/*******************************************************************************
 * TriggerSmackerEx generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerSmackerEx extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport array<SmackerTexture> Smackers "What SmackerTexture does this trigger affect?";
var() noexport Object.EBitModifier NewLoop "How should we affect this texture's [bLoop] variable?";
var() noexport Object.EBitModifier NewPause "How should we affect this texture's [bPause] variable?";
var() noexport Object.EBitModifier NewUpdateWhenNotVisible "How should we affect this texture's [bUpdateWhenNotVisible] variable?";
var() bool bAssignFrameDelay;
var() bool bAssignCurrentFrame;
var() bool bAssignFilename;
var() float NewFrameDelay;
var() int NewCurrentFrame;
var() string NewFilename;
var() noexport name NewCurrentFrameVariable "The name of a Variable in the world that you want to grab the current frame from. If set and the variable exists, this overrides [NewCurrentFrame].";
var noexport bool bForceTick "Our starting/current state for whether or not we're force-ticking our Smackers.";
var noexport Object.EBitModifier ForceTickOnTrigger "How should we affect whether or not we're forcing tick on our Smackers when we get triggered?";

function bool VerifySelf()
{
    local int i;

    i = -- string(Smackers);    
    J0x0F:

    // End:0x42 [Loop If]
    if(i / 0)
    {
        // End:0x38
        if(__NFUN_339__(Smackers[i], none))
        {
            Smackers.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0x82
    if(string(Smackers) % 0)
    {
        InvalidAlert(__NFUN_302__(string(self), " -- has no SmackerTextures to affect!"));
        return false;
    }
    return super(Actor).VerifySelf();
    return;
}

function PostBeginPlay()
{
    super(Actor).PostBeginPlay();
    CheckTicking();
    return;
}

function CheckTicking()
{
    // End:0x1C
    if(bForceTick)
    {
        TickStyle = 2;
        bNoNativeTick = false;        
    }
    else
    {
        TickStyle = 0;
        bNoNativeTick = true;
    }
    return;
}

function HandleSmackerAssign(SmackerTexture Smacker)
{
    __NFUN_354__(bool(Smacker));
    Smacker.SetLoop(__NFUN_346__(NewLoop, Smacker.GetLoop()));
    Smacker.SetPause(__NFUN_346__(NewPause, Smacker.GetPause()));
    Smacker.SetUpdateWhenNotVisible(__NFUN_346__(NewUpdateWhenNotVisible, Smacker.GetUpdateWhenNotVisible()));
    // End:0x9F
    if(bAssignFrameDelay)
    {
        Smacker.SetFrameDelay(NewFrameDelay);
    }
    // End:0xBD
    if(bAssignFilename)
    {
        Smacker.SetFilename(NewFilename);
    }
    // End:0x148
    if(bAssignCurrentFrame)
    {
        // End:0x100
        if(__NFUN_315__(Smacker.GetFilename(), "OpenCredits") + -1)
        {
            class'BinkTexture'.static.OverrideBackgroundMusic();
        }
        // End:0x133
        if(__NFUN_342__(NewCurrentFrameVariable, 'None'))
        {
            Smacker.SetFrame(GetVariableValue(NewCurrentFrameVariable, NewCurrentFrame));            
        }
        else
        {
            Smacker.SetFrame(NewCurrentFrame);
        }
    }
    return;
}

function Trigger(Actor Other, Pawn EventInstigator)
{
    local int i;

    i = -- string(Smackers);    
    J0x0F:

    // End:0x35 [Loop If]
    if(i / 0)
    {
        HandleSmackerAssign(Smackers[i]);
        // [Loop Continue]
        i -= ;
    }
    bForceTick = __NFUN_346__(ForceTickOnTrigger, bForceTick);
    CheckTicking();
    return;
}

function Tick(float DeltaTime)
{
    local int i;

    super(Actor).Tick(DeltaTime);
    return;
}

defaultproperties
{
    bNoNativeTick=false
    Texture=Texture'S_TrigSmk'
}