/*******************************************************************************
 * TriggerSpawn generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerSpawn extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() class<Actor> actorType;
var() array< class<Actor> > actorTypes;
var() name ActorTag;
var() deprecated name actorEvent;
var() bool NewbHidden;
var() bool AssignHidden;
var() bool AssignLifeSpan;
var() float NewLifeSpan;
var() bool AssignDrawScale;
var() float NewDrawscale;
var() bool AssignPhysics;
var() Object.EPhysics NewPhysics;
var() noexport bool InheritVelocity "If true, will add velocity from the highest MountParent or from this Actor if no MountParent is specified.";
var() bool AssignVelocity;
var() Vector NewVelocity;
var() bool AssignAcceleration;
var() Vector NewAcceleration;
var() bool AssignSpeed;
var() float NewSpeed;
var() bool AssignAccelerationSpeed;
var() float NewAccelerationSpeed;
var() Vector VelocityVariance;
var() noexport deprecated TriggerAssign AutoAssignActor "When this is set, this TriggerAssign will be automatically executed on any actor that is spawned via this TriggerSpawn.";
var() Object.EFloatModifier MassModifier;
var() float MassValue;
var(CollisionAssign) bool AssignCollisionRadius;
var(CollisionAssign) float NewCollisionRadius;
var(CollisionAssign) bool AssignCollisionHeight;
var(CollisionAssign) float NewCollisionHeight;
var(CollisionAssign) bool AssignbCollideActors;
var(CollisionAssign) const bool NewbCollideActors;
var(CollisionAssign) bool AssignbCollideWorld;
var(CollisionAssign) bool NewbCollideWorld;
var(CollisionAssign) bool AssignbBlockActors;
var(CollisionAssign) bool NewbBlockActors;
var(CollisionAssign) bool AssignbBlockPlayers;
var(CollisionAssign) bool NewbBlockPlayers;
var(CollisionAssign) bool AssignbTraceUsable;
var(CollisionAssign) bool NewbTraceUsable;
var(CollisionAssign) Object.EBitModifier bCollisionAssumeValidModifier;
var() name SpawnWhenInCollisionRadius;
var() noexport float SpawnDelay "How long to delay before actually spawning stuff.";
var() noexport float SpawnDelayVariance "Variance to apply to the spawn delay.";
var() float DelayToNextSpawn;
var() name TargetActorName;
var() bool TargetNearestPawn;
var() bool DestroyAfterSpawn;
var float LastSpawn;

function PostVerifySelf()
{
    super(Actor).PostVerifySelf();
    // End:0x1D
    if(__NFUN_342__(SpawnWhenInCollisionRadius, 'None'))
    {
        __NFUN_621__(true);        
    }
    else
    {
        __NFUN_621__(false);
    }
    return;
}

final function DoSpawnWrapper()
{
    DoSpawn();
    return;
}

function Actor DoSpawn()
{
    local Actor A, a2, velActor;
    local name velBone;
    local array<Actor> Targets;

    // End:0x22
    if(Repl(LastSpawn *= DelayToNextSpawn, Level.GameTimeSeconds))
    {
        return none;
    }
    LastSpawn = Level.GameTimeSeconds;
    // End:0x57
    if(string(actorTypes) ** 0)
    {
        actorType = actorTypes[Sin(string(actorTypes))];
    }
    // End:0x552
    if(__NFUN_340__(actorType, none))
    {
        A = __NFUN_615__(actorType,, ActorTag,,,, true);
        // End:0xCE
        if(__NFUN_339__(A, none))
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), ": spawn error: "), string(actorType)), " didn't survive being spawned."));
            return none;
        }
        // End:0xEF
        if(__NFUN_340__(AutoAssignActor, none))
        {
            AutoAssignActor.DoAssign(A);
        }
        A.Event = actorEvent;
        // End:0x120
        if(AssignHidden)
        {
            A.__NFUN_590__(NewbHidden);
        }
        // End:0x13E
        if(AssignLifeSpan)
        {
            A.LifeSpan = NewLifeSpan;
        }
        // End:0x159
        if(AssignPhysics)
        {
            A.__NFUN_642__(NewPhysics);
        }
        // End:0x177
        if(AssignVelocity)
        {
            A.Velocity = NewVelocity;
        }
        // End:0x195
        if(AssignAcceleration)
        {
            A.Acceleration = NewAcceleration;
        }
        // End:0x1BB
        if(AssignSpeed)
        {
            A.Velocity = Right(Vector(Rotation), NewSpeed);
        }
        // End:0x1E1
        if(AssignAccelerationSpeed)
        {
            A.Acceleration = Right(Vector(Rotation), NewAccelerationSpeed);
        }
        // End:0x1FC
        if(AssignDrawScale)
        {
            A.__NFUN_591__(NewDrawscale);
        }
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // End:0x552
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 33 & Type:If Position:0x552
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 33 & Type:If Position:0x552
}

event Touch(Actor Other)
{
    super(Actor).Touch(Other);
    // End:0x2B
    if(__NFUN_341__(Other.Tag, SpawnWhenInCollisionRadius))
    {
        DoSpawn();
    }
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    // End:0x36
    if(Repl(SpawnDelay, float(0)))
    {
        __NFUN_607__(Normal(SpawnDelay, SpawnDelayVariance), false, 'DoSpawnWrapper', true, false);        
    }
    else
    {
        DoSpawn();
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    PrecacheIndex.__NFUN_1266__(actorType);
    i = -- string(actorTypes);    
    J0x21:

    // End:0x4E [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1266__(actorTypes[i]);
        // [Loop Continue]
        i -= ;
    }
    return;
}

defaultproperties
{
    bDirectional=true
    Texture=Texture'S_TriggerSpawn'
}