/*******************************************************************************
 * TriggerSpawnKarma generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerSpawnKarma extends TriggerSpawn
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() bool bForceWake;
var() bool bAssignLinearVelocity;
var() bool bAssignAngularVelocity;
var() bool bAssignPhysicsEntityGroup;
var() noexport bool bLinearVelocityRelativeToRotation "Linear velocity will be applied relative to this Actor's rotation.";
var() Vector NewLinearVelocity;
var() Vector NewAngularVelocity;
var() name NewPhysicsEntityGroup;
var() Vector NewLinearVelocity_Variance;
var() Vector NewAngularVelocity_Variance;

function Actor DoSpawn()
{
    local Actor ret;
    local KarmaActor K;
    local Vector LinVel;

    ret = super.DoSpawn();
    K = KarmaActor(ret);
    // End:0x2E
    if(__NFUN_339__(K, none))
    {
        return ret;
    }
    // End:0x78
    if(bAssignLinearVelocity)
    {
        LinVel = Sleep(NewLinearVelocity, NewLinearVelocity_Variance);
        // End:0x66
        if(bLinearVelocityRelativeToRotation)
        {
            LinVel = __NFUN_263__(LinVel, Rotation);
        }
        K.__NFUN_790__(LinVel);
    }
    // End:0x9B
    if(bAssignAngularVelocity)
    {
        K.__NFUN_791__(Sleep(NewAngularVelocity, NewAngularVelocity_Variance));
    }
    // End:0xB6
    if(bAssignPhysicsEntityGroup)
    {
        K.__NFUN_816__(NewPhysicsEntityGroup);
    }
    // End:0xCC
    if(bForceWake)
    {
        K.__NFUN_817__();
    }
    return;
}

defaultproperties
{
    bForceWake=true
}