/*******************************************************************************
 * UdpBeaconSystemLink generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UdpBeaconSystemLink extends UdpLink
    transient
    native
    collapsecategories
    notplaceable
    hidecategories(movement,Collision,Lighting,LightColor);

var() int ServerBeaconPort;

// Export UUdpBeaconSystemLink::execBroadcastBeacon(FFrame&, void* const)
native function BroadcastBeacon(IpAddr Addr, int Nonce);

function BeginPlay()
{
    local IpAddr Addr;
    local int boundport;

    boundport = __NFUN_1135__(ServerBeaconPort, true);
    // End:0x4E
    if(boundport % 0)
    {
        __NFUN_355__("UdpBeaconSystemLink failed to bind a port.");
        return;        
    }
    else
    {
        __NFUN_355__(__NFUN_303__("UdpBeaconSystemLink bound to port", string(boundport)));
    }
    return;
}

event ReceivedText(IpAddr Addr, string Text)
{
    local int n, Nonce;

    n = __NFUN_314__("REPORT");
    // End:0x67
    if(__NFUN_310__(Text - ++ n))
    {
        "REPORT "        
        Addr.Addr = BroadcastAddr;
        Nonce = int(Text + ++ n);        
        BroadcastBeacon(Addr, Nonce);
    }
    return;
}

defaultproperties
{
    ServerBeaconPort=1001
}