/*******************************************************************************
 * Variable generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Variable extends Triggers
    collapsecategories
    notplaceable
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

enum EVariableTriggerType
{
    VT_None,
    VT_Equal,
    VT_Greater,
    VT_GreaterOrEqual,
    VT_Less,
    VT_LessOrEqual,
    VT_NotEqual,
    VT_Range
};

var() noexport bool OnlyTestOnTrigger "Only compare on trigger, (ignore when variable is set)";
var() noexport bool PrintValue "Prints the value when it is modified. (For debugging)";
var() noexport int Value "Current value of the variable.";
var() noexport name ValueVariable "Actor Variable to get value from when not ''";
var() noexport int ComparisonValue "Value to compare current value to.";
var() noexport name ComparisonValueVariable "Actor Variable to get comparison value from.";
var() noexport int OtherComparisonValue "Other value to compare to. (For types that take more than one parameter)";
var() noexport deprecated name FailedEvent "Event to trigger when a comparison fails.";
var() noexport Variable.EVariableTriggerType VariableTriggerType "Type of checking to do on the variable vs Comparison value that will result in firing off our Event.";
var(VariableStorage) noexport float StorageValue "Value used simply to store a float for reference later. Can be modified via VariableModify. Does not cause any triggering to occur.";

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(Actor).Trigger(Other, EventInstigator);
    Instigator = EventInstigator;
    PerformTest();
    return;
}

final function PerformTest()
{
    // End:0x10
    if(int(VariableTriggerType) % int(0))
    {
        return;
    }
    // End:0x2C
    if(TestValue())
    {
        GlobalTrigger(Event, Instigator);        
    }
    else
    {
        GlobalTrigger(FailedEvent, Instigator);
    }
    return;
}

final function bool TestValue()
{
    Value = GetVariableValue(ValueVariable, Value);
    ComparisonValue = GetVariableValue(ComparisonValueVariable, ComparisonValue);
    switch(VariableTriggerType)
    {
        // End:0x3B
        case 0:
            return false;
        // End:0x4D
        case 1:
            return Value % ComparisonValue;
        // End:0x5F
        case 2:
            return Value ** ComparisonValue;
        // End:0x71
        case 3:
            return Value / ComparisonValue;
        // End:0x83
        case 4:
            return -Value;            
        // End:0x95
        case 5:
            return Value * ComparisonValue;
        // End:0xA7
        case 6:
            return Value + ComparisonValue;
        // End:0xCA
        case 7:
            return (ComparisonValue * Value) << Value * OtherComparisonValue;
        // End:0xFFFF
        default:
            return;
            break;
    }
}

final function int GetValue()
{
    return GetVariableValue(ValueVariable, Value);
    return;
}

final function SetValue(int NewValue)
{
    Value = NewValue;
    // End:0x35
    if(PrintValue)
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__(string(Tag), " Value="), string(Value)));
    }
    // End:0x46
    if(OnlyTestOnTrigger / )
    {
    }
    return;
}

final function float GetStorageValue()
{
    return StorageValue;
    return;
}

final function SetStorageValue(float NewStorageValue)
{
    StorageValue = NewStorageValue;
    // End:0x3C
    if(PrintValue)
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__(string(Tag), " StorageValue="), string(StorageValue)));
    }
    return;
}

defaultproperties
{
    Texture=Texture'S_Variable'
}