/*******************************************************************************
 * UdpServerUplink generated by Eliot.UELib using UELib.CLI.
 * Eliot.UELib © 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UdpServerUplink extends UdpLink
	transient
	config
	collapsecategories
	hidecategories(movement,Collision,Lighting,LightColor);

var() config bool DoUplink;
var() config int UpdateMinutes;
var() config string MasterServerAddress;
var() config int MasterServerPort;
var() config int ServerRegion;
var() name TargetQueryName;
var IpAddr MasterServerIpAddr;
var string HeartbeatMessage;
var UdpServerQuery Query;
var int CurrentQueryNum;

function PreBeginPlay()
{
	// End:0x48
	if(__NFUN_145__(DoUplink))
	{
		__NFUN_355__("DoUplink is not set.  Not connecting to Master Server.");
		return;
	}
	// End:0x61
	foreach __NFUN_747__(class'UdpServerQuery', Query, TargetQueryName)
	{
		// End:0x61
		break;		
	}	
	// End:0xB7
	if(__NFUN_339__(Query, none))
	{
		__NFUN_355__("UdpServerUplink: Could not find a UdpServerQuery object, aborting.");
		return;
	}
	HeartbeatMessage = __NFUN_302__(__NFUN_302__(__NFUN_302__("\\heartbeat\\", string(Query.Port)), "\\gamename\\"), Query.GameName);
	MasterServerIpAddr.Port = MasterServerPort;
	// End:0x143
	if(__NFUN_308__(MasterServerAddress, ""))
	{
		MasterServerAddress = __NFUN_302__(__NFUN_302__("master", string(ServerRegion)), ".gamespy.com");
	}
	__NFUN_1129__(MasterServerAddress);
	return;
}

function Resolved(IpAddr Addr)
{
	local bool Result;
	local int UplinkPort;

	MasterServerIpAddr.Addr = Addr.Addr;
	// End:0x65
	if(__NFUN_173__(MasterServerIpAddr.Addr, 0))
	{
		__NFUN_355__("UdpServerUplink: Invalid master server address, aborting.");
		return;
	}
	__NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__("UdpServerUplink: Master Server is ", MasterServerAddress), ":"), string(MasterServerIpAddr.Port)));
	UplinkPort = __NFUN_165__(Query.Port, 1);
	// End:0x104
	if(__NFUN_173__(__NFUN_1135__(UplinkPort, true), 0))
	{
		__NFUN_355__("UdpServerUplink: Error binding port, aborting.");
		return;
	}
	__NFUN_355__(__NFUN_302__(__NFUN_302__("UdpServerUplink: Port ", string(UplinkPort)), " successfully bound."));
	Resume();
	return;
}

function ResolveFailed()
{
	__NFUN_355__("UdpServerUplink: Failed to resolve master server address, aborting.");
	return;
}

function HeartbeatTimer()
{
	local bool Result;

	Result = __NFUN_1136__(MasterServerIpAddr, HeartbeatMessage);
	// End:0x4E
	if(__NFUN_145__(Result))
	{
		__NFUN_355__("Failed to send heartbeat to master server.");
	}
	return;
}

function halt()
{
	__NFUN_606__('HeartbeatTimer');
	return;
}

function Resume()
{
	__NFUN_605__(float(__NFUN_162__(UpdateMinutes, 60)), true, 'HeartbeatTimer');
	HeartbeatTimer();
	return;
}

event ReceivedText(IpAddr Addr, string Text)
{
	local string Query;
	local bool QueryRemaining;
	local int QueryNum, PacketNum;

	__NFUN_184__(CurrentQueryNum);
	// End:0x1A
	if(__NFUN_170__(CurrentQueryNum, 100))
	{
		CurrentQueryNum = 1;
	}
	QueryNum = CurrentQueryNum;
	Query = Text;
	// End:0x48
	if(__NFUN_308__(Query, ""))
	{
		QueryRemaining = false;		
	}
	else
	{
		QueryRemaining = true;
	}
	J0x50:

	// End:0x9C [Loop If]
	if(QueryRemaining)
	{
		Query = ParseQuery(Addr, Query, QueryNum, PacketNum);
		// End:0x91
		if(__NFUN_308__(Query, ""))
		{
			QueryRemaining = false;			
		}
		else
		{
			QueryRemaining = true;
		}
		// [Loop Continue]
		goto J0x50;
	}
	return;
}

function bool ParseNextQuery(string Query, out string QueryType, out string QueryValue, out string QueryRest, out string FinalPacket)
{
	local string TempQuery;
	local int ClosingSlash;

	// End:0x0F
	if(__NFUN_308__(Query, ""))
	{
		return false;
	}
	// End:0x17A
	if(__NFUN_308__(__NFUN_317__(Query, 1), "\\"))
	{
		ClosingSlash = __NFUN_315__(__NFUN_318__(Query, __NFUN_166__(__NFUN_314__(Query), 1)), "\\");
		// End:0x4D
		if(__NFUN_173__(ClosingSlash, 0))
		{
			return false;
		}
		TempQuery = Query;
		QueryType = __NFUN_318__(Query, __NFUN_166__(__NFUN_314__(Query), 1));
		QueryType = __NFUN_317__(QueryType, ClosingSlash);
		QueryRest = __NFUN_318__(Query, __NFUN_166__(__NFUN_314__(Query), __NFUN_165__(__NFUN_314__(QueryType), 2)));
		// End:0xD7
		if(__NFUN_150__(__NFUN_308__(QueryRest, ""), __NFUN_173__(__NFUN_314__(QueryRest), 1)))
		{
			FinalPacket = "final";
			return true;			
		}
		else
		{
			// End:0xEB
			if(__NFUN_308__(__NFUN_317__(QueryRest, 1), "\\"))
			{
				return true;
			}
		}
		ClosingSlash = __NFUN_315__(QueryRest, "\\");
		// End:0x11D
		if(__NFUN_172__(ClosingSlash, 0))
		{
			QueryValue = __NFUN_317__(QueryRest, ClosingSlash);			
		}
		else
		{
			QueryValue = QueryRest;
		}
		QueryRest = __NFUN_318__(Query, __NFUN_166__(__NFUN_314__(Query), __NFUN_165__(__NFUN_165__(__NFUN_314__(QueryType), __NFUN_314__(QueryValue)), 3)));
		// End:0x175
		if(__NFUN_308__(QueryRest, ""))
		{
			FinalPacket = "final";
			return true;			
		}
		else
		{
			return true;
		}		
	}
	else
	{
		return false;
	}
	return;
}

function string ParseQuery(IpAddr Addr, coerce string QueryStr, int QueryNum, out int PacketNum)
{
	local string QueryType, QueryValue, QueryRest, ValidationString;
	local bool Result;
	local string FinalPacket;

	Result = ParseNextQuery(QueryStr, QueryType, QueryValue, QueryRest, FinalPacket);
	// End:0x34
	if(__NFUN_145__(Result))
	{
		return "";
	}
	// End:0x51
	if(__NFUN_308__(QueryType, "basic"))
	{
		Result = true;		
	}
	else
	{
		// End:0xBB
		if(__NFUN_308__(QueryType, "secure"))
		{
			ValidationString = __NFUN_302__("\\validate\\", __NFUN_1133__(QueryValue, Query.GameName));
			Result = SendQueryPacket(Addr, ValidationString, QueryNum, __NFUN_182__(PacketNum), FinalPacket);			
		}
		else
		{
			__NFUN_355__(__NFUN_302__("UdpServerQuery: Unknown query: ", QueryType));
		}
	}
	// End:0x121
	if(__NFUN_145__(Result))
	{
		__NFUN_355__("UdpServerQuery: Error responding to query.");
	}
	return QueryRest;
	return;
}

function bool SendQueryPacket(IpAddr Addr, coerce string SendString, int QueryNum, int PacketNum, string FinalPacket)
{
	local bool Result;

	// End:0x29
	if(__NFUN_308__(FinalPacket, "final"))
	{
		SendString = __NFUN_302__(SendString, "\\final\\");
	}
	SendString = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(SendString, "\\queryid\\"), string(QueryNum)), "."), string(PacketNum));
	Result = __NFUN_1136__(Addr, SendString);
	return Result;
	return;
}

defaultproperties
{
	DoUplink=true
	UpdateMinutes=1
	MasterServerAddress="dnf.3drealms.com"
	MasterServerPort=27900
	TargetQueryName=MasterUplink
}