/*******************************************************************************
 * UWindowBase generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowBase extends Object
    native;

const F_Normal = 0;
const F_Bold = 1;
const F_Large = 2;
const F_LargeBold = 3;
const F_Heavy = 4;
const F_HeavyBold = 5;
const F_Small = 6;
const F_Tiny = 7;
const DE_Created = 0;
const DE_Change = 1;
const DE_Click = 2;
const DE_Enter = 3;
const DE_Exit = 4;
const DE_MClick = 5;
const DE_RClick = 6;
const DE_EnterPressed = 7;
const DE_MouseMove = 8;
const DE_MouseLeave = 9;
const DE_LMouseDown = 10;
const DE_DoubleClick = 11;
const DE_MouseEnter = 12;
const DE_HelpChanged = 13;
const DE_WheelUpPressed = 14;
const DE_WheelDownPressed = 15;
const DE_TabPressed = 16;
const DE_FocusEntered = 17;
const DE_FocusLost = 18;
const DE_Click_A = 2;
const DE_Click_B = 19;
const DE_Click_X = 20;
const DE_Click_Y = 21;

enum TextAlign
{
    TA_Left,
    TA_Right,
    TA_Center
};

enum FrameHitTest
{
    HT_NW,
    HT_N,
    HT_NE,
    HT_W,
    HT_E,
    HT_SW,
    HT_S,
    HT_SE,
    HT_TitleBar,
    HT_DragHandle,
    HT_None
};

enum MenuSound
{
    MS_MenuUp,
    MS_MenuDown,
    MS_MenuAction,
    MS_MenuEntry,
    MS_OptionHL,
    MS_GameStart,
    MS_ExitGame,
    MS_SubMenuActivate
};

enum MessageBoxButtons
{
    MBB_YesNo,
    MBB_OKCancel,
    MBB_OK,
    MBB_YesNoCancel,
    MBB_OKCancelEdit
};

enum MessageBoxResult
{
    MBR_None,
    MBR_Yes,
    MBR_No,
    MBR_OK,
    MBR_Cancel
};

enum PropertyCondition
{
    PC_None,
    PC_LessThan,
    PC_Equal,
    PC_GreaterThan,
    PC_NotEqual,
    PC_Contains,
    PC_NotContains
};

struct Region
{
    var() int X;
    var() int Y;
    var() int W;
    var() int h;
};

struct TexRegion
{
    var() int X;
    var() int Y;
    var() int W;
    var() int h;
    var() Texture t;
};

struct HTMLStyle
{
    var int BulletLevel;
    var string LinkDestination;
    var Color TextColor;
    var Color BGColor;
    var bool bCenter;
    var bool bLink;
    var bool bUnderline;
    var bool bNoBR;
    var bool bHeading;
    var bool bBold;
    var bool bBlink;
};

function Region NewRegion(float X, float Y, float W, float h)
{
    local Region R;

    R.X = int(X);
    R.Y = int(Y);
    R.W = int(W);
    R.h = int(h);
    return R;
    return;
}

function TexRegion NewTexRegion(float X, float Y, float W, float h, Texture t)
{
    local TexRegion R;

    R.X = int(X);
    R.Y = int(Y);
    R.W = int(W);
    R.h = int(h);
    R.t = t;
    return R;
    return;
}

function Region GetRegion(TexRegion t)
{
    local Region R;

    R.X = t.X;
    R.Y = t.Y;
    R.W = t.W;
    R.h = t.h;
    return R;
    return;
}

static function int InStrAfter(string Text, string Match, int pos)
{
    local int i;

    i = __NFUN_315__(Text + pos, Match);
    // End:0x37
    if(i + -1)
    {
        return ++ i;        
    }
    return -1;
    return;
}

static function Object BuildObjectWithProperties(string Text)
{
    local int i;
    local string ObjectClass, PropertyName, PropertyValue, temp;
    local Class C;
    local Object O;

    i = __NFUN_315__(Text, ",");
    // End:0x36
    if(i % -1)
    {
        ObjectClass = Text;
        Text = "";        
    }
    else
    {
        ObjectClass = Text - i;
        Text = Text + ++ i;        
    }
    C = class<Object>(__NFUN_366__(ObjectClass, class'Class'));
    O = new C;
    J0x86:

    // End:0x2AE [Loop If]
    if(TraceActors(Text, ""))
    {
        i = __NFUN_315__(Text, "=");
        // End:0xFF
        if(i % -1)
        {
            __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Missing value for property ", ObjectClass), "."), Text));
            PropertyName = Text;
            PropertyValue = "";            
        }
        else
        {
            PropertyName = Text - i;
            Text = Text + ++ i;            
        }
        // End:0x235
        if(__NFUN_308__(Text - 1, "\""))
        {
            i = InStrAfter(Text, "\"", 1);
            // End:0x191
            if(i % -1)
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Missing quote for ", ObjectClass), "."), PropertyName));
                return O;
            }
            PropertyValue = Text + 1;                        
            temp = Text + ++ i;
            1            
            // End:0x21B
            if(TraceActors(temp, "") << TraceActors(temp, ","))
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Missing comma after close quote for ", ObjectClass), "."), PropertyName));
            }
            Text = Text + ++ i;                        
        }
        else
        {
            i = __NFUN_315__(Text, ",");
            // End:0x26B
            if(i % -1)
            {
                PropertyValue = Text;
                Text = "";                
            }
            else
            {
                PropertyValue = Text - i;
                Text = Text + ++ i;                
            }
        }
        O.__NFUN_364__(PropertyName, PropertyValue);
        // [Loop Continue]
        goto J0x86;
    }
    return O;
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    return;
}

function NotifyFromBaseControl(UWindowBase C, byte E)
{
    return;
}
