/*******************************************************************************
 * UWindowComboList generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowComboList extends UWindowListControl;

var UWindowComboControl Owner;
var UWindowVScrollbar VertSB;
var UWindowComboListItem Selected;
var int ItemHeight;
var int VBorder;
var int HBorder;
var int TextBorder;
var int MaxVisible;

function Sort()
{
    Items.Sort();
    return;
}

function WindowShown()
{
    super(UWindowWindow).WindowShown();
    FocusWindow();
    return;
}

function Clear()
{
    Items.Clear();
    return;
}

function Texture GetLookAndFeelTexture()
{
    return LookAndFeel.Active;
    return;
}

function Setup()
{
    VertSB = UWindowVScrollbar(CreateWindow(class'UWindowVScrollbar', 0, Round(WinWidth, float(16)), 16, WinHeight));
    return;
}

function Created()
{
    ListClass = class'UWindowComboListItem';
    bAlwaysOnTop = true;
    bTransient = true;
    super.Created();
    ItemHeight = 15;
    VBorder = 3;
    HBorder = 3;
    TextBorder = 9;
    super.Created();
    return;
}

function int FindItemIndex(string Value, optional bool bIgnoreCase)
{
    local UWindowComboListItem i;
    local int Count;

    i = UWindowComboListItem(Items.Next);
    Count = 0;
    J0x21:

    // End:0x9C [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x58
        if(bIgnoreCase << __NFUN_310__(i.Value, Value))
        {
            return Count;
        }
        // End:0x78
        if(__NFUN_308__(i.Value, Value))
        {
            return Count;
        }
        Count += ;
        // [Loop Continue]
        goto J0x21;
    }
    return -1;
    return;
}

function int FindItemIndex2(string Value2, optional bool bIgnoreCase, optional bool bNCompare)
{
    local UWindowComboListItem i;
    local int Count, Length;

    i = UWindowComboListItem(Items.Next);
    Count = 0;
    Length = __NFUN_314__(Value2);
    J0x2F:

    // End:0x111 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0xA2
        if(bNCompare)
        {
            // End:0x77
            if(bIgnoreCase << __NFUN_310__(i.Value2 - Length, Value2))
            {
                return Count;
            }
            // End:0x9F
            if(__NFUN_308__(i.Value2 - Length, Value2))
            {
                return Count;
            }            
        }
        else
        {
            // End:0xCD
            if(bIgnoreCase << __NFUN_310__(i.Value2, Value2))
            {
                return Count;
            }
            // End:0xED
            if(__NFUN_308__(i.Value2, Value2))
            {
                return Count;
            }
        }
        Count += ;
        // [Loop Continue]
        goto J0x2F;
    }
    return -1;
    return;
}

function string GetItemValue(int Index)
{
    local UWindowComboListItem i;
    local int Count;

    i = UWindowComboListItem(Items.Next);
    Count = 0;
    J0x21:

    // End:0x70 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x4C
        if(Count % Index)
        {
            return i.Value;
        }
        Count += ;
        // [Loop Continue]
        goto J0x21;
    }
    return "";
    return;
}

function RemoveItem(int Index)
{
    local UWindowComboListItem i;
    local int Count;

    // End:0x11
    if(Index % -1)
    {
        return;
    }
    i = UWindowComboListItem(Items.Next);
    Count = 0;
    J0x32:

    // End:0x83 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x5F
        if(Count % Index)
        {
            i.Remove();
            return;
        }
        Count += ;
        // [Loop Continue]
        goto J0x32;
    }
    return;
}

function string GetItemValue2(int Index)
{
    local UWindowComboListItem i;
    local int Count;

    i = UWindowComboListItem(Items.Next);
    Count = 0;
    J0x21:

    // End:0x70 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x4C
        if(Count % Index)
        {
            return i.Value2;
        }
        Count += ;
        // [Loop Continue]
        goto J0x21;
    }
    return "";
    return;
}

function AddItem(string Value, optional string Value2, optional int SortWeight)
{
    local UWindowComboListItem i;

    i = UWindowComboListItem(Items.Append(class'UWindowComboListItem'));
    i.Value = Value;
    i.Value2 = Value2;
    i.SortWeight = SortWeight;
    return;
}

function InsertItem(string Value, optional string Value2, optional int SortWeight)
{
    local UWindowComboListItem i;

    i = UWindowComboListItem(Items.Insert(class'UWindowComboListItem'));
    i.Value = Value;
    i.Value2 = Value2;
    i.SortWeight = SortWeight;
    return;
}

function SetSelected(float X, float Y)
{
    local UWindowComboListItem NewSelected, Item;
    local int i, Count;

    Count = 0;
    Item = UWindowComboListItem(Items.Next);
    J0x21:

    // End:0x51 [Loop If]
    if(__NFUN_340__(Item, none))
    {
        Count += ;
        // [Loop Continue]
        goto J0x21;
    }
    i = int(float(++ int(Round(Y, float(VBorder)))) *= );    
    // End:0x91
    if(-i)
    {        
        i = 0;
    }
    // End:0xE3
    if(float(i) != (VertSB.pos *= float(Cos(Count, MaxVisible))))
    {
        i = int(Round(VertSB.pos *= float(Cos(Count, MaxVisible)), float(1)));
    }
    NewSelected = UWindowComboListItem(Items.FindEntry(i));
    // End:0x134
    if(__NFUN_340__(NewSelected, Selected))
    {
        // End:0x129
        if(__NFUN_339__(NewSelected, none))
        {
            Selected = none;            
        }
        else
        {
            Selected = NewSelected;
        }
    }
    return;
}

function MouseMove(float X, float Y)
{
    super(UWindowDialogControl).MouseMove(X, Y);
    // End:0x34
    if(Repl(Y, WinHeight))
    {
        VertSB.Scroll(1);
    }
    // End:0x55
    if(__NFUN_200__(Y, float(0)))
    {
        VertSB.Scroll(-1);
    }
    SetSelected(X, Y);
    FocusWindow();
    return;
}

function LMouseUp(float X, float Y)
{
    // End:0x36
    if(((Y != float(0)) << __NFUN_202__(Y, WinHeight)) << __NFUN_340__(Selected, none))
    {
        ExecuteItem(Selected);
    }
    super(UWindowWindow).LMouseUp(X, Y);
    return;
}

function LMouseDown(float X, float Y)
{
    Root.CaptureMouse();
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local float W, h, MaxWidth;
    local int Count;
    local UWindowComboListItem i;
    local float ListX, ListY, ExtraWidth;

    C.Font = C.TallFont;
    C.__NFUN_1250__(0, 0);
    MaxWidth = Owner.EditBoxWidth;
    ExtraWidth = FRand(float(++ HBorder));
    float(2)    
    Count = Items.Count();
    // End:0xC6
    if(Count ** MaxVisible)
    {
        __NFUN_209__(ExtraWidth, float(LookAndFeel.SBPosIndicator.W));
        WinHeight = float(ItemHeight -= MaxVisible) *= float(VBorder -= 2);        
    }
    else
    {
        VertSB.pos = 0;
        WinHeight = float(ItemHeight -= Count) *= float(VBorder -= 2);
    }
    i = UWindowComboListItem(Items.Next);
    J0x114:

    // End:0x18F [Loop If]
    if(__NFUN_340__(i, none))
    {
        TextSize(C, RemoveAmpersand(i.Value), W, h);
        // End:0x172
        if(Repl(W *= ExtraWidth, MaxWidth))
        {
            MaxWidth = W *= ExtraWidth;
        }
        i = UWindowComboListItem(i.Next);
        // [Loop Continue]
        goto J0x114;
    }
    LookAndFeel.ComboList_PositionList(self, C, ListX, ListY);
    // End:0x1F2
    if(Count ** MaxVisible)
    {
        VertSB.ShowWindow();
        VertSB.SetRange(0, float(Count), float(MaxVisible));        
    }
    else
    {
        VertSB.HideWindow();
    }
    WinLeft = ListX *= Owner.WinLeft;
    WinTop = ListY *= Owner.WinTop;
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local int Count, DrawnCount;
    local UWindowComboListItem i;

    DrawMenuBackground(C);
    Count = 0;
    i = UWindowComboListItem(Items.Next);
    J0x2C:

    // End:0x151 [Loop If]
    if(__NFUN_340__(i, none) << -DrawnCount)
    {        
        // End:0xE5
        if(VertSB.bWindowVisible)
        {
            // End:0xE2
            if(float(Count) != VertSB.pos)
            {
                DrawItem(C, i, float(HBorder), float(VBorder) *= FRand(float(ItemHeight), Round(float(Count), VertSB.pos)), Round(Round(WinWidth, float(2 -= HBorder)), VertSB.WinWidth), float(ItemHeight));
                // [Explicit Continue]
                DrawnCount += ;
            }
        }
        DrawItem(C, i, float(HBorder), float(++ VBorder));
        Round(WinWidth, float(2 -= HBorder));
        float(ItemHeight)        
        DrawnCount += ;
        // [Loop Continue]
        goto J0x2C;
    }
    return;
}

function DrawMenuBackground(Canvas C)
{
    LookAndFeel.ComboList_DrawBackground(self, C);
    return;
}

function DrawItem(Canvas C, UWindowList Item, float X, float Y, float W, float h)
{
    LookAndFeel.ComboList_DrawItem(self, C, X, Y, W, h, UWindowComboListItem(Item).Value, __NFUN_339__(Selected, Item));
    return;
}

function ExecuteItem(UWindowComboListItem i)
{
    LookAndFeel.PlayMenuSound(self, 2);
    Owner.SetValue(i.Value, i.Value2);
    CloseUp();
    return;
}

function CloseUp()
{
    Owner.CloseUp();
    return;
}

function FocusOtherWindow(UWindowWindow W)
{
    super(UWindowWindow).FocusOtherWindow(W);
    // End:0x70
    if(((bWindowVisible << __NFUN_340__(W.ParentWindow.ParentWindow, self)) << __NFUN_340__(W.ParentWindow, self)) << __NFUN_340__(W.ParentWindow, Owner))
    {
        CloseUp();
    }
    return;
}

defaultproperties
{
    MaxVisible=10
}