/*******************************************************************************
 * UWindowConsoleClientWindow generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowConsoleClientWindow extends UWindowDialogClientWindow
    dependson(UWindowConsoleTextAreaControl)
    dependson(WindowConsole);

var UWindowConsoleTextAreaControl TextArea;
var UWindowEditControl EditControl;
var class<UWindowEditControl> EditControlClass;

function Created()
{
    TextArea = UWindowConsoleTextAreaControl(CreateWindow(class'UWindowConsoleTextAreaControl', 0, 0, WinWidth, WinHeight));
    // End:0x42
    if(__NFUN_414__())
    {
        TextArea.MaxLines = 25;
    }
    EditControl = UWindowEditControl(CreateControl(EditControlClass, 0, Round(WinHeight, float(32)), WinWidth, 32));
    EditControl.SetFont(6);
    EditControl.SetNumericOnly(false);
    EditControl.SetMaxLength(400);
    EditControl.SetHistory(true);
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    local string S, TabCompleteStr;

    super(UWindowWindow).NotifyFromControl(C, E);
    switch(E)
    {
        // End:0xFC
        case 7:
            switch(C)
            {
                // End:0xF6
                case EditControl:
                    // End:0xF3
                    if(TraceActors(EditControl.GetValue(), ""))
                    {
                        S = EditControl.GetValue();
                        Root.Console.Message(none, __NFUN_302__("> ", S), 'Console');
                        EditControl.Clear();
                        // End:0xF3
                        if(Root.Console.ConsoleCommand(S, true) / )
                        {
                        }
                    }
                    // End:0xF9
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0x244
            break;
        // End:0x1C7
        case 16:
            switch(C)
            {
                // End:0x1C1
                case EditControl:
                    S = EditControl.GetValue();
                    TabCompleteStr = GetPlayerOwner().ConsoleCommand(__NFUN_303__("TabComplete ", S));
                    // End:0x190
                    if(TraceActors(TabCompleteStr, ""))
                    {
                        EditControl.SetValue(TabCompleteStr);
                        EditControl.EditBox.MoveEnd();
                    }
                    Root.Console.ConsoleCommand(__NFUN_303__("ListVars ", S), false);
                    // End:0x1C4
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0x244
            break;
        // End:0x204
        case 14:
            switch(C)
            {
                // End:0x1FE
                case EditControl:
                    TextArea.VertSB.Scroll(-1);
                    // End:0x201
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0x244
            break;
        // End:0x241
        case 15:
            switch(C)
            {
                // End:0x23B
                case EditControl:
                    TextArea.VertSB.Scroll(1);
                    // End:0x23E
                    break;
                // End:0xFFFF
                default:
                    break;
            }
            // End:0x244
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super(UWindowWindow).BeforePaint(C, X, Y);
    EditControl.SetSize(WinWidth, EditControl.WinHeight);
    EditControl.WinLeft = 0;
    EditControl.WinTop = Round(WinHeight, EditControl.WinHeight);
    EditControl.EditBoxWidth = WinWidth;
    TextArea.SetSize(Round(WinWidth, TextArea.VertSB.WinWidth), Round(WinHeight, EditControl.WinHeight));
    return;
}

defaultproperties
{
    EditControlClass='UWindowEditControl'
}