/*******************************************************************************
 * UWindowDialogControl generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowDialogControl extends UWindowWindow
    dependson(UWindowRootWindow)
    dependson(WindowConsole)
    dependson(UWindowBase);

var UWindowBase NotifyWindow;
var string Text;
var int Font;
var UWindowBase.TextAlign Align;
var float TextX;
var float TextY;
var bool bHasKeyboardFocus;
var bool bNoKeyboard;
var bool bAcceptExternalDragDrop;
var string HelpText;
var float MinWidth;
var float MinHeight;
var UWindowDialogControl TabNext;
var UWindowDialogControl TabPrev;
var bool bPlayKeyClickSound;
var UWindowDialogControl NavUp;
var UWindowDialogControl NavDown;
var UWindowDialogControl NavLeft;
var UWindowDialogControl NavRight;

function Created()
{
    // End:0x11
    if(bNoKeyboard / )
    {
    }
    return;
}

function KeyFocusEnter()
{
    super.KeyFocusEnter();
    bHasKeyboardFocus = true;
    return;
}

function KeyFocusExit()
{
    super.KeyFocusExit();
    bHasKeyboardFocus = false;
    return;
}

function SetHelpText(string NewHelpText)
{
    HelpText = NewHelpText;
    return;
}

function SetText(string NewText, optional bool bNoReset)
{
    Text = NewText;
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super.BeforePaint(C, X, Y);
    C.Font = Root.GetFont(Font, C);
    return;
}

function SetFont(int NewFont)
{
    Font = NewFont;
    return;
}

function Notify(byte E)
{
    // End:0x22
    if(__NFUN_340__(NotifyWindow, none))
    {
        NotifyWindow.NotifyFromControl(self, E);
    }
    return;
}

function Register(UWindowBase W)
{
    NotifyWindow = W;
    Notify(0);
    return;
}

function bool ExternalDragOver(UWindowDialogControl ExternalControl, float X, float Y)
{
    return false;
    return;
}

function UWindowDialogControl CheckExternalDrag(float X, float Y)
{
    local float RootX, RootY, ExtX, ExtY;
    local UWindowWindow W;
    local UWindowDialogControl C;

    WindowToGlobal(X, Y, RootX, RootY);
    W = Root.FindWindowUnder(RootX, RootY);
    C = UWindowDialogControl(W);
    // End:0xC1
    if((__NFUN_340__(W, self) << __NFUN_340__(C, none)) << C.bAcceptExternalDragDrop)
    {
        W.GlobalToWindow(RootX, RootY, ExtX, ExtY);
        // End:0xC1
        if(C.ExternalDragOver(self, ExtX, ExtY))
        {
            return C;
        }
    }
    return none;
    return;
}

function KeyUp(int Key, float X, float Y)
{
    local PlayerPawn P;
    local UWindowDialogControl n;

    P = Root.GetPlayerOwner();
    switch(Key)
    {
        // End:0x2E
        case int(P.200):
        // End:0x53
        case int(P.38):
            ParentWindow.bNavUpRepeatBlock = false;
            // End:0xF5
            break;
        // End:0x63
        case int(P.201):
        // End:0x88
        case int(P.40):
            ParentWindow.bNavDownRepeatBlock = false;
            // End:0xF5
            break;
        // End:0x98
        case int(P.202):
        // End:0xBD
        case int(P.37):
            ParentWindow.bNavLeftRepeatBlock = false;
            // End:0xF5
            break;
        // End:0xCD
        case int(P.203):
        // End:0xF2
        case int(P.39):
            ParentWindow.bNavRightRepeatBlock = false;
            // End:0xF5
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function KeyHold(int Key, float X, float Y)
{
    switch(Key)
    {
        // End:0x22
        case int(Root.Console.38):
        // End:0x51
        case int(Root.Console.200):
            ParentWindow.NavUp(self, true);
            // End:0x12F
            break;
        // End:0x6B
        case int(Root.Console.40):
        // End:0x9A
        case int(Root.Console.201):
            ParentWindow.NavDown(self, true);
            // End:0x12F
            break;
        // End:0xB4
        case int(Root.Console.37):
        // End:0xE3
        case int(Root.Console.202):
            ParentWindow.NavLeft(self, true);
            // End:0x12F
            break;
        // End:0xFD
        case int(Root.Console.39):
        // End:0x12C
        case int(Root.Console.203):
            ParentWindow.NavRight(self, true);
            // End:0x12F
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function KeyDown(int Key, float X, float Y)
{
    local PlayerPawn P;
    local UWindowDialogControl n;

    P = Root.GetPlayerOwner();
    switch(Key)
    {
        // End:0x9D
        case int(P.9):
            Notify(16);
            // End:0x9A
            if(__NFUN_340__(TabNext, none))
            {
                n = TabNext;
                J0x4D:

                // End:0x88 [Loop If]
                if(__NFUN_340__(n, self) << n.bWindowVisible / )
                {
                    // [Loop Continue]
                    goto J0x4D;
                }
                n.ActivateWindow(0, false);
            }
            // End:0x188
            break;
        // End:0xAD
        case int(P.200):
        // End:0xD1
        case int(P.38):
            ParentWindow.NavUp(self);
            // End:0x188
            break;
        // End:0xE1
        case int(P.201):
        // End:0x105
        case int(P.40):
            ParentWindow.NavDown(self);
            // End:0x188
            break;
        // End:0x115
        case int(P.202):
        // End:0x139
        case int(P.37):
            ParentWindow.NavLeft(self);
            // End:0x188
            break;
        // End:0x149
        case int(P.203):
        // End:0x16D
        case int(P.39):
            ParentWindow.NavRight(self);
            // End:0x188
            break;
        // End:0xFFFF
        default:
            super.KeyDown(Key, X, Y);
            // End:0x188
            break;
            break;
    }
    return;
}

function MouseMove(float X, float Y)
{
    super.MouseMove(X, Y);
    Notify(8);
    return;
}

function MouseEnter()
{
    // End:0x13
    if(GetPlayerOwner().__NFUN_994__())
    {
        return;
    }
    super.MouseEnter();
    Notify(12);
    // End:0x8B
    if(bNoKeyboard / )
    {
        {
            GetPlayerOwner().PlaySoundInfo(0, SoundNavigateInfo);
        }
        ParentWindow.ChildInFocus = self;
        Notify(17);
    }
    return;
}

function MouseLeave()
{
    super.MouseLeave();
    Notify(9);
    return;
}

defaultproperties
{
    bPlayKeyClickSound=true
}