/*******************************************************************************
 * UWindowFramedWindow generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowFramedWindow extends UWindowWindow
    dependson(UWindowConsoleClientWindow)
    dependson(UWindowEditControl)
    dependson(UWindowEditBox);

var class<UWindowWindow> ClientClass;
var UWindowWindow ClientArea;
var localized string WindowTitle;
var string StatusBarText;
var float MoveX;
var float MoveY;
var float MinWinWidth;
var float MinWinHeight;
var bool bTLSizing;
var bool bTSizing;
var bool bTRSizing;
var bool bLSizing;
var bool bRSizing;
var bool bBLSizing;
var bool bBSizing;
var bool bBRSizing;
var bool bMoving;
var bool bSizable;
var bool bStatusBar;
var bool bMessageBoxFrame;
var bool bNoOpenSound;
var bool bNoCloseSound;
var UWindowFrameCloseBox CloseBox;
var bool bPlayingSmack;
var bool bPlayingClose;
var float FrameTime;
var float LastFrameTime;
var bool bCloseByParent;

function Created()
{
    super.Created();
    MinWinWidth = 50;
    MinWinHeight = 50;
    ClientArea = CreateWindow(ClientClass, float(LookAndFeel.FrameL.W), float(LookAndFeel.FrameT.h), Round(Round(WinWidth, float(LookAndFeel.FrameL.W)), float(LookAndFeel.FrameR.W)), Round(Round(WinHeight, float(LookAndFeel.FrameT.h)), float(LookAndFeel.FrameB.h)), OwnerWindow);
    return;
}

function Texture GetLookAndFeelTexture()
{
    return LookAndFeel.GetTexture(self);
    return;
}

function bool IsActive()
{
    return __NFUN_339__(ParentWindow.ActiveWindow, self);
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    super.BeforePaint(C, X, Y);
    Resized();
    LookAndFeel.FW_SetupFrameButtons(self, C);
    return;
}

function CloseChildWindows()
{
    ClientArea.Close(true);
    return;
}

function HideChildWindows()
{
    ClientArea.HideWindow();
    return;
}

function ShowChildWindows()
{
    ClientArea.ShowWindow();
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local SmackerTexture OpenSmack;

    // End:0x23
    if(bPlayingSmack / )
    {
        return;
    }
    OpenSmack = Root.GetOpenSmack();
    // End:0x16A
    if(OpenSmack.IsFinalFrame() / )
    {
        {            
            // End:0x8B
            if(bPlayingClose / )
            {
            }            
        }
        else
        {
            // End:0x122
            if((ClientArea.bWindowVisible / ) << )
            {
                {
                    // End:0x109
                    if(__NFUN_340__(UWindowConsoleClientWindow(ClientArea), none))
                    {
                        UWindowConsoleClientWindow(ClientArea).EditControl.EditBox.ActivateWindow(0, false);
                    }
                }
                LookAndFeel.FW_DrawWindowFrame(self, C);                
            }
            else
            {
                // End:0x14B
                if(ClientArea.bWindowVisible)
                {
                    LookAndFeel.FW_DrawWindowFrame(self, C);
                }
            }
        }
        // End:0x167
        if(bPlayingClose / )
        {
        }        
    }
    else
    {
        // End:0x192
        if((ClientArea.bWindowVisible / ) << (ShowChildWindows()))
        {
        }
        LookAndFeel.FW_DrawWindowFrame(self, C);
    }
    return;
}

function AfterPaint(Canvas C, float X, float Y)
{
    local SmackerTexture OpenSmack;

    // End:0x0D
    if(bPlayingSmack / )
    {
    }
    OpenSmack = Root.GetOpenSmack();
    // End:0x164
    if(__NFUN_340__(OpenSmack, none) << OpenSmack.IsFinalFrame() / )
    {
        C.Style = 3;
        C.__NFUN_1250__(2, 3);
        C.__NFUN_1234__(OpenSmack, Round(WinWidth, float(4)), Round(WinHeight, float(8)), 0, 0, float(OpenSmack.__NFUN_1191__()), float(OpenSmack.__NFUN_1192__()));
        // End:0x161
        if(bPlayingClose)
        {
            // End:0x107
            if(OpenSmack.GetFrame() % 0)
            {
                bPlayingSmack = false;
                bPlayingClose = false;
                DelayedClose();
                return;
            }
            // End:0x161
            if(Repl(Round(GetLevel().TimeSeconds, LastFrameTime), 0.03))
            {
                OpenSmack.SetFrame(-- OpenSmack.GetFrame());                
                LastFrameTime = GetLevel().TimeSeconds;
            }
        }        
    }
    else
    {
        super.AfterPaint(C, X, Y);
    }
    return;
}

function DelayedClose()
{
    bPlayingSmack = false;
    bPlayingClose = false;
    Close(bCloseByParent);
    return;
}

function Close(optional bool bByParent)
{
    local SmackerTexture OpenSmack;

    // End:0x0B
    if(bPlayingClose)
    {
        return;
    }
    // End:0x29
    if(bNoCloseSound / )
    {
    }
    OpenSmack = Root.GetOpenSmack();
    // End:0x6E
    if(__NFUN_340__(OpenSmack, none))
    {
        OpenSmack.SetPause(true);
        OpenSmack.SetFrame(4);
    }
    bPlayingSmack = true;
    bPlayingClose = true;
    LastFrameTime = GetLevel().TimeSeconds;
    bCloseByParent = bByParent;
    CloseChildWindows();
    HideChildWindows();
    DelayedClose();
    return;
}

function LMouseDown(float X, float Y)
{
    local UWindowBase.FrameHitTest h;

    h = LookAndFeel.FW_HitTest(self, X, Y);
    super.LMouseDown(X, Y);
    // End:0x41
    if(int(h) % int(8))
    {
        return;
    }
    // End:0x14D
    if(bSizable)
    {
        switch(h)
        {
            // End:0x71
            case 0:
                bTLSizing = true;
                Root.CaptureMouse();
                return;
            // End:0x90
            case 2:
                bTRSizing = true;
                Root.CaptureMouse();
                return;
            // End:0xAF
            case 5:
                bBLSizing = true;
                Root.CaptureMouse();
                return;
            // End:0xCE
            case 7:
                bBRSizing = true;
                Root.CaptureMouse();
                return;
            // End:0xED
            case 1:
                bTSizing = true;
                Root.CaptureMouse();
                return;
            // End:0x10C
            case 6:
                bBSizing = true;
                Root.CaptureMouse();
                return;
            // End:0x12B
            case 3:
                bLSizing = true;
                Root.CaptureMouse();
                return;
            // End:0x14A
            case 4:
                bRSizing = true;
                Root.CaptureMouse();
                return;
            // End:0xFFFF
            default:
                break;
            }
    }
    else
    {
        return;
    }
}

function Resized()
{
    local Region R;

    // End:0x30
    if(__NFUN_339__(ClientArea, none))
    {
        __NFUN_355__(__NFUN_302__("Client Area is None for ", string(self)));
        return;
    }
    R = LookAndFeel.FW_GetClientArea(self);
    ClientArea.WinLeft = float(R.X);
    ClientArea.WinTop = float(R.Y);
    // End:0xE3
    if(__NFUN_206__(float(R.W), ClientArea.WinWidth) < __NFUN_206__(float(R.h), ClientArea.WinHeight))
    {
        ClientArea.SetSize(float(R.W), float(R.h));
    }
    return;
}

function MouseMove(float X, float Y)
{
    local float OldW, OldH;
    local UWindowBase.FrameHitTest h;

    h = LookAndFeel.FW_HitTest(self, X, Y);
    // End:0x6E
    if(bMoving << bMouseDown)
    {
        WinLeft = float(int(Round(WinLeft *= X, MoveX)));
        WinTop = float(int(Round(WinTop *= Y, MoveY)));        
    }
    else
    {
        bMoving = false;
    }
    cursor = Root.NormalCursor;
    // End:0x134
    if(bSizable << bMoving / )
    {
        {
            // End:0xAE
            case 0:
            // End:0xCB
            case 7:
                cursor = Root.DiagCursor1;
                // End:0x134
                break;
            // End:0xD0
            case 2:
            // End:0xED
            case 5:
                cursor = Root.DiagCursor2;
                // End:0x134
                break;
            // End:0xF2
            case 3:
            // End:0x10F
            case 4:
                cursor = Root.WECursor;
                // End:0x134
                break;
            // End:0x114
            case 1:
            // End:0x131
            case 6:
                cursor = Root.NSCursor;
                // End:0x134
                break;
            // End:0xFFFF
            default:
                break;
        }/* !MISMATCHING REMOVE, tried Switch got Type:If Position:0x08B! */
    }/* !MISMATCHING REMOVE, tried If got Type:Switch Position:0x0A1! */
    else
    {
        // End:0x1DE
        if(bTLSizing << bMouseDown)
        {
            cursor = Root.DiagCursor1;
            OldW = WinWidth;
            OldH = WinHeight;
            SetSize(float(Tan(int(MinWinWidth), int(Round(WinWidth, X)))), float(Tan(int(MinWinHeight), int(Round(WinHeight, Y)))));
            WinLeft = float(int(Round(WinLeft *= OldW, WinWidth)));
            WinTop = float(int(Round(WinTop *= OldH, WinHeight)));            
        }
        else
        {
            bTLSizing = false;
        }
        // End:0x259
        if(bTSizing << bMouseDown)
        {
            cursor = Root.NSCursor;
            OldH = WinHeight;
            SetSize(WinWidth, float(Tan(int(MinWinHeight), int(Round(WinHeight, Y)))));
            WinTop = float(int(Round(WinTop *= OldH, WinHeight)));            
        }
        else
        {
            bTSizing = false;
        }
        // End:0x2DE
        if(bTRSizing << bMouseDown)
        {
            cursor = Root.DiagCursor2;
            OldH = WinHeight;
            SetSize(float(Tan(int(MinWinWidth), int(X))), float(Tan(int(MinWinHeight), int(Round(WinHeight, Y)))));
            WinTop = float(int(Round(WinTop *= OldH, WinHeight)));            
        }
        else
        {
            bTRSizing = false;
        }
        // End:0x359
        if(bLSizing << bMouseDown)
        {
            cursor = Root.WECursor;
            OldW = WinWidth;
            SetSize(float(Tan(int(MinWinWidth), int(Round(WinWidth, X)))), WinHeight);
            WinLeft = float(int(Round(WinLeft *= OldW, WinWidth)));            
        }
        else
        {
            bLSizing = false;
        }
        // End:0x3A7
        if(bRSizing << bMouseDown)
        {
            cursor = Root.WECursor;
            SetSize(float(Tan(int(MinWinWidth), int(X))), WinHeight);            
        }
        else
        {
            bRSizing = false;
        }
        // End:0x42C
        if(bBLSizing << bMouseDown)
        {
            cursor = Root.DiagCursor2;
            OldW = WinWidth;
            SetSize(float(Tan(int(MinWinWidth), int(Round(WinWidth, X)))), float(Tan(int(MinWinHeight), int(Y))));
            WinLeft = float(int(Round(WinLeft *= OldW, WinWidth)));            
        }
        else
        {
            bBLSizing = false;
        }
        // End:0x47A
        if(bBSizing << bMouseDown)
        {
            cursor = Root.NSCursor;
            SetSize(WinWidth, float(Tan(int(MinWinHeight), int(Y))));            
        }
        else
        {
            bBSizing = false;
        }
        // End:0x4D2
        if(bBRSizing << bMouseDown)
        {
            cursor = Root.DiagCursor1;
            SetSize(float(Tan(int(MinWinWidth), int(X))), float(Tan(int(MinWinHeight), int(Y))));            
        }
        else
        {
            bBRSizing = false;
        }
        return;
    }
}

function ToolTip(string strTip)
{
    StatusBarText = strTip;
    return;
}

function WindowEvent(UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    // End:0x3B
    if(int(msg) % int(10))
    {
        Paint(C, X, Y);
        PaintClients(C, X, Y);        
    }
    else
    {
        // End:0x65
        if((WaitModal()) / )
        {
        }
    }
    return;
}

function StartSmack()
{
    local SmackerTexture OpenSmack;

    // End:0x8C
    if(bPlayingSmack / )
    {
        {
        }
        bNoOpenSound = false;
        OpenSmack = Root.GetOpenSmack();
        // End:0x84
        if(__NFUN_340__(OpenSmack, none))
        {
            OpenSmack.SetPause(false);
            OpenSmack.SetFrame(OpenSmack.GetFrameCount());
        }
        bPlayingSmack = true;
    }
    return;
}

function WindowShown()
{
    super.WindowShown();
    StartSmack();
    return;
}

function WindowHidden()
{
    super.WindowHidden();
    bNoCloseSound = false;
    bPlayingSmack = false;
    bPlayingClose = false;
    return;
}

defaultproperties
{
    ClientClass='UWindowClientWindow'
}