/*******************************************************************************
 * UWindowLookAndFeel generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowLookAndFeel extends UWindowBase
    dependson(UWindowComboControl)
    dependson(UWindowEditControl)
    dependson(UWindowRootWindow)
    dependson(UWindowEditBox)
    dependson(UWindowComboButton)
    dependson(UWindowComboLeftButton)
    dependson(UWindowComboRightButton)
    dependson(UWindowCheckbox)
    dependson(UWindowControlFrame);

enum eWindowFrameTypes
{
    eWINDOW_FRAME_TYPE_DEFAULT,
    eWINDOW_FRAME_TYPE_TILE_TOP,
    eWINDOW_FRAME_TYPE_SINGLE_TEXTURE,
    eWINDOW_FRAME_TYPE_MAX
};

var() Texture Active;
var() Texture Active2;
var() Texture Active3;
var() Texture Glow;
var() Texture Glow2;
var() Texture Glow3;
var() Texture Misc;
var(LookAndFeelFrame) Region FrameTL;
var(LookAndFeelFrame) Region FrameT;
var(LookAndFeelFrame) Region FrameT2;
var(LookAndFeelFrame) Region FrameT3;
var(LookAndFeelFrame) Region FrameTR;
var(LookAndFeelFrame) Region FrameL;
var(LookAndFeelFrame) Region FrameR;
var(LookAndFeelFrame) Region FrameBL;
var(LookAndFeelFrame) Region FrameB;
var(LookAndFeelFrame) Region FrameBR;
var(LookAndFeelFrame) Region CloseButtonUpRegion;
var(LookAndFeelFrame) Region CloseButtonRegion;
var(LookAndFeelFrame) Region ResetButtonUpRegion;
var(LookAndFeelFrame) Region ResetButtonRegion;
var(LookAndFeelFrame) UWindowLookAndFeel.eWindowFrameTypes eFrameType;
var() Color FrameActiveTitleColor;
var() Color FrameInactiveTitleColor;
var() Color HeadingActiveTitleColor;
var() Color HeadingInActiveTitleColor;
var() Color colorGUIWindows;
var(LookAndFeelFrame) int FrameTitleX;
var(LookAndFeelFrame) int FrameTitleY;
var(LookAndFeelBevel) Region BevelUpTL;
var(LookAndFeelBevel) Region BevelUpT;
var(LookAndFeelBevel) Region BevelUpTR;
var(LookAndFeelBevel) Region BevelUpL;
var(LookAndFeelBevel) Region BevelUpR;
var(LookAndFeelBevel) Region BevelUpBL;
var(LookAndFeelBevel) Region BevelUpB;
var(LookAndFeelBevel) Region BevelUpBR;
var(LookAndFeelBevel) Region BevelUpArea;
var(LookAndFeelBevel) Region MiscBevelTL[5];
var(LookAndFeelBevel) Region MiscBevelT[5];
var(LookAndFeelBevel) Region MiscBevelTR[5];
var(LookAndFeelBevel) Region MiscBevelL[5];
var(LookAndFeelBevel) Region MiscBevelR[5];
var(LookAndFeelBevel) Region MiscBevelBL[5];
var(LookAndFeelBevel) Region MiscBevelB[5];
var(LookAndFeelBevel) Region MiscBevelBR[5];
var(LookAndFeelBevel) Region MiscBevelArea[5];
var() Region ComboBtnUp;
var() Region ComboBtnDown;
var() Region ComboBtnDisabled;
var() int ColumnHeadingHeight;
var() Region HLine;
var() Color DefaultTextColor;
var() Color EditBoxTextColor;
var() int EditBoxBevel;
var(LookAndFeelTab) Region TabSelectedL;
var(LookAndFeelTab) Region TabSelectedM;
var(LookAndFeelTab) Region TabSelectedR;
var(LookAndFeelTab) Region TabUnselectedL;
var(LookAndFeelTab) Region TabUnselectedM;
var(LookAndFeelTab) Region TabUnselectedR;
var(LookAndFeelTab) Region TabBackground;
var() Region VSlideTop;
var() Region VSlideMid;
var() Region VSlideBot;
var(LookAndFeelSlider) int SliderBarBoxOffset;
var(LookAndFeelSlider) Region SliderBarBox;
var(LookAndFeelSlider) Region SBUpUp;
var(LookAndFeelSlider) Region SBUpDown;
var(LookAndFeelSlider) Region SBUpDisabled;
var(LookAndFeelSlider) Region SBDownUp;
var(LookAndFeelSlider) Region SBDownDown;
var(LookAndFeelSlider) Region SBDownDisabled;
var(LookAndFeelSlider) Region SBLeftUp;
var(LookAndFeelSlider) Region SBLeftDown;
var(LookAndFeelSlider) Region SBLeftDisabled;
var(LookAndFeelSlider) Region SBRightUp;
var(LookAndFeelSlider) Region SBRightDown;
var(LookAndFeelSlider) Region SBRightDisabled;
var(LookAndFeelSlider) Region VScrollUpDown;
var(LookAndFeelSlider) Region VScrollDownDown;
var(LookAndFeelSlider) Region VScrollSmallUpDown;
var(LookAndFeelSlider) Region VScrollSmallDownDown;
var(LookAndFeelSlider) Region VScrollBevelUpDown;
var(LookAndFeelSlider) Region VScrollBevelDownDown;
var(LookAndFeelSlider) Region SBBackground;
var(LookAndFeelSlider) Region SBPosIndicatorT;
var(LookAndFeelSlider) Region SBPosIndicatorM;
var(LookAndFeelSlider) Region SBPosIndicatorB;
var(LookAndFeelSlider) Region SBPosIndicator;
var(LookAndFeelSlider) Region SBPosIndicatorSmall;
var(LookAndFeelSlider) Region SBPosIndicatorBevel;
var() Region ArrowButtonRightUp;
var() Region ArrowButtonRightDown;
var() Region ArrowButtonLeftUp;
var() Region ArrowButtonLeftDown;
var(LookAndFeelTab) float Size_TabAreaHeight;
var(LookAndFeelTab) float Size_TabAreaOverhangHeight;
var(LookAndFeelTab) float Size_TabSpacing;
var(LookAndFeelTab) float Size_TabXOffset;
var() float Pulldown_ItemHeight;
var() float Pulldown_VBorder;
var() float Pulldown_HBorder;
var() float Pulldown_TextBorder;

function Texture GetTexture(UWindowFramedWindow W)
{
    return Active;
    return;
}

function Color GetGUIColor(UWindowWindow W)
{
    local Color C;

    return C;
    return;
}

function Color GetTextColor(UWindowWindow W)
{
    local Color C;

    return C;
    return;
}

function Setup()
{
    return;
}

function FW_DrawWindowFrame(UWindowFramedWindow W, Canvas C)
{
    return;
}

function Region FW_GetClientArea(UWindowFramedWindow W)
{
    return;
}

function UWindowBase.FrameHitTest FW_HitTest(UWindowFramedWindow W, float X, float Y)
{
    return;
}

function FW_SetupFrameButtons(UWindowFramedWindow W, Canvas C)
{
    return;
}

function DrawClientArea(UWindowWindow W, Canvas C)
{
    return;
}

function Combo_GetButtonBitmaps(UWindowComboButton W)
{
    return;
}

function Combo_SetupLeftButton(UWindowComboLeftButton W)
{
    return;
}

function Combo_SetupRightButton(UWindowComboRightButton W)
{
    return;
}

function ComboList_PositionList(UWindowComboList W, Canvas C, out float ListX, out float ListY)
{
    return;
}

function ComboList_DrawBackground(UWindowComboList W, Canvas C)
{
    return;
}

function ComboList_DrawItem(UWindowComboList Combo, Canvas C, float X, float Y, float W, float h, string Text, bool bSelected)
{
    return;
}

function SB_SetupUpButton(UWindowSBUpButton W)
{
    return;
}

function SB_SetupDownButton(UWindowSBDownButton W)
{
    return;
}

function SB_SetupLeftButton(UWindowSBLeftButton W)
{
    return;
}

function SB_SetupRightButton(UWindowSBRightButton W)
{
    return;
}

function SB_VSetSize(UWindowVScrollbar W, out float ThumbY, out float ThumbHeight)
{
    return;
}

function SB_VDraw(UWindowVScrollbar W, Canvas C)
{
    return;
}

function SB_HDraw(UWindowHScrollbar W, Canvas C)
{
    return;
}

function Tab_DrawTab(UWindowTabControlTabArea Tab, Canvas C, bool bActiveTab, bool bLeftmostTab, float X, float Y, float W, float h, string Text, bool bShowText)
{
    return;
}

function Tab_GetTabSize(UWindowTabControlTabArea Tab, Canvas C, string Text, out float W, out float h)
{
    return;
}

function Tab_SetupLeftButton(UWindowTabControlLeftButton W)
{
    return;
}

function Tab_SetupRightButton(UWindowTabControlRightButton W)
{
    return;
}

function Tab_SetTabPageSize(UWindowPageControl W, UWindowPageWindow P)
{
    return;
}

function Tab_DrawTabPageArea(UWindowPageControl W, Canvas C, UWindowPageWindow P)
{
    return;
}

function Menu_DrawMenuBar(UWindowMenuBar W, Canvas C)
{
    return;
}

function Menu_DrawMenuBarItem(UWindowMenuBar B, UWindowMenuBarItem i, float X, float Y, float W, float h, Canvas C)
{
    return;
}

function Menu_DrawPulldownMenuBackground(UWindowPulldownMenu W, Canvas C)
{
    return;
}

function Menu_DrawPulldownMenuItem(UWindowPulldownMenu m, UWindowPulldownMenuItem Item, Canvas C, float X, float Y, float W, float h, bool bSelected)
{
    return;
}

function Button_AutoSize(UWindowSmallButton B, Canvas C)
{
    return;
}

function Button_DrawSmallButton(UWindowSmallButton B, Canvas C, bool IsFocused)
{
    return;
}

function ControlFrame_SetupSizes(UWindowControlFrame W, Canvas C)
{
    return;
}

function Bevel_DrawTabBevel(UWindowWindow W, Canvas C, int X, int Y, int Width, int Height)
{
    return;
}

function Bevel_DrawSimpleBevel(UWindowWindow W, Canvas C, int X, int Y, int Width, int Height, float Alpha)
{
    return;
}

function Bevel_DrawSplitHeaderedBevel(UWindowWindow W, Canvas C, int X, int Y, int Width, int Height, string Header1, string Header2)
{
    return;
}

function DrawFullBorder(UWindowWindow W, Canvas C, int borderwidth)
{
    return;
}

function DrawBorder(UWindowWindow W, Canvas C, int X, int Y, int Width, int Height, int borderwidth)
{
    return;
}

function int Bevel_GetSplitLeft()
{
    return;
}

function int Bevel_GetSplitRight(int Width)
{
    return;
}

function int Bevel_GetHeaderedTop()
{
    return;
}

function Grid_DrawGrid(UWindowGrid W, Canvas C)
{
    return;
}

function Grid_DrawBrowserGrid(UWindowGrid W, Canvas C)
{
    return;
}

function Grid_SizeGrid(UWindowGrid W)
{
    return;
}

function Grid_SetGridColumnSize(UWindowGridColumn W)
{
    return;
}

simulated function PlayMenuSound(UWindowWindow W, UWindowBase.MenuSound S, optional float fVolume)
{
    return;
}

function SetTextColors(Color colorNew)
{
    DefaultTextColor = colorNew;
    EditBoxTextColor = colorNew;
    return;
}

final function ClipText(UWindowDialogControl W, Canvas C, float fTextX, float fTextY, out string OutText, optional bool bCheckHotKey, optional float ScaleX, optional float ScaleY, optional float Alpha, optional float ShadowDrift)
{
    C.DrawColor = GetTextColor(W);
    W.super(UWindowLookAndFeel).ClipText(C, fTextX, fTextY, OutText, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    return;
}

function bool Checkbox_Draw(UWindowCheckbox W, Canvas C, bool IsFocused)
{
    return false;
    return;
}

function Checkbox_ManualDraw(UWindowWindow Win, Canvas C, float X, float Y, float W, float h, bool bChecked)
{
    return;
}

function ControlFrame_Draw(UWindowControlFrame W, Canvas C)
{
    C.DrawColor.R = 255;
    C.DrawColor.G = 255;
    C.DrawColor.B = 255;
    W.DrawStretchedTexture(C, 0, 0, W.WinWidth, W.WinHeight, class'WhiteTexture');
    return;
}

function DrawBevelByTilingHor(UWindowWindow W, Canvas C, float DestX, float DestY, float DestWidth, float DestHeight, Region R, Texture t, int iBevelSizeLeft, int iBevelSizeRight)
{
    local Region regRemainder;

    W.DrawStretchedTextureSegment(C, DestX, DestY, float(iBevelSizeLeft), DestHeight, float(R.X), float(R.Y), float(iBevelSizeLeft), float(R.h), t);
    W.DrawStretchedTextureSegment(C, Round(DestX *= DestWidth, float(iBevelSizeRight)), DestY, float(iBevelSizeRight), DestHeight, float(-- ++ R.X), iBevelSizeRight);
    float(R.Y)
    float(iBevelSizeRight)
    float(R.h)
    t    
    regRemainder.X = ++ R.X;    
    regRemainder.Y = R.Y;
    regRemainder.W = -- R.W;        
    regRemainder.h = R.h;
    W.DrawHorizTiledPieces(C, DestX *= float(iBevelSizeLeft), DestY, Round(DestWidth, float(++ iBevelSizeLeft)));
    DestHeight
    regRemainder
    t    
    return;
}

function DrawBevelByTilingVert(UWindowWindow W, Canvas C, float DestX, float DestY, float DestWidth, float DestHeight, Region R, Texture t, int iBevelSizeTop, int iBevelSizeBottom)
{
    local Region regRemainder;

    W.DrawStretchedTextureSegment(C, DestX, DestY, DestWidth, float(iBevelSizeTop), float(R.X), float(R.Y), float(R.W), float(iBevelSizeTop), t);
    W.DrawStretchedTextureSegment(C, DestX, Round(DestY *= DestHeight, float(iBevelSizeBottom)), DestWidth, float(iBevelSizeBottom), float(R.X), float(-- ++ R.Y), iBevelSizeBottom);
    float(R.W)
    float(iBevelSizeBottom)
    t    
    regRemainder.X = R.X;
    regRemainder.Y = ++ R.Y;    
    regRemainder.W = R.W;
    regRemainder.h = -- R.h;        
    W.DrawVertTiledPieces(C, DestX, DestY *= float(iBevelSizeTop), DestWidth, Round(DestHeight, float(++ iBevelSizeTop)));
    regRemainder
    t    
    return;
}

function Checkbox_SetupSizes(UWindowCheckbox W, Canvas C)
{
    local float tW, tH;

    W.TextSize(C, W.Text, tW, tH);
    W.WinHeight = float(Tan(int(tH *= float(1)), 32));
    switch(W.Align)
    {
        // End:0xA0
        case 0:
            W.ImageX = Round(W.WinWidth, float(32));
            W.TextX = 0;
            // End:0x142
            break;
        // End:0xE3
        case 1:
            W.ImageX = 0;
            W.TextX = Round(W.WinWidth, tW);
            // End:0x142
            break;
        // End:0x13F
        case 2:
            W.ImageX = Round(W.WinWidth, float(32)) >>> float(2);
            W.TextX = Round(W.WinWidth, tW) >>> float(2);
            // End:0x142
            break;
        // End:0xFFFF
        default:
            break;
    }
    W.ImageY = Round(W.WinHeight, float(32)) >>> float(2);
    W.TextY = Round(W.WinHeight, tH) >>> float(2);
    return;
}

function Editbox_SetupSizes(UWindowEditControl W, Canvas C)
{
    local float tW, tH;
    local int B;

    B = EditBoxBevel;
    C.Font = W.Root.GetFont(W.Font, C);
    W.TextSize(C, W.Text, tW, tH);
    W.WinHeight = (12 *= float(MiscBevelT[B].h)) *= float(MiscBevelB[B].h);
    switch(W.Align)
    {
        // End:0x111
        case 0:
            W.EditAreaDrawX = Round(W.WinWidth, W.EditBoxWidth);
            W.TextX = 0;
            // End:0x1BF
            break;
        // End:0x154
        case 1:
            W.EditAreaDrawX = 0;
            W.TextX = Round(W.WinWidth, tW);
            // End:0x1BF
            break;
        // End:0x1BC
        case 2:
            W.EditAreaDrawX = Round(W.WinWidth, W.EditBoxWidth) >>> float(2);
            W.TextX = Round(W.WinWidth, tW) >>> float(2);
            // End:0x1BF
            break;
        // End:0xFFFF
        default:
            break;
    }
    W.EditAreaDrawY = Round(W.WinHeight, float(2)) >>> float(2);
    W.TextY = Round(W.WinHeight, tH) >>> float(2);
    W.EditBox.WinLeft = W.EditAreaDrawX *= float(MiscBevelL[B].W);
    W.EditBox.WinTop = float(MiscBevelT[B].h);
    W.EditBox.WinWidth = Round(Round(W.EditBoxWidth, float(MiscBevelL[B].W)), float(MiscBevelR[B].W));
    W.EditBox.WinHeight = Round(Round(W.WinHeight, float(MiscBevelT[B].h)), float(MiscBevelB[B].h));
    return;
}

function Combo_SetupSizes(UWindowComboControl W, Canvas C)
{
    local float tW, tH;

    C.Font = W.Root.GetFont(W.Font, C);
    W.TextSize(C, W.Text, tW, tH);
    W.WinHeight = float(++ ++ ComboBtnUp.h);
    MiscBevelB[2].h;    
    switch(W.Align)
    {
        // End:0x104
        case 0:
            W.EditAreaDrawX = Round(W.WinWidth, W.EditBoxWidth);
            W.TextX = 0;
            // End:0x1B2
            break;
        // End:0x147
        case 1:
            W.EditAreaDrawX = 0;
            W.TextX = Round(W.WinWidth, tW);
            // End:0x1B2
            break;
        // End:0x1AF
        case 2:
            W.EditAreaDrawX = Round(W.WinWidth, W.EditBoxWidth) >>> float(2);
            W.TextX = Round(W.WinWidth, tW) >>> float(2);
            // End:0x1B2
            break;
        // End:0xFFFF
        default:
            break;
    }
    W.EditAreaDrawY = Round(W.WinHeight, float(2)) >>> float(2);
    W.TextY = Round(W.WinHeight, tH) >>> float(2);
    W.EditBox.WinLeft = W.EditAreaDrawX *= float(MiscBevelL[2].W);
    W.EditBox.WinTop = float(MiscBevelT[2].h);
    W.Button.WinWidth = float(ComboBtnUp.W);
    // End:0x581
    if(W.bButtons)
    {
        W.EditBox.WinWidth = Round(Round(Round(Round(Round(W.EditBoxWidth, float(MiscBevelL[2].W)), float(MiscBevelR[2].W)), float(ComboBtnUp.W)), float(SBLeftUp.W)), float(SBRightUp.W));
        W.EditBox.WinHeight = Round(Round(W.WinHeight, float(MiscBevelT[2].h)), float(MiscBevelB[2].h));
        W.Button.WinLeft = Round(Round(Round(Round(W.WinWidth, float(ComboBtnUp.W)), float(MiscBevelR[2].W)), float(SBLeftUp.W)), float(SBRightUp.W));
        W.Button.WinTop = W.EditBox.WinTop;
        W.LeftButton.WinLeft = Round(Round(Round(W.WinWidth, float(MiscBevelR[2].W)), float(SBLeftUp.W)), float(SBRightUp.W));
        W.LeftButton.WinTop = W.EditBox.WinTop;
        W.RightButton.WinLeft = Round(Round(W.WinWidth, float(MiscBevelR[2].W)), float(SBRightUp.W));
        W.RightButton.WinTop = W.EditBox.WinTop;
        W.LeftButton.WinWidth = float(SBLeftUp.W);
        W.LeftButton.WinHeight = float(SBLeftUp.h);
        W.RightButton.WinWidth = float(SBRightUp.W);
        W.RightButton.WinHeight = float(SBRightUp.h);        
    }
    else
    {
        W.EditBox.WinWidth = Round(Round(Round(W.EditBoxWidth, float(MiscBevelL[2].W)), float(MiscBevelR[2].W)), float(ComboBtnUp.W));
        W.EditBox.WinHeight = Round(Round(W.WinHeight, float(MiscBevelT[2].h)), float(MiscBevelB[2].h));
        W.Button.WinLeft = Round(Round(W.WinWidth, float(ComboBtnUp.W)), float(MiscBevelR[2].W));
        W.Button.WinTop = W.EditBox.WinTop;
    }
    W.Button.WinHeight = W.EditBox.WinHeight;
    return;
}

function Editbox_Draw(UWindowEditControl W, Canvas C)
{
    ClipText(W, C, W.TextX, W.TextY, W.Text);
    return;
}

function Combo_Draw(UWindowComboControl W, Canvas C)
{
    W.DrawMiscBevel(C, W.EditAreaDrawX, 0, W.EditBoxWidth, W.WinHeight, Misc, 2);
    ClipText(W, C, W.TextX, W.TextY, W.Text);
    return;
}

function HSlider_Draw(UWindowHSliderControl W, Canvas C, bool IsFocused)
{
    return;
}

function HSlider_AutoSize(UWindowHSliderControl W, Canvas C)
{
    return;
}

function MessageBox_AutoSize(UWindowMessageBox W, Canvas C)
{
    return;
}

defaultproperties
{
    FrameActiveTitleColor=(R=181,G=181,B=181,A=0)
    FrameInactiveTitleColor=(R=74,G=74,B=74,A=0)
    HeadingActiveTitleColor=(R=109,G=109,B=109,A=0)
    HeadingInActiveTitleColor=(R=54,G=54,B=54,A=0)
    colorGUIWindows=(R=121,G=206,B=125,A=0)
    DefaultTextColor=(R=165,G=165,B=165,A=0)
    EditBoxTextColor=(R=206,G=165,B=165,A=0)
    EditBoxBevel=2
    SliderBarBoxOffset=-4
    SBPosIndicator=(X=79,Y=55,W=12,h=10)
}