/*******************************************************************************
 * UWindowPageControl generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowPageControl extends UWindowTabControl;

function ResolutionChanged(float W, float h)
{
    local UWindowPageControlPage i;

    i = UWindowPageControlPage(Items.Next);
    J0x1A:

    // End:0x8F [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x72
        if(__NFUN_340__(i.Page, none) << __NFUN_340__(i, SelectedTab))
        {
            i.Page.ResolutionChanged(W, h);
        }
        i = UWindowPageControlPage(i.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    // End:0xC4
    if(__NFUN_340__(SelectedTab, none))
    {
        UWindowPageControlPage(SelectedTab).Page.ResolutionChanged(W, h);
    }
    return;
}

function NotifyQuitUnreal()
{
    local UWindowPageControlPage i;

    i = UWindowPageControlPage(Items.Next);
    J0x1A:

    // End:0x73 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x56
        if(__NFUN_340__(i.Page, none))
        {
            i.Page.NotifyQuitUnreal();
        }
        i = UWindowPageControlPage(i.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    return;
}

function NotifyBeforeLevelChange()
{
    local UWindowPageControlPage i;

    i = UWindowPageControlPage(Items.Next);
    J0x1A:

    // End:0x73 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x56
        if(__NFUN_340__(i.Page, none))
        {
            i.Page.NotifyBeforeLevelChange();
        }
        i = UWindowPageControlPage(i.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    return;
}

function NotifyAfterLevelChange()
{
    local UWindowPageControlPage i;

    i = UWindowPageControlPage(Items.Next);
    J0x1A:

    // End:0x73 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x56
        if(__NFUN_340__(i.Page, none))
        {
            i.Page.NotifyAfterLevelChange();
        }
        i = UWindowPageControlPage(i.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    return;
}

function GetDesiredDimensions(out float W, out float h)
{
    local float MaxW, MaxH, tW, tH;
    local UWindowPageControlPage i;

    MaxW = 0;
    MaxH = 0;
    i = UWindowPageControlPage(Items.Next);
    J0x30:

    // End:0xC7 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x76
        if(__NFUN_340__(i.Page, none))
        {
            i.Page.GetDesiredDimensions(tW, tH);
        }
        // End:0x90
        if(Repl(tW, MaxW))
        {
            MaxW = tW;
        }
        // End:0xAA
        if(Repl(tH, MaxH))
        {
            MaxH = tH;
        }
        i = UWindowPageControlPage(i.Next);
        // [Loop Continue]
        goto J0x30;
    }
    W = MaxW;
    h = MaxH *= TabArea.WinHeight;
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local float OldWinHeight;
    local UWindowPageControlPage i;

    OldWinHeight = WinHeight;
    super.BeforePaint(C, X, Y);
    WinHeight = OldWinHeight;
    i = UWindowPageControlPage(Items.Next);
    J0x45:

    // End:0x8E [Loop If]
    if(__NFUN_340__(i, none))
    {
        LookAndFeel.Tab_SetTabPageSize(self, i.Page);
        i = UWindowPageControlPage(i.Next);
        // [Loop Continue]
        goto J0x45;
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    super.Paint(C, X, Y);
    LookAndFeel.Tab_DrawTabPageArea(self, C, UWindowPageControlPage(SelectedTab).Page);
    return;
}

function UWindowPageControlPage AddPage(string Caption, class<UWindowPageWindow> PageClass, optional name ObjectName)
{
    local UWindowPageControlPage P;

    P = UWindowPageControlPage(AddTab(Caption));
    P.Page = UWindowPageWindow(CreateWindow(PageClass, 0, Round(TabArea.WinHeight, float(-- LookAndFeel.TabSelectedM.h))));
    WinWidth
    Round(WinHeight, Round(TabArea.WinHeight, float(-- LookAndFeel.TabSelectedM.h)));            
    ObjectName    
    P.Page.OwnerTab = P;
    GetPlayerOwner().BroadcastMessage(__NFUN_303__("AddPage", string(P)));
    // End:0x135
    if(__NFUN_340__(P, SelectedTab))
    {
        P.Page.HideWindow();        
    }
    else
    {
        // End:0x18F
        if(__NFUN_340__(UWindowPageControlPage(SelectedTab), none) << WindowIsVisible())
        {
            UWindowPageControlPage(SelectedTab).Page.ShowWindow();
            UWindowPageControlPage(SelectedTab).Page.BringToFront();
        }
    }
    return P;
    return;
}

function UWindowPageControlPage InsertPage(UWindowPageControlPage BeforePage, string Caption, class<UWindowPageWindow> PageClass, optional name ObjectName)
{
    local UWindowPageControlPage P;

    // End:0x1D
    if(__NFUN_339__(BeforePage, none))
    {
        return AddPage(Caption, PageClass);
    }
    P = UWindowPageControlPage(InsertTab(BeforePage, Caption));
    P.Page = UWindowPageWindow(CreateWindow(PageClass, 0, Round(TabArea.WinHeight, float(-- LookAndFeel.TabSelectedM.h))));
    WinWidth
    Round(WinHeight, Round(TabArea.WinHeight, float(-- LookAndFeel.TabSelectedM.h)));            
    ObjectName    
    P.Page.OwnerTab = P;
    // End:0x134
    if(__NFUN_340__(P, SelectedTab))
    {
        P.Page.HideWindow();        
    }
    else
    {
        // End:0x18E
        if(__NFUN_340__(UWindowPageControlPage(SelectedTab), none) << WindowIsVisible())
        {
            UWindowPageControlPage(SelectedTab).Page.ShowWindow();
            UWindowPageControlPage(SelectedTab).Page.BringToFront();
        }
    }
    return P;
    return;
}

function UWindowPageControlPage GetPage(string Caption)
{
    return UWindowPageControlPage(GetTab(Caption));
    return;
}

function DeletePage(UWindowPageControlPage P)
{
    P.Page.Close(true);
    P.Page.HideWindow();
    DeleteTab(P);
    return;
}

function Close(optional bool bByParent)
{
    local UWindowPageControlPage i;

    i = UWindowPageControlPage(Items.Next);
    J0x1A:

    // End:0x74 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x57
        if(__NFUN_340__(i.Page, none))
        {
            i.Page.Close(true);
        }
        i = UWindowPageControlPage(i.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    super(UWindowWindow).Close(bByParent);
    return;
}

function GotoTab(UWindowTabControlItem NewSelected, optional bool bByUser)
{
    local UWindowPageControlPage i;

    super.GotoTab(NewSelected, bByUser);
    i = UWindowPageControlPage(Items.Next);
    J0x2B:

    // End:0x7E [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x61
        if(__NFUN_340__(i, NewSelected))
        {
            i.Page.HideWindow();
        }
        i = UWindowPageControlPage(i.Next);
        // [Loop Continue]
        goto J0x2B;
    }
    // End:0xAE
    if(__NFUN_340__(UWindowPageControlPage(NewSelected), none))
    {
        UWindowPageControlPage(NewSelected).Page.ShowWindow();
    }
    return;
}

function UWindowPageControlPage FirstPage()
{
    return UWindowPageControlPage(Items.Next);
    return;
}

defaultproperties
{
    ListClass='UWindowPageControlPage'
}