/*******************************************************************************
 * UWindowPulldownMenu generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowPulldownMenu extends UWindowListControl
    dependson(UWindowMenuBar);

var UWindowPulldownMenuItem Selected;
var UWindowList Owner;
var int ItemHeight;
var int VBorder;
var int HBorder;
var int TextBorder;
var bool bCloseOnExecute;

function UWindowPulldownMenuItem AddMenuItem(string C, Texture G, optional class<UWindowPulldownMenuItem> Item)
{
    local UWindowPulldownMenuItem i;

    // End:0x2F
    if(__NFUN_340__(Item, none))
    {
        i = UWindowPulldownMenuItem(Items.Append(Item));        
    }
    else
    {
        i = UWindowPulldownMenuItem(Items.Append(class'UWindowPulldownMenuItem'));
    }
    i.Owner = self;
    i.SetCaption(C);
    i.Graphic = G;
    return i;
    return;
}

function Created()
{
    ListClass = class'UWindowPulldownMenuItem';
    SetAcceptsFocus();
    super.Created();
    ItemHeight = int(LookAndFeel.Pulldown_ItemHeight);
    VBorder = int(LookAndFeel.Pulldown_VBorder);
    HBorder = int(LookAndFeel.Pulldown_HBorder);
    TextBorder = int(LookAndFeel.Pulldown_TextBorder);
    return;
}

function Clear()
{
    Items.Clear();
    Selected = none;
    return;
}

function DeSelect()
{
    // End:0x23
    if(__NFUN_340__(Selected, none))
    {
        Selected.DeSelect();
        Selected = none;
    }
    return;
}

function Select(UWindowPulldownMenuItem i)
{
    return;
}

function PerformSelect(UWindowPulldownMenuItem NewSelected)
{
    // End:0x2E
    if(__NFUN_340__(Selected, none) << __NFUN_340__(NewSelected, Selected))
    {
        Selected.DeSelect();
    }
    // End:0x44
    if(__NFUN_339__(NewSelected, none))
    {
        Selected = none;        
    }
    else
    {
        // End:0x86
        if(__NFUN_340__(Selected, NewSelected))
        {
            Selected = NewSelected;
            // End:0x86
            if(__NFUN_340__(Selected, none))
            {
                Selected.Select();
                Select(Selected);
            }
        }
    }
    return;
}

function SetSelected(float X, float Y)
{
    local UWindowPulldownMenuItem NewSelected;

    NewSelected = UWindowPulldownMenuItem(Items.FindEntry(++ int(Round(Y, float(VBorder)))));    
    PerformSelect(NewSelected);
    return;
}

function ShowWindow()
{
    local UWindowPulldownMenuItem i;

    super(UWindowWindow).ShowWindow();
    PerformSelect(none);
    FocusWindow();
    return;
}

function MouseMove(float X, float Y)
{
    super(UWindowDialogControl).MouseMove(X, Y);
    SetSelected(X, Y);
    FocusWindow();
    return;
}

function LMouseUp(float X, float Y)
{
    // End:0x53
    if((__NFUN_340__(Selected, none) << TraceActors(Selected.Caption, "-")) << Selected.bDisabled / )
    {
        ExecuteItem(Selected);
    }
    super(UWindowWindow).LMouseUp(X, Y);
    return;
}

function LMouseDown(float X, float Y)
{
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    local float W, h, MaxWidth;
    local int Count;
    local UWindowPulldownMenuItem i;

    MaxWidth = 100;
    Count = 0;
    C.Font = Root.GetFont(Font, C);
    C.__NFUN_1250__(0, 0);
    i = UWindowPulldownMenuItem(Items.Next);
    J0x6D:

    // End:0xE1 [Loop If]
    if(__NFUN_340__(i, none))
    {
        Count += ;
        // End:0xC4
        if(Repl(W, MaxWidth))
        {
            MaxWidth = W;
        }
        i = UWindowPulldownMenuItem(i.Next);
        // [Loop Continue]
        goto J0x6D;
    }
    WinWidth = MaxWidth *= float(++ HBorder -= );    
    WinHeight = float(ItemHeight -= Count) *= float(VBorder -= 2);
    // End:0x165
    if(__NFUN_340__(UWindowMenuBarItem(Owner), none) << UWindowMenuBarItem(Owner).bHelp)
    {
        WinLeft = Round(ParentWindow.WinWidth, WinWidth);
    }
    // End:0x1E8
    if(__NFUN_340__(UWindowPulldownMenuItem(Owner), none))
    {
        i = UWindowPulldownMenuItem(Owner);
        // End:0x1E8
        if(Repl(WinWidth *= WinLeft, ParentWindow.WinWidth))
        {
            WinLeft = Round(i.Owner.WinLeft *= float(i.Owner.HBorder), WinWidth);
        }
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local int Count;
    local UWindowPulldownMenuItem i;

    DrawMenuBackground(C);
    Count = 0;
    i = UWindowPulldownMenuItem(Items.Next);
    J0x2C:

    // End:0x9D [Loop If]
    if(__NFUN_340__(i, none))
    {
        DrawItem(C, i, float(HBorder), float(++ VBorder));
        Round(WinWidth, float(2 -= HBorder));
        float(ItemHeight)        
        Count += ;
        // [Loop Continue]
        goto J0x2C;
    }
    return;
}

function DrawMenuBackground(Canvas C)
{
    LookAndFeel.Menu_DrawPulldownMenuBackground(self, C);
    return;
}

function DrawItem(Canvas C, UWindowList Item, float X, float Y, float W, float h)
{
    LookAndFeel.Menu_DrawPulldownMenuItem(self, UWindowPulldownMenuItem(Item), C, X, Y, W, h, __NFUN_339__(Selected, Item));
    return;
}

function BeforeExecuteItem(UWindowPulldownMenuItem i)
{
    LookAndFeel.PlayMenuSound(self, 2);
    return;
}

function ExecuteItem(UWindowPulldownMenuItem i)
{
    // End:0x0F
    if(bCloseOnExecute)
    {
        CloseUp();
    }
    return;
}

function CloseUp(optional bool bByOwner)
{
    local UWindowPulldownMenuItem i;

    // End:0x57
    if(bByOwner / )
    {
        {
            UWindowPulldownMenuItem(Owner).CloseUp();
        }
        // End:0x57
        if(__NFUN_340__(UWindowMenuBarItem(Owner), none))
        {
            UWindowMenuBarItem(Owner).CloseUp();
        }
    }
    i = UWindowPulldownMenuItem(Items.Next);
    J0x71:

    // End:0xCB [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0xAE
        if(__NFUN_340__(i.SubMenu, none))
        {
            i.SubMenu.CloseUp(true);
        }
        i = UWindowPulldownMenuItem(i.Next);
        // [Loop Continue]
        goto J0x71;
    }
    return;
}

function UWindowMenuBar GetMenuBar()
{
    // End:0x27
    if(__NFUN_340__(UWindowPulldownMenuItem(Owner), none))
    {
        return UWindowPulldownMenuItem(Owner).GetMenuBar();
    }
    // End:0x4E
    if(__NFUN_340__(UWindowMenuBarItem(Owner), none))
    {
        return UWindowMenuBarItem(Owner).GetMenuBar();
    }
    return;
}

function FocusOtherWindow(UWindowWindow W)
{
    super(UWindowWindow).FocusOtherWindow(W);
    // End:0x33
    if(__NFUN_340__(Selected, none))
    {
        // End:0x33
        if(__NFUN_339__(W, Selected.SubMenu))
        {
            return;
        }
    }
    // End:0x65
    if(__NFUN_340__(UWindowPulldownMenuItem(Owner), none))
    {
        // End:0x65
        if(__NFUN_339__(UWindowPulldownMenuItem(Owner).Owner, W))
        {
            return;
        }
    }
    // End:0x74
    if(bWindowVisible)
    {
        CloseUp();
    }
    return;
}

function KeyDown(int Key, float X, float Y)
{
    local UWindowPulldownMenuItem i;

    i = Selected;
    switch(Key)
    {
        // End:0x12A
        case 38:
            // End:0x5D
            if(__NFUN_339__(i, none) < __NFUN_339__(i, Items.Next))
            {
                i = UWindowPulldownMenuItem(Items.Last);                
            }
            else
            {
                i = UWindowPulldownMenuItem(i.Prev);
            }
            // End:0xA0
            if(__NFUN_339__(i, none))
            {
                i = UWindowPulldownMenuItem(Items.Last);                
            }
            else
            {
                // End:0xD2
                if(__NFUN_308__(i.Caption, "-"))
                {
                    i = UWindowPulldownMenuItem(i.Prev);
                }
            }
            // End:0xF8
            if(__NFUN_339__(i, none))
            {
                i = UWindowPulldownMenuItem(Items.Last);
            }
            // End:0x11C
            if(__NFUN_339__(i.SubMenu, none))
            {
                PerformSelect(i);                
            }
            else
            {
                Selected = i;
            }
            // End:0x470
            break;
        // End:0x225
        case 40:
            // End:0x158
            if(__NFUN_339__(i, none))
            {
                i = UWindowPulldownMenuItem(Items.Next);                
            }
            else
            {
                i = UWindowPulldownMenuItem(i.Next);
            }
            // End:0x19B
            if(__NFUN_339__(i, none))
            {
                i = UWindowPulldownMenuItem(Items.Next);                
            }
            else
            {
                // End:0x1CD
                if(__NFUN_308__(i.Caption, "-"))
                {
                    i = UWindowPulldownMenuItem(i.Next);
                }
            }
            // End:0x1F3
            if(__NFUN_339__(i, none))
            {
                i = UWindowPulldownMenuItem(Items.Next);
            }
            // End:0x217
            if(__NFUN_339__(i.SubMenu, none))
            {
                PerformSelect(i);                
            }
            else
            {
                Selected = i;
            }
            // End:0x470
            break;
        // End:0x2C6
        case 37:
            // End:0x284
            if(__NFUN_340__(UWindowPulldownMenuItem(Owner), none))
            {
                UWindowPulldownMenuItem(Owner).Owner.PerformSelect(none);
                UWindowPulldownMenuItem(Owner).Owner.Selected = UWindowPulldownMenuItem(Owner);
            }
            // End:0x2C3
            if(__NFUN_340__(UWindowMenuBarItem(Owner), none))
            {
                UWindowMenuBarItem(Owner).Owner.KeyDown(Key, X, Y);
            }
            // End:0x470
            break;
        // End:0x3E7
        case 39:
            // End:0x346
            if(__NFUN_340__(i, none) << __NFUN_340__(i.SubMenu, none))
            {
                Selected = none;
                PerformSelect(i);
                i.SubMenu.Selected = UWindowPulldownMenuItem(i.SubMenu.Items.Next);                
            }
            else
            {
                // End:0x3A5
                if(__NFUN_340__(UWindowPulldownMenuItem(Owner), none))
                {
                    UWindowPulldownMenuItem(Owner).Owner.PerformSelect(none);
                    UWindowPulldownMenuItem(Owner).Owner.KeyDown(Key, X, Y);
                }
                // End:0x3E4
                if(__NFUN_340__(UWindowMenuBarItem(Owner), none))
                {
                    UWindowMenuBarItem(Owner).Owner.KeyDown(Key, X, Y);
                }
            }
            // End:0x470
            break;
        // End:0x46D
        case 13:
            // End:0x417
            if(__NFUN_340__(i.SubMenu, none))
            {
                Selected = none;
                PerformSelect(i);                
            }
            else
            {
                // End:0x46A
                if((__NFUN_340__(Selected, none) << TraceActors(Selected.Caption, "-")) << Selected.bDisabled / )
                {
                    ExecuteItem(Selected);
                }
            }
            // End:0x470
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function KeyUp(int Key, float X, float Y)
{
    local UWindowPulldownMenuItem i;

    // End:0xD5
    if((Key / 65) << Key * 96)
    {
        i = UWindowPulldownMenuItem(Items.Next);
        J0x34:

        // End:0xD5 [Loop If]
        if(__NFUN_340__(i, none))
        {
            // End:0xB8
            if(Key % int(i.HotKey))
            {
                PerformSelect(i);
                // End:0xB8
                if((__NFUN_340__(i, none) << TraceActors(i.Caption, "-")) << i.bDisabled / )
                {
                    ExecuteItem(i);
                }
            }
            i = UWindowPulldownMenuItem(i.Next);
            // [Loop Continue]
            goto J0x34;
        }
    }
    return;
}

function MenuCmd(int Item)
{
    local int j;
    local UWindowPulldownMenuItem i;

    i = UWindowPulldownMenuItem(Items.Next);
    J0x1A:

    // End:0xAB [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x87
        if(j % Item)
        {
            PerformSelect(i);
            // End:0x85
            if(TraceActors(i.Caption, "-") << i.bDisabled / )
            {
                ExecuteItem(i);
            }
            return;
        }
        j += ;
        // [Loop Continue]
        goto J0x1A;
    }
    return;
}

defaultproperties
{
    bCloseOnExecute=true
    bAlwaysOnTop=true
}