/*******************************************************************************
 * UWindowRootWindow generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowRootWindow extends UWindowWindow
    native
    config
    dependson(WindowConsole)
    dependson(UWindowHotkeyWindowList);

enum EUWindowMode
{
    EUWindowMode_Startup,
    EUWindowMode_MainMenu,
    EUWindowMode_InstallScreen,
    EUWindowMode_ReturnToMainMenu,
    EUWindowMode_SinglePlayer_Pause,
    EUWindowMode_SinglePlayer_Credits,
    EUWindowMode_MultiPlayer_Pause,
    EUWindowMode_MultiPlayer_PreGameLobby,
    EUWindowMode_MultiPlayer_PostGameLobby,
    EUWindowMode_MultiPlayer_Scoreboard,
    EUWindowMode_MultiPlayer_DigsMenu,
    EUWindowMode_MultiPlayer_CustomizationMenu,
    EUWindowMode_MultiPlayer_DigsPauseMenu,
    EUWindowMode_MultiPlayer_DigsMoreInfoMenu,
    EUWindowMode_Horde_GameStart,
    EUWindowMode_Horde_GameEnd,
    EUWindowMode_Horde_Pause
};

var UWindowWindow MouseWindow;
var bool bMouseCapture;
var float MouseX;
var float MouseY;
var float OldMouseX;
var float OldMouseY;
var WindowConsole Console;
var UWindowWindow FocusedWindow;
var UWindowWindow KeyFocusWindow;
var MouseCursor NormalCursor;
var MouseCursor MoveCursor;
var MouseCursor DiagCursor1;
var MouseCursor HandCursor;
var MouseCursor HSplitCursor;
var MouseCursor VSplitCursor;
var MouseCursor DiagCursor2;
var MouseCursor NSCursor;
var MouseCursor WECursor;
var MouseCursor WaitCursor;
var bool bQuickKeyEnable;
var UWindowHotkeyWindowList HotkeyWindows;
var config float GUIScale;
var float RealWidth;
var float RealHeight;
var UWindowLookAndFeel LooksAndFeels[20];
var config string LookAndFeelClass;
var bool bRequestQuit;
var float QuitTime;
var bool bAllowConsole;
var bool bAllowObjectives;
var bool DontCloseOnEscape;
var UWindowWindow ScoreboardWindow;
var UWindowRootWindow.EUWindowMode WindowMode;

function BeginPlay()
{
    Root = self;
    MouseWindow = self;
    KeyFocusWindow = self;
    return;
}

function UWindowLookAndFeel GetLookAndFeel(string LFClassName)
{
    local int i;
    local class<UWindowLookAndFeel> LFClass;

    LFClass = class<UWindowLookAndFeel>(__NFUN_366__(LFClassName, class'Class'));
    i = 0;
    J0x1F:

    // End:0xAA [Loop If]
    if(-i)
    {        
        // End:0x74
        if(__NFUN_339__(LooksAndFeels[i], none))
        {
            LooksAndFeels[i] = new LFClass;
            LooksAndFeels[i].Setup();
            return LooksAndFeels[i];
        }
        // End:0xA0
        if(__NFUN_339__(LooksAndFeels[i].Class, LFClass))
        {
            return LooksAndFeels[i];
        }
        // [Loop Continue]
        i += ;
    }
    __NFUN_355__("Out of LookAndFeel array space!!");
    return none;
    return;
}

function Created()
{
    LookAndFeel = GetLookAndFeel(LookAndFeelClass);
    NormalCursor.Tex = Texture'MouseCursor';
    NormalCursor.HotX = 0;
    NormalCursor.HotY = 0;
    NormalCursor.WindowsCursor = Console.Viewport.0;
    MoveCursor.Tex = Texture'MouseMove';
    MoveCursor.HotX = 8;
    MoveCursor.HotY = 8;
    MoveCursor.WindowsCursor = Console.Viewport.1;
    DiagCursor1.Tex = Texture'MouseDiag1';
    DiagCursor1.HotX = 8;
    DiagCursor1.HotY = 8;
    DiagCursor1.WindowsCursor = Console.Viewport.4;
    HandCursor.Tex = Texture'MouseHand';
    HandCursor.HotX = 11;
    HandCursor.HotY = 1;
    HandCursor.WindowsCursor = Console.Viewport.0;
    HSplitCursor.Tex = Texture'MouseHSplit';
    HSplitCursor.HotX = 9;
    HSplitCursor.HotY = 9;
    HSplitCursor.WindowsCursor = Console.Viewport.5;
    VSplitCursor.Tex = Texture'MouseVSplit';
    VSplitCursor.HotX = 9;
    VSplitCursor.HotY = 9;
    VSplitCursor.WindowsCursor = Console.Viewport.3;
    DiagCursor2.Tex = Texture'MouseDiag2';
    DiagCursor2.HotX = 7;
    DiagCursor2.HotY = 7;
    DiagCursor2.WindowsCursor = Console.Viewport.2;
    NSCursor.Tex = Texture'MouseNS';
    NSCursor.HotX = 3;
    NSCursor.HotY = 7;
    NSCursor.WindowsCursor = Console.Viewport.3;
    WECursor.Tex = Texture'MouseWE';
    WECursor.HotX = 7;
    WECursor.HotY = 3;
    WECursor.WindowsCursor = Console.Viewport.5;
    WaitCursor.Tex = Texture'MouseWait';
    WECursor.HotX = 6;
    WECursor.HotY = 9;
    WECursor.WindowsCursor = Console.Viewport.6;
    HotkeyWindows = new class'UWindowHotkeyWindowList';
    HotkeyWindows.Last = HotkeyWindows;
    HotkeyWindows.Next = none;
    HotkeyWindows.Sentinel = HotkeyWindows;
    cursor = NormalCursor;
    Console.bReturnToMainMenu = false;
    return;
}

function MoveMouse(float X, float Y)
{
    local UWindowWindow NewMouseWindow;
    local float tX, tY;

    MouseX = X;
    MouseY = Y;
    // End:0x3A
    if(bMouseCapture / )
    {        
    }
    else
    {
        NewMouseWindow = MouseWindow;
    }
    // End:0x80
    if(__NFUN_340__(NewMouseWindow, MouseWindow))
    {
        MouseWindow.MouseLeave();
        NewMouseWindow.MouseEnter();
        MouseWindow = NewMouseWindow;
    }
    // End:0xEA
    if(__NFUN_206__(MouseX, OldMouseX) < __NFUN_206__(MouseY, OldMouseY))
    {
        OldMouseX = MouseX;
        OldMouseY = MouseY;
        MouseWindow.GetMouseXY(tX, tY);
        MouseWindow.MouseMove(tX, tY);
    }
    return;
}

function DrawMouse(Canvas C)
{
    local float X, Y;

    // End:0xBF
    if(GetPlayerOwner().__NFUN_994__() / )
    {
        C.DrawColor = LookAndFeel.GetGUIColor(self);
        C.__NFUN_1250__(Round(FRand(MouseX, GUIScale), float(MouseWindow.cursor.HotX)), Round(FRand(MouseY, GUIScale), float(MouseWindow.cursor.HotY)));
        C.__NFUN_1255__(MouseWindow.cursor.Tex, 1);
    }
    return;
}

function bool CheckCaptureMouseUp()
{
    local float X, Y;

    // End:0x47
    if(bMouseCapture)
    {
        MouseWindow.GetMouseXY(X, Y);
        MouseWindow.LMouseUp(X, Y);
        bMouseCapture = false;
        return true;
    }
    return false;
    return;
}

function bool CheckCaptureMouseDown()
{
    local float X, Y;

    // End:0x47
    if(bMouseCapture)
    {
        MouseWindow.GetMouseXY(X, Y);
        MouseWindow.LMouseDown(X, Y);
        bMouseCapture = false;
        return true;
    }
    return false;
    return;
}

function CancelCapture()
{
    bMouseCapture = false;
    return;
}

function CaptureMouse(optional UWindowWindow W)
{
    // End:0x08
    if(__NFUN_414__())
    {
        return;
    }
    bMouseCapture = true;
    // End:0x27
    if(__NFUN_340__(W, none))
    {
        MouseWindow = W;
    }
    return;
}

function Texture GetLookAndFeelTexture()
{
    return LookAndFeel.Active;
    return;
}

function Texture GetLookAndFeelTexture2()
{
    return LookAndFeel.Active2;
    return;
}

function Texture GetLookAndFeelTexture3()
{
    return LookAndFeel.Active3;
    return;
}

function Texture GetLookAndFeelGlowTexture()
{
    return LookAndFeel.Glow;
    return;
}

function Texture GetLookAndFeelGlowTexture2()
{
    return LookAndFeel.Glow2;
    return;
}

function Texture GetLookAndFeelGlowTexture3()
{
    return LookAndFeel.Glow3;
    return;
}

function MaterialEx GetBackgroundMovie()
{
    return none;
    return;
}

function SelectBackgroundMovie()
{
    return;
}

function CloseBackgroundMovie()
{
    return;
}

function bool IsActive()
{
    return true;
    return;
}

function AddHotkeyWindow(UWindowWindow W)
{
    UWindowHotkeyWindowList(HotkeyWindows.Insert(class'UWindowHotkeyWindowList')).Window = W;
    return;
}

function RemoveHotkeyWindow(UWindowWindow W)
{
    local UWindowHotkeyWindowList l;

    l = HotkeyWindows.FindWindow(W);
    // End:0x37
    if(__NFUN_340__(l, none))
    {
        l.Remove();
    }
    return;
}

function WindowEvent(UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    switch(msg)
    {
        // End:0x2A
        case 7:
            // End:0x27
            if(HotKeyDown(Key, X, Y))
            {
                return;
            }
            // End:0x4F
            break;
        // End:0x4C
        case 6:
            // End:0x49
            if(HotKeyUp(Key, X, Y))
            {
                return;
            }
            // End:0x4F
            break;
        // End:0xFFFF
        default:
            break;
    }
    super.WindowEvent(msg, C, X, Y, Key);
    return;
}

function bool HotKeyDown(int Key, float X, float Y)
{
    local UWindowHotkeyWindowList l;

    l = UWindowHotkeyWindowList(HotkeyWindows.Next);
    J0x1A:

    // End:0x89 [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x6C
        if(__NFUN_340__(l.Window, self) << l.Window.HotKeyDown(Key, X, Y))
        {
            return true;
        }
        l = UWindowHotkeyWindowList(l.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    return false;
    return;
}

function bool HotKeyUp(int Key, float X, float Y)
{
    local UWindowHotkeyWindowList l;

    l = UWindowHotkeyWindowList(HotkeyWindows.Next);
    J0x1A:

    // End:0x89 [Loop If]
    if(__NFUN_340__(l, none))
    {
        // End:0x6C
        if(__NFUN_340__(l.Window, self) << l.Window.HotKeyUp(Key, X, Y))
        {
            return true;
        }
        l = UWindowHotkeyWindowList(l.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    return false;
    return;
}

function CloseActiveWindow()
{
    // End:0x1F
    if(__NFUN_340__(ActiveWindow, none))
    {
        ActiveWindow.EscClose();        
    }
    else
    {
        Console.CloseUWindow();
    }
    return;
}

function Resized()
{
    ResolutionChanged(WinWidth, WinHeight);
    return;
}

final function Font GetFont(int Font, Canvas C)
{
    // End:0x1C
    if(Font % 6)
    {
        return C.BlockFontSmall;
    }
    // End:0x38
    if(Font % 7)
    {
        return C.SmallFont;
    }
    return C.BlockFont;
    return;
}

function SetScale(float NewScale)
{
    WinWidth = RealWidth >>> NewScale;
    WinHeight = RealHeight >>> NewScale;
    GUIScale = NewScale;
    ClippingRegion.X = 0;
    ClippingRegion.Y = 0;
    ClippingRegion.W = int(WinWidth);
    ClippingRegion.h = int(WinHeight);
    Resized();
    return;
}

function ChangeLookAndFeel(string NewLookAndFeel)
{
    LookAndFeelClass = NewLookAndFeel;
    __NFUN_368__();
    Console.ResetUWindow();
    return;
}

function ShowUWindowSystem(UWindowRootWindow.EUWindowMode NewWindowMode)
{
    bWindowVisible = true;
    WindowMode = NewWindowMode;
    return;
}

function bool DoesTopSceneIgnoreInput()
{
    return false;
    return;
}

function HideUWindowSystem()
{
    return;
}

function HideWindow()
{
    return;
}

function SetMousePos(float X, float Y)
{
    Console.MouseX = X;
    Console.MouseY = Y;
    return;
}

function QuitGame()
{
    bRequestQuit = true;
    QuitTime = 0;
    NotifyQuitUnreal();
    return;
}

function DoQuitGame()
{
    __NFUN_368__();
    Console.__NFUN_368__();
    Console.Viewport.Actor.__NFUN_368__();
    Close();    
    Console.Viewport.Actor.ConsoleCommand("exit");
    return;
}

function Tick(float Delta)
{
    // End:0x2A
    if(bRequestQuit)
    {
        // End:0x1E
        if(Repl(QuitTime, 0.25))
        {
            DoQuitGame();
        }
        __NFUN_209__(QuitTime, Delta);
    }
    super.Tick(Delta);
    return;
}

function ConfirmQuit()
{
    return;
}

function SmackerTexture GetOpenSmack()
{
    return;
}

function PrecachePauseMenu()
{
    __NFUN_355__(__NFUN_303__(string(self), "(UWindowRootWindow)::PrecachePauseMenu"));
    return;
}

function LoadScoreboardWindow(class<UWindowWindow> WndClass)
{
    ScoreboardWindow = CreateWindow(WndClass, 1, 1, 1, 1, none);
    // End:0x67
    if(__NFUN_340__(ScoreboardWindow, none))
    {
        __NFUN_355__("###Created special scoreboard");
        ScoreboardWindow.HideWindow();        
    }
    else
    {
        __NFUN_355__("###Failed to create special scoreboard!!!");
    }
    return;
}

function UWindowWindow GetScoreboardWindow()
{
    return ScoreboardWindow;
    return;
}

defaultproperties
{
    GUIScale=1
    bAllowConsole=true
    bAllowObjectives=true
}