/*******************************************************************************
 * UWindowTabControl generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowTabControl extends UWindowListControl
    dependson(UWindowTabControlTabArea)
    dependson(UWindowTabControlLeftButton)
    dependson(UWindowTabControlRightButton);

var UWindowTabControlLeftButton LeftButton;
var UWindowTabControlRightButton RightButton;
var UWindowTabControlTabArea TabArea;
var UWindowTabControlItem SelectedTab;
var bool bMultiLine;
var bool bSelectNearestTabOnRemove;

function Created()
{
    super.Created();
    SelectedTab = none;
    TabArea = UWindowTabControlTabArea(CreateWindow(class'UWindowTabControlTabArea', 0, 0, Round(Round(WinWidth, float(10)), float(LookAndFeel.SBPosIndicator.W -= 2)), LookAndFeel.Size_TabAreaHeight *= LookAndFeel.Size_TabAreaOverhangHeight));
    TabArea.bAlwaysOnTop = true;
    LeftButton = UWindowTabControlLeftButton(CreateWindow(class'UWindowTabControlLeftButton', Round(WinWidth, float(20)), 0, 10, 12));
    RightButton = UWindowTabControlRightButton(CreateWindow(class'UWindowTabControlRightButton', Round(WinWidth, float(10)), 0, 10, 12));
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    TabArea.WinTop = 0;
    TabArea.WinLeft = 0;
    // End:0x4B
    if(bMultiLine)
    {
        TabArea.WinWidth = WinWidth;        
    }
    else
    {
        TabArea.WinWidth = Round(Round(WinWidth, float(10)), float(LookAndFeel.SBPosIndicator.W -= 2));
    }
    TabArea.LayoutTabs(C);
    WinHeight = FRand(LookAndFeel.Size_TabAreaHeight, float(TabArea.TabRows)) *= LookAndFeel.Size_TabAreaOverhangHeight;
    TabArea.WinHeight = WinHeight;
    super(UWindowDialogControl).BeforePaint(C, X, Y);
    return;
}

function SetMultiLine(bool InMultiLine)
{
    bMultiLine = InMultiLine;
    // End:0x39
    if(bMultiLine)
    {
        LeftButton.HideWindow();
        RightButton.HideWindow();        
    }
    else
    {
        LeftButton.ShowWindow();
        RightButton.ShowWindow();
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local Region R;
    local Texture t;

    t = GetLookAndFeelTexture();
    R = LookAndFeel.TabBackground;
    DrawStretchedTextureSegment(C, 0, 0, WinWidth, FRand(LookAndFeel.Size_TabAreaHeight, float(TabArea.TabRows)), float(R.X), float(R.Y), float(R.W), float(R.h), t);
    return;
}

function UWindowTabControlItem AddTab(string Caption)
{
    local UWindowTabControlItem i;

    i = UWindowTabControlItem(Items.Append(ListClass));
    i.Owner = self;
    i.SetCaption(Caption);
    // End:0x5D
    if(__NFUN_339__(SelectedTab, none))
    {
        SelectedTab = i;
    }
    return i;
    return;
}

function UWindowTabControlItem InsertTab(UWindowTabControlItem BeforeTab, string Caption)
{
    local UWindowTabControlItem i;

    i = UWindowTabControlItem(BeforeTab.InsertBefore(ListClass));
    i.Owner = self;
    i.SetCaption(Caption);
    // End:0x5D
    if(__NFUN_339__(SelectedTab, none))
    {
        SelectedTab = i;
    }
    return i;
    return;
}

function GotoTab(UWindowTabControlItem NewSelected, optional bool bByUser)
{
    SelectedTab = NewSelected;
    TabArea.bShowSelected = true;
    return;
}

function UWindowTabControlItem GetTab(string Caption)
{
    local UWindowTabControlItem i;

    i = UWindowTabControlItem(Items.Next);
    J0x1A:

    // End:0x63 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x46
        if(__NFUN_308__(i.Caption, Caption))
        {
            return i;
        }
        i = UWindowTabControlItem(i.Next);
        // [Loop Continue]
        goto J0x1A;
    }
    return none;
    return;
}

function DeleteTab(UWindowTabControlItem Tab)
{
    local UWindowTabControlItem NextTab, PrevTab;

    NextTab = UWindowTabControlItem(Tab.Next);
    PrevTab = UWindowTabControlItem(Tab.Prev);
    Tab.Remove();
    // End:0xA7
    if(__NFUN_339__(SelectedTab, Tab))
    {
        // End:0x8D
        if(bSelectNearestTabOnRemove)
        {
            Tab = NextTab;
            // End:0x7F
            if(__NFUN_339__(Tab, none))
            {
                Tab = PrevTab;
            }
            GotoTab(Tab);            
        }
        else
        {
            GotoTab(UWindowTabControlItem(Items.Next));
        }
    }
    return;
}

defaultproperties
{
    ListClass='UWindowTabControlItem'
}