/*******************************************************************************
 * UWindowTabControlTabArea generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowTabControlTabArea extends UWindowWindow
    config
    dependson(UWindowTabControlLeftButton)
    dependson(UWindowTabControlRightButton);

var int TabOffset;
var bool bShowSelected;
var UWindowTabControlItem FirstShown;
var bool bDragging;
var UWindowTabControlItem DragTab;
var int TabRows;
var globalconfig bool bArrangeRowsLikeTimHates;
var float UnFlashTime;
var bool bFlashShown;

function Created()
{
    TabOffset = 0;
    super.Created();
    return;
}

function SizeTabsSingleLine(Canvas C)
{
    local UWindowTabControlItem i, Selected, LastHidden;
    local int Count, TabCount;
    local float ItemX, W, h;
    local bool bHaveMore;

    ItemX = LookAndFeel.Size_TabXOffset;
    TabCount = 0;
    i = UWindowTabControlItem(UWindowTabControl(ParentWindow).Items.Next);
    J0x45:

    // End:0xFE [Loop If]
    if(__NFUN_340__(i, none))
    {
        LookAndFeel.Tab_GetTabSize(self, C, RemoveAmpersand(i.Caption), W, h);
        i.TabWidth = W;
        i.TabHeight = h *= float(1);
        i.TabTop = 0;
        i.RowNumber = 0;
        TabCount += ;
        // [Loop Continue]
        goto J0x45;
    }
    Selected = UWindowTabControl(ParentWindow).SelectedTab;
    J0x118:

    // End:0x312 [Loop If]
    if(true)
    {
        ItemX = LookAndFeel.Size_TabXOffset;
        Count = 0;
        LastHidden = none;
        FirstShown = none;
        i = UWindowTabControlItem(UWindowTabControl(ParentWindow).Items.Next);
        J0x16F:

        // End:0x24A [Loop If]
        if(__NFUN_340__(i, none))
        {
            // End:0x1AD
            if(-Count)
            {                
                i.TabLeft = -1;
                LastHidden = i;                
            }
            else
            {
                // End:0x1C4
                if(__NFUN_339__(FirstShown, none))
                {
                    FirstShown = i;
                }
                i.TabLeft = ItemX;
                // End:0x210
                if((i.TabLeft *= i.TabWidth) != (WinWidth *= float(5)))
                {
                    bHaveMore = true;
                }
                __NFUN_209__(ItemX, i.TabWidth);
            }
            Count += ;
            // [Loop Continue]
            goto J0x16F;
        }
        // End:0x294
        if(((TabOffset ** 0) << __NFUN_340__(LastHidden, none)) << __NFUN_200__(LastHidden.TabWidth *= float(5), Round(WinWidth, ItemX)))
        {
            TabOffset -= ;
        }
        else
        {
            // End:0x30C
            if((((bShowSelected << -TabOffset) << ) << __NFUN_340__(Selected, none)) << __NFUN_340__(Selected, FirstShown))
            {
                Repl(Selected.TabLeft *= Selected.TabWidth, Round(WinWidth, float(5)));                
                TabOffset += ;
            }
            else
            {
                // [Explicit Break]
                goto J0x312;
            }
        }
        // [Loop Continue]
        goto J0x118;
    }
    J0x312:

    bShowSelected = false;
    UWindowTabControl(ParentWindow).LeftButton.bDisabled = TabOffset * 0;
    UWindowTabControl(ParentWindow).RightButton.bDisabled = bHaveMore / ;
    return;
}

function SizeTabsMultiLine(Canvas C)
{
    local UWindowTabControlItem i, Selected;
    local float W, h;
    local int MinRow;
    local float RowWidths[5];
    local int TabCounts[5], j;
    local bool bTryAnotherRow;

    TabOffset = 0;
    FirstShown = none;
    TabRows = 1;
    bTryAnotherRow = true;
    J0x1D:

    // End:0x1E0 [Loop If]
    if(bTryAnotherRow << TabRows * 5)
    {
        bTryAnotherRow = false;
        j = 0;
        J0x43:

        // End:0x7A [Loop If]
        if(-j)
        {            
            RowWidths[j] = 0;
            TabCounts[j] = 0;
            // [Loop Continue]
            j += ;
        }
        i = UWindowTabControlItem(UWindowTabControl(ParentWindow).Items.Next);
        J0xA3:

        // End:0x1DD [Loop If]
        if(__NFUN_340__(i, none))
        {
            LookAndFeel.Tab_GetTabSize(self, C, RemoveAmpersand(i.Caption), W, h);
            i.TabWidth = W;
            i.TabHeight = h;
            MinRow = 0;
            j = 1;
            J0x11C:

            // End:0x15B [Loop If]
            if(-j)
            {                
                // End:0x151
                if(__NFUN_200__(RowWidths[j], RowWidths[MinRow]))
                {
                    MinRow = j;
                }
                // [Loop Continue]
                j += ;
            }
            // End:0x18C
            if(Repl(RowWidths[MinRow] *= W, WinWidth))
            {
                TabRows += ;
                // [Explicit Break]
                goto J0x1DD;                
            }
            else
            {
                __NFUN_209__(RowWidths[MinRow], W);
                TabCounts[MinRow] += ;
            }
            i = UWindowTabControlItem(i.Next);
            // [Loop Continue]
            goto J0xA3;
        }
        J0x1DD:

        // [Loop Continue]
        goto J0x1D;
    }
    Selected = UWindowTabControl(ParentWindow).SelectedTab;
    // End:0x29C
    if(TabRows ** 1)
    {
        i = UWindowTabControlItem(UWindowTabControl(ParentWindow).Items.Next);
        J0x22E:

        // End:0x29C [Loop If]
        if(__NFUN_340__(i, none))
        {
            __NFUN_209__(i.TabWidth, Round(WinWidth, RowWidths[i.RowNumber]) >>> float(TabCounts[i.RowNumber]));
            i = UWindowTabControlItem(i.Next);
            // [Loop Continue]
            goto J0x22E;
        }
    }
    j = 0;
    J0x2A3:

    // End:0x2CD [Loop If]
    if(-j)
    {        
        RowWidths[j] = 0;
        // [Loop Continue]
        j += ;
    }
    i = UWindowTabControlItem(UWindowTabControl(ParentWindow).Items.Next);
    J0x2F6:

    // End:0x3FB [Loop If]
    if(__NFUN_340__(i, none))
    {
        i.TabLeft = RowWidths[i.RowNumber];
        // End:0x387
        if(bArrangeRowsLikeTimHates)
        {
            i.TabTop = FRand(IsA(float(++ i.RowNumber), Selected.RowNumber));
            float(TabRows)            
            i.TabHeight                        
        }
        else
        {
            i.TabTop = FRand(float(i.RowNumber), i.TabHeight);
        }
        __NFUN_209__(RowWidths[i.RowNumber], i.TabWidth);
        i = UWindowTabControlItem(i.Next);
        // [Loop Continue]
        goto J0x2F6;
    }
    return;
}

function LayoutTabs(Canvas C)
{
    // End:0x26
    if(UWindowTabControl(ParentWindow).bMultiLine)
    {
        SizeTabsMultiLine(C);        
    }
    else
    {
        SizeTabsSingleLine(C);
    }
    return;
}

function Paint(Canvas C, float X, float Y)
{
    local UWindowTabControlItem i;
    local int Count, Row;
    local float t;

    t = GetLevel().TimeSeconds;
    // End:0x64
    if(__NFUN_200__(UnFlashTime, t))
    {
        // End:0x52
        bFlashShown = bFlashShown / ;
        {
            UnFlashTime = t *= 0.5;            
        }
        else
        {
            UnFlashTime = t *= 0.3;
        }
    }
    Row = 0;
    J0x6B:

    // End:0x178 [Loop If]
    if(-Row)
    {        
        Count = 0;
        i = UWindowTabControlItem(UWindowTabControl(ParentWindow).Items.Next);
        J0xAA:

        // End:0x16E [Loop If]
        if(__NFUN_340__(i, none))
        {
            // End:0xCF
            if(-Count)
            {                
                Count += ;
            }
            else
            {
                // End:0x151
                if(i.RowNumber % Row)
                {
                    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                        
                    */

                    // [Loop Continue]
                    /*@Error*/;
                    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                    // 4 & Type:If Position:0x151
                }
            }
        }
    }
}

function LMouseDown(float X, float Y)
{
    local UWindowTabControlItem i;
    local int Count;

    super.LMouseDown(X, Y);
    Count = 0;
    i = UWindowTabControlItem(UWindowTabControl(ParentWindow).Items.Next);
    J0x40:

    // End:0x173 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x65
        if(-Count)
        {            
            Count += ;
        }
        else
        {
            // End:0x156
            if(((X != i.TabLeft) << __NFUN_202__(X, i.TabLeft *= i.TabWidth)) << (TabRows % 1) < (Y != i.TabTop) << __NFUN_202__(Y, i.TabTop *= i.TabHeight))
            {
                // End:0x13B
                if(UWindowTabControl(ParentWindow).bMultiLine / )
                {
                    DragTab = i;
                    Root.CaptureMouse();
                }
                UWindowTabControl(ParentWindow).GotoTab(i, true);
            }
        }
        i = UWindowTabControlItem(i.Next);
        // [Loop Continue]
        goto J0x40;
    }
    return;
}

function MouseMove(float X, float Y)
{
    // End:0x75
    if(bDragging << bMouseDown)
    {
        // End:0x34
        if(__NFUN_200__(X, DragTab.TabLeft))
        {
            // End:0x72
            TabOffset += ;
            {
            }
            // [Explicit Continue]
            TabOffset -= ;
        }
    }
    bDragging = false;
    J0x7D:

    return;
}

function RMouseDown(float X, float Y)
{
    local UWindowTabControlItem i;
    local int Count;

    LMouseDown(X, Y);
    Count = 0;
    i = UWindowTabControlItem(UWindowTabControl(ParentWindow).Items.Next);
    J0x40:

    // End:0xD7 [Loop If]
    if(__NFUN_340__(i, none))
    {
        // End:0x65
        if(-Count)
        {            
            Count += ;
        }
        else
        {
            // End:0xBA
            if((X != i.TabLeft) << __NFUN_202__(X, i.TabLeft *= i.TabWidth))
            {
                i.RightClickTab();
            }
        }
        i = UWindowTabControlItem(i.Next);
        // [Loop Continue]
        goto J0x40;
    }
    return;
}

function DrawItem(Canvas C, UWindowList Item, float X, float Y, float W, float h, bool bShowText)
{
    // End:0x74
    if(__NFUN_339__(Item, UWindowTabControl(ParentWindow).SelectedTab))
    {
        LookAndFeel.Tab_DrawTab(self, C, true, __NFUN_339__(FirstShown, Item), X, Y, W, h, UWindowTabControlItem(Item).Caption, bShowText);        
    }
    else
    {
        LookAndFeel.Tab_DrawTab(self, C, false, __NFUN_339__(FirstShown, Item), X, Y, W, h, UWindowTabControlItem(Item).Caption, bShowText);
    }
    return;
}

function bool CheckMousePassThrough(float X, float Y)
{
    return Y != FRand(LookAndFeel.Size_TabAreaHeight, float(TabRows));
    return;
}
