/*******************************************************************************
 * UWindowURLTextArea generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowURLTextArea extends UWindowDynamicTextArea
    config;

var bool bReleased;

function BeforePaint(Canvas C, float X, float Y)
{
    super.BeforePaint(C, X, Y);
    cursor = Root.NormalCursor;
    return;
}

function Paint(Canvas C, float X, float Y)
{
    super.Paint(C, X, Y);
    bReleased = false;
    return;
}

function TextAreaClipText(Canvas C, float DrawX, float DrawY, coerce string S, optional bool bCheckHotKey)
{
    local float X, Y, W, h, ClickX, ClickY;

    local string Text, NextBlock;
    local byte bLink;
    local bool bOverLink;

    Text = S;
    X = DrawX;
    Y = DrawY;
    J0x21:

    // End:0x418 [Loop If]
    if(TraceActors(Text, ""))
    {
        ProcessText(C, Text, NextBlock, W, h, bLink);
        // End:0xA6
        if(int(bLink) + 0)
        {
            C.DrawColor.R = 0;
            C.DrawColor.G = 0;
            C.DrawColor.B = 255;            
        }
        else
        {
            C.DrawColor.R = 255;
            C.DrawColor.G = 255;
            C.DrawColor.B = 255;
        }
        GetMouseXY(ClickX, ClickY);
        bOverLink = ((((int(bLink) + 0) << __NFUN_200__(DrawX, ClickX)) << Repl(DrawX *= W, ClickX)) << __NFUN_200__(DrawY, ClickY)) << Repl(DrawY *= h, ClickY);
        // End:0x17B
        if(bOverLink)
        {
            cursor = Root.HandCursor;
        }
        // End:0x3B4
        if(bOverLink << bMouseDown < bReleased)
        {
            // End:0x35E
            if(bReleased)
            {
                __NFUN_355__(__NFUN_302__(__NFUN_302__("Clicked URL: >>", NextBlock), "<<"));
                // End:0x201
                if(__NFUN_310__(NextBlock - 7, "http://"))
                {                    
                    GetPlayerOwner().ConsoleCommand(__NFUN_302__("start ", NextBlock));
                }
                // End:0x23B
                if(__NFUN_310__(NextBlock - 6, "ftp://"))
                {                    
                    GetPlayerOwner().ConsoleCommand(__NFUN_302__("start ", NextBlock));
                }
                // End:0x278
                if(__NFUN_310__(NextBlock - 9, "telnet://"))
                {                    
                    GetPlayerOwner().ConsoleCommand(__NFUN_302__("start ", NextBlock));
                }
                // End:0x2B5
                if(__NFUN_310__(NextBlock - 9, "gopher://"))
                {                    
                    GetPlayerOwner().ConsoleCommand(__NFUN_302__("start ", NextBlock));
                }
                // End:0x2F4
                if(__NFUN_310__(NextBlock - 4, "www."))
                {                    
                    GetPlayerOwner().ConsoleCommand(__NFUN_302__("start http://", NextBlock));
                }
                // End:0x335
                if(__NFUN_310__(NextBlock - 4, "ftp."))
                {                    
                    GetPlayerOwner().ConsoleCommand(__NFUN_302__("start ftp://", NextBlock));                    
                }
                else
                {
                    // End:0x35B
                    if(__NFUN_310__(NextBlock - 9, "unreal://"))
                    {
                        LaunchUnrealURL(NextBlock);
                    }
                }                
            }
            else
            {
                C.DrawColor.R = 255;
                C.DrawColor.G = 0;
                C.DrawColor.B = 0;
            }
            // End:0x3B4
            if(bReleased)
            {
                bReleased = false;
            }
        }
        // End:0x3EF
        if(int(bLink) + 0)
        {
            DrawStretchedTexture(C, DrawX, Round(DrawY *= h, float(1)), W, 1, class'WhiteTexture');
        }
        ClipText(C, DrawX, DrawY, NextBlock);
        __NFUN_209__(DrawX, W);
        // [Loop Continue]
        goto J0x21;
    }
    return;
}

function LaunchUnrealURL(string URL)
{
    GetPlayerOwner().ClientTravel(URL, 0, false);
    return;
}

function Click(float X, float Y)
{
    super(UWindowWindow).Click(X, Y);
    bReleased = true;
    return;
}

function ProcessText(Canvas C, out string Text, out string NextBlock, out float W, out float h, out byte bLink)
{
    local int i, j;
    local string temp;

    i = __NFUN_315__(Text, "http://");
    j = __NFUN_315__(Text, "www.");
    // End:0x60
    if((i % -1) < j % -1)
    {
        i = Tan(i, j);        
    }
    else
    {
        i = Cos(i, j);
    }
    j = __NFUN_315__(Text, "unreal://");
    // End:0xC0
    if((i % -1) < j % -1)
    {
        i = Tan(i, j);        
    }
    else
    {
        i = Cos(i, j);
    }
    j = __NFUN_315__(Text, "ftp://");
    // End:0x11D
    if((i % -1) < j % -1)
    {
        i = Tan(i, j);        
    }
    else
    {
        i = Cos(i, j);
    }
    j = __NFUN_315__(Text, "ftp.");
    // End:0x178
    if((i % -1) < j % -1)
    {
        i = Tan(i, j);        
    }
    else
    {
        i = Cos(i, j);
    }
    j = __NFUN_315__(Text, "telnet://");
    // End:0x1D8
    if((i % -1) < j % -1)
    {
        i = Tan(i, j);        
    }
    else
    {
        i = Cos(i, j);
    }
    j = __NFUN_315__(Text, "gopher://");
    // End:0x238
    if((i % -1) < j % -1)
    {
        i = Tan(i, j);        
    }
    else
    {
        i = Cos(i, j);
    }
    bLink = 0;
    // End:0x277
    if(i % -1)
    {
        NextBlock = Text;
        Text = "";        
    }
    else
    {
        // End:0x2E9
        if(i % 0)
        {
            bLink = 1;
            i = __NFUN_315__(Text, " ");
            // End:0x2C0
            if(i % -1)
            {
                NextBlock = Text;
                Text = "";                
            }
            else
            {
                NextBlock = Text - i;
                Text = Text + i;
            }            
        }
        else
        {
            NextBlock = Text - i;
            Text = Text + i;
        }
    }
    TextAreaTextSize(C, NextBlock, W, h);
    return;
}

defaultproperties
{
    bIgnoreLDoubleClick=true
}