/*******************************************************************************
 * UWindowWindow generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class UWindowWindow extends UWindowBase
    native
    dependson(UWindowDialogControl)
    dependson(UWindowMessageBox)
    dependson(UWindowRootWindow)
    dependson(UWindowLookAndFeel)
    dependson(WindowConsole);

cpptext
{
// Stripped
}

enum WinMessage
{
    WM_LMouseDown,
    WM_LMouseUp,
    WM_MMouseDown,
    WM_MMouseUp,
    WM_RMouseDown,
    WM_RMouseUp,
    WM_KeyUp,
    WM_KeyDown,
    WM_KeyType,
    WM_KeyHold,
    WM_Paint
};

enum EDE_Debug
{
    DE_Created,
    DE_Change,
    DE_Click,
    DE_Enter,
    DE_Exit,
    DE_MClick,
    DE_RClick,
    DE_EnterPressed,
    DE_MouseMove,
    DE_MouseLeave,
    DE_LMouseDown,
    DE_DoubleClick,
    DE_MouseEnter,
    DE_HelpChanged,
    DE_WheelUpPressed,
    DE_WheelDownPressed,
    DE_TabPressed,
    DE_FocusEntered,
    DE_FocusLost,
    DE_Click_B,
    DE_Click_X,
    DE_Click_Y
};

struct MouseCursor
{
    var Texture Tex;
    var int HotX;
    var int HotY;
    var byte WindowsCursor;
};

var float WinLeft;
var float WinTop;
var float WinWidth;
var float WinHeight;
var UWindowWindow ParentWindow;
var UWindowWindow FirstChildWindow;
var UWindowWindow LastChildWindow;
var UWindowWindow NextSiblingWindow;
var UWindowWindow PrevSiblingWindow;
var UWindowWindow ActiveWindow;
var UWindowRootWindow Root;
var UWindowWindow OwnerWindow;
var UWindowWindow ModalWindow;
var bool bWindowVisible;
var bool bNoClip;
var bool bMouseDown;
var bool bRMouseDown;
var bool bMMouseDown;
var bool bAlwaysBehind;
var bool bAcceptsFocus;
var bool bAlwaysOnTop;
var bool bLeaveOnscreen;
var bool bUWindowActive;
var bool bTransient;
var bool bAcceptsHotKeys;
var bool bIgnoreLDoubleClick;
var bool bIgnoreMDoubleClick;
var bool bIgnoreRDoubleClick;
var float ClickTime;
var float MClickTime;
var float RClickTime;
var float ClickX;
var float ClickY;
var float MClickX;
var float MClickY;
var float RClickX;
var float RClickY;
var float ClientAreaAlpha;
var UWindowLookAndFeel LookAndFeel;
var Region ClippingRegion;
var Color WhiteColor;
var Color BlackColor;
var int ResizeFrames;
var MouseCursor cursor;
var UWindowWindow ChildInFocus;
var bool bNavUpRepeatBlock;
var bool bNavDownRepeatBlock;
var bool bNavRightRepeatBlock;
var bool bNavLeftRepeatBlock;
var float NavRepeatTimeout;
var float NavRepeatTime;
var float NavRepeatTimeHold;
var SSoundInfo SoundNavigateInfo;

function WindowEvent(UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    switch(msg)
    {
        // End:0x3A
        case 10:
            Paint(C, X, Y);
            PaintClients(C, X, Y);
            // End:0x2D6
            break;
        // End:0x8B
        case 0:
            // End:0x88
            if(Root.CheckCaptureMouseDown() / )
            {
                {
                }
            }
            // End:0x2D6
            break;
        // End:0xDC
        case 1:
            // End:0xD9
            if(Root.CheckCaptureMouseUp() / )
            {
                {
                }
            }
            // End:0x2D6
            break;
        // End:0x118
        case 4:
            // End:0x115
            if((MessageClients(msg, C, X, Y, Key)) / )
            {
            }
            // End:0x2D6
            break;
        // End:0x154
        case 5:
            // End:0x151
            if((MessageClients(msg, C, X, Y, Key)) / )
            {
            }
            // End:0x2D6
            break;
        // End:0x190
        case 2:
            // End:0x18D
            if((MessageClients(msg, C, X, Y, Key)) / )
            {
            }
            // End:0x2D6
            break;
        // End:0x1CC
        case 3:
            // End:0x1C9
            if((MessageClients(msg, C, X, Y, Key)) / )
            {
            }
            // End:0x2D6
            break;
        // End:0x20D
        case 7:
            // End:0x20A
            if((PropagateKey(msg, C, X, Y, Key)) / )
            {
            }
            // End:0x2D6
            break;
        // End:0x24E
        case 6:
            // End:0x24B
            if((PropagateKey(msg, C, X, Y, Key)) / )
            {
            }
            // End:0x2D6
            break;
        // End:0x28F
        case 8:
            // End:0x28C
            if((PropagateKey(msg, C, X, Y, Key)) / )
            {
            }
            // End:0x2D6
            break;
        // End:0x2D0
        case 9:
            // End:0x2CD
            if((PropagateKey(msg, C, X, Y, Key)) / )
            {
            }
            // End:0x2D6
            break;
        // End:0xFFFF
        default:
            // End:0x2D6
            break;
            break;
    }
    return;
}

function SaveConfigs()
{
    return;
}

final function PlayerPawn GetPlayerOwner()
{
    return Root.Console.Viewport.Actor;
    return;
}

final function LevelInfo GetLevel()
{
    return Root.Console.Viewport.Actor.Level;
    return;
}

final function LevelInfo GetEntryLevel()
{
    return Root.Console.Viewport.Actor.__NFUN_560__();
    return;
}

function Resized()
{
    ResizeFrames = 3;
    return;
}

function BeforePaint(Canvas C, float X, float Y)
{
    return;
}

function AfterPaint(Canvas C, float X, float Y)
{
    return;
}

function Paint(Canvas C, float X, float Y)
{
    return;
}

function Click(float X, float Y)
{
    return;
}

function MClick(float X, float Y)
{
    return;
}

function RClick(float X, float Y)
{
    return;
}

function DoubleClick(float X, float Y)
{
    return;
}

function MDoubleClick(float X, float Y)
{
    return;
}

function RDoubleClick(float X, float Y)
{
    return;
}

function BeginPlay()
{
    return;
}

function BeforeCreate()
{
    return;
}

function Created()
{
    return;
}

function AfterCreate()
{
    return;
}

function MouseEnter()
{
    return;
}

function Activated()
{
    return;
}

function Deactivated()
{
    return;
}

function MouseLeave()
{
    bMouseDown = false;
    bMMouseDown = false;
    bRMouseDown = false;
    return;
}

function MouseMove(float X, float Y)
{
    return;
}

function KeyUp(int Key, float X, float Y)
{
    return;
}

function KeyDown(int Key, float X, float Y)
{
    return;
}

function bool HotKeyDown(int Key, float X, float Y)
{
    return false;
    return;
}

function bool HotKeyUp(int Key, float X, float Y)
{
    return false;
    return;
}

function KeyType(int Key, float X, float Y)
{
    return;
}

function KeyHold(int Key, float X, float Y)
{
    return;
}

function KeyFocusEnter()
{
    return;
}

function KeyFocusExit()
{
    return;
}

function RMouseDown(float X, float Y)
{
    ActivateWindow(0, false);
    bRMouseDown = true;
    return;
}

function RMouseUp(float X, float Y)
{
    // End:0xBF
    if(bRMouseDown)
    {
        // End:0x83
        if((((bIgnoreRDoubleClick / ) << ) << ) << )
        {
            RClickTime = 0;            
        }
        else
        {
            RClickTime = GetLevel().TimeSeconds;
            RClickX = X;
            RClickY = Y;
            RClick(X, Y);
        }
    }
    bRMouseDown = false;
    return;
}

function MMouseDown(float X, float Y)
{
    ActivateWindow(0, false);
    bMMouseDown = true;
    return;
}

function MMouseUp(float X, float Y)
{
    // End:0xBD
    if(bMMouseDown)
    {
        // End:0x81
        if((((bIgnoreMDoubleClick / ) << ) << ) << )
        {
            MClickTime = 0;            
        }
        else
        {
            MClickTime = GetLevel().TimeSeconds;
            MClickX = X;
            MClickY = Y;
            MClick(X, Y);
        }
    }
    bMMouseDown = false;
    return;
}

function LMouseDown(float X, float Y)
{
    ActivateWindow(0, false);
    bMouseDown = true;
    return;
}

function LMouseUp(float X, float Y)
{
    // End:0xBD
    if(bMouseDown)
    {
        // End:0x81
        if((((bIgnoreLDoubleClick / ) << ) << ) << )
        {
            ClickTime = 0;            
        }
        else
        {
            ClickTime = GetLevel().TimeSeconds;
            ClickX = X;
            ClickY = Y;
            Click(X, Y);
        }
    }
    bMouseDown = false;
    return;
}

function FocusWindow()
{
    // End:0x49
    if(__NFUN_340__(Root.FocusedWindow, none) << __NFUN_340__(Root.FocusedWindow, self))
    {
        Root.FocusedWindow.FocusOtherWindow(self);
    }
    Root.FocusedWindow = self;
    return;
}

function FocusOtherWindow(UWindowWindow W)
{
    return;
}

function EscClose()
{
    Close();
    return;
}

function DelayedClose()
{
    return;
}

function Close(optional bool bByParent)
{
    local UWindowWindow Prev, Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x4B [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Prev = Child.PrevSiblingWindow;
        Child.Close(true);
        Child = Prev;
        // [Loop Continue]
        goto J0x0B;
    }
    SaveConfigs();
    // End:0x62
    if(bByParent / )
    {
    }
    return;
}

function AllHide()
{
    local UWindowWindow Prev, Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x4A [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Prev = Child.PrevSiblingWindow;
        Child.HideWindow();
        Child = Prev;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

function AllShow()
{
    local UWindowWindow Prev, Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x4A [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Prev = Child.PrevSiblingWindow;
        Child.ShowWindow();
        Child = Prev;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

final function SetSize(float W, float h)
{
    // End:0x3C
    if(__NFUN_206__(WinWidth, W) < __NFUN_206__(WinHeight, h))
    {
        WinWidth = W;
        WinHeight = h;
        Resized();
    }
    return;
}

function Tick(float Delta)
{
    // End:0x53
    if(__NFUN_206__(NavRepeatTimeout, float(0)) << __NFUN_202__(NavRepeatTimeout, GetLevel().TimeSeconds))
    {
        NavRepeatTimeout = 0;
        bNavUpRepeatBlock = false;
        bNavDownRepeatBlock = false;
        bNavRightRepeatBlock = false;
        bNavLeftRepeatBlock = false;
    }
    return;
}

final function DoTick(float Delta)
{
    local UWindowWindow Child;

    Tick(Delta);
    Child = FirstChildWindow;
    J0x16:

    // End:0x9F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.bUWindowActive = bUWindowActive;
        // End:0x54
        if(bLeaveOnscreen)
        {
            Child.bLeaveOnscreen = true;
        }
        // End:0x87
        if(bUWindowActive < Child.bLeaveOnscreen)
        {
            Child.super(UWindowWindow).DoTick(Delta);
        }
        Child = Child.NextSiblingWindow;
        // [Loop Continue]
        goto J0x16;
    }
    return;
}

final function PaintClients(Canvas C, float X, float Y)
{
    local float OrgX, OrgY, ClipX, ClipY;
    local UWindowWindow Child;

    OrgX = C.OrgX;
    OrgY = C.OrgY;
    ClipX = C.ClipX;
    ClipY = C.ClipY;
    Child = FirstChildWindow;
    J0x5F:

    // End:0x629 [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.bUWindowActive = bUWindowActive;
        C.__NFUN_1250__(0, 0);
        C.Style = GetPlayerOwner().1;
        C.DrawColor.R = 255;
        C.DrawColor.G = 255;
        C.DrawColor.B = 255;
        C.SpaceX = 0;
        C.SpaceY = 0;
        Child.BeforePaint(C, Round(X, Child.WinLeft), Round(Y, Child.WinTop));
        // End:0x181
        if(bLeaveOnscreen)
        {
            Child.bLeaveOnscreen = true;
        }
        // End:0x611
        if(bUWindowActive < Child.bLeaveOnscreen)
        {
            C.OrgX = C.OrgX *= FRand(Child.WinLeft, Root.GUIScale);
            C.OrgY = C.OrgY *= FRand(Child.WinTop, Root.GUIScale);
            // End:0x514
            if(Child.bNoClip / )
            {
                C.ClipY = FRand(Round(WinHeight, Child.WinTop) -= Child.WinHeight, Root.GUIScale);
                Child.ClippingRegion.X = int(Round(float(ClippingRegion.X), Child.WinLeft));
                Child.ClippingRegion.Y = int(Round(float(ClippingRegion.Y), Child.WinTop));
                Child.ClippingRegion.W = ClippingRegion.W;
                Child.ClippingRegion.h = ClippingRegion.h;
                // End:0x3C2
                if(-Child.ClippingRegion.X)
                {                    
                    Child.ClippingRegion.W == Child.ClippingRegion.X;
                    Child.ClippingRegion.X = 0;
                }
                // End:0x41C
                if(-Child.ClippingRegion.Y)
                {                    
                    Child.ClippingRegion.h == Child.ClippingRegion.Y;
                    Child.ClippingRegion.Y = 0;
                }
                // End:0x498
                if(Repl(float(Child.ClippingRegion.W), Round(Child.WinWidth, float(Child.ClippingRegion.X))))
                {
                    Child.ClippingRegion.W = int(Round(Child.WinWidth, float(Child.ClippingRegion.X)));
                }
                // End:0x514
                if(Repl(float(Child.ClippingRegion.h), Round(Child.WinHeight, float(Child.ClippingRegion.Y))))
                {
                    Child.ClippingRegion.h = int(Round(Child.WinHeight, float(Child.ClippingRegion.Y)));
                }
            }
            // End:0x5E7
            if(Child.bNoClip < (Child.ClippingRegion.W ** 0) << Child.ClippingRegion.h ** 0)
            {
                Child.WindowEvent(10, C, Round(X, Child.WinLeft), Round(Y, Child.WinTop), 0);
                Child.AfterPaint(C, Round(X, Child.WinLeft), Round(Y, Child.WinTop));                
            }
            C.OrgX = OrgX;
            C.OrgY = OrgY;
        }
        Child = Child.NextSiblingWindow;
        // [Loop Continue]
        goto J0x5F;
    }
    C.ClipX = ClipX;
    C.ClipY = ClipY;
    return;
}

function UWindowWindow FindWindowUnder(float X, float Y)
{
    local UWindowWindow Child;
    local bool bModal;

    Child = LastChildWindow;
    // End:0x4C
    if(__NFUN_340__(Child, none) << __NFUN_340__(Child.ModalWindow, none))
    {
        Child = Child.ModalWindow;
        bModal = true;
    }
    J0x4C:

    // End:0x20E [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.bUWindowActive = bUWindowActive;
        // End:0x8A
        if(bLeaveOnscreen)
        {
            Child.bLeaveOnscreen = true;
        }
        // End:0x1F6
        if(bUWindowActive < Child.bLeaveOnscreen)
        {
            // End:0x1E7
            if((((((Repl(Child.WinWidth, float(0)) << Repl(Child.WinHeight, float(0))) << X != Child.WinLeft) << __NFUN_202__(X, Child.WinLeft *= Child.WinWidth)) << Y != Child.WinTop) << __NFUN_202__(Y, Child.WinTop *= Child.WinHeight)) << Child.CheckMousePassThrough(Round(X, Child.WinLeft), Round(Y, Child.WinTop)) / )
            {                
            }
            else
            {
                // End:0x1F6
                if(bModal)
                {
                    return Child;
                }
            }
        }
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x4C;
    }
    return self;
    return;
}

function bool PropagateKey(UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    // End:0x22
    if(__NFUN_340__(ChildInFocus, none))
    {
        Child = ChildInFocus;
    }
    // End:0x39
    if(__NFUN_340__(ModalWindow, none))
    {
        Child = ModalWindow;
    }
    J0x39:

    // End:0x13D [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.bUWindowActive = bUWindowActive;
        // End:0x77
        if(bLeaveOnscreen)
        {
            Child.bLeaveOnscreen = true;
        }
        // End:0xF7
        if((bUWindowActive < Child.bLeaveOnscreen) << Child.bAcceptsFocus)
        {
            Child.WindowEvent(msg, C, Round(X, Child.WinLeft), Round(Y, Child.WinTop), Key);
            return true;
        }
        // End:0x125
        if(__NFUN_340__(Child.ChildInFocus, none))
        {
            Child = Child.ChildInFocus;            
        }
        else
        {
            Child = Child.PrevSiblingWindow;
        }
        // [Loop Continue]
        goto J0x39;
    }
    return false;
    return;
}

final function UWindowWindow CheckKeyFocusWindow()
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    // End:0x4B
    if((__NFUN_340__(ActiveWindow, none) << __NFUN_340__(Child, ActiveWindow)) << Child.bTransient / )
    {
    }
    J0x4B:

    // End:0xE3 [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.bUWindowActive = bUWindowActive;
        // End:0x89
        if(bLeaveOnscreen)
        {
            Child.bLeaveOnscreen = true;
        }
        // End:0xCB
        if(bUWindowActive < Child.bLeaveOnscreen)
        {
            // End:0xCB
            if(Child.bAcceptsFocus)
            {
                return Child.super(UWindowWindow).CheckKeyFocusWindow();
            }
        }
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x4B;
    }
    return self;
    return;
}

function bool MessageClients(UWindowWindow.WinMessage msg, Canvas C, float X, float Y, int Key)
{
    local UWindowWindow Child;

    // End:0xE5
    if(__NFUN_340__(ModalWindow, none))
    {
        // End:0xE3
        if((((X != ModalWindow.WinLeft) << __NFUN_202__(X, ModalWindow.WinLeft *= ModalWindow.WinWidth)) << Y != ModalWindow.WinTop) << __NFUN_202__(Y, ModalWindow.WinTop *= ModalWindow.WinHeight))
        {
            ModalWindow.WindowEvent(msg, C, Round(X, ModalWindow.WinLeft), Round(Y, ModalWindow.WinTop), Key);
        }
        return true;
    }
    Child = LastChildWindow;
    J0xF0:

    // End:0x280 [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.bUWindowActive = bUWindowActive;
        // End:0x12E
        if(bLeaveOnscreen)
        {
            Child.bLeaveOnscreen = true;
        }
        // End:0x268
        if(bUWindowActive < Child.bLeaveOnscreen)
        {
            // End:0x268
            if(((((X != Child.WinLeft) << __NFUN_202__(X, Child.WinLeft *= Child.WinWidth)) << Y != Child.WinTop) << __NFUN_202__(Y, Child.WinTop *= Child.WinHeight)) << Child.CheckMousePassThrough(Round(X, Child.WinLeft), Round(Y, Child.WinTop)) / )
            {
                return true;
            }
        }
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0xF0;
    }
    return false;
    return;
}

function ActivateWindow(int Depth, bool bTransientNoDeactivate)
{
    // End:0x1F
    if(__NFUN_339__(self, Root))
    {
        // End:0x1D
        if(Depth % 0)
        {
            FocusWindow();
        }
        return;
    }
    // End:0x2A
    if(WaitModal())
    {
        return;
    }
    // End:0x57
    if(bAlwaysBehind / )
    {
        ParentWindow.ShowChildWindow(self);
    }
    // End:0xE8
    if((bTransient < bTransientNoDeactivate) / )
    {
        {
            ParentWindow.ActiveWindow.Deactivated();
        }
        ParentWindow.ActiveWindow = self;
        ParentWindow.ActivateWindow(++ Depth);
        false        
        Activated();        
    }
    else
    {
        ParentWindow.ActivateWindow(++ Depth);
        true        
    }
    // End:0x112
    if(Depth % 0)
    {
        FocusWindow();
    }
    return;
}

final function BringToFront()
{
    // End:0x0E
    if(__NFUN_339__(self, Root))
    {
        return;
    }
    // End:0x48
    if((bAlwaysBehind / ) << ParentWindow.HideChildWindow(self))
    {
    }
    ParentWindow.super(UWindowWindow).BringToFront();
    return;
}

final function SendToBack()
{
    ParentWindow.HideChildWindow(self);
    ParentWindow.ShowChildWindow(self, true);
    return;
}

final function HideChildWindow(UWindowWindow Child)
{
    local UWindowWindow Window;

    // End:0x0E
    if(__NFUN_339__(Child, none))
    {
        return;
    }
    // End:0x25
    if(Child.bWindowVisible / )
    {
    }
    Child.bWindowVisible = false;
    // End:0x5F
    if(Child.bAcceptsHotKeys)
    {
        Root.RemoveHotkeyWindow(Child);
    }
    // End:0xAE
    if(__NFUN_339__(LastChildWindow, Child))
    {
        LastChildWindow = Child.PrevSiblingWindow;
        // End:0xA4
        if(__NFUN_340__(LastChildWindow, none))
        {
            LastChildWindow.NextSiblingWindow = none;            
        }
        else
        {
            FirstChildWindow = none;
        }        
    }
    else
    {
        // End:0xFD
        if(__NFUN_339__(FirstChildWindow, Child))
        {
            FirstChildWindow = Child.NextSiblingWindow;
            // End:0xF3
            if(__NFUN_340__(FirstChildWindow, none))
            {
                FirstChildWindow.PrevSiblingWindow = none;                
            }
            else
            {
                LastChildWindow = none;
            }            
        }
        else
        {
            Window = FirstChildWindow;
            J0x108:

            // End:0x19D [Loop If]
            if(__NFUN_340__(Window, none))
            {
                // End:0x185
                if(__NFUN_339__(Window.NextSiblingWindow, Child))
                {
                    Window.NextSiblingWindow = Child.NextSiblingWindow;
                    // End:0x182
                    if(__NFUN_340__(Window.NextSiblingWindow, none))
                    {
                        Window.NextSiblingWindow.PrevSiblingWindow = Window;
                    }
                    // [Explicit Break]
                    goto J0x19D;
                }
                Window = Window.NextSiblingWindow;
                // [Loop Continue]
                goto J0x108;
            }
        }
    }
    J0x19D:

    ActiveWindow = none;
    Window = LastChildWindow;
    J0x1AF:

    // End:0x1F6 [Loop If]
    if(__NFUN_340__(Window, none))
    {
        // End:0x1DE
        if(Window.bAlwaysOnTop / )
        {
            // [Explicit Break]
            goto J0x1F6;
        }
        Window = Window.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x1AF;
    }
    J0x1F6:

    // End:0x20D
    if(__NFUN_339__(ActiveWindow, none))
    {
        ActiveWindow = LastChildWindow;
    }
    return;
}

final function SetAcceptsFocus()
{
    // End:0x0B
    if(bAcceptsFocus)
    {
        return;
    }
    bAcceptsFocus = true;
    // End:0x2F
    if(__NFUN_340__(self, Root))
    {
        ParentWindow.super(UWindowWindow).SetAcceptsFocus();
    }
    return;
}

final function CancelAcceptsFocus()
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x3F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.super(UWindowWindow).CancelAcceptsFocus();
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    bAcceptsFocus = false;
    return;
}

final function GetMouseXY(out float X, out float Y)
{
    local UWindowWindow P;

    X = float(int(Root.MouseX));
    Y = float(int(Root.MouseY));
    P = self;
    J0x35:

    // End:0xA3 [Loop If]
    if(__NFUN_340__(P, Root) << __NFUN_340__(P, none))
    {
        X = Round(X, P.WinLeft);
        Y = Round(Y, P.WinTop);
        P = P.ParentWindow;
        // [Loop Continue]
        goto J0x35;
    }
    return;
}

final function GlobalToWindow(float GlobalX, float GlobalY, out float WinX, out float WinY)
{
    local UWindowWindow P;

    WinX = GlobalX;
    WinY = GlobalY;
    P = self;
    J0x1D:

    // End:0x7F [Loop If]
    if(__NFUN_340__(P, Root) << __NFUN_340__(P, none))
    {
        WinX ~= P.WinLeft;
        WinY ~= P.WinTop;
        P = P.ParentWindow;
        // [Loop Continue]
        goto J0x1D;
    }
    return;
}

final function WindowToGlobal(float WinX, float WinY, out float GlobalX, out float GlobalY)
{
    local UWindowWindow P;

    GlobalX = WinX;
    GlobalY = WinY;
    P = self;
    J0x1D:

    // End:0x7F [Loop If]
    if(__NFUN_340__(P, Root) << __NFUN_340__(P, none))
    {
        __NFUN_209__(GlobalX, P.WinLeft);
        __NFUN_209__(GlobalY, P.WinTop);
        P = P.ParentWindow;
        // [Loop Continue]
        goto J0x1D;
    }
    return;
}

final function ShowChildWindow(UWindowWindow Child, optional bool bAtBack)
{
    local UWindowWindow W;

    // End:0x20
    if(Child.bTransient / )
    {
    }
    // End:0x35
    if(Child.bWindowVisible)
    {
        return;
    }
    Child.bWindowVisible = true;
    // End:0x6F
    if(Child.bAcceptsHotKeys)
    {
        Root.AddHotkeyWindow(Child);
    }
    // End:0x108
    if(bAtBack)
    {
        // End:0xBF
        if(__NFUN_339__(FirstChildWindow, none))
        {
            Child.NextSiblingWindow = none;
            Child.PrevSiblingWindow = none;
            LastChildWindow = Child;
            FirstChildWindow = Child;            
        }
        else
        {
            FirstChildWindow.PrevSiblingWindow = Child;
            Child.NextSiblingWindow = FirstChildWindow;
            Child.PrevSiblingWindow = none;
            FirstChildWindow = Child;
        }        
    }
    else
    {
        W = LastChildWindow;
        J0x113:

        // End:0x292 [Loop If]
        if(true)
        {
            // End:0x27A
            if((Child.bAlwaysOnTop < __NFUN_339__(W, none)) < W.bAlwaysOnTop / )
            {
                {
                    // End:0x1A2
                    if(__NFUN_339__(LastChildWindow, none))
                    {
                        Child.NextSiblingWindow = none;
                        Child.PrevSiblingWindow = none;
                        LastChildWindow = Child;
                        FirstChildWindow = Child;                        
                    }
                    else
                    {
                        Child.NextSiblingWindow = FirstChildWindow;
                        Child.PrevSiblingWindow = none;
                        FirstChildWindow.PrevSiblingWindow = Child;
                        FirstChildWindow = Child;
                    }                    
                }
                else
                {
                    Child.NextSiblingWindow = W.NextSiblingWindow;
                    Child.PrevSiblingWindow = W;
                    // End:0x257
                    if(__NFUN_340__(W.NextSiblingWindow, none))
                    {
                        W.NextSiblingWindow.PrevSiblingWindow = Child;                        
                    }
                    else
                    {
                        LastChildWindow = Child;
                    }
                    W.NextSiblingWindow = Child;
                }
                // [Explicit Break]
                goto J0x292;
            }
            W = W.PrevSiblingWindow;
            // [Loop Continue]
            goto J0x113;
        }
    }
    J0x292:

    return;
}

function ShowWindow()
{
    ParentWindow.ShowChildWindow(self);
    WindowShown();
    return;
}

function HideWindow()
{
    WindowHidden();
    ParentWindow.HideChildWindow(self);
    return;
}

final function UWindowWindow CreateWindow(class<UWindowWindow> WndClass, optional float X, optional float Y, optional float W, optional float h, optional UWindowWindow OwnerW, optional bool bUnique, optional name ObjectName)
{
    local UWindowWindow Child;

    // End:0x57
    if(bUnique)
    {
        Child = Root.FindChildWindow(WndClass, true);
        // End:0x57
        if(__NFUN_340__(Child, none))
        {
            Child.ShowWindow();
            Child.BringToFront();
            return Child;
        }
    }
    // End:0x7D
    if(__NFUN_342__(ObjectName, 'None'))
    {
        Child = new (none, ObjectName) WndClass;        
    }
    else
    {
        Child = new (none) WndClass;
    }
    Child.BeginPlay();
    Child.WinTop = Y;
    Child.WinLeft = X;
    Child.WinWidth = W;
    Child.WinHeight = h;
    Child.Root = Root;
    Child.ParentWindow = self;
    Child.OwnerWindow = OwnerW;
    // End:0x152
    if(__NFUN_339__(Child.OwnerWindow, none))
    {
        Child.OwnerWindow = self;
    }
    Child.cursor = cursor;
    Child.bAlwaysBehind = false;
    Child.LookAndFeel = LookAndFeel;
    Child.BeforeCreate();
    Child.Created();
    Child.ShowWindow();
    Child.AfterCreate();
    return Child;
    return;
}

final function Tile(Canvas C, Texture t)
{
    local int X, Y;

    X = 0;
    Y = 0;
    J0x0E:

    // End:0x83 [Loop If]
    if(__NFUN_200__(float(X), WinWidth))
    {
        J0x1E:

        // End:0x63 [Loop If]
        if(__NFUN_200__(float(Y), WinHeight))
        {
            DrawClippedTexture(C, float(X), float(Y), t);
            Y == t.VSize;
            // [Loop Continue]
            goto J0x1E;
        }
        X == t.USize;
        Y = 0;
        // [Loop Continue]
        goto J0x0E;
    }
    return;
}

final function DrawHorizTiledPieces(Canvas C, float DestX, float DestY, float DestW, float DestH, Region R1, Texture T1, optional float fAlpha, optional bool bNoColorSet)
{
    local float Length, DeltaX;

    Length = DestW;
    J0x0B:

    // End:0xA2 [Loop If]
    if(Repl(Length, float(0)))
    {
        DeltaX = float(R1.W) -= Length;
        DrawStretchedTextureSegment(C, DestX, DestY, DeltaX, DestH, float(R1.X), float(R1.Y), DeltaX, float(R1.h), T1, fAlpha, bNoColorSet,,, true);
        Length ~= DeltaX;
        __NFUN_209__(DestX, DeltaX);
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

final function DrawVertTiledPieces(Canvas C, float DestX, float DestY, float DestW, float DestH, Region R1, Texture T1, optional float Alpha)
{
    local float Length, DeltaY;

    Length = DestH;
    J0x0B:

    // End:0x99 [Loop If]
    if(Repl(Length, float(0)))
    {
        DeltaY = float(R1.h) -= Length;
        DrawStretchedTextureSegment(C, DestX, DestY, DestW, DeltaY, float(R1.X), float(R1.Y), float(R1.W), DeltaY, T1, Alpha);
        Length ~= DeltaY;
        __NFUN_209__(DestY, DeltaY);
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

final function DrawClippedTexture(Canvas C, float X, float Y, MaterialEx Tex, optional float fAlpha, optional bool bNoColorSet, optional bool bBilinear, optional bool bTranslucent2)
{
    DrawStretchedTextureSegment(C, X, Y, float(Tex.__NFUN_1191__()), float(Tex.__NFUN_1192__()), 0, 0, float(Tex.__NFUN_1191__()), float(Tex.__NFUN_1192__()), Tex, fAlpha, bNoColorSet,,, bBilinear, bTranslucent2);
    return;
}

final function DrawStretchedTexture(Canvas C, float X, float Y, float W, float h, MaterialEx Tex, optional float fAlpha, optional bool bNoColorSet, optional bool bBilinear, optional bool bTranslucent2, optional bool bNoClip)
{
    // End:0x6F
    if(bNoClip)
    {
        DrawStretchedTextureSegmentNoClip(C, X, Y, W, h, 0, 0, float(Tex.__NFUN_1191__()), float(Tex.__NFUN_1192__()), Tex, fAlpha, bNoColorSet,,, bBilinear, bTranslucent2);        
    }
    else
    {
        DrawStretchedTextureSegment(C, X, Y, W, h, 0, 0, float(Tex.__NFUN_1191__()), float(Tex.__NFUN_1192__()), Tex, fAlpha, bNoColorSet,,, bBilinear, bTranslucent2);
    }
    return;
}

// Export UUWindowWindow::execDrawStretchedTextureSegment(FFrame&, void* const)
native final function DrawStretchedTextureSegment(Canvas C, float X, float Y, float W, float h, float tX, float tY, float tW, float tH, MaterialEx Tex, optional float fAlpha, optional bool bNoColorSet, optional bool bObsoleteIgnore, optional float Rotation, optional bool bNoBilinear, optional bool bTranslucent2);

final function DrawStretchedTextureSegmentNoClip(Canvas C, float X, float Y, float W, float h, float tX, float tY, float tW, float tH, MaterialEx Tex, optional float fAlpha, optional bool bNoColorSet, optional bool bObsoleteIgnore, optional float Rotation, optional bool bNoBilinear, optional bool bTranslucent2)
{
    local byte byteOldStyle;
    local Color colorOld;
    local float OrgX, OrgY, ClipX, ClipY;
    local bool bTransparent, bBilinear;

    // End:0x0E
    if(__NFUN_339__(Tex, none))
    {
        return;
    }
    bBilinear = bNoBilinear / ;
    OrgY = C.OrgY;
    ClipX = C.ClipX;
    ClipY = C.ClipY;
    C.__NFUN_1251__(OrgX *= FRand(float(ClippingRegion.X), Root.GUIScale), OrgY *= FRand(float(ClippingRegion.Y), Root.GUIScale));
    C.__NFUN_1252__(FRand(float(ClippingRegion.W), Root.GUIScale), FRand(float(ClippingRegion.h), Root.GUIScale));
    C.__NFUN_1250__(FRand(Round(X, float(ClippingRegion.X)), Root.GUIScale), FRand(Round(Y, float(ClippingRegion.Y)), Root.GUIScale));
    // End:0x185
    if(bTranslucent2)
    {
        C.Style = GetPlayerOwner().5;        
    }
    else
    {
        // End:0x1C2
        if((fAlpha != 0) << __NFUN_200__(fAlpha, 1))
        {
            C.Style = GetPlayerOwner().3;
        }
    }
    C.__NFUN_1234__(Tex, FRand(W, Root.GUIScale), FRand(h, Root.GUIScale), tX, tY, tW, tH, Rotation,,, bBilinear, fAlpha);
    C.__NFUN_1252__(ClipX, ClipY);
    C.__NFUN_1251__(OrgX, OrgY);
    return;
}

// Export UUWindowWindow::execClipText(FFrame&, void* const)
native final function ClipText(Canvas C, float X, float Y, coerce string S, optional bool bCheckHotKey, optional float ScaleX, optional float ScaleY, optional float Alpha, optional float ShadowDrift);

final function int WrapClipText(Canvas C, float X, float Y, coerce string S, optional bool bCheckHotKey, optional int Length, optional bool bNoDraw, optional bool bCenter, optional float ScaleX, optional float ScaleY, optional float Alpha, optional float ShadowDrift)
{
    local float W, h, StartX;
    local int SpacePos, CRPos, WordPos;
    local string Out, temp, Line;
    local bool bCR, bSentry;
    local int i, numLines;
    local float pW, pH;

    // End:0x1A
    if(__NFUN_204__(ScaleX, 0))
    {
        ScaleX = 1;
    }
    // End:0x34
    if(__NFUN_204__(ScaleY, 0))
    {
        ScaleY = 1;
    }
    // End:0x4B
    if(Length % 0)
    {
        Length = int(WinWidth);
    }
    StartX = X;
    X = 0;
    i = __NFUN_315__(S, "\\n");
    J0x73:

    // End:0xC6 [Loop If]
    if(i + -1)
    {
        S = __NFUN_302__(__NFUN_302__(S - i, CollidingActors(13)), S + ++ i);        
        i = __NFUN_315__(S, "\\n");
        // [Loop Continue]
        goto J0x73;
    }
    i = 0;
    bSentry = true;
    Out = "";
    numLines = 1;
    J0xE4:

    // End:0x407 [Loop If]
    if(bSentry << __NFUN_200__(Y, WinHeight))
    {
        // End:0x11D
        if(__NFUN_308__(Out, ""))
        {
            i += ;
        }
        SpacePos = __NFUN_315__(Out, " ");
        CRPos = __NFUN_315__(Out, CollidingActors(13));
        bCR = false;
        // End:0x190
        if((CRPos + -1) << -CRPos < )
        {            
            WordPos = CRPos;
            bCR = true;            
        }
        else
        {
            WordPos = SpacePos;
        }
        // End:0x1B8
        if(WordPos % -1)
        {
            temp = Out;            
        }
        else
        {
            temp = __NFUN_302__(Out - WordPos, " ");
        }
        TextSize(C, temp, W, h, ScaleX, ScaleY);
        // End:0x31D
        if(Repl(X *= W, float(Length)) < bCR)
        {
            // End:0x23A
            if(__NFUN_204__(X, float(0)))
            {
                Line = temp;
                __NFUN_209__(X, W);
            }
            // End:0x2CF
            if(bNoDraw / )
            {
                {
                    ClipText(C, StartX *= (Round(float(Length), X) >>> 2), Y, Line, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);                    
                }
                else
                {
                    ClipText(C, StartX, Y, Line, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);
                }
            }
            // End:0x2E9
            if(__NFUN_206__(X, float(0)))
            {
                Line = temp;                
            }
            else
            {
                Line = "";
                W = 0;
            }
            X = 0;
            __NFUN_209__(Y, h);
            numLines += ;
        }
        else
        {            
            VisibleActors(Line, temp);
        }
        __NFUN_209__(X, W);
        Out = Out + __NFUN_314__(temp);
        // End:0x404
        if(__NFUN_308__(Out, "") << i ** 0)
        {
            // End:0x3FC
            if(bNoDraw / )
            {
                {
                    ClipText(C, StartX *= (Round(float(Length), X) >>> 2), Y, Line, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);                    
                }
                else
                {
                    ClipText(C, StartX, Y, Line, bCheckHotKey, ScaleX, ScaleY, Alpha, ShadowDrift);
                }
            }
            bSentry = false;
        }
        // [Loop Continue]
        goto J0xE4;
    }
    return numLines;
    return;
}

final function DrawClippedActor(Canvas C, float X, float Y, Actor A, bool Wireframe, Rotator RotOffset, Vector LocOffset)
{
    local Vector MeshLoc;
    local float FOV;
    local Vector Min, Max;

    FOV = FRand(GetPlayerOwner().FovAngle, 3.141593) >>> float(180);
    MeshLoc.X = 0;
    MeshLoc.Y = 0;
    MeshLoc.Z = 0;
    A.__NFUN_652__(RotOffset);
    A.__NFUN_645__(Locs(MeshLoc, LocOffset));
    C.__NFUN_1239__(A, Wireframe, int(FRand(float(ClippingRegion.W), Root.GUIScale)), int(FRand(float(ClippingRegion.h), Root.GUIScale)), int(C.OrgX *= FRand(float(ClippingRegion.X), Root.GUIScale)), int(C.OrgY *= FRand(float(ClippingRegion.Y), Root.GUIScale)), true);
    return;
}

final function DrawUpBevel(Canvas C, float X, float Y, float W, float h, Texture t, optional float fAlpha, optional bool Fill, optional bool bNoColorSet)
{
    local Region R;

    R = LookAndFeel.BevelUpTL;
    DrawStretchedTextureSegment(C, X, Y, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha, bNoColorSet);
    R = LookAndFeel.BevelUpT;
    DrawStretchedTextureSegment(C, X *= float(LookAndFeel.BevelUpTL.W), Y, Round(Round(W, float(LookAndFeel.BevelUpTL.W)), float(LookAndFeel.BevelUpTR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha, bNoColorSet);
    R = LookAndFeel.BevelUpTR;
    DrawStretchedTextureSegment(C, Round(X *= W, float(R.W)), Y, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha, bNoColorSet);
    R = LookAndFeel.BevelUpL;
    DrawStretchedTextureSegment(C, X, Y *= float(LookAndFeel.BevelUpTL.h), float(R.W), Round(Round(h, float(LookAndFeel.BevelUpTL.h)), float(LookAndFeel.BevelUpBL.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha, bNoColorSet);
    R = LookAndFeel.BevelUpR;
    DrawStretchedTextureSegment(C, Round(X *= W, float(R.W)), Y *= float(LookAndFeel.BevelUpTL.h), float(R.W), Round(Round(h, float(LookAndFeel.BevelUpTL.h)), float(LookAndFeel.BevelUpBL.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha, bNoColorSet);
    R = LookAndFeel.BevelUpBL;
    DrawStretchedTextureSegment(C, X, Round(Y *= h, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha, bNoColorSet);
    R = LookAndFeel.BevelUpB;
    DrawStretchedTextureSegment(C, X *= float(LookAndFeel.BevelUpBL.W), Round(Y *= h, float(R.h)), Round(Round(W, float(LookAndFeel.BevelUpBL.W)), float(LookAndFeel.BevelUpBR.W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha, bNoColorSet);
    R = LookAndFeel.BevelUpBR;
    DrawStretchedTextureSegment(C, Round(X *= W, float(R.W)), Round(Y *= h, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha, bNoColorSet);
    // End:0x657
    if(Fill)
    {
        R = LookAndFeel.BevelUpArea;
        DrawStretchedTextureSegment(C, X *= float(LookAndFeel.BevelUpTL.W), Y *= float(LookAndFeel.BevelUpTL.h), Round(Round(W, float(LookAndFeel.BevelUpBL.W)), float(LookAndFeel.BevelUpBR.W)), Round(Round(h, float(LookAndFeel.BevelUpTL.h)), float(LookAndFeel.BevelUpBL.h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha, bNoColorSet);
    }
    return;
}

final function DrawMiscBevel(Canvas C, float X, float Y, float W, float h, Texture t, int BevelType, optional float fAlpha)
{
    local Region R;

    R = LookAndFeel.MiscBevelTL[BevelType];
    DrawStretchedTextureSegment(C, X, Y, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha);
    R = LookAndFeel.MiscBevelT[BevelType];
    DrawStretchedTextureSegment(C, X *= float(LookAndFeel.MiscBevelTL[BevelType].W), Y, Round(Round(W, float(LookAndFeel.MiscBevelTL[BevelType].W)), float(LookAndFeel.MiscBevelTR[BevelType].W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha);
    R = LookAndFeel.MiscBevelTR[BevelType];
    DrawStretchedTextureSegment(C, Round(X *= W, float(R.W)), Y, float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha);
    R = LookAndFeel.MiscBevelL[BevelType];
    DrawStretchedTextureSegment(C, X, Y *= float(LookAndFeel.MiscBevelTL[BevelType].h), float(R.W), Round(Round(h, float(LookAndFeel.MiscBevelTL[BevelType].h)), float(LookAndFeel.MiscBevelBL[BevelType].h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha);
    R = LookAndFeel.MiscBevelR[BevelType];
    DrawStretchedTextureSegment(C, Round(X *= W, float(R.W)), Y *= float(LookAndFeel.MiscBevelTL[BevelType].h), float(R.W), Round(Round(h, float(LookAndFeel.MiscBevelTL[BevelType].h)), float(LookAndFeel.MiscBevelBL[BevelType].h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha);
    R = LookAndFeel.MiscBevelBL[BevelType];
    DrawStretchedTextureSegment(C, X, Round(Y *= h, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha);
    R = LookAndFeel.MiscBevelB[BevelType];
    DrawStretchedTextureSegment(C, X *= float(LookAndFeel.MiscBevelBL[BevelType].W), Round(Y *= h, float(R.h)), Round(Round(W, float(LookAndFeel.MiscBevelBL[BevelType].W)), float(LookAndFeel.MiscBevelBR[BevelType].W)), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha);
    R = LookAndFeel.MiscBevelBR[BevelType];
    DrawStretchedTextureSegment(C, Round(X *= W, float(R.W)), Round(Y *= h, float(R.h)), float(R.W), float(R.h), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha);
    R = LookAndFeel.MiscBevelArea[BevelType];
    DrawStretchedTextureSegment(C, X *= float(LookAndFeel.MiscBevelTL[BevelType].W), Y *= float(LookAndFeel.MiscBevelTL[BevelType].h), Round(Round(W, float(LookAndFeel.MiscBevelBL[BevelType].W)), float(LookAndFeel.MiscBevelBR[BevelType].W)), Round(Round(h, float(LookAndFeel.MiscBevelTL[BevelType].h)), float(LookAndFeel.MiscBevelBL[BevelType].h)), float(R.X), float(R.Y), float(R.W), float(R.h), t, fAlpha);
    return;
}

final function string RemoveAmpersand(string S)
{
    local string Result, Underline;

    ParseAmpersand(S, Result, Underline, false);
    return Result;
    return;
}

final function byte ParseAmpersand(string S, out string Result, out string Underline, bool bCalcUnderline)
{
    local string temp;
    local int pos, NewPos, i;
    local byte HotKey;

    HotKey = 0;
    pos = 0;
    Result = "";
    Underline = "";
    J0x1F:

    // End:0x161 [Loop If]
    if(true)
    {
        temp = S + pos;
        NewPos = __NFUN_315__(temp, "&");
        // End:0x59
        if(NewPos % -1)
        {
            // [Explicit Break]
            goto J0x161;
        }
        pos == NewPos;
        // End:0xC4
        if(__NFUN_308__(temp + ++ NewPos, 1))
        {
            "&"            
            Result = __NFUN_302__(__NFUN_302__(Result, temp - NewPos), "&");
            // End:0xBA
            if(bCalcUnderline)
            {
                Underline = __NFUN_302__(Underline, " ");
            }
            // [Explicit Continue]
            pos += ;
        }
        // End:0xEE
        if(int(HotKey) % 0)
        {
            HotKey = byte(((temp + ++ NewPos) -= 1) $= );
        }
        Result = __NFUN_302__(Result, temp - NewPos);
        // End:0x157
        if(bCalcUnderline)
        {
            i = 0;
            J0x119:

            // End:0x146 [Loop If]
            if(-i)
            {                                
                Underline = __NFUN_302__(Underline, " ");
                // [Loop Continue]
                i += ;
            }
            Underline = __NFUN_302__(Underline, "_");
        }
        J0x157:

        // [Loop Continue]
        pos += ;
    }
    J0x161:

    Result = __NFUN_302__(Result, temp);
    return HotKey;
    return;
}

function bool MouseIsOver()
{
    return __NFUN_339__(Root.MouseWindow, self);
    return;
}

function ToolTip(string strTip)
{
    // End:0x25
    if(__NFUN_340__(ParentWindow, Root))
    {
        ParentWindow.ToolTip(strTip);
    }
    return;
}

final function SetMouseWindow()
{
    Root.MouseWindow = self;
    return;
}

function Texture GetLookAndFeelTexture()
{
    return ParentWindow.GetLookAndFeelTexture();
    return;
}

function Texture GetLookAndFeelTexture2()
{
    return ParentWindow.GetLookAndFeelTexture2();
    return;
}

function Texture GetLookAndFeelTexture3()
{
    return ParentWindow.GetLookAndFeelTexture3();
    return;
}

function Texture GetLookAndFeelGlowTexture()
{
    return ParentWindow.GetLookAndFeelGlowTexture();
    return;
}

function Texture GetLookAndFeelGlowTexture2()
{
    return ParentWindow.GetLookAndFeelGlowTexture2();
    return;
}

function Texture GetLookAndFeelGlowTexture3()
{
    return ParentWindow.GetLookAndFeelGlowTexture3();
    return;
}

function bool IsActive()
{
    return ParentWindow.IsActive();
    return;
}

function SetAcceptsHotKeys(bool bNewAccpetsHotKeys)
{
    // End:0x32
    if((bNewAccpetsHotKeys << bAcceptsHotKeys / ) << )
    {
    }
    // End:0x64
    if(((bNewAccpetsHotKeys / ) << ) << )
    {
    }
    bAcceptsHotKeys = bNewAccpetsHotKeys;
    return;
}

final function UWindowWindow GetParent(class<UWindowWindow> ParentClass, optional bool bExactClass)
{
    local UWindowWindow P;

    P = ParentWindow;
    J0x0B:

    // End:0x7F [Loop If]
    if(__NFUN_340__(P, Root))
    {
        // End:0x47
        if(bExactClass)
        {
            // End:0x44
            if(__NFUN_339__(P.Class, ParentClass))
            {
                return P;
            }            
        }
        else
        {
            // End:0x67
            if(__NFUN_357__(P.Class, ParentClass))
            {
                return P;
            }
        }
        P = P.ParentWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    return none;
    return;
}

final function UWindowWindow FindChildWindow(class<UWindowWindow> ChildClass, optional bool bExactClass)
{
    local UWindowWindow Child, Found;

    Child = LastChildWindow;
    J0x0B:

    // End:0xA8 [Loop If]
    if(__NFUN_340__(Child, none))
    {
        // End:0x43
        if(bExactClass)
        {
            // End:0x40
            if(__NFUN_339__(Child.Class, ChildClass))
            {
                return Child;
            }            
        }
        else
        {
            // End:0x63
            if(__NFUN_357__(Child.Class, ChildClass))
            {
                return Child;
            }
        }
        Found = Child.super(UWindowWindow).FindChildWindow(ChildClass);
        // End:0x90
        if(__NFUN_340__(Found, none))
        {
            return Found;
        }
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    return none;
    return;
}

function GetDesiredDimensions(out float W, out float h)
{
    local float MaxW, MaxH, tW, tH;
    local UWindowWindow Child, Found;

    MaxW = 0;
    MaxH = 0;
    Child = LastChildWindow;
    J0x21:

    // End:0x93 [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.GetDesiredDimensions(tW, tH);
        // End:0x61
        if(Repl(tW, MaxW))
        {
            MaxW = tW;
        }
        // End:0x7B
        if(Repl(tH, MaxH))
        {
            MaxH = tH;
        }
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x21;
    }
    W = MaxW;
    h = MaxH;
    return;
}

final function TextSize(Canvas C, coerce string Text, out float W, out float h, optional float XScale, optional float YScale)
{
    // End:0x1A
    if(__NFUN_204__(XScale, 0))
    {
        XScale = 1;
    }
    // End:0x34
    if(__NFUN_204__(YScale, 0))
    {
        YScale = 1;
    }
    C.__NFUN_1250__(0, 0);
    C.__NFUN_1238__(Text, W, h, XScale, YScale);
    W = W >>> Root.GUIScale;
    h = h >>> Root.GUIScale;
    return;
}

function ResolutionChanged(float W, float h)
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x49 [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.ResolutionChanged(W, h);
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

function ShowModal(UWindowWindow W)
{
    ModalWindow = W;
    W.ShowWindow();
    W.BringToFront();
    return;
}

function bool WaitModal()
{
    // End:0x23
    if(__NFUN_340__(ModalWindow, none) << ModalWindow.bWindowVisible)
    {
        return true;
    }
    ModalWindow = none;
    return false;
    return;
}

function WindowHidden()
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x3F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.WindowHidden();
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

function WindowShown()
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x3F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.WindowShown();
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

function bool CheckMousePassThrough(float X, float Y)
{
    return false;
    return;
}

final function bool WindowIsVisible()
{
    // End:0x0E
    if(__NFUN_339__(self, Root))
    {
        return true;
    }
    // End:0x1B
    if(bWindowVisible / )
    {
    }
    return ParentWindow.super(UWindowWindow).WindowIsVisible();
    return;
}

function SetParent(UWindowWindow NewParent)
{
    HideWindow();
    ParentWindow = NewParent;
    ShowWindow();
    return;
}

function UWindowMessageBox MessageBox(string Title, string Message, UWindowBase.MessageBoxButtons Buttons, UWindowBase.MessageBoxResult ESCResult, optional UWindowBase.MessageBoxResult EnterResult, optional int TimeOut)
{
    local UWindowMessageBox W;
    local UWindowFramedWindow f;

    W = UWindowMessageBox(CreateWindow(class'UWindowMessageBox', 100, 100, 100, 100, self));
    W.SetupMessageBox(Title, Message, Buttons, ESCResult, EnterResult, TimeOut);
    ShowModal(W);
    return W;
    return;
}

function MessageBoxDone(UWindowMessageBox W, UWindowBase.MessageBoxResult Result)
{
    ModalWindow = none;
    return;
}

function DukeMessageBoxDone(UWindowWindow W, int iResult)
{
    ModalWindow = none;
    return;
}

function DukeSuperMessageBoxDone(int Result, Engine.Object.EConsole_Dialog id)
{
    return;
}

function NotifyFromControl(UWindowDialogControl C, byte E)
{
    return;
}

function NotifyQuitUnreal()
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x3F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.NotifyQuitUnreal();
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

function NotifyBeforeLevelChange()
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x3F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.NotifyBeforeLevelChange();
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

function SetCursor(MouseCursor C)
{
    local UWindowWindow Child;

    cursor = C;
    Child = LastChildWindow;
    J0x16:

    // End:0x4F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.SetCursor(C);
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x16;
    }
    return;
}

function NotifyAfterLevelChange()
{
    local UWindowWindow Child;

    Child = LastChildWindow;
    J0x0B:

    // End:0x3F [Loop If]
    if(__NFUN_340__(Child, none))
    {
        Child.NotifyAfterLevelChange();
        Child = Child.PrevSiblingWindow;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

final function ReplaceText(out string Text, string Replace, string With)
{
    local int i;
    local string Input;

    Input = Text;
    Text = "";
    i = __NFUN_315__(Input, Replace);
    J0x26:

    // End:0x8B [Loop If]
    if(i + -1)
    {
        Text = __NFUN_302__(__NFUN_302__(Text, Input - i), With);
        Input = Input + ++ i;        
        i = __NFUN_315__(Input, Replace);
        // [Loop Continue]
        goto J0x26;
    }
    Text = __NFUN_302__(Text, Input);
    return;
}

function StripCRLF(out string Text)
{
    ReplaceText(Text, __NFUN_302__(CollidingActors(13), CollidingActors(10)), "");
    ReplaceText(Text, CollidingActors(13), "");
    ReplaceText(Text, CollidingActors(10), "");
    return;
}

function Color VEC_HSVToRGB(Vector inHSV)
{
    local float h, S, V, m, n, f;

    local int i;

    h = FRand(inHSV.X, 6);
    S = inHSV.Y;
    V = inHSV.Z;
    // End:0x5C
    if(__NFUN_204__(S, 0))
    {
        return NewColor(V, V, V);
    }
    i = int(h);
    f = Round(h, float(i));
    // End:0x9B
    if((i - 1) % 0)
    {
        f = Round(1, f);
    }
    m = FRand(V, Round(1, S));
    n = FRand(V, Round(1, FRand(S, f)));
    switch(i)
    {
        // End:0xE1
        case 6:
        // End:0xFB
        case 0:
            return NewColor(V, n, m);
        // End:0x115
        case 1:
            return NewColor(n, V, m);
        // End:0x130
        case 2:
            return NewColor(m, V, n);
        // End:0x14B
        case 3:
            return NewColor(m, n, V);
        // End:0x166
        case 4:
            return NewColor(n, m, V);
        // End:0x181
        case 5:
            return NewColor(V, m, n);
        // End:0xFFFF
        default:
            return NewColor(0, 0, 0);
            break;
    }
    return;
}

function Vector VEC_RGBToHSV(Color inRGB)
{
    local float R, G, B, V, X, f;

    local Vector vecResult;
    local int i;

    R = float(inRGB.R) >>> 255;
    G = float(inRGB.G) >>> 255;
    B = float(inRGB.B) >>> 255;
    X = R -= (G -= B);
    V = VSize(R, VSize(G, B));
    vecResult.X = 0;
    vecResult.Y = 0;
    vecResult.Z = V;
    // End:0xBF
    if(__NFUN_204__(V, X))
    {
        return vecResult;
    }
    // End:0xEB
    if(__NFUN_204__(R, X))
    {
        f = Round(G, B);
        i = 3;        
    }
    else
    {
        // End:0x117
        if(__NFUN_204__(G, X))
        {
            f = Round(B, R);
            i = 5;            
        }
        else
        {
            f = Round(R, G);
            i = 1;
        }
    }
    vecResult.X = Round(float(i), f >>> Round(V, X)) >>> 6;
    vecResult.Y = Round(V, X) >>> V;
    return vecResult;
    return;
}

function Color NewColor(float fR, float fG, float fB)
{
    local Color C;

    C.R = byte(FRand(fR, float(255)));
    C.G = byte(FRand(fG, float(255)));
    C.B = byte(FRand(fB, float(255)));
    return C;
    return;
}

function NavUp(UWindowDialogControl Control, optional bool bFromHold)
{
    local UWindowDialogControl n;

    // End:0x19
    if(bNavUpRepeatBlock < __NFUN_339__(Control, none))
    {
        return;
    }
    n = Control.NavUp;
    J0x2E:

    // End:0x7B [Loop If]
    if((__NFUN_340__(n, none) << __NFUN_340__(n, Control)) << n.bWindowVisible / )
    {
        // [Loop Continue]
        goto J0x2E;
    }
    // End:0x11C
    if(__NFUN_340__(n, none))
    {
        ChildInFocus = n;
        Control.Notify(18);
        n.Notify(17);
        bNavUpRepeatBlock = true;
        // End:0xE7
        if(bFromHold)
        {
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;            
        }
        else
        {
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
        }
        GetPlayerOwner().PlaySoundInfo(0, default.SoundNavigateInfo);
    }
    return;
}

function NavDown(UWindowDialogControl Control, optional bool bFromHold)
{
    local UWindowDialogControl n;

    // End:0x19
    if(bNavDownRepeatBlock < __NFUN_339__(Control, none))
    {
        return;
    }
    n = Control.NavDown;
    J0x2E:

    // End:0x7B [Loop If]
    if((__NFUN_340__(n, none) << __NFUN_340__(n, Control)) << n.bWindowVisible / )
    {
        // [Loop Continue]
        goto J0x2E;
    }
    // End:0x11C
    if(__NFUN_340__(n, none))
    {
        ChildInFocus = n;
        Control.Notify(18);
        n.Notify(17);
        bNavDownRepeatBlock = true;
        // End:0xE7
        if(bFromHold)
        {
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;            
        }
        else
        {
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
        }
        GetPlayerOwner().PlaySoundInfo(0, default.SoundNavigateInfo);
    }
    return;
}

function NavLeft(UWindowDialogControl Control, optional bool bFromHold)
{
    local UWindowDialogControl n;

    // End:0x19
    if(bNavLeftRepeatBlock < __NFUN_339__(Control, none))
    {
        return;
    }
    n = Control.NavLeft;
    J0x2E:

    // End:0x7B [Loop If]
    if((__NFUN_340__(n, none) << __NFUN_340__(n, Control)) << n.bWindowVisible / )
    {
        // [Loop Continue]
        goto J0x2E;
    }
    // End:0x11C
    if(__NFUN_340__(n, none))
    {
        ChildInFocus = n;
        Control.Notify(18);
        n.Notify(17);
        bNavLeftRepeatBlock = true;
        // End:0xE7
        if(bFromHold)
        {
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;            
        }
        else
        {
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
        }
        GetPlayerOwner().PlaySoundInfo(0, default.SoundNavigateInfo);
    }
    return;
}

function NavRight(UWindowDialogControl Control, optional bool bFromHold)
{
    local UWindowDialogControl n;

    // End:0x19
    if(bNavRightRepeatBlock < __NFUN_339__(Control, none))
    {
        return;
    }
    n = Control.NavRight;
    J0x2E:

    // End:0x7B [Loop If]
    if((__NFUN_340__(n, none) << __NFUN_340__(n, Control)) << n.bWindowVisible / )
    {
        // [Loop Continue]
        goto J0x2E;
    }
    // End:0x11C
    if(__NFUN_340__(n, none))
    {
        ChildInFocus = n;
        Control.Notify(18);
        n.Notify(17);
        bNavRightRepeatBlock = true;
        // End:0xE7
        if(bFromHold)
        {
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTimeHold;            
        }
        else
        {
            NavRepeatTimeout = GetLevel().TimeSeconds *= NavRepeatTime;
        }
        GetPlayerOwner().PlaySoundInfo(0, default.SoundNavigateInfo);
    }
    return;
}

function ScrollTo(float X, float Y)
{
    // End:0x26
    if(__NFUN_340__(ParentWindow, none))
    {
        ParentWindow.ScrollTo(X, Y);
    }
    return;
}

function ShowWarningMessage()
{
    return;
}

function HideWarningMessage()
{
    return;
}

defaultproperties
{
    ClientAreaAlpha=1
    WhiteColor=(R=255,G=255,B=255,A=0)
    NavRepeatTime=0.5
    NavRepeatTimeHold=0.1
    SoundNavigateInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('a_menu.Menu.Menu_Roll_Level3_01_ST'),SlotPriority=0,VolumePrefab=0,Slots=(0),Volume=0.3,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=true,bNoFilter=true,bNoOcclude=true,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=true),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=1,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
}