/*******************************************************************************
 * AIActor generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AIActor extends BaseAI
    abstract
    native
    config
    collapsecategories
    dependson(AITarget)
    dependson(WeaponCfg)
    dependson(AIRelationshipMgr)
    dependson(AIAnimationControllerEx)
    dependson(AIInputDispatcher_Base)
    dependson(ScriptPlayer)
    dependson(Destructible_Armor)
    dependson(PopUpCfg)
    dependson(AIAnimHUD)
    dependson(AIActorFactoryManager)
    dependson(AIActorFactory)
    dependson(dnControl_FinishingMove)
    dependson(ScriptObj)
    dependson(ScriptMethod)
    dependson(ScriptMethod_PlayExplicitAnim)
    dependson(ScriptMethod_PlayTransientExplicitAnim)
    dependson(PointTracker);

const AI_LedgeRagdollK = 4.0f;
const AI_MaxTreeDepth = 50;
const AI_MaxTrailTime = 10.0f;
const AI_MaxAimYaw = 8000;
const AI_MaxAimPitch = 4000;
const AI_AimAccelK = 0.5f;
const AnimX_Mode_Init = 0;
const AnimX_Mode_Anim = 1;
const AnimX_Mode_AnimFacePos = 2;
const AnimX_Mode_AnimFaceActor = 3;
const AnimX_Mode_AnimFaceTarget = 4;
const AnimX_Mode_SyncGoto = 5;
const AnimX_Mode_SyncTurn = 6;
const AnimX_Mode_SyncWait = 7;
const AnimX_Mode_SyncAnim = 8;
const Fall_Mode_StartFall = 0;
const Fall_Mode_Fall = 1;
const Fall_Mode_Land = 2;
const GotoX_NoMaxSteps = -1;
const GotoX_DoorPauseTime = 0.6f;
const GotoX_StuckPercentage = 0.25f;
const GotoX_StuckThresholdPush = 0.5f;
const GotoX_StuckThresholdCollision = 1.0f;
const GotoX_StuckDynamicThreshold = 1.0f;
const Jump_Mode_None = 0;
const Jump_Mode_TakeOff = 1;
const Jump_Mode_Fall = 2;
const Jump_Mode_Land = 3;
const Jump_Mode_Stop = 4;
const JumpAttack_Mode_None = 0;
const JumpAttack_Mode_TakeOff = 1;
const JumpAttack_Mode_Fall = 2;
const JumpAttack_Mode_Attack = 3;
const JumpAttack_Mode_Land = 4;
const PlaceTripMine_Mode_None = 0;
const PlaceTripMine_Mode_Aim = 2;
const PlaceTripMine_Mode_Place = 3;
const PlaceTripMine_Mode_EndAim = 4;
const SelectWeapon_Mode_None = 0;
const SelectWeapon_Mode_Wait = 1;
const SelectWeapon_Mode_Holster = 2;
const SelectWeapon_Mode_Draw = 3;
const SelectWeapon_Mode_QuickSwitch = 4;
const SetAim_Mode_None = 0;
const SetAim_Mode_Wait = 1;
const SetAim_Mode_AimOn = 2;
const SetAim_Mode_AimOff = 3;
const SetFireMode_DefautAbortPeriod = 3.0f;
const SetFireMode_DefautFinishPeriod = 0.25f;
const DefaultWeaponAimDownTime = 0.35;
const DefaultWeaponAimDownTimeFast = 0.02;
const DefaultWeaponAimUpTime = 0.5;
const PreFireInterval = 0.2;
const PostFireInterval = 0.2;
const AimInterval = 0.7;

enum EAIWeaponClearShotType
{
    AIWeaponClearShot_NoCheck,
    AIWeaponClearShot_TargetVisible,
    AIWeaponClearShot_ClearTrace
};

struct STargetSlot
{
    var bool m_bUsed;
    var Actor m_aActor;
};

struct SBoneAim
{
    var() name BoneName;
    var float Yaw;
    var float Pitch;
    var() float Weight;
};

struct SBoneAimConstraints
{
    var int MinViewPitchOffset;
    var int MaxViewPitchOffset;
    var int IgnoreThresholdPitch;
    var int MinViewYawOffset;
    var int MaxViewYawOffset;
    var int IgnoreThresholdYaw;
    var float SmerpOn;
    var float SmerpOff;
    var float Acceleration;
    var float AccelerationReset;
    var float Velocity;
    var float VelocityReset;
};

struct SAimerTargetInfo
{
    var Engine.BaseAI.EAITargetType TargetType;
    var Actor TargetActor;
    var name TargetBoneName;
    var Vector TargetPos;
    var Engine.BaseAI.EAITarget TargetID;
    var float TargetExpiryTime;
    var string TargetInfID;
    var float ThresholdAngle;
    var float TrackRate;
    var bool RemoveIfBeyondConstraints;
    var name UpdatePosFuncName;
};

struct SAimerInfo
{
    var AIActor MyOwner;
    var name NotifyStateFuncName;
    var name NotifyLostFuncName;
    var name NotifyThresholdFuncName;
    var Engine.BaseAI.EAIAim CurrentState;
    var array<SAimerTargetInfo> TargetStack;
    var float AngleToTarget;
    var float DeltaAngleToTarget;
    var bool SolutionClamped;
    var bool UseWeaponAimFromPos;
};

struct SAIAnimController
{
    var Engine.BaseAI.EAIAnimController m_eFallback;
    var class<AIAnimationControllerEx> m_cClass;
    var AIAnimationControllerEx m_oController;
};

struct SAICurAnimController
{
    var Engine.BaseAI.EAIAnimController m_eFallback;
    var class<AIAnimationControllerEx> m_cClass;
    var AIAnimationControllerEx m_oController;
    var Engine.BaseAI.EAIAnimController m_eController;
};

struct SAIMessage
{
    var noexport Engine.BaseAI.EAIMessageType m_eType "Type of message.";
    var noexport Actor m_aFrom "Who the message came from.";
    var noexport Actor m_aSubject "Actor associated with this message.";
    var noexport int m_nData "Miscellaneous data.";
    var noexport float m_fTime "Time this message arrived.";
};

struct SAIHealthTrigger
{
    var() noexport float Health "When I am less than or equal to this health....";
    var() noexport deprecated name Event "I trigger this event...";
};

struct SAIInventoryInfo
{
    var() noexport Engine.BaseAI.EAIMount m_eMountType "To mount or not to mount.  Optional.  If not set, default for item type will be used.";
    var() noexport name m_fnMountBone "Bone this item mounts to.  Optional.  If not set, default for item type will be used.";
    var() noexport Vector m_vMountOffset "Offset from mount bone.  Optional.  If not set, default for item type will be used.";
    var() noexport Rotator m_rMountRotation "Rotation offset from mount bone.  Optional.  If not set, default for item type will be used.";
    var() noexport float m_fDrawScale "DrawScale of the attachment. Less than or equal to 0.0 is treated the same as 1.0";
    var() noexport name m_fnEquippedAnim "Animation to play when equipped.";
};

struct SAIInventorySpawnInfo
{
    var() noexport Engine.BaseAI.EAIInventory m_eInventoryType "Type of inventory to give the AI.";
    var() noexport bool m_bStartActivated "Start with this item activated.";
    var() noexport bool m_bStartEquipped "Start with this item equipped / mounted.";
    var() noexport bool m_bUseable "If TRUE, the AI can actually use this item... if FALSE, he's just holding it for Duke or something.";
    var() noexport SAIInventoryInfo m_Overrides "Options that you can override for an inventory item.";
    var Inventory m_aSpawnedItem;
};

struct SPathCache
{
    var bool Valid;
    var int Count;
    var Vector TargetPos;
    var Actor RefActor;
    var float ClipTolerance;
    var Vector NextPathPos;
    var int FinalDest;
    var Engine.BaseAI.EAIPathResult Result;
};

struct SAIDamageInfo
{
    var bool Valid;
    var Pawn Instigator;
    var float Damage;
    var Engine.Object.EPawnBodyPart Part;
    var class<DamageType> DamageType;
    var Vector pos;
    var Vector Dir;
    var float Time;
};

struct SAIDamageScale
{
    var class<Actor> QualifierClass;
    var float DamageScale;
    var array< class<DamageType> > QualifierDamageTypes;
    var array< class<DamageType> > QualifierNotDamageTypes;
};

struct SWeaponManager
{
    var Engine.BaseAI.EAIWeapManMode Mode;
    var class<Weapon> CurrentWeaponClass;
    var bool HoldFire;
    var float MinRange;
    var float MaxRange;
    var float IdealMinRange;
    var float IdealMaxRange;
    var int ReloadThresh;
    var int MinShots;
    var int RndShots;
    var float MinVolleyInterval;
    var float RndVolleyInterval;
    var Vector StandingFireOffset;
    var Vector CrouchingFireOffset;
    var Vector ProneFireOffset;
    var Vector PipeBombFireOffset;
    var int ShotsFired;
    var int ShotCount;
    var transient float Gate;
    var bool ForceFire;
    var bool NoFire;
    var bool ChargeWeapon;
    var float WeaponChargeTime;
    var transient float ScanGate;
    var transient float RefreshScanGate;
    var Rotator ScanRot;
    var Vector ScanTarget;
    var float ScanTrackRate;
    var float ActionPointDistance;
    var AIActor.EAIWeaponClearShotType ClearShotRequirement;
    var bool MeleeFrozenTargets;
};

struct SGuardInfo
{
    var bool CanGuard;
    var bool IsGuardingActor;
    var bool IsGuardingPos;
    var Actor GuardedActor;
    var Vector GuardedPos;
    var float InnerRange;
    var float OuterRange;
    var float BaseInnerRange;
    var float BaseOuterRange;
    var bool bDontScaleRangeWithDrawScale;
    var bool AlignWith;
    var float AlignmentOffset;
    var float AbortRange;
    var bool MustBeVisible;
    var bool AllowAvoidDanger;
    var bool AllowDodge;
    var bool bStaticGuardHack;
    var bool bAvoidGuardedPlayer;
};

struct PopUpInfo
{
    var() array<PopUpCfg> Entrys;
    var() int PrimaryChoices;
    var() int IdealAngle;
};

struct SPopUpState
{
    var() float DamageTaken;
    var() bool bWaitCompromised;
    var() bool bForceHoldStop;
    var() int ShotsFired;
};

struct SMoveInfo
{
    var Vector Disp;
};

struct STargetEvalInfo
{
    var AIActor MyOwner;
    var transient float EvalGate;
    var float EvalInterval;
    var bool Suspended;
    var bool bSuspendedWithNoTarget;
    var Engine.BaseAI.EAITargetEval Evaluator;
    var bool ForceUpdate;
    var bool MustBePawn;
    var bool MustBeSighted;
    var bool MustBeReachable;
    var bool CanTargetProjectiles;
    var bool CanAvoidTargetableProjectiles;
    var Actor LastTarget;
    var float LastTargetEndTime;
};

struct AITransition
{
    var() name Ident;
    var() Engine.BaseAI.EAICondition Cond;
    var() name Func;
    var() Engine.BaseAI.EAIWindow Win;
    var() Engine.BaseAI.EAICode Code;
    var private int StateTableIndex;
};

struct AITransitionAction
{
    var() AITransition Transition;
    var() Engine.BaseAI.EAICode Code;
    var() name State;
    var() name Node;
};

struct AIState
{
    var() name FSM;
    var() name Ident;
    var() bool FSMSucc;
    var() bool FSMFail;
    var() array<AITransition> Transitions;
    var private int NodeIndex;
};

struct AINode
{
    var() name Ident;
    var private Engine.BaseAI.EAINodeStatus Status;
    var private bool ReportedInvalid;
    var() Engine.BaseAI.EAICondition SucCond;
    var() name SucFunc;
    var() Engine.BaseAI.EAICondition FailCond;
    var() name FailFunc;
    var() Engine.BaseAI.EAIOp Op;
    var private int OpRef;
    var() array<AITransition> SharedTransitions;
    var array<int> StateTable;
    var private int CurStateIndex;
};

struct SAnimX
{
    var name AnimName;
    var bool UseExactAnimName;
    var int RefId;
    var Engine.BaseAI.EAITargetType TargetType;
    var Actor TargetActor;
    var Vector TargetFacePos;
    var Vector TargetSyncPos;
    var AIActor TargetSyncActor;
    var float FaceThreshold;
    var float ExitTime;
    var bool FullAnim;
    var bool Sync;
    var bool SyncActor;
    var name SyncWaitAnimName;
    var bool FinishAlone;
    var bool MustFinish;
    var int Mode;
    var int TurnDir;
    var bool bExitOnLand;
    var bool bSucceedOnFail;
};

struct SMultiAnimInfo
{
    var() int AnimIndex;
    var() float MinTime;
    var() float RndTime;
    var() float Gate;
    var() float MinInterval;
    var() bool RequireLOS;
    var() bool RequireLOSFromWeapon;
    var() bool FaceTarget;
    var() name AnimName;
};

struct SControlX
{
    var class<dnControl> ControlType;
    var dnControl MyControl;
    var name AnimName;
    var float Time;
    var bool IsControlled;
    var bool DieOnTakeDamage;
    var bool AssumeCanFit;
};

struct SFall
{
    var int Mode;
    var float LandingThresh;
    var float HeavyLandingThresh;
    var float StartZ;
    var int RefId;
    var int AnimSet;
    var bool ToggleIK;
};

struct SGotoX
{
    var Engine.BaseAI.EAITargetType TargetType;
    var Actor TargetActor;
    var Vector TargetPos;
    var Actor RefActor;
    var Vector NextPos;
    var int FinalDest;
    var Engine.BaseAI.EAIOffsetType OffsetType;
    var float Range;
    var float Bearing;
    var float Height;
    var float ClipTolerance;
    var Engine.BaseAI.EAIMoveSpeed Speed;
    var float SpeedScale;
    var Engine.BaseAI.EAIFocus Focus;
    var Actor FocusActor;
    var Vector FacePos;
    var int RefId;
    var Engine.BaseAI.EAIGotoXMode Mode;
    var float SideArcTurnSpeedThresh;
    var float StepBackwardsSpeedThresh;
    var float StartAngleSideSector;
    var float StartAngleBackSector;
    var float MoveBackwardsDistThresh;
    var float SideStepDistThresh;
    var int MaxSteps;
    var bool PreVerified;
    var int TurnDir;
    var DoorMoverEx MyDoorEx;
    var bool ForceEval;
    var bool ForceAnim;
    var transient float AnimChangeGate;
    var float StuckTime;
    var transient float Gate;
    var bool bStopToTurn;
    var transient float EvalGate;
    var transient float EvalGateTime;
    var int EvalCount;
    var bool bDisableEvalGate;
    var float ConstraintStrengthOverride;
    var Engine.BaseAI.EAIPathFailMode PathFailMode;
    var bool bWaitingOnDynamicBlocker;
    var float bWaitTime;
    var Vector TargetExtent;
    var bool bDebug;
    var float FlyConstraintStrength;
    var bool bUseAccelerationWhenFlying;
    var bool ExitOnLand;
    var float ExitOnLandHeight;
    var Engine.Object.EBitModifier UseAnimDispDirMod;
};

struct SAIPhysics
{
    var bool bDebug;
    var float AccelRateEx;
    var float SlowAccelRateEx;
    var float AirControlEx;
    var float SlowSpeedScale;
    var float VertAccelRateEx;
    var bool bDisableGroundFinder;
    var float MaxSpeed;
    var float MaxSpeedDamping;
    var float MaxSpeedOtherDir;
    var float MaxSpeedOtherDirDamping;
    var bool bDisablePhysicsConstraints;
};

struct STeleport
{
    var Vector Destination;
    var Rotator DestinationRotation;
    var class<SoftParticleSystem> StartParticleSystem;
    var class<SoftParticleSystem> EndParticleSystem;
    var Weapon_LightEx StartLight;
    var Weapon_LightEx EndLight;
    var name StartSound;
    var name EndSound;
    var ActionPoint EndActionPoint;
    var name StartAnimName;
    var name EndAnimName;
    var MaterialEx StartOverlay;
    var bool bFaceTarget;
    var bool bValid;
    var int Mode;
    var float MinTeleportDist;
    var float MaxTeleportDist;
    var float Delay;
    var bool bCantDie;
    var bool bForceLandOnFinish;
    var bool bForceJetpackOnFinish;
    var bool bSkipStartEffects;
};

struct SRappel
{
    var() name StartAnimName;
    var() name IdleAnimName;
    var() name EndAnimName;
    var() name BoneName;
    var() float GravityScale;
    var bool bOverrideAttachToInfo;
    var Actor AttachToActor;
    var name AttachToBone;
    var class<BeamSystem> BeamSystemClass;
    var BeamSystem MyBeamSystem;
    var int Mode;
};

struct SFreeMove
{
    var Engine.BaseAI.EAIFreeMoveMode Mode;
    var float MinDotToTarget;
    var float MaxDotToTarget;
    var float ExitTime;
    var Vector FreeMoveTarget;
    var float FreeMoveVelocity;
    var float FreeMoveMaxVelocity;
    var float StoppingRate;
    var float StoppingRestitution;
    var Vector startLocation;
};

struct SHaywire
{
    var() bool bAllowHaywire;
    var() float MinTime;
    var() float MaxTime;
    var() Vector LinearAccel;
    var() Vector AngularAccel;
    var() float HaywireStartTime;
    var() float MinTimeToExplode;
    var() float ChanceExplosion;
    var() float HurtRadiusDamage;
    var() float DamageRadius;
    var() float DamageRadiusFallOffStart;
    var() class<dnFriendFX_Spawners> ExplosionClass;
    var() class<LightEx> ExplosionLight;
    var() name ExplosionSoundName;
    var() Vector HitNormal;
};

struct SCharge
{
    var() Vector ChargeDir;
    var() Vector ChargeTarget;
    var() float ChargeStartTime;
    var float CoolDownStartSpeed;
    var() float StartVelocity;
    var() float MaxVelocity;
    var() float ReturnVelocity;
    var() float RampUpTime;
    var() float CoolDownTime;
    var() bool RequireLOS;
    var() Engine.BaseAI.EAIChargeState ChargeState;
    var() float ConstraintStrength;
};

struct STakeOff
{
    var Vector TakeOffVel;
    var float TakeOffIdleTime;
    var float TakeOffIdleTimeRnd;
    var float GravityScale;
    var float IdealTakeOffHeight;
    var Vector IdealTakeOffVel;
    var bool AllowFire;
    var Vector TakeOffTarget;
};

struct SHover
{
    var float MinHoverTime;
    var float RndHoverTime;
};

struct SIdle
{
    var float MinIdleTime;
    var float RndIdleTime;
    var bool bFaceTarget;
    var name AnimName;
};

struct SAIAmbientSoundInfo
{
    var() bool bDebug;
    var() float TargetAquiredMinInterval;
    var() float NoTargetIdleInterval;
    var() float NoTargetIdleRnd;
    var() float BattleIdleInterval;
    var() float BattleIdleRnd;
    var name TargetAquiredSoundName;
    var name TargetLostSoundName;
    var name NoTargetSoundName;
    var name TargetVisibleSoundName;
    var name TargetNotVisibleSoundName;
};

struct SJump
{
    var int Mode;
    var Vector JumpVel;
    var float HeavyLandingThresh;
    var bool AppliedJumpVel;
    var float StartZ;
    var int RefId;
    var int AnimSet;
    var Vector FrameVelocity;
    var bool bDisableIK;
    var bool bRestoreIKPreLand;
    var float ExitTime;
    var Engine.BaseAI.EAIJumpType JumpType;
    var bool FaceTarget;
    var Actor FocusActor;
    var bool AutoPitch;
    var float PitchRate;
    var float PitchRateLand;
    var float MaxPitch;
    var float MaxVelocity;
    var bool bDebug;
    var bool bTakeOffNoLand;
    var float TakeOffIdleTime;
    var float FlyingGravityScale;
    var Vector TargetPos;
    var bool bCheckTargetPos;
    var bool bUseAccelaration;
    var float AccelerationScale;
    var Vector Fudge;
    var bool bSnapToTargetDuringLand;
    var bool bRequireCompleteSnap;
    var bool bSnapActive;
    var bool bLandAnimComplete;
    var float StopLinearDamping;
    var bool bAllowProcFireDuringFall;
};

struct SJumpAttack
{
    var Actor TargetActor;
    var int Mode;
    var int Type;
    var bool AttackOnTakeoff;
    var bool Attacked;
    var bool AttackSuccess;
    var bool AppliedJumpVel;
    var int RefId;
    var Vector FrameVelocity;
    var bool bCanJumpAttackShrunkTarget;
    var float ShrunkTargetHeightScale;
    var float ShrunkTargetDistanceScale;
    var transient float Gate;
    var() float MinInterval;
    var float GroundFinderGate;
    var float GroundFinderInterval;
    var Vector PresetFrameVelocity;
    var Vector DefaultPresetFrameVelocity;
    var Engine.BaseAI.EAIJumpAttackType JumpAttackType;
    var float ParabolaJumpHeight;
    var float ParabolaMinJumpHeight;
    var float ParabolaMaxJumpHeight;
    var float GroundFinderLockout;
    var bool bInstantJump;
    var bool bUsePresetVelocity;
    var bool bCheckClearShot;
    var bool bCheckHasPath;
    var bool bCheckClearPath;
    var bool bDontApplyDirectDamage;
    var bool bDisabled;
};

struct SDodgeInfo
{
    var name AnimName;
    var Vector PhysicsFrameVelocity;
    var Engine.BaseAI.EAIDodgeType DodgeType;
};

struct SStompInfo
{
    var() noexport float StompRadius "The range at which we attempt to stomp. Should be slightly larger than StompDamageRadius";
    var() name AnimName;
    var() name BoneName;
    var() float StompDamageAmount;
    var() float StompDamageRadius;
    var() float StompDamageVel;
    var() float StompDamageLift;
    var() bool bDebug;
    var() noexport float SafeHeight "If we are this many units height than where the stomp happens, we dont take damage";
    var() noexport bool bCanStompShrunk "Can we stomp full sized pawns?";
    var() SViewShakeInfo ShakeInfo;
    var() float ShakeRadius;
    var() class<dnFriendFX_Spawners> ParticleEffectClass;
    var() array<name> AdditionalEffectBones;
    var Vector StompLocation;
    var() bool bDontFaceTarget;
    var() bool bLightRumbleOnDamage;
};

struct SStubToeInfo
{
    var() bool bDebug;
    var() bool bEnabled;
    var() name AnimName;
    var() bool bBerzerkAfterStub;
    var() bool bDropWeapon;
    var() float MinImpactVelocity;
    var() noexport float MinToeStubInterval "How much time must pass between subsequent toe stubs.";
    var float ToeStubGate;
};

struct SMoveUnderground
{
    var Vector DestLocation;
    var Rotator DestRotation;
    var float StartTime;
    var float Duration;
};

struct SPause
{
    var float Time;
    var bool EndOnHeadAim;
    var bool EndOnEyeAim;
};

struct SPlaceTripMine
{
    var Actor TargetActor;
    var int Mode;
    var bool ResumeLookEval;
};

struct SSelectWeapon
{
    var class<Weapon> NewWeaponClass;
    var bool QuickSwitch;
    var int Mode;
    var int RefId;
};

struct SSetAim
{
    var Engine.BaseAI.EAIAim DesiredState;
    var int Mode;
    var float Time;
};

struct SSetFireMode
{
    var bool On;
    var bool Expedite;
    var float AbortTime;
    var float FinishTime;
    var bool Done;
    var bool DontIdle;
};

struct STurnToX
{
    var float ExitTime;
    var Engine.BaseAI.EAITargetType TargetType;
    var Actor TargetActor;
    var Vector TargetPos;
    var float FaceThreshold;
    var int TurnDir;
    var float AnimThreshold;
    var bool PlayTurnAnim;
};

struct SUseXItemInfo
{
    var() name ItemTag;
    var() name InputDipstacherTag;
    var AIInputDispatcher_Base InputDispatcher;
    var dnUsableSomething Item;
};

struct SUseX
{
    var InteractiveActor TargetActor;
    var AIInputDispatcher_Base InputDispatcher;
    var name AttachedEvent;
    var int Attempts;
    var float AttemptInterval;
    var bool Using;
    var bool ForceAttach;
    var int RefId;
    var bool AllowProceduralAim;
    var bool bAttached;
    var bool bDetaching;
};

struct SAnimPreset
{
    var Engine.BaseAI.EAIAnimXType AnimType;
    var name AnimName;
    var bool UseExactAnimName;
    var float ExitTime;
    var Actor TargetActor;
    var Vector TargetPos;
    var float FaceThreshold;
};

struct SGotoPreset
{
    var Engine.BaseAI.EAITargetType TargetType;
    var Actor TargetActor;
    var Vector TargetPos;
    var Actor RefActor;
    var Engine.BaseAI.EAIOffsetType OffsetType;
    var float Range;
    var float Bearing;
    var float Height;
    var float ClipTolerance;
    var Engine.BaseAI.EAIFocus Focus;
    var Actor FocusActor;
    var int MaxSteps;
    var bool bDebug;
};

struct STripMinePreset
{
    var Actor TargetActor;
};

struct STurnToPreset
{
    var Engine.BaseAI.EAITargetType TargetType;
    var Actor TargetActor;
    var Vector TargetPos;
    var float ShouldTurnThresh;
    var float FaceThresh;
};

struct SWeaponPreset
{
    var() class<Weapon> WeaponType;
};

struct SUsePreset
{
    var Actor TargetActor;
    var name InputDispatcherTag;
    var name AttachedEvent;
    var int Attempts;
    var float AttemptInterval;
    var bool ForceAttach;
    var bool AllowProceduralAim;
};

struct SAbortScriptInfo
{
    var SAbortScriptMotive_SeeActor MotiveSeeActor;
    var SAbortScriptMotive_HearSound MotiveHearSound;
    var SAbortScriptMotive_Damaged MotiveDamaged;
    var SAbortScriptMotive_Bumped MotiveBumped;
    var SAbortScriptMotive_Triggered MotiveTriggered;
    var SAbortScriptMotive_Shrunk MotiveShrunk;
    var bool ShouldAbort;
    var int EgoChange;
    var name OtherActorTag;
    var name AbortEvent;
    var noexport bool bUseAbortEventStuck "Set to true and we will use AbortEventStuck when stuck. if false, stuck aborts just fire off AbortEvents like normal";
    var noexport name AbortEventStuck "An event to trigger if I abort because I was stuck. If none we will still fire AbortEvent if stuck";
    var bool ChangeScriptTag;
    var name ChangedScriptTag;
    var bool KeepProp;
    var bool CanFall;
    var noexport bool PlayPainDontAbort "If true we will play pain animations BUT WONT ABORT the script. If false we wont pain. If true we will. Either way we will only abort if MotiveDamage is met";
};

struct SAISquadChannel
{
    var() noexport name ChannelName "Name of channel we are communicating on";
    var() noexport float MaxDistance "Max distance between AI for squad communication to work. 0 = no max distance";
};

struct SDroolInfo
{
    var() float MinSpitTime;
    var() float RndSpitTime;
    var() float SpitOnPainChance;
    var() name Bone;
    var() Vector Location;
    var() Rotator Rotation;
    var() class<dnFriendFX_Spawners> SpawnClass;
};

struct SAIRangeInfo
{
    var() noexport float ActionPointClosestMaxTravelDist "How far are we willing to go when wanting to go to closest action point";
    var() noexport float ActionPointClosestMaxTargetDist "Max distance we are willing to be from target when going to an AP";
    var() noexport float ActionPointClosestJumpableMaxTravelDist "How far are we willing to go when wanting to go to closest action point";
    var() noexport float ActionPointClosestFlyerMaxTravelDist "How far are we willing to go when wanting to go to closest action point";
};

struct SAIShrunkInfo
{
    var() bool bRunFromBiggerEnemies;
    var() float MinSafeDistanceFromBigEnemy;
};

struct SAIPerformanceInfo
{
    var() array<float> TickTime;
    var float TickTimeLastFrame;
    var float PathTimeLastFrame;
    var float ProcAimTimeLastFrame;
    var bool SetLocation;
    var bool ExecuteDecisionTree;
    var int Cycles;
    var float Path_PreStaticPath;
    var float Path_PostStaticPath;
    var float Path_GenerateStaticPath;
    var float Path_FinalizeNextPathPos;
};

struct SDeathImpulseInfo
{
    var bool bDebug;
    var bool bEnabled;
    var Vector ImpulseMag;
    var bool bImpulseRelativeToActorRotation;
};

struct SGotoXHistory
{
    var SGotoX GotoXParms;
    var Vector Location;
    var Rotator Rotation;
    var Engine.BaseAI.EAICode Code;
    var float Timestamp;
};

struct SAIDebugMessage
{
    var string msg;
    var Color C;
    var float TimeExpire;
};

struct SPathingHistory
{
    var Vector Location;
    var Rotator Rotation;
    var Vector Destination;
    var Vector NextPosition;
    var int FinalDest;
    var float Time;
    var Engine.BaseAI.EAIPathResult Result;
    var bool bActorWasInValidArea;
    var SPathInfo PathInfo;
};

struct SScriptFailInfo
{
    var name AIState;
    var Engine.BaseAI.EAIOp AIOP;
    var ScriptMethod ScriptMethod;
    var string ScriptMethodStr;
    var float Timestamp;
};

struct SEyeAimInfo
{
    var name BoneName;
    var Vector Alignment;
    var float MaxAngleOffset;
};

var Vector DisplacementLastFrame;
var Vector LocationLastFrame;
var(AIMesh) array<Mesh> OverrideMeshList;
var(AIMesh) Mesh OverrideMesh;
var array<Color> RandomActorColor;
var name RandomActorColorGroupID;
var bool MountLightEx;
var class<LightEx> MountedLightExClass;
var SMountedActorPrefab MountedLightExMountPrefab;
var() LightEx MountedLightEx;
var array<SPathCache> PathCache;
var bool AllowFrozenExecution;
var SAIDamageInfo DamageInfo;
var(AIDamage) array<SAIDamageScale> DamageScaleInfo;
var private Engine.BaseAI.EAIExecutive Executive;
var private bool ExecutiveSuspended;
var(AIBrain) transient float DecisionTreeGate;
var(AIBrain) float DecisionTreeInterval;
var(AIBrain) array<AINode> Nodes;
var(AIBrain) array<AIState> FSMStates;
var(AIBrain) array<AITransitionAction> TransitionHistory;
var(AIBrain) array<string> StateEndMessages;
var SAISquadChannel SquadChannel;
var Engine.BaseAI.EAIOp CurrentOp;
var private int CurrentOpRef;
var private Engine.BaseAI.EAIOpStatus CurrentOpStatus;
var bool CurrentOpMustFinish;
var bool CurrentOpShouldFinish;
var int CurrentOpMode;
var Engine.Object.EPawnBodyPart WoundedBodyPart;
var Engine.BaseAI.EAIArcSector WoundedBodySector;
var Engine.BaseAI.EAIAnimController PostOpAnimCtrl;
var noexport bool CanSeeTargets "Can see targets?";
var noexport bool CanHearTargets "Can hear targets? (see also bCanHear)";
var noexport float ClearTargetTime "If time since contact with a traget exceeds this threhold, the target is cleared.";
var noexport float TargetVisTestInt "Interval between visibility tests.";
var float SightCounter;
var bool HasWeaponTargetEvaluator;
var STargetEvalInfo WeaponTargetEvalInfo;
var TargetEvaluator WeaponTargetEvaluator;
var float WeaponConeAngle;
var float PlayerHate;
var(AIBehavior) float MinPlayerHate;
var(AIBehavior) float MaxPlayerHate;
var(AIBehavior) float PlayerHateRecoverRate;
var bool HasLookTargetEvaluator;
var STargetEvalInfo LookTargetEvalInfo;
var TargetEvaluator LookTargetEvaluator;
var float LookConeAngle;
var private string BaseLookTargetString;
var private string GlanceLookTargetString;
var float MinGlanceTime;
var float RndGlanceTime;
var float SameGlanceTargetInterval;
var float ChanceTryGlanceAgain;
var float MinGlanceRest;
var float RndGlanceRest;
var array<STargetSlot> TargetActors;
var(AITarget) AITarget PrimaryTarget;
var(AITarget) Actor PrimaryTargetActor;
var(AITarget) AITarget FollowTarget;
var(AITarget) Actor FollowTargetActor;
var(AIDebug) bool DebugDrawLOS;
var(AICache) float CachedLOSDistance;
var(AICache) float CachedWeaponLOSDistance;
var(AICache) float CachedProjectileLOSDistance;
var SAimerInfo WeaponAimerInfo;
var SAimerInfo MuzzleAimerInfo;
var SAimerInfo HeadAimerInfo;
var private Aimer WeaponAimer;
var private Aimer HeadAimer;
var float WeaponTrackRate;
var float HeadTrackRate;
var private float ShootAngleThresh;
var private bool InShootAngleThresh;
var private bool EndStateOnWeaponTargetLost;
var private bool EndStateOnWeaponTargetInThresh;
var private bool EndStateOnLookTargetLost;
var private bool EndStateOnLookTargetInThresh;
var bool bSpecialMeshAccurateLOSChecks;
var(AIWeapons) noexport bool HasWeaponManager "True if this AI needs to handle weapons.";
var(AIWeapons) SWeaponManager WeaponManager;
var class<WeaponCfg> WeaponConfig;
var(AIWeapons) noexport array< class<Weapon> > Weapons "List of weapon to startup with.";
var(AIWeapons) noexport array< class<Weapon> > RandomWeapons "Optional list of weapons.  If non-zero, one will be randomly chosen to be added to the weapons list.";
var(AIWeapons) noexport bool SpawnWithWeaponDrawn "Spawn with a weapon already in hands?";
var(AIWeapons) noexport bool ForceWeaponActive "Consider weapon to always be active?";
var(AIWeapons) noexport class<Weapon> InitialWeapon "Optional weapon to be held on startup.";
var class<Pistol> PistolClass;
var(AIWeapons) noexport float WpnSteadyHorizError "Weapons Horizontal error when stationary (unreal rotator units)";
var(AIWeapons) noexport float WpnSteadyVertError "Weapons Vertical error when stationary (unreal rotator units)";
var(AIWeapons) noexport float WpnMovingHorizError "Weapons Horizontal error when moving (unreal rotator units)";
var(AIWeapons) noexport float WpnMovingVertError "Weapons Vertical error when moving (unreal rotator units)";
var noexport float LeadTimeK "If non-zero, we will lead the target by this ratio (1.0 means intercept, 2.0 would overshoot by the intercept distance, 0.5 would undershoot.)";
var bool ForceDirectShot;
var bool ForceNonDirectShot;
var float AimAtTargetTimeThresh;
var bool CanScan;
var(AIWeapons) float MinWeaponScanTrackRate;
var(AIWeapons) float RndWeaponScanTrackRate;
var(AIWeapons) float LookTrackRateK;
var(AIWeapons) float MinScanInterval;
var(AIWeapons) float RndScanInterval;
var(AIWeapons) float MinScanDuration;
var(AIWeapons) float RndScanDuration;
var(AIWeapons) float MinScanRefreshTime;
var(AIWeapons) float RndScanRefreshTime;
var(AIWeapons) int MinScanPitch;
var(AIWeapons) int MaxScanPitch;
var(AIWeapons) int MinScanYaw;
var(AIWeapons) int MaxScanYaw;
var(AIWeapons) noexport int NumPipeBombs "Set to -ve for an infinite supply.";
var(AIWeapons) noexport float MinPipeBombInterval "Minimum time that must pass between pipebomb attacks.";
var(AIWeapons) class<dnGrenade> PipeBombClass;
var dnGrenade MyPipeBomb;
var Vector PipeBombVel;
var name RightHandPipebombMount;
var name LeftHandPipebombMount;
var int NumPipeBombBeeps;
var(AIPipeBomb) float MinPipeBombTime;
var(AIPipeBomb) float MaxPipeBombTime;
var(AIPipeBomb) float MinHorizDistPipeBomb;
var(AIPipeBomb) float MaxHorizDistPipeBomb;
var(AIPipeBomb) float MinVertDistPipeBomb;
var(AIPipeBomb) float MaxVertDistPipeBomb;
var(AIPipeBomb) float MinPipeBombArcHeight;
var(AIPipeBomb) float MaxPipeBombArcHeight;
var(AIPipeBomb) float PipeBombChance;
var transient float PipeBombGate;
var bool bIgnoreTripMines;
var array<LaserMine> TripMines;
var float MinTargetVisibleTime;
var(AIWeapons) bool bDisableWeaponDrops;
var(AIWeapons) bool bAllowWeaponDropsPlayerNotSameSize;
var SGuardInfo GuardInf;
var() array<PopUpInfo> Popups;
var PopUpCfg PopUp;
var SPopUpState PopUpState;
var bool bNoWeaponChargePopUp;
var private transient float BlindFireGate;
var(AIBehavior) noexport bool UseActionPoints "Does this actor use action points?";
var(AIBehavior) noexport array<name> ActionPointTags "We can only use action points that have this tag";
var noexport float ChanceStayAtActionPoint "DEPRECATED";
var noexport int ActionPointIndex "DEPRECATED";
var noexport int ActionPointDesiredIndex "DEPRECATED";
var array<ActionPoint> ActionPoints;
var array<ActionPoint> ReloadActionPoints;
var ActionPoint ReloadActionPoint;
var ActionPoint NextActionPoint;
var float ActionPointMeleeK;
var ActionPoint ActionPoint;
var Vector ActionPointUserLoc;
var bool PreShrinkUseActionPoints;
var ActionPoint LastActionPoint;
var name LastActionPointGroup;
var(AIUse) noexport bool UseActionFollow "If true, this AI can be *used* to make it follow / stop follow.";
var bool FaceAnims;
var noexport float MinBlinkTime "Minimum time between blinks.";
var noexport float MaxBlinkTime "Maximum time between blinks.";
var noexport int NumEyeSets "How many sets of eyes?";
var anim name EyesClosedAnim;
var noexport array<SEyeAimInfo> EyeAimInfos "A list of eye bones used for aiming.";
var Vector RollForwardInfo;
var Vector RollLeftInfo;
var Vector RollRightInfo;
var float RollTime;
var Engine.BaseAI.EAICloaking Cloaking;
var float CloakValue;
var float CloakRate;
var MaterialEx CloakMaterial;
var bool HasTKShield;
var int TKShieldCollisionRadius;
var int TKShieldCollisionHeight;
var Actor TKShield;
var InteractiveActor TKObj;
var Vector TKObjVel;
var int TKCatchAnim;
var int NumSecondaryTKCatchAnims;
var array<name> TKIgnoreClasses;
var float MaxTKDistance;
var float MinTKDot;
var bool bForceTK;
var InteractiveActor DesiredProp;
var InteractiveActor Prop;
var(AIThrowProp) name ThrowPropTag;
var bool CanAnimHurl;
var float PickupItemRange;
var AIRelationshipMgr RelationshipMgr;
var array<SRelationship> Relations;
var(AIRelationships) noexport array<SRelationship> Relationships "Relationships to other characters.";
var(AIRelationships) noexport array<SRelationship> m_RelationOverrides "How this creature reacts to other classes.";
var bool bUseNormalPhysicsRotation;
var bool UseLatentMovement;
var bool UseTurnAnimRot;
var const float DecelerationDist;
var const float DesiredSpeed;
var float AIBaseMoveSpeed;
var bool ZeroMoveSpeed;
var bool ZeroMoveSpeedEnabled;
var bool bDampenSpeedWhileTurning;
var bool AutoRollWhileTurning;
var float AutoRollRate;
var float AutoUnrollRate;
var bool AutoPitchWhileTurning;
var float AutoPitchRate;
var float AutoUnPitchRate;
var Vector LocalUp;
var Rotator DesiredDir;
var bool DisablePhysics;
var bool bUseAnimDispSpeed;
var bool bUseAnimDispDir;
var bool bUseAnimRotation;
var bool bAnimCutScene;
var bool bApplyAnimCutSceneVelocity;
var Vector AnimCutSceneVelocity;
var bool bUseAcceleration;
var bool SavedUseAnimDispSpeed;
var bool SavedUseAnimDispDir;
var bool SavedUseAnimRotation;
var bool SavedAnimCutScene;
var bool SavedUseAcceleration;
var PointTracker BodyTargetTracker;
var float BodyAlignRate;
var float BodyAlignRateFlying;
var float BodyAlignThresh;
var float BodyAlignScale;
var bool AlignYaw;
var bool AlignPitch;
var float AirSpeedScale;
var float GroundSpeedScale;
var float AnimDispSpeedScale;
var bool bIgnoreZAnimDisp;
var bool bUseWeaponMovementAnims;
var bool bUseWeaponIdle;
var bool bWeaponActiveAnimsActive;
var bool bUseWeaponReadyIdle;
var bool AimAtEye;
var bool bTryBackupPathingOnFailure;
var float NextBackupPathingTime;
var float BackupPathingCooldown;
var Vector AIAdditiveVelocity;
var float InstaGibRandomImpulse;
var SAnimPreset AnimPreset;
var SGotoPreset GotoPreset;
var SJumpPreset JumpPreset;
var STripMinePreset TripMinePreset;
var STurnToPreset TurnToPreset;
var SWeaponPreset WeaponPreset;
var SUsePreset UsePreset;
var(AIBehavior) array<SIdle> IdleInfo;
var(AISound) SAIAmbientSoundInfo AmbientSoundInfo;
var ScriptPlayer ScriptPlayer;
var SAbortScriptInfo AbortScriptInfo;
var(AIScripts) noexport ScriptObj SpawnScript "Script to play when this AI spawns.";
var(AIScripts) noexport name ScriptTag "If this is set the AI will attempt to trigger it when under nomral AI control.  Use this in conjunction with dispatchers and script triggers to play scripts on the AI.";
var(AIScripts) noexport name UsedScriptTag "If this is set the AI will attempt to trigger it when the player uses this actor.";
var float LastScriptLoopTime;
var bool bFailedBecauseStuck;
var(AIEvents) noexport name TargetAquiredEvent "This is fired every time we aquire a valid target.";
var(AIEvents) noexport name TargetClearedEvent "This is fired every time we clear our target.";
var float NextMessageTime;
var array<SAIMessage> MessageQueue;
var(AIAnim) Engine.BaseAI.EAIAnimController InitialAnimController;
var SAIAnimController AnimControllers[10];
var SAICurAnimController AnimCtrl;
var SAnimX AnimXParms;
var SControlX ControlXParms;
var SFall FallParms;
var(AIBehavior) SGotoX GotoXParms;
var(AIBehavior) SFreeMove FreeMoveParms;
var(AIBehavior) SHaywire HaywireParms;
var(AIBehavior) SJump JumpParms;
var(AIBehavior) STakeOff TakeOffParms;
var(AIBehavior) SJumpAttack JumpAttackParms;
var(AIBehavior) SCharge ChargeParms;
var(AIBehavior) SDroolInfo DroolParms;
var(AIBehavior) SHover HoverParms;
var(AIBehavior) SAIRangeInfo RangeParms;
var(AIBehavior) SAIPhysics PhysicsParms;
var(AIBehavior) SAIShrunkInfo ShrunkParms;
var(AIBehavior) array<SMultiAnimInfo> MultiAnimParms;
var() int MultiAnimIndex;
var() int MultiAnimMode;
var SMoveUnderground MoveUndergroundParms;
var SPause PauseParms;
var SPlaceTripMine PlaceTripMineParms;
var SSelectWeapon SelectWeaponParms;
var SSetAim SetAimParms;
var SSetFireMode SetFireModeParms;
var STurnToX TurnToXParms;
var SUseX UseXParms;
var(AIBehavior) STeleport TeleportParms;
var(AIBehavior) SRappel RappelParms;
var(AIBehavior) array<SUseXItemInfo> UseableItems;
var AIActorFactory Factory;
var AIActorFactoryManager FactoryManager;
var name SpawnAnimSeq;
var name SpawnAnim;
var private name InitAnim;
var ScriptTrigger LastScriptTrigger;
var(AIDamage) noexport bool Invulnerable "If true, the AI's health cannot be modified.";
var(AIDeath) noexport bool bPlayDeathSound "If true, AI will play death sound.";
var(AIDeath) noexport float LedgeDistOverride "If > 0, this overrides the default distance that we look for a ledge to fall over when we die.";
var(AIDeath) noexport float SizeLedgeImpulse "Magnitude of the Impulse to give towards the nearest ledge if applicable.  If <= 0 just do normal death impusle.  3000 is a suggested value to try.";
var bool DieOnExitState;
var transient float PainOpGate;
var bool ShowPain;
var bool bHackNoDeathAnim;
var(AIDeath) float DeathAnimChance;
var(AIDeath) float ThrownObjectDeathAnimChance;
var class<dnControl> FinishMeControlType;
var name FinishMeAnimName;
var name FinishMeReviveAnimName;
var float FinishMeTimeout;
var bool FaceDamage;
var bool FaceDeath;
var bool WasExecuted;
var SDeathImpulseInfo DeathImpulseOverride;
var bool bDisableCorpseCleanup;
var bool bFixCorpseRoot;
var(AIDeath) SSoundInfo ExpandPopSound;
var Pawn ExpandInstigator;
var(AIHealth) noexport bool bHealthTriggerMultiple "If true, health triggers can be triggered mutliple times.";
var(AIHealth) noexport array<SAIHealthTrigger> HealthTriggers "List of events to fire off when health reaches certain points.";
var(AIPain) noexport bool bMeleeResetPainOpGate "If true, MeleeDamage will reset pain op timer allowing AI to play another pain animation.";
var(AIPain) noexport float MinPainOpInterval "Minimum time between pain ops.";
var(AIPain) noexport float RndPainOpInterval "Random time interval added to MinPainOpInterval.";
var(AIPain) noexport int MaxConsecutivePainOp "how many consecutive pain ops can we do?";
var(AIPain) noexport float MaxConsecutivePainInterval "after hitting a max pain op, how long before we pain again";
var int ConsecutivePainOp;
var(AIPain) float PainImpulseMagnitude;
var(AIPain) float PainImpulseMinDamage;
var(AIPain) bool bDontUseAIOPPain;
var(AIPain) int PainAnimRefID;
var(AIProcFire) array<SBoneAim> BoneAim;
var(AIProcFire) array<SBoneAim> MuzzleBoneAim;
var(AIProcFire) bool HasBoneAimer;
var(AIProcFire) bool DisableAimGrids;
var(AIProcFire) bool ProceduralMovingFire;
var(AIProcFire) array<name> ProcFireStates;
var(AIProcFire) array<Engine.BaseAI.EAIOp> ProcFireOps;
var(AIProcFire) bool ProcAimingEnabledThisFrame;
var(AIProcFire) bool CanProcFire;
var(AIProcFire) bool CanPopupAim;
var(AIProcFire) float PopUpFireGate;
var(AIProcFire) float ProcFireMaxTimeSinceSeen;
var(AIBehavior) array<SBoneAim> BoneHeadAim;
var(AIBehavior) bool HasBoneHeadAimer;
var(AIBehavior) noexport deprecated Actor HackAimFromRotationActor "Hack that allows us to use another Actor's rotation as our procedural aim base rotation.";
var name WeaponIdle;
var transient float MovingFireGate;
var bool ShouldFire;
var float MinMovingFireInterval;
var float RndMovingFireInterval;
var SBoneAimConstraints MuzzleBoneAimConstraints;
var SBoneAimConstraints WeaponBoneAimConstraints;
var SBoneAimConstraints HeadBoneAimConstraints;
var SBoneAimConstraints BodyBoneAimConstraints;
var SBoneAimConstraints WeaponBoneAimConstraintsOverride;
var bool bWeaponBoneAimConstraintsOverrideEnabled;
var bool BoneAimerOnTarget;
var bool HasWeaponAimer;
var bool HasHeadAimer;
var bool AimBodyAtHeadTarget;
var Vector GoalPos;
var(AITick) noexport bool StartTickDisabled "If TRUE, the creature will start with it's tick disabled and activate when it is rendered.  Leave TRUE for optimal performance.";
var(AIBehavior) noexport Engine.BaseAI.EAIAttackConstraint AttackConstraint "How to constrain the attacks that this creature can perform.";
var(AIBehavior) noexport bool AllowBezerk "Is this creature allowed to go bezerk?";
var(AIBehavior) noexport bool AllowProne "Are we allowed to go prone? Note: not implemented on all creatures";
var noexport float TryGotoAttackTime "If we havent seen the target for this long, attempt to find a new attack position. (NOTE: Only Partial character support)";
var float MaxTravelDist;
var(AIBehavior) float MinIdleTime;
var(AIBehavior) float RndIdleTime;
var float MinAggressiveIdleTime;
var float RndAggressiveIdleTime;
var float MinPauseTime;
var float RndPauseTime;
var float MinStunTime;
var float RndStunTime;
var float MaxTryTurnTime;
var float ShouldTurnThreshold;
var float FaceThreshold;
var bool bNeverPlayerTurnAnim;
var(AIMovement) float WalkSpeedScale;
var(AIMovement) float RunSpeedScale;
var float SideArcTurnSpeedThresh;
var float StepBackwardsSpeedThresh;
var float StartAngleSideSector;
var float StartAngleBackSector;
var float MoveBackwardsDistThresh;
var float SideStepDistThresh;
var float WalkDistThresh;
var float GotoPosRange;
var float GotoPosHeight;
var float GotoPosFlyingRange;
var float GotoPosFlyingHeight;
var float MinDistToGoal;
var float MinMoveAroundDist;
var float RndMoveAroundDist;
var float MinBackOffDist;
var float RndBackOffDist;
var float MinMoveSideDist;
var float RndMoveSideDist;
var float MinSpreadOutTime;
var float RndSpreadOutTime;
var(AIMelee) float MinMeleeRange;
var(AIMelee) float RndMeleeRange;
var(AIMelee) float MinMeleeHeight;
var(AIMelee) float RndMeleeHeight;
var int MaxGotoMeleeSteps;
var bool bForceMelee;
var(AIMelee) float MeleeZone;
var(AIMelee) float MeleeZoneHeight;
var float MinMeleeStrafeRange;
var float RndMeleeStrafeRange;
var int MinMeleeStrafeCycles;
var int RndMeleeStrafeCycles;
var float MeleeAttackRange;
var float MeleeAttackArc;
var bool MeleeFaceTarget;
var(AIMelee) float BiteDamageAmount;
var Vector BiteDamageVel;
var(AIMelee) float ClawDamageAmount;
var Vector ClawDamageVel;
var(AIMelee) float KickDamageAmount;
var Vector KickDamageVel;
var(AIBehavior) array<SStompInfo> StompInfo;
var int StompIndex;
var int ForcedStompIndex;
var(AIBehavior) noexport SStubToeInfo ToeStubInfo "How we get our toes stubbed";
var(AIBehavior) array<SDodgeInfo> DodgeInfo;
var int DodgeIndex;
var transient float DodgeGate;
var float DodgeInterval;
var SViewShakeInfo PlayerShrunkFootstepViewShake;
var bool bPlayerShrunkSpecialFootstep;
var float MinChargeRange;
var float MaxChargeRange;
var float MinChargeHeightDelta;
var float MaxChargeHeightDelta;
var float MinChargeAttackRange;
var float MaxChargeAttackRange;
var int MaxChargeSteps;
var int MinWeaponStrafeCycles;
var int RndWeaponStrafeCycles;
var(AIProjectile) class<dnProjectile> ProjectileClass;
var(AIProjectile) name ProjectileMuzzleName;
var(AIProjectile) float MinProjectileFireInterval;
var(AIProjectile) float RndProjectileFireInterval;
var(AIProjectile) transient float ProjecilteFireGate;
var bool ForceShootProjectile;
var(AIProjectile) bool bShootProjectileRequireLOS;
var(AIProjectile) bool bShootProjectileRequireSemiClearShot;
var(AIProjectile) bool bShootProjectileRequireTargetNotInStrTap;
var(AIProjectile) bool bShootProjectileFaceTarget;
var float MinAirAttackHeight;
var float MaxAirAttackHeight;
var(AIJump) noexport float MinJumpAttackRange "Min range that we can jump attack from";
var(AIJump) noexport float MaxJumpAttackRange "Poorly Named - think max distance from MinJumpAttackRange that we can jump attack";
var(AIJump) noexport float MaxJumpAttackHeight "Max height difference when we can still attempt jump attack.";
var(AIJump) bool bJumpAttackRequireTargetNotInStrTap;
var bool JumpAttackOnTakeOff;
var bool ForceJumpAttack;
var float JumpAttackBearingVariance;
var float JumpAttackHeightDelta;
var(AIFall) bool CanJump;
var(AIFall) bool HasStartFallAnim;
var(AIFall) bool HasTouchedGround;
var Vector JumpVel;
var float StartFallHeight;
var(AIFall) float FallDistThresh;
var(AIFall) float LandingThresh;
var(AIFall) float HeavyLandingThresh;
var(AIBehavior) float ChanceLand;
var(AIBehavior) Engine.Object.EBitModifier ForceStartJetpack;
var bool DoJetPackWobble;
var bool bIsFlying;
var(AIBehavior) float TimeTargetNotVisible;
var bool CanOpenDoors;
var(AIBehavior) bool AvoidDangers;
var bool InDanger;
var Vector DangerPos;
var array<Actor> IgnoredDangerActors;
var float MaxThreatAimAngle;
var float MoveAroundTime;
var float RndMoveAroundTime;
var(AIHaywire) noexport float HaywireChance "Chance of going haywire when shot to death";
var(AIHaywire) noexport float HaywireMinDuration "Min duration of Haywire state";
var(AIHaywire) noexport float HaywireMaxDuration "Max duration of Haywire state";
var(AIHaywire) noexport Vector HaywireLinearAccel "Linear acceleration to apply";
var(AIHaywire) noexport Vector HaywireLinearAccelVar "Variance to the linear acceleration to apply";
var(AIHaywire) noexport Vector HaywireAngularAccel "Angular acceleration to apply";
var(AIHaywire) noexport Vector HaywireAngularAccelVar "Variance to the angular acceleration to apply";
var(AIHaywire) noexport bool bForceHaywire "internal programmer nonsense.";
var(AINav) noexport name PathID "ID of the path used by this AIActor.  AIActors with the same PathID will share the same path.";
var(AINav) noexport class<AIActor> OptionalPathClass "Class of AIActor to optionally create paths for.";
var(AINav) noexport bool bNeverFailOnDynamicPath "Actor will not fail when a dynamic path blocker is blocking his path completely. HE will just keep moving.";
var(AIBehavior) name ActionPointJumpType;
var(AIDialog) float ChanceSayPain;
var(AIDialog) float ChanceSayFireInTheHole;
var(AIDialog) float ChanceSayTakeCover;
var(AIDialog) float ChanceSayLowHealth;
var(AIDialog) float ChanceSayConfirmKill;
var(AIDialog) float ChanceSayReloading;
var(AIDialog) float ChanceSayManDown;
var(AIDialog) float ChanceSayFriendlyFire;
var(AIDialog) float ChanceSayEnemySpotted;
var(AISound) float PainSoundMinInterval;
var(AISound) float PainSoundRndInterval;
var(AISound) bool bDebugAISounds;
var(AISound) noexport bool bDisableSounds "AI wont explicitly play sounds if this is set.";
var transient float PainSoundGate;
var const editconst transient nontrans pointer MyLog;
var(AIDebug) bool bUseMyLog;
var(AIDebug) bool bValidateDecisionTree;
var string ShouldFireStr;
var(AIDebug) noexport bool DebugInfiniteLoop "Enable debugging of infinite loops?";
var float NumTransitions;
var bool bAutoOpenDoors;
var bool bWasInAir;
var float FramesWithoutGroundContact;
var string TreeDescentLog;
var Vector TrailMarkerLoc;
var array<SGotoXHistory> GotoXHistory;
var bool bGotoXTracking;
var array<SPathingHistory> PathingHistory;
var array<SAIDebugMessage> AIDebugMessageQueue;
var array<SScriptFailInfo> ScriptFailHistory;
var float LastMoveSpeed;
var Vector LastMoveDir;
var Vector LastFrameVelocity;
var AIAnimHUD MyAnimHUD;
var float PathingErrors;
var transient float OpenDoorGate;
var Vector PreviousLocation;
var Vector DesiredMovement;
var bool bTrackPhysicsContacts;
var array<Actor> PhysicsContactActors;
var netupdate(NU_AIRotation) int AIRotation;
var Engine.BaseAI.EAIDynamicPathPriority DynamicPathingPriority;
var float DynamicPathingPriorityTieBreaker;
var float GroundConstraintScalerOverride;
var bool bScriptPathingEnabled;
var Engine.BaseAI.EAIDynamicPathPriority ScriptPathingOverride;
var float ScriptPathingTieBreakerOverride;
var bool bSpawnedPhysicsControllerActive;
var float PathSizeOverrideHeight;
var float PathSizeOverrideRadius;
var bool bForcePhysicsCutScene;
var float EvalGateOverride;
var bool bPathRover;
var bool bRestorePhysControllerAfterKeyframe;
var float GameplayCurrentScaleConstraintStrength;
var float GameplayDesiredScaleConstraintStrength;
var bool bAutoStartWeaponTargetEval;
var bool bAutoStartLookTargetEval;
var bool bAutoStartDecisionTree;
var bool bHolsterWeapons;
var bool bOpSuspendedLookTargetEval;
var SAIPerformanceInfo PerfInfo;
var bool bHackAIWantsToFire;
var bool bDontPlayShootAnim;
var int AINoTick;
var bool DumbAI;
var() noexport bool bSpecialStepHeightCollisionEnabled "If true, AI will have special collision in their step height for shrunken vehicle collisions.";
var bool bIsBoss;
var bool bDisableThrowAttack;

replication
{
    // Pos:0x000
    reliable if(int(Role) % int(ROLE_Authority))
        AIRotation;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        AnimXParms, ClientMaybeFadeChannelBlock, 
        ClientSetAnimGridState, ClientSetAnimation, 
        ClientSetAnimationController;
}

simulated event bool CanBreatheNormally()
{
    return __NFUN_871__();
    return;
}

// Export UAIActor::execSetAnimPresets(FFrame&, void* const)
native function SetAnimPresets(Engine.BaseAI.EAIAnimXType AnimType, name AnimName, bool UseExactAnimName, float ExitTime, Actor TargetActor, Vector TargetPos, float FaceThreshold);

// Export UAIActor::execSetTurnToPresets(FFrame&, void* const)
native final function SetTurnToPresets(Engine.BaseAI.EAITargetType TargetType, optional Actor TargetActor, optional Vector TargetPos, optional float ShouldTurnThresh, optional float FaceThresh);

// Export UAIActor::execSetJumpPresets(FFrame&, void* const)
native function SetJumpPresets(Vector JumpVel, float HeavingLandingThresh, optional Actor FaceTargetActor, optional float NewGravityScale, optional float NewJumpTime, optional bool FlyToTarget, optional Vector TargetPos);

// Export UAIActor::execActivateCloaking(FFrame&, void* const)
native function ActivateCloaking(bool On);

// Export UAIActor::execGetCloaking(FFrame&, void* const)
native function Engine.BaseAI.EAICloaking GetCloaking();

// Export UAIActor::execIsCloaked(FFrame&, void* const)
native function bool IsCloaked();

// Export UAIActor::execSetDangerPos(FFrame&, void* const)
native function SetDangerPos(Vector NewDangerPos);

// Export UAIActor::execClearDangerPos(FFrame&, void* const)
native function ClearDangerPos();

// Export UAIActor::execLogMyLog(FFrame&, void* const)
native function LogMyLog(string str);

// Export UAIActor::execBeginMyLog(FFrame&, void* const)
native function BeginMyLog();

// Export UAIActor::execEndMyLog(FFrame&, void* const)
native function EndMyLog();

// Export UAIActor::execWeaponAimerAddTargetActor(FFrame&, void* const)
native function WeaponAimerAddTargetActor(Actor TargetActor, name TargetBoneName, float TargetLifeTime, float BlendTime, bool ClearStack, float Threshold, float TrackRate, bool RemoveIfBeyondConstraints, optional string id);

// Export UAIActor::execWeaponAimerAddTargetPos(FFrame&, void* const)
native function WeaponAimerAddTargetPos(Vector TargetPos, float TargetLifeTime, float BlendTime, bool ClearStack, float Threshold, float TrackRate, bool RemoveIfBeyondConstraints, name UpdatePosFuncName, optional string id);

// Export UAIActor::execWeaponAimerAddTargetAITarget(FFrame&, void* const)
native function WeaponAimerAddTargetAITarget(Engine.BaseAI.EAITarget NewTarget, float TargetLifeTime, float BlendTime, bool ClearStack, float Threshold, float TrackRate, bool RemoveIfBeyondConstraints, optional string id);

// Export UAIActor::execWeaponAimerRemoveTarget(FFrame&, void* const)
native function WeaponAimerRemoveTarget(bool RemoveAll, float BlendTime);

// Export UAIActor::execWeaponAimerRemoveSpecificTarget(FFrame&, void* const)
native function WeaponAimerRemoveSpecificTarget(string id, float BlendTime);

// Export UAIActor::execIsWeaponAimerOn(FFrame&, void* const)
native function bool IsWeaponAimerOn();

// Export UAIActor::execGetWeaponAimerState(FFrame&, void* const)
native function Engine.BaseAI.EAIAim GetWeaponAimerState();

// Export UAIActor::execWeaponAimerGetNumTargets(FFrame&, void* const)
native function int WeaponAimerGetNumTargets();

// Export UAIActor::execWeaponAimerGetTargetString(FFrame&, void* const)
native function string WeaponAimerGetTargetString(int TargetIndex);

// Export UAIActor::execHeadAimerAddTargetActor(FFrame&, void* const)
native function HeadAimerAddTargetActor(Actor TargetActor, name TargetBoneName, float TargetLifeTime, float BlendTime, bool ClearStack, float Threshold, float TrackRate, bool RemoveIfBeyondConstraints, optional string id);

// Export UAIActor::execHeadAimerAddTargetPos(FFrame&, void* const)
native function HeadAimerAddTargetPos(Vector TargetPos, float TargetLifeTime, float BlendTime, bool ClearStack, float Threshold, float TrackRate, bool RemoveIfBeyondConstraints, name UpdatePosFuncName, optional string id);

// Export UAIActor::execHeadAimerAddTargetAITarget(FFrame&, void* const)
native function HeadAimerAddTargetAITarget(Engine.BaseAI.EAITarget NewTarget, float TargetLifeTime, float BlendTime, bool ClearStack, float Threshold, float TrackRate, bool RemoveIfBeyondConstraints, optional string id);

// Export UAIActor::execHeadAimerRemoveTarget(FFrame&, void* const)
native function HeadAimerRemoveTarget(bool RemoveAll, float BlendTime);

// Export UAIActor::execHeadAimerRemoveSpecificTarget(FFrame&, void* const)
native function HeadAimerRemoveSpecificTarget(string id, float BlendTime);

// Export UAIActor::execIsHeadAimerOn(FFrame&, void* const)
native function bool IsHeadAimerOn();

// Export UAIActor::execGetHeadAimerState(FFrame&, void* const)
native function Engine.BaseAI.EAIAim GetHeadAimerState();

// Export UAIActor::execHeadAimerGetNumTargets(FFrame&, void* const)
native function int HeadAimerGetNumTargets();

// Export UAIActor::execHeadAimerGetTargetString(FFrame&, void* const)
native function string HeadAimerGetTargetString(int TargetIndex);

// Export UAIActor::execCanGuard(FFrame&, void* const)
native function bool CanGuard();

// Export UAIActor::execIsGuarding(FFrame&, void* const)
native function bool IsGuarding();

// Export UAIActor::execIsGuardingPlayer(FFrame&, void* const)
native function bool IsGuardingPlayer();

// Export UAIActor::execIsGuardingActor(FFrame&, void* const)
native function bool IsGuardingActor(out Actor OutGuardedActor, out float OutInnerRange, out float OutOuterRange);

// Export UAIActor::execIsGuardingPos(FFrame&, void* const)
native function bool IsGuardingPos(out Vector OutGuardedPos, out float OutInnerRange, out float OutOuterRange);

// Export UAIActor::execGuardActor(FFrame&, void* const)
native function bool GuardActor(Actor GuardedActor, float InnerRange, float OuterRange, bool AlignWith, float AlignmentOffset, bool AllowAvoidDanger, bool AllowDodge, optional bool bDontScaleRangeWithDrawScale);

// Export UAIActor::execGuardPos(FFrame&, void* const)
native function bool GuardPos(float InnerRange, float OuterRange, bool AllowAvoidDanger, bool AllowDodge, optional bool bDontScaleRangeWithDrawScale);

// Export UAIActor::execSetAbortGuardThresh(FFrame&, void* const)
native function SetAbortGuardThresh(float Range, bool MustBeVisible);

// Export UAIActor::execClearGuard(FFrame&, void* const)
native function ClearGuard();

// Export UAIActor::execSetPopUp(FFrame&, void* const)
native function SetPopUp(PopUpCfg NewCfg);

// Export UAIActor::execPopUpCompromised(FFrame&, void* const)
native function bool PopUpCompromised();

// Export UAIActor::execSetActionPointIndex(FFrame&, void* const)
native function bool SetActionPointIndex(int NewIndex, int NewDesiredIndex);

// Export UAIActor::execLockActionPoint(FFrame&, void* const)
native function bool LockActionPoint(ActionPoint NewActionPoint, Vector NewActionPointUserLoc);

// Export UAIActor::execAtActionPoint(FFrame&, void* const)
native function bool AtActionPoint();

// Export UAIActor::execCanUseNewActionPoint(FFrame&, void* const)
native function bool CanUseNewActionPoint(ActionPoint NewActionPoint, bool Secondary);

// Export UAIActor::execCanUseActionPoint(FFrame&, void* const)
native function bool CanUseActionPoint(bool Secondary);

// Export UAIActor::execGetActionPointAction(FFrame&, void* const)
native function bool GetActionPointAction(bool Secondary);

// Export UAIActor::execActionPointCompromised(FFrame&, void* const)
native function bool ActionPointCompromised();

// Export UAIActor::execUseActionPoint(FFrame&, void* const)
native function bool UseActionPoint(bool Secondary);

// Export UAIActor::execReleaseActionPoint(FFrame&, void* const)
native function bool ReleaseActionPoint(bool Died);

// Export UAIActor::execHasUseableActionPoint(FFrame&, void* const)
native function bool HasUseableActionPoint();

// Export UAIActor::execSetNewActionPoint(FFrame&, void* const)
native function bool SetNewActionPoint(ActionPoint NewActionPoint);

// Export UAIActor::execSetExecutive(FFrame&, void* const)
native function SetExecutive(Engine.BaseAI.EAIExecutive NewExecutive);

// Export UAIActor::execGetExecutive(FFrame&, void* const)
native function Engine.BaseAI.EAIExecutive GetExecutive();

// Export UAIActor::execInitialiseExecutive(FFrame&, void* const)
native function InitialiseExecutive();

// Export UAIActor::execSuspendExecutive(FFrame&, void* const)
native function SuspendExecutive(bool Suspended);

// Export UAIActor::execIsExecutiveSuspended(FFrame&, void* const)
native function bool IsExecutiveSuspended();

// Export UAIActor::execExecuteExecutive(FFrame&, void* const)
native function ExecuteExecutive();

// Export UAIActor::execForceExecutive(FFrame&, void* const)
native function ForceExecutive();

// Export UAIActor::execPrintExecutive(FFrame&, void* const)
native function PrintExecutive();

// Export UAIActor::execPlayScript(FFrame&, void* const)
native function bool PlayScript(ScriptObj NewScript, bool Push);

// Export UAIActor::execStopScript(FFrame&, void* const)
native function bool StopScript();

// Export UAIActor::execAbortScripts(FFrame&, void* const)
native function AbortScripts();

// Export UAIActor::execAbortScript_SeeActor(FFrame&, void* const)
native function AbortScript_SeeActor(Actor VisibleActor, out int VisibilityChecked, out int IsVisible);

// Export UAIActor::execAbortScript_HearSound(FFrame&, void* const)
native function AbortScript_HearSound(Actor SoundInstigator);

// Export UAIActor::execAbortScript_Damaged(FFrame&, void* const)
native function AbortScript_Damaged(int Damage, Actor DamageInstigator);

// Export UAIActor::execAbortScript_Bumped(FFrame&, void* const)
native function AbortScript_Bumped(Actor BumpedActor);

// Export UAIActor::execAbortScript_Triggered(FFrame&, void* const)
native function AbortScript_Triggered(Actor EventInstigator);

// Export UAIActor::execAbortScript_Shrunk(FFrame&, void* const)
native function AbortScript_Shrunk();

// Export UAIActor::execHeardSound(FFrame&, void* const)
native function HeardSound(Actor NoiseMaker, Vector SoundPos);

// Export UAIActor::execPotentialWeaponTargetSound(FFrame&, void* const)
native function PotentialWeaponTargetSound(Actor NoiseMaker, Vector NoisePos);

// Export UAIActor::execSuspendWeaponTargetEvaluation(FFrame&, void* const)
native function SuspendWeaponTargetEvaluation(bool Suspend);

// Export UAIActor::execPotentialLookTargetSound(FFrame&, void* const)
native function PotentialLookTargetSound(Actor NoiseMaker, Vector NoisePos);

// Export UAIActor::execSuspendLookTargetEvaluation(FFrame&, void* const)
native function SuspendLookTargetEvaluation(bool Suspend);

// Export UAIActor::execForceLookTargetEval(FFrame&, void* const)
native function ForceLookTargetEval();

// Export UAIActor::execSetGoal(FFrame&, void* const)
native function bool SetGoal(Engine.BaseAI.EAIGoalType GoalType, optional bool ReturnTrueIfInRange, optional bool TestCanGotoPos);

// Export UAIActor::execSetGotoPresets(FFrame&, void* const)
native function SetGotoPresets(Engine.BaseAI.EAITargetType TargetType, Actor TargetActor, Vector TargetPos, Actor RefActor, Engine.BaseAI.EAIOffsetType OffsetType, float Range, float Bearing, float Height, float ClipTolerance, Engine.BaseAI.EAIFocus Focus, Actor FocusActor, int MaxSteps, optional bool bDebug);

// Export UAIActor::execCalcTargetsAimAngle(FFrame&, void* const)
native function bool CalcTargetsAimAngle(out float OutAimAngle);

// Export UAIActor::execCalcAimToMeAngle(FFrame&, void* const)
native function bool CalcAimToMeAngle(Actor AimingActor, out float OutAimAngle);

// Export UAIActor::execNative_PreGameInit(FFrame&, void* const)
native final function Native_PreGameInit();

// Export UAIActor::execNative_PreBeginPlay(FFrame&, void* const)
native final function Native_PreBeginPlay();

// Export UAIActor::execNative_PostBeginPlay(FFrame&, void* const)
native final function Native_PostBeginPlay();

// Export UAIActor::execNative_PostLoadMap(FFrame&, void* const)
native final function Native_PostLoadMap();

// Export UAIActor::execNative_PostSpawn(FFrame&, void* const)
native final function Native_PostSpawn();

// Export UAIActor::execIsFacingInYaw(FFrame&, void* const)
native final function bool IsFacingInYaw(Vector vPos);

// Export UAIActor::execIsFacing(FFrame&, void* const)
native final function bool IsFacing(Vector vDirTo, Vector vMyDir);

// Export UAIActor::execMoveToEx(FFrame&, void* const)
native final function MoveToEx(Vector vDest, float fMaxSpeed, float fDesiredSpeedAtDest);

// Export UAIActor::execEnableMovement(FFrame&, void* const)
native final function EnableMovement(bool On);

// Export UAIActor::execGetLatentAction(FFrame&, void* const)
native final function name GetLatentAction();

// Export UAIActor::execSetTarget(FFrame&, void* const)
native final function bool SetTarget(bool AllowClear, Actor NewTarget, optional Vector TargetPos, optional Rotator TargetRotn, optional bool Sighted);

// Export UAIActor::execClearTarget(FFrame&, void* const)
native final function ClearTarget();

// Export UAIActor::execFreeTargetActorSlot(FFrame&, void* const)
native final function FreeTargetActorSlot(int iIndex);

// Export UAIActor::execTargetActor(FFrame&, void* const)
native final function Actor TargetActor(int iIndex);

// Export UAIActor::execSetTargetActorSlot(FFrame&, void* const)
native final function SetTargetActorSlot(int iIndex, Actor aActor);

// Export UAIActor::execGetUnusedTargetActorSlot(FFrame&, void* const)
native final function int GetUnusedTargetActorSlot();

// Export UAIActor::execGetTarget(FFrame&, void* const)
native final function AITarget GetTarget(Engine.BaseAI.EAITarget eTarget);

// Export UAIActor::execGetTargetActor(FFrame&, void* const)
native final function Actor GetTargetActor(Engine.BaseAI.EAITarget eTarget);

// Export UAIActor::execCheckCondition(FFrame&, void* const)
native function Engine.BaseAI.EAICode CheckCondition(Engine.BaseAI.EAICondition Cond);

// Export UAIActor::execFacingActor(FFrame&, void* const)
native function bool FacingActor(Actor TargetActor, float Threshold, out Vector OutFacePos);

// Export UAIActor::execFacingPos(FFrame&, void* const)
native function bool FacingPos(Vector TargetPos, float Threshold);

// Export UAIActor::execPosInAngularThreshold(FFrame&, void* const)
native function bool PosInAngularThreshold(Vector TargetPos, float Threshold);

// Export UAIActor::execActorInHorizRange(FFrame&, void* const)
native function bool ActorInHorizRange(Actor TargetActor, float MaxHorizRange);

// Export UAIActor::execActorInHorizRangeLimits(FFrame&, void* const)
native function bool ActorInHorizRangeLimits(Actor TargetActor, float MinRange, float MaxRange);

// Export UAIActor::execActorInRange(FFrame&, void* const)
native function bool ActorInRange(Actor TargetActor, float MaxHorizRange, float MaxHeight);

// Export UAIActor::execAtActorOffset(FFrame&, void* const)
native function bool AtActorOffset(Actor TargetActor, Engine.BaseAI.EAIOffsetType OffsetType, float HorizRange, float Bearing, float Height);

// Export UAIActor::execPosInHorizProx(FFrame&, void* const)
native function bool PosInHorizProx(Vector TargetPos, float MaxHorizDist);

// Export UAIActor::execPosInAcceptableHorizProx(FFrame&, void* const)
native function bool PosInAcceptableHorizProx(Vector TargetPos, float MaxHorizDist);

// Export UAIActor::execPosInProx(FFrame&, void* const)
native function bool PosInProx(Vector TargetPos, float MaxHorizDist, float MaxHeight);

// Export UAIActor::execPosInAcceptableProx(FFrame&, void* const)
native function bool PosInAcceptableProx(Vector TargetPos, float MaxHorizDist, float MaxHeight);

// Export UAIActor::execCanGotoActor2D(FFrame&, void* const)
native function Engine.BaseAI.EAICode CanGotoActor2D(Actor TargetActor, Actor RefActor, float HorizRange, float ClipTolerance, out Vector OutNextPathPos, out int FinalDest);

// Export UAIActor::execCanGotoActorOffset(FFrame&, void* const)
native function Engine.BaseAI.EAICode CanGotoActorOffset(Actor TargetActor, Actor RefActor, Engine.BaseAI.EAIOffsetType OffsetType, float HorizRange, float Bearing, float Height, float ClipTolerance, out Vector OutNextPathPos, out int FinalDest);

// Export UAIActor::execCanGotoPos2D(FFrame&, void* const)
native function Engine.BaseAI.EAICode CanGotoPos2D(Vector TargetPos, Actor RefActor, float HorizDist, float ClipTolerance, out Vector OutNextPathPos, out int FinalDest);

// Export UAIActor::execCanGotoPos(FFrame&, void* const)
native function Engine.BaseAI.EAICode CanGotoPos(Vector TargetPos, Actor RefActor, float HorizDist, float Height, float ClipTolerance, out Vector OutNextPathPos, out int FinalDest);

// Export UAIActor::execCanTurnToActor(FFrame&, void* const)
native function Engine.BaseAI.EAICode CanTurnToActor(Actor TargetActor, float FaceThresh, out Vector OutFacePos);

// Export UAIActor::execCanTurnToPos(FFrame&, void* const)
native function Engine.BaseAI.EAICode CanTurnToPos(Vector TargetPos, float FaceThresh);

// Export UAIActor::execCalcPerpSpeed(FFrame&, void* const)
native function float CalcPerpSpeed(Vector Velocity);

// Export UAIActor::execCalcWeaponRange(FFrame&, void* const)
native function float CalcWeaponRange(float K);

// Export UAIActor::execCalcMeleeRange(FFrame&, void* const)
native function float CalcMeleeRange(float K);

// Export UAIActor::execCalcMeleeStrafeRange(FFrame&, void* const)
native function float CalcMeleeStrafeRange(float K);

// Export UAIActor::execCalcNumMeleeStrafeCylces(FFrame&, void* const)
native function float CalcNumMeleeStrafeCylces(float K);

// Export UAIActor::execCalcNumWeaponStrafeCycles(FFrame&, void* const)
native function float CalcNumWeaponStrafeCycles(float K);

// Export UAIActor::execCalcJumpRange(FFrame&, void* const)
native function float CalcJumpRange(float K);

// Export UAIActor::execCalcSector(FFrame&, void* const)
native function Engine.BaseAI.EAIArcSector CalcSector(Vector TargetPos, float SideSector, float BackSector);

// Export UAIActor::execCalcRelativeSector(FFrame&, void* const)
native function Engine.BaseAI.EAIArcSector CalcRelativeSector(Vector TargetPos, Vector Fwd, float SideSector, float BackSector);

// Export UAIActor::execCalcRndPos(FFrame&, void* const)
native function CalcRndPos(Actor TargetActor, out Vector OutTargetPos);

// Export UAIActor::execCalcRelOffsetPos(FFrame&, void* const)
native function CalcRelOffsetPos(float Range, float Bearing, out Vector OutTargetPos);

// Export UAIActor::execCalcTargetOffsetPos2D(FFrame&, void* const)
native function CalcTargetOffsetPos2D(Actor TargetActor, float HorizRange, float Heading, out Vector OutTargetPos);

// Export UAIActor::execCalcTargetOffsetPos3D(FFrame&, void* const)
native function CalcTargetOffsetPos3D(Actor TargetActor, float HorizRange, float Heading, float Height, out Vector OutTargetPos);

// Export UAIActor::execCalcTargetRelOffsetPos2D(FFrame&, void* const)
native function CalcTargetRelOffsetPos2D(Actor TargetActor, float HorizRange, float Bearing, out Vector OutTargetPos);

// Export UAIActor::execCalcTargetRelOffsetPos3D(FFrame&, void* const)
native function CalcTargetRelOffsetPos3D(Actor TargetActor, float HorizRange, float Bearing, float Height, out Vector OutTargetPos);

// Export UAIActor::execCalcDirToTargetRelOffsetPos2D(FFrame&, void* const)
native function CalcDirToTargetRelOffsetPos2D(Actor TargetActor, float HorizRange, float Bearing, out Vector OutTargetPos);

// Export UAIActor::execCalcDirToTargetRelOffsetPos3D(FFrame&, void* const)
native function CalcDirToTargetRelOffsetPos3D(Actor TargetActor, float HorizRange, float Bearing, float Height, out Vector OutTargetPos);

// Export UAIActor::execCalcDistForRange(FFrame&, void* const)
native function float CalcDistForRange(Actor TargetActor, float Range);

// Export UAIActor::execCalcRangeForDist(FFrame&, void* const)
native function float CalcRangeForDist(Actor TargetActor, float Dist);

// Export UAIActor::execCalcHorizRangeToActor(FFrame&, void* const)
native function float CalcHorizRangeToActor(Actor TargetActor);

// Export UAIActor::execValidateTargetPos(FFrame&, void* const)
native function Engine.BaseAI.EAICode ValidateTargetPos(Vector TargetPos, float ClipTolerance, out Vector OutClippedDest);

// Export UAIActor::execCalcJumpVelocity(FFrame&, void* const)
native function CalcJumpVelocity(Vector TargetPos, float MaxHeight, out Vector OutVelocity, optional bool Debug, optional float GravityScale, optional out float TimeOut);

// Export UAIActor::execCalcJumpAttackVelocity(FFrame&, void* const)
native function CalcJumpAttackVelocity(Actor TargetActor, out Vector OutJumpVelocity);

// Export UAIActor::execCalcPipeBombVelocity(FFrame&, void* const)
native function bool CalcPipeBombVelocity(Object PipeBombOrClass, Vector TargetPos, float MaxHeight, Engine.Actor.EAIAttitude AttitudeThresh, float FriendlyFireThresh, out Vector OutVelocity, optional bool Debug);

// Export UAIActor::execCalcProjectileVelocity(FFrame&, void* const)
native function bool CalcProjectileVelocity(Actor ProjectileObj, Engine.Object.EPhysics ProjectilePhys, Actor TargetActor, Vector TargetPos, float MinError, float MaxError, float MaxHeight, bool AssumeNoGravity, float NoGravitySpeed, bool CheckClear, Engine.Actor.EAIAttitude AttitudeThresh, float FriendlyFireThresh, bool IgnoreTransparents, out Vector OutVelocity, bool Debug);

// Export UAIActor::execCalcMapRange(FFrame&, void* const)
native function float CalcMapRange(float Value, float Range1Start, float Range1End, float Range2Start, float Range2End);

// Export UAIActor::execCanReloadWeapon(FFrame&, void* const)
native function Engine.BaseAI.EAICode CanReloadWeapon();

// Export UAIActor::execCanSeeActor(FFrame&, void* const)
native function bool CanSeeActor(Actor TargetActor, bool CheckFOV, optional bool Debug);

// Export UAIActor::execClearShot(FFrame&, void* const)
native function bool ClearShot(Actor TargetActor, Vector From, Vector To, Engine.Actor.EAIAttitude AttitudeThresh, float FriendlyFireThresh, optional bool Debug, optional out Vector Extent, optional bool IgnoreTransparent);

// Export UAIActor::execCanSeePosFrom(FFrame&, void* const)
native function bool CanSeePosFrom(Vector From, Vector To, bool IgnoreTransparents, out Actor OutHitActor, out float OutHitTime, optional bool Debug, optional out Vector Extent);

// Export UAIActor::execFloatInLimits(FFrame&, void* const)
native function Engine.BaseAI.EAICode FloatInLimits(float TestFloat, float MinLimit, float MaxLimit);

// Export UAIActor::execVectorInLimits(FFrame&, void* const)
native function Engine.BaseAI.EAICode VectorInLimits(Vector TestVector, float MinHorizLimit, float MaxHorizLimit, float MinVertLimit, float MaxVertLimit);

// Export UAIActor::execFindClosestLedge(FFrame&, void* const)
native function bool FindClosestLedge(out Vector OutLedgePos, float MaxDistToLedge);

// Export UAIActor::execPortalDoorIsClosed(FFrame&, void* const)
native function bool PortalDoorIsClosed(int DestPortal, int TransType, out DoorMoverEx DoorMover);

// Export UAIActor::execForcePosIntoPath(FFrame&, void* const)
native function bool ForcePosIntoPath(Vector TargetPos, float ClipTolerance, out Vector ClippedTargetPos);

// Export UAIActor::execTargetContact(FFrame&, void* const)
native function Engine.BaseAI.EAICode TargetContact(float MaxTimeSinceContact);

// Export UAIActor::execFacingTarget(FFrame&, void* const)
native function Engine.BaseAI.EAICode FacingTarget(float Thresh);

// Export UAIActor::execTargetInHorizRangeLimits(FFrame&, void* const)
native function Engine.BaseAI.EAICode TargetInHorizRangeLimits(float MinRange, float MaxRange);

// Export UAIActor::execGetMaxRangeError(FFrame&, void* const)
native function float GetMaxRangeError();

// Export UAIActor::execGetMaxHeightError(FFrame&, void* const)
native function float GetMaxHeightError();

// Export UAIActor::execAddTrailMarker(FFrame&, void* const)
native function AddTrailMarker();

// Export UAIActor::execNotifyDied(FFrame&, void* const)
native function bool NotifyDied();

// Export UAIActor::execPointIsInWorld(FFrame&, void* const)
native function bool PointIsInWorld(Vector Point, optional Vector Extent);

// Export UAIActor::execGetRealNAVID(FFrame&, void* const)
native function int GetRealNAVID();

// Export UAIActor::execSortHealthTriggers(FFrame&, void* const)
native function SortHealthTriggers();

// Export UAIActor::execIsInAir(FFrame&, void* const)
native function bool IsInAir();

// Export UAIActor::execIsFlying(FFrame&, void* const)
native function bool IsFlying();

// Export UAIActor::execIsFalling(FFrame&, void* const)
native function bool IsFalling();

// Export UAIActor::execShowDebugInfoBubbles(FFrame&, void* const)
native function bool ShowDebugInfoBubbles();

// Export UAIActor::execAIShouldTick(FFrame&, void* const)
native function bool AIShouldTick();

// Export UAIActor::execClearGlobalPathingCache(FFrame&, void* const)
native simulated function ClearGlobalPathingCache();

simulated function NU_AIRotation(int Rot)
{
    ViewRotationInt = Rot;
    return;
}

event ReceiveWeapon(class<Weapon> WeaponClass)
{
    WeaponClass.static.GiveToAI(self);
    return;
}

event bool PawnNeedsSpecialStepHeightCollision()
{
    return bSpecialStepHeightCollisionEnabled;
    return;
}

simulated event EnumerateRawAnimationSequences(out array<SAnimationEnumeration> References)
{
    local int i;

    super(InteractiveActor).EnumerateRawAnimationSequences(References);
    // End:0x31
    if(__NFUN_340__(SpawnScript, none))
    {
        SpawnScript.super(ScriptObj).EnumerateRawAnimationSequences(References, Mesh);
    }
    i = 0;
    J0x38:

    // End:0x78 [Loop If]
    if(-i)
    {        
        class'AnimationControllerEx'.static.EnumerateRawAnimationSequences(References, AnimControllers[i].m_cClass, Mesh);
        // [Loop Continue]
        i += ;
    }
    return;
}

static function AIActor StaticSpawnAI(class<AIActor> SpawnClass, AIActorFactory Factory, Actor Owner, name SpawnTag, Vector SpawnLocation, Rotator SpawnRotation, bool bSkipFindSpot)
{
    return Factory.__NFUN_615__(SpawnClass, Owner, SpawnTag, SpawnLocation, SpawnRotation,, bSkipFindSpot);
    return;
}

simulated function ModifyAllowQuickTeleports(Engine.Object.EBitModifier bAllowQuickTeleportsModifier)
{
    return;
}

simulated delegate ClientSetAnimation(name AnimName, optional float Rate, optional bool Reset, optional bool UseExactAnimName)
{
    PlayAnim(AnimName, Rate, Reset, UseExactAnimName);
    return;
}

simulated event delegate bool ClientSetAnimGridState(name AnimGridName, float X, optional float Y, optional bool bKeepChannelAlpha)
{
    SetAnimGridState(AnimGridName, X, Y, bKeepChannelAlpha);
    return;
}

simulated delegate ClientSetAnimationController(Engine.BaseAI.EAIAnimController cont)
{
    SetAnimController(cont);
    return;
}

simulated delegate ClientMaybeFadeChannelBlock(name ChannelBlockName, float TargetAlpha, float FadeTime, optional bool bClearAnimsOnFinish)
{
    MaybeFadeChannelBlock(ChannelBlockName, TargetAlpha, FadeTime, bClearAnimsOnFinish);
    return;
}

simulated function NU_AnimXParms(SAnimX newparms)
{
    return;
}

simulated function bool CanDisablePhysicsConstraintsInStateGotoX()
{
    return true;
    return;
}

function StartBloat(float BloatTime)
{
    DeathAnimChance = 0;
    super(Pawn).StartBloat(BloatTime);
    return;
}

// Export UAIActor::execRegisterAIAnimationControllerEntry(FFrame&, void* const)
native final function RegisterAIAnimationControllerEntry(PrecacheIndex PrecacheIndex, name EntryName);

event EnumerateWeaponClasses(PrecacheIndex PrecacheIndex, out array< class<Weapon> > WeaponClasses)
{
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    return;
}

function ActionPointDestroyed(ActionPoint Point)
{
    local int Index, DesiredIndex;

    super(Actor).ActionPointDestroyed(Point);
    Index = ActionPointIndex;
    DesiredIndex = ActionPointDesiredIndex;
    SetActionPointIndex(-1, -1);
    SetActionPointIndex(Index, DesiredIndex);
    return;
}

event SaveAnimSync()
{
    SavedUseAnimDispSpeed = bUseAnimDispSpeed;
    SavedUseAnimDispDir = bUseAnimDispDir;
    SavedUseAnimRotation = bUseAnimRotation;
    SavedAnimCutScene = bAnimCutScene;
    SavedUseAcceleration = bUseAcceleration;
    return;
}

event SetAnimSync(Engine.Object.EBitModifier UseAnimDispSpeedMod, Engine.Object.EBitModifier UseAnimDispDirMod, Engine.Object.EBitModifier UseAnimRotationMod, Engine.Object.EBitModifier AnimCutSceneMod, Engine.Object.EBitModifier UseAccelerationMod)
{
    bUseAnimDispSpeed = __NFUN_346__(UseAnimDispSpeedMod, bUseAnimDispSpeed);
    bUseAnimDispDir = __NFUN_346__(UseAnimDispDirMod, bUseAnimDispDir);
    bUseAnimRotation = __NFUN_346__(UseAnimRotationMod, bUseAnimRotation);
    bUseAcceleration = __NFUN_346__(UseAccelerationMod, bUseAcceleration);
    SetAnimCutScene(__NFUN_346__(AnimCutSceneMod, bAnimCutScene));
    return;
}

event RestoreSavedAnimSync()
{
    bUseAnimDispSpeed = SavedUseAnimDispSpeed;
    bUseAnimDispDir = SavedUseAnimDispDir;
    bUseAnimRotation = SavedUseAnimRotation;
    bUseAcceleration = SavedUseAcceleration;
    SetAnimCutScene(SavedAnimCutScene);
    return;
}

event RestoreDefaultAnimSync()
{
    bUseAnimDispSpeed = default.bUseAnimDispSpeed;
    bUseAnimDispDir = default.bUseAnimDispDir;
    bUseAnimRotation = default.bUseAnimRotation;
    bUseAcceleration = default.bUseAcceleration;
    SetAnimCutScene(default.bAnimCutScene);
    return;
}

function DumpAnimSync()
{
    return;
}

function SetAnimCutScene(bool NewAnimCutScene)
{
    // End:0x20
    if(NewAnimCutScene << bAnimCutScene / )
    {        
    }
    else
    {
        // End:0x3D
        if((NewAnimCutScene / ) << )
        {
        }
    }
    bAnimCutScene = NewAnimCutScene;
    return;
}

event RestoreDefaultBodyAlignRate()
{
    // End:0x22
    if(__NFUN_340__(BodyTargetTracker, none))
    {
        BodyTargetTracker.SetMaxRate(DefaultBodyAlignRate());
    }
    return;
}

event float DefaultBodyAlignRate()
{
    // End:0x12
    if(IsFlying())
    {
        return default.BodyAlignRateFlying;        
    }
    else
    {
        return default.BodyAlignRate;
    }
    return;
}

event PreLoadMap()
{
    super(Actor).PreLoadMap();
    return;
}

event PostLoadMap()
{
    Native_PostLoadMap();
    super(Actor).PostLoadMap();
    return;
}

event PreGameInit()
{
    super(Actor).PreGameInit();
    Native_PreGameInit();
    return;
}

event PreBeginPlay()
{
    super(Pawn).PreBeginPlay();
    Native_PreBeginPlay();
    return;
}

simulated event PostBeginPlay()
{
    bSpawnedPhysicsControllerActive = bPhysicsControllerActive;
    // End:0x1A
    if(bSpawnedPhysicsControllerActive)
    {
        __NFUN_862__(false);
    }
    super(Pawn).PostBeginPlay();
    Native_PostBeginPlay();
    return;
}

event PlayDefaultSpawnAnim()
{
    Anim_Idle();
    return;
}

event PostSpawn()
{
    // End:0x18
    if(bSpawnedPhysicsControllerActive << bSimplePawnPhysicsCollision)
    {
        __NFUN_862__(true);
    }
    Native_PostSpawn();
    bNoDamage = false;
    return;
}

event bool ExtractSpawnAnimSeq(out name OutSequenceName, out int OutLoopSequence, out float OutStartFrame, out float OutSpawnAnimRate)
{
    local int i, Index, NumMethods;
    local ScriptMethod MyMethod;

    // End:0x0E
    if(__NFUN_339__(SpawnScript, none))
    {
        return false;
    }
    NumMethods = string(SpawnScript.Methods);
    i = 0;
    J0x2B:

    // End:0x185 [Loop If]
    if(-i)
    {        
        MyMethod = SpawnScript.Methods[i];
        // End:0x17B
        if(__NFUN_340__(MyMethod, none))
        {
            // End:0xE5
            if(MyMethod.__NFUN_358__('ScriptMethod_PlayExplicitAnim'))
            {
                OutSequenceName = ScriptMethod_PlayExplicitAnim(MyMethod).SequenceName;
                OutLoopSequence = int(ScriptMethod_PlayExplicitAnim(MyMethod).Loop);
                OutStartFrame = ScriptMethod_PlayExplicitAnim(MyMethod).StartFrame;
                OutSpawnAnimRate = ScriptMethod_PlayExplicitAnim(MyMethod).Rate;
                return true;                
            }
            else
            {
                // End:0x166
                if(MyMethod.__NFUN_358__('ScriptMethod_PlayTransientExplicitAnim'))
                {
                    OutSequenceName = ScriptMethod_PlayTransientExplicitAnim(MyMethod).SequenceName;
                    OutLoopSequence = int(ScriptMethod_PlayTransientExplicitAnim(MyMethod).Loop);
                    OutStartFrame = ScriptMethod_PlayTransientExplicitAnim(MyMethod).StartFrame;
                    OutSpawnAnimRate = ScriptMethod_PlayTransientExplicitAnim(MyMethod).Rate;
                    return true;
                }
            }
            // End:0x17B
            if(MyMethod.Latent)
            {
                return false;
            }
        }
        // [Loop Continue]
        i += ;
    }
    return false;
    return;
}

event PreInit()
{
    // End:0x22
    if(string(RandomActorColor) ** 0)
    {
        __NFUN_601__(RandomActorColorGroupID, RandomActorColor[Sin(string(RandomActorColor))]);
    }
    return;
}

simulated function PostVerifySelf()
{
    // End:0x1C
    if(MountLightEx)
    {
        MountOnSpawn[MountOnSpawn.Add(1)] = MountedLightExMountPrefab;
    }
    super(RenderActor).PostVerifySelf();
    // End:0x36
    foreach __NFUN_753__(class'LightEx', MountedLightEx)
    {
        // End:0x36
        break;        
    }    
    return;
}

event PostInit()
{
    return;
}

simulated event Destroyed()
{
    // End:0x1D
    if(__NFUN_340__(FactoryManager, none))
    {
        FactoryManager.NotifyDied(self);
    }
    // End:0x3A
    if(__NFUN_340__(Factory, none))
    {
        Factory.NotifyDied(self);
    }
    ClearFactory();
    ReleaseActionPoint(true);
    KillWeaponManager();
    DestroyAnimControllers();
    DestroyShield();
    DestroyTKShield();
    DestroyShootProjectileEffects();
    __NFUN_701__(none);
    // End:0x8C
    if(__NFUN_340__(RappelParms.MyBeamSystem, none))
    {
        RappelParms.MyBeamSystem.__NFUN_614__();
    }
    // End:0xAF
    if(__NFUN_340__(TeleportParms.StartLight, none))
    {
        TeleportParms.StartLight.__NFUN_614__();
    }
    // End:0xD2
    if(__NFUN_340__(TeleportParms.EndLight, none))
    {
        TeleportParms.EndLight.__NFUN_614__();
    }
    super(Pawn).Destroyed();
    return;
}

event ScriptCalcRotation(out Rotator OldRotation, out Rotator NewRotation, float DeltaTime)
{
    return;
}

event FireWeapon()
{
    return;
}

event ProceduralFire()
{
    MovingFireGate = (Level.GameTimeSeconds *= MinMovingFireInterval) *= FRand( /= RndMovingFireInterval);
    return;
}

// Export UAIActor::execIsInProcFireState(FFrame&, void* const)
native(1328) function bool IsInProcFireState();

// Export UAIActor::execIsInProcFireOp(FFrame&, void* const)
native(1329) function bool IsInProcFireOp();

function string HUDProceduralFireInfo()
{
    local string str;

    // End:0x38
    if(ProcAimingEnabledThisFrame / )
    {        
    }
    else
    {
        // End:0x61
        if(CanProcFire / )
        {            
        }
        else
        {
            // End:0x93
            if(ProceduralMovingFire / )
            {                
            }
            else
            {
                // End:0xC2
                if(BoneAimerOnTarget / )
                {                    
                }
                else
                {
                    // End:0x129
                    if((__NFUN_202__(MovingFireGate, 0) < Repl(Level.GameTimeSeconds, MovingFireGate)) / )
                    {                        
                    }
                    else
                    {
                        // End:0x1FB
                        if((PrimaryTarget.IsValidTarget() << Repl(PrimaryTarget.GetTimeVisible(), 0) << __NFUN_200__(PrimaryTarget.GetTimeSinceSeen(), ProcFireMaxTimeSinceSeen)) / )
                        {                            
                        }
                        else
                        {
                            // End:0x22D
                            if(ShouldProceduralFire())
                            {
                                str = "ShouldProceduralFire() = TRUE!";                                
                            }
                            else
                            {
                                str = " I DONT FUCKING KNOW!!!";
                            }
                        }
                    }
                }
            }
        }
    }
    return str;
    return;
}

function string HUDPreFireInfo()
{
    local string str;

    // End:0x35
    if(WeaponManager.NoFire)
    {
        str = "WeaponManager.NoFire == true";        
    }
    else
    {
        // End:0xBA
        if((Level.GameTimeSeconds != WeaponManager.Gate) / )
        {            
        }
        else
        {
            // End:0x1F6
            if(((((WeaponManager.ShotsFired ** 0) < __NFUN_339__(PrimaryTargetActor, none)) < PrimaryTargetActor.bIsPlayerPawn / ) < ) / str = __NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__(__NFUN_302__("WeaponManager.ShotsFired: ", string(WeaponManager.ShotsFired)), "PrimaryTargetActor: "), string(PrimaryTargetActor)), "PrimaryTargetActor.bIsPlayerPawn: "), string(PrimaryTargetActor.bIsPlayerPawn)), "PrimaryTarget.GetTimeVisible: "), string(PrimaryTarget.GetTimeVisible())), "MinTargetVisibleTime"), string(MinTargetVisibleTime)))
            {
            }
            else
            {
                // End:0x27C
                if((int(TargetInHorizRangeLimits(WeaponManager.MinRange, 999999.9)) % int(0)) / )
                {
                }
            }
        }
    }
    J0x27C:

    return str;
    return;
}

event UpdateState(float DeltaSecs)
{
    return;
}

event UpdateStateOPNotWorking(float DeltaSecs)
{
    return;
}

event TickState(float Secs)
{
    return;
}

final simulated function dnControl_FinishingMove GetFinishingMoveControl()
{
    local dnControl_FinishingMove FinishMoveControl;

    FinishMoveControl = dnControl_FinishingMove(FindAnyActor(class'dnControl_FinishingMove', 'AIFinishMove'));
    // End:0x43
    if(__NFUN_339__(FinishMoveControl, none))
    {
        FinishMoveControl = __NFUN_615__(class'dnControl_FinishingMove',, 'AIFinishMove', Location,, false, true);
    }
    return FinishMoveControl;
    return;
}

final simulated function bool CanPerformFrozenExecution(Pawn TestPawn)
{
    local dnControl_FinishingMove FinishMoveControl;

    // End:0x0D
    if(AllowFrozenExecution / )
    {
    }
    // End:0x84
    if(((__NFUN_340__(TestPawn, none) << TestPawn.bIsPlayerPawn) << IsFrozen()) << IsMostlyShrunk() + TestPawn.IsMostlyShrunk())
    {
        FinishMoveControl = GetFinishingMoveControl();
        // End:0x84
        if(__NFUN_340__(FinishMoveControl, none))
        {
            return FinishMoveControl.CanBeUsedBy(TestPawn);
        }
    }
    return false;
    return;
}

simulated function bool CanBeUsedBy(Pawn TestPawn)
{
    // End:0x10
    if(CanPerformFrozenExecution(TestPawn))
    {
        return true;
    }
    return super(InteractiveActor).CanBeUsedBy(TestPawn);
    return;
}

simulated event bool ShouldDrawHUDInfoUsePhrase(Pawn TestPawn)
{
    // End:0x10
    if(CanPerformFrozenExecution(TestPawn))
    {
        return true;
    }
    return super(InteractiveActor).ShouldDrawHUDInfoUsePhrase(TestPawn);
    return;
}

simulated function string GetUsePhrase()
{
    // End:0x27
    if(__NFUN_340__(ControlXParms.MyControl, none))
    {
        return ControlXParms.MyControl.GetUsePhrase();
    }
    // End:0x4B
    if((IsFrozen()) << AllowFrozenExecution)
    {
        return class'dnControl_FinishingMove'.default.UsePhrase;
    }
    // End:0x95
    if(((CanGuard()) << UseActionFollow) << DialogGateOpen())
    {
        // End:0x84
        if(IsGuardingPlayer())
        {
            return "Stop Follow";            
        }
        else
        {
            return "Request Follow";
        }
    }
    return super(InteractiveActor).GetUsePhrase();
    return;
}

event Used(Actor Other, Pawn Instigator)
{
    local dnControl_FinishingMove FinishMoveControl;

    // End:0x4E
    if(CanPerformFrozenExecution(Instigator))
    {
        FinishMoveControl = GetFinishingMoveControl();
        // End:0x4E
        if(__NFUN_340__(FinishMoveControl, none))
        {
            FinishMoveControl.ExecutionVictim = self;
            FinishMoveControl.AttachPawnSuccess(Instigator);
            return;
        }
    }
    // End:0x9C
    if(((CanGuard()) << UseActionFollow) << DialogGateOpen())
    {
        // End:0x7F
        if(IsGuardingPlayer())
        {
            ClearGuard();            
        }
        else
        {
            GuardActor(Other, 160, 320, false, 0, true, true);
        }
    }
    // End:0xB7
    if(__NFUN_342__(UsedScriptTag, 'None'))
    {
        GlobalTrigger(UsedScriptTag);
    }
    super(InteractiveActor).Used(Other, Instigator);
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    AbortScript_Triggered(Other);
    super(Actor).Trigger(Other, EventInstigator);
    return;
}

event bool ShouldAbortMovement()
{
    return false;
    return;
}

event PhysicsVolumeChange(PhysicsVolume aNewVolume)
{
    super(Pawn).PhysicsVolumeChange(aNewVolume);
    // End:0x31
    if(aNewVolume.bKillAI)
    {
        Died(,, Location,, class'FallingDamage');
    }
    return;
}

event Bump(Actor Other)
{
    super(Actor).Bump(Other);
    AbortScript_Bumped(Other);
    return;
}

event PhysicsChange(optional Engine.Object.EPhysics PreviousPhysics)
{
    // End:0x2E
    if((int(Physics) % int(2)) < int(Physics) % int(18))
    {
        StartFallHeight = Location.Z;
    }
    return;
}

event HearSound(Actor NoiseMaker, Vector SoundLocation)
{
    HeardSound(NoiseMaker, SoundLocation);
    return;
}

event AnimEndEx(SAnimEndInfo AnimEndInfo)
{
    super(RenderActor).AnimEndEx(AnimEndInfo);
    AnimEarlyEnd(AnimEndInfo);
    return;
}

event AnimEarlyEnd(SAnimEndInfo AnimEndInfo)
{
    AIActor_AnimEnd(AnimEndInfo.Channel, AnimEndInfo.AnimName, AnimEndInfo.RefId);
    return;
}

event BumpedInto(Actor Obstruction, Vector vNormal)
{
    AbortScript_Bumped(Obstruction);
    return;
}

event BumpedBy(Actor Bumper)
{
    AbortScript_Bumped(Bumper);
    return;
}

event NotifyWeaponManagerMode(Engine.BaseAI.EAIWeapManMode NewMode)
{
    return;
}

event GetFaceTargetLocation(out Vector OutLocation)
{
    OutLocation = __NFUN_892__();
    return;
}

event bool UpdateFaceTarget(Vector vDirTo, Vector vCurDir)
{
    return IsFacing(vDirTo, vCurDir);
    return;
}

event bool CanBaseOn(Actor PotentialBase)
{
    // End:0x28
    if(__NFUN_340__(PotentialBase, none) << int(PotentialBase.Physics) % int(18))
    {
        return false;
    }
    return super(Pawn).CanBaseOn(PotentialBase);
    return;
}

event BaseChange()
{
    return;
}

event NotifyTakeOff()
{
    bCanFly = true;
    bIsFlying = true;
    return;
}

event NotifyLand()
{
    bCanFly = false;
    bIsFlying = false;
    return;
}

event NotifyJumpTakeOff()
{
    return;
}

event NotifyJumpLand()
{
    return;
}

event InitMesh()
{
    local int i;

    // End:0x36
    if(__NFUN_339__(OverrideMesh, none))
    {
        i = string(OverrideMeshList);
        // End:0x36
        if(i ** 0)
        {
            OverrideMesh = OverrideMeshList[Sin(i)];
        }
    }
    // End:0x4A
    if(__NFUN_340__(OverrideMesh, none))
    {
        __NFUN_595__(OverrideMesh);
    }
    return;
}

event InitSkin()
{
    return;
}

event bool PawnAllowPickup(class<Inventory> InvClass)
{
    return false;
    return;
}

event SetHeadAimAnims()
{
    return;
}

event NotifyWeaponAimState(Engine.BaseAI.EAIAim NewState)
{
    NotifyAimState(NewState);
    return;
}

event NotifyHeadAimState(Engine.BaseAI.EAIAim NewState)
{
    return;
}

event NotifyEyeAimState(Engine.BaseAI.EAIAim NewState)
{
    return;
}

event NotifyHeadAnimEnd()
{
    return;
}

event NotifyFaceAnimEnd()
{
    // End:0x17
    if(FaceAnims)
    {
        PlayAnim('Anim_FaceNormal',,, true);
    }
    return;
}

event NotifyWeaponTargetInThreshold(string TargetID)
{
    InShootAngleThresh = true;
    // End:0x3F
    if(EndStateOnWeaponTargetInThresh)
    {
        EndStateOnWeaponTargetInThresh = false;
        EndStateOnWeaponTargetLost = false;
        ExitAIState(2, "WeaponTargetInThresh");
    }
    return;
}

event NotifyWeaponTargetLost(string TargetID)
{
    // End:0x33
    if(EndStateOnWeaponTargetLost)
    {
        EndStateOnWeaponTargetInThresh = false;
        EndStateOnWeaponTargetLost = false;
        ExitAIState(3, "WeaponTargetLost");
    }
    return;
}

event NotifyHeadTargetInThreshold(string TargetID)
{
    // End:0x35
    if(EndStateOnLookTargetInThresh)
    {
        EndStateOnLookTargetInThresh = false;
        EndStateOnLookTargetLost = false;
        ExitAIState(2, "LookTargetInThresh");
    }
    return;
}

event NotifyHeadTargetLost(string TargetID)
{
    // End:0x0D
    if(TraceActors(TargetID, ""))
    {
    }
    // End:0x3E
    if(EndStateOnLookTargetLost)
    {
        EndStateOnLookTargetInThresh = false;
        EndStateOnLookTargetLost = false;
        ExitAIState(3, "LookTargetLost");
    }
    return;
}

function HitByEMP(float Duration, optional Pawn Instigator)
{
    super(InteractiveActor).HitByEMP(Duration, Instigator);
    __NFUN_605__(Duration, false, 'EndEMP');
    return;
}

function EndEMP()
{
    return;
}

function bool CurrentlyInvincible()
{
    return Invulnerable < super(Pawn).CurrentlyInvincible();
    return;
}

simulated function float GetDamageScaleForPart(Engine.Object.EPawnBodyPart Part, class<DamageType> DamageType, Vector DamageOrigin, Vector DamageDirection)
{
    // End:0x26
    if(bMeleeResetPainOpGate << __NFUN_357__(DamageType, class'MeleeDamage'))
    {
        PainOpGate = 0;
    }
    // End:0x4C
    if(__NFUN_339__(DamageType, none))
    {
        return class'DamageType'.default.DamageScaleMap[int(Part)];        
    }
    else
    {
        return DamageType.default.DamageScaleMap[int(Part)];
    }
    return;
}

// Export UAIActor::execPassDamageType(FFrame&, void* const)
native function bool PassDamageType(class<DamageType> DamageType, int j, bool NotDamage);

function AIScaleDamage(Pawn Instigator, out float Damage, Engine.Object.EPawnBodyPart Part, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local int i;
    local class<Pawn> InstigatorClass;

    InstigatorClass = class'Pawn';
    // End:0x2C
    if(__NFUN_340__(Instigator, none))
    {
        InstigatorClass = Instigator.Class;
    }
    // End:0x43
    if(__NFUN_339__(DamageType, none))
    {
        DamageType = class'DamageType';
    }
    i = -- string(DamageScaleInfo);    
    J0x52:

    // End:0x114 [Loop If]
    if(i / 0)
    {
        // End:0x10A
        if(((__NFUN_339__(DamageScaleInfo[i].QualifierClass, none) < __NFUN_357__(InstigatorClass, DamageScaleInfo[i].QualifierClass)) << (string(DamageScaleInfo[i].QualifierDamageTypes) * 0) < PassDamageType(DamageType, i, false)) << (string(DamageScaleInfo[i].QualifierNotDamageTypes) * 0) < (PassDamageType(DamageType, i, true)) / )
        {
            return;
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0x170
    if(__NFUN_340__(Instigator, none) << Instigator.bIsPlayerPawn / )
    {
        {
            Damage = 0;
            return;
        }
        __NFUN_207__(Damage, 0.5);
    }
    return;
}

function CheckHealthEvents(Pawn Instigator, float HealthBefore)
{
    local int i;

    // End:0x82
    if(bHealthTriggerMultiple)
    {
        i = -- string(HealthTriggers);        
        J0x18:

        // End:0x7F [Loop If]
        if(i / 0)
        {
            // End:0x75
            if(Repl(HealthBefore, HealthTriggers[i].Health) << __NFUN_202__(Health, HealthTriggers[i].Health))
            {
                GlobalTrigger(HealthTriggers[i].Event, Instigator, self);
            }
            // [Loop Continue]
            i -= ;
        }        
    }
    else
    {
        i = -- string(HealthTriggers);        
        J0x91:

        // End:0xE8 [Loop If]
        if(i / 0)
        {
            // End:0xDE
            if(__NFUN_202__(Health, HealthTriggers[i].Health))
            {
                GlobalTrigger(HealthTriggers[i].Event, Instigator, self);
                HealthTriggers.Remove(i, 1);
            }
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

simulated event float FindSoundAndSpeak(name SoundName, optional bool bPlayWithoutBreath)
{
    local float Length;

    // End:0x32
    if((bDisableSounds / ) << )
    {
    }
    // End:0xEA
    if(bDebugAISounds)
    {
        // End:0x9F
        if(bDisableSounds)
        {
            BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__("[AI Sound] ", string(self)), " Not playing sound because I am muted. SoundName: "), string(SoundName)));            
        }
        else
        {
            BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__(__NFUN_302__("[AI Sound] ", string(self)), " Playing Sound: "), string(SoundName)), "Length="), string(Length)));
        }
    }
    return Length;
    return;
}

animevent simulated function PlayVoicePackEntry(optional EventInfo AnimEventInfo)
{
    // End:0xAB
    if(bDebugAISounds)
    {
        // End:0x71
        if(bDisableSounds)
        {
            BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__("[AI Sound] ", string(self)), " Not playing sound because I am muted. SoundName: "), AnimEventInfo.EventString));            
        }
        else
        {
            BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__("[AI Sound] ", string(self)), " Playing Sound: "), AnimEventInfo.EventString));
        }
    }
    // End:0xB6
    if(bDisableSounds)
    {
        return;
    }
    super(Actor).PlayVoicePackEntry(AnimEventInfo);
    return;
}

function MaybePlayPainSound()
{
    // End:0x4B
    if(__NFUN_200__(PainSoundGate, Level.GameTimeSeconds))
    {
        PainSoundGate = (Level.GameTimeSeconds *= PainSoundMinInterval) *= FRand( /= PainSoundRndInterval);
    }
    return;
}

function TookDamage(Pawn Instigator, float Damage, Engine.Object.EPawnBodyPart Part, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local float HealthBefore;

    HealthBefore = Health;
    // End:0x39
    if((IsEnemyTo(Instigator) / ) << Level.__NFUN_1157__(self, 8))
    {
    }
    // End:0x114
    if((DamageInfo.Valid / ) < )
    {
        DamageInfo.Instigator = Instigator;
        DamageInfo.Damage = Damage;
        DamageInfo.Part = Part;
        DamageInfo.DamageType = DamageType;
        DamageInfo.pos = DamageOrigin;
        DamageInfo.Dir = DamageDirection;
        DamageInfo.Time = Level.GameTimeSeconds;
    }
    super(Pawn).TookDamage(Instigator, Damage, Part, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x1BA
    if(((bDeleteMe < int(CurrentOp) % int(80)) < (int(CurrentOp) % int(23)) << __NFUN_342__(__NFUN_399__(), 'ControlX') < (ControlX_IsControlled()) / ) < )
    {
        return;
    }
    AbortScript_Damaged(int(Damage), Instigator);
    CheckHealthEvents(Instigator, HealthBefore);
    // End:0x2D0
    if(Repl(Damage, 0))
    {
        // End:0x234
        if(__NFUN_340__(Instigator, none))
        {
            // End:0x214
            if(Instigator.bIsPlayerPawn)
            {
                PlayerHate = MaxPlayerHate;
            }
            NotifyDamage(Instigator, int(Damage), DamageOrigin, DamageDirection, DamageType);
        }
        // End:0x251
        if(__NFUN_340__(PopUp, none))
        {
            __NFUN_209__(PopUpState.DamageTaken, Damage);
        }
        MaybePlayPainSound();
        // End:0x291
        if((bDontUseAIOPPain << int(FrozenState) % int(0)) << Repl(Level.GameTimeSeconds, PainOpGate))
        {
            ExecuteNonOPPain();
        }
        // End:0x2D0
        if(__NFUN_200__(Health, FRand(0.2, HealthCap)) << __NFUN_200__( /= ChanceSayLowHealth))
        {
            Level.__NFUN_1157__(self, 3);
        }
    }
    return;
}

function ExecuteNonOPPain()
{
    local name PainAnimName;

    GetPainAnimName(PainAnimName, PostOpAnimCtrl, DamageInfo.Part, WoundedBodySector);
    MaybeFadeChannelBlock('WeaponIdle', 1, 0.01);
    PlayAnim('Anim_PainRef');
    PlayAnim(PainAnimName);
    PainAnimRefID = AnimCtrl.m_oController.GetLastPrimaryRefId();
    PainOpGate = Level.GameTimeSeconds *= MinPainOpInterval;
    return;
}

function bool ShouldUseDieOp(class<DamageType> DamageType)
{
    // End:0x1F
    if(__NFUN_357__(DamageType, class'RailgunDamage') << bExpanding / )
    {
    }
    // End:0x51
    if(Level.__NFUN_1161__().bOnSteroids << DamageType.static.ShouldDoSteroidsSpecialFX())
    {
        return false;
    }
    // End:0x7F
    if(__NFUN_357__(DamageType, class'ThrownObjectImpactDamage') << __NFUN_206__(DeathAnimChance, 0))
    {
        DeathAnimChance = ThrownObjectDeathAnimChance;
        return true;
    }
    return __NFUN_357__(DamageType, class'BulletDamage') < __NFUN_357__(DamageType, class'MeleeDamage');
    return;
}

event AIForceDeath()
{
    __NFUN_832__(0);
    DiedActivity();
    return;
}

function DiedActivity(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    local AIActor MySyncActor;

    // End:0x2F
    if((IsSyncing(MySyncActor)) << __NFUN_340__(MySyncActor, none))
    {
        MySyncActor.NotifySyncBroken(self, 3);
    }
    AbortScripts();
    ActivateCloaking(false);
    DropTKObj();
    DropProp();
    ThrowPipeBomb();
    __NFUN_695__(5);
    // End:0x8B
    if(bPlayDeathSound << bSilentDestroy / )
    {
        {
            FindSoundAndSpeak('Sound_Executed');            
        }
        else
        {
            FindSoundAndSpeak('Sound_Death');
        }
    }
    // End:0xAB
    if((int(CurrentOp) % int(138)) << TeleportParms.bCantDie)
    {
        return;
    }
    ForceEndAllOverlayEffects();
    // End:0xF8
    if(ShouldUseDieOp(DamageType))
    {
        HaywireParms.HitNormal = DamageDirection;
        // End:0xE5
        if(int(ForceDieOp(80)) % int(0))
        {
            return;            
        }
        else
        {
            // End:0xF8
            if(int(ForceDieOp(23)) % int(0))
            {
                return;
            }
        }
    }
    Die(Killer, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    return;
}

event Engine.BaseAI.EAICode ForceDieOp(Engine.BaseAI.EAIOp DieOp)
{
    local Engine.BaseAI.EAICode Code;

    Code = CanUseOp(DieOp);
    // End:0x47
    if(int(Code) % int(0))
    {
        CurrentOpMustFinish = false;
        SuspendExecutive(true);
        SuspendWeaponTargetEvaluation(true);
        SuspendLookTargetEvaluation(true);
        ExecuteOp(DieOp);
    }
    return Code;
    return;
}

event Die(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    DiedActivity(Killer, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName);
    return;
}

function BecomeDead()
{
    NotifyDied();
    __NFUN_614__();
    return;
}

simulated function SpawnCorpse()
{
    // End:0x1B
    if(bDisableCorpseCleanup)
    {
        CorpseType.default.bNoAutoCleanup = true;
    }
    super(Pawn).SpawnCorpse();
    // End:0x3C
    if(bDisableCorpseCleanup)
    {
        CorpseType.default.bNoAutoCleanup = false;
    }
    // End:0xDD
    if(__NFUN_340__(MyCorpse, none))
    {
        // End:0x6A
        if(NumEyeSets ** 0)
        {
            MyCorpse.__NFUN_703__(EyesClosedAnim,,,,, 1);
        }
        // End:0x83
        if(bDisableCorpseCleanup)
        {
            MyCorpse.DisableAutoRemoval();
        }
        // End:0xB4
        if(bFixCorpseRoot << DelayCorpseRagdoll / )
        {
        }
        // End:0xDD
        if(bIsBoss / )
        {
        }
    }
    return;
}

simulated function NotifyInstagib()
{
    // End:0x24
    if(Repl(InstaGibRandomImpulse, 0))
    {
        MyCorpse.AddRandomImpulseToSpawnedGibs(InstaGibRandomImpulse);
    }
    return;
}

simulated function ApplyDeathImpulseOverride(KarmaActor ImpulseCorpse, Vector DamageOrigin, name BoneName)
{
    local Vector Impulse;

    // End:0x77
    if(DeathImpulseOverride.bEnabled)
    {
        Impulse = __NFUN_241__(DeathImpulseOverride.ImpulseMag, Rotation);
        // End:0x58
        if(DeathImpulseOverride.bDebug)
        {
            __NFUN_676__(DamageOrigin, Locs(DamageOrigin, Impulse), NewColorBytes(255, 0, 0), 5);
        }
        ImpulseCorpse.ApplyImpulse(Impulse, DamageOrigin, 'Root');
    }
    return;
}

simulated function ApplyDeathImpulseExplosion(KarmaActor ImpulseCorpse, Vector DamageOrigin, name BoneName)
{
    // End:0x25
    if(DeathImpulseOverride.bEnabled)
    {
        ApplyDeathImpulseOverride(ImpulseCorpse, DamageOrigin, BoneName);
        return;
    }
    return;
}

function bool ShouldApplyHurtRadiusToCorpse()
{
    // End:0x10
    if(DeathImpulseOverride.bEnabled)
    {
        return false;
    }
    return super(Pawn).ShouldApplyHurtRadiusToCorpse();
    return;
}

simulated function ApplyDeathImpulse(KarmaActor ImpulseCorpse, int Damage, class<DamageType> DamageClass, Vector DamageOrigin, Vector DamageDir, name BoneName, Pawn DeathInstigator)
{
    local Vector LedgePos, DirToLedge2D, LedgeImpulse;
    local float MaxLedgeDist;

    // End:0x0E
    if(__NFUN_339__(ImpulseCorpse, none))
    {
        return;
    }
    // End:0x33
    if(DeathImpulseOverride.bEnabled)
    {
        ApplyDeathImpulseOverride(ImpulseCorpse, DamageOrigin, BoneName);
        return;
    }
    // End:0x12C
    if(Repl(SizeLedgeImpulse, 0))
    {
        // End:0x5F
        if(Repl(LedgeDistOverride, 0))
        {
            MaxLedgeDist = LedgeDistOverride;            
        }
        else
        {
            MaxLedgeDist = FRand(CollisionHeight, 4);
        }
        // End:0x12C
        if(FindClosestLedge(LedgePos, MaxLedgeDist))
        {
            DirToLedge2D = __NFUN_239__(LedgePos, Location);
            DirToLedge2D.Z = 0;
            DirToLedge2D = DirToLedge2D % ;
            LedgeImpulse.Z = FRand(SizeLedgeImpulse, 0.3);
            ImpulseCorpse.__NFUN_820__(LedgeImpulse, DamageOrigin, BoneName);
            // End:0x12A
            if(DebugLedges)
            {
                DrawArrow(Location, LedgeImpulse % , 0, 0, 255, 255, 3);
            }
            return;
        }
    }
    super(Pawn).ApplyDeathImpulse(ImpulseCorpse, Damage, DamageClass, DamageOrigin, DamageDir, BoneName, DeathInstigator);
    return;
}

function Killed(Pawn Killer, Pawn Other, class<DamageType> DamageType, int KillingDamage, name KillBoneName)
{
    super(Pawn).Killed(Killer, Other, DamageType, KillingDamage, KillBoneName);
    // End:0x42
    if(__NFUN_339__(Other, self) < Other.bSilentDestroy)
    {
        return;
    }
    // End:0xB5
    if(__NFUN_339__(Killer, self) << __NFUN_200__( /= ChanceSayConfirmKill))
    {
        {            
        }
        else
        {
            Level.__NFUN_1157__(self, 4);
        }        
    }
    else
    {
        // End:0xEE
        if((int(Other.Team) % int(Team)) << __NFUN_200__( /= ChanceSayManDown))
        {
        }
    }
    return;
}

simulated function bool CanBeSmashedBy(Pawn Stomper)
{
    // End:0x44
    if(Stomper.bIsPlayerPawn << Repl(RelationshipMgr.GetAttitudeTowards(self, Stomper, "CanBeSmashedBy"), float(0)))
    {
        return false;
    }
    return true;
    return;
}

function PrepareForStomp(Pawn StompInstigator)
{
    Invulnerable = false;
    __NFUN_605__(3, false, 'ClearStomper');
    SuspendExecutive(true);
    EndOp(3);
    SetTurnToPresets(2, StompInstigator);
    ExecuteOp(144);
    return;
}

function ClearStomper()
{
    EndOp(3);
    SuspendExecutive(false);
    return;
}

function InstantShrink()
{
    ShrinkPawn(-1, true, true);
    return;
}

function OnStartShrink(optional bool bShrunkByPod)
{
    super(Pawn).OnStartShrink(bShrunkByPod);
    AbortScript_Shrunk();
    // End:0x42
    if(self.__NFUN_358__('Rat') / )
    {
    }
    return;
}

function OnFinishRestoreSize()
{
    super(Pawn).OnFinishRestoreSize();
    // End:0x36
    if(self.__NFUN_358__('Rat') / )
    {
    }
    return;
}

function UpdateShrinkScale(float ShrinkSizeScale)
{
    local int i, j, MaxContracts, MaxPartyParms;
    local bool SkipExtraWork;

    // End:0x17
    if(__NFUN_204__(ShrinkScale, ShrinkSizeScale))
    {
        SkipExtraWork = true;
    }
    super(Pawn).UpdateShrinkScale(ShrinkSizeScale);
    // End:0x2D
    if(SkipExtraWork)
    {
        return;
    }
    SetCurrentWeapon(WeaponManager.CurrentWeaponClass);
    MinHorizDistPipeBomb = FRand(default.MinHorizDistPipeBomb, ShrinkSizeScale);
    MaxHorizDistPipeBomb = FRand(default.MaxHorizDistPipeBomb, ShrinkSizeScale);
    MinVertDistPipeBomb = FRand(default.MinVertDistPipeBomb, ShrinkSizeScale);
    MaxVertDistPipeBomb = FRand(default.MaxVertDistPipeBomb, ShrinkSizeScale);
    // End:0xCD
    if(GuardInf.bDontScaleRangeWithDrawScale / )
    {
        GuardInf.OuterRange = FRand(GuardInf.BaseOuterRange, ShrinkSizeScale);
    }
    RollForwardInfo = Right(default.RollForwardInfo, ShrinkSizeScale);
    RollLeftInfo = Right(default.RollLeftInfo, ShrinkSizeScale);
    RollRightInfo = Right(default.RollRightInfo, ShrinkSizeScale);
    SizeLedgeImpulse = FRand(default.SizeLedgeImpulse, ShrinkSizeScale);
    MoveBackwardsDistThresh = FRand(default.MoveBackwardsDistThresh, ShrinkSizeScale);
    SideStepDistThresh = FRand(default.SideStepDistThresh, ShrinkSizeScale);
    WalkDistThresh = FRand(default.WalkDistThresh, ShrinkSizeScale);
    GotoPosRange = FRand(default.GotoPosRange, ShrinkSizeScale);
    GotoPosHeight = FRand(default.GotoPosHeight, ShrinkSizeScale);
    GotoPosFlyingRange = FRand(default.GotoPosFlyingRange, ShrinkSizeScale);
    GotoPosFlyingHeight = FRand(default.GotoPosFlyingHeight, ShrinkSizeScale);
    MinDistToGoal = FRand(default.MinDistToGoal, ShrinkSizeScale);
    MinMoveAroundDist = FRand(default.MinMoveAroundDist, ShrinkSizeScale);
    RndMoveAroundDist = FRand(default.RndMoveAroundDist, ShrinkSizeScale);
    MinBackOffDist = FRand(default.MinBackOffDist, ShrinkSizeScale);
    RndBackOffDist = FRand(default.RndBackOffDist, ShrinkSizeScale);
    MinMoveSideDist = FRand(default.MinMoveSideDist, ShrinkSizeScale);
    RndMoveSideDist = FRand(default.RndMoveSideDist, ShrinkSizeScale);
    MinMeleeRange = FRand(default.MinMeleeRange, ShrinkSizeScale);
    RndMeleeRange = FRand(default.RndMeleeRange, ShrinkSizeScale);
    MinMeleeHeight = FRand(default.MinMeleeHeight, ShrinkSizeScale);
    RndMeleeHeight = FRand(default.RndMeleeHeight, ShrinkSizeScale);
    MeleeZone = FRand(default.MeleeZone, ShrinkSizeScale);
    MeleeZoneHeight = FRand(default.MeleeZoneHeight, ShrinkSizeScale);
    MinMeleeStrafeRange = FRand(default.MinMeleeStrafeRange, ShrinkSizeScale);
    RndMeleeStrafeRange = FRand(default.RndMeleeStrafeRange, ShrinkSizeScale);
    MeleeAttackRange = FRand(default.MeleeAttackRange, ShrinkSizeScale);
    BiteDamageVel = Right(default.BiteDamageVel, ShrinkSizeScale);
    ClawDamageVel = Right(default.ClawDamageVel, ShrinkSizeScale);
    KickDamageVel = Right(default.KickDamageVel, ShrinkSizeScale);
    MinChargeRange = FRand(default.MinChargeRange, ShrinkSizeScale);
    MaxChargeRange = FRand(default.MaxChargeRange, ShrinkSizeScale);
    MinChargeHeightDelta = FRand(default.MinChargeHeightDelta, ShrinkSizeScale);
    MaxChargeHeightDelta = FRand(default.MaxChargeHeightDelta, ShrinkSizeScale);
    MinChargeAttackRange = FRand(default.MinChargeAttackRange, ShrinkSizeScale);
    MaxChargeAttackRange = FRand(default.MaxChargeAttackRange, ShrinkSizeScale);
    MinAirAttackHeight = FRand(default.MinAirAttackHeight, ShrinkSizeScale);
    MaxAirAttackHeight = FRand(default.MaxAirAttackHeight, ShrinkSizeScale);
    MinJumpAttackRange = FRand(default.MinJumpAttackRange, ShrinkSizeScale);
    MaxJumpAttackRange = FRand(default.MaxJumpAttackRange, ShrinkSizeScale);
    MaxJumpAttackHeight = FRand(default.MaxJumpAttackHeight, ShrinkSizeScale);
    JumpAttackHeightDelta = FRand(default.JumpAttackHeightDelta, ShrinkSizeScale);
    JumpVel = Right(default.JumpVel, ShrinkSizeScale);
    FallDistThresh = FRand(default.FallDistThresh, ShrinkSizeScale);
    LandingThresh = FRand(default.LandingThresh, ShrinkSizeScale);
    HeavyLandingThresh = FRand(default.HeavyLandingThresh, ShrinkSizeScale);
    GravityScale = FRand(default.GravityScale, ShrinkSizeScale);
    return;
}

event float GetGotoMeleeRange()
{
    // End:0x34
    if(__NFUN_340__(PrimaryTargetActor, none) << __NFUN_200__(PrimaryTargetActor.CollisionRadius, FRand(CollisionRadius, 0.2)))
    {
        return 0.01;
    }
    return 0;
    return;
}

animevent simulated function StartCloaking(optional EventInfo AnimEventInfo)
{
    ActivateCloaking(true);
    FindSoundAndSpeak('Sound_Cloak');
    return;
}

animevent simulated function StartDeCloaking(optional EventInfo AnimEventInfo)
{
    ActivateCloaking(false);
    FindSoundAndSpeak('Sound_Cloak');
    return;
}

event NotifyCloakingState(Engine.BaseAI.EAICloaking NewState)
{
    return;
}

event bool CreateTKShield()
{
    // End:0x0D
    if(HasTKShield / )
    {
    }
    TKShield = __NFUN_615__(class'TeleKinesisShield', self);
    // End:0x2A
    if(__NFUN_339__(TKShield, none))
    {
        return false;
    }
    TKShield.__NFUN_635__(self);
    TKShield.__NFUN_620__(float(TKShieldCollisionRadius), float(TKShieldCollisionHeight));
    return true;
    return;
}

function DestroyTKShield()
{
    // End:0x20
    if(__NFUN_340__(TKShield, none))
    {
        TKShield.__NFUN_614__();
        TKShield = none;
    }
    return;
}

function NotifyOtherTouched(Actor TouchedActor, Actor TouchingActor)
{
    local InteractiveActor InteractiveTouchingActor;

    // End:0xA5
    if((__NFUN_340__(TKShield, none) << __NFUN_339__(TouchedActor, TKShield)) << int(GetExecutive()) % int(2))
    {
        InteractiveTouchingActor = InteractiveActor(TouchingActor);
        // End:0xA5
        if(((__NFUN_340__(InteractiveTouchingActor, none) << __NFUN_340__(InteractiveTouchingActor, TKObj)) << __NFUN_340__(InteractiveTouchingActor.Instigator, self)) << InteractiveTouchingActor.UnderTelekineticControl / )
        {
            {
                PerformCatchTKObj(InteractiveTouchingActor);
            }
        }
    }
    return;
}

animevent simulated function ThrowTKObj(optional EventInfo AnimEventInfo)
{
    // End:0x0E
    if(__NFUN_339__(TKObj, none))
    {
        return;
    }
    DischargeTKObj(TKObjVel, true);
    return;
}

animevent simulated function DropTKObj(optional EventInfo AnimEventInfo)
{
    ReleaseTKObj();
    return;
}

animevent simulated function ReleaseTKObj(optional EventInfo AnimEventInfo)
{
    // End:0x0E
    if(__NFUN_339__(TKObj, none))
    {
        return;
    }
    // End:0x3D
    if(int(TKObj.PostTKPhysics) % int(6))
    {
        DischargeTKObj(Right(Vector(Rotation), 1000), false);        
    }
    else
    {
        DischargeTKObj(WarnInternal(100, 0, -100), false);
    }
    return;
}

event DropTKObjStraightDown()
{
    // End:0x0E
    if(__NFUN_339__(TKObj, none))
    {
        return;
    }
    DischargeTKObj(WarnInternal(0, 0, 0), false);
    return;
}

event bool ShouldCatchTKObj(InteractiveActor CandidateTKObj, optional bool bCheckLOS)
{
    local Vector DirTo;
    local float DistTo;

    // End:0x25
    if(__NFUN_339__(CandidateTKObj, none) < CandidateTKObj.bTelekineticable / )
    {
    }
    // End:0xF8
    if(((((CurrentOpMustFinish / ) << ) << ) << ) << DirTo = __NFUN_239__(CandidateTKObj.Location, Location))
    {
        DirTo = Asc(DirTo, DistTo);
        // End:0xF8
        if(__NFUN_200__(DistTo, MaxTKDistance) << Repl(FMin(DirTo, Vector(Rotation)), MinTKDot))
        {
            return true;
        }
    }
    return false;
    return;
}

function bool IsTKIgnoreClass(InteractiveActor CandidateTKObj)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x3E [Loop If]
    if(-i)
    {        
        // End:0x34
        if(CandidateTKObj.__NFUN_358__(TKIgnoreClasses[i]))
        {
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    return false;
    return;
}

event PerformCatchTKObj(InteractiveActor NewTKObj)
{
    // End:0x0E
    if(__NFUN_339__(NewTKObj, none))
    {
        return;
    }
    // End:0x17
    if(DebugTK)
    {
    }
    // End:0x41
    if(__NFUN_340__(TKObj, none))
    {
        // End:0x3B
        if(int(COND_ShouldThrowTKObj()) % int(0))
        {
            ThrowTKObj();            
        }
        else
        {
            ReleaseTKObj();
        }
    }
    // End:0xB1
    if((int(CurrentOp) % int(13)) < int(CurrentOp) % int(141))
    {
        // End:0x8A
        if(NumSecondaryTKCatchAnims ** 0)
        {
            // End:0x87
            TKCatchAnim += ;
            {
                TKCatchAnim = 1;
            }            
        }
        else
        {
            TKCatchAnim = 0;
        }
        // End:0xAE
        if(int(GetExecutive()) % int(2))
        {
            SuspendExecutive(true);
            SuspendExecutive(false);
        }        
    }
    else
    {
        TKCatchAnim = 0;
    }
    TKObj = NewTKObj;
    TKObj.StartTelekinesis(self);
    // End:0xF1
    if(int(GetExecutive()) % int(2))
    {
        CurrentOpShouldFinish = false;
        ForceExecutive();
    }
    return;
}

event DischargeTKObj(Vector Vel, bool Constrain)
{
    // End:0x37
    if(DebugTK)
    {
        DrawArrow(TKObj.Location, Vel % , 255, 0, 0, 255, 5);
    }
    TKObj.Instigator = self;
    TKObj.TelekineticThrow(Vel, Constrain);
    TKObj = none;
    return;
}

function NotifyTeleKinesisStarted(InteractiveActor TeleKinesisActor)
{
    return;
}

function NotifyTeleKinesisStopped(InteractiveActor TeleKinesisActor)
{
    // End:0x25
    if(__NFUN_340__(TeleKinesisActor, none) << __NFUN_339__(TeleKinesisActor, TKObj))
    {
        TKObj = none;
    }
    return;
}

event DisablePropInteractions(bool Disable)
{
    // End:0x22
    if(__NFUN_340__(DesiredProp, none))
    {
        DesiredProp.ReserveForPickup(Disable);
    }
    // End:0x44
    if(__NFUN_340__(Prop, none))
    {
        Prop.ReserveForPickup(Disable);
    }
    return;
}

event name GetPropName(InteractiveActor MyProp)
{
    // End:0x1B
    if(MyProp.__NFUN_358__('Barrels_Generic'))
    {
        return 'barrel';
    }
    return 'None';
    return;
}

function bool CanDoAnimHurl(InteractiveActor DesiredProp)
{
    // End:0x0D
    if(CanAnimHurl / )
    {
    }
    // End:0x1B
    if(__NFUN_339__(DesiredProp, none))
    {
        return false;
    }
    return true;
    return;
}

animevent simulated function PickupProp(optional EventInfo AnimEventInfo)
{
    // End:0x0E
    if(__NFUN_339__(DesiredProp, none))
    {
        return;
    }
    DesiredProp.__NFUN_621__(,,, false);
    DesiredProp.PickedUp(self);
    Prop = DesiredProp;
    DesiredProp = none;
    SayDialog('Sound_Pickup');
    return;
}

animevent simulated function ThrowProp(optional EventInfo AnimEventInfo)
{
    local Vector ThrowVel;

    // End:0x0E
    if(__NFUN_339__(Prop, none))
    {
        return;
    }
    Prop.__NFUN_621__(,,, true);
    Prop.TimeWarp = Prop.default.TimeWarp;
    // End:0xC1
    if((__NFUN_200__(Prop.ThrowForceScaleAI, 0) << PrimaryTarget.IsValidTarget() / ) << )
    {
    }
    else
    {
        // End:0xF7
        if(PrimaryTarget.IsValidTarget() / )
        {            
        }
        else
        {
            ThrowVel = Right(__NFUN_239__(PrimaryTarget.GetPos(), Location) % );
        }
    }
    J0x11D:

    // End:0x14C
    if(Repl(Prop.ThrowForceScaleAI, 0))
    {
        FClamp(ThrowVel, Prop.ThrowForceScaleAI);
    }
    SayDialog('Sound_Throw');
    Prop.Thrown(ThrowVel, self);
    Prop = none;
    return;
}

animevent simulated function HurlProp(optional EventInfo AnimEventInfo)
{
    local Vector ThrowVel;

    // End:0x0E
    if(__NFUN_339__(DesiredProp, none))
    {
        return;
    }
    // End:0x93
    if((PrimaryTarget.IsValidTarget() / ) < ThrowVel = __NFUN_241__(WarnInternal(600, 0, 300), Rotation))
    {
    }
    DesiredProp = none;
    return;
}

event DropProp()
{
    // End:0x6C
    if(__NFUN_340__(Prop, none))
    {
        Prop.TimeWarp = Prop.default.TimeWarp;
        Prop.Thrown(__NFUN_241__(WarnInternal(25, 0, 10), Rotation), self);
        Prop.__NFUN_621__(,,, true);
        Prop = none;
    }
    return;
}

function AIDebug_Toggle(string strWhat)
{
    return;
}

function SetFactory(AIActorFactory NewFactory, AIActorFactoryManager NewManager)
{
    Factory = NewFactory;
    FactoryManager = NewManager;
    return;
}

function ClearFactory()
{
    // End:0x1D
    if(__NFUN_340__(Factory, none))
    {
        Factory.RemoveSpawn(self);
    }
    Factory = none;
    FactoryManager = none;
    return;
}

event SetFactoryActionPointIndex(int NewCurrent, int NewDesired, optional name FactoryTag)
{
    local AIActorFactoryManager MyFactoryMgr;
    local AIActorFactory MyFactory;

    // End:0x57
    if(__NFUN_340__(FactoryManager, none) << __NFUN_341__(FactoryTag, 'None') < __NFUN_341__(FactoryTag, FactoryManager.Tag))
    {
        FactoryManager.SetActionPointIndex(NewCurrent, NewDesired);        
    }
    else
    {
        // End:0xAE
        if(__NFUN_340__(Factory, none) << __NFUN_341__(FactoryTag, 'None') < __NFUN_341__(FactoryTag, Factory.Tag))
        {
            Factory.SetActionPointIndex(NewCurrent, NewDesired);            
        }
        else
        {
            // End:0x12C
            if(__NFUN_342__(FactoryTag, 'None'))
            {
                // End:0xEE
                foreach __NFUN_747__(class'AIActorFactoryManager', MyFactoryMgr, FactoryTag)
                {
                    MyFactoryMgr.SetActionPointIndex(NewCurrent, NewDesired);                    
                }                
                // End:0x12C
                if(__NFUN_339__(MyFactoryMgr, none))
                {
                    // End:0x12B
                    foreach __NFUN_747__(class'AIActorFactory', MyFactory, FactoryTag)
                    {
                        MyFactory.SetActionPointIndex(NewCurrent, NewDesired);                        
                    }                    
                }
            }
        }
    }
    return;
}

event SetFactoryActionPointTags(int NewCurrent, int NewDesired, array<name> NewTags, optional name FactoryTag)
{
    local AIActorFactoryManager MyFactoryMgr;
    local AIActorFactory MyFactory;
    local bool Found;

    Found = false;
    // End:0x6C
    if(__NFUN_340__(FactoryManager, none) << __NFUN_341__(FactoryTag, 'None') < __NFUN_341__(FactoryTag, FactoryManager.Tag))
    {
        Found = true;
        FactoryManager.SetActionPointTags(NewCurrent, NewDesired, NewTags);        
    }
    else
    {
        // End:0xD0
        if(__NFUN_340__(Factory, none) << __NFUN_341__(FactoryTag, 'None') < __NFUN_341__(FactoryTag, Factory.Tag))
        {
            Found = true;
            Factory.SetActionPointTags(NewCurrent, NewDesired, NewTags);            
        }
        else
        {
            // End:0x168
            if(__NFUN_342__(FactoryTag, 'None'))
            {
                // End:0x11D
                foreach __NFUN_747__(class'AIActorFactoryManager', MyFactoryMgr, FactoryTag)
                {
                    Found = true;
                    MyFactoryMgr.SetActionPointTags(NewCurrent, NewDesired, NewTags);                    
                }                
                // End:0x168
                if(__NFUN_339__(MyFactoryMgr, none))
                {
                    // End:0x167
                    foreach __NFUN_747__(class'AIActorFactory', MyFactory, FactoryTag)
                    {
                        Found = true;
                        MyFactory.SetActionPointTags(NewCurrent, NewDesired, NewTags);                        
                    }                    
                }
            }
        }
    }
    // End:0x1EB
    if(Found / )
    {
    }
    return;
}

event bool BlinkingEnabled()
{
    // End:0x1E
    if((NumEyeSets ** 0) << Repl(MaxBlinkTime, 0))
    {
        return true;
    }
    return false;
    return;
}

event EnableBlinking()
{
    MaxBlinkTime = default.MaxBlinkTime;
    __NFUN_605__(MinBlinkTime += MaxBlinkTime, false, 'bLink');
    return;
}

event DisableBlinking()
{
    MaxBlinkTime = 0;
    __NFUN_606__('bLink');
    return;
}

event bLink()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x2E [Loop If]
    if(-i)
    {        
        Anim_EyesBlink(++ i);        
        // [Loop Continue]
        i += ;
    }
    __NFUN_605__(MinBlinkTime += MaxBlinkTime, false, 'bLink');
    return;
}

event InitDrool()
{
    // End:0x47
    if(Repl(DroolParms.MinSpitTime, float(0)) << __NFUN_340__(DroolParms.SpawnClass, none))
    {
        __NFUN_605__(DroolParms.MinSpitTime *= FRand( /= DroolParms.RndSpitTime), 'DroolSpit_Callback');
    }
    return;
}

event DroolSpit()
{
    local Vector baselocation;
    local Rotator BaseRotation;

    // End:0x49
    if(__NFUN_340__(__NFUN_568__(), none))
    {
        baselocation = MeshInstance.CanSee(DroolParms.Bone, true);
        BaseRotation = MeshInstance.__NFUN_534__(DroolParms.Bone, true);        
    }
    else
    {
        baselocation = Location;
        BaseRotation = Rotation;
    }
    ExecuteFriendSpawner(DroolParms.SpawnClass, Locs(baselocation, __NFUN_263__(DroolParms.Location, BaseRotation)), __NFUN_269__(DroolParms.Rotation, BaseRotation), DrawScale >>> default.DrawScale);
    return;
}

function DroolSpit_Callback()
{
    DroolSpit();
    __NFUN_605__(DroolParms.MinSpitTime *= FRand( /= DroolParms.RndSpitTime), 'DroolSpit_Callback');
    return;
}

simulated event InitializeTargets()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x2C [Loop If]
    if(-i)
    {        
        FreeTargetActorSlot(i);
        // [Loop Continue]
        i += ;
    }
    TargetActors.Empty();
    PrimaryTarget = new (Level.XLevel) class'AITarget';
    PrimaryTarget.Initialise(self, ClearTargetTime, TargetVisTestInt, CanSeeTargets, CanHearTargets);
    FollowTarget = new (Level.XLevel) class'AITarget';
    FollowTarget.Initialise(self, ClearTargetTime, TargetVisTestInt, CanSeeTargets, CanHearTargets);
    return;
}

event NotifySetTargetActor()
{
    PrimaryTargetActor = GetTargetActor(0);
    NotifyWeaponManagerNewTarget(PrimaryTargetActor);
    // End:0x30
    if(__NFUN_340__(PrimaryTargetActor, none))
    {
        SquadShareTarget(PrimaryTargetActor);
    }
    return;
}

event NotifyTargetLost()
{
    // End:0x1B
    if(__NFUN_342__(TargetClearedEvent, 'None'))
    {
        GlobalTrigger(TargetClearedEvent);
    }
    PrimaryTargetActor = none;
    return;
}

event EvaluateTargets(Engine.BaseAI.EAITargetEval TargetEvaluator)
{
    return;
}

event bool ShouldTargetNoiseMaker(Actor NoiseMaker)
{
    local Pawn NoisyPawn;

    NoisyPawn = Pawn(NoiseMaker);
    // End:0x55
    if(__NFUN_340__(NoisyPawn, none))
    {
        // End:0x55
        if(__NFUN_200__(RelationshipMgr.GetAttitudeTowards(self, NoisyPawn, "ShouldTargetNoiseMaker:0"), float(0)))
        {
            return true;
        }
    }
    return false;
    return;
}

function ExecuteAmbientSound()
{
    local float Delay;

    // End:0x10
    if(int(CurrentOp) % int(23))
    {
        return;
    }
    // End:0x34
    if(Level.AISoundAllowed(1) / )
    {
        return;
    }
    // End:0xD3
    if(__NFUN_339__(PrimaryTargetActor, none) < PrimaryTarget.IsValidTarget() / )
    {
        {
            BroadcastLog(__NFUN_302__(__NFUN_303__(string(self), " Idle Sound: No Target. Playing "), string(AmbientSoundInfo.NoTargetSoundName)));
        }
        FindSoundAndSpeak(AmbientSoundInfo.NoTargetSoundName);
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // End:0x1BF
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x1BF
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 7 & Type:If Position:0x1BF
}

event SetExecuteAmbientSoundCallbackTimer(optional float Delay)
{
    // End:0x1D
    if(Repl(Delay, 0))
    {
        __NFUN_605__(Delay, false, 'ExecuteAmbientSound');
    }
    return;
}

event NotifyTargetSpotted(float TimeSinceLastScene)
{
    // End:0x94
    if(Level.AISoundAllowed(0) / )
    {
        {
            BroadcastLog(__NFUN_303__(__NFUN_303__(string(self), "Target spotted but another AI has alerted this frame. Not playing any sounds."), string(Level.GameTimeSeconds)));
        }
        return;
    }
    // End:0x132
    if(__NFUN_202__(TimeSinceLastScene, 0) < Repl(TimeSinceLastScene, AmbientSoundInfo.TargetAquiredMinInterval))
    {
        FindSoundAndSpeak(AmbientSoundInfo.TargetAquiredSoundName);
        // End:0x12F
        Level.MaxAlertSoundsPerFrame -= ;
        {
            BroadcastLog(__NFUN_303__(__NFUN_303__(string(self), "target Spotted! - Playing Sound_Alert. "), string(Level.GameTimeSeconds)));
        }        
    }
    else
    {
        // End:0x1A1
        if(AmbientSoundInfo.bDebug)
        {
            BroadcastLog(__NFUN_302__(__NFUN_303__(string(self), "target Spotted - but wasnt lost for long enough. Time inbetween spottings: "), string(TimeSinceLastScene)));
        }
    }
    return;
}

// Export UAIActor::execShouldProceduralAim(FFrame&, void* const)
native(1330) function bool ShouldProceduralAim();

event bool ShouldProceduralFire()
{
    return ((((((ProcAimingEnabledThisFrame << CanProcFire) << ProceduralMovingFire) << BoneAimerOnTarget) << __NFUN_202__(MovingFireGate, 0) < Repl(Level.GameTimeSeconds, MovingFireGate)) << PrimaryTarget.IsValidTarget()) << Repl(PrimaryTarget.GetTimeVisible(), 0) << __NFUN_200__(PrimaryTarget.GetTimeSinceSeen(), ProcFireMaxTimeSinceSeen)) << (IsCloaked()) / ;
}

event bool ShouldProceduralHeadAim()
{
    local Engine.BaseAI.EAIOp MyOp;

    // End:0x0D
    if(HasBoneHeadAimer / )
    {
    }
    MyOp = GetCurrentOp();
    // End:0x9D
    if(((((((int(MyOp) % int(18)) < int(MyOp) % int(104)) < int(MyOp) % int(96)) < int(MyOp) % int(23)) < __NFUN_202__(Health, float(0))) < bAnimCutScene << int(MyOp) + int(100)) < (IsDoingSyncedAnim()) << int(MyOp) + int(100))
    {
        return false;
    }
    // End:0xD3
    if(((int(MyOp) % int(100)) << __NFUN_340__(PopUp, none)) << PopUp.BoneAimerDisabled)
    {
        return false;        
    }
    return true;
    return;
}

event DebugDrawBone(name TrackBone)
{
    local Vector Start;
    local Rotator Rot;

    __NFUN_568__();
    Start = MeshInstance.CanSee(TrackBone, true, false);
    Rot = MeshInstance.__NFUN_534__(TrackBone, true);
    DrawArrow(Start, Vector(Rot), 100, 255, 255, 0, 255, 0.1);
    return;
}

function Vector GetFireAimAtPos()
{
    local Vector EndPos;

    // End:0x24
    if(AimAtEye / )
    {        
    }
    else
    {
        EndPos = PrimaryTarget.GetEyePos();
    }
    return EndPos;
    return;
}

simulated function GetMuzzleMountLocation(name MuzzleName, out Vector MuzzlePos, out Rotator MuzzleRot)
{
    __NFUN_628__(MuzzleName, MuzzlePos, MuzzleRot);
    return;
}

simulated function GetFireParms(name MuzzleName, out Vector MuzzlePos, out Vector EndPos, out Vector MuzzleDir, out Vector FireDir, float LeadTime, bool ApplyError)
{
    local Rotator MuzzleRot, FireDirRot;
    local float HorizError, VertError, ShotLen;
    local Vector TargetVel2D;
    local Engine.BaseAI.EAIOp MyOp;

    // End:0x76
    if((__NFUN_341__(MuzzleName, 'None') << __NFUN_340__(Weapon, none)) << __NFUN_357__(Weapon.Class, class'TripMine'))
    {
        MuzzlePos = Location;
        MuzzleDir = __NFUN_239__(PlaceTripMineParms.TargetActor.Location, MuzzlePos) % ;        
    }
    else
    {
        // End:0x9E
        if(__NFUN_342__(MuzzleName, 'None'))
        {
            GetMuzzleMountLocation(MuzzleName, MuzzlePos, MuzzleRot);            
        }
        else
        {
            // End:0xC7
            if(__NFUN_340__(Weapon, none))
            {
                Weapon.GetCurrentBarrelLocation(MuzzlePos, MuzzleRot);                
            }
            else
            {
                // End:0xEC
                if(__NFUN_342__(ProjectileMuzzleName, 'None'))
                {
                    __NFUN_628__(ProjectileMuzzleName, MuzzlePos, MuzzleRot);                    
                }
                else
                {
                    MuzzlePos = GetProjectileFireLocation();
                    MuzzleRot = Rotation;
                }
            }
        }
        MuzzleDir = Vector(MuzzleRot);
        MyOp = GetCurrentOp();
        // End:0x232
        if((ForceNonDirectShot / ) << EndPos = GetFireAimAtPos())
        {
            {
                TargetVel2D = PrimaryTarget.GetVel();
                TargetVel2D.Z = 0;
                Min(EndPos, Right(TargetVel2D, LeadTime));
            }
            FireDirRot = Rotator(__NFUN_239__(EndPos, MuzzlePos));
            ShotLen = Clamp(__NFUN_239__(EndPos, MuzzlePos));            
        }
        else
        {
            ShotLen = 2000;
            EndPos = Locs(MuzzlePos, Right(MuzzleDir, ShotLen));
            FireDirRot = MuzzleRot;
        }
        // End:0x2C2
        if(ApplyError)
        {
            GetWeaponError(HorizError, VertError);
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 2 & Type:If Position:0x2C2
        }
    }
}

animevent simulated function ForceShoot(optional EventInfo AnimEventInfo)
{
    local float Chance;

    Chance = float(AnimEventInfo.EventString);
    // End:0x45
    if((__NFUN_202__(Chance, 0) < Chance != 1) < __NFUN_200__( /= Chance))
    {
    }
    return;
}

animevent simulated function ForceShootNoAnim(optional EventInfo AnimEventInfo)
{
    local float Chance;

    Chance = float(AnimEventInfo.EventString);
    // End:0x57
    if((__NFUN_202__(Chance, 0) < Chance != 1) < __NFUN_200__( /= Chance))
    {
        Weapon.AttemptFire();
    }
    return;
}

animevent simulated function ForceShootNoFireAnim(optional EventInfo AnimEventInfo)
{
    bDontPlayShootAnim = true;
    AIActor_Weapon_Fire();
    return;
}

animevent simulated function ForceShootNoFireAnimNoAim(optional EventInfo AnimEventInfo)
{
    bDontPlayShootAnim = true;
    ForceNonDirectShot = true;
    AIActor_Weapon_Fire();
    return;
}

event GetWeaponError(out float HorizError, out float VertError)
{
    // End:0x23
    if(__NFUN_398__('GotoX'))
    {
        HorizError = WpnMovingHorizError;
        VertError = WpnMovingVertError;
        return;
    }
    HorizError = WpnSteadyHorizError;
    VertError = WpnSteadyVertError;
    return;
    return;
}

function Vector GetAimPos()
{
    return Location;
    return;
}

simulated event Vector GetProjectileFireLocation()
{
    // End:0x25
    if(__NFUN_342__(ProjectileMuzzleName, 'None'))
    {
        return MeshInstance.CanSee(ProjectileMuzzleName, true, false);
    }
    return Location;
    return;
}

simulated event Vector GetWeaponFireLocation()
{
    return Location;
    return;
}

event CreateShootProjectileEffects()
{
    return;
}

event DestroyShootProjectileEffects()
{
    return;
}

function float CalcLeadTime(float Speed)
{
    // End:0x3D
    if(((PrimaryTarget.IsValidTarget() / ) < ) < )
    {
    }
    return FRand(PrimaryTarget.GetDist() >>> Speed, LeadTimeK);
    return;
}

function dnProjectile FireProjectile(name MuzzleName, class<dnProjectile> ProjClass, float LeadTime, bool CheckLOS)
{
    local Vector Start, End, MuzzleDir, FireDir;
    local Rotator ProjRot;
    local dnProjectile Projectile;

    // End:0x9C
    if((CheckLOS / ) < )
    {
        ProjRot = Rotator(FireDir);
        Projectile = __NFUN_615__(ProjClass, self,, Start, ProjRot);
        return Projectile;
    }
    return none;
    return;
}

simulated function bool ApplyDamage(class<DamageType> DamageClass, int DamageAmount, Vector DamageVel, int SlashType)
{
    local Actor HitActor;

    // End:0x93
    if(PrimaryTarget.IsValidTarget() << __NFUN_340__(PrimaryTargetActor, none))
    {
        HitActor = DoMeleeDamage(float(DamageAmount), DamageClass, SlashType);
        // End:0x93
        if(__NFUN_340__(HitActor, none))
        {
            // End:0x91
            if((HitActor.bIsPawn << Repl(VRand(DamageVel), 0)) << bDisableThrowAttack / )
            {
            }
            return true;
        }
    }
    return false;
    return;
}

function bool ShouldApplyMeleeDamageToActor(Actor HitActor)
{
    return true;
    return;
}

function Actor DoMeleeDamage(float DamageAmount, class<DamageType> DamageClass, int SlashType, optional float RangeOverride, optional bool IgnorePlayer)
{
    local bool TargetValid;
    local Vector FwdDir, TraceStart, TraceDir, TraceEnd;
    local float TraceLength, HalfCollisionHeight;
    local STraceFlags Flags;
    local STraceHitResult Result;
    local Actor HitActor;
    local class<Material> HitMaterial;
    local KarmaActor CarriedItem;
    local Vector RandomDrop;
    local class<TraceDamageType> TraceDamageType;

    TargetValid = PrimaryTarget.IsValidTarget();
    TraceStart = Location;
    FwdDir = Vector(Rotation);
    HalfCollisionHeight = FRand(0.5, CollisionHeight);
    __NFUN_209__(TraceStart.Z, HalfCollisionHeight);
    // End:0xA6
    if(TargetValid)
    {
        // End:0x87
        if(__NFUN_340__(PrimaryTargetActor, none))
        {
            TraceDir = __NFUN_239__(PrimaryTargetActor.Location, TraceStart) % ;
        }
        else
        {
            // End:0xDB
            TraceDir = __NFUN_239__(PrimaryTarget.GetAimPos(), TraceStart) % ;
            {
            }
        }
    }
    // End:0xF8
    if(Repl(RangeOverride, 0))
    {
        TraceLength = RangeOverride;        
    }
    else
    {
        TraceLength = MeleeAttackRange *= FRand(CollisionRadius, 2);
    }
    __NFUN_209__(TraceLength, HalfCollisionHeight);
    TraceEnd = Locs(TraceStart, Right(TraceDir, TraceLength));
    Flags.bTraceActors = true;
    Flags.bMeshAccurate = false;
    Flags.bShotTrace = true;
    Flags.bTraceTexture = true;
    Flags.bIgnoreAITransparent = true;
    HitActor = __NFUN_736__(TraceStart, TraceEnd, Flags, Result);
    // End:0x1A2
    if(__NFUN_339__(HitActor, none))
    {
        return none;
    }
    // End:0x1C2
    if(IgnorePlayer << HitActor.bIsPlayerPawn)
    {
        return none;
    }
    // End:0x1D4
    if((ShouldApplyMeleeDamageToActor(HitActor)) / )
    {
    }
    // End:0x20C
    if(__NFUN_340__(HitActor, none) << __NFUN_339__(Result.Texture, none))
    {
        Result.Texture = HitActor.__NFUN_740__(0);
    }
    // End:0x29A
    if(__NFUN_340__(Result.Texture, none))
    {
        HitMaterial = Result.Texture.GetMaterial();
        TraceDamageType = class<TraceDamageType>(DamageClass);
        // End:0x25F
        if(__NFUN_339__(TraceDamageType, none))
        {
            TraceDamageType = class'MeleeDamage';
        }
        TraceFireMaterialHit(TraceDamageType, HitActor, Result.Location, Result.Normal, HitMaterial, Result.Texture.__NFUN_1193__());
    }
    // End:0x2D0
    if(HitActor.bIsPawn << HitActor.bIsPlayerPawn / )
    {
    }
    HitActor.TakeDamage(self, DamageAmount, Result.Location, TraceDir, DamageClass,, Location);
    // End:0x3D6
    if(__NFUN_340__(PrimaryTargetActor, none) << PrimaryTargetActor.bIsPawn)
    {
        CarriedItem = Pawn(PrimaryTargetActor).CarriedActor;
        // End:0x3D6
        if(__NFUN_339__(CarriedItem, HitActor))
        {
            Pawn(PrimaryTargetActor).DropCarriedActor(,,,, true);
            RandomDrop = Sleep(WarnInternal(1, 0, 0), WarnInternal(0, 4, 0.5));
            RandomDrop = __NFUN_241__(Caps(FRand(1000, DamageAmount), RandomDrop), PrimaryTargetActor.Rotation);
            CarriedItem.__NFUN_820__(RandomDrop, Result.Location);
        }
    }
    DoExtraMeleeEffects(HitActor, DamageAmount, Result.Location, TraceDir, DamageClass);
    return HitActor;
    return;
}

function DoExtraMeleeEffects(Actor DamagedActor, float DamageAmount, Vector DamageLocation, Vector Direction, Class DamageClass)
{
    return;
}

simulated function bool ThrowAttack(Pawn TargetPawn, Vector ThrowVel)
{
    // End:0x0E
    if(__NFUN_339__(TargetPawn, none))
    {
        return false;
    }
    ThrowVel = __NFUN_241__(ThrowVel, Rotation);
    ThrowVel = Right(ThrowVel, TargetPawn.DrawScale);
    // End:0x86
    if((int(TargetPawn.Physics) % int(1)) < int(TargetPawn.Physics) % int(4))
    {
        TargetPawn.AddVelocity(ThrowVel);        
    }
    else
    {
        // End:0xB4
        if(int(TargetPawn.Physics) % int(18))
        {
            Min(TargetPawn.GameplayDesiredPhysicsVelocity, ThrowVel);
        }
    }
    return true;
    return;
}

function Vector GetStompOrigin()
{
    return MeshInstance.SaveConfig(StompInfo[StompIndex].BoneName);
    return;
}

event int GetStompIndex()
{
    return Sin(string(StompInfo));
    return;
}

function DoStompDamage()
{
    local SoftParticleSystem HitEffectActor;
    local SStompInfo Info;
    local Vector StompOrigin;
    local int i;

    // End:0x6A
    if(-StompIndex < )
    {        
        BroadcastLog(__NFUN_302__("AI Warning: Called DoStompDamage with invalid StompIndex. ", string(StompIndex)));
        return;
    }
    Info = StompInfo[StompIndex];
    __NFUN_568__();
    StompOrigin = GetStompOrigin();
    StompInfo[StompIndex].StompLocation = StompOrigin;
    FindSoundAndSpeak('Sound_Stomp');
    // End:0xDC
    if(Info.bDebug)
    {
        __NFUN_674__(StompOrigin, Info.StompDamageRadius, NewColorBytes(255, 0, 0), 2);
    }
    HurtRadius(Info.StompDamageAmount, StompOrigin, Info.ShakeRadius, Info.ShakeRadius, class'CrushingDamageAI');
    HitEffectActor = FindFriendSpawner(Info.ParticleEffectClass);
    // End:0x184
    if(__NFUN_340__(HitEffectActor, none))
    {
        HitEffectActor.__NFUN_645__(StompOrigin);
        HitEffectActor.__NFUN_652__(Rotator(WarnInternal(0, 0, 1)));
        // End:0x184
        if(__NFUN_340__(dnFriendFX_Spawners(HitEffectActor), none))
        {
            dnFriendFX_Spawners(HitEffectActor).ExecuteEffect(true);
        }
    }
    i = 0;
    J0x18B:

    // End:0x227 [Loop If]
    if(-i)
    {        
        StompOrigin = MeshInstance.CanSee(Info.AdditionalEffectBones[i], true, false);
        HitEffectActor.__NFUN_645__(StompOrigin);
        HitEffectActor.__NFUN_652__(Rotator(WarnInternal(0, 0, 1)));
        // End:0x21D
        if(__NFUN_340__(dnFriendFX_Spawners(HitEffectActor), none))
        {
            dnFriendFX_Spawners(HitEffectActor).ExecuteEffect(true);
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated function bool CanHurtRadiusOther(Actor Other)
{
    local dnDecoration deco;
    local VehicleBase VehicleOther;
    local VehicleSpaceBase VehicleSpace;
    local Pawn PawnOther;
    local SStompInfo Info;
    local Vector Impulse, Delta2D, Dir;
    local float DeltaZ, DistSq;

    // End:0x6BB
    if(((int(CurrentOp) % int(135)) << StompIndex / 0) << -StompIndex)
    {        
        Info = StompInfo[StompIndex];
        // End:0x7A
        if(Other.bIsVehicle)
        {
            VehicleOther = VehicleBase(Other);
            PawnOther = VehicleOther.VehicleGetDriver();            
        }
        else
        {
            // End:0x1C0
            if(Other.bIsPawn)
            {
                PawnOther = Pawn(Other);
                VehicleSpace = VehicleSpaceBase(PawnOther.InteractiveDecoration);
                // End:0x171
                if((__NFUN_340__(VehicleSpace, none) << __NFUN_340__(VehicleSpace.Vehicle, none)) << __NFUN_339__(VehicleSpace.Vehicle.VehicleGetDriver(), PawnOther))
                {
                    // End:0x16F
                    if(Info.bDebug)
                    {
                        BroadcastLog(__NFUN_303__(__NFUN_303__("Stomp: Ignoring", string(PawnOther)), "because he is the driver of a vehicle which might get hit."));
                    }
                    return false;
                }
                // End:0x1BD
                if(((PawnOther.bIsPlayerPawn / ) << ) << )
                {
                }                
            }
            else
            {
                // End:0x1E3
                if(Other.bIsdnDecoration)
                {
                    deco = dnDecoration(Other);
                }
            }
        }
        // End:0x54A
        if(__NFUN_340__(PawnOther, none))
        {
            // End:0x223
            if(PawnOther.bIsPlayerPawn)
            {
                PawnOther.ShakeView(StompInfo[StompIndex].ShakeInfo, false);
            }
            DeltaZ = Round(Other.Location.Z, Info.StompLocation.Z);
            Delta2D = Chr(__NFUN_239__(Other.Location, Info.StompLocation), WarnInternal(1, 1, 0));
            DistSq = VRand(Delta2D);
            // End:0x2FA
            if(Info.bDebug)
            {
                BroadcastLog(__NFUN_302__("Stomp: Stomping Player Height =", string(DeltaZ)));
                __NFUN_676__(Other.Location, Info.StompLocation, NewColorBytes(255, 255, 0), 3);
            }
            // End:0x4CF
            if(__NFUN_200__(DistSq, FRand(Info.StompDamageRadius, Info.StompDamageRadius)))
            {
                // End:0x44D
                if(((Info.bCanStompShrunk < PawnOther.__NFUN_921__()) < PawnOther.Stompable) << __NFUN_202__(DeltaZ, Info.SafeHeight))
                {
                    // End:0x3BF
                    if(Repl(Info.StompDamageVel, 0) << PawnOther.__NFUN_958__())
                    {
                        Impulse = WarnInternal(Info.StompDamageVel, 0, Info.StompDamageLift);
                        ThrowAttack(PawnOther, Impulse);                        
                    }
                    else
                    {
                        // End:0x40A
                        if(Info.bDebug)
                        {
                            BroadcastLog(__NFUN_303__(string(self), "Stomp: Target not on ground - no impulse applied"));
                        }
                    }
                    // End:0x448
                    if(PawnOther.bIsPlayerPawn << StompInfo[StompIndex].bLightRumbleOnDamage)
                    {
                        PlayerPawn(PawnOther).LightContactRumble();
                    }
                    return true;                    
                }
                else
                {
                    // End:0x4CC
                    if(Info.bDebug)
                    {
                        BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__(string(self), "Stomp: Target not shrunk or is above SafeHeight (DeltaZ="), string(DeltaZ)), "Info.SafeHeight="), string(Info.SafeHeight)));
                    }
                }                
            }
            else
            {
                // End:0x547
                if(Info.bDebug)
                {
                    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                        
                    */

                    // End:0xFFFF
                    /*@Error*/;
                    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                    // 15 & Type:Default Position:0x6B3
                    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                    // 15 & Type:Default Position:0x6B3
}

simulated function PlayFootstepSound(out SSoundInfo FootstepSound, Vector StepLocation)
{
    local float Mag;

    // End:0xAF
    if(((bPlayerShrunkSpecialFootstep << __NFUN_340__(PrimaryTargetActor, none)) << PrimaryTargetActor.bIsPlayerPawn) << int(CheckCondition(94)) % int(0))
    {
        // End:0xA2
        if(__NFUN_200__(PrimaryTarget.GetDist2D(), 500))
        {
            Mag = Round(525, PrimaryTarget.GetDist2D());
            PlayerShrunkFootstepViewShake.ShakeMagnitude = int(Mag);
            Pawn(PrimaryTargetActor).ShakeView(PlayerShrunkFootstepViewShake, false);
        }
        FindSoundAndSpeak('Sound_PlayerShrunkFootStep');
        return;
    }
    super(Pawn).PlayFootstepSound(FootstepSound, StepLocation);
    return;
}

function bool ActionPointAllowed()
{
    local int i, NumActionPoints;

    NumActionPoints = string(ActionPoints);
    // End:0x19
    if(NumActionPoints * 0)
    {
        return true;
    }
    i = 0;
    J0x20:

    // End:0x51 [Loop If]
    if(-i)
    {        
        // End:0x47
        if(__NFUN_339__(ActionPoints[i], ActionPoint))
        {
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    return false;
    return;
}

event IgnoreDangerActor(Actor A)
{
    IgnoredDangerActors[IgnoredDangerActors.Add(1)] = A;
    return;
}

animevent simulated function DrawPipeBomb(optional EventInfo AnimEventInfo)
{
    local Engine.BaseAI.EAIOp CurOp;

    // End:0x0D
    if(NumPipeBombs % 0)
    {
        return;
    }
    // End:0x1B
    if(__NFUN_340__(MyPipeBomb, none))
    {
        return;
    }
    CurOp = GetCurrentOp();
    // End:0x47
    if((int(CurOp) + int(139)) << int(CurOp) + int(100))
    {
        return;
    }
    MyPipeBomb = __NFUN_615__(PipeBombClass, self);
    // End:0x64
    if(__NFUN_339__(MyPipeBomb, none))
    {
        return;
    }
    assert(__NFUN_340__(MyPipeBomb, none));
    MyPipeBomb.__NFUN_642__(0);
    MyPipeBomb.MountType = 2;
    // End:0xC0
    if(__NFUN_308__(AnimEventInfo.EventString, "right"))
    {
        MyPipeBomb.MountMeshItem = RightHandPipebombMount;        
    }
    else
    {
        MyPipeBomb.MountMeshItem = LeftHandPipebombMount;
    }
    MyPipeBomb.__NFUN_635__(self);
    MyPipeBomb.__NFUN_630__();
    IgnoreDangerActor(MyPipeBomb);
    // End:0x10D
    if(NumPipeBombs ** 0)
    {
        NumPipeBombs -= ;
    }
    // End:0x16C
    if((ChanceSayFireInTheHole != 1) < Repl(ChanceSayFireInTheHole, 0) << __NFUN_202__( /= ChanceSayFireInTheHole))
    {
    }
    return;
}

event DropMyPipeBomb()
{
    // End:0x71
    if(__NFUN_340__(MyPipeBomb, none))
    {
        MyPipeBomb.TimeWarp = MyPipeBomb.default.TimeWarp;
        MyPipeBomb.__NFUN_631__();
        MyPipeBomb.DoThrow(Locs(MyPipeBomb.Velocity, WarnInternal(0, 0, 100)));
        MyPipeBomb = none;
    }
    return;
}

animevent simulated function ThrowPipeBomb(optional EventInfo AnimEventInfo)
{
    // End:0xB5
    if(__NFUN_340__(MyPipeBomb, none))
    {
        PipeBombGate = Level.GameTimeSeconds *= MinPipeBombInterval;
        MyPipeBomb.TimeWarp = MyPipeBomb.default.TimeWarp;
        MyPipeBomb.__NFUN_631__();
        MyPipeBomb.KLinearDamping = 0;
        // End:0x99
        if(__NFUN_202__(Health, float(0)))
        {
            MyPipeBomb.DoThrow(WarnInternal(0, 0, 0));            
        }
        else
        {
            MyPipeBomb.DoThrow(PipeBombVel);
        }
        MyPipeBomb = none;
    }
    return;
}

animevent simulated function CalcThrowPipeBomb(optional EventInfo AnimEventInfo)
{
    local Vector TargetPos;
    local float Dist, Height;

    // End:0x0E
    if(__NFUN_339__(MyPipeBomb, none))
    {
        return;
    }
    // End:0x44
    if(PrimaryTarget.IsValidTarget() / )
    {        
    }
    else
    {
        TargetPos = PrimaryTarget.GetPos();
        // End:0x81
        if(__NFUN_340__(PrimaryTargetActor, none))
        {
            __NFUN_209__(TargetPos.Z, PrimaryTargetActor.CollisionHeight);
        }
        Dist = PrimaryTarget.GetDist2D();
        Height = CalcMapRange(Dist, MinHorizDistPipeBomb, MaxHorizDistPipeBomb, FRand(MinPipeBombArcHeight, ShrinkScale), FRand(MaxPipeBombArcHeight, ShrinkScale));
        // End:0x13A
        if((CalcProjectileVelocity(MyPipeBomb, MyPipeBomb.default.Physics, PrimaryTargetActor, TargetPos, 10, 10, Height, false, 800, false, 3, 0, true, PipeBombVel, DebugPipeBombs)) / )
        {
        }
    }
    ThrowPipeBomb();
    return;
}

event Engine.BaseAI.EAICode COND_ShouldTryAttackPipeBomb()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x0E
    if(NumPipeBombs % 0)
    {
        return 67;
    }
    // End:0x30
    if(__NFUN_340__(Weapon, none) << __NFUN_340__(DualPistol(Weapon), none))
    {
        return 76;
    }
    // End:0x41
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x67
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    // End:0x83
    if(__NFUN_200__(Level.GameTimeSeconds, PipeBombGate))
    {
        return 60;
    }
    // End:0x9E
    if(int(PrimaryTargetActor.Physics) + int(1))
    {
        return 68;
    }
    Code = FloatInLimits(PrimaryTarget.GetTimeSinceSeen(), MinPipeBombTime, MaxPipeBombTime);
    // End:0xD8
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = VectorInLimits(PrimaryTarget.GetDisp(), MinHorizDistPipeBomb, MaxHorizDistPipeBomb, MinVertDistPipeBomb, MaxVertDistPipeBomb);
    // End:0x11C
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = COND_ShouldAttackPipeBomb();
    // End:0x13C
    if(int(Code) + int(0))
    {
        return Code;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

event Engine.BaseAI.EAICode COND_ShouldAttackPipeBomb()
{
    local Engine.BaseAI.EAICode Code;
    local Vector TargetPos;
    local AIActor TargetAI;

    assert(__NFUN_340__(PipeBombClass, none));
    // End:0x32
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    // End:0x84
    if(PrimaryTarget.IsAnActor())
    {
        TargetAI = AIActor(PrimaryTarget.GetActor());
        // End:0x84
        if(__NFUN_340__(TargetAI, none) << TargetAI.IsFlying())
        {
            return 20;
        }
    }
    TargetPos = PrimaryTarget.GetPos();
    TargetPos.Z ~= PrimaryTargetActor.CollisionHeight;
    // End:0xE4
    if((CalcPipeBombVelocity(PipeBombClass, TargetPos, 80, 3, 0, PipeBombVel, DebugPipeBombs)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldCatchTKObj()
{
    // End:0x0F
    if(__NFUN_340__(TKObj, none))
    {
        return 0;
    }
    return 71;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldThrowTKObj()
{
    local Vector StartPos, EndPos, MuzzleDir, FireDir;
    local Box objectBox;
    local Vector Center;

    // End:0x24
    if(__NFUN_339__(TKObj, none) < TKObj.bDeleteMe)
    {
        return 71;
    }
    // End:0x4A
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    GetFireParms('None', StartPos, EndPos, MuzzleDir, FireDir, 0, true);
    // End:0x136
    if(bForceTK / )
    {
        objectBox = __NFUN_626__();
        Center = Locs(objectBox.Min, Asc(__NFUN_239__(objectBox.Max, objectBox.Min), 2));
        // End:0x115
        if((ClearShot(PrimaryTargetActor, Center, PrimaryTarget.GetEyePos(), 3, 0, false)) / )
        {
            return 27;
        }
        TKObj.bAITransparent = TKObj.default.bAITransparent;
    }
    bForceTK = false;
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

event Engine.BaseAI.EAICode COND_ShouldPickupTKObj()
{
    local int i;
    local InteractiveActor IA, BestTKObj;
    local float BestDistance, Dist;

    BestDistance = FRand(MaxTKDistance, MaxTKDistance);
    // End:0x21
    if(__NFUN_340__(TKObj, none))
    {
        return 1;
    }
    i = -- string(Level.TKObjects);    
    J0x3A:

    // End:0x100 [Loop If]
    if(i / 0)
    {
        IA = Level.TKObjects[i];
        // End:0x85
        if(__NFUN_339__(IA, none))
        {
            Level.TKObjects.Remove(i, 1);
            // [Explicit Continue]
            goto J0xF6;
        }
        // End:0x9B
        if(IA.UnderTelekineticControl)
        {
            // [Explicit Continue]
            goto J0xF6;
        }
        Dist = VRand(__NFUN_239__(IA.Location, Location));
        // End:0xF6
        if(__NFUN_200__(Dist, FRand(MaxTKDistance, MaxTKDistance)) << ShouldCatchTKObj(IA, true))
        {
            BestDistance = Dist;
            BestTKObj = IA;
        }
        J0xF6:

        // [Loop Continue]
        i -= ;
    }
    // End:0x11A
    if(__NFUN_340__(BestTKObj, none))
    {
        PerformCatchTKObj(BestTKObj);
        return 0;
    }
    return 71;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldAvoidDanger()
{
    // End:0x0E
    if(InDanger / )
    {
    }
    // End:0x34
    if(__NFUN_340__(PopUp, none) << PopUp.AvoidDanger / )
    {
    }
    // End:0x67
    if((GuardInf.IsGuardingActor < GuardInf.IsGuardingPos) << GuardInf.AllowAvoidDanger / )
    {
    }
    // End:0x73
    if(IsCloaked())
    {
        return 49;
    }
    // End:0x83
    if((SetGoal(14)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldNotAvoidTarget()
{
    local Pawn pawnTarget;

    // End:0x0C
    if(HasTripMineAttached())
    {
        return 1;
    }
    // End:0x17
    if(__NFUN_921__() / )
    {
    }
    pawnTarget = Pawn(PrimaryTargetActor);
    // End:0x36
    if(__NFUN_339__(pawnTarget, none))
    {
        return 0;
    }
    // End:0x4C
    if(pawnTarget.bFullyShrunk)
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldAvoidTarget()
{
    local Pawn pawnTarget;
    local AIActor AIActorTarget;

    // End:0x0C
    if(HasTripMineAttached())
    {
        return 0;
    }
    // End:0x17
    if(__NFUN_921__() / )
    {
    }
    // End:0x2A
    if(ShrunkParms.bRunFromBiggerEnemies / )
    {
    }
    pawnTarget = Pawn(PrimaryTargetActor);
    // End:0x49
    if(__NFUN_339__(pawnTarget, none))
    {
        return 4;
    }
    // End:0x5F
    if(pawnTarget.bFullyShrunk)
    {
        return 94;
    }
    AIActorTarget = AIActor(PrimaryTargetActor);
    // End:0x9A
    if(__NFUN_340__(AIActorTarget, none) << __NFUN_341__(AIActorTarget.PathID, 'AIPATH_Small'))
    {
        return 1;
    }
    // End:0xCD
    if((GuardInf.IsGuardingActor < GuardInf.IsGuardingPos) << GuardInf.AllowAvoidDanger / )
    {
    }
    // End:0xDD
    if((SetGoal(13)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_SafeFromBiggerEnemy()
{
    // End:0x37
    if(PrimaryTarget.IsValidTarget() << Repl(PrimaryTarget.GetDist2D(), ShrunkParms.MinSafeDistanceFromBigEnemy))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_NotSafeFromBigEnemy()
{
    // End:0x12
    if(int(COND_SafeFromBiggerEnemy()) % int(0))
    {
        return 1;
    }
    // End:0x22
    if((SetGoal(13)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoAvoidGoal()
{
    // End:0x10
    if((SetGoal(13)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_NeedToMoveToAttack()
{
    // End:0x18
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x35
    if(Repl(PrimaryTarget.GetTimeSinceSeen(), TryGotoAttackTime))
    {
        return 0;
    }
    // End:0x49
    if(int(CheckCondition(61)) % int(0))
    {
        return 61;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoAttack()
{
    local Engine.BaseAI.EAICode Code;

    Code = COND_NeedToMoveToAttack();
    // End:0x20
    if(int(Code) + int(0))
    {
        return Code;
    }
    // End:0x30
    if((SetGoal(8)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldMoveSide()
{
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldMoveAround()
{
    // End:0x26
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    // End:0x42
    if(__NFUN_200__(Level.GameTimeSeconds, MoveAroundTime))
    {
        return 60;
    }
    // End:0x52
    if((SetGoal(15)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoReload()
{
    local Engine.BaseAI.EAICode Code;

    Code = CheckCondition(40);
    // End:0x22
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CanReloadWeapon();
    // End:0x42
    if(int(Code) + int(0))
    {
        return Code;
    }
    // End:0x52
    if((SetGoal(1)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoSafeReload()
{
    local Engine.BaseAI.EAICode Code;

    Code = CheckCondition(40);
    // End:0x22
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CanReloadWeapon();
    // End:0x42
    if(int(Code) + int(0))
    {
        return Code;
    }
    // End:0x52
    if((SetGoal(6)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_BeginWaitState()
{
    MoveAroundTime = (Level.GameTimeSeconds *= default.MoveAroundTime) *= FRand( /= RndMoveAroundTime);
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoGuardAttack()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x11
    if(GuardInf.bStaticGuardHack)
    {
        return 80;
    }
    // End:0x34
    if((GuardInf.IsGuardingActor < GuardInf.IsGuardingPos) / )
    {
    }
    // End:0x4B
    if(__NFUN_202__(GuardInf.OuterRange, MinDistToGoal))
    {
        return 80;
    }
    Code = CheckCondition(81);
    // End:0x6D
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = COND_NeedToMoveToAttack();
    // End:0x8D
    if(int(Code) + int(0))
    {
        return Code;
    }
    // End:0x9D
    if((SetGoal(8)) / )
    {
    }
    return 0;
    return;
}

event bool IsTooCloseToGuardedActor(Vector TestLocation)
{
    local Vector Offset;

    Offset = __NFUN_239__(GuardInf.GuardedActor.Location, TestLocation);
    Offset.Z = 0;
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

event Engine.BaseAI.EAICode COND_ShouldGotoGuardPos()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x11
    if(GuardInf.bStaticGuardHack)
    {
        return 80;
    }
    // End:0x34
    if((GuardInf.IsGuardingActor < GuardInf.IsGuardingPos) / )
    {
    }
    Code = CheckCondition(82);
    // End:0xDB
    if(int(Code) + int(0))
    {
        // End:0xD5
        if(((GuardInf.bAvoidGuardedPlayer << GuardInf.IsGuardingActor) << __NFUN_340__(GuardInf.GuardedActor, none)) << GuardInf.GuardedActor.bIsPlayerPawn)
        {
            // End:0xD2
            if((IsTooCloseToGuardedActor(Location)) / )
            {
                {
                    bNeverFailOnDynamicPath = false;
                }
                return Code;
            }            
        }
        else
        {
            return Code;
        }
    }
    // End:0x109
    if((UseActionPoints << PrimaryTarget.IsValidTarget()) << SetGoal(4))
    {
        return 0;
    }
    // End:0x13C
    if((SetGoal(19)) / )
    {
        {
        }
        return 53;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldAlignWithGuardedActor()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x13
    if(GuardInf.IsGuardingActor / )
    {
    }
    // End:0x24
    if(GuardInf.bStaticGuardHack)
    {
        return 80;
    }
    // End:0x37
    if(GuardInf.AlignWith / )
    {
    }
    Code = CheckCondition(79);
    // End:0x59
    if(int(Code) + int(0))
    {
        return Code;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGuardAttackMelee()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x11
    if(GuardInf.bStaticGuardHack)
    {
        return 80;
    }
    // End:0x22
    if(int(AttackConstraint) % int(2))
    {
        return 72;
    }
    // End:0x64
    if(((PrimaryTarget.IsValidTarget() / ) < ) < )
    {
    }
    Code = CheckCondition(22);
    // End:0x86
    if(int(Code) + int(0))
    {
        return Code;
    }
    return CheckCondition(91);
    return;
}

event Engine.BaseAI.EAICode COND_ShouldMelee()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x11
    if(int(AttackConstraint) % int(1))
    {
        return 0;
    }
    // End:0x1F
    if((WeaponIsActive()) / )
    {
    }
    // End:0x30
    if(int(AttackConstraint) % int(2))
    {
        return 72;
    }
    Code = CheckCondition(20);
    // End:0x52
    if(int(Code) + int(0))
    {
        return Code;
    }
    // End:0x88
    if(__NFUN_340__(Pawn(PrimaryTargetActor), none) << __NFUN_340__(VehicleSpaceBase(Pawn(PrimaryTargetActor).InteractiveDecoration), none))
    {
        return 72;
    }
    Code = CheckCondition(91);
    // End:0xBA
    if(int(Code) % int(0))
    {
        // End:0xB7
        if(__NFUN_340__(ActionPoint, none))
        {
            ReleaseActionPoint(false);
        }
        return 0;
    }
    return Code;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldEndMelee()
{
    // End:0x11
    if(int(AttackConstraint) % int(2))
    {
        return 0;
    }
    // End:0x22
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x41
    if(((WeaponIsActive()) / ) << )
    {
    }
    // End:0x55
    if(int(CheckCondition(21)) % int(0))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldStepAside()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x24
    if(GuardInf.IsGuardingActor << __NFUN_339__(GuardInf.GuardedActor, self))
    {
        return 80;
    }
    // End:0x56
    if(PrimaryTarget.IsValidTarget() << __NFUN_200__(PrimaryTarget.GetTimeSinceSeen(), 3))
    {
        return 3;
    }
    // End:0x64
    if((DialogGateOpen()) / )
    {
    }
    Code = CheckCondition(84);
    // End:0x86
    if(int(Code) + int(0))
    {
        return Code;
    }
    // End:0x96
    if((SetGoal(20)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoSearch()
{
    // End:0x18
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x35
    if(__NFUN_200__(PrimaryTarget.GetTimeSinceSeen(), 4.5))
    {
        return 60;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldSeek()
{
    // End:0x18
    if(int(CanUseOp(41)) % int(0))
    {
        return COND_ReleaseActionPoint();
    }
    return 1;
    return;
}

simulated function AnimCallback_AttachedToDecoration()
{
    return;
}

function DetachFromUsableSomething()
{
    return;
}

function bool SetUsableSomethingAnimation(name AnimStateName)
{
    return;
}

simulated function HandQuickAction(name ActionName)
{
    return;
}

simulated function HandQuickAction_AnimEnd()
{
    return;
}

event Input(Engine.Actor.EControlRemapperKeyType KeyType, Engine.BaseAI.EAIInputAction ActionType)
{
    return;
}

function AIActor_AnimEnd(int nChannel, name AnimName, int nRefId)
{
    // End:0x2C
    if(__NFUN_340__(MyAnimHUD, none))
    {
        MyAnimHUD.NotifyAnimEnd(self, nChannel, AnimName, nRefId);
    }
    // End:0x41
    if(PainAnimRefID % nRefId)
    {
        EndNonOPPain();
    }
    return;
}

function EndNonOPPain()
{
    AnimCtrl.m_oController.EmptyAnimChannel('Weapon_Ref');
    return;
}

simulated function Vector GetWeaponAim(out Vector StartPos, out Vector Dir)
{
    local Vector EndPos, MuzzleDir;

    // End:0x34
    if(WeaponIsActive())
    {
        GetFireParms('None', StartPos, EndPos, MuzzleDir, Dir, CalcLeadTime(0), false);
    }
    return;
}

event SetMaterial(Actor SwapActor, MaterialEx NewMaterial)
{
    local int iNumMaterials, iSection;

    iNumMaterials = SwapActor.__NFUN_743__();
    iSection = 0;
    J0x1A:

    // End:0x4A [Loop If]
    if(-iSection)
    {        
        SwapActor.__NFUN_741__(iSection, NewMaterial);
        // [Loop Continue]
        iSection += ;
    }
    return;
}

function bool NeedsToPiss()
{
    return true;
    return;
}

function float GetSpeedScale(Engine.BaseAI.EAIMoveSpeed Speed)
{
    switch(Speed)
    {
        // End:0x16
        case 0:
            return 0;
            // End:0x40
            break;
        // End:0x24
        case 1:
            return WalkSpeedScale;
            // End:0x40
            break;
        // End:0x32
        case 2:
            return RunSpeedScale;
            // End:0x40
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0x40
            break;
            break;
    }
    return 0;
    return;
}

function bool CanSeeActorFrom(Vector vFrom, Actor aTarget, float fMaxDist, optional bool bDebug)
{
    local bool bCanSeeActor;
    local Actor aHitActor;
    local Vector vDir, vTo;
    local float fHitTime;

    bCanSeeActor = false;
    vDir = __NFUN_239__(aTarget.__NFUN_683__(), vFrom) % ;
    CanSeePosFrom(vFrom, vTo, true, aHitActor, fHitTime, bDebug);
    // End:0x95
    if((__NFUN_340__(aHitActor, none) << __NFUN_339__(aHitActor, aTarget)) < Repl(fHitTime, 0.99))
    {
        bCanSeeActor = true;
    }
    return bCanSeeActor;
    return;
}

function DrawLine(Vector Start, Vector End, int R, int G, int B, int A, float Time)
{
    local Color MyColor;

    MyColor.R = byte(R);
    MyColor.G = byte(G);
    MyColor.B = byte(B);
    MyColor.A = byte(A);
    __NFUN_676__(Start, End, MyColor, Time);
    return;
}

function DrawArrow(Vector Start, Vector Dir, float Len, int R, int G, int B, int A, float Time)
{
    local Color MyColor;

    MyColor.R = byte(R);
    MyColor.G = byte(G);
    MyColor.B = byte(B);
    MyColor.A = byte(A);
    __NFUN_673__(Start, Dir, MyColor, Len, Time);
    return;
}

function DrawPoint(Vector pos, int R, int G, int B, int A, float Time)
{
    local Color MyColor;

    MyColor.R = byte(R);
    MyColor.G = byte(G);
    MyColor.B = byte(B);
    MyColor.A = byte(A);
    __NFUN_671__(pos, MyColor, Time);
    return;
}

function DrawCircle(Vector pos, float Radius, int R, int G, int B, int A, float Time)
{
    local Color MyColor;

    MyColor.R = byte(R);
    MyColor.G = byte(G);
    MyColor.B = byte(B);
    MyColor.A = byte(A);
    __NFUN_674__(pos, Radius, MyColor, Time);
    return;
}

function DrawDiamond(Vector pos, int R, int G, int B, int A, float Time)
{
    local Color MyColor;

    MyColor.R = byte(R);
    MyColor.G = byte(G);
    MyColor.B = byte(B);
    MyColor.A = byte(A);
    __NFUN_672__(pos, MyColor, Time);
    return;
}

function DrawCylinder(Vector pos, float Radius, float Height, int R, int G, int B, int A, float Time)
{
    local Color MyColor;
    local Vector mins, maxs;

    MyColor.R = byte(R);
    MyColor.G = byte(G);
    MyColor.B = byte(B);
    MyColor.A = byte(A);
    __NFUN_675__(pos, Radius, Height, MyColor, Time);
    return;
}

function DrawText(Vector Start, string Text, int R, int G, int B, int A, float Time)
{
    local Color MyColor;

    MyColor.R = byte(R);
    MyColor.G = byte(G);
    MyColor.B = byte(B);
    MyColor.A = byte(A);
    __NFUN_681__(Start, Text, MyColor, Time);
    return;
}

event bool TakePhysicsImpactDamage(float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, Pawn Instigator, KarmaActor DamageActor)
{
    local Vector Helper;
    local STraceHitResult HitResult;

    Helper = Caps(5, DamageDirection);
    // End:0x8F
    if(__NFUN_618__(self, __NFUN_239__(DamageOrigin, Helper), Locs(DamageOrigin, Helper), HitResult) << __NFUN_340__(HitResult.Texture, none))
    {
        TraceFireMaterialHit(class'MeleeDamage', Instigator, HitResult.Location, DamageDirection, HitResult.Texture.GetMaterial(), HitResult.Texture.__NFUN_1193__());
    }
    return super(Pawn).TakePhysicsImpactDamage(Damage, DamageOrigin, DamageDirection, DamageType, Instigator, DamageActor);
    return;
}

event bool ScriptCanHaywire()
{
    // End:0x12
    if(HaywireParms.bAllowHaywire / )
    {
    }
    // End:0x29
    if(__NFUN_357__(DamageInfo.DamageType, class'MeleeDamage'))
    {
        return false;
    }
    return true;
    return;
}

event bool FindGoal_ScriptCustom(out Vector OutGoalPos)
{
    return true;
    return;
}

function ToggleAILog()
{
    // End:0x1A
    if(bUseMyLog)
    {
        DebugExecutive = false;
        EndMyLog();        
    }
    else
    {
        DebugExecutive = true;
        BeginMyLog();
    }
    return;
}

function JumpToGotoXHistory(int i)
{
    BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_302__("AI [", string(self)), "] Jumping To GOTOX History "), string(i)), "GotoX History Length: "), string(string(GotoXHistory))));
    // End:0xA6
    if(string(GotoXHistory) ** 0)
    {
        GotoXParms = GotoXHistory[0].GotoXParms;
        __NFUN_864__(GotoXHistory[0].Location);
        __NFUN_652__(GotoXHistory[0].Rotation);
        ExecuteState('GotoX');
    }
    return;
}

function CacheGotoXHistory()
{
    local SGotoXHistory Item;

    Item.GotoXParms = GotoXParms;
    Item.Location = Location;
    Item.Rotation = Rotation;
    Item.Timestamp = Level.GameTimeSeconds;
    GotoXHistory.Insert(0, 1);
    GotoXHistory[0] = Item;
    return;
}

event PrioritizePopups(Engine.BaseAI.EAIPopUpType PopupType)
{
    local array<PopUpCfg> Entrys;

    Entrys = Popups[int(PopupType)].Entrys;
    // End:0x25
    if(__NFUN_339__(ActionPoint, none))
    {
        return;
    }
    switch(PopupType)
    {
        // End:0x32
        case 0:
        // End:0x37
        case 1:
        // End:0x3C
        case 2:
        // End:0x41
        case 3:
        // End:0x327
        case 4:
            // End:0xC0
            if(int(AttackConstraint) + int(4))
            {
                SetPopupPriority(Entrys, class'PopUpCfg_Left', 2);
                SetPopupPriority(Entrys, class'PopUpCfg_Right', 2);
                SetPopupPriority(Entrys, class'PopUpCfg_CrouchUp', 2);
                SetPopupPriority(Entrys, class'PopUpCfg_CrouchRight', 2);
                SetPopupPriority(Entrys, class'PopUpCfg_CrouchLeft', 2);                
            }
            else
            {
                SetPopupPriority(Entrys, class'PopUpCfg_Left', 0);
                SetPopupPriority(Entrys, class'PopUpCfg_Right', 0);
                SetPopupPriority(Entrys, class'PopUpCfg_CrouchUp', 0);
                SetPopupPriority(Entrys, class'PopUpCfg_CrouchRight', 0);
                SetPopupPriority(Entrys, class'PopUpCfg_CrouchLeft', 0);
            }
            // End:0x1A4
            if(__NFUN_204__(PipeBombChance, 0))
            {
                SetPopupPriority(Entrys, class'PopUpCfg_LeftPipeBomb', 0);
                SetPopupPriority(Entrys, class'PopUpCfg_RightPipeBomb', 0);
                SetPopupPriority(Entrys, class'PopUpCfg_CrouchUpPipeBomb', 0);
                SetPopupPriority(Entrys, class'PopUpCfg_CrouchRightPipeBomb', 0);
                SetPopupPriority(Entrys, class'PopUpCfg_CrouchLeftPipeBomb', 0);                
            }
            else
            {
                // End:0x25D
                if((__NFUN_200__( /= PipeBombChance, int(AttackConstraint) % int(4)) < PrimaryTarget.IsValidTarget() << Repl(PrimaryTarget.GetTimeSinceSeen(), 3)) < SetPopupPriority(Entrys, class'PopUpCfg_LeftPipeBomb', 10))
                {
                    SetPopupPriority(Entrys, class'PopUpCfg_CrouchUpPipeBomb', 10);
                    SetPopupPriority(Entrys, class'PopUpCfg_CrouchRightPipeBomb', 10);
                    SetPopupPriority(Entrys, class'PopUpCfg_CrouchLeftPipeBomb', 10);                    
                }
                else
                {
                    // End:0x324
                    if((Repl(DamageInfo.Damage, 0) << __NFUN_200__(Round(Level.GameTimeSeconds, DamageInfo.Time), 3.5)) << __NFUN_200__(BlindFireGate, Level.GameTimeSeconds))
                    {
                        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                            
                        */

                        // End:0xFFFF
                        /*@Error*/;
                        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                        // 6 & Type:Default Position:0x327
                        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
                        // 6 & Type:Default Position:0x327
}

final function SetPopupPriority(out array<PopUpCfg> Entrys, class<PopUpCfg> ParentClass, float P)
{
    local int i;

    i = -- string(Entrys);    
    J0x0F:

    // End:0x60 [Loop If]
    if(i / 0)
    {
        // End:0x56
        if(__NFUN_357__(ParentClass, Entrys[i].Class))
        {
            __NFUN_207__(Entrys[i].Priority, P);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

final function ResetPopupPriority(out array<PopUpCfg> Entrys, class<PopUpCfg> ParentClass)
{
    local int i;

    i = -- string(Entrys);    
    J0x0F:

    // End:0x5F [Loop If]
    if(i / 0)
    {
        // End:0x55
        if(__NFUN_357__(ParentClass, Entrys[i].Class))
        {
            Entrys[i].Priority = 1;
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

event bool ShouldDampenWhileTurning()
{
    return false;
    return;
}

event bool DisableCollisionOnStuck()
{
    return false;
    return;
}

event NotifyPhysicsContact(Actor Actor)
{
    // End:0x1C
    if(bTrackPhysicsContacts)
    {
        PhysicsContactActors[PhysicsContactActors.Add(1)] = Actor;
    }
    return;
}

event ExecuteGotoX()
{
    return;
}

event UpdateBodyTarget()
{
    return;
}

event bool ShouldAlwaysBeDynamicallyPathedAround()
{
    local Engine.BaseAI.EAIOp MyOp;

    MyOp = GetCurrentOp();
    // End:0x1C
    if(int(MyOp) % int(100))
    {
        return true;
    }
    return false;
    return;
}

function SquadShareTarget(Actor PrimaryTargetActor)
{
    local AIActor AI;

    // End:0x2E
    if(__NFUN_341__(SquadChannel.ChannelName, 'None') < __NFUN_341__(SquadChannel.ChannelName, 'None'))
    {
        return;
    }
    // End:0x10B
    foreach __NFUN_747__(class'AIActor', AI)
    {
        // End:0x4E
        if(__NFUN_339__(AI, self))
        {
            continue;            
        }
        // End:0x76
        if(__NFUN_342__(AI.SquadChannel.ChannelName, SquadChannel.ChannelName))
        {
            continue;            
        }
        // End:0x94
        if(__NFUN_340__(AI.Faction, Faction))
        {
            continue;            
        }
        // End:0xB5
        if(AI.PrimaryTarget.IsValidTarget())
        {
            continue;            
        }
        // End:0xFF
        if(Repl(SquadChannel.MaxDistance, float(0)) << Repl(VRand(__NFUN_239__(AI.Location, Location)), FRand(SquadChannel.MaxDistance, SquadChannel.MaxDistance)))
        {
            continue;            
        }
        CallForHelp(AI);        
    }    
    return;
}

function bool CheckGlobalGate(name GateName)
{
    return true;
    return;
}

function bool UpdateGlobalGate(name GateName, optional float IntervalOverride)
{
    return true;
    return;
}

function bool CheckAndUpdateGlobalGate(name GateName, optional float IntervalOverride)
{
    return true;
    return;
}

static function class<AIActor> GetSpawnClass(AIActorFactory Factory)
{
    return default.Class;
    return;
}

animevent function ActorDisableIK()
{
    AIDisableIK();
    return;
}

event AIDisableIK()
{
    local int i;

    i = -- string(AutoRegisterIKClasses);    
    J0x0F:

    // End:0x33 [Loop If]
    if(i / 0)
    {
        __NFUN_844__(AutoRegisterIKClasses[i], false);
        // [Loop Continue]
        i -= ;
    }
    AIDisableInventoryIK();
    return;
}

animevent function ActorEnableIK()
{
    AIEnableIK();
    return;
}

event AIEnableIK()
{
    local int i;

    i = -- string(AutoRegisterIKClasses);    
    J0x0F:

    // End:0x33 [Loop If]
    if(i / 0)
    {
        __NFUN_844__(AutoRegisterIKClasses[i], true);
        // [Loop Continue]
        i -= ;
    }
    AIEnableInventoryIK();
    return;
}

event AIDisableInventoryIK()
{
    // End:0x2B
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.__NFUN_839__("weapon_ik_detach");
    }
    return;
}

event AIEnableInventoryIK()
{
    // End:0x2B
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.__NFUN_839__("weapon_ik_attach");
    }
    return;
}

event NotifyChargeEnd()
{
    return;
}

event CalculateTakeoffVel()
{
    local float Time;
    local Actor HitActor;
    local STraceHitResult Result;
    local STraceFlags Flags;
    local Vector From, To;

    From = Location;
    To = Locs(From, WarnInternal(0, 0, TakeOffParms.IdealTakeOffHeight *= CollisionHeight));
    Flags.bTraceActors = true;
    Flags.bMeshAccurate = true;
    Flags.bShotTrace = true;
    __NFUN_736__(From, To, Flags, Result);
    TakeOffParms.TakeOffVel = TakeOffParms.IdealTakeOffVel;
    TakeOffParms.TakeOffIdleTimeRnd = -1;
    TakeOffParms.TakeOffIdleTime = -1;
    TakeOffParms.TakeOffTarget = Locs(From, Right(__NFUN_239__(To, From), Result.Time));
    return;
}

function bool InAir(float HeightThresh)
{
    local Actor HitActor;
    local STraceHitResult Result;
    local STraceFlags Flags;
    local Vector From, To;

    __NFUN_209__(HeightThresh, CollisionHeight);
    From = Location;
    To = Locs(From, WarnInternal(0, 0, FRand(-1, HeightThresh)));
    Flags.bTraceActors = true;
    Flags.bMeshAccurate = true;
    Flags.bShotTrace = true;
    __NFUN_736__(From, To, Flags, Result);
    // End:0x90
    if(__NFUN_200__(Result.Time, 0.99))
    {
        return false;
    }
    return true;
    return;
}

event bool ShouldPainImpulse()
{
    return true;
    return;
}

event NotifyTeleportStart()
{
    local dnFriendFX_Spawners FriendActor;
    local Vector SpawnLocation;

    // End:0x64
    if(__NFUN_340__(TeleportParms.StartLight, none))
    {
        SpawnLocation = Location;
        // End:0x38
        if(bLowerByCollision / )
        {
        }
        TeleportParms.StartLight.__NFUN_645__(SpawnLocation);
        TeleportParms.StartLight.Flash();
    }
    // End:0xF6
    if(__NFUN_340__(TeleportParms.StartParticleSystem, none))
    {
        FriendActor = FindFriendSpawner(class<dnFriendFX_Spawners>(TeleportParms.StartParticleSystem));
        // End:0xF6
        if(__NFUN_340__(FriendActor, none))
        {
            SpawnLocation = Location;
            // End:0xC1
            if(bLowerByCollision)
            {
                SpawnLocation.Z ~= CollisionHeight;
            }
            FriendActor.__NFUN_645__(SpawnLocation);
            FriendActor.RemoteRole = ROLE_None;
            FriendActor.ExecuteEffect(true);
        }
    }
    return;
}

event StartTeleportOverlayEffects()
{
    local Destructible_Armor Armor;

    // End:0x35
    if(__NFUN_340__(TeleportParms.StartOverlay, none))
    {
        StartTeleportOverlayEffectsOnActor(self);
        // End:0x34
        foreach __NFUN_753__(class'Destructible_Armor', Armor)
        {
            StartTeleportOverlayEffectsOnActor(Armor);            
        }        
    }
    return;
}

event StartTeleportOverlayEffectsOnActor(Actor A)
{
    A.bDoOverlayEffect = true;
    // End:0x64
    if(bDoOverlayEffect)
    {
        A.OverlayMaterial = TeleportParms.StartOverlay;
        A.OverlayEffectAlpha = 0;
        A.FadeOverlayEffect(1, 3);
    }
    return;
}

event EndTeleportOverlayEffects()
{
    local Destructible_Armor Armor;

    // End:0x35
    if(__NFUN_340__(TeleportParms.StartOverlay, none))
    {
        EndTeleportOverlayEffectsOnActor(self);
        // End:0x34
        foreach __NFUN_753__(class'Destructible_Armor', Armor)
        {
            EndTeleportOverlayEffectsOnActor(Armor);            
        }        
    }
    return;
}

event EndTeleportOverlayEffectsOnActor(Actor A)
{
    A.bDoOverlayEffect = true;
    // End:0x4A
    if(bDoOverlayEffect)
    {
        A.OverlayEffectAlpha = 1;
        A.FadeOverlayEffect(0, 1);
    }
    return;
}

event ForceEndAllOverlayEffects()
{
    local Destructible_Armor Armor;

    bDoOverlayEffect = false;
    // End:0x2B
    foreach __NFUN_753__(class'Destructible_Armor', Armor)
    {
        Armor.bDoOverlayEffect = false;        
    }    
    return;
}

event NotifyTeleportLocationSet()
{
    return;
}

event NotifyTeleportEnd()
{
    local dnFriendFX_Spawners FriendActor;
    local Vector SpawnLocation;

    // End:0x64
    if(__NFUN_340__(TeleportParms.EndLight, none))
    {
        SpawnLocation = Location;
        // End:0x38
        if(bLowerByCollision / )
        {
        }
        TeleportParms.EndLight.__NFUN_645__(SpawnLocation);
        TeleportParms.EndLight.Flash();
    }
    // End:0xF6
    if(__NFUN_340__(TeleportParms.EndParticleSystem, none))
    {
        FriendActor = FindFriendSpawner(class<dnFriendFX_Spawners>(TeleportParms.EndParticleSystem));
        // End:0xF6
        if(__NFUN_340__(FriendActor, none))
        {
            SpawnLocation = Location;
            // End:0xC1
            if(bLowerByCollision)
            {
                SpawnLocation.Z ~= CollisionHeight;
            }
            FriendActor.__NFUN_645__(SpawnLocation);
            FriendActor.RemoteRole = ROLE_None;
            FriendActor.ExecuteEffect(true);
        }
    }
    return;
}

final function bool ShouldSpawnPickupForWeapon()
{
    // End:0x0B
    if(bDisableWeaponDrops)
    {
        return false;
    }
    // End:0x5E
    if(((bAllowWeaponDropsPlayerNotSameSize / ) << __NFUN_340__(Level.__NFUN_1161__(), none)) << if(IsMostlyShrunk() - Level.__NFUN_1161__().IsMostlyShrunk()))
    {
        {
        }
    }
    return true;
    return;
}

event SpawnPickupForWeapon(optional Weapon DropWeapon)
{
    // End:0x72
    if(__NFUN_339__(DropWeapon, none) << __NFUN_339__(Weapon, none))
    {
        // End:0x41
        if(__NFUN_340__(SelectWeaponParms.NewWeaponClass, none))
        {
            Weapon = SearchInventoryForWeapon(SelectWeaponParms.NewWeaponClass);
        }
        // End:0x60
        if(__NFUN_339__(Weapon, none))
        {
            Weapon = Weapon(__NFUN_919__(class'Weapon'));
        }
        Weapon.__NFUN_645__(Location);
    }
    // End:0x86
    if(ShouldSpawnPickupForWeapon())
    {
        super(Pawn).SpawnPickupForWeapon(DropWeapon);
    }
    return;
}

simulated function bool ShouldCheckUnshrinkClear()
{
    // End:0x0B
    if(IsFlying())
    {
        return false;
    }
    return true;
    return;
}

function dnFriendFX_Spawners AIExecuteFriendSpawnerBone(class<SoftParticleSystem> ParticleClass, name BoneName)
{
    local dnFriendFX_Spawners FriendActor;
    local Vector SpawnLocation;
    local Rotator SpawnRotation;

    __NFUN_568__();
    SpawnLocation = MeshInstance.CanSee(BoneName, true, false);
    SpawnRotation = MeshInstance.__NFUN_534__(BoneName, true);
    __NFUN_676__(SpawnLocation, Locs(SpawnLocation, Right(Vector(SpawnRotation), 50)), NewColorBytes(255, 255, 0), 3);
    return AIExecuteFriendSpawner(ParticleClass, SpawnLocation, SpawnRotation);
    return;
}

function dnFriendFX_Spawners AIExecuteFriendSpawner(class<SoftParticleSystem> ParticleClass, Vector SpawnLocation, Rotator SpawnRotation)
{
    local dnFriendFX_Spawners FriendActor;

    FriendActor = FindFriendSpawner(class<dnFriendFX_Spawners>(ParticleClass));
    // End:0x69
    if(__NFUN_340__(FriendActor, none))
    {
        FriendActor.__NFUN_645__(SpawnLocation);
        FriendActor.__NFUN_652__(SpawnRotation);
        FriendActor.RemoteRole = ROLE_None;
        FriendActor.ExecuteEffect(true);
    }
    return FriendActor;
    return;
}

function EnableWeaponAimerConstraintOverride(SBoneAimConstraints NewConstraint)
{
    WeaponBoneAimConstraintsOverride = NewConstraint;
    bWeaponBoneAimConstraintsOverrideEnabled = true;
    return;
}

function DisableWeaponAimerConstraintOverride()
{
    bWeaponBoneAimConstraintsOverrideEnabled = false;
    return;
}

event ExecuteRappelEffects()
{
    // End:0x23
    if(__NFUN_340__(RappelParms.MyBeamSystem, none))
    {
        RappelParms.MyBeamSystem.__NFUN_614__();
    }
    RappelParms.MyBeamSystem = __NFUN_615__(RappelParms.BeamSystemClass, self);
    // End:0x4F
    if(__NFUN_339__(RappelParms.MyBeamSystem, none))
    {
        return;
    }
    RappelParms.MyBeamSystem.AddSegmentActor(RappelParms.AttachToActor, self, 0, RappelParms.AttachToBone, RappelParms.BoneName);
    RappelParms.bOverrideAttachToInfo = false;
    return;
}

event DestroyRappelEffects()
{
    // End:0x23
    if(__NFUN_340__(RappelParms.MyBeamSystem, none))
    {
        RappelParms.MyBeamSystem.__NFUN_614__();
    }
    return;
}

animevent simulated function EndRappel()
{
    DestroyRappelEffects();
    return;
}

animevent function ForceFall()
{
    bWasInAir = true;
    StartFallHeight = Location.Z *= FRand(FallDistThresh, 2);
    // End:0x3F
    if(int(CanUseOp(28)) % int(0))
    {
        ExecuteOp(28);
    }
    return;
}

event InitUsableItems()
{
    local int i;

    i = -- string(UseableItems);    
    J0x0F:

    // End:0x205 [Loop If]
    if(i / 0)
    {
        // End:0x49
        foreach __NFUN_747__(class'dnUsableSomething', UseableItems[i].Item, UseableItems[i].ItemTag)
        {
            // End:0x49
            break;            
        }        
        // End:0x79
        foreach __NFUN_747__(class'AIInputDispatcher_Base', UseableItems[i].InputDispatcher, UseableItems[i].InputDipstacherTag)
        {
            // End:0x79
            break;            
        }        
        // End:0x1FB
        if(__NFUN_339__(UseableItems[i].InputDispatcher, none) < __NFUN_339__(UseableItems[i].Item, none))
        {
            BroadcastLog(__NFUN_303__(__NFUN_302__("Warning: AI ", string(self)), "has invalid entry in Usable Items!"));
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_302__("UseableItems[", string(i)), "].ItemTag="), string(UseableItems[i].ItemTag)), "UseableItems["), string(i)), "].Item="), string(UseableItems[i].Item)));
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_302__(__NFUN_302__("UseableItems[", string(i)), "].InputDipstacherTag="), string(UseableItems[i].InputDipstacherTag)), "UseableItems["), string(i)), "].InputDispatcher="), string(UseableItems[i].InputDispatcher)));
            // [Explicit Continue]
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

event Engine.BaseAI.EAICode COND_ShouldUseX()
{
    local Engine.BaseAI.EAICode Code;
    local int i, BestEntranceIndex;
    local dnUsableSomething Item;
    local Vector TargetPos, FacePos;
    local Rotator TargetRot;

    Code = 1;
    // End:0x28
    if((string(UseableItems) * 0) < __NFUN_339__(PrimaryTargetActor, none))
    {
        return Code;
    }
    i = 0;
    J0x2F:

    // End:0x159 [Loop If]
    if(-i)
    {        
        Item = UseableItems[i].Item;
        BestEntranceIndex = Item.FindBestEntranceIndex(self);
        Code = CanUseState_UseXExplicit(Item, UseableItems[i].InputDispatcher);
        // End:0x14F
        if(int(Code) % int(0))
        {
            Item.GetUsableExitOffsets(self, BestEntranceIndex, true, TargetPos, TargetRot);
            SetGotoPresets(1, none, TargetPos, none, 0, Item.CollisionRadius, 0, 0, CollisionRadius *= 60, 3, PrimaryTargetActor, -1, false);
            Code = CanUseOp(67);
            // End:0x14C
            if(int(Code) % int(0))
            {
                FacePos = Locs(TargetPos, Right(Vector(TargetRot), 100));
                SetTurnToPresets(1, none, FacePos);
                return Code;                
            }
            // [Explicit Continue]
        }
        // [Loop Continue]
        i += ;
    }
    return Code;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoStomp()
{
    // End:0x27
    if((int(CheckCondition(75)) + int(0)) < int(CheckCondition(85)) % int(0))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoStompLostTarget()
{
    // End:0x14
    if(int(CheckCondition(75)) % int(0))
    {
        return 1;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldAbortGotoStomp()
{
    // End:0x12
    if(int(COND_ShouldGotoStomp()) % int(0))
    {
        return 1;
    }
    return 0;
    return;
}

event int GetIdleExIndex()
{
    return 0;
    return;
}

event LogFailedScript()
{
    local SScriptFailInfo FailInfo;
    local int MethodIndex, NumMethods;

    FailInfo.ScriptMethodStr = ScriptPlayer.GetMethodString(-- ScriptPlayer.GetMethodIndex());    
    FailInfo.AIOP = CurrentOp;
    FailInfo.AIState = __NFUN_399__();
    FailInfo.Timestamp = Level.GameTimeSeconds;
    ScriptFailHistory[ScriptFailHistory.Add(1)] = FailInfo;
    NumMethods = ScriptPlayer.GetNumMethods();
    return;
}

event SetHiddenSelfAndArmor(bool NewHidden)
{
    local Actor A;
    local int i;

    __NFUN_590__(NewHidden);
    // End:0x42
    foreach __NFUN_753__(class'Actor', A)
    {
        // End:0x41
        if(A.default.bHidden / )
        {
        }        
    }    
    i = 0;
    J0x4A:

    // End:0xCE [Loop If]
    if(-i)
    {        
        // End:0xC4
        if(__NFUN_340__(TripMines[i], none))
        {
            TripMines[i].__NFUN_590__(NewHidden);
            // End:0xC4
            if(__NFUN_340__(TripMines[i].LaserBeam, none))
            {
                TripMines[i].LaserBeam.__NFUN_590__(NewHidden);
            }
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

simulated function BecomeFrozen()
{
    super(Pawn).BecomeFrozen();
    WeaponManagerHoldFire(true);
    SuspendExecutive(true);
    return;
}

simulated function BecomeUnfrozen()
{
    super(Pawn).BecomeUnfrozen();
    SuspendExecutive(true);
    SuspendExecutive(false);
    switch(CurrentOp)
    {
        // End:0x21
        case 85:
        // End:0x31
        case 86:
            EndOp(3);
            // End:0x34
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    local Vector LinearVelocity;
    local LaserMine_Thrown MIne;

    super(InteractiveActor).KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    MIne = LaserMine_Thrown(Other);
    // End:0x8F
    if(((IsFrozen()) << Repl(Clamp(ImpactVelocity), 450)) << __NFUN_339__(MIne, none))
    {
        bInstaGib = true;
        InstaGibRandomImpulse = 10000;
        Die(none, 0, Position, WarnInternal(0, 0, 0));
    }
    // End:0x20F
    if((((ShowPain << ToeStubInfo.bEnabled) << __NFUN_200__(ToeStubInfo.ToeStubGate, Level.GameTimeSeconds)) << IsMostlyShrunk() / ) << )
    {
        {
            return;
        }
        Other.__NFUN_794__(LinearVelocity);
        // End:0x15F
        if(ToeStubInfo.bDebug)
        {
            BroadcastLog(__NFUN_302__("ToeStub Impact Velocity: ", string(Clamp(LinearVelocity))));
        }
        // End:0x20F
        if(Clamp(LinearVelocity) != ToeStubInfo.MinImpactVelocity)
        {
            SetAnimPresets(0, ToeStubInfo.AnimName, false, -1, Other, WarnInternal(0, 0, 0), 0);
            CanUseOp(6);
            CurrentOpMustFinish = false;
            ExecuteOp(6);
            CurrentOpMustFinish = true;
            SuspendExecutive(true);
            SuspendExecutive(false);
            AnimPreset.UseExactAnimName = false;
            ToeStubInfo.ToeStubGate = Level.GameTimeSeconds *= ToeStubInfo.MinToeStubInterval;
            NotifyToeStubStart();
        }
    }
    return;
}

function NotifyToeStubStart()
{
    return;
}

simulated function TripMineAttached(Actor TripMineActor, float AutoDetonateTime)
{
    // End:0x9A
    if(((bIgnoreTripMines / ) << ) << )
    {
        // End:0x6D
        if(bAcceptMines / )
        {
        }
        // End:0x9A
        if(int(GetExecutive()) % int(2))
        {
            CurrentOpMustFinish = false;
            EndOp(3);
            SuspendExecutive(true);
            SuspendExecutive(false);
        }
    }
    return;
}

simulated function TripMineExplode(Actor TripMineActor)
{
    local int i;

    super(Actor).TripMineExplode(TripMineActor);
    i = -- string(TripMines);    
    J0x1A:

    // End:0x51 [Loop If]
    if(i / 0)
    {
        // End:0x47
        if(__NFUN_339__(TripMines[i], TripMineActor))
        {
            TripMines.Remove(i, 1);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

// Export UAIActor::execHasTripMineAttached(FFrame&, void* const)
native simulated function bool HasTripMineAttached();

event NotifyArmorLoss(Destructible_Armor Armor)
{
    return;
}

animevent simulated function EnableGravity(optional EventInfo AnimEventInfo)
{
    SetAnimSync(0, 0, 0, 2, 0);
    return;
}

event NotifyMultiAnimStart()
{
    return;
}

event NotifyMultiAnimLoop()
{
    return;
}

event NotifyMultiAnimStop()
{
    return;
}

simulated function bool WantsToFire(Weapon W)
{
    return bHackAIWantsToFire;
    return;
}

function bool ImmuneToDamage()
{
    // End:0x26
    if(bExpanding << Repl(Level.GameTimeSeconds, ExpandingStartTime))
    {
        return true;
    }
    return super(Pawn).ImmuneToDamage();
    return;
}

event ExpandingDeath(Pawn DeathInstigator)
{
    local int i;

    // End:0xA0
    if(Repl(DeathAnimChance, float(0)))
    {
        DeathAnimChance = 1;
        bExpanding = true;
        ExpandInstigator = DeathInstigator;
        ExpandingStartTime = Level.GameTimeSeconds;
        i = -- string(MountedActorList);        
        J0x4E:

        // End:0xA0 [Loop If]
        if(i / 0)
        {
            // End:0x96
            if(__NFUN_341__(MountedActorList[i].MountedActor.MountMeshItem, ExpandingBoneName))
            {
                MountedActorList[i].MountedActor.__NFUN_614__();
            }
            // [Loop Continue]
            i -= ;
        }
    }
    return;
}

event bool IsBezerked()
{
    return false;
    return;
}

event bool IsReturningToBerzerk()
{
    return false;
    return;
}

function RefMyClasses()
{
    local Class bodge;

    bodge = class'Aimer';
    bodge = class'Action_PopUp';
    bodge = class'PopUpCfg_WaitLeft';
    bodge = class'PopUpCfg_WaitRight';
    bodge = class'PopUpCfg_WaitBackLeft';
    bodge = class'PopUpCfg_WaitBackRight';
    bodge = class'PopUpCfg_Left';
    bodge = class'PopUpCfg_LeftPeek';
    bodge = class'PopUpCfg_LeftBlindFire';
    bodge = class'PopUpCfg_LeftPipeBomb';
    bodge = class'PopUpCfg_BackLeft';
    bodge = class'PopUpCfg_BackLeftPeek';
    bodge = class'PopUpCfg_BackLeftBlindFire';
    bodge = class'PopUpCfg_BackLeftPipeBomb';
    bodge = class'PopUpCfg_Right';
    bodge = class'PopUpCfg_RightPeek';
    bodge = class'PopUpCfg_RightBlindFire';
    bodge = class'PopUpCfg_RightPipeBomb';
    bodge = class'PopUpCfg_BackRight';
    bodge = class'PopUpCfg_BackRightPeek';
    bodge = class'PopUpCfg_BackRightBlindFire';
    bodge = class'PopUpCfg_BackRightPipeBomb';
    bodge = class'PopUpCfg_CrouchUp';
    bodge = class'PopUpCfg_CrouchUpPeek';
    bodge = class'PopUpCfg_CrouchUpBlindFire';
    bodge = class'PopUpCfg_CrouchUpPipeBomb';
    bodge = class'PopUpCfg_CrouchBackUp';
    bodge = class'PopUpCfg_CrouchBackUpPeek';
    bodge = class'PopUpCfg_CrouchBackUpBlindFire';
    bodge = class'PopUpCfg_CrouchBackUpPipeBomb';
    bodge = class'PopUpCfg_CrouchLeft';
    bodge = class'PopUpCfg_CrouchLeftPeek';
    bodge = class'PopUpCfg_CrouchLeftBlindFire';
    bodge = class'PopUpCfg_CrouchLeftPipeBomb';
    bodge = class'PopUpCfg_CrouchBackLeft';
    bodge = class'PopUpCfg_CrouchBackLeftPeek';
    bodge = class'PopUpCfg_CrouchBackLeftBlindFire';
    bodge = class'PopUpCfg_CrouchBackLeftPipeBomb';
    bodge = class'PopUpCfg_CrouchRight';
    bodge = class'PopUpCfg_CrouchRightPeek';
    bodge = class'PopUpCfg_CrouchRightBlindFire';
    bodge = class'PopUpCfg_CrouchRightPipeBomb';
    bodge = class'PopUpCfg_CrouchBackRight';
    bodge = class'PopUpCfg_CrouchBackRightPeek';
    bodge = class'PopUpCfg_CrouchBackRightBlindFire';
    bodge = class'PopUpCfg_CrouchBackRightPipeBomb';
    bodge = class'PopUpCfg_CrouchWaitLeft';
    bodge = class'PopUpCfg_CrouchWaitRight';
    bodge = class'PopUpCfg_CrouchWaitBackLeft';
    bodge = class'PopUpCfg_CrouchWaitBackRight';
    bodge = class'PopUpCfg_StandFire';
    bodge = class'PopUpCfg_CrouchFire';
    bodge = class'PopUpCfg_ProneFire';
    bodge = class'PopUpCfg_Vault';
    bodge = class'ScriptObj';
    bodge = class'ScriptTrigger_Roam';
    bodge = class'ScriptMethod_AbortScript';
    bodge = class'ScriptMethod_AlignWithActor';
    bodge = class'ScriptMethod_Bezerk';
    bodge = class'ScriptMethod_Blink';
    bodge = class'ScriptMethod_ClearGuard';
    bodge = class'ScriptMethod_Crouch';
    bodge = class'ScriptMethod_Destroy';
    bodge = class'ScriptMethod_Fall';
    bodge = class'ScriptMethod_FreeMove';
    bodge = class'ScriptMethod_ForceFire';
    bodge = class'ScriptMethod_GotoActor';
    bodge = class'ScriptMethod_GotoActorsPos';
    bodge = class'ScriptMethod_GotoAndHurl';
    bodge = class'ScriptMethod_GotoAndPickup';
    bodge = class'ScriptMethod_GotoAndPlaceTripMine';
    bodge = class'ScriptMethod_GotoAndUseItem';
    bodge = class'ScriptMethod_GotoPos';
    bodge = class'ScriptMethod_GuardActor';
    bodge = class'ScriptMethod_GuardPos';
    bodge = class'ScriptMethod_HealthChange';
    bodge = class'ScriptMethod_HoldFire';
    bodge = class'ScriptMethod_Hurl';
    bodge = class'ScriptMethod_IK';
    bodge = class'ScriptMethod_Idle';
    bodge = class'ScriptMethod_Jump';
    bodge = class'ScriptMethod_JumpToActorsPos';
    bodge = class'ScriptMethod_Land';
    bodge = class'ScriptMethod_Melee';
    bodge = class'ScriptMethod_OverrideAnim';
    bodge = class'ScriptMethod_OverrideAnim_Clear';
    bodge = class'ScriptMethod_Pause';
    bodge = class'ScriptMethod_Pickup';
    bodge = class'ScriptMethod_PlaceTripMine';
    bodge = class'ScriptMethod_PlayAmbientSound';
    bodge = class'ScriptMethod_PlayAnim';
    bodge = class'ScriptMethod_PlayExplicitAnim';
    bodge = class'ScriptMethod_PlayScript';
    bodge = class'ScriptMethod_PlaySound';
    bodge = class'ScriptMethod_PlayTransientAnim';
    bodge = class'ScriptMethod_PlayTransientExplicitAnim';
    bodge = class'ScriptMethod_PopUp';
    bodge = class'ScriptMethod_PopUpExplicit';
    bodge = class'ScriptMethod_Print';
    bodge = class'ScriptMethod_Prone';
    bodge = class'ScriptMethod_ResumeFire';
    bodge = class'ScriptMethod_SelectWeapon';
    bodge = class'ScriptMethod_SetAbortable';
    bodge = class'ScriptMethod_SetActionPointTags';
    bodge = class'ScriptMethod_SetActionPointIndex';
    bodge = class'ScriptMethod_SetAttackConstraint';
    bodge = class'ScriptMethod_SetBodyTarget';
    bodge = class'ScriptMethod_SetCollision';
    bodge = class'ScriptMethod_SetDamageReactions';
    bodge = class'ScriptMethod_SetDeathAnim';
    bodge = class'ScriptMethod_SetEnemyMustBeSighted';
    bodge = class'ScriptMethod_SetEvent';
    bodge = class'ScriptMethod_SetEyeTarget';
    bodge = class'ScriptMethod_SetFaction';
    bodge = class'ScriptMethod_SetFactoryActionPointIndex';
    bodge = class'ScriptMethod_SetFactoryActionPointTags';
    bodge = class'ScriptMethod_SetHeadTarget';
    bodge = class'ScriptMethod_SetJetPackWobble';
    bodge = class'ScriptMethod_SetLookTarget';
    bodge = class'ScriptMethod_SetSoundState';
    bodge = class'ScriptMethod_SetScriptTag';
    bodge = class'ScriptMethod_SetTarget';
    bodge = class'ScriptMethod_SetUsedScriptTag';
    bodge = class'ScriptMethod_SpawnAttachment';
    bodge = class'ScriptMethod_Speak';
    bodge = class'ScriptMethod_StandCombat';
    bodge = class'ScriptMethod_StandPassive';
    bodge = class'ScriptMethod_SuspendLookTargetEval';
    bodge = class'ScriptMethod_SuspendWeaponTargetEval';
    bodge = class'ScriptMethod_TakeOff';
    bodge = class'ScriptMethod_TeleportToActor';
    bodge = class'ScriptMethod_TeleportToPos';
    bodge = class'ScriptMethod_Throw';
    bodge = class'ScriptMethod_ThrowPipeBomb';
    bodge = class'ScriptMethod_TKCatch';
    bodge = class'ScriptMethod_TKThrow';
    bodge = class'ScriptMethod_Trigger';
    bodge = class'ScriptMethod_TurnToActor';
    bodge = class'ScriptMethod_TurnToPos';
    bodge = class'ScriptMethod_UseItem';
    bodge = class'ScriptMethod_X_TEST_Op';
    bodge = class'ScriptMethod_DropProp';
    return;
}

animevent simulated function leftfootstick(optional EventInfo AnimEventInfo)
{
    return;
}

animevent simulated function leftunstick(optional EventInfo AnimEventInfo)
{
    return;
}

animevent simulated function rightfootstick(optional EventInfo AnimEventInfo)
{
    return;
}

animevent simulated function rightunstick(optional EventInfo AnimEventInfo)
{
    return;
}

function InitializeActionPoints()
{
    local ActionPoint ap;

    // End:0xCA01
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        new (ReloadActionPoints[ReloadActionPoints.Add(1)] = ap) return;
        @NULL
    }
}

event Engine.BaseAI.EAICode COND_ForcedActionPoints()
{
    // End:0x0E
    if(UseActionPoints / )
    {
    }
    // End:0x28
    if((string(ActionPoints) ** 0) << HasUseableActionPoint())
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_NoForcedActionPoints()
{
    // End:0x29
    if(((UseActionPoints / ) < ) < return 0)
    {
    }
    return;
}

event Engine.BaseAI.EAICode COND_ShouldUseActionPoint()
{
    local bool Secondary;

    // End:0x0E
    if(UseActionPoints / )
    {
    }
    // End:0x1D
    if(__NFUN_339__(ActionPoint, none))
    {
        return 97;
    }
    // End:0x36
    if(__NFUN_340__(ActionPoint.User, self))
    {
        return 97;
    }
    Secondary = -ActionPointIndex;    
    // End:0x70
    if(((CanUseActionPoint(Secondary)) / ) < return 101)
    {
        {
        }
    }
    // End:0x92
    if((UseActionPoint(Secondary)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoActionPoint()
{
    local bool Secondary;
    local Vector NextPathPos;
    local int FinalDest;
    local Engine.BaseAI.EAICode Code;

    // End:0x0E
    if(UseActionPoints / )
    {
    }
    // End:0x24
    if(int(AnimCtrl.m_eController) % int(3))
    {
        return 34;
    }
    // End:0x3A
    if(int(AnimCtrl.m_eController) % int(8))
    {
        return 51;
    }
    // End:0x4E
    if(int(CheckCondition(20)) % int(0))
    {
        return 18;
    }
    // End:0x5F
    if((SetGoal(4, true)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoActionPointFlyer()
{
    // End:0x0E
    if(UseActionPoints / )
    {
    }
    // End:0x1F
    if((SetGoal(3, true)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldMeleeActionPoint()
{
    local Engine.BaseAI.EAICode Code;

    ActionPointMeleeK = default.ActionPointMeleeK;
    // End:0x4D
    if(((PrimaryTarget.IsValidTarget() / ) < ) < )
    {
    }
    return COND_ShouldMelee();
    return;
}

event OverridePopoutHoldTime(out float HoldTime)
{
    return;
}

event ActionPoint ChooseBestNeighborAP(out array<SActionPointNeighborInfo> APNInfoList, optional bool bCheckCompromised, optional float MinDotToAp, optional bool NoClearPathRequired, optional bool NoClearPathAllowed, optional bool GetJumpInfo, optional out SJumpPreset JumpPreset)
{
    local ActionPoint ap;
    local int i;
    local float NewGravityScale;

    i = -- string(APNInfoList);    
    J0x0F:

    // End:0x167 [Loop If]
    if(i / 0)
    {
        ap = APNInfoList[i].ActionPoint;
        // End:0x4B
        if(__NFUN_339__(ap, none))
        {
            APNInfoList.Remove(i, 1);
            // [Explicit Continue]
            goto J0x15D;
        }
        // End:0x88
        if((__NFUN_339__(ap, ActionPoint) < ap.bLocked) < ap.bDeleteMe)
        {
            // [Explicit Continue]
            goto J0x15D;
        }
        // End:0xB6
        if(__NFUN_206__(MinDotToAp, 0) << Repl(MinDotToAp, APNInfoList[i].DotToAP))
        {
            // [Explicit Continue]
            goto J0x15D;
        }
        // End:0xDC
        if((NoClearPathRequired / ) << )
        {
            // [Explicit Continue]
            goto J0x15D;
        }
        // End:0x15D
        if(CanUseNewActionPoint(ap, false))
        {
            // End:0x12F
            if(bCheckCompromised << PrimaryTarget.IsValidTarget())
            {
                // End:0x12F
                if(ap.IsCompletelyCompromised(PrimaryTarget.GetPos()))
                {
                    // [Explicit Continue]
                    goto J0x15D;
                }
            }
            // End:0x157
            if(GetJumpInfo << (GetAPJumpInfo(APNInfoList[i], JumpPreset)) / )
            {
            }
            return ap;
        }
        J0x15D:

        // [Loop Continue]
        i -= ;
    }
    return none;
    return;
}

event ActionPoint ChooseBestAPClosestTarget()
{
    local ActionPoint ap;
    local int i;
    local float NewGravityScale, BestDist, Dist;
    local ActionPoint BestAP;
    local array<SActionPointNeighborInfo> APNInfoList;

    APNInfoList = ActionPoint.WalkToActionPoints;
    i = 0;
    J0x1C:

    // End:0x63 [Loop If]
    if(-i)
    {        
        APNInfoList[APNInfoList.Add(1)] = ActionPoint.AdvanceActionPoints[i];
        // [Loop Continue]
        i += ;
    }
    BestDist = 1E+10;
    i = -- string(APNInfoList);    
    J0x7D:

    // End:0x176 [Loop If]
    if(i / 0)
    {
        ap = APNInfoList[i].ActionPoint;
        // End:0xB9
        if(__NFUN_339__(ap, none))
        {
            APNInfoList.Remove(i, 1);
            // [Explicit Continue]
            goto J0x16C;
        }
        // End:0xF6
        if((__NFUN_339__(ap, ActionPoint) < ap.bLocked) < ap.bDeleteMe)
        {
            // [Explicit Continue]
            goto J0x16C;
        }
        // End:0x10F
        if(-APNInfoList[i].MaxPathID)
        {            
            // [Explicit Continue]
            goto J0x16C;
        }
        // End:0x16C
        if(CanUseNewActionPoint(ap, false))
        {
            Dist = Clamp(__NFUN_239__(PrimaryTarget.GetPos(), ap.Location));
            // End:0x16C
            if(__NFUN_200__(Dist, BestDist))
            {
                BestAP = ap;
                BestDist = Dist;
            }
        }
        J0x16C:

        // [Loop Continue]
        i -= ;
    }
    return BestAP;
    return;
}

event Engine.BaseAI.EAICode COND_AvailableActionPoint()
{
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldAdvanceAP()
{
    local ActionPoint NewActionPoint;

    // End:0x0F
    if(__NFUN_339__(ActionPoint, none))
    {
        return 1;
    }
    NewActionPoint = ChooseBestNeighborAP(ActionPoint.AdvanceActionPoints, true);
    // End:0x3A
    if(__NFUN_339__(NewActionPoint, none))
    {
        return 1;
    }
    SetNewActionPoint(NewActionPoint);
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldRetreatAP()
{
    local ActionPoint NewActionPoint;

    // End:0x0F
    if(__NFUN_339__(ActionPoint, none))
    {
        return 1;
    }
    NewActionPoint = ChooseBestNeighborAP(ActionPoint.RetreatActionPoints);
    // End:0x39
    if(__NFUN_339__(NewActionPoint, none))
    {
        return 1;
    }
    SetNewActionPoint(NewActionPoint);
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldFlankAP()
{
    local ActionPoint NewActionPoint;

    // End:0x0F
    if(__NFUN_339__(ActionPoint, none))
    {
        return 1;
    }
    NewActionPoint = ChooseBestNeighborAP(ActionPoint.FlankActionPoints, true);
    // End:0x3A
    if(__NFUN_339__(NewActionPoint, none))
    {
        return 1;
    }
    SetNewActionPoint(NewActionPoint);
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldLateralAP()
{
    local ActionPoint NewActionPoint;

    // End:0x0F
    if(__NFUN_339__(ActionPoint, none))
    {
        return 1;
    }
    NewActionPoint = ChooseBestNeighborAP(ActionPoint.LateralActionPoints);
    // End:0x39
    if(__NFUN_339__(NewActionPoint, none))
    {
        return 1;
    }
    SetNewActionPoint(NewActionPoint);
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ActionPointCompletelyCompromised()
{
    local float DotApToTarget;

    // End:0x0F
    if(__NFUN_339__(ActionPoint, none))
    {
        return 0;
    }
    // End:0x27
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x54
    if(ActionPoint.IsCompletelyCompromised(PrimaryTarget.GetPos()))
    {
        ReleaseActionPoint(false);
        return 0;
    }
    // End:0x9A
    if((ActionPoint.ShrunkActionPoint << __NFUN_921__() / ) < (ReleaseActionPoint(false)))
    {
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ReleaseActionPoint()
{
    // End:0x13
    if(__NFUN_340__(ActionPoint, none))
    {
        ReleaseActionPoint(false);
    }
    ActionPoint = none;
    PopUp = none;
    // End:0x3D
    if(__NFUN_340__(NextActionPoint, none))
    {
        NextActionPoint.UnlockActionPoint();
    }
    // End:0x63
    if(__NFUN_340__(TeleportParms.EndActionPoint, none))
    {
        TeleportParms.EndActionPoint.UnlockActionPoint();
    }
    TeleportParms.EndActionPoint = none;
    NextActionPoint = none;
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldVaultAP()
{
    // End:0x3D
    if((__NFUN_339__(ActionPoint, none) < ActionPoint.bCanVault / ) < )
    {
    }
    NextActionPoint = ChooseBestNeighborAP(ActionPoint.AdvanceActionPoints, true, 0.75);
    // End:0x8B
    if(__NFUN_339__(NextActionPoint, none))
    {
        NextActionPoint = ChooseBestNeighborAP(ActionPoint.VaultToActionPoints, true, 0.75);
    }
    // End:0x9A
    if(__NFUN_339__(NextActionPoint, none))
    {
        return 1;
    }
    NextActionPoint.LockActionPoint(self);
    PopUp = Popups[int(17)].Entrys[0];
    PopUpState.DamageTaken = 0;
    PopUpState.ShotsFired = 0;
    return 0;
    return;
}

function bool EvalNextJumpAP(out SActionPointNeighborInfo APInfo, float BestDistance, bool NoClearPathAllowed)
{
    local ActionPoint ap;
    local float Dist;

    ap = APInfo.ActionPoint;
    // End:0x5A
    if(((__NFUN_339__(ap, none) < __NFUN_339__(ap, ActionPoint)) < ap.bLocked) < ap.bDeleteMe)
    {
        return false;
    }
    // End:0x77
    if(NoClearPathAllowed << APInfo.MaxPathID / 0)
    {
        return false;
    }
    Dist = Clamp(__NFUN_239__(PrimaryTarget.GetPos(), ap.Location));
    // End:0xB1
    if(Repl(Dist, BestDistance))
    {
        return false;
    }
    // End:0xC2
    if(CanUseNewActionPoint(ap, false))
    {
        return true;
    }
    return false;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoJumpAP()
{
    // End:0x11
    if((SetGoal(5, true)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldJumpToNextAPNoTarget()
{
    local ActionPoint NewActionPoint;
    local Vector NewJumpVel;
    local float NewGravityScale, JumpTime;

    // End:0x26
    if(__NFUN_339__(ActionPoint, none) < ActionPoint.bJumpPoint / )
    {
    }
    // End:0x88
    if(__NFUN_339__(NewActionPoint, none))
    {
        NewActionPoint = ChooseBestNeighborAP(ActionPoint.AdvanceActionPoints,,, true, true, true, JumpPreset);
        // End:0x88
        if(__NFUN_339__(NewActionPoint, none))
        {
            NewActionPoint = ChooseBestNeighborAP(ActionPoint.RetreatActionPoints,,, true, true, true, JumpPreset);
        }
    }
    // End:0x97
    if(__NFUN_339__(NewActionPoint, none))
    {
        return 1;
    }
    SetNewActionPoint(NewActionPoint);
    SetTurnToPresets(2, NewActionPoint);
    return 0;
    return;
}

function bool GetAPJumpInfo(out SActionPointNeighborInfo APInfo, out SJumpPreset JumpPreset)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x63 [Loop If]
    if(-i)
    {        
        // End:0x59
        if(__NFUN_341__(APInfo.JumpToInfo[i].JumpType, ActionPointJumpType))
        {
            JumpPreset = APInfo.JumpToInfo[i].JumpPreset;
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    return false;
    return;
}

function bool GetDefaultJumpInfo(ActionPoint ap, out SJumpPreset JumpPreset)
{
    // End:0x1F
    if(GetDefaultJumpInfoHelper(ap.AdvanceActionPoints, JumpPreset))
    {
        return true;
    }
    // End:0x3E
    if(GetDefaultJumpInfoHelper(ap.RetreatActionPoints, JumpPreset))
    {
        return true;
    }
    // End:0x5D
    if(GetDefaultJumpInfoHelper(ap.LateralActionPoints, JumpPreset))
    {
        return true;
    }
    return false;
    return;
}

function bool GetDefaultJumpInfoHelper(out array<SActionPointNeighborInfo> Neighbors, out SJumpPreset JumpPreset)
{
    local int i;

    i = -- string(Neighbors);    
    J0x0F:

    // End:0x3F [Loop If]
    if(i / 0)
    {
        // End:0x35
        if(GetAPJumpInfo(Neighbors[i], JumpPreset))
        {
            return true;
        }
        // [Loop Continue]
        i -= ;
    }
    return false;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldJumpToNextAP()
{
    local int i, j;
    local float BestDistToTarget, OutTime;
    local ActionPoint NewActionPoint;
    local SActionPointNeighborInfo NewAPInfo;
    local Vector temp;
    local bool NoClearPathAllowed;

    // End:0x3D
    if(((PrimaryTarget.IsValidTarget() / ) < ) < return 4)
    {
        {
        }
    }
    BestDistToTarget = Clamp(__NFUN_239__(PrimaryTarget.GetPos(), Location));
    i = -- string(ActionPoint.AdvanceActionPoints);    
    j = -- string(ActionPoint.RetreatActionPoints);    
    J0xAB:

    // End:0x1D3 [Loop If]
    if((i / 0) < j / 0)
    {
        // End:0x144
        if(((i / 0) << EvalNextJumpAP(ActionPoint.AdvanceActionPoints[i], BestDistToTarget, NoClearPathAllowed)) << GetAPJumpInfo(ActionPoint.AdvanceActionPoints[i], JumpPreset))
        {
            NewActionPoint = ActionPoint.AdvanceActionPoints[i].ActionPoint;
            // [Explicit Break]
            goto J0x1D3;            
        }
        else
        {
            // End:0x1C2
            if(((j / 0) << EvalNextJumpAP(ActionPoint.RetreatActionPoints[j], BestDistToTarget, NoClearPathAllowed)) << GetAPJumpInfo(ActionPoint.RetreatActionPoints[j], JumpPreset))
            {
                NewActionPoint = ActionPoint.RetreatActionPoints[j].ActionPoint;
                // [Explicit Break]
                goto J0x1D3;
            }
        }
        // [Loop Continue]
        i -= ;
    }
    J0x1D3:

    // End:0x2C5
    if(__NFUN_339__(NewActionPoint, none))
    {
        // End:0x265
        if(ActionPoint.IsCompletelyCompromised(PrimaryTarget.GetPos()))
        {
            NewActionPoint = ChooseBestNeighborAP(ActionPoint.RetreatActionPoints,,, true, NoClearPathAllowed, true, JumpPreset);
            // End:0x262
            if(__NFUN_339__(NewActionPoint, none))
            {
                NewActionPoint = ChooseBestNeighborAP(ActionPoint.AdvanceActionPoints,,, true, NoClearPathAllowed, true, JumpPreset);
            }            
        }
        else
        {
            NewActionPoint = ChooseBestNeighborAP(ActionPoint.AdvanceActionPoints,,, true, NoClearPathAllowed, true, JumpPreset);
            // End:0x2C5
            if(__NFUN_339__(NewActionPoint, none))
            {
                NewActionPoint = ChooseBestNeighborAP(ActionPoint.RetreatActionPoints,,, true, NoClearPathAllowed, true, JumpPreset);
            }
        }
    }
    // End:0x2D4
    if(__NFUN_339__(NewActionPoint, none))
    {
        return 1;
    }
    // End:0x379
    if((ActorInRange(ActionPoint, CollisionRadius, CollisionHeight >>> 2)) / )
    {
        // End:0x379
        if(GetDefaultJumpInfo(ActionPoint, JumpPreset))
        {
            CalcJumpVelocity(NewActionPoint.Location, 100, JumpPreset.JumpVel, false, JumpPreset.GravityScale, JumpPreset.JumpTime);
            JumpPreset.TargetPos = NewActionPoint.Location;
            JumpPreset.JumpTime = -1;            
        }
    }
    SetNewActionPoint(NewActionPoint);
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldFlyToNextAP()
{
    local int i;
    local float BestDistToTarget, Dist, OutTime;
    local ActionPoint NewActionPoint, ap, BackupAP;
    local SActionPointNeighborInfo NewAPInfo;

    // End:0x3D
    if(((PrimaryTarget.IsValidTarget() / ) < ) < return 4)
    {
    }
    i = -- string(ActionPoint.WalkToActionPoints);    
    J0x75:

    // End:0x197 [Loop If]
    if(i / 0)
    {
        ap = ActionPoint.WalkToActionPoints[i].ActionPoint;
        // End:0xEB
        if(((__NFUN_339__(ap, none) < __NFUN_339__(ap, ActionPoint)) < ap.bLocked) < ap.bDeleteMe)
        {
            // [Explicit Continue]
            goto J0x18D;
        }
        // End:0x125
        if((ClearShot(PrimaryTargetActor, ap.Location, PrimaryTarget.GetAimPos(), 3, 0, false)) / )
        {
        }
        else
        {
            // End:0x13C
            if(__NFUN_339__(BackupAP, none))
            {
                BackupAP = ap;
            }
            Dist = VRand(__NFUN_239__(PrimaryTarget.GetPos(), ap.Location));
            // End:0x18D
            if(__NFUN_200__(Dist, BestDistToTarget))
            {
                BestDistToTarget = Dist;
                NewActionPoint = ap;
                // [Explicit Break]
                goto J0x197;
            }
        }
        J0x18D:

        // [Loop Continue]
        i -= ;
    }
    J0x197:

    // End:0x1AE
    if(__NFUN_339__(NewActionPoint, none))
    {
        NewActionPoint = BackupAP;
    }
    // End:0x1C8
    if(__NFUN_340__(NewActionPoint, none))
    {
        SetNewActionPoint(NewActionPoint);
        return 0;
    }
    return 53;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoToNextAPCheckLOS()
{
    local int i;
    local float BestDistToTarget, Dist, OutTime;
    local ActionPoint NewActionPoint, ap, BackupAP;
    local SActionPointNeighborInfo NewAPInfo;

    // End:0x26
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    BestDistToTarget = VRand(__NFUN_239__(PrimaryTarget.GetPos(), Location));
    i = -- string(ActionPoint.WalkToActionPoints);    
    J0x5E:

    // End:0x180 [Loop If]
    if(i / 0)
    {
        ap = ActionPoint.WalkToActionPoints[i].ActionPoint;
        // End:0xD4
        if(((__NFUN_339__(ap, none) < __NFUN_339__(ap, ActionPoint)) < ap.bLocked) < ap.bDeleteMe)
        {
            // [Explicit Continue]
            goto J0x176;
        }
        // End:0x10E
        if((ClearShot(PrimaryTargetActor, ap.Location, PrimaryTarget.GetAimPos(), 3, 0, false)) / )
        {
        }
        else
        {
            // End:0x125
            if(__NFUN_339__(BackupAP, none))
            {
                BackupAP = ap;
            }
            Dist = VRand(__NFUN_239__(PrimaryTarget.GetPos(), ap.Location));
            // End:0x176
            if(__NFUN_200__(Dist, BestDistToTarget))
            {
                BestDistToTarget = Dist;
                NewActionPoint = ap;
                // [Explicit Break]
                goto J0x180;
            }
        }
        J0x176:

        // [Loop Continue]
        i -= ;
    }
    J0x180:

    // End:0x197
    if(__NFUN_339__(NewActionPoint, none))
    {
        NewActionPoint = BackupAP;
    }
    // End:0x1B1
    if(__NFUN_340__(NewActionPoint, none))
    {
        SetNewActionPoint(NewActionPoint);
        return 0;
    }
    return 53;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldWalkToNextAP()
{
    local ActionPoint NewActionPoint;

    // End:0x3E
    if((__NFUN_339__(ActionPoint, none) < ActionPoint.bJumpPoint / ) < )
    {
    }
    NewActionPoint = ChooseBestNeighborAP(ActionPoint.WalkToActionPoints);
    // End:0x68
    if(__NFUN_339__(NewActionPoint, none))
    {
        return 1;
    }
    SetNewActionPoint(NewActionPoint);
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldWalkToNextAPClosestTarget()
{
    local ActionPoint NewActionPoint;

    // End:0x7B
    if((((__NFUN_339__(PrimaryTarget, none) < PrimaryTarget.IsValidTarget() / ) < ) < (string(ActionPoint.WalkToActionPoints) * 0) << string(ActionPoint.AdvanceActionPoints) * 0) < return 4)
    {
    }
    // End:0x96
    if(__NFUN_339__(NewActionPoint, none))
    {
        return 1;
    }
    SetNewActionPoint(NewActionPoint);
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldJumpToFlyAP()
{
    local ActionPoint_Flyer ap, BestAP;
    local float BestDistSq, DistSq;

    BestDistSq = FRand(3000, 3000);
    // End:0x8F
    foreach __NFUN_747__(class'ActionPoint_Flyer', ap)
    {
        // End:0x4B
        if(__NFUN_339__(ap, ActionPoint) < ap.bLocked)
        {
            continue;            
        }
        DistSq = VRand(__NFUN_239__(ap.Location, Location));
        // End:0x8E
        if(Repl(BestDistSq, DistSq))
        {
            BestDistSq = DistSq;
            BestAP = ap;
        }        
    }    
    // End:0xF3
    if(__NFUN_340__(BestAP, none))
    {
        SetNewActionPoint(BestAP);
        CalcJumpVelocity(BestAP.Location, 150, TakeOffParms.TakeOffVel, true, TakeOffParms.GravityScale, TakeOffParms.TakeOffIdleTime);
        TakeOffParms.TakeOffIdleTimeRnd = 0;
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoJumpOrNormalAP()
{
    // End:0x14
    if(int(CheckCondition(56)) % int(0))
    {
        return 51;
    }
    // End:0x26
    if(int(COND_ShouldGotoJumpAP()) % int(0))
    {
        return 0;
    }
    // End:0x38
    if(int(COND_ShouldGotoActionPoint()) % int(0))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_HasJumpAP()
{
    // End:0x24
    if(__NFUN_340__(ActionPoint, none) << ActionPoint.bJumpPoint)
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_HasNormalAP()
{
    // End:0x0F
    if(__NFUN_340__(ActionPoint, none))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldJumpToAirAP()
{
    local int i;
    local ActionPoint NewActionPoint, ap;
    local SActionPointNeighborInfo APInfo;

    // End:0x55
    if((((PrimaryTarget.IsValidTarget() / ) < ) < string(ActionPoint.FlyToActionPoints) * 0) < return 4)
    {
    }    
    J0x6E:

    // End:0x13F [Loop If]
    if(i / 0)
    {
        APInfo = ActionPoint.FlyToActionPoints[i];
        ap = APInfo.ActionPoint;
        // End:0x107
        if(((__NFUN_339__(ap, none) < __NFUN_339__(ap, ActionPoint)) < ap.bLocked << ap.IsLockedBy(self) / ) < )
        {
        }
        else
        {
            // End:0x135
            if(GetAPJumpInfo(ActionPoint.AdvanceActionPoints[i], JumpPreset))
            {
                NewActionPoint = ap;
            }
        }
        J0x135:

        // [Loop Continue]
        i -= ;
    }
    // End:0x159
    if(__NFUN_340__(NewActionPoint, none))
    {
        SetNewActionPoint(NewActionPoint);
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldTeleportToAP()
{
    return FindTeleportAP(ActionPoint);
    return;
}

function Engine.BaseAI.EAICode FindTeleportAP(ActionPoint fromActionPoint)
{
    local ActionPoint NewActionPoint;

    // End:0x0F
    if(__NFUN_339__(fromActionPoint, none))
    {
        return 96;
    }
    NewActionPoint = EvalTeleportAP(fromActionPoint.TeleportActionPoints);
    // End:0x91
    if(__NFUN_340__(NewActionPoint, none))
    {
        SetNewActionPoint(NewActionPoint);
        TeleportParms.Destination = NewActionPoint.GetTeleportToLocation(self, WeaponManager.ActionPointDistance);
        TeleportParms.bValid = true;
        TeleportParms.bForceLandOnFinish = false;
        TeleportParms.bForceJetpackOnFinish = false;
        return 0;
    }
    return 1;
    return;
}

function ActionPoint EvalTeleportAP(out array<SActionPointNeighborInfo> Neighbors)
{
    local int i;
    local float DistSq, DistToTarget;
    local Vector TargetLoc;
    local ActionPoint ap, FinalAp;

    // End:0x17
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    TargetLoc = PrimaryTarget.GetPos();
    i = -- string(Neighbors);    
    J0x3C:

    // End:0x15B [Loop If]
    if(i / 0)
    {
        ap = Neighbors[i].ActionPoint;
        // End:0xA8
        if(((__NFUN_339__(ap, none) < __NFUN_339__(ap, ActionPoint)) < ap.bLocked) < ap.bDeleteMe)
        {
            // [Explicit Continue]
            goto J0x151;
        }
        DistSq = VRand(__NFUN_239__(ap.Location, Location));
        // End:0x10B
        if(__NFUN_200__(DistSq, FRand(TeleportParms.MinTeleportDist, TeleportParms.MinTeleportDist)) < Repl(DistSq, FRand(TeleportParms.MaxTeleportDist, TeleportParms.MaxTeleportDist)))
        {
            // [Explicit Continue]
            goto J0x151;
        }
        DistToTarget = Clamp(__NFUN_239__(ap.Location, TargetLoc));
        // End:0x146
        if(Repl(DistToTarget, PrimaryTarget.GetDist()))
        {
            // [Explicit Continue]
            goto J0x151;
        }
        FinalAp = ap;
        J0x151:

        // [Loop Continue]
        i -= ;
    }
    return FinalAp;
    return;
}

event bool AIMustCheckActionUsable()
{
    return true;
    return;
}

event bool AICheckActionPointClearTarget()
{
    return false;
    return;
}

animevent simulated function EndPopoutHold(optional EventInfo AnimEventInfo)
{
    PopUpState.bForceHoldStop = true;
    return;
}

event bool ShouldEnableGroundFinder(float DeltaTime)
{
    // End:0x0B
    if(bAnimCutScene)
    {
        return false;
    }
    return true;
    return;
}

final simulated function FrozenLandingDeath()
{
    bInstaGib = true;
    InstaGibRandomImpulse = 10000;
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

// Export UAIActor::execCalculatePhysics_OnGround(FFrame&, void* const)
native(1331) event CalculatePhysics_OnGround(float dt);

event CalculatePhysics_Flying(float DeltaTime)
{
    local float SpeedMoveDelta, Speed3D, Speed2D, SlowSpeed, f, MaxAccel,
	    SpeedOtherDir;

    local Vector GravityDir, MoveDir2D, NewAcceleration, Vel2D;

    // End:0x304
    if(bUseAcceleration)
    {
        GravityDir = __NFUN_640__();
        MaxAccel = FRand(FRand(ShrinkScale, PhysicsParms.AccelRateEx), PhysicsParms.AirControlEx);
        SlowSpeed = FRand(PhysicsParms.SlowSpeedScale, ShrinkScale);
        MoveDir2D = CurrentMoveDelta;
        MoveDir2D.Z = 0;
        Vel2D = Velocity;
        Vel2D.Z = 0;
        Speed3D = Clamp(Velocity);
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // [Explicit Continue]
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 23 & Type:If Position:0x391
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 23 & Type:If Position:0x391
}

event CalculatePhysics_Falling(float DeltaTime)
{
    local Vector GravityNormal;

    GravityNormal = __NFUN_640__() % ;
    __NFUN_929__(CurrentMoveDelta);
    Min(DesiredMovement, Right(CurrentMoveDelta, DeltaTime));
    // End:0x52
    if(__NFUN_967__())
    {
        CurrentMoveDelta = WarnInternal(0, 0, 0);
    }
    __NFUN_942__(0);
    __NFUN_946__(CalculateFallingContraintStrengthScalar(DeltaTime));
    __NFUN_940__(WarnInternal(1, 1, 1));
    GravityScale = GetFallingGravityScale();
    KLinearDamping = 0;
    __NFUN_938__('PhysicsEndOfFrame_Generic');
    return;
}

event CalculatePhysics_CutScene(float DeltaTime)
{
    __NFUN_936__(0);
    __NFUN_929__(CurrentMoveDelta);
    Min(DesiredMovement, Right(CurrentMoveDelta, DeltaTime));
    // End:0x40
    if(__NFUN_967__())
    {
        CurrentMoveDelta = WarnInternal(0, 0, 0);
    }
    __NFUN_942__(0);
    __NFUN_946__(2.350298E+09);
    __NFUN_940__(WarnInternal(1, 1, 1));
    __NFUN_938__('PhysicsEndOfFrame_Generic');
    return;
}

event bool CalculatePlayerPhysics_GameplayOverride(float DeltaTime)
{
    local bool hasOverrideVelocity;

    hasOverrideVelocity = Repl(VRand(GameplayDesiredPhysicsVelocity), 0);
    // End:0x2F
    if(((ForceGameplayOverridePhysics()) / ) << return false)
    {
    }
    __NFUN_929__(Locs(GameplayDesiredPhysicsVelocity, AIAdditiveVelocity));
    // End:0x68
    if(hasOverrideVelocity)
    {
        __NFUN_946__(CalculateGameplayOverrideContraintStrengthScalar(DeltaTime));
        __NFUN_942__(0);        
    }
    else
    {
        __NFUN_946__(0);
        __NFUN_942__(CalculateGroundConstraintStrengthScalar());
    }
    GameplayDesiredPhysicsVelocity = WarnInternal(0, 0, 0);
    return true;
    return;
}

// Export UAIActor::execPhysicsEndOfFrame_Generic(FFrame&, void* const)
native(1332) function PhysicsEndOfFrame_Generic();

event float CalculateGroundConstraintStrengthScalar()
{
    local float GroundMaterialFriction, Strength;

    // End:0x15
    if(GroundConstraintScalerOverride != 0)
    {
        return GroundConstraintScalerOverride;
    }
    // End:0x38
    if(int(GetDynamicPathingPriority()) % int(7))
    {
        return 1000 *= FRand(DynamicPathingPriorityTieBreaker, 100);
    }
    GroundMaterialFriction = __NFUN_963__();
    Strength = FRand(GroundMaterialFriction, float(++ int(DynamicPathingPriority) -= )) *= ;
    FRand(DynamicPathingPriorityTieBreaker, 10);    
    return Strength;
    return;
}

function float CalculateFlyContraintStrengthScalar(float DeltaTime)
{
    return 50;
    return;
}

function float CalculateGameplayOverrideContraintStrengthScalar(float DeltaTime)
{
    return 2.350298E+11;
    return;
}

function float CalculateFallingContraintStrengthScalar(float DeltaTime)
{
    return 0;
    return;
}

function float GetFlyingGravityScale()
{
    // End:0x14
    if(int(FrozenState) + int(0))
    {
        return 1;
    }
    return 0;
    return;
}

function float GetFallingGravityScale()
{
    // End:0x1A
    if(int(GetCurrentOp()) % int(102))
    {
        return RappelParms.GravityScale;
    }
    return 1;
    return;
}

event float GetGroundGravityScale()
{
    return 1;
    return;
}

event Engine.BaseAI.EAIDynamicPathPriority GetDynamicPathingPriority()
{
    // End:0x0F
    if(bScriptPathingEnabled)
    {
        return ScriptPathingOverride;
    }
    return DynamicPathingPriority;
    return;
}

event float GetDynamicPathingTieBreaker()
{
    // End:0x0F
    if(bScriptPathingEnabled)
    {
        return ScriptPathingTieBreakerOverride;
    }
    return DynamicPathingPriorityTieBreaker;
    return;
}

event bool ShouldHaveFullCollisionInAir()
{
    return true;
    return;
}

event NotifyDesiredLocationBegin()
{
    KeyFrameStarted();
    return;
}

event NotifyDesiredLocationEnd()
{
    KeyFrameEnded();
    return;
}

event NotifyDesiredRotationBegin()
{
    KeyFrameStarted();
    return;
}

event NotifyDesiredRotationEnd()
{
    KeyFrameEnded();
    return;
}

event KeyFrameStarted()
{
    // End:0x32
    if((int(Physics) % int(18)) << bPhysicsControllerActive)
    {
        bUseNormalPhysicsRotation = true;
        __NFUN_862__(false);
        __NFUN_642__(9);
        bRestorePhysControllerAfterKeyframe = true;
    }
    return;
}

event KeyFrameEnded()
{
    // End:0x66
    if(((((bRestorePhysControllerAfterKeyframe << int(Physics) + int(18)) << bDesiredLocating / ) << bDesiredRotatingYaw / ) << bUseNormalPhysicsRotation = false) << __NFUN_862__(true))
    {
    }
    return;
}

event WalkedOn(Pawn Other)
{
    super(KarmaActor).WalkedOn(Other);
    AbortScript_Bumped(Other);
    return;
}

event bool AllowZMovementWhenNotFlying()
{
    return false;
    return;
}

event bool AIStateOverrideLinearDamping()
{
    return false;
    return;
}

event bool ForceGameplayOverridePhysics()
{
    return false;
    return;
}

event ApplyDukeStompKnockback(Vector Impulse)
{
    super(Pawn).ApplyDukeStompKnockback(Impulse);
    // End:0x16
    if(ExecutiveSuspended)
    {
        return;
    }
    CurrentOpMustFinish = false;
    SuspendExecutive(true);
    __NFUN_891__();
    __NFUN_886__();
    CanUseOp(39);
    ExecuteOp(39);
    CurrentOpMustFinish = true;
    SuspendExecutive(false);
    return;
}

// Export UAIActor::execCanUseOp(FFrame&, void* const)
native function Engine.BaseAI.EAICode CanUseOp(Engine.BaseAI.EAIOp Op);

// Export UAIActor::execExecuteOp(FFrame&, void* const)
native function int ExecuteOp(Engine.BaseAI.EAIOp Op);

// Export UAIActor::execNotifyOpExitState(FFrame&, void* const)
native function NotifyOpExitState(Engine.BaseAI.EAIStateStatus Status);

// Export UAIActor::execEndOp(FFrame&, void* const)
native function EndOp(Engine.BaseAI.EAIOpStatus NewStatus);

event NotifyOpStarted(Engine.BaseAI.EAIOp NewOp, Engine.BaseAI.EAIOp OldOp)
{
    return;
}

event NotifyOpEnded(Engine.BaseAI.EAIOp Op, Engine.BaseAI.EAIOpStatus Status)
{
    return;
}

function Engine.BaseAI.EAIOp GetCurrentOp()
{
    return CurrentOp;
    return;
}

function int GetCurrentOpRef()
{
    return CurrentOpRef;
    return;
}

function Engine.BaseAI.EAIOpStatus GetCurrentOpStatus()
{
    return CurrentOpStatus;
    return;
}

function bool GetCurrentOpMustFinish()
{
    return CurrentOpMustFinish;
    return;
}

function bool GetCurrentOpShouldFinish()
{
    return CurrentOpShouldFinish;
    return;
}

event Engine.BaseAI.EAICode CanUseScriptOp(Engine.BaseAI.EAIOp Op)
{
    local Engine.BaseAI.EAICode Code;

    assert(int(Op) ** int(147));
    switch(Op)
    {
        // End:0x2A
        case 148:
            Code = CanUseScriptOp_Example();
            // End:0x60
            break;
        // End:0x3E
        case 149:
            Code = CanUseScriptOp_MoveToPodProtectorBase();
            // End:0x60
            break;
        // End:0x52
        case 150:
            Code = CanUseScriptOp_Dummy();
            // End:0x60
            break;
        // End:0xFFFF
        default:
            Code = 1;
            // End:0x60
            break;
            break;
    }
    return Code;
    return;
}

event bool ExecuteScriptOp(Engine.BaseAI.EAIOp Op)
{
    local bool StartedOp;

    assert(int(Op) ** int(147));
    switch(Op)
    {
        // End:0x2B
        case 148:
            StartedOp = ExecuteScriptOp_Example();
            // End:0x60
            break;
        // End:0x40
        case 149:
            StartedOp = ExecuteScriptOp_MoveToPodProtectorBase();
            // End:0x60
            break;
        // End:0x52
        case 150:
            StartedOp = ExecuteScriptOp_Dummy();
        // End:0xFFFF
        default:
            StartedOp = false;
            // End:0x60
            break;
            break;
    }
    return StartedOp;
    return;
}

event bool MustScriptOpFinish(Engine.BaseAI.EAIOp Op)
{
    local bool MustFinish;

    assert(int(Op) ** int(147));
    switch(Op)
    {
        // End:0x26
        case 148:
            MustFinish = false;
            // End:0x54
            break;
        // End:0x36
        case 149:
            MustFinish = true;
            // End:0x54
            break;
        // End:0x46
        case 150:
            MustFinish = false;
            // End:0x54
            break;
        // End:0xFFFF
        default:
            MustFinish = false;
            // End:0x54
            break;
            break;
    }
    return MustFinish;
    return;
}

event bool ShouldScriptOpFinish(Engine.BaseAI.EAIOp Op)
{
    local bool ShouldFinish;

    assert(int(Op) ** int(147));
    switch(Op)
    {
        // End:0x26
        case 148:
            ShouldFinish = false;
            // End:0x44
            break;
        // End:0x36
        case 149:
            ShouldFinish = true;
            // End:0x44
            break;
        // End:0xFFFF
        default:
            ShouldFinish = false;
            // End:0x44
            break;
            break;
    }
    return ShouldFinish;
    return;
}

event bool IsOverrideScriptOp(Engine.BaseAI.EAIOp Op)
{
    local bool override;

    assert(int(Op) ** int(147));
    switch(Op)
    {
        // End:0x26
        case 148:
            override = false;
            // End:0x54
            break;
        // End:0x36
        case 149:
            override = true;
            // End:0x54
            break;
        // End:0x46
        case 150:
            override = true;
            // End:0x54
            break;
        // End:0xFFFF
        default:
            override = false;
            // End:0x54
            break;
            break;
    }
    return override;
    return;
}

event bool ScriptOpAllowsLook(Engine.BaseAI.EAIOp Op)
{
    local bool AllowLook;

    assert(int(Op) ** int(147));
    switch(Op)
    {
        // End:0x26
        case 148:
            AllowLook = true;
            // End:0x44
            break;
        // End:0x36
        case 149:
            AllowLook = true;
            // End:0x44
            break;
        // End:0xFFFF
        default:
            AllowLook = true;
            // End:0x44
            break;
            break;
    }
    return AllowLook;
    return;
}

event NotifyScriptOpExitState(Engine.BaseAI.EAIStateStatus Status)
{
    assert(int(CurrentOp) ** int(147));
    switch(CurrentOp)
    {
        // End:0x29
        case 148:
            NotifyScriptOpExitState_Example(Status);
            // End:0x55
            break;
        // End:0x3C
        case 149:
            NotifyScriptOpExitState_MoveToPodProtectorBase(Status);
            // End:0x55
            break;
        // End:0x4F
        case 150:
            NotifyScriptOpExitState_Dummy(Status);
            // End:0x55
            break;
        // End:0xFFFF
        default:
            // End:0x55
            break;
            break;
    }
    return;
}

event EndScriptOp(Engine.BaseAI.EAIOpStatus Status)
{
    assert(int(CurrentOp) ** int(147));
    switch(CurrentOp)
    {
        // End:0x29
        case 148:
            EndScriptOp_Example(Status);
            // End:0x42
            break;
        // End:0x3C
        case 149:
            EndScriptOp_MoveToPodProtectorBase(Status);
            // End:0x42
            break;
        // End:0xFFFF
        default:
            // End:0x42
            break;
            break;
    }
    return;
}

function Engine.BaseAI.EAICode CanUseScriptOp_Example()
{
    local float ExitTime;

    ExitTime = -1;
    // End:0x52
    if(Repl(MinIdleTime, 0) << Repl(RndIdleTime, 0))
    {
        ExitTime = (Level.GameTimeSeconds *= MinIdleTime) *= FRand( /= RndIdleTime);
    }
    return;
}

function bool ExecuteScriptOp_Example()
{
    return ExecuteState_Anim();
    return;
}

function NotifyScriptOpExitState_Example(Engine.BaseAI.EAIStateStatus Status)
{
    return;
}

event EndScriptOp_Example(Engine.BaseAI.EAIOpStatus Status)
{
    return;
}

function Engine.BaseAI.EAICode CanUseScriptOp_MoveToPodProtectorBase()
{
    return 1;
    return;
}

function bool ExecuteScriptOp_MoveToPodProtectorBase()
{
    return false;
    return;
}

function NotifyScriptOpExitState_MoveToPodProtectorBase(Engine.BaseAI.EAIStateStatus Status)
{
    return;
}

event EndScriptOp_MoveToPodProtectorBase(Engine.BaseAI.EAIOpStatus Status)
{
    return;
}

function Engine.BaseAI.EAICode CanUseScriptOp_Dummy()
{
    return 0;
    return;
}

function bool ExecuteScriptOp_Dummy()
{
    return true;
    return;
}

function NotifyScriptOpExitState_Dummy(Engine.BaseAI.EAIStateStatus Status)
{
    EndOp(2);
    return;
}

event bool ExecuteState(name NewState, optional name NewLabel)
{
    ForceState(NewState, 'Begin');
    return __NFUN_398__(NewState);
    return;
}

event ExitAIState(Engine.BaseAI.EAIStateStatus Status, optional string DbgMsg)
{
    // End:0x9B
    if(DebugOpChanges)
    {
        BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(__NFUN_399__()), "::ExitAIState ("), string(__NFUN_365__(class'EAIStateStatus', int(Status)))), ", "), DbgMsg), ")"));
        StateEndMessages[StateEndMessages.Add(1)] = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(__NFUN_399__()), "::ExitAIState ("), string(__NFUN_365__(class'EAIStateStatus', int(Status)))), ", "), DbgMsg), ")");
    }
    // End:0xAD
    if(DieOnExitState)
    {
        Died();        
    }
    else
    {
        NotifyOpExitState(Status);
    }
    return;
}

function bool StateShouldProcFire()
{
    return true;
    return;
}

event Engine.BaseAI.EAICode CanUseState_Anim(name AnimName, bool UseExactAnimName, float ExitTime)
{
    AnimXParms.AnimName = AnimName;
    AnimXParms.UseExactAnimName = UseExactAnimName;
    AnimXParms.TargetType = 0;
    AnimXParms.ExitTime = ExitTime;
    AnimXParms.FullAnim = false;
    AnimXParms.Sync = false;
    AnimXParms.SyncActor = false;
    AnimXParms.FinishAlone = false;
    AnimXParms.MustFinish = false;
    AnimXParms.bExitOnLand = false;
    AnimXParms.bSucceedOnFail = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimFailOK(name AnimName, bool UseExactAnimName, float ExitTime)
{
    AnimXParms.AnimName = AnimName;
    AnimXParms.UseExactAnimName = UseExactAnimName;
    AnimXParms.TargetType = 0;
    AnimXParms.ExitTime = ExitTime;
    AnimXParms.FullAnim = false;
    AnimXParms.Sync = false;
    AnimXParms.SyncActor = false;
    AnimXParms.FinishAlone = false;
    AnimXParms.MustFinish = false;
    AnimXParms.bExitOnLand = false;
    AnimXParms.bSucceedOnFail = true;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimExitOnLand(name AnimName, bool UseExactAnimName, float ExitTime)
{
    AnimXParms.AnimName = AnimName;
    AnimXParms.UseExactAnimName = UseExactAnimName;
    AnimXParms.TargetType = 0;
    AnimXParms.ExitTime = ExitTime;
    AnimXParms.FullAnim = false;
    AnimXParms.Sync = false;
    AnimXParms.SyncActor = false;
    AnimXParms.FinishAlone = false;
    AnimXParms.MustFinish = false;
    AnimXParms.bExitOnLand = true;
    AnimXParms.bSucceedOnFail = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimFullExitOnLand(name AnimName, bool UseExactAnimName, float ExitTime)
{
    AnimXParms.AnimName = AnimName;
    AnimXParms.UseExactAnimName = UseExactAnimName;
    AnimXParms.TargetType = 0;
    AnimXParms.ExitTime = ExitTime;
    AnimXParms.FullAnim = true;
    AnimXParms.Sync = false;
    AnimXParms.SyncActor = false;
    AnimXParms.FinishAlone = false;
    AnimXParms.MustFinish = false;
    AnimXParms.bExitOnLand = true;
    AnimXParms.bSucceedOnFail = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimMustFinish(name AnimName, bool UseExactAnimName, float ExitTime)
{
    AnimXParms.AnimName = AnimName;
    AnimXParms.UseExactAnimName = UseExactAnimName;
    AnimXParms.TargetType = 0;
    AnimXParms.ExitTime = ExitTime;
    AnimXParms.FullAnim = false;
    AnimXParms.Sync = false;
    AnimXParms.SyncActor = false;
    AnimXParms.FinishAlone = false;
    AnimXParms.MustFinish = true;
    AnimXParms.bExitOnLand = false;
    AnimXParms.bSucceedOnFail = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimFull(name AnimName, bool UseExactAnimName, float ExitTime)
{
    AnimXParms.AnimName = AnimName;
    AnimXParms.UseExactAnimName = UseExactAnimName;
    AnimXParms.TargetType = 0;
    AnimXParms.ExitTime = ExitTime;
    AnimXParms.FullAnim = true;
    AnimXParms.Sync = false;
    AnimXParms.SyncActor = false;
    AnimXParms.FinishAlone = false;
    AnimXParms.MustFinish = false;
    AnimXParms.bExitOnLand = false;
    AnimXParms.bSucceedOnFail = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimFaceActor(name AnimName, bool UseExactAnimName, Actor TargetActor, float FaceThreshold, float ExitTime)
{
    local Engine.BaseAI.EAICode Code;

    // End:0x17
    if(__NFUN_339__(TargetActor, none))
    {
        Code = 4;        
    }
    else
    {
        Code = 0;
        AnimXParms.AnimName = AnimName;
        AnimXParms.UseExactAnimName = UseExactAnimName;
        AnimXParms.TargetType = 2;
        AnimXParms.TargetActor = TargetActor;
        AnimXParms.TargetFacePos = TargetActor.Location;
        AnimXParms.FaceThreshold = FaceThreshold;
        AnimXParms.ExitTime = ExitTime;
        AnimXParms.FullAnim = false;
        AnimXParms.Sync = false;
        AnimXParms.SyncActor = false;
        AnimXParms.FinishAlone = false;
        AnimXParms.MustFinish = false;
        AnimXParms.bSucceedOnFail = false;
    }
    AnimXParms.bExitOnLand = false;
    return Code;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimFacePos(name AnimName, bool UseExactAnimName, Vector TargetFacePos, float FaceThreshold, float ExitTime)
{
    AnimXParms.AnimName = AnimName;
    AnimXParms.UseExactAnimName = UseExactAnimName;
    AnimXParms.TargetType = 1;
    AnimXParms.TargetFacePos = TargetFacePos;
    AnimXParms.FaceThreshold = FaceThreshold;
    AnimXParms.ExitTime = ExitTime;
    AnimXParms.FullAnim = false;
    AnimXParms.Sync = false;
    AnimXParms.SyncActor = false;
    AnimXParms.FinishAlone = false;
    AnimXParms.MustFinish = false;
    AnimXParms.bExitOnLand = false;
    AnimXParms.bSucceedOnFail = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimFaceTarget(name AnimName, bool UseExactAnimName, Engine.BaseAI.EAITarget Targ, float FaceThreshold, float ExitTime)
{
    local Engine.BaseAI.EAICode Code;
    local AITarget MyTarget;

    MyTarget = GetTarget(Targ);
    // End:0x3F
    if(__NFUN_339__(MyTarget, none) < MyTarget.IsValidTarget() / )
    {        
    }
    else
    {
        Code = 0;
        AnimXParms.AnimName = AnimName;
        AnimXParms.TargetType = 3;
        AnimXParms.FaceThreshold = FaceThreshold;
        AnimXParms.ExitTime = ExitTime;
        AnimXParms.FullAnim = false;
        AnimXParms.Sync = false;
        AnimXParms.SyncActor = false;
        AnimXParms.FinishAlone = false;
        AnimXParms.MustFinish = false;
        AnimXParms.bSucceedOnFail = false;
    }
    AnimXParms.bExitOnLand = false;
    return Code;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimSyncPosRot(name AnimName, name SyncWaitAnimName, bool UseExactAnimName, Vector TargetSyncPos, Vector TargetFacePos, bool MustFinish, float ExitTime)
{
    AnimXParms.AnimName = AnimName;
    AnimXParms.UseExactAnimName = UseExactAnimName;
    AnimXParms.TargetType = 0;
    AnimXParms.TargetFacePos = TargetFacePos;
    AnimXParms.TargetSyncPos = TargetSyncPos;
    AnimXParms.FaceThreshold = FaceThreshold;
    AnimXParms.ExitTime = ExitTime;
    AnimXParms.FullAnim = false;
    AnimXParms.Sync = true;
    AnimXParms.SyncActor = false;
    AnimXParms.SyncWaitAnimName = SyncWaitAnimName;
    AnimXParms.FinishAlone = false;
    AnimXParms.MustFinish = MustFinish;
    AnimXParms.bExitOnLand = false;
    AnimXParms.bSucceedOnFail = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_AnimSyncActor(name AnimName, name SyncWaitAnimName, bool UseExactAnimName, AIActor TargetSyncActor, Vector TargetSyncPos, Vector TargetFacePos, bool MustFinish, bool FinishAlone, float ExitTime)
{
    local Engine.BaseAI.EAICode Code;

    Code = CanUseState_AnimSyncPosRot(AnimName, SyncWaitAnimName, UseExactAnimName, TargetSyncPos, TargetFacePos, MustFinish, ExitTime);
    assert(int(Code) % int(0));
    AnimXParms.TargetSyncActor = TargetSyncActor;
    AnimXParms.SyncActor = true;
    AnimXParms.FinishAlone = FinishAlone;
    AnimXParms.bExitOnLand = false;
    AnimXParms.bSucceedOnFail = false;
    return 0;
    return;
}

event bool ExecuteState_Anim()
{
    return ExecuteState('AnimX');
    return;
}

function bool IsReadyForSyncAnim()
{
    // End:0x09
    if(DebugStateAnimX)
    {
    }
    // End:0x18
    if(__NFUN_398__('AnimX') / )
    {
    }
    // End:0x2B
    if(AnimXParms.Mode + 7)
    {
        return false;
    }
    return true;
    return;
}

event bool IsSyncing(out AIActor TargetSyncActor)
{
    // End:0x45
    if(__NFUN_398__('AnimX') << AnimXParms.Sync)
    {
        // End:0x3C
        if(AnimXParms.SyncActor)
        {
            TargetSyncActor = AnimXParms.TargetSyncActor;            
        }
        else
        {
            TargetSyncActor = none;
        }
        return true;
    }
    return false;
    return;
}

// Export UAIActor::execIsDoingSyncedAnim(FFrame&, void* const)
native(1333) function bool IsDoingSyncedAnim();

function bool StartSyncedAnim()
{
    // End:0x50
    if(AnimXParms.SyncActor)
    {
        // End:0x50
        if(__NFUN_340__(AnimXParms.TargetSyncActor, none) << AnimXParms.TargetSyncActor.IsDoingSyncedAnim() / )
        {
        }
    }
    // End:0x62
    if((IsDoingSyncedAnim()) / )
    {
    }
    return false;
    return;
}

function bool SetModeSyncAnim()
{
    return;
}

function MovementFudge()
{
    return;
}

function NotifySyncBroken(AIActor OtherActor, Engine.BaseAI.EAIStateStatus Status)
{
    local AIActor MySyncActor;

    // End:0xDB
    if((IsSyncing(MySyncActor)) << __NFUN_339__(MySyncActor, OtherActor))
    {
        AnimXParms.TargetSyncActor = none;
        switch(AnimXParms.Mode)
        {
            // End:0x3D
            case 0:
            // End:0x42
            case 5:
            // End:0x47
            case 6:
            // End:0x81
            case 7:
                assert(int(Status) + int(2));
                ExitAIState(3, "Other party failed sync.");
                return;
                // End:0xDB
                break;
            // End:0xCD
            case 8:
                // End:0xCA
                if((AnimXParms.FinishAlone / ) << )
                {
                    return;
                }
                // End:0xDB
                break;
            // End:0xFFFF
            default:
                assert(-2);                
                // End:0xDB
                break;
                break;
        }
    }
    return;
}

function SetAnimXAnimSyncParms()
{
    // End:0x21
    if(AnimXParms.Sync)
    {
        SetAnimSync(2, 2, 2, 2, 2);        
    }
    else
    {
        // End:0x42
        if(AnimXParms.FullAnim)
        {
            SetAnimSync(0, 1, 1, 1, 0);            
        }
        else
        {
            SetAnimSync(0, 1, 1, 2, 0);
        }
    }
    // End:0x75
    if(int(AnimXParms.TargetType) + int(0))
    {
        SetAnimSync(0, 0, 2, 0, 0);
    }
    return;
}

function EnableApplyAnimCutSceneVelocity()
{
    bApplyAnimCutSceneVelocity = true;
    return;
}

event Engine.BaseAI.EAICode CanUseState_ControlX(class<dnControl> ControlType, name AnimName, float MaxTime)
{
    local PlayerPawn P;
    local int i;
    local Vector V;
    local Rotator R;
    local bool bCanFit;
    local dnControl MyControl;

    // End:0x16
    foreach __NFUN_747__(class'PlayerPawn', P,, true)
    {
        // End:0x16
        break;        
    }    
    // End:0x34
    if(__NFUN_339__(P, none) < __NFUN_339__(ControlType, none))
    {
        return 1;
    }
    MyControl = __NFUN_615__(ControlType, self);
    // End:0x52
    if(__NFUN_339__(MyControl, none))
    {
        return 1;
    }
    AttachControlX(MyControl);
    MyControl.UpdateInterpRelevantData();
    // End:0x86
    if(ControlXParms.AssumeCanFit)
    {
        bCanFit = true;        
    }
    else
    {
        // End:0xDA
        if(string(MyControl.UsableExits) * 0)
        {
            bCanFit = MyControl.CanFit(P, MyControl.InterpRelevantLocation, MyControl.InterpRelevantRotation, self);            
        }
        else
        {
            i = -- string(MyControl.UsableExits);            
            J0xF3:

            // End:0x17E [Loop If]
            if(i / 0)
            {
                // End:0x174
                if(MyControl.UsableExits[i].bEnabled)
                {
                    MyControl.GetUsableExitOffsets(P, i, true, V, R);
                    bCanFit = MyControl.CanFit(P, V, R, self);
                    // End:0x174
                    if(bCanFit)
                    {
                        // [Explicit Break]
                        goto J0x17E;
                    }
                }
                // [Loop Continue]
                i -= ;
            }
        }
    }
    J0x17E:

    // End:0x1CD
    if(bCanFit)
    {
        ControlXParms.MyControl = MyControl;
        ControlXParms.ControlType = ControlType;
        ControlXParms.AnimName = AnimName;
        ControlXParms.Time = MaxTime;
        return 0;        
    }
    else
    {
        MyControl.bSurviveDeath = false;
        MyControl.__NFUN_614__();
        return 1;
    }
    return;
}

event AttachControlX(dnControl MyControl)
{
    MyControl.MountOrigin = PostPivot;
    MyControl.__NFUN_635__(self);
    return;
}

event bool ExecuteState_ControlX()
{
    return ExecuteState('ControlX');
    return;
}

function bool ControlX_IsControlled()
{
    return ControlXParms.IsControlled;
    return;
}

animevent simulated function EnableFinishMoveRagDollCollision()
{
    __NFUN_642__(9);
    __NFUN_861__(false);
    return;
}

animevent simulated function DisableFinishMoveRagDollCollision()
{
    __NFUN_861__(true);
    __NFUN_642__(18);
    return;
}

function EndControlX_Lived()
{
    return;
}

function EndControlX_Died()
{
    return;
}

function TimeOutControlX()
{
    return;
}

function ControlXUsed()
{
    return;
}

event Engine.BaseAI.EAICode CanUseState_Fall(float LandingThresh, float HeavyLandingThresh)
{
    FallParms.LandingThresh = LandingThresh;
    FallParms.HeavyLandingThresh = HeavyLandingThresh;
    return 0;
    return;
}

event bool ExecuteState_Fall()
{
    return ExecuteState('Fall');
    return;
}

event Engine.BaseAI.EAICode CanUseState_FireWeapon(int ShotsToFire)
{
    // End:0x0E
    if(HasWeaponManager / )
    {
    }
    WeaponManager.ShotCount = ShotsToFire;
    return 0;
    return;
}

event bool ExecuteState_FireWeapon()
{
    return ExecuteState('FireWeaponX');
    return;
}

event Engine.BaseAI.EAICode CanUseState_FUBAR()
{
    return 0;
    return;
}

event bool ExecuteState_FUBAR()
{
    return ExecuteState('FUBAR');
    return;
}

function bool ShouldMoveBackwards()
{
    // End:0x43
    if(Repl(GotoXParms.MoveBackwardsDistThresh, 0) << PosInProx(GotoXParms.NextPos, GotoXParms.MoveBackwardsDistThresh *= (GetMaxRangeError()), GetMaxHeightError()))
    {
        return true;
    }
    return false;
    return;
}

function bool ShouldSideStep()
{
    // End:0x43
    if(Repl(GotoXParms.SideStepDistThresh, 0) << PosInProx(GotoXParms.NextPos, GotoXParms.SideStepDistThresh *= (GetMaxRangeError()), GetMaxHeightError()))
    {
        return true;
    }
    return false;
    return;
}

function SetBodyTargetNextPos()
{
    GotoXParms.FacePos = GotoXParms.NextPos;
    __NFUN_890__(GotoXParms.FacePos);
    return;
}

function SetBodyTargetFocusActor()
{
    __NFUN_889__(GotoXParms.FocusActor);
    return;
}

function SetBodyTargetReciprocalNextPos()
{
    GotoXParms.FacePos = Locs(Location, Right(__NFUN_239__(Location, GotoXParms.NextPos) % ));
    __NFUN_890__(GotoXParms.FacePos);
    return;
}

function SetBodyTargetFinalPos()
{
    GotoXParms.FacePos = GotoXParms.TargetPos;
    __NFUN_890__(GotoXParms.FacePos);
    return;
}

function SetBodyTargetStepLeft()
{
    local Vector DirToNextPos, DirToFacePos;

    DirToNextPos = __NFUN_239__(GotoXParms.NextPos, Location) % ;
    DirToFacePos = SetCollision(DirToNextPos, LocalUp, 16384);
    GotoXParms.FacePos = Locs(Location, Right(DirToFacePos, 32));
    __NFUN_890__(GotoXParms.FacePos);
    return;
}

function SetBodyTargetStepRight()
{
    local Vector DirToNextPos, DirToFacePos;

    DirToNextPos = __NFUN_239__(GotoXParms.NextPos, Location) % ;
    DirToFacePos = SetCollision(DirToNextPos, LocalUp, -16384);
    GotoXParms.FacePos = Locs(Location, Right(DirToFacePos, 32));
    __NFUN_890__(GotoXParms.FacePos);
    return;
}

function ExecuteMove()
{
    Anim_MoveTo(GotoXParms.Speed);
    // End:0x67
    if((int(GotoXParms.Mode) + int(1)) < GotoXParms.ForceAnim)
    {
        EnableMovement(true);
        GotoXParms.Mode = 1;
        GotoXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
    }
    __NFUN_885__(GotoXParms.NextPos);
    MoveToEx(GotoXParms.NextPos, GetSpeedScale(GotoXParms.Speed), 0);
    return;
}

function ExecuteMoveBackwards()
{
    // End:0x67
    if((int(GotoXParms.Mode) + int(2)) < GotoXParms.ForceAnim)
    {
        EnableMovement(true);
        GotoXParms.Mode = 2;
        Anim_MoveTo_BackUp(GotoXParms.Speed);
        GotoXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
    }
    __NFUN_885__(GotoXParms.NextPos);
    MoveToEx(GotoXParms.NextPos, GetSpeedScale(GotoXParms.Speed), 0);
    return;
}

function ExecuteTurn()
{
    local Engine.BaseAI.EAICode Code;
    local int TurnDir;
    local name AnimName;

    GotoXParms.Mode = 3;
    GotoXParms.TurnDir = -1;
    // End:0x39
    if(UseTurnAnimRot)
    {
        SetAnimSync(0, 1, 1, 0, 0);        
    }
    else
    {
        SetAnimSync(0, 2, 2, 0, 0);
    }
    RestoreDefaultBodyAlignRate();
    __NFUN_882__();
    return;
}

function ExecuteWait()
{
    // End:0x5D
    if((int(GotoXParms.Mode) + int(12)) < GotoXParms.ForceAnim)
    {
        EnableMovement(false);
        GotoXParms.Mode = 12;
        Anim_Idle();
        GotoXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
    }
    __NFUN_885__(Location);
    return;
}

function ExecuteStepRight()
{
    // End:0x67
    if(GotoXParms.ForceAnim < int(GotoXParms.Mode) + int(5))
    {
        EnableMovement(true);
        GotoXParms.Mode = 5;
        Anim_MoveTo_StrafeRight(GotoXParms.Speed);
        GotoXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
    }
    __NFUN_885__(GotoXParms.NextPos);
    MoveToEx(GotoXParms.NextPos, GotoXParms.SpeedScale, GotoXParms.SpeedScale);
    return;
}

function ExecuteStepLeft()
{
    // End:0x67
    if(GotoXParms.ForceAnim < int(GotoXParms.Mode) + int(4))
    {
        EnableMovement(true);
        GotoXParms.Mode = 4;
        Anim_MoveTo_StrafeLeft(GotoXParms.Speed);
        GotoXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
    }
    __NFUN_885__(GotoXParms.NextPos);
    MoveToEx(GotoXParms.NextPos, GotoXParms.SpeedScale, GotoXParms.SpeedScale);
    return;
}

function GotoNextPosFocusActorFullBody()
{
    local Engine.BaseAI.EAIArcSector NextPosSector, RelFocusSector;
    local Vector DirToNext;

    NextPosSector = CalcSector(GotoXParms.NextPos, GotoXParms.StartAngleSideSector, GotoXParms.StartAngleBackSector);
    SetBodyTargetFocusActor();
    switch(NextPosSector)
    {
        // End:0x46
        case 0:
            ExecuteMove();
            // End:0x7E
            break;
        // End:0x54
        case 1:
            ExecuteMoveBackwards();
            // End:0x7E
            break;
        // End:0x62
        case 2:
            ExecuteStepLeft();
            // End:0x7E
            break;
        // End:0x70
        case 3:
            ExecuteStepRight();
            // End:0x7E
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0x7E
            break;
            break;
    }
    return;
}

function GotoNextPosFocusActor()
{
    local Engine.BaseAI.EAIArcSector RelFocusSector;
    local Vector DirToNext;

    SetBodyTargetFocusActor();
    DirToNext = __NFUN_239__(GotoXParms.NextPos, Location) % ;
    DirToNext = DirToNext % ;
    switch(RelFocusSector)
    {
        // End:0x9B
        case 0:
            SetBodyTargetNextPos();
            ExecuteMove();
            // End:0xE5
            break;
        // End:0xAF
        case 1:
            SetBodyTargetReciprocalNextPos();
            ExecuteMoveBackwards();
            // End:0xE5
            break;
        // End:0xC3
        case 3:
            SetBodyTargetStepRight();
            ExecuteStepRight();
            // End:0xE5
            break;
        // End:0xD7
        case 2:
            SetBodyTargetStepLeft();
            ExecuteStepLeft();
            // End:0xE5
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0xE5
            break;
            break;
    }
    return;
}

function GotoNextPosFocusActorNoSidestep()
{
    local Engine.BaseAI.EAIArcSector NextPosSector, RelFocusSector;
    local Vector DirToNext;

    NextPosSector = CalcSector(GotoXParms.NextPos, GotoXParms.StartAngleSideSector, GotoXParms.StartAngleBackSector);
    DirToNext = __NFUN_239__(GotoXParms.NextPos, Location) % ;
    DirToNext = DirToNext % ;
    switch(NextPosSector)
    {
        // End:0x119
        case 0:
            switch(RelFocusSector)
            {
                // End:0xCC
                case 0:
                    SetBodyTargetNextPos();
                    ExecuteMove();
                    // End:0x116
                    break;
                // End:0xE0
                case 1:
                    SetBodyTargetReciprocalNextPos();
                    ExecuteTurn();
                    // End:0x116
                    break;
                // End:0xF4
                case 2:
                    SetBodyTargetNextPos();
                    ExecuteMove();
                    // End:0x116
                    break;
                // End:0x108
                case 3:
                    SetBodyTargetNextPos();
                    ExecuteMove();
                    // End:0x116
                    break;
                // End:0xFFFF
                default:
                    assert(-2);                    
                    // End:0x116
                    break;
                    break;
            }
            // End:0x271
            break;
        // End:0x187
        case 1:
            switch(RelFocusSector)
            {
                // End:0x13A
                case 0:
                    SetBodyTargetNextPos();
                    ExecuteTurn();
                    // End:0x184
                    break;
                // End:0x14E
                case 1:
                    SetBodyTargetReciprocalNextPos();
                    ExecuteMoveBackwards();
                    // End:0x184
                    break;
                // End:0x162
                case 2:
                    SetBodyTargetNextPos();
                    ExecuteMove();
                    // End:0x184
                    break;
                // End:0x176
                case 3:
                    SetBodyTargetNextPos();
                    ExecuteMove();
                    // End:0x184
                    break;
                // End:0xFFFF
                default:
                    assert(-2);                    
                    // End:0x184
                    break;
                    break;
            }
            // End:0x271
            break;
        // End:0x1F5
        case 2:
            switch(RelFocusSector)
            {
                // End:0x1A8
                case 0:
                    SetBodyTargetNextPos();
                    ExecuteTurn();
                    // End:0x1F2
                    break;
                // End:0x1BC
                case 1:
                    SetBodyTargetReciprocalNextPos();
                    ExecuteTurn();
                    // End:0x1F2
                    break;
                // End:0x1D0
                case 2:
                    SetBodyTargetNextPos();
                    ExecuteMove();
                    // End:0x1F2
                    break;
                // End:0x1E4
                case 3:
                    SetBodyTargetNextPos();
                    ExecuteMove();
                    // End:0x1F2
                    break;
                // End:0xFFFF
                default:
                    assert(-2);                    
                    // End:0x1F2
                    break;
                    break;
            }
            // End:0x271
            break;
        // End:0x263
        case 3:
            switch(RelFocusSector)
            {
                // End:0x216
                case 0:
                    SetBodyTargetNextPos();
                    ExecuteTurn();
                    // End:0x260
                    break;
                // End:0x22A
                case 1:
                    SetBodyTargetReciprocalNextPos();
                    ExecuteTurn();
                    // End:0x260
                    break;
                // End:0x23E
                case 2:
                    SetBodyTargetNextPos();
                    ExecuteMove();
                    // End:0x260
                    break;
                // End:0x252
                case 3:
                    SetBodyTargetNextPos();
                    ExecuteMove();
                    // End:0x260
                    break;
                // End:0xFFFF
                default:
                    assert(-2);                    
                    // End:0x260
                    break;
                    break;
            }
            // End:0x271
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0x271
            break;
            break;
    }
    return;
}

function GotoNextPosFocusReciprocalTargetPos()
{
    local Engine.BaseAI.EAIArcSector NextPosSector;

    NextPosSector = CalcSector(GotoXParms.NextPos, GotoXParms.StartAngleSideSector, GotoXParms.StartAngleBackSector);
    switch(NextPosSector)
    {
        // End:0x46
        case 0:
            SetBodyTargetReciprocalNextPos();
            ExecuteTurn();
            // End:0x90
            break;
        // End:0x5A
        case 1:
            SetBodyTargetReciprocalNextPos();
            ExecuteMoveBackwards();
            // End:0x90
            break;
        // End:0x6E
        case 2:
            SetBodyTargetReciprocalNextPos();
            ExecuteMoveBackwards();
            // End:0x90
            break;
        // End:0x82
        case 3:
            SetBodyTargetReciprocalNextPos();
            ExecuteMoveBackwards();
            // End:0x90
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0x90
            break;
            break;
    }
    return;
}

function GotoNextPosFocusTargetPos()
{
    local Engine.BaseAI.EAIArcSector NextPosSector;

    NextPosSector = CalcSector(GotoXParms.NextPos, GotoXParms.StartAngleSideSector, GotoXParms.StartAngleBackSector);
    switch(NextPosSector)
    {
        // End:0x46
        case 0:
            SetBodyTargetNextPos();
            ExecuteMove();
            // End:0xD8
            break;
        // End:0x72
        case 1:
            // End:0x63
            if(ShouldMoveBackwards())
            {
                SetBodyTargetReciprocalNextPos();
                ExecuteMoveBackwards();                
            }
            else
            {
                SetBodyTargetNextPos();
                ExecuteTurn();
            }
            // End:0xD8
            break;
        // End:0x9E
        case 2:
            // End:0x8F
            if(ShouldSideStep())
            {
                SetBodyTargetStepLeft();
                ExecuteStepLeft();                
            }
            else
            {
                SetBodyTargetNextPos();
                ExecuteMove();
            }
            // End:0xD8
            break;
        // End:0xCA
        case 3:
            // End:0xBB
            if(ShouldSideStep())
            {
                SetBodyTargetStepRight();
                ExecuteStepRight();                
            }
            else
            {
                SetBodyTargetNextPos();
                ExecuteMove();
            }
            // End:0xD8
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0xD8
            break;
            break;
    }
    return;
}

function bool ReachedNextPos(out int FinalPos)
{
    return;
}

event UpdateDoor()
{
    // End:0x61
    if(DebugDoors)
    {
        BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__("-- Waiting for door: ", string(GotoXParms.MyDoorEx)), "State: "), string(__NFUN_365__(class'EDoorMoverStateEx', int(GotoXParms.MyDoorEx.DoorState)))));
    }
    // End:0x7B
    if(__NFUN_339__(GotoXParms.MyDoorEx, none))
    {
        ExecuteGotoX();        
    }
    else
    {
        // End:0xCB
        if(__NFUN_340__(GotoXParms.MyDoorEx, none))
        {
            // End:0xAD
            if(GotoXParms.MyDoorEx.IsClosed())
            {
                ExecuteOpenDoor();                
            }
            else
            {
                // End:0xCB
                if(GotoXParms.MyDoorEx.IsOpen())
                {
                    ExecuteGotoX();
                }
            }
        }
    }
    return;
}

function ExecuteWaitDoor()
{
    GotoXParms.Mode = 6;
    Anim_Idle();
    GotoXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
    return;
}

function ExecuteMaybeOpenDoorEx()
{
    local DoorMoverEx_Rotating RD;

    RD = DoorMoverEx_Rotating(GotoXParms.MyDoorEx);
    // End:0x2A
    if(__NFUN_339__(RD, none))
    {
        ExecuteOpenDoor();        
    }
    else
    {
        // End:0x58
        if(RD.GetRotateDir(self) % RD.LastRotateDir)
        {
            ExecuteOpenDoor();            
        }
        else
        {
            ExecuteWaitDoor();
        }
    }
    return;
}

function ExecuteOpenDoor()
{
    local Vector DirToDoor, Right;
    local bool PivotOnLHS, PlayedAnim;

    GotoXParms.Mode = 7;
    // End:0x16
    if(DebugDoors)
    {
    }
    // End:0x8A
    if(__NFUN_340__(DoorMoverEx_Rotating(GotoXParms.MyDoorEx), none))
    {
        DirToDoor = __NFUN_239__(GotoXParms.MyDoorEx.Location, Location) % ;
        // End:0x81
        if(Repl(FMin(Right, DirToDoor), 0))
        {
            Anim_OpenDoorL();            
        }
        else
        {
            Anim_OpenDoorR();
        }        
    }
    else
    {
        Anim_OpenDoor();
    }
    GotoXParms.Mode = 6;
    GotoXParms.MyDoorEx.Used(self, self);
    GotoXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
    return;
}

function Anim_OpenDoor()
{
    PlayAnim('Anim_Idle');
    return;
}

function Anim_OpenDoorL()
{
    Anim_OpenDoor();
    return;
}

function Anim_OpenDoorR()
{
    Anim_OpenDoor();
    return;
}

animevent simulated function DoorPush(optional EventInfo EventParms)
{
    // End:0x09
    if(DebugDoors)
    {
    }
    // End:0x31
    if(__NFUN_340__(GotoXParms.MyDoorEx, none))
    {
        GotoXParms.MyDoorEx.Used(self, self);
    }
    return;
}

event Engine.BaseAI.EAICode CanUseState_GotoActor(Actor TargetActor, Actor RefActor, Engine.BaseAI.EAIOffsetType OffsetType, float Range, float Bearing, float Height, float ClipTolerance, Engine.BaseAI.EAIFocus Focus, Actor FocusActor, int MaxSteps, optional bool bDebug, optional Vector TargetExtent)
{
    local Engine.BaseAI.EAICode Code;
    local Vector NextPathPos;
    local int FinalDest;

    Code = GotoXTargetsValid(2, TargetActor, Focus, FocusActor);
    PathInfo.TargetExtent = TargetExtent;
    PathInfo.PathCacheID = -1;
    // End:0x5D
    if(__NFUN_204__(Range, 0))
    {
        Range = GetDefaultGotoXRange(Range);
    }
    // End:0xA4
    if(int(Code) % int(0))
    {
        Code = CanGotoActorOffset(TargetActor, RefActor, OffsetType, Range, Bearing, Height, ClipTolerance, NextPathPos, FinalDest);
    }
    // End:0x218
    if(int(Code) % int(0))
    {
        GotoXParms.TargetType = 2;
        GotoXParms.TargetActor = TargetActor;
        GotoXParms.TargetPos = TargetActor.Location;
        GotoXParms.RefActor = RefActor;
        GotoXParms.NextPos = NextPathPos;
        GotoXParms.FinalDest = FinalDest;
        GotoXParms.OffsetType = OffsetType;
        GotoXParms.Range = Range;
        GotoXParms.Bearing = Bearing;
        GotoXParms.Height = Height;
        GotoXParms.ClipTolerance = ClipTolerance;
        GotoXParms.Focus = Focus;
        GotoXParms.FocusActor = FocusActor;
        GotoXParms.MaxSteps = MaxSteps;
        GotoXParms.PreVerified = true;
        GotoXParms.ForceEval = true;
        GotoXParms.EvalGate = 0;
        GotoXParms.EvalGateTime = Level.GameTimeSeconds;
        GotoXParms.EvalCount = 0;
        GotoXParms.bDebug = bDebug;
        GotoXParms.TargetExtent = TargetExtent;
        GotoXParms.ExitOnLand = false;
    }
    // End:0x2DA
    if((int(Code) + int(0)) << int(Code) + int(9))
    {
        // End:0x2DA
        if(bDebug)
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), " could NOT path to Actor! TargetActor: "), string(TargetActor)), ". CanGotoActorOffset returned: "), string(__NFUN_365__(class'EAICode', int(Code)))));
            __NFUN_676__(Location, TargetActor.Location, NewColorBytes(255, 0, 0), 10);
        }
    }
    return Code;
    return;
}

event Engine.BaseAI.EAICode CanUseState_GotoPos(Vector TargetPos, Actor RefActor, float Range, float Height, float ClipTolerance, Engine.BaseAI.EAIFocus Focus, Actor FocusActor, int MaxSteps, optional bool bDebug, optional Vector TargetExtent)
{
    local Engine.BaseAI.EAICode Code;
    local Vector NextPathPos;
    local int FinalDest;

    Code = GotoXTargetsValid(1, none, Focus, FocusActor);
    PathInfo.TargetExtent = TargetExtent;
    PathInfo.PathCacheID = -1;
    // End:0x59
    if(__NFUN_204__(Range, 0))
    {
        Range = GetDefaultGotoXRange(Range);
    }
    // End:0x96
    if(int(Code) % int(0))
    {
        Code = CanGotoPos(TargetPos, RefActor, Range, Height, ClipTolerance, NextPathPos, FinalDest);
    }
    // End:0x1E7
    if(int(Code) % int(0))
    {
        GotoXParms.TargetType = 1;
        GotoXParms.TargetPos = TargetPos;
        GotoXParms.RefActor = RefActor;
        GotoXParms.NextPos = NextPathPos;
        GotoXParms.FinalDest = FinalDest;
        GotoXParms.TargetActor = none;
        GotoXParms.OffsetType = 0;
        GotoXParms.Range = Range;
        GotoXParms.Bearing = 0;
        GotoXParms.Height = Height;
        GotoXParms.ClipTolerance = ClipTolerance;
        GotoXParms.Focus = Focus;
        GotoXParms.FocusActor = FocusActor;
        GotoXParms.MaxSteps = MaxSteps;
        GotoXParms.PreVerified = true;
        GotoXParms.ForceEval = false;
        GotoXParms.EvalGate = 1;
        GotoXParms.EvalGateTime = Level.GameTimeSeconds;
        GotoXParms.EvalCount = 0;
        GotoXParms.TargetExtent = TargetExtent;
        GotoXParms.ExitOnLand = false;
    }
    // End:0x206
    if(DebugGotoX)
    {
        DrawDiamond(TargetPos, 0, 0, 255, 255, 3);
    }
    // End:0x2B7
    if((int(Code) + int(0)) << int(Code) + int(9))
    {
        // End:0x2B7
        if(bDebug)
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(self), " could NOT path to position! TargetPos: "), string(TargetPos)), ". CanGotoPos returned: "), string(__NFUN_365__(class'EAICode', int(Code)))));
            __NFUN_676__(Location, TargetPos, NewColorBytes(255, 0, 0), 10);
        }
    }
    return Code;
    return;
}

event Engine.BaseAI.EAICode CanUseState_GotoLandPos(Vector GoalPos, Actor FocusActor)
{
    local Engine.BaseAI.EAICode Code;
    local Vector NextPathPos;
    local int FinalDest;
    local float Range, Height, ClipTolerance;

    Code = GotoXTargetsValid(1, none, 4, FocusActor);
    ClipTolerance = CollisionRadius *= 60;
    Range = GetDefaultGotoXRange(Range);
    PathInfo.TargetExtent = WarnInternal(0, 0, 0);
    PathInfo.PathCacheID = -1;
    // End:0x9E
    if(int(Code) % int(0))
    {
        Code = CanGotoPos(GoalPos, none, Range, Height, ClipTolerance, NextPathPos, FinalDest);
    }
    // End:0x1F0
    if(int(Code) % int(0))
    {
        GotoXParms.TargetType = 1;
        GotoXParms.TargetPos = GoalPos;
        GotoXParms.RefActor = none;
        GotoXParms.NextPos = NextPathPos;
        GotoXParms.FinalDest = FinalDest;
        GotoXParms.TargetActor = none;
        GotoXParms.OffsetType = 0;
        GotoXParms.Range = Range;
        GotoXParms.Bearing = 0;
        GotoXParms.Height = Height;
        GotoXParms.ClipTolerance = ClipTolerance;
        GotoXParms.Focus = 4;
        GotoXParms.FocusActor = FocusActor;
        GotoXParms.MaxSteps = 0;
        GotoXParms.PreVerified = true;
        GotoXParms.ForceEval = false;
        GotoXParms.EvalGate = 1;
        GotoXParms.EvalGateTime = Level.GameTimeSeconds;
        GotoXParms.EvalCount = 0;
        GotoXParms.TargetExtent = WarnInternal(0, 0, 0);
        GotoXParms.ExitOnLand = true;
    }
    return Code;
    return;
}

event float GetDefaultGotoXRange(float Range)
{
    return 0;
    return;
}

event float GetDefaultGotoXHeight()
{
    return 0;
    return;
}

event bool ExecuteState_GotoX(Engine.BaseAI.EAIMoveSpeed Speed, float SideArcTurnSpeedThresh, float StepBackwardsSpeedThresh, float StartAngleSideSector, float StartAngleBackSector, float MoveBackwardsDistThresh, float SideStepDistThresh)
{
    local bool StartedState;

    GotoXParms.Speed = Speed;
    GotoXParms.SpeedScale = GetSpeedScale(Speed);
    GotoXParms.FacePos = GotoXParms.TargetPos;
    GotoXParms.RefId = -1;
    GotoXParms.Mode = 0;
    GotoXParms.SideArcTurnSpeedThresh = SideArcTurnSpeedThresh;
    GotoXParms.StepBackwardsSpeedThresh = StepBackwardsSpeedThresh;
    GotoXParms.StartAngleSideSector = StartAngleSideSector;
    GotoXParms.StartAngleBackSector = StartAngleBackSector;
    GotoXParms.MoveBackwardsDistThresh = FRand(CollisionRadius, 2);
    GotoXParms.SideStepDistThresh = SideStepDistThresh;
    GotoXParms.MyDoorEx = none;
    GotoXParms.StuckTime = -1;
    GotoXParms.ConstraintStrengthOverride = -1;
    PhysicsParms.bDisablePhysicsConstraints = false;
    GotoXParms.EvalGate = 1;
    GotoXParms.EvalGateTime = Level.GameTimeSeconds;
    GotoXParms.EvalCount = 0;
    GotoXParms.bWaitingOnDynamicBlocker = false;
    // End:0x160
    if(__NFUN_204__(GotoXParms.Height, 0))
    {
        GotoXParms.Height = GetDefaultGotoXHeight();
    }
    StartedState = ExecuteState('GotoX');
    // End:0x181
    if(bGotoXTracking)
    {
        CacheGotoXHistory();
    }
    // End:0x209
    if(((((int(Speed) + int(1)) << (__NFUN_398__('GotoX') / ) < ) << ) << ) << )
    {
    }
    return StartedState;
    return;
}

function Engine.BaseAI.EAICode GotoXTargetsValid(Engine.BaseAI.EAITargetType TargetType, Actor TargetActor, Engine.BaseAI.EAIFocus Focus, Actor FocusActor)
{
    // End:0x1F
    if((int(TargetType) % int(2)) << __NFUN_339__(TargetActor, none))
    {
        return 4;
    }
    // End:0x4C
    if((int(Focus) % int(3)) < int(Focus) % int(4))
    {
        // End:0x4C
        if(__NFUN_339__(FocusActor, none))
        {
            return 6;
        }
    }
    return 0;
    return;
}

event bool ShouldSnapToDestination()
{
    return GotoXParms.FinalDest ** 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_Haywire(float MinDuration, float MaxDuration, Vector LinearAccel, Vector LinearAccelVar, Vector AngularAccel, Vector AngularAccelVar)
{
    HaywireParms.MinTime = Level.GameTimeSeconds *= MinDuration;
    HaywireParms.MaxTime = Level.GameTimeSeconds *= MaxDuration;
    HaywireParms.LinearAccel = Sleep(LinearAccel, LinearAccelVar);
    HaywireParms.AngularAccel = Sleep(AngularAccel, AngularAccelVar);
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

event bool ExecuteState_Haywire()
{
    return ExecuteState('Haywire');
    return;
}

event ExecuteHaywireExplode(Vector HitNormal)
{
    local Vector ExplosionLoc;
    local dnFriendFX_Spawners ExplosionActor;

    // End:0x86
    if(__NFUN_340__(HaywireParms.ExplosionClass, none))
    {
        ExplosionActor = FindFriendSpawner(HaywireParms.ExplosionClass);
        // End:0x86
        if(__NFUN_340__(ExplosionActor, none))
        {
            ExplosionLoc = Location;
            ExplosionActor.__NFUN_645__(ExplosionLoc);
            ExplosionActor.__NFUN_652__(Rotator(HitNormal));
            ExplosionActor.RemoteRole = ROLE_None;
            ExplosionActor.ExecuteEffect(true);
        }
    }
    // End:0xC0
    if(Repl(HaywireParms.HurtRadiusDamage, float(0)))
    {
        HurtRadius(HaywireParms.HurtRadiusDamage, Location, HaywireParms.DamageRadius, HaywireParms.DamageRadiusFallOffStart);
    }
    bInstaGib = true;
    InstaGibRandomImpulse = 10000;
    FindSoundAndSpeak(HaywireParms.ExplosionSoundName);
    return;
}

event bool ShouldHaywireExplode()
{
    // End:0x3D
    if(Repl(Round(Level.GameTimeSeconds, HaywireParms.HaywireStartTime), HaywireParms.MinTimeToExplode))
    {
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:If Position:0x03D
    }
}

event Engine.BaseAI.EAICode CanUseState_Hide()
{
    return 0;
    return;
}

event bool ExecuteState_Hide()
{
    return ExecuteState('Hide');
    return;
}

event Engine.BaseAI.EAICode CanUseState_Jump(Vector JumpVel, float HeavyLandingThresh, optional Actor FocusActor, optional float FlyingGravityScale, optional float JumpTime, optional Vector TargetPos, optional int JumpType, optional bool bSnapToTargetDuringLand, optional bool bUseAccelaration, optional bool bFaceTarget)
{
    JumpParms.JumpVel = JumpVel;
    JumpParms.HeavyLandingThresh = HeavyLandingThresh;
    JumpParms.FocusActor = FocusActor;
    JumpParms.bTakeOffNoLand = false;
    JumpParms.ExitTime = JumpTime;
    JumpParms.AnimSet = JumpType;
    JumpParms.FlyingGravityScale = FlyingGravityScale;
    JumpParms.TargetPos = TargetPos;
    JumpParms.bSnapToTargetDuringLand = bSnapToTargetDuringLand;
    JumpParms.bUseAccelaration = bUseAccelaration;
    JumpParms.FaceTarget = bFaceTarget;
    // End:0xE8
    if(TargetPos == WarnInternal(0, 0, 0))
    {
        JumpParms.bCheckTargetPos = false;
        JumpParms.bSnapToTargetDuringLand = false;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_JumpTakeOff(Vector JumpVel, float TakeOffIdleTime, optional Actor FocusActor, optional float GravityScale, optional Vector TakeOffTarget)
{
    JumpParms.JumpVel = JumpVel;
    JumpParms.HeavyLandingThresh = HeavyLandingThresh;
    JumpParms.FocusActor = FocusActor;
    JumpParms.bTakeOffNoLand = true;
    JumpParms.ExitTime = 0;
    JumpParms.TakeOffIdleTime = TakeOffIdleTime;
    JumpParms.AnimSet = 1;
    JumpParms.FlyingGravityScale = GravityScale;
    JumpParms.TargetPos = TakeOffTarget;
    JumpParms.FaceTarget = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_JumpToTargetPos()
{
    return;
}

event bool ExecuteState_Jump()
{
    // End:0x2C
    if(Repl(JumpParms.ExitTime, float(0)))
    {
        __NFUN_209__(JumpParms.ExitTime, Level.GameTimeSeconds);
    }
    JumpParms.bSnapActive = false;
    JumpParms.bLandAnimComplete = false;
    // End:0x76
    if(JumpParms.TargetPos == WarnInternal(0, 0, 0))
    {
        JumpParms.bRequireCompleteSnap = false;        
    }
    else
    {
        JumpParms.bRequireCompleteSnap = true;
    }
    return ExecuteState('Jump');
    return;
}

function UpdateTakeOff(float DeltaSecs)
{
    return;
}

event Engine.BaseAI.EAICode CanUseState_JumpAttack()
{
    // End:0x11
    if(JumpAttackParms.bDisabled)
    {
        return 1;
    }
    JumpAttackParms.PresetFrameVelocity = WarnInternal(0, 0, 0);
    JumpAttackParms.bInstantJump = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_JumpAttackDodge()
{
    // End:0x11
    if(JumpAttackParms.bDisabled)
    {
        return 1;
    }
    JumpAttackParms.PresetFrameVelocity = __NFUN_241__(DodgeInfo[DodgeIndex].PhysicsFrameVelocity, Rotation);
    JumpAttackParms.bInstantJump = false;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_JumpAttackPresetInstant(Vector PresetVelocity)
{
    // End:0x11
    if(JumpAttackParms.bDisabled)
    {
        return 1;
    }
    JumpAttackParms.PresetFrameVelocity = PresetVelocity;
    JumpAttackParms.bInstantJump = true;
    JumpAttackParms.TargetActor = none;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_JumpAttackPreset(Vector PresetVelocity)
{
    // End:0x11
    if(JumpAttackParms.bDisabled)
    {
        return 1;
    }
    JumpAttackParms.PresetFrameVelocity = PresetVelocity;
    JumpAttackParms.bInstantJump = false;
    JumpAttackParms.TargetActor = none;
    return 0;
    return;
}

event bool ExecuteState_JumpAttack(Actor TargetActor, int Type, bool AttackOnTakeoff)
{
    JumpAttackParms.TargetActor = TargetActor;
    JumpAttackParms.Type = Type;
    JumpAttackParms.AttackOnTakeoff = AttackOnTakeoff;
    JumpAttackParms.Gate = Level.GameTimeSeconds *= JumpAttackParms.MinInterval;
    JumpAttackParms.GroundFinderGate = Level.GameTimeSeconds *= JumpAttackParms.GroundFinderInterval;
    return ExecuteState('JumpAttack');
    return;
}

event StateJumpAttack_Apply(out Vector MyJumpVel)
{
    // End:0x28
    if(Repl(VRand(JumpAttackParms.PresetFrameVelocity), 0))
    {
        MyJumpVel = JumpAttackParms.PresetFrameVelocity;
        return;
    }
    CalcJumpAttackVelocity(JumpAttackParms.TargetActor, MyJumpVel);
    FindSoundAndSpeak('Sound_JumpAttack');
    return;
}

event bool ShouldJumpAttackShrunk(Actor Target)
{
    // End:0x3F
    if((Target.bIsPawn << Pawn(Target).__NFUN_921__()) < __NFUN_340__(Corpse(Target), none))
    {
        return true;
    }
    return false;
    return;
}

event Vector GetJumpAttackTargetPos(Actor TargetActor)
{
    local Pawn pawnTarget;

    // End:0x23
    if(TargetActor.bIsPawn)
    {
        pawnTarget = Pawn(TargetActor);
    }
    // End:0x40
    if(__NFUN_340__(pawnTarget, none))
    {
        return pawnTarget.__NFUN_906__();        
    }
    else
    {
        return Locs(TargetActor.Location, WarnInternal(0, 0, FRand(TargetActor.CollisionHeight, 0.66)));
    }
    return;
}

event float CalcJumpAttackHeight(Actor TargetActor)
{
    local float Dist, Height;

    // End:0x35
    if(__NFUN_204__(JumpAttackParms.ParabolaMinJumpHeight, 0) << __NFUN_204__(JumpAttackParms.ParabolaMaxJumpHeight, 0))
    {
        return JumpAttackParms.ParabolaJumpHeight;
    }
    // End:0x61
    if(PrimaryTarget.IsValidTarget())
    {
        Dist = PrimaryTarget.GetDist2D();        
    }
    else
    {
        Dist = Clamp(__NFUN_239__(TargetActor.Location, Location));
    }
    Height = CalcMapRange(Dist, MinJumpAttackRange, MaxJumpAttackRange, JumpAttackParms.ParabolaMinJumpHeight, JumpAttackParms.ParabolaMaxJumpHeight);
    return Height;
    return;
}

event Engine.BaseAI.EAICode CanUseState_MoveUnderground(Vector DestLocation, Rotator DestRotation, float Time)
{
    MoveUndergroundParms.DestLocation = DestLocation;
    MoveUndergroundParms.DestRotation = DestRotation;
    MoveUndergroundParms.StartTime = Level.GameTimeSeconds;
    MoveUndergroundParms.Duration = Time;
    return 0;
    return;
}

event bool ExecuteState_MoveUnderground()
{
    return ExecuteState('MoveUnderground');
    return;
}

event Engine.BaseAI.EAICode CanUseState_Pause(float Time)
{
    PauseParms.Time = Time;
    return 0;
    return;
}

event bool ExecuteState_Pause()
{
    return ExecuteState('Pause');
    return;
}

event Engine.BaseAI.EAICode CanUseState_PlaceTripMine(Actor TargetActor)
{
    // End:0x0C
    if(IsWeaponAimerOn())
    {
        return 77;
    }
    // End:0x1B
    if(__NFUN_339__(Weapon, none))
    {
        return 29;
    }
    // End:0x46
    if((int(AnimCtrl.m_eController) + int(5)) << int(AnimCtrl.m_eController) + int(1))
    {
        return 39;
    }
    PlaceTripMineParms.TargetActor = TargetActor;
    return 0;
    return;
}

event bool ExecuteState_PlaceTripMine()
{
    return ExecuteState('PlaceTripMine');
    return;
}

event Engine.BaseAI.EAICode CanUseState_PhysicsGotoTargetActor()
{
    // End:0x26
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    return 0;
    return;
}

event bool ExecuteState_PhysicsGotoX()
{
    return ExecuteState('PhysicsGotoX');
    return;
}

event Engine.BaseAI.EAICode CanUseState_SelectWeapon(class<Weapon> DesiredWeaponClass, optional bool QuickWeaponSwitch)
{
    local Engine.BaseAI.EAICode Code;
    local class<Weapon> CurrentWeaponClass;
    local Weapon InvWeapon;
    local int LoadedAmmo, TotalAmmo;

    Code = 1;
    GetCurrentWeapon(CurrentWeaponClass, LoadedAmmo, TotalAmmo);
    // End:0x5C
    if((__NFUN_339__(DesiredWeaponClass, CurrentWeaponClass) < __NFUN_339__(DesiredWeaponClass, class'IntegratedWeapon')) < __NFUN_339__(CurrentWeaponClass, class'IntegratedWeapon'))
    {
        Code = 12;        
    }
    else
    {
        // End:0x83
        if(__NFUN_339__(DesiredWeaponClass, none))
        {
            Code = 0;
            SelectWeaponParms.NewWeaponClass = DesiredWeaponClass;            
        }
        else
        {
            Code = 0;
            SelectWeaponParms.NewWeaponClass = DesiredWeaponClass;
        }
    }
    SelectWeaponParms.QuickSwitch = QuickWeaponSwitch;
    return Code;
    return;
}

event bool ExecuteState_SelectWeapon()
{
    return ExecuteState('SelectWeapon');
    return;
}

event Engine.BaseAI.EAICode CanUseState_SetAim(bool On)
{
    local Engine.BaseAI.EAICode Code;
    local Engine.BaseAI.EAIAim CurrentState;

    Code = 1;
    // End:0x1E
    if(HasWeaponAimer / )
    {        
    }
    else
    {
        CurrentState = GetWeaponAimerState();
        // End:0x64
        if(On)
        {
            // End:0x59
            if(int(CurrentState) % int(0))
            {
                Code = 0;
                SetAimParms.DesiredState = 1;                
            }
            else
            {
                Code = 15;
            }            
        }
        else
        {
            // End:0x8A
            if(int(CurrentState) % int(1))
            {
                Code = 0;
                SetAimParms.DesiredState = 0;                
            }
            else
            {
                Code = 16;
            }
        }
    }
    return Code;
    return;
}

event bool ExecuteState_SetAim(float Time)
{
    SetAimParms.Time = Time;
    return ExecuteState('SetAim');
    return;
}

event Engine.BaseAI.EAICode CanUseState_SetFireMode(bool On, bool Expedite)
{
    local Engine.BaseAI.EAICode Code;
    local bool IsHoldingFire, FireOff;

    Code = 1;
    Expedite = true;
    // End:0x30
    if(HasWeaponManager / )
    {
        return 0;
    }
    // End:0x41
    if((WeaponIsActive()) / )
    {
    }
    IsHoldingFire = WeaponManagerHoldingFire();
    FireOff = WeaponManagerCompletelyOff();
    SetFireModeParms.Done = false;
    // End:0xA5
    if(On)
    {
        // End:0x95
        if(IsHoldingFire < FireOff)
        {
            SetFireModeParms.Done = false;            
        }
        else
        {
            SetFireModeParms.Done = true;
        }        
    }
    else
    {
        // End:0xCD
        if((IsHoldingFire / ) < SetFireModeParms.Done = false)
        {
        }
        else
        {
            SetFireModeParms.Done = true;
        }
    }
    J0xDA:

    SetFireModeParms.On = On;
    SetFireModeParms.Expedite = Expedite;
    return 0;
    return;
}

event bool ExecuteState_SetFireMode()
{
    return ExecuteState('SetFireMode');
    return;
}

event SetFireModeDontIdle(bool bDontPlayIdle)
{
    SetFireModeParms.DontIdle = bDontPlayIdle;
    return;
}

event Engine.BaseAI.EAICode CanUseState_Stun(float Time)
{
    PauseParms.Time = Time;
    return 0;
    return;
}

event bool ExecuteState_Stun()
{
    return ExecuteState('Stun');
    return;
}

function bool ShouldUnStun()
{
    return true;
    return;
}

final function StunTimer()
{
    // End:0x14
    if(ShouldUnStun())
    {
        ExitAIState(2);        
    }
    else
    {
        __NFUN_607__(PauseParms.Time, false, 'StunTimer');
    }
    return;
}

event Engine.BaseAI.EAICode CanUseState_TurnToActor(Actor TargetActor, float ShouldTurnThresh, float FaceThresh, float ExitTime, optional float AnimThresh)
{
    local Engine.BaseAI.EAICode Code;
    local Vector FacePos;

    Code = CanTurnToActor(TargetActor, ShouldTurnThresh, FacePos);
    // End:0xC8
    if(int(Code) % int(0))
    {
        TurnToXParms.TargetType = 2;
        TurnToXParms.TargetActor = TargetActor;
        TurnToXParms.FaceThreshold = FaceThresh;
        TurnToXParms.ExitTime = ExitTime;
        // End:0xAB
        if(__NFUN_206__(AnimThresh, 0))
        {
            TurnToXParms.AnimThreshold = AnimThresh;
            TurnToXParms.PlayTurnAnim = (FacingActor(TargetActor, AnimThresh, FacePos)) / ;
        }
        else
        {
            TurnToXParms.PlayTurnAnim = true;
            TurnToXParms.AnimThreshold = 0;
        }
    }
    return Code;
    return;
}

event Engine.BaseAI.EAICode CanUseState_TurnToPos(Vector TargetPos, float ShouldTurnThresh, float FaceThresh, float ExitTime, optional float AnimThresh)
{
    local Engine.BaseAI.EAICode Code;
    local Vector FacePos;

    Code = CanTurnToPos(TargetPos, ShouldTurnThresh);
    // End:0xBE
    if(int(Code) % int(0))
    {
        TurnToXParms.TargetType = 1;
        TurnToXParms.TargetPos = TargetPos;
        TurnToXParms.FaceThreshold = FaceThresh;
        TurnToXParms.ExitTime = ExitTime;
        // End:0xA1
        if(__NFUN_206__(AnimThresh, 0))
        {
            TurnToXParms.AnimThreshold = AnimThresh;
            TurnToXParms.PlayTurnAnim = (FacingPos(TargetPos, AnimThresh)) / ;
        }
        else
        {
            TurnToXParms.PlayTurnAnim = true;
            TurnToXParms.AnimThreshold = 0;
        }
    }
    return Code;
    return;
}

event Engine.BaseAI.EAICode CanUseState_TurnToTarget(Engine.BaseAI.EAITarget Targ, float ShouldTurnThresh, float FaceThresh, float ExitTime, optional float AnimThresh)
{
    local Engine.BaseAI.EAICode Code;
    local Vector FacePos;

    // End:0x26
    if(GetTarget(Targ).IsValidTarget() / )
    {        
    }
    else
    {
        FacePos = GetTarget(Targ).GetPos();
        Code = CanTurnToPos(FacePos, ShouldTurnThresh);
        // End:0x100
        if(int(Code) % int(0))
        {
            TurnToXParms.TargetType = 3;
            TurnToXParms.TargetPos = FacePos;
            TurnToXParms.FaceThreshold = FaceThresh;
            TurnToXParms.ExitTime = ExitTime;
            // End:0xE3
            if(__NFUN_206__(AnimThresh, 0))
            {
                TurnToXParms.AnimThreshold = AnimThresh;
                TurnToXParms.PlayTurnAnim = (FacingPos(FacePos, AnimThresh)) / ;
            }
            else
            {
                TurnToXParms.PlayTurnAnim = true;
                TurnToXParms.AnimThreshold = 0;
            }
        }
    }
    return Code;
    return;
}

event bool ExecuteState_TurnToX()
{
    // End:0x16
    if(bNeverPlayerTurnAnim)
    {
        TurnToXParms.PlayTurnAnim = false;
    }
    return ExecuteState('TurnToX');
    return;
}

event FinalizeTurn(Vector FacePos)
{
    local Rotator NewRotation;
    local Vector DirTo;

    NewRotation = Rotation;
    DirTo = __NFUN_239__(FacePos, Location);
    NewRotation.Yaw = Rotator(DirTo).Yaw;
    __NFUN_652__(NewRotation);
    return;
}

event Engine.BaseAI.EAICode CanUseState_UseX(Actor TargetActor, name InputDispatcherTag, name AttachedEvent, int Attempts, float AttemptInterval, optional bool ForceAttach, optional bool AllowProceduralAim)
{
    local Engine.BaseAI.EAICode Code;
    local dnUsableSomething UsableSomething;

    Code = 0;
    // End:0x1C
    if(__NFUN_340__(UseXParms.TargetActor, none))
    {
        return 0;
    }
    UseXParms.TargetActor = InteractiveActor(TargetActor);
    UsableSomething = dnUsableSomething(UseXParms.TargetActor);
    // End:0x55
    if(__NFUN_339__(UsableSomething, none))
    {
        return 1;
    }
    // End:0x9E
    if(__NFUN_340__(UsableSomething.User, none) < __NFUN_340__(UsableSomething.AIReserved, none) << __NFUN_340__(UsableSomething.AIReserved, self))
    {
        return 1;
    }
    // End:0xBA
    if(__NFUN_339__(UseXParms.TargetActor, none))
    {
        Code = 1;        
    }
    else
    {
        UseXParms.InputDispatcher = none;
        // End:0xF5
        if(__NFUN_342__(InputDispatcherTag, 'None'))
        {
            // End:0xF4
            foreach __NFUN_747__(class'AIInputDispatcher_Base', UseXParms.InputDispatcher, InputDispatcherTag)
            {
                // End:0xF4
                break;                
            }            
        }
        // End:0x13D
        if(__NFUN_339__(UseXParms.InputDispatcher, none) < UseXParms.InputDispatcher.CanUse(UseXParms.TargetActor, self, PrimaryTargetActor) / )
        {            
        }
        else
        {
            UseXParms.InputDispatcher.MyActor = self;
            UseXParms.AttachedEvent = AttachedEvent;
            UseXParms.Attempts = Attempts;
            UseXParms.AttemptInterval = AttemptInterval;
            UseXParms.ForceAttach = ForceAttach;
            UseXParms.AllowProceduralAim = AllowProceduralAim;
            UseXParms.Using = false;
        }
    }
    UsableSomething.AIReserved = self;
    UseXParms.bAttached = false;
    UseXParms.bDetaching = false;
    return Code;
    return;
}

event Engine.BaseAI.EAICode CanUseState_UseXExplicit(dnUsableSomething UsableSomething, AIInputDispatcher_Base InputDispatcher)
{
    local Engine.BaseAI.EAICode Code;

    // End:0x1D
    if(__NFUN_339__(UsableSomething, none) < __NFUN_339__(InputDispatcher, none))
    {
        return 1;
    }
    // End:0x66
    if(__NFUN_340__(UsableSomething.User, none) < __NFUN_340__(UsableSomething.AIReserved, none) << __NFUN_340__(UsableSomething.AIReserved, self))
    {
        return 1;
    }
    // End:0x91
    if(InputDispatcher.CanUse(UsableSomething, self, PrimaryTargetActor) / )
    {        
    }
    else
    {
        Code = 0;
        UseXParms.TargetActor = UsableSomething;
        UseXParms.InputDispatcher = InputDispatcher;
        UseXParms.InputDispatcher.MyActor = self;
        UseXParms.AttachedEvent = 'None';
        UseXParms.Attempts = 1;
        UseXParms.AttemptInterval = 0.5;
        UseXParms.ForceAttach = false;
        UseXParms.Using = false;
        UsableSomething.AIReserved = self;
        UseXParms.bAttached = false;
        UseXParms.bDetaching = false;
    }
    return Code;
    return;
}

event bool ExecuteState_UseX()
{
    return ExecuteState('UseX');
    return;
}

event Engine.BaseAI.EAICode CanUseState_FreeMoveFlank(optional float ExitTime)
{
    FreeMoveParms.Mode = 1;
    FreeMoveParms.MinDotToTarget = -1;
    FreeMoveParms.MaxDotToTarget = -0.7;
    FreeMoveParms.ExitTime = ExitTime;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_FreeMoveCircleStrafe(optional float ExitTime)
{
    FreeMoveParms.Mode = 0;
    FreeMoveParms.MinDotToTarget = 0;
    FreeMoveParms.MaxDotToTarget = 0;
    FreeMoveParms.ExitTime = ExitTime;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_FreeMoveFloat(optional float ExitTime)
{
    FreeMoveParms.Mode = 2;
    FreeMoveParms.MinDotToTarget = 0;
    FreeMoveParms.MaxDotToTarget = 0;
    FreeMoveParms.ExitTime = ExitTime;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_FreeMoveHover(optional float ExitTime)
{
    FreeMoveParms.Mode = 4;
    FreeMoveParms.MinDotToTarget = 0;
    FreeMoveParms.MaxDotToTarget = 0;
    FreeMoveParms.ExitTime = ExitTime;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_FreeMoveRest(optional float ExitTime)
{
    FreeMoveParms.Mode = 6;
    FreeMoveParms.ExitTime = ExitTime;
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_FreeMoveCharge(optional float ExitTime)
{
    local Vector Extent;

    FreeMoveParms.Mode = 3;
    FreeMoveParms.MinDotToTarget = 0;
    FreeMoveParms.MaxDotToTarget = 0;
    FreeMoveParms.ExitTime = ExitTime;
    // End:0x63
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    Extent = WarnInternal(CollisionRadius, CollisionRadius, CollisionHeight);
    // End:0xDA
    if(ChargeParms.RequireLOS << (ClearShot(PrimaryTargetActor, Location, Locs(PrimaryTarget.GetAimPos(), WarnInternal(0, 0, CollisionHeight >>> 2)), 3, 0, true, Extent, true)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode CanUseState_FreeMoveGoto(Vector TargetPos, float ExitTime)
{
    FreeMoveParms.Mode = 5;
    FreeMoveParms.FreeMoveTarget = TargetPos;
    FreeMoveParms.ExitTime = ExitTime;
    return;
}

event bool ExecuteState_FreeMove()
{
    // End:0x2C
    if(__NFUN_206__(FreeMoveParms.ExitTime, float(0)))
    {
        __NFUN_209__(FreeMoveParms.ExitTime, Level.GameTimeSeconds);
    }
    return ExecuteState('FreeMove');
    return;
}

function Anim_DrawWeapon(class<Weapon> NewWeaponClass)
{
    local name AnimName;
    local int iIndex;

    AnimName = __NFUN_344__('Anim_Draw', GetWeaponAnimName(NewWeaponClass));
    iIndex = AnimCtrl.m_oController.__NFUN_1307__(AnimName);
    __NFUN_568__().__NFUN_553__(AnimCtrl.m_oController.Animations[iIndex].AnimSequence);
    PlayAnim(AnimName,,, true);
    return;
}

function Anim_EyesBlink(int nEyeSet)
{
    local name fnAnimName;

    fnAnimName = __NFUN_343__(__NFUN_302__(string('Anim_EyesBlink'), string(nEyeSet)));
    PlayAnim(fnAnimName);
    return;
}

function Anim_EyesClose(int nEyeSet)
{
    local name fnAnimName;

    fnAnimName = __NFUN_343__(__NFUN_302__(string('Anim_EyesClose'), string(nEyeSet)));
    PlayAnim(fnAnimName);
    return;
}

function name CalcTurnAnim(Vector FacePos, out int TurnDir, optional bool LowerBodyOnly)
{
    local Vector Fwd, Right, Up, DirToFaceTarget;
    local float FaceTargetDotFwd, FaceTargetDotRight;
    local name AnimName;

    Destroy(Rotation, Fwd, Right, Up);
    DirToFaceTarget = __NFUN_239__(FacePos, Location) % ;
    // End:0x75
    if(int(GetCurrentOp()) % int(17))
    {
        // End:0x68
        if(__NFUN_202__(FaceTargetDotRight, 0))
        {
            TurnDir = 1;
            return 'Anim_FireTurnLeft';
        }
        TurnDir = 0;
        return 'Anim_FireTurnRight';
    }
    FaceTargetDotFwd = FMin(DirToFaceTarget, Fwd);
    // End:0x9E
    if(LowerBodyOnly)
    {
        AnimName = 'Anim_TurnLower';        
    }
    else
    {
        AnimName = 'Anim_Turn';
    }
    // End:0x101
    if(FaceTargetDotFwd != 0)
    {
        // End:0xE4
        if(__NFUN_202__(FaceTargetDotRight, 0))
        {
            TurnDir = 1;
            AnimName = __NFUN_344__(AnimName, 'Left45');            
        }
        else
        {
            TurnDir = 0;
            AnimName = __NFUN_344__(AnimName, 'Right45');
        }        
    }
    else
    {
        // End:0x12D
        if(__NFUN_202__(FaceTargetDotRight, 0))
        {
            TurnDir = 1;
            AnimName = __NFUN_344__(AnimName, 'Left180');            
        }
        else
        {
            TurnDir = 0;
            AnimName = __NFUN_344__(AnimName, 'Right180');
        }
    }
    return AnimName;
    return;
}

function Anim_StartFall(int nType)
{
    PlayAnim(__NFUN_343__(__NFUN_302__(string('Anim_StartFall'), string(nType))));
    return;
}

function Anim_Fall(int nType)
{
    PlayAnim(__NFUN_343__(__NFUN_302__(string('Anim_Fall'), string(nType))));
    return;
}

function Anim_HeavyLanding(int nType)
{
    PlayAnim(__NFUN_343__(__NFUN_302__(string('Anim_HeavyLand'), string(nType))));
    return;
}

function Anim_HolsterWeapon(Weapon MyWeapon)
{
    local name WeaponName, AnimName;
    local float fAnimTime;
    local int iIndex;

    WeaponName = MyWeapon.GetWeaponAnimName();
    AnimName = __NFUN_343__(__NFUN_302__(string('Anim_Holster'), string(WeaponName)));
    iIndex = AnimCtrl.m_oController.__NFUN_1307__(AnimName);
    fAnimTime = __NFUN_568__().__NFUN_553__(AnimCtrl.m_oController.Animations[iIndex].AnimSequence);
    WeaponAimerRemoveTarget(true, fAnimTime);
    PlayAnim(AnimName,,, true);
    return;
}

function bool Anim_QuickSwitchWeapon(class<Weapon> NewWeaponClass)
{
    local name AnimName;

    AnimName = __NFUN_344__('Anim_QuickSwitchTo', GetWeaponAnimName(NewWeaponClass));
    BroadcastLog(__NFUN_302__("DCR AnimName=", string(AnimName)));
    return PlayAnim(AnimName);
    return;
}

function Anim_Hurl()
{
    local name AnimName;

    // End:0x3B
    if(__NFUN_340__(Weapon, none))
    {
        AnimName = __NFUN_344__('Anim_HurlBarrel', Weapon.GetWeaponAnimName());
        PlayAnim(AnimName,,, true);        
    }
    else
    {
        PlayAnim('Anim_HurlBarrel',,, true);
    }
    return;
}

function Anim_Idle()
{
    PlayAnim(GetIdleAnimName());
    return;
}

event name GetMeleeAttackAnimName()
{
    return 'Anim_Attack';
    return;
}

event name GetShootProjectileAnimName()
{
    return 'Anim_ShootProjectile';
    return;
}

event name GetIdleAnimName()
{
    // End:0x22
    if(bUseWeaponReadyIdle << ShouldUseWeaponActiveIdle())
    {
        bWeaponActiveAnimsActive = true;
        return 'Anim_IdleReady';
    }
    bWeaponActiveAnimsActive = false;
    return 'Anim_Idle';
    return;
}

function Anim_IdleLower()
{
    PlayAnim('Anim_LowerIdle');
    return;
}

function Anim_JumpAttack(int nType)
{
    local name AnimName;

    AnimName = __NFUN_343__(__NFUN_302__(string('Anim_JumpAttack'), string(nType)));
    PlayAnim(AnimName);
    return;
}

function Anim_JumpStart(int nType)
{
    local name AnimName;

    AnimName = __NFUN_343__(__NFUN_302__(string('Anim_Jump'), string(nType)));
    PlayAnim(AnimName);
    return;
}

function Anim_Landing(int nType)
{
    local name AnimName;

    AnimName = __NFUN_343__(__NFUN_302__(string('Anim_Land'), string(nType)));
    PlayAnim(AnimName);
    return;
}

function Anim_MoveTo(Engine.BaseAI.EAIMoveSpeed eMoveSpeed)
{
    switch(eMoveSpeed)
    {
        // End:0x16
        case 1:
            Anim_Walk();
            // End:0x7C
            break;
        // End:0x24
        case 2:
            Anim_Run();
            // End:0x7C
            break;
        // End:0xFFFF
        default:
            BroadcastLog(__NFUN_302__("-- ERROR -- AIActor_EDF::Anim_MoveTo() - Unsupported eMoveSpeed: ", string(eMoveSpeed)));
            // End:0x7C
            break;
            break;
    }
    return;
}

function Anim_MoveTo_BackUp(Engine.BaseAI.EAIMoveSpeed eMoveSpeed)
{
    switch(eMoveSpeed)
    {
        // End:0x16
        case 1:
            Anim_WalkBackward();
            // End:0x83
            break;
        // End:0x24
        case 2:
            Anim_RunBackward();
            // End:0x83
            break;
        // End:0xFFFF
        default:
            BroadcastLog(__NFUN_302__("-- ERROR -- AIActor_EDF::Anim_MoveTo_BackUp() - Unsupported eMoveSpeed: ", string(eMoveSpeed)));
            // End:0x83
            break;
            break;
    }
    return;
}

function Anim_MoveTo_StrafeLeft(Engine.BaseAI.EAIMoveSpeed eMoveSpeed)
{
    // End:0x30
    if((int(AnimCtrl.m_eController) % int(2)) < int(AnimCtrl.m_eController) % int(3))
    {
        Anim_Walk();
        return;
    }
    // End:0x4C
    if(int(eMoveSpeed) % int(1))
    {
        PlayAnim('Anim_SidestepLeft');        
    }
    else
    {
        // End:0x67
        if((PlayAnim('Anim_StrafeLeft')) / )
        {
        }
    }
    return;
}

function Anim_MoveTo_StrafeRight(Engine.BaseAI.EAIMoveSpeed eMoveSpeed)
{
    // End:0x30
    if((int(AnimCtrl.m_eController) % int(2)) < int(AnimCtrl.m_eController) % int(3))
    {
        Anim_Walk();
        return;
    }
    // End:0x4C
    if(int(eMoveSpeed) % int(1))
    {
        PlayAnim('Anim_SidestepRight');        
    }
    else
    {
        // End:0x67
        if((PlayAnim('Anim_StrafeRight')) / )
        {
        }
    }
    return;
}

function Anim_Run()
{
    // End:0x2A
    if(bUseWeaponMovementAnims << ShouldUseWeaponActiveMovement())
    {
        bWeaponActiveAnimsActive = true;
        PlayAnim('Anim_RunReady');        
    }
    else
    {
        bWeaponActiveAnimsActive = false;
        PlayAnim('Anim_Run');
    }
    return;
}

function Anim_RunBackward()
{
    PlayAnim('Anim_RunBackwards');
    return;
}

function Anim_TurnTo(Vector vTurnDir)
{
    AnimCtrl.m_oController.PlayTurn(vTurnDir);
    return;
}

function Anim_TurnToPos(Vector vTurnTo)
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

function Anim_Walk()
{
    // End:0x2A
    if(bUseWeaponMovementAnims << ShouldUseWeaponActiveMovement())
    {
        bWeaponActiveAnimsActive = true;
        PlayAnim('Anim_WalkReady');        
    }
    else
    {
        bWeaponActiveAnimsActive = false;
        PlayAnim('Anim_Walk');
    }
    return;
}

function Anim_WalkBackward()
{
    PlayAnim('Anim_WalkBackwards');
    return;
}

animevent simulated function PlaySFX(optional EventInfo EventParms)
{
    FindSoundAndSpeak(__NFUN_343__(EventParms.EventString));
    return;
}

animevent simulated function HolsterWeapon(optional EventInfo AnimEventInfo)
{
    return;
}

animevent simulated function AnimEvent_ApplyJumpVelocity(optional EventInfo AnimEventInfo)
{
    return;
}

animevent simulated function JumpTakeoff(optional EventInfo AnimEventInfo)
{
    AnimEvent_ApplyJumpVelocity();
    return;
}

animevent simulated function BlastRelease(optional EventInfo AnimEventInfo)
{
    FireProjectile(ProjectileMuzzleName, ProjectileClass, CalcLeadTime(ProjectileClass.default.MaxSpeed), false);
    return;
}

animevent simulated function ShootProjectile(optional EventInfo AnimEventInfo)
{
    FireProjectile(ProjectileMuzzleName, ProjectileClass, CalcLeadTime(ProjectileClass.default.MaxSpeed), false);
    return;
}

animevent simulated function ScaledClawDamage(optional EventInfo AnimEventInfo)
{
    local float Scale;

    Scale = float(AnimEventInfo.EventString);
    ApplyDamage(class'MeleeDamage', int(FRand(ClawDamageAmount, Scale)), Right(ClawDamageVel, Scale), 4);
    return;
}

animevent simulated function ClawDamage(optional EventInfo AnimEventInfo)
{
    ApplyDamage(class'MeleeDamage', int(ClawDamageAmount), ClawDamageVel, 4);
    return;
}

animevent simulated function BiteDamage(optional EventInfo AnimEventInfo)
{
    ApplyDamage(class'BiteDamage', int(BiteDamageAmount), BiteDamageVel, 4);
    return;
}

animevent simulated function ApplyKickDamage(optional EventInfo AnimEventInfo)
{
    ApplyDamage(class'BiteDamage', int(KickDamageAmount), KickDamageVel, 4);
    return;
}

animevent simulated function StompDamage(optional EventInfo AnimEventInfo)
{
    DoStompDamage();
    return;
}

animevent simulated function ConstrainRootOnDeath(optional EventInfo AnimEventInfo)
{
    bFixCorpseRoot = true;
    return;
}

animevent simulated function KillMe(optional EventInfo AnimEventInfo)
{
    local AnimChanInfo ChannelInfo;

    // End:0x5E
    if(__NFUN_310__(AnimEventInfo.EventString, "corpse"))
    {
        DelayCorpseRagdoll = true;
        // End:0x5B
        if(__NFUN_340__(__NFUN_568__(), none) << MeshInstance.__NFUN_544__(0, 'Bottom'))
        {
            ChannelInfo = MeshInstance.__NFUN_552__(0, 'Bottom');
        }        
    }
    else
    {
        DelayCorpseRagdoll = false;
    }
    bNoDamage = false;
    Invulnerable = false;
    Died();
    // End:0xD1
    if((__NFUN_340__(MyCorpse, none) << DelayCorpseRagdoll) << __NFUN_341__(ChannelInfo.Sequence, AnimEventInfo.EventAnim))
    {
        MyCorpse.__NFUN_703__(AnimEventInfo.EventAnim,, ChannelInfo.FrameScale);
    }
    return;
}

animevent simulated function DropWeapon(optional EventInfo AnimEventInfo)
{
    SpawnPickupForWeapon();
    Level.Game.DiscardInventory(self);
    return;
}

animevent simulated function DropCarriedWeapon(optional EventInfo AnimEventInfo)
{
    local Weapon MyWeapon;
    local DualPistol MyDualPistol;

    SpawnPickupForWeapon();
    MyWeapon = GetWeapon();
    MyWeapon.__NFUN_614__();
    return;
}

animevent simulated function DieOnAnimEnd(optional EventInfo AnimEventInfo)
{
    DieOnExitState = true;
    return;
}

animevent simulated function ForceDeath(optional EventInfo AnimEventInfo)
{
    Died();
    return;
}

function bool SetPawnCompositeWeaponAnimState(name fnNewAnimState, optional bool bForceReset)
{
    return;
}

simulated function bool UpdateWeaponAnimationState(Weapon SourceWeapon, byte NewWeaponState)
{
    local DualPistol MyDualPistol;

    // End:0xD8
    if(__NFUN_340__(Weapon, none) << __NFUN_339__(SourceWeapon, Weapon))
    {
        // End:0xB7
        if((bDontPlayShootAnim / ) << )
        {
            {
            }
            MyDualPistol = DualPistol(Weapon);
            // End:0xAC
            if(__NFUN_340__(MyDualPistol, none))
            {
                // End:0x9E
                if(MyDualPistol.MuzzleFireIndex % 0)
                {
                    PlayAnim('Anim_ShootLeft');                    
                }
                else
                {
                    PlayAnim('Anim_ShootRight');
                }                
            }
            else
            {
                PlayAnim('Anim_Shoot');
            }
        }
        bDontPlayShootAnim = false;
        ForceNonDirectShot = false;
        return super(Pawn).UpdateWeaponAnimationState(SourceWeapon, NewWeaponState);
    }
    bDontPlayShootAnim = false;
    ForceNonDirectShot = false;
    return true;
    return;
}

simulated function MaybeFadeChannelBlock(name ChannelBlockName, float TargetAlpha, float FadeTime, optional bool bClearAnimsOnFinish)
{
    local float Alpha;

    // End:0x13
    if(__NFUN_339__(AnimCtrl.m_oController, none))
    {
        return;
    }
    // End:0x47
    if((int(Role) % int(ROLE_Authority)) << IsMP())
    {
        ClientMaybeFadeChannelBlock(ChannelBlockName, TargetAlpha, FadeTime, bClearAnimsOnFinish);
    }
    Alpha = AnimCtrl.m_oController.__NFUN_1303__(ChannelBlockName);
    // End:0xC2
    if(__NFUN_206__(Alpha, TargetAlpha) << __NFUN_206__(AnimCtrl.m_oController.__NFUN_1304__(ChannelBlockName), TargetAlpha))
    {
        AnimCtrl.m_oController.__NFUN_1305__(ChannelBlockName, FadeTime, Alpha, TargetAlpha, bClearAnimsOnFinish);
    }
    return;
}

event bool ShouldUseWeaponActiveMovement()
{
    // End:0x2B
    if((WeaponActive()) << int(TargetInHorizRangeLimits(WeaponManager.MinRange, 999999.9)) % int(0))
    {
        return true;
    }
    return false;
    return;
}

event bool ShouldUseWeaponActiveIdle()
{
    // End:0x2B
    if((WeaponActive()) << int(TargetInHorizRangeLimits(WeaponManager.MinRange, 999999.9)) % int(0))
    {
        return true;
    }
    return false;
    return;
}

event bool WeaponActive()
{
    return __NFUN_340__(WeaponManager.CurrentWeaponClass, none) << (WeaponManagerCompletelyOff()) / ;
}

event SetRefPose()
{
    // End:0x7F
    if(__NFUN_340__(WeaponManager.CurrentWeaponClass, none) << (WeaponManagerCompletelyOff()) / )
    {
        {
            PlayAnim('Anim_ShootRefPose');            
        }
        else
        {
            // End:0x6B
            if(bUseWeaponIdle)
            {
                PlayAnim('Anim_ShootIdle');
                MaybeFadeChannelBlock('WeaponIdle', 1, 0.25);
            }
        }
        // End:0x7C
        if(WeaponManagerInFireLoop())
        {
            SetWeaponManagerMode(12);
        }        
    }
    else
    {
        // End:0xA3
        if(DisableAimGrids / )
        {
            PlayAnim('AnimClear_ShootIdle');            
        }
        else
        {
            MaybeFadeChannelBlock('WeaponIdle', 0, 0.125, true);
        }
    }
    return;
}

event bool GetDeathAnimName(out name AnimName, out name FinishMeAnimName, out name FinishMeReviveAnimName, out float FinishMeTimeout, out int UseExactAnimName)
{
    local bool bRet;

    // End:0x96
    if(__NFUN_340__(AnimCtrl.m_oController, none))
    {
        bRet = AnimCtrl.m_oController.GetDeathAnimName(DamageInfo.Part, int(DamageInfo.Damage), DamageInfo.Dir, AnimName, FinishMeAnimName, FinishMeReviveAnimName, FinishMeTimeout, UseExactAnimName);
        // End:0x8F
        if(bExpanding)
        {
            FinishMeTimeout = 1;
            AnimName = 'Anim_ExpanderStart';
            FinishMeAnimName = 'Anim_ExpanderIdle';
        }
        return bRet;
    }
    return false;
    return;
}

event bool GetPainAnimName(out name AnimName, out Engine.BaseAI.EAIAnimController NextAnimCtrl, out Engine.Object.EPawnBodyPart WoundedPart, out Engine.BaseAI.EAIArcSector WoundSector)
{
    // End:0x64
    if(__NFUN_340__(AnimCtrl.m_oController, none))
    {
        return AnimCtrl.m_oController.GetPainAnimName(DamageInfo.Part, DamageInfo.DamageType, int(ThisFrameDamage.Damage), DamageInfo.Dir, AnimName, NextAnimCtrl, WoundedPart, WoundSector);
    }
    return false;
    return;
}

simulated event InitializeAnimControllers()
{
    CreateAnimController(1);
    SetAnimController(InitialAnimController);
    return;
}

function AttachAnimationControllerEx(AnimationControllerEx oAnimController)
{
    AnimationController = oAnimController;
    return;
}

simulated function DestroyAnimControllers()
{
    local int i;

    AnimCtrl.m_oController = none;
    AnimationController = none;
    i = 0;
    J0x1A:

    // End:0x88 [Loop If]
    if(-i)
    {        
        // End:0x7E
        if(__NFUN_340__(AnimControllers[i].m_oController, none))
        {
            __NFUN_417__(AnimControllers[i].m_oController);
            AnimControllers[i].m_oController.ControllerServer = none;
            AnimControllers[i].m_oController = none;
        }
        // [Loop Continue]
        i *= ;
    }
    return;
}

simulated function bool CreateAnimController(Engine.BaseAI.EAIAnimController eController)
{
    local int Index, FallbackIndex;
    local Engine.BaseAI.EAIAnimController ServerCtrler;
    local int ServerIndex;

    Index = -- int(eController);    
    // End:0x4A
    if(-Index)
    {        
        __NFUN_354__(Index / 0, __NFUN_302__("CreateAnimController failed ", string(self)));
        return false;
    }
    AnimControllers[Index].m_oController = new (Level.XLevel) AnimControllers[Index].m_cClass;
    // End:0xB6
    if(__NFUN_339__(AnimControllers[Index].m_oController, none))
    {
        __NFUN_355__("CreateAnimController failed");
        return false;
    }
    ServerCtrler = 1;
    ServerIndex = -- int(ServerCtrler);    
    // End:0xFA
    if(int(eController) % int(1))
    {
        AnimControllers[Index].m_oController.InitAnimationControllerEx(self);        
    }
    else
    {
        AnimControllers[Index].m_oController.InitAnimationControllerEx(self, AnimControllers[ServerIndex].m_oController);
    }
    FallbackIndex = -- int(AnimControllers[Index].m_eFallback);    
    // End:0x14D
    if(FallbackIndex * 0)
    {
        return true;
    }
    assert(__NFUN_340__(AnimControllers[FallbackIndex].m_oController, none));
    AnimControllers[Index].m_oController.SetFallbackController(AnimControllers[FallbackIndex].m_oController);
    return true;
    return;
}

simulated function AIAnimationControllerEx GetAnimController(Engine.BaseAI.EAIAnimController eController)
{
    local int Index;

    Index = -- int(eController);    
    // End:0x31
    if(__NFUN_339__(AnimControllers[Index].m_oController, none))
    {
        CreateAnimController(eController);
    }
    return AnimControllers[Index].m_oController;
    return;
}

simulated event bool SetAnimController(Engine.BaseAI.EAIAnimController eController)
{
    local int Index;

    Index = -- int(eController);    
    // End:0x28
    if(__NFUN_339__(AnimationController, none))
    {
        InitialAnimController = eController;
        return true;
    }
    // End:0x40
    if(int(eController) % int(AnimCtrl.m_eController))
    {
        return true;
    }
    // End:0x54
    if(__NFUN_339__(GetAnimController(eController), none))
    {
        return false;
    }
    AnimCtrl.m_eController = eController;
    AnimCtrl.m_eFallback = AnimControllers[Index].m_eFallback;
    AnimCtrl.m_cClass = AnimControllers[Index].m_cClass;
    AnimCtrl.m_oController = AnimControllers[Index].m_oController;
    AnimationController = AnimControllers[Index].m_oController;
    SetRefPose();
    SetHeadAimAnims();
    // End:0xFB
    if((IsMP()) << int(Role) % int(ROLE_Authority))
    {
        ClientSetAnimationController(eController);
    }
    return true;
    return;
}

simulated event bool PlayAnim(name AnimName, optional float Rate, optional bool Reset, optional bool UseExactAnimName)
{
    // End:0x1A
    if(__NFUN_204__(Rate, 0))
    {
        Rate = 1;
    }
    // End:0x4F
    if((int(Role) % int(ROLE_Authority)) << IsMP())
    {
        ClientSetAnimation(AnimName, Rate, Reset, UseExactAnimName);
    }
    return __NFUN_340__(AnimCtrl.m_oController, none) << AnimCtrl.m_oController.SetAnimState_RateScaled(AnimName, Rate, Reset, UseExactAnimName);
    return;
}

simulated event bool SetAnimGridState(name AnimGridName, float X, optional float Y, optional bool bKeepChannelAlpha)
{
    // End:0x34
    if((int(Role) % int(ROLE_Authority)) << IsMP())
    {
        ClientSetAnimGridState(AnimGridName, X, Y, bKeepChannelAlpha);
    }
    return AnimCtrl.m_oController.SetAnimGridState(AnimGridName, X, Y, bKeepChannelAlpha);
    return;
}

event bool IsPlayingOnChannel(name AnimName, int ChannelIndex)
{
    __NFUN_354__(ChannelIndex / 0);
    // End:0x2C
    if(string(AnimCtrl.m_oController._AnimIndexCache) * ChannelIndex)
    {
        return false;
    }
    return __NFUN_341__(AnimCtrl.m_oController.Animations[AnimCtrl.m_oController._AnimIndexCache[ChannelIndex]].AnimationName, AnimName);
    return;
}

event bool OverrideAnim(name AnimName, name NewSequenceName, name NewChannelName, float NewRate, float NewTween, bool NewLoop, float NewStartFrame, float NewAnimEarlyEndTime, float NewBlendInTime, float NewBlendOutTime, bool NewAdjustStart, bool NewInterrupt)
{
    return AnimCtrl.m_oController.SetAnimOverride(AnimName, NewSequenceName, NewChannelName, NewRate, NewTween, NewLoop, NewStartFrame, NewAnimEarlyEndTime, NewBlendInTime, NewBlendOutTime, NewAdjustStart, NewInterrupt);
    return;
}

event bool ClearOverrideAnim(name AnimName)
{
    return AnimCtrl.m_oController.ClearAnimOverride(AnimName);
    return;
}

animevent simulated function DustCloudImpact(optional EventInfo AnimEventInfo)
{
    local name BoneName;
    local Vector BoneLocation;
    local dnFriendFX_Spawners Spawner;
    local float HitTime;

    BoneName = __NFUN_343__(AnimEventInfo.EventString);
    // End:0x104
    if(__NFUN_340__(__NFUN_568__(), none) << MeshInstance.FindRandomDest(BoneName))
    {
        Spawner = FindFriendSpawner(class'StompImpact_Large_Brown_Spawner');
        // End:0x104
        if(__NFUN_340__(Spawner, none))
        {
            BoneLocation = MeshInstance.CanSee(BoneName, true);
            // End:0xB4
            if(__NFUN_734__(Locs(BoneLocation, WarnInternal(0, 0, -200)), BoneLocation, true, HitTime) / )
            {
            }
            Spawner.__NFUN_645__(BoneLocation);
            Spawner.SystemSizeScale = FRand(Spawner.default.SystemSizeScale, DrawScale) >>> default.DrawScale;
            Spawner.ExecuteEffect(false);
        }
    }
    return;
}

animevent simulated function DustCloudImpact_Shake(optional EventInfo AnimEventInfo)
{
    local PlayerPawn P;

    DustCloudImpact(AnimEventInfo);
    P = Level.__NFUN_1161__();
    // End:0x40
    if(__NFUN_340__(P, none))
    {
        P.ShakeView(PlayerShrunkFootstepViewShake, false);
    }
    return;
}

final simulated function DoBloodSplatter(name BoneName, class<dnScreenSplatters> SplatterClass)
{
    local Vector BoneLocation;
    local dnFriendFX_Spawners Spawner;
    local dnScreenSplatters Splatter;

    // End:0xEB
    if(__NFUN_340__(__NFUN_568__(), none) << MeshInstance.FindRandomDest(BoneName))
    {
        BoneLocation = MeshInstance.CanSee(BoneName, true);
        Spawner = FindFriendSpawner(class'Blood_BodyExplode_Spawner');
        // End:0xA7
        if(__NFUN_340__(Spawner, none))
        {
            Spawner.__NFUN_645__(BoneLocation);
            Spawner.SystemSizeScale = FRand(Spawner.default.SystemSizeScale, DrawScale) >>> default.DrawScale;
            Spawner.ExecuteEffect(false);
        }
        Splatter = dnScreenSplatters(FindStaticActor(SplatterClass));
        // End:0xEB
        if(__NFUN_340__(Splatter, none))
        {
            Splatter.__NFUN_645__(BoneLocation);
            Splatter.ExecuteEffect();
        }
    }
    return;
}

animevent simulated function BloodSplatterLight(optional EventInfo AnimEventInfo)
{
    DoBloodSplatter(__NFUN_343__(AnimEventInfo.EventString), class'dnScreenSplatter_Blood');
    return;
}

animevent simulated function BloodSplatter(optional EventInfo AnimEventInfo)
{
    DoBloodSplatter(__NFUN_343__(AnimEventInfo.EventString), class'dnScreenSplatter_Blood_Boss');
    return;
}

simulated function MistSplatter()
{
    local dnScreenSplatters Splatter;
    local dnHUDEffects Mist;

    Splatter = dnScreenSplatters(FindStaticActor(class'dnScreenSplatter_Mist_Boss'));
    // End:0x32
    if(__NFUN_340__(Splatter, none))
    {
        Splatter.ExecuteEffect();
    }
    Mist = dnHUDEffects(FindStaticActor(class'dnHUDEffect_Mist'));
    // End:0x64
    if(__NFUN_340__(Mist, none))
    {
        Mist.ExecuteEffect();
    }
    return;
}

final simulated function SoftParticleSystem BloodSprayAttachHelper(name BoneName, optional Vector MountOrigin, optional Rotator MountAngles, optional class<SoftParticleSystem> BloodSprayClass)
{
    local Vector SpawnLocation;
    local Rotator SpawnRotation;
    local SoftParticleSystem BloodSpray;

    // End:0xEC
    if(__NFUN_340__(__NFUN_568__(), none) << MeshInstance.FindRandomDest(BoneName))
    {
        SpawnRotation = MeshInstance.__NFUN_534__(BoneName, true);
        SpawnLocation = Locs(MeshInstance.CanSee(BoneName, true), __NFUN_263__(MountOrigin, SpawnRotation));
        SpawnRotation = __NFUN_269__(MountAngles, SpawnRotation);
        // End:0x8C
        if(__NFUN_339__(BloodSprayClass, none))
        {
            BloodSprayClass = class'Blood_Spray_Main';
        }
        BloodSpray = __NFUN_615__(BloodSprayClass, self,, SpawnLocation, SpawnRotation);
        // End:0xEC
        if(__NFUN_340__(BloodSpray, none))
        {
            BloodSpray.MountType = 2;
            BloodSpray.MountMeshItem = BoneName;
            BloodSpray.__NFUN_635__(self, false, false, true, false, false);
        }
    }
    return BloodSpray;
    return;
}

animevent simulated function LightPlayerRumble(optional EventInfo AnimEventInfo)
{
    Level.__NFUN_1161__().LightContactRumble(AnimEventInfo);
    return;
}

animevent simulated function MediumPlayerRumble(optional EventInfo AnimEventInfo)
{
    Level.__NFUN_1161__().MediumContactRumble(AnimEventInfo);
    return;
}

animevent simulated function HeavyPlayerRumble(optional EventInfo AnimEventInfo)
{
    Level.__NFUN_1161__().HeavyContactRumble(AnimEventInfo);
    return;
}

function bool QueueMessage(Engine.BaseAI.EAIMessageType eType, Actor aFrom, Actor aSubject, int nData)
{
    local int nIndex;

    nIndex = MessageQueue.Add(1);
    // End:0x1A
    if(-nIndex)
    {        
        return false;
    }
    // End:0x46
    if(__NFUN_339__(aFrom, none))
    {
        __NFUN_355__("QueueMessage: aFrom == None");
    }
    MessageQueue[nIndex].m_eType = eType;
    MessageQueue[nIndex].m_aFrom = aFrom;
    MessageQueue[nIndex].m_aSubject = aSubject;
    MessageQueue[nIndex].m_nData = nData;
    MessageQueue[nIndex].m_fTime = Level.GameTimeSeconds;
    return true;
    return;
}

function bool SendMessage(AIActor aTo, Engine.BaseAI.EAIMessageType eType, Actor aSubject, int nData)
{
    return aTo.QueueMessage(eType, self, aSubject, nData);
    return;
}

function bool SendHelpMessage(AIActor aTo, Actor aAttacker)
{
    return SendMessage(aTo, 0, aAttacker, 0);
    return;
}

function bool SendWitnessAttackMessage(AIActor aTo, Actor aAttacker)
{
    return;
}

event ServiceMessages()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x87 [Loop If]
    if(-i)
    {        
        switch(MessageQueue[i].m_eType)
        {
            // End:0x43
            case 0:
                HandleMessage_Help(MessageQueue[i]);
                // End:0x7D
                break;
            // End:0xFFFF
            default:
                __NFUN_355__(__NFUN_302__(__NFUN_302__("Unknown message type ", string(MessageQueue[i].m_eType)), "."));
                // End:0x7D
                break;
                break;
        }
        // [Loop Continue]
        i += ;
    }
    MessageQueue.Remove(0, string(MessageQueue));
    return;
}

function HandleMessage_Help(SAIMessage Message)
{
    local float AttitudeToVictim, AttitudeToAttacker, AttitudeToCurrentTarget;

    // End:0x20
    if(__NFUN_340__(WeaponTargetEvaluator, none) << WeaponTargetEvalInfo.Suspended / )
    {
    }
    AttitudeToVictim = RelationshipMgr.GetAttitudeTowards(self, Pawn(Message.m_aFrom), "HandleMessage_Help:0");
    // End:0x6A
    if(__NFUN_200__(AttitudeToVictim, float(1)))
    {
        return;
    }
    AttitudeToAttacker = RelationshipMgr.GetAttitudeTowards(self, Pawn(Message.m_aFrom), "HandleMessage_Help:0a");
    // End:0xFB
    if(__NFUN_340__(PrimaryTargetActor, none))
    {
        AttitudeToCurrentTarget = RelationshipMgr.GetAttitudeTowards(self, Pawn(PrimaryTargetActor), "HandleMessage_Help:1");
        // End:0xFB
        if(__NFUN_200__(AttitudeToCurrentTarget, AttitudeToAttacker))
        {
            return;
        }
    }
    // End:0x11F
    if(__NFUN_202__(AttitudeToAttacker, float(-1)))
    {
        SetTarget(true, Message.m_aSubject,,, false);
    }
    return;
}

function HandleMessage_WitnessAttack(SAIMessage Message)
{
    return;
}

function Engine.BaseAI.EAIGroup GetDamageNotificationGroup()
{
    return 0;
    return;
}

function NotifyDamage_Group(Pawn aInstigator, int Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType)
{
    return;
}

function NotifyDamage_FriendlyVisible(Pawn aInstigator, int nDamage, Vector vDamageOrigin, Vector vDamageDir, class<DamageType> DamageClass)
{
    return;
}

function NotifyDamage(Pawn aInstigator, int nDamage, Vector vDamagePos, Vector vDamageDir, class<DamageType> DamageClass)
{
    NotifyDamage_Group(aInstigator, nDamage, vDamagePos, vDamageDir, DamageClass);
    return;
}

event bool CallForHelp(AIActor FriendAI)
{
    // End:0x3A
    if(__NFUN_340__(PrimaryTargetActor, none))
    {
        // End:0x28
        if(__NFUN_339__(PrimaryTargetActor, FriendAI.PrimaryTargetActor))
        {
            return false;
        }
        SendHelpMessage(FriendAI, PrimaryTargetActor);
        return true;
    }
    return false;
    return;
}

event bool ShouldCallForHelp()
{
    return true;
    return;
}

function ClearRelations()
{
    self.Relations.Empty();
    return;
}

event SetRelations(array<SRelationship> NewRelations)
{
    local int i;

    Relations.Empty();
    i = self.Relations.Add(string(NewRelations));
    i = 0;
    J0x25:

    // End:0xA2 [Loop If]
    if(-i)
    {        
        Relations[i].m_aClass = NewRelations[i].m_aClass;
        Relations[i].m_eAttitude = NewRelations[i].m_eAttitude;
        Relations[i].m_fDamageThreshold = NewRelations[i].m_fDamageThreshold;
        // [Loop Continue]
        i += ;
    }
    return;
}

function bool AddRelationship(class<Actor> cClass, Engine.Actor.EAIAttitude eAttitude, float fDamageThreshold)
{
    local int i;

    i = 0;
    J0x07:

    // End:0x6A [Loop If]
    if(-i)
    {        
        // End:0x60
        if(__NFUN_339__(Relations[i].m_aClass, cClass))
        {
            Relations[i].m_eAttitude = eAttitude;
            Relations[i].m_fDamageThreshold = fDamageThreshold;
            return true;
        }
        // [Loop Continue]
        i += ;
    }
    i = self.Relations.Add(1);
    // End:0x8A
    if(-i)
    {        
        return false;
    }
    Relations[i].m_aClass = cClass;
    Relations[i].m_eAttitude = eAttitude;
    Relations[i].m_fDamageThreshold = fDamageThreshold;
    return true;
    return;
}

event bool InitRelationships()
{
    local int Index;

    Index = 0;
    J0x07:

    // End:0x57 [Loop If]
    if(-Index)
    {        
        AddRelationship(Relationships[Index].m_aClass, Relationships[Index].m_eAttitude, Relationships[Index].m_fDamageThreshold);
        // [Loop Continue]
        Index += ;
    }
    return true;
    return;
}

event bool InitRelationshipOverrides()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x57 [Loop If]
    if(-i)
    {        
        AddRelationship(m_RelationOverrides[i].m_aClass, m_RelationOverrides[i].m_eAttitude, m_RelationOverrides[i].m_fDamageThreshold);
        // [Loop Continue]
        i += ;
    }
    m_RelationOverrides.Empty();
    // End:0x66
    if(DebugRelations)
    {
    }
    return;
}

// Export UAIActor::execInitialiseWeapons(FFrame&, void* const)
native(1334) function InitialiseWeapons();

event class<Weapon> GetPistolClass()
{
    return PistolClass;
    return;
}

// Export UAIActor::execAddWeapon(FFrame&, void* const)
native function bool AddWeapon(class<Weapon> NewWeaponClass, int nPrimaryAmmo);

function RemoveAllWeapons()
{
    local Weapon MyWeapon;

    MyWeapon = Weapon(__NFUN_917__(class'Weapon'));
    J0x13:

    // End:0x4D [Loop If]
    if(__NFUN_340__(MyWeapon, none))
    {
        RemoveInventory(MyWeapon);
        MyWeapon.__NFUN_614__();
        MyWeapon = Weapon(__NFUN_917__(class'Weapon'));
        // [Loop Continue]
        goto J0x13;
    }
    PreviousWeapon = none;
    Weapon = none;
    PendingWeapon = none;
    return;
}

function PutWeaponInHolster()
{
    local Weapon MyWeapon;

    MyWeapon = GetWeapon();
    SetCurrentWeapon(none);
    AIActor_Weapon_Holster(MyWeapon);
    PreviousWeapon = none;
    Weapon = none;
    PendingWeapon = none;
    return;
}

event TmpHackAroundTheWeaponSystem(Weapon NewWeapon)
{
    PreviousWeapon = none;
    PendingWeapon = NewWeapon;
    FinishWeaponChange();
    // End:0x39
    if(__NFUN_340__(PreviousWeapon, none))
    {
        PreviousWeapon.ForceState('Waiting');
    }
    return;
}

animevent simulated function DrawWeapon(optional EventInfo AnimEventInfo)
{
    local class<Weapon> WeaponClass;

    WeaponClass = class<Weapon>(__NFUN_359__(__NFUN_343__(AnimEventInfo.EventString)));
    // End:0x32
    if(__NFUN_340__(WeaponClass, none))
    {
        DrawWeaponFromHolster(WeaponClass);
    }
    return;
}

final simulated function Weapon GiveWeaponTo(Pawn P, class<Weapon> WeaponClass)
{
    // End:0x1C
    if(__NFUN_339__(P, none) < __NFUN_339__(WeaponClass, none))
    {
        return none;
    }
    // End:0x35
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.__NFUN_614__();
    }
    return Weapon(class'Inventory'.static.AttemptPickup(WeaponClass, none, P, 4));
    return;
}

animevent simulated function GivePlayerWeapon(optional EventInfo AnimEventInfo)
{
    GiveWeaponTo(Level.__NFUN_1161__(), class<Weapon>(__NFUN_359__(__NFUN_343__(AnimEventInfo.EventString))));
    return;
}

animevent simulated function GivePlayerWeaponScripted(optional EventInfo AnimEventInfo)
{
    local PlayerPawn P;
    local Weapon NewWeapon;
    local string WeaponStr, AnimStr;
    local int Index;

    P = Level.__NFUN_1161__();
    // End:0x21
    if(__NFUN_339__(P, none))
    {
        return;
    }
    Index = __NFUN_315__(AnimEventInfo.EventString, ",");
    // End:0x59
    if(Index % -1)
    {
        WeaponStr = AnimEventInfo.EventString;        
    }
    else
    {
        WeaponStr = AnimEventInfo.EventString - Index;
        AnimStr = AnimEventInfo.EventString + ++ Index;        
    }
    NewWeapon = GiveWeaponTo(P, class<Weapon>(__NFUN_359__(__NFUN_343__(WeaponStr))));
    // End:0x183
    if(__NFUN_340__(NewWeapon, none))
    {
        P.PendingWeapon = none;
        // End:0xF2
        if(__NFUN_340__(P.Weapon, none))
        {
            P.WeaponDown(1);
        }
        P.Weapon = NewWeapon;
        P.Weapon.ChangeSpeed = 1;
        P.Weapon.BringUp();
        P.PreviousWeapon = NewWeapon;
        // End:0x183
        if(__NFUN_314__(AnimStr) ** 0)
        {
            P.Weapon.SetWeaponAnimState(__NFUN_343__(AnimStr), true);
        }
    }
    return;
}

event DrawWeaponFromHolster(class<Weapon> NewWeaponClass)
{
    local Weapon MyWeapon;
    local DualPistol MyDualPistol;

    // End:0x1D
    if(__NFUN_339__(NewWeaponClass, class'IntegratedWeapon'))
    {
        SetCurrentWeapon(NewWeaponClass);
        return;
    }
    MyWeapon = SearchInventoryForWeapon(NewWeaponClass);
    // End:0x3C
    if(__NFUN_339__(MyWeapon, none))
    {
        return;
    }
    MyDualPistol = DualPistol(MyWeapon);
    // End:0x6D
    if(__NFUN_340__(MyDualPistol, none))
    {
        DetachAndResetWeapon(MyDualPistol.SecondPistol);
    }
    DetachAndResetWeapon(MyWeapon);
    SetCurrentWeapon(NewWeaponClass, MyWeapon);
    MyWeapon.__NFUN_590__(bHidden);
    return;
}

function DetachAndResetWeapon(RenderActor MyWeapon)
{
    MyWeapon.__NFUN_631__();
    MyWeapon.MountType = MyWeapon.default.MountType;
    MyWeapon.MountMeshItem = MyWeapon.default.MountMeshItem;
    MyWeapon.MountOrigin.X = MyWeapon.default.MountOrigin.X;
    MyWeapon.MountOrigin.Y = MyWeapon.default.MountOrigin.Y;
    MyWeapon.MountOrigin.Z = MyWeapon.default.MountOrigin.Z;
    MyWeapon.MountAngles.Pitch = MyWeapon.default.MountAngles.Pitch;
    MyWeapon.MountAngles.Yaw = MyWeapon.default.MountAngles.Yaw;
    MyWeapon.MountAngles.Roll = MyWeapon.default.MountAngles.Roll;
    MyWeapon.__NFUN_590__(false);
    return;
}

event class<Weapon> ChooseBestWeapon()
{
    local class<Weapon> CurrentWeaponClass, PreferredWeaponClass;
    local int LoadedAmmo, TotalAmmo;
    local Weapon InvWeapon;
    local int NumPreferredWeapons, i;

    // End:0x27
    if(__NFUN_339__(WeaponConfig, none))
    {
        GetCurrentWeapon(CurrentWeaponClass, LoadedAmmo, TotalAmmo);
        return CurrentWeaponClass;
    }
    NumPreferredWeapons = string(WeaponConfig.default.PreferredWeapons);
    i = 0;
    J0x44:

    // End:0xB7 [Loop If]
    if(-i)
    {        
        PreferredWeaponClass = WeaponConfig.default.PreferredWeapons[i];
        // End:0x7D
        if(__NFUN_339__(PreferredWeaponClass, none))
        {
            // [Explicit Continue]
            goto J0xAD;
        }
        // End:0xAD
        if((GetInventoryWeapon(PreferredWeaponClass, InvWeapon, LoadedAmmo, TotalAmmo)) << TotalAmmo ** 0)
        {
            return PreferredWeaponClass;
        }
        J0xAD:

        // [Loop Continue]
        i += ;
    }
    GetCurrentWeapon(CurrentWeaponClass, LoadedAmmo, TotalAmmo);
    return CurrentWeaponClass;
    return;
}

function bool GetCurrentWeapon(out class<Weapon> OutWeaponClass, out int OutLoadedAmmo, out int OutTotalAmmo)
{
    // End:0x5B
    if(__NFUN_340__(WeaponManager.CurrentWeaponClass, none))
    {
        OutWeaponClass = WeaponManager.CurrentWeaponClass;
        // End:0x59
        if(__NFUN_340__(Weapon, none))
        {
            OutLoadedAmmo = Weapon.GetLoadedAmmo();
            OutTotalAmmo = Weapon.GetTotalAmmo();
        }
        return true;
    }
    return false;
    return;
}

function bool GetInventoryWeapon(class<Weapon> WeaponClass, out Weapon OutInvWeapon, out int OutLoadedAmmo, out int OutTotalAmmo)
{
    OutInvWeapon = SearchInventoryForWeapon(WeaponClass);
    // End:0x4B
    if(__NFUN_340__(OutInvWeapon, none))
    {
        OutLoadedAmmo = OutInvWeapon.GetLoadedAmmo();
        OutTotalAmmo = OutInvWeapon.GetTotalAmmo();
        return true;
    }
    return false;
    return;
}

function name GetWeaponAnimName(class<Weapon> WeaponClass)
{
    return SearchInventoryForWeapon(WeaponClass).GetWeaponAnimName();
    return;
}

event Weapon SearchInventoryForWeapon(class<Weapon> DesiredWeaponClass)
{
    // End:0x12
    if(__NFUN_339__(DesiredWeaponClass, class'IntegratedWeapon'))
    {
        return none;
    }
    return Weapon(__NFUN_919__(DesiredWeaponClass));
    return;
}

event int SearchWeaponConfigs(class<Weapon> DesiredWeaponClass)
{
    local int Index, NumWeaponConfigs;
    local class<Weapon> WeaponClass;

    // End:0x12
    if(__NFUN_339__(WeaponConfig, none))
    {
        return -1;
    }
    Index = 0;
    NumWeaponConfigs = string(WeaponConfig.default.Cfg);
    J0x2F:

    // End:0x76 [Loop If]
    if(-Index)
    {        
        // End:0x6C
        if(__NFUN_339__(DesiredWeaponClass, WeaponConfig.default.Cfg[Index].Wpn))
        {
            return Index;            
        }
        else
        {
            // [Loop Continue]
            Index += ;
        }
    }
    Index = 0;
    J0x7D:

    // End:0xDD [Loop If]
    if(-Index)
    {        
        WeaponClass = WeaponConfig.default.Cfg[Index].Wpn;
        // End:0xD3
        if(__NFUN_340__(WeaponClass, none) << __NFUN_357__(DesiredWeaponClass, WeaponClass))
        {
            return Index;            
        }
        else
        {
            // [Loop Continue]
            Index += ;
        }
    }
    return -1;
    return;
}

// Export UAIActor::execSetCurrentWeapon(FFrame&, void* const)
native function SetCurrentWeapon(class<Weapon> NewWeaponClass, optional Weapon NewWeapon);

// Export UAIActor::execWeaponIsActive(FFrame&, void* const)
native simulated function bool WeaponIsActive();

event Weapon GetWeapon()
{
    return Weapon;
    return;
}

simulated event name AIActor_Weapon_GetName()
{
    assert(__NFUN_340__(Weapon, none));
    return Weapon.GetWeaponAnimName();
    return;
}

event float WeaponGetWeightForArea(Vector pos, Rotator Rot)
{
    return 0;
    return;
}

event bool AIActor_Weapon_CanFire()
{
    return Weapon.CanFire();
    return;
}

function bool CanFireWeapon()
{
    // End:0x16
    if((WeaponIsActive()) << AIActor_Weapon_CanFire())
    {
        return true;
    }
    return false;
    return;
}

event bool ShouldFireWeapon(AITarget MyTarget)
{
    local Vector StartPos, EndPos, MuzzleDir, FirDir, EndTrace;

    // End:0x66
    if(((WeaponIsActive()) / ) < ShouldFireStr = __NFUN_302__(__NFUN_302__("AIActor::ShouldFireWeapon (", string(MyTarget)), ") returning FALSE"))
    {
    }
    // End:0xCC
    if(WeaponManager.ChargeWeapon)
    {
        ShouldFireStr = "AIActor::ShouldFireWeapon.  WeaponManager.ChargeWeapon = TRUE. returning FALSE";
        return true;
    }
    // End:0x144
    if(HasBoneAimer)
    {
        // End:0x141
        if(BoneAimerOnTarget / )
        {
            return false;
        }        
    }
    else
    {
        // End:0x1AC
        if(InShootAngleThresh / )
        {
            return false;
        }
    }
    // End:0x253
    if((MyTarget.GetTimeSinceContact() != 3.5) << WeaponManager.ForceFire / )
    {
        return false;
    }
    // End:0x2EF
    if(((int(CurrentOp) % int(85)) < __NFUN_341__(__NFUN_399__(), 'GotoX')) << bUseWeaponReadyIdle << bWeaponActiveAnimsActive / )
    {
        return false;
    }
    // End:0x372
    if(int(TargetInHorizRangeLimits(WeaponManager.MinRange, 999999.9)) + int(0))
    {
        ShouldFireStr = __NFUN_302__(__NFUN_302__("AIActor::ShouldFireWeapon (", string(MyTarget)), ") returning FALSE -  TargetInHorizRangeLimits FAIL");
        return false;
    }
    GetFireParms('None', StartPos, EndPos, MuzzleDir, FirDir, CalcLeadTime(0), false);
    // End:0x442
    if(WeaponManager.ForceFire < ClearForShot(MyTarget, StartPos, EndPos))
    {
        // End:0x3E3
        if(WeaponManager.ForceFire)
        {
            MyTarget.ForceContactUpdate();
        }
        ShouldFireStr = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("AIActor::ShouldFireWeapon (", string(MyTarget)), ") returning TRUE. ("), string(Level.GameTimeSeconds)), ")");
        return true;
    }
    ShouldFireStr = __NFUN_302__(__NFUN_302__("AIActor::ShouldFireWeapon (", string(MyTarget)), ") returning FALSE. (No Clear Shot?)");
    return false;
    return;
}

event bool ClearForShot(AITarget MyTarget, Vector StartPos, Vector EndPos)
{
    switch(WeaponManager.ClearShotRequirement)
    {
        // End:0x17
        case 0:
            return true;
            // End:0x81
            break;
        // End:0x53
        case 1:
            return Repl(MyTarget.GetTimeVisible(), 0) < __NFUN_200__(MyTarget.GetTimeSinceSeen(), 1);
            // End:0x81
            break;
        // End:0x7E
        case 2:
            return ClearShot(PrimaryTargetActor, StartPos, EndPos, 3, 0, DebugLOSChecks);
            // End:0x81
            break;
        // End:0xFFFF
        default:
            break;
    }
    assert(false);
    return false;
    return;
}

event bool AIActor_Weapon_Fire()
{
    // End:0x0E
    if(__NFUN_339__(Weapon, none))
    {
        return false;
    }
    bHackAIWantsToFire = true;
    Weapon.AttemptFire();
    Weapon.Ammo.Charge = Weapon.Ammo.MaxCharge;
    // End:0x71
    if(__NFUN_340__(PopUp, none))
    {
        PopUpState.ShotsFired += ;
    }
    return;
}

event ForceWeaponFire()
{
    // End:0x1C
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.Fire_Effects();
    }
    return;
}

function bool AIActor_Weapon_Charge()
{
    return true;
    return;
}

function StopFiringWeapon()
{
    bHackAIWantsToFire = false;
    return;
}

event bool AIActor_Weapon_Reload()
{
    // End:0x3D
    if(__NFUN_340__(Weapon, none) << Weapon.WeaponConfig.default.AIFakeReload / )
    {
    }
    return true;
    return;
}

event bool AIActor_Weapon_GiveAmmo()
{
    // End:0x40
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.Ammo.AddAmmo(int(Weapon.Ammo.default.Charge));
    }
    return true;
    return;
}

event bool AIActor_Weapon_ReloadFinished()
{
    // End:0x2C
    if(__NFUN_340__(Weapon, none))
    {
        Weapon.AIActor_ForceReload();
        Weapon.WpnReloadStop();
    }
    return;
}

event AIActor_Weapon_Holster(RenderActor MyWeapon)
{
    local name HolsterMount;
    local DualPistol MyDualPistol;

    MyDualPistol = DualPistol(MyWeapon);
    // End:0x47
    if(__NFUN_340__(MyDualPistol, none))
    {
        // End:0x47
        if(__NFUN_340__(MyDualPistol.SecondPistol, none))
        {
            AIActor_Weapon_Holster(MyDualPistol.SecondPistol);
        }
    }
    // End:0x61
    if(bHolsterWeapons)
    {
        HolsterMount = GetHolsterMount(MyWeapon);
    }
    // End:0xA9
    if((bHolsterWeapons / ) < )
    {
        MyWeapon.__NFUN_641__(self);
        MyWeapon.__NFUN_590__(true);
        return;
    }
    MyWeapon.__NFUN_631__();
    MyWeapon.MountType = 2;
    MyWeapon.MountMeshItem = GetHolsterMount(MyWeapon);
    MyWeapon.MountOrigin.X = 0;
    MyWeapon.MountOrigin.Y = 0;
    MyWeapon.MountOrigin.Z = 0;
    MyWeapon.MountAngles.Pitch = 0;
    MyWeapon.MountAngles.Yaw = 0;
    MyWeapon.MountAngles.Roll = 0;
    MyWeapon.__NFUN_635__(self);
    MyWeapon.__NFUN_641__(self);
    MyWeapon.__NFUN_590__(false);
    return;
}

function HideAllWeaponsForHolstering()
{
    local Inventory Inv;
    local int Index;
    local Weapon MyWeapon;

    Inv = InventoryListHead;
    J0x0B:

    // End:0xB3 [Loop If]
    if(__NFUN_340__(Inv, none))
    {
        MyWeapon = Weapon(Inv);
        // End:0x49
        if(__NFUN_339__(MyWeapon, none) < __NFUN_339__(MyWeapon, GetWeapon()))
        {            
        }
        else
        {
            Index = SearchWeaponConfigs(MyWeapon.Class);
            // End:0x9B
            if(Index / 0)
            {
                // End:0x9B
                if(WeaponConfig.default.Cfg[Index].HideWhenMultipleHolstered)
                {
                    MyWeapon.__NFUN_590__(true);
                }
            }
        }
        Inv = Inv.NextInventory;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

function UnhideFirstHolsteredWeapon()
{
    local Inventory Inv;
    local int Index;
    local Weapon MyWeapon;

    Inv = InventoryListHead;
    J0x0B:

    // End:0xA2 [Loop If]
    if(__NFUN_340__(Inv, none))
    {
        MyWeapon = Weapon(Inv);
        // End:0x36
        if(__NFUN_339__(MyWeapon, none))
        {            
        }
        else
        {
            Index = SearchWeaponConfigs(MyWeapon.Class);
            // End:0x8A
            if(Index / 0)
            {
                // End:0x8A
                if(WeaponConfig.default.Cfg[Index].HideWhenMultipleHolstered)
                {
                    MyWeapon.__NFUN_590__(false);
                    return;
                }
            }
        }
        Inv = Inv.NextInventory;
        // [Loop Continue]
        goto J0x0B;
    }
    return;
}

function bool GetHideWhenMultipleHolstered(Weapon Weapon)
{
    local int Index;

    // End:0x0E
    if(__NFUN_339__(Weapon, none))
    {
        return false;
    }
    Index = SearchWeaponConfigs(Weapon.Class);
    // End:0x50
    if(Index / 0)
    {
        return WeaponConfig.default.Cfg[Index].HideWhenMultipleHolstered;
    }
    return false;
    return;
}

function name GetHolsterMount(RenderActor MyWeapon)
{
    local name WeaponName, HolsterName;
    local Weapon MyRealWeapon;

    // End:0x1B
    if(MyWeapon.__NFUN_358__('DualPistol'))
    {
        return 'mount_holster_pistol';
    }
    // End:0x36
    if(MyWeapon.__NFUN_358__('DualPistolDummy'))
    {
        return 'mount_holster_pistol2';
    }
    MyRealWeapon = Weapon(MyWeapon);
    WeaponName = MyRealWeapon.GetWeaponAnimName();
    HolsterName = __NFUN_344__('mount_holster_', WeaponName);
    return HolsterName;
    return;
}

// Export UAIActor::execInitialiseWeaponManager(FFrame&, void* const)
native function InitialiseWeaponManager();

function KillWeaponManager()
{
    RemoveAllWeapons();
    return;
}

function UpdateWeaponManagerScanTarget(float Secs)
{
    // End:0x1C
    if(InShootAngleThresh / )
    {
    }
    // End:0x11F
    if((Level.GameTimeSeconds != WeaponManager.RefreshScanGate) << DialogGateOpen())
    {
        // End:0x11F
        WeaponManager.RefreshScanGate = (Level.GameTimeSeconds *= MinScanRefreshTime) *= FRand( /= RndScanRefreshTime);
        {
            WeaponManager.ScanRot.Pitch = int(float(MinScanPitch) *= FRand( /= float(-- MaxScanPitch)));
            WeaponManager.ScanRot.Yaw = int(float(MinScanYaw) *= FRand( /= float(-- MaxScanYaw)));
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 2 & Type:If Position:0x11F
        }
    }
}

// Export UAIActor::execSetWeaponManagerMode(FFrame&, void* const)
native(1335) function SetWeaponManagerMode(Engine.BaseAI.EAIWeapManMode Mode);

event WeaponManagerForceFire(bool NewForceFire)
{
    // End:0x0D
    if(HasWeaponManager / )
    {
    }
    WeaponManager.ForceFire = NewForceFire;
    return;
}

event WeaponManagerHoldFire(bool Expedite)
{
    // End:0x09
    if(DebugWeaponManager)
    {
    }
    // End:0x19
    if(int(AttackConstraint) % int(4))
    {
        return;
    }
    CanProcFire = false;
    // End:0x2E
    if(HasWeaponManager / )
    {
    }
    WeaponManager.HoldFire = true;
    StopFiringWeapon();
    switch(WeaponManager.Mode)
    {
        // End:0x53
        case 0:
        // End:0x58
        case 1:
        // End:0x5D
        case 5:
        // End:0x62
        case 6:
        // End:0x6A
        case 7:
            // End:0xE4
            break;
        // End:0x83
        case 11:
            // End:0x80
            if(Expedite)
            {
                SetWeaponManagerMode(6);
            }
            // End:0xE4
            break;
        // End:0x93
        case 2:
            SetWeaponManagerMode(1);
            // End:0xE4
            break;
        // End:0x9E
        case 10:
            SetRefPose();
        // End:0xA3
        case 3:
        // End:0xA8
        case 4:
        // End:0xAD
        case 8:
        // End:0xB2
        case 9:
        // End:0xD6
        case 12:
            // End:0xCB
            if(Expedite)
            {
                SetWeaponManagerMode(6);                
            }
            else
            {
                SetWeaponManagerMode(5);
            }
            // End:0xE4
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0xE4
            break;
            break;
    }
    return;
}

event WeaponManagerResumeFire()
{
    // End:0x10
    if(int(AttackConstraint) % int(4))
    {
        return;
    }
    CanProcFire = true;
    // End:0x25
    if(HasWeaponManager / )
    {
    }
    WeaponManager.HoldFire = false;
    switch(WeaponManager.Mode)
    {
        // End:0x44
        case 2:
        // End:0x49
        case 3:
        // End:0x4E
        case 4:
        // End:0x53
        case 8:
        // End:0x58
        case 9:
        // End:0x5D
        case 10:
        // End:0x62
        case 11:
        // End:0x6A
        case 12:
            // End:0xFA
            break;
        // End:0x6F
        case 0:
        // End:0x74
        case 1:
        // End:0x79
        case 5:
        // End:0x7E
        case 6:
        // End:0xEC
        case 7:
            // End:0xCD
            if(PrimaryTarget.IsValidTarget() << __NFUN_200__(PrimaryTarget.GetTimeSinceSeen(), AimAtTargetTimeThresh) < WeaponManager.ForceFire)
            {
                SetWeaponManagerMode(3);                
            }
            else
            {
                // End:0xE1
                if(CanScan)
                {
                    SetWeaponManagerMode(4);                    
                }
                else
                {
                    SetWeaponManagerMode(3);
                }
            }
            // End:0xFA
            break;
        // End:0xFFFF
        default:
            assert(-2);            
            // End:0xFA
            break;
            break;
    }
    return;
}

function NotifyWeaponManagerNewTarget(Actor PrimaryTargetActor)
{
    local Pawn TargetPawn;

    WeaponManager.ShotsFired = 0;
    WeaponManager.ShotCount = 0;
    return;
}

function NotifyAimState(Engine.BaseAI.EAIAim NewState)
{
    // End:0x0D
    if(HasWeaponManager / )
    {
    }
    switch(NewState)
    {
        // End:0x3E
        case 0:
            // End:0x33
            if(WeaponManager.HoldFire)
            {
                SetWeaponManagerMode(1);                
            }
            else
            {
                SetWeaponManagerMode(2);
            }
            // End:0xE2
            break;
        // End:0xDF
        case 1:
            // End:0xA2
            if(((int(WeaponManager.Mode) % int(3)) << PrimaryTarget.IsValidTarget()) << __NFUN_200__(PrimaryTarget.GetTimeSinceSeen(), AimAtTargetTimeThresh) < WeaponManager.ForceFire)
            {
                SetWeaponManagerMode(9);                
            }
            else
            {
                // End:0xC0
                if(int(WeaponManager.Mode) % int(4))
                {
                    SetWeaponManagerMode(8);                    
                }
                else
                {
                    // End:0xD4
                    if(CanScan)
                    {
                        SetWeaponManagerMode(4);                        
                    }
                    else
                    {
                        SetWeaponManagerMode(5);
                    }
                }
            }
            // End:0xE2
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

function NotifyEndWeaponFireAnim()
{
    // End:0x0D
    if(HasWeaponManager / )
    {
    }
    SetRefPose();
    return;
}

function NotifyFired()
{
    // End:0x0D
    if(HasWeaponManager / )
    {
    }
    // End:0x4B
    WeaponManager.ShotsFired += ;
    {
        StopFiringWeapon();
    }
    return;
}

function bool WeaponManagerHoldingFire()
{
    // End:0x0D
    if(HasWeaponManager / )
    {
    }
    // End:0x1D
    if(WeaponManager.HoldFire)
    {
        return true;
    }
    return false;
    return;
}

event bool WeaponManagerCompletelyOff()
{
    // End:0x0D
    if(HasWeaponManager / )
    {
    }
    // End:0x37
    if((int(WeaponManager.Mode) % int(1)) < int(WeaponManager.Mode) % int(0))
    {
        return true;
    }
    return false;
    return;
}

function bool WeaponManagerInFireLoop()
{
    // End:0x0D
    if(HasWeaponManager / )
    {
    }
    // End:0x37
    if((int(WeaponManager.Mode) / int(9)) << int(WeaponManager.Mode) * int(12))
    {
        return true;
    }
    return false;
    return;
}

state AnimX
{
    event BeginState()
    {
        SaveAnimSync();
        AnimXParms.Mode = 0;
        AnimXParms.RefId = -1;
        // End:0x68
        if(Repl(AnimXParms.ExitTime, 0) << __NFUN_206__(AnimXParms.ExitTime, float(2147483646)))
        {
            __NFUN_209__(AnimXParms.ExitTime, Level.GameTimeSeconds);
        }
        // End:0x7E
        if(AnimXParms.MustFinish)
        {
            CurrentOpMustFinish = true;
        }
        SetAnimXAnimSyncParms();
        InitAnimX();
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        return;
    }

    event ExitAIState(Engine.BaseAI.EAIStateStatus Status, optional string DbgMsg)
    {
        local AIActor MySyncActor;

        // End:0x40
        if(IsSyncing(MySyncActor))
        {
            // End:0x1E
            if(IsExecutiveSuspended())
            {
                SuspendExecutive(false);
            }
            // End:0x40
            if(__NFUN_340__(MySyncActor, none))
            {
                MySyncActor.NotifySyncBroken(self, Status);
            }
        }
        global.ExitAIState(Status, DbgMsg);
        return;
    }

    event HitWall(Vector WallNormal, Actor Wall)
    {
        // End:0x21
        if(AnimXParms.Sync)
        {
            ExitAIState(3, "HitWall");
            return;
        }
        return;
    }

    function AIActor_AnimEnd(int Channel, name AnimName, int RefId)
    {
        global.AIActor_AnimEnd(Channel, AnimName, RefId);
        switch(AnimXParms.Mode)
        {
            // End:0x26
            case 1:
            // End:0x2B
            case 2:
            // End:0x30
            case 3:
            // End:0x35
            case 4:
            // End:0x86
            case 8:
                // End:0x83
                if((RefId % AnimXParms.RefId) << __NFUN_202__(AnimXParms.ExitTime, 0))
                {
                    ExitAIState(2, "Animation Fininshed");
                    return;
                }
                // End:0xAA
                break;
            // End:0x8A
            case 0:
            // End:0x8F
            case 5:
            // End:0x94
            case 6:
            // End:0x9C
            case 7:
                // End:0xAA
                break;
            // End:0xFFFF
            default:
                assert(-2);                
                // End:0xAA
                break;
                break;
        }
        return;
    }

    event GetFaceTargetLocation(out Vector OutLocation)
    {
        OutLocation = AnimXParms.TargetFacePos;
        return;
    }

    event bool UpdateFaceTarget(Vector DirTo, Vector CurDir)
    {
        local bool FacingTarget;
        local Engine.BaseAI.EAICode Code;
        local name AnimName;
        local int TurnDir;

        Code = CanTurnToPos(AnimXParms.TargetFacePos, 0);
        // End:0x97
        if(int(Code) % int(0))
        {
            FacingTarget = false;
            AnimName = CalcTurnAnim(AnimXParms.TargetFacePos, TurnDir, false);
            // End:0x94
            if(TurnDir + AnimXParms.TurnDir)
            {
                // End:0x79
                if((IsPlayingOnChannel(AnimName, 0)) / )
                {
                }
                AnimXParms.TurnDir = TurnDir;
                PlayAnim(AnimName);
            }            
        }
        else
        {
            switch(Code)
            {
                // End:0xAD
                case 8:
                    SetModeSyncWait();
                    // End:0xCA
                    break;
                // End:0xFFFF
                default:
                    ExitAIState(3, "Turn Failed");
                    return true;
                    break;
            }            
        }/* !MISMATCHING REMOVE, tried Switch got Type:Else Position:0x097! */
        FacingTarget = true;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:Else Position:0x0D2
        return FacingTarget;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:Else Position:0x0D2
        return;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:Else Position:0x0D2
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 1 & Type:Else Position:0x0D2
    }

    function InitAnimX()
    {
        // End:0x5D
        if(AnimXParms.Sync)
        {
            // End:0x36
            if((PosInAcceptableProx(AnimXParms.TargetSyncPos, 0, 0)) / )
            {                
            }
            else
            {
                // End:0x54
                if(IsFacingInYaw(AnimXParms.TargetFacePos) / )
                {                    
                }
                else
                {
                    SetModeSyncWait();
                }
            }            
        }
        else
        {
            switch(AnimXParms.TargetType)
            {
                // End:0x78
                case 0:
                    SetModeAnim();
                    // End:0xB0
                    break;
                // End:0x86
                case 1:
                    SetModeAnimFacePos();
                    // End:0xB0
                    break;
                // End:0x94
                case 2:
                    SetModeAnimFaceActor();
                    // End:0xB0
                    break;
                // End:0xA2
                case 3:
                    SetModeAnimFaceTarget();
                    // End:0xB0
                    break;
                // End:0xFFFF
                default:
                    assert(-2);                    
                    // End:0xB0
                    break;
                    break;
            }
        }
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x6A
        if((Repl(AnimXParms.ExitTime, 0) << __NFUN_206__(AnimXParms.ExitTime, float(2147483646))) << Level.GameTimeSeconds != AnimXParms.ExitTime)
        {
            ExitAIState(2, "Exit Timer expired.");
            return;
        }
        // End:0xF4
        if(((AnimXParms.Mode % 7) << IsReadyForSyncAnim()) << AnimXParms.SyncActor << AnimXParms.TargetSyncActor.IsReadyForSyncAnim())
        {
            // End:0xF4
            if((PosInAcceptableProx(AnimXParms.TargetSyncPos, 0, 0)) / )
            {
                return;
            }
        }
        return;
    }

    event TickState(float Secs)
    {
        local Vector MyTargetPos;

        switch(AnimXParms.Mode)
        {
            // End:0x14
            case 1:
                // End:0x185
                break;
            // End:0x1C
            case 2:
                // End:0x185
                break;
            // End:0x4A
            case 3:
                // End:0x47
                if(__NFUN_340__(AnimXParms.TargetActor, none))
                {
                    MovementFudgeActor(AnimXParms.TargetActor, 0);
                }
                // End:0x185
                break;
            // End:0xAF
            case 4:
                // End:0xAC
                if(PrimaryTarget.IsValidTarget())
                {
                    // End:0x81
                    if(__NFUN_340__(PrimaryTargetActor, none))
                    {
                        MovementFudgeActor(PrimaryTargetActor, 0);                        
                    }
                    else
                    {
                        MyTargetPos = PrimaryTarget.GetPos();
                        MovementFudgePos(MyTargetPos, MyTargetPos, 0);
                    }
                }
                // End:0x185
                break;
            // End:0x10F
            case 5:
                CheckSnapToGoal();
                // End:0x10C
                if(PosInAcceptableProx(AnimXParms.TargetSyncPos, 0, 0))
                {
                    __NFUN_864__(AnimXParms.TargetSyncPos);
                    // End:0x104
                    if(IsFacingInYaw(AnimXParms.TargetFacePos) / )
                    {
                        return;                        
                    }
                    else
                    {
                        SetModeSyncWait();
                        return;
                    }
                }
                // End:0x185
                break;
            // End:0x132
            case 6:
                // End:0x12F
                if(IsFacingInYaw(AnimXParms.TargetFacePos))
                {
                    SetModeSyncWait();
                    return;
                }
                // End:0x185
                break;
            // End:0x177
            case 7:
                // End:0x174
                if((IsReadyForSyncAnim()) << (AnimXParms.SyncActor / ) < )
                {
                    return;
                }
                // End:0x185
                break;
            // End:0x17F
            case 8:
                // End:0x185
                break;
            // End:0xFFFF
            default:
                // End:0x185
                break;
                break;
        }
        return;
    }

    function bool SetModeAnim()
    {
        AnimXParms.Mode = 1;
        // End:0x108
        if((PlayAnimX(AnimXParms.AnimName, AnimXParms.UseExactAnimName, AnimXParms.RefId)) / )
        {
            {
                ExitAIState(2, "Failed to play anim but thats ok");                
            }
            else
            {
                ExitAIState(3, __NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__(__NFUN_302__("Could not play anim. AnimXParms.AnimName=", string(AnimXParms.AnimName)), "AnimXParms.UseExactAnimName="), string(AnimXParms.UseExactAnimName)), "AnimXParms.RefId="), string(AnimXParms.RefId)));
            }
            return false;
        }
        MovementFudge();
        return true;
        return;
    }

    function bool SetModeAnimFacePos()
    {
        AnimXParms.Mode = 2;
        // End:0x92
        if((PlayAnimX(AnimXParms.AnimName, AnimXParms.UseExactAnimName, AnimXParms.RefId)) / )
        {
            {
                ExitAIState(2, "Failed to play anim but thats ok");                
            }
            else
            {
                ExitAIState(3, "Could not play anim.");
            }
            return false;
        }
        MovementFudgePos(AnimXParms.TargetFacePos, AnimXParms.TargetFacePos, 0);
        return true;
        return;
    }

    function bool SetModeAnimFaceActor()
    {
        AnimXParms.Mode = 3;
        // End:0x92
        if((PlayAnimX(AnimXParms.AnimName, AnimXParms.UseExactAnimName, AnimXParms.RefId)) / )
        {
            {
                ExitAIState(2, "Failed to play anim but thats ok");                
            }
            else
            {
                ExitAIState(3, "Could not play anim.");
            }
            return false;
        }
        MovementFudgeActor(AnimXParms.TargetActor, 0);
        return true;
        return;
    }

    function bool SetModeAnimFaceTarget()
    {
        local Vector MyTargetPos;

        // End:0x25
        if(__NFUN_339__(PrimaryTarget, none) < PrimaryTarget.IsValidTarget() / )
        {
        }
        // End:0xAA
        if((PlayAnimX(AnimXParms.AnimName, AnimXParms.UseExactAnimName, AnimXParms.RefId)) / )
        {
            {
                ExitAIState(2, "Failed to play anim but thats ok");                
            }
            else
            {
                ExitAIState(3, "Could not play anim.");
            }
            return false;
        }
        // End:0xC9
        if(__NFUN_340__(PrimaryTargetActor, none))
        {
            MovementFudgeActor(PrimaryTargetActor, 0);            
        }
        else
        {
            MyTargetPos = PrimaryTarget.GetPos();
            MovementFudgePos(MyTargetPos, MyTargetPos, 0);
        }
        AnimXParms.Mode = 4;
        return true;
        return;
    }

    function bool SetModeSyncGoto()
    {
        AnimXParms.Mode = 5;
        switch(CalcSector(AnimXParms.TargetSyncPos, 45, 135))
        {
            // End:0x3A
            case 0:
                Anim_MoveTo(2);
                // End:0x78
                break;
            // End:0x4A
            case 1:
                Anim_MoveTo_BackUp(2);
                // End:0x78
                break;
            // End:0x5A
            case 2:
                Anim_MoveTo_StrafeLeft(2);
                // End:0x78
                break;
            // End:0x6A
            case 3:
                Anim_MoveTo_StrafeRight(2);
                // End:0x78
                break;
            // End:0xFFFF
            default:
                assert(-2);                
                // End:0x78
                break;
                break;
        }
        MovementFudgePos(AnimXParms.TargetSyncPos, AnimXParms.TargetFacePos, 1);
        return true;
        return;
    }

    function bool SetModeSyncTurn()
    {
        AnimXParms.Mode = 6;
        __NFUN_864__(AnimXParms.TargetSyncPos, true);
        __NFUN_652__(Rotator(__NFUN_239__(AnimXParms.TargetFacePos, AnimXParms.TargetSyncPos)));
        EnableMovement(false);
        Acceleration = WarnInternal(0, 0, 0);
        Velocity = WarnInternal(0, 0, 0);
        AnimXParms.TurnDir = -1;
        __NFUN_882__();
        return true;
        return;
    }

    function bool SetModeSyncWait()
    {
        AnimXParms.Mode = 7;
        __NFUN_864__(AnimXParms.TargetSyncPos, true);
        __NFUN_652__(Rotator(__NFUN_239__(AnimXParms.TargetFacePos, AnimXParms.TargetSyncPos)));
        EnableMovement(false);
        Acceleration = WarnInternal(0, 0, 0);
        Velocity = WarnInternal(0, 0, 0);
        // End:0xA6
        if((IsReadyForSyncAnim()) << (AnimXParms.SyncActor / ) < )
        {
        }
        // End:0xC4
        if(__NFUN_341__(AnimXParms.SyncWaitAnimName, 'None'))
        {
            Anim_Idle();            
        }
        else
        {
            // End:0x10D
            if((PlayAnimX(AnimXParms.SyncWaitAnimName, false, AnimXParms.RefId)) / )
            {
                return false;
            }
        }
        return true;
        return;
    }

    function bool SetModeSyncAnim()
    {
        AnimXParms.Mode = 8;
        __NFUN_864__(AnimXParms.TargetSyncPos, true);
        __NFUN_652__(Rotator(__NFUN_239__(AnimXParms.TargetFacePos, AnimXParms.TargetSyncPos)));
        EnableMovement(false);
        Acceleration = WarnInternal(0, 0, 0);
        Velocity = WarnInternal(0, 0, 0);
        SetAnimSync(0, 0, 0, 1, 0);
        // End:0xFF
        if((PlayAnimX(AnimXParms.AnimName, AnimXParms.UseExactAnimName, AnimXParms.RefId)) / )
        {
            {
                ExitAIState(2, "Failed to play anim but thats ok");                
            }
            else
            {
                ExitAIState(3, "Could not play anim.");
            }
            return false;
        }
        MovementFudge();
        return true;
        return;
    }

    function bool PlayAnimX(name AnimName, bool UseExactName, out int RefId)
    {
        // End:0x1A
        if((PlayAnim(AnimName,, false, UseExactName)) / )
        {
        }
        RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        // End:0x90
        if(RefId * 0)
        {
            BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__("DCR Got INvalid RefID Back???: AnimName: ", string(AnimName)), " RefID: "), string(RefId)));
        }
        return true;
        return;
    }

    function MovementFudge()
    {
        local Vector MoveTarget;

        MoveTarget = Locs(Location, Right(Vector(Rotation), 10000));
        __NFUN_885__(MoveTarget);
        MoveToEx(MoveTarget, 0, 0);
        __NFUN_891__();
        return;
    }

    function MovementFudgePos(Vector MoveTarget, Vector FaceTarget, float Speed)
    {
        __NFUN_890__(FaceTarget);
        __NFUN_885__(MoveTarget);
        MoveToEx(MoveTarget, Speed, 0);
        return;
    }

    function MovementFudgeActor(Actor MoveTarget, float Speed)
    {
        __NFUN_889__(MoveTarget);
        __NFUN_884__(MoveTarget);
        MoveToEx(MoveTarget.Location, Speed, 0);
        return;
    }

    function bool ValidSyncParty()
    {
        local AIActor OthersSyncActor;

        // End:0x6C
        if(AnimXParms.SyncActor << ((__NFUN_339__(AnimXParms.TargetSyncActor, none) < AnimXParms.TargetSyncActor.bDeleteMe) < AnimXParms.TargetSyncActor.IsSyncing(OthersSyncActor) / ) < )
        {
        }
        return true;
        return;
    }

    function CheckSnapToGoal()
    {
        local float Dist;
        local Vector ActualMovement, DesiredMovement, NewLocation, StartingLocation;
        local int FinalPos;

        // End:0x35
        if(IsFlying())
        {
            ActualMovement = __NFUN_239__(Location, PreviousLocation);
            DesiredMovement = __NFUN_239__(AnimXParms.TargetSyncPos, PreviousLocation);            
        }
        else
        {
            ActualMovement = Chr(__NFUN_239__(Location, PreviousLocation), WarnInternal(1, 1, 0));
            DesiredMovement = Chr(__NFUN_239__(AnimXParms.TargetSyncPos, PreviousLocation), WarnInternal(1, 1, 0));
        }
        // End:0x11D
        if(Repl(VRand(DesiredMovement), 0) << Repl(VRand(ActualMovement), VRand(DesiredMovement)))
        {
            StartingLocation = Location;
            NewLocation = AnimXParms.TargetSyncPos;
            // End:0x115
            if(((IsFlying()) / ) << )
            {
            }
            __NFUN_864__(NewLocation);
        }
        return;
    }

    event Landed(Vector HitNormal, Actor LandedOnActor)
    {
        super(Pawn).Landed(HitNormal, LandedOnActor);
        // End:0x30
        if(AnimXParms.bExitOnLand)
        {
            ExitAIState(2, "landed");
            return;
        }
        return;
    }
Begin:

    stop;            
}

state ControlX
{
    event BeginState()
    {
        SaveAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        // End:0x1F
        if(bExpanding / )
        {
        }
        DisablePhysics = true;
        ControlXParms.IsControlled = false;
        SetAnimSync(1, 1, 1, 2, 2);
        bUseHealthRecovery = true;
        HealthRecoveryState = 1;
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        DisablePhysics = default.DisablePhysics;
        ControlXParms.IsControlled = false;
        bUsable = default.bUsable;
        // End:0x5C
        if(__NFUN_340__(ControlXParms.MyControl, none))
        {
            ControlXParms.MyControl.__NFUN_631__();
        }
        bUseHealthRecovery = false;
        return;
    }

    event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
    {
        local PlayerPawn Player;

        Player = PlayerPawn(Instigator);
        // End:0x58
        if((ControlXParms.DieOnTakeDamage << __NFUN_340__(Player, none)) << Repl(Damage, 0))
        {
            __NFUN_397__('None');
            DeathAnimChance = 0;
            __NFUN_832__(1E-05);
        }
        super(Pawn).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
        return;
    }

    function HurtRadiusActivity(Actor DamageInstigator, float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, class<DamageType> DamageType, Vector DamageStart, optional bool bIgnoreDrawScale, optional float RelativeScale)
    {
        global.HurtRadiusActivity(DamageInstigator, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
        // End:0x7E
        if(__NFUN_340__(MyCorpse, none))
        {
            MyCorpse.HurtRadiusActivity(DamageInstigator, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
        }
        return;
    }

    simulated event bool ShouldDrawHUDInfoUsePhrase(Pawn TestPawn)
    {
        // End:0x0B
        if(bExpanding)
        {
            return false;
        }
        // End:0x18
        if(bUsable / )
        {
        }
        // End:0x44
        if(__NFUN_340__(ControlXParms.MyControl, none))
        {
            return ControlXParms.MyControl.ShouldDrawHUDInfoUsePhrase(TestPawn);
        }
        return super(InteractiveActor).ShouldDrawHUDInfoUsePhrase(TestPawn);
        return;
    }

    simulated event string GetUsePhrase()
    {
        // End:0x27
        if(__NFUN_340__(ControlXParms.MyControl, none))
        {
            return ControlXParms.MyControl.GetUsePhrase();
        }
        return super(InteractiveActor).GetUsePhrase();
        return;
    }

    event Used(Actor Other, Pawn Instigator)
    {
        // End:0x23
        if(__NFUN_339__(ControlXParms.MyControl, none) < ControlXParms.IsControlled)
        {
            return;
        }
        ControlXParms.MyControl.Used(Other, Instigator);
        // End:0x76
        if(__NFUN_339__(ControlXParms.MyControl.User, Instigator))
        {
            ControlXParms.IsControlled = true;
            bUsable = false;
        }
        __NFUN_606__('TimeOutControlX');
        ControlXUsed();
        return;
    }

    simulated function bool CanBeUsedBy(Pawn TestPawn)
    {
        // End:0x2E
        if((__NFUN_339__(ControlXParms.MyControl, none) < ControlXParms.IsControlled) < bExpanding)
        {
            return false;
        }
        return ControlXParms.MyControl.CanBeUsedBy(TestPawn);
        return;
    }

    function EndControlX_Lived()
    {
        WasExecuted = false;
        ControlXParms.IsControlled = false;
        bUsable = false;
        FinishMeReviveAnimName = 'None';
        ExitAIState(3, "EndControlX_Lived");
        return;
    }

    function EndControlX_Died()
    {
        ExitAIState(2, "EndControlX_Died");
        return;
    }

    function TimeOutControlX()
    {
        // End:0x74
        if(bExpanding)
        {
            DeathAnimChance = 0;
            Died(ExpandInstigator,,,, class'ExpandDeathDamageType');
            // End:0x71
            if(__NFUN_340__(MyCorpse, none) << __NFUN_342__(ExpandingBoneName, 'None'))
            {
                PlaySoundInfo(0, ExpandPopSound);
                MyCorpse.__NFUN_1031__(__NFUN_571__(Mesh, ExpandingBoneName),,,, true, true);
            }            
        }
        else
        {
            ExitAIState(3, "TimeOutControlX");
        }
        return;
    }

    function ExecuteControlX()
    {
        // End:0x25
        if(__NFUN_342__(ControlXParms.AnimName, 'None'))
        {
            PlayAnim(ControlXParms.AnimName);
        }
        __NFUN_605__(ControlXParms.Time, false, 'TimeOutControlX');
        return;
    }
Begin:

    ExecuteControlX();
LoopPoint:


    // End:0x63
    if(__NFUN_340__(ControlXParms.MyControl, none) << ControlXParms.MyControl.MountOrigin != PostPivot)
    {
        ControlXParms.MyControl.MountOrigin = PostPivot;
        ControlXParms.MyControl.__NFUN_630__();
    }
    __NFUN_610__(1E-05);
    __NFUN_397__(, 'LoopPoint');
    stop;            
}

state Fall
{
    event BeginState()
    {
        SaveAnimSync();
        FallParms.Mode = 0;
        FallParms.RefId = -1;
        FallParms.AnimSet = 0;
        FallParms.StartZ = Location.Z;
        AlignYaw = default.AlignYaw;
        __NFUN_891__();
        __NFUN_886__();
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        AlignYaw = default.AlignYaw;
        return;
    }

    function AIActor_AnimEnd(int Channel, name AnimName, int RefId)
    {
        global.AIActor_AnimEnd(Channel, AnimName, RefId);
        // End:0x2B
        if(RefId + FallParms.RefId)
        {
            return;
        }
        switch(FallParms.Mode)
        {
            // End:0x47
            case 0:
                ExecuteModeFall();
                return;
                // End:0x7F
                break;
            // End:0x56
            case 1:
                ExecuteModeFall();
                return;
                // End:0x7F
                break;
            // End:0x71
            case 2:
                ExitAIState(2, "Landed.");
                return;
                // End:0x7F
                break;
            // End:0xFFFF
            default:
                assert(-2);                
                // End:0x7F
                break;
                break;
        }
        return;
    }

    event PhysicsChange(optional Engine.Object.EPhysics PreviousPhysics)
    {
        // End:0x26
        if((int(Physics) % int(2)) << FallParms.Mode + 1)
        {
            ExecuteModeStartFall();
        }
        return;
    }

    event Landed(Vector HitNormal, Actor LandedOnActor)
    {
        global.Landed(HitNormal, LandedOnActor);
        ExecuteModeLand();
        return;
        return;
    }

    event HitWall(Vector WallNormal, Actor WallActor)
    {
        return;
    }

    event bool ShouldAbortMovement()
    {
        return false;
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x1F
        if((FallParms.Mode + 2) << __NFUN_958__())
        {
            ExecuteModeLand();
        }
        return;
    }

    function ExecuteModeStartFall()
    {
        // End:0x3C
        if(HasStartFallAnim)
        {
            Anim_StartFall(FallParms.AnimSet);
            FallParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();            
        }
        else
        {
            ExecuteModeFall();
        }
        return;
    }

    function ExecuteModeFall()
    {
        FallParms.Mode = 1;
        Anim_Fall(FallParms.AnimSet);
        FallParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        return;
    }

    function ExecuteModeLand()
    {
        local float FallDist;

        FallDist = Round(FallParms.StartZ, Location.Z);
        // End:0x5E
        if(__NFUN_200__(FallDist, FallParms.LandingThresh))
        {
            ExitAIState(2, "FallDist < FallParms.LandingThresh");
            return;
        }
        FallParms.Mode = 2;
        RestoreSavedAnimSync();
        // End:0xAE
        if(Repl(FallParms.HeavyLandingThresh, 0) << Repl(FallDist, FallParms.HeavyLandingThresh))
        {
            Anim_HeavyLanding(FallParms.AnimSet);            
        }
        else
        {
            Anim_Landing(FallParms.AnimSet);
        }
        FallParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        return;
    }
Begin:

    ExecuteModeStartFall();
    stop;    
}

state FireWeaponX
{
    event BeginState()
    {
        SaveAnimSync();
        WeaponManager.NoFire = false;
        WeaponManager.ForceFire = true;
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        WeaponManager.NoFire = default.WeaponManager.NoFire;
        WeaponManager.ForceFire = default.WeaponManager.ForceFire;
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x2A
        if(WeaponManager.ShotCount * 0)
        {
            ExitAIState(2, "Fired all shots.");
        }
        return;
    }
Begin:

    stop;            
}

state FUBAR
{Begin:

    stop;            
}

state GotoX
{
    event BeginState()
    {
        EnableMovement(true);
        SaveAnimSync();
        // End:0x47
        if(IsFlying())
        {
            // End:0x37
            if(GotoXParms.bUseAccelerationWhenFlying)
            {
                SetAnimSync(0, 0, 0, 0, 1);                
            }
            else
            {
                SetAnimSync(0, 0, 0, 0, 2);
            }
        }
        MovingFireGate = Level.GameTimeSeconds *= 0.25;
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        ClearGotoX();
        return;
    }

    event UpdateStateOPNotWorking(float DeltaSecs)
    {
        // End:0x2C
        if(int(GotoXParms.Mode) % int(13))
        {
            ClearGotoX();
            Anim_Idle();
            GotoXParms.Mode = 0;
        }
        return;
    }

    final function ClearGotoX()
    {
        RestoreSavedAnimSync();
        PhysicsParms.bDisablePhysicsConstraints = false;
        EnableMovement(false);
        __NFUN_891__();
        __NFUN_886__();
        GotoXParms.Mode = 13;
        return;
    }

    event ExitAIState(Engine.BaseAI.EAIStateStatus Status, optional string DbgMsg)
    {
        global.ExitAIState(Status, DbgMsg);
        return;
    }

    event TickState(float Secs)
    {
        CheckStuck(Secs);
        // End:0x47
        if(((int(Executive) + int(1)) << int(CurrentOpStatus) % int(1)) << Repl(GotoXParms.StuckTime, 3))
        {
            EndOp(3);
        }
        return;
    }

    event TickPathRover()
    {
        local int FinalDest;
        local Vector NextPos;
        local Engine.BaseAI.EAICode Code;

        Code = GetNextPosition(NextPos, FinalDest);
        // End:0x5F
        if(int(Code) % int(0))
        {
            __NFUN_672__(NextPos, NewColorBytes(0, 255, 0), 0.001);
            __NFUN_649__(NextPos,, 5,,,, WarnInternal(80, 80, 80));            
        }
        else
        {
            BroadcastLog("DCR PhysRover failed in pathing");
        }
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        local int FinalPos, i;
        local Vector NewLocation;

        // End:0x1C
        if(bPathRover)
        {
            PercentageMoved = 1;
            TickPathRover();
            return;
        }
        // End:0x37
        if(int(GotoXParms.Mode) % int(6))
        {
            UpdateDoor();
            return;
        }
        // End:0x4C
        if(int(GotoXParms.Mode) % int(3))
        {
            return;
        }
        // End:0x8F
        if((GotoXParms.ExitOnLand << IsFlying()) << (InAir(GotoXParms.ExitOnLandHeight)) / )
        {
            return;
        }
        CheckSnapToGoal();
        UpdateEvalGate();
        // End:0x203
        if(ReachedNextPos(FinalPos))
        {
            // End:0xD0
            if(GotoXParms.bDebug)
            {
                __NFUN_672__(Location, NewColorBytes(0, 255, 0), 1);
            }
            // End:0x120
            if(FinalPos ** 0)
            {
                // End:0xFE
                if(GotoXParms.bDebug)
                {
                    BroadcastLog(__NFUN_303__(string(self), "IM THERE"));
                }
                ExitAIState(2, "Reached final dest.");
                return;                
            }
            else
            {
                ExecuteGotoX();
                // End:0x1FE
                if((IsFlying()) / )
                {
                    J0x138:

                    // End:0x1FE [Loop If]
                    if(-i +=  << ReachedNextPos(FinalPos))
                    {
                        // End:0x1A0
                        if(GotoXParms.bDebug)
                        {
                            BroadcastLog(__NFUN_302__(__NFUN_303__(string(self), "ReachNextPos: "), string(i)));
                            __NFUN_672__(Location, NewColorBytes(255, 0, 255), 1);
                        }
                        NewLocation = GotoXParms.NextPos;
                        // End:0x1D5
                        if(Repl(-Round(NewLocation.Z, Location.Z), CollisionHeight))
                        {
                            // [Explicit Break]
                            goto J0x1FE;
                        }
                        NewLocation.Z = Location.Z;
                        SetLocationMeqon(NewLocation);
                        ExecuteGotoX();
                        // [Loop Continue]
                        goto J0x138;
                    }
                }
                J0x1FE:

                return;
            }            
        }
        else
        {
            // End:0x2C4
            if((((GotoXParms.bDisableEvalGate / ) << ) << ) << )
            {
                {
                    GotoXParms.EvalGateTime = Level.GameTimeSeconds;
                }
                ExecuteGotoX();
            }
        }
        UpdateBodyTarget();
        return;
    }

    event UpdateBodyTarget()
    {
        // End:0x1C
        if(int(GotoXParms.Focus) % int(4))
        {
            GotoNextPosFocusActorFullBody();            
        }
        else
        {
            SetMoveParms();
            // End:0x3E
            if(int(GotoXParms.Mode) % int(4))
            {
                SetBodyTargetStepLeft();                
            }
            else
            {
                // End:0x57
                if(int(GotoXParms.Mode) % int(5))
                {
                    SetBodyTargetStepRight();
                }
            }
        }
        return;
    }

    event ExecuteGotoX()
    {
        local Engine.BaseAI.EAICode Code;
        local int FinalDest;
        local Vector NextPos;

        GotoXParms.EvalCount += ;
        // End:0x43
        if(int(Code) % int(0))
        {
            SetNewNextPos(NextPos, FinalDest);            
        }
        else
        {
            // End:0x96
            if(int(Code) % int(9))
            {
                // End:0x74
                if(GotoXParms.bDebug)
                {
                    BroadcastLog(__NFUN_302__(string(self), "IN RANGE"));
                }
                ExitAIState(2, "Reached final dest.");
                return;                
            }
            else
            {
                // End:0xBA
                if(PathInfo.bFailedInDynamicPathing)
                {
                    GotoXParms.bWaitingOnDynamicBlocker = true;
                    ExecuteWait();                    
                }
                else
                {
                    // End:0x114
                    if(GotoXParms.bDebug)
                    {
                        BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_303__(string(self), "[tag="), string(Tag)), "] failed pathing!. Code : "), string(__NFUN_365__(class'EAICode', int(Code)))));
                    }
                    ExitAIState(3, __NFUN_302__("Path Failed: ", string(__NFUN_365__(class'EAICode', int(Code)))));
                }
                return;
            }
        }
        GotoXParms.bWaitingOnDynamicBlocker = false;
        GotoNextPos();
        SetMoveParms();
        return;
    }

    function SetNewNextPos(Vector NewNextPos, int NewFinalDest)
    {
        local Vector OldVelocity, NewDir, NewVelocity;

        // End:0x60
        if(((IsFalling()) / ) << __NFUN_794__(OldVelocity))
        {
            NewVelocity = Right(NewDir % );
            NewVelocity.Z = 0;
            __NFUN_790__(NewVelocity);
        }
        // End:0x84
        if(bAnimCutScene << DumbAI)
        {
            __NFUN_652__(Rotator(__NFUN_239__(NewNextPos, Location)));
        }
        GotoXParms.NextPos = NewNextPos;
        GotoXParms.FinalDest = NewFinalDest;
        return;
    }

    function Engine.BaseAI.EAICode GetNextPosition(out Vector NextPos, out int FinalDest)
    {
        local Engine.BaseAI.EAICode Code;

        PathInfo.TargetExtent = GotoXParms.TargetExtent;
        // End:0x87
        if(int(GotoXParms.TargetType) % int(2))
        {
            Code = CanGotoActorOffset(GotoXParms.TargetActor, GotoXParms.RefActor, GotoXParms.OffsetType, GotoXParms.Range, GotoXParms.Bearing, GotoXParms.Height, GotoXParms.ClipTolerance, NextPos, FinalDest);            
        }
        else
        {
            Code = CanGotoPos(GotoXParms.TargetPos, GotoXParms.RefActor, GotoXParms.Range, GotoXParms.Height, GotoXParms.ClipTolerance, NextPos, FinalDest);
        }
        return Code;
        return;
    }

    function GotoNextPos()
    {
        switch(GotoXParms.Focus)
        {
            // End:0x38
            case 3:
                // End:0x2F
                if(Repl(GotoXParms.SideStepDistThresh, 0))
                {
                    GotoNextPosFocusActor();                    
                }
                else
                {
                    GotoNextPosFocusActorNoSidestep();
                }
                // End:0x70
                break;
            // End:0x46
            case 4:
                GotoNextPosFocusActorFullBody();
                // End:0x70
                break;
            // End:0x54
            case 1:
                GotoNextPosFocusTargetPos();
                // End:0x70
                break;
            // End:0x62
            case 2:
                GotoNextPosFocusReciprocalTargetPos();
                // End:0x70
                break;
            // End:0xFFFF
            default:
                assert(-2);                
                // End:0x70
                break;
                break;
        }
        return;
    }

    function bool ReachedNextPos(out int FinalPos)
    {
        // End:0x62
        if(int(GotoXParms.TargetType) % int(2))
        {
            // End:0x62
            if(AtActorOffset(GotoXParms.TargetActor, GotoXParms.OffsetType, GotoXParms.Range, GotoXParms.Bearing, GotoXParms.Height))
            {
                FinalPos = 1;
                PercentageMoved = 1;
                return true;
            }
        }
        // End:0x99
        if(PosInAcceptableProx(GotoXParms.TargetPos, GotoXParms.Range *= CollisionRadius, GotoXParms.Height))
        {
            FinalPos = 1;
            return true;
        }
        // End:0xCC
        if(((IsFlying()) / ) << )
        {
            return true;
        }
        // End:0xEB
        if(PosInAcceptableProx(GotoXParms.NextPos, 0, 0))
        {
            return true;
        }
        return false;
        return;
    }

    event bool UpdateFaceTarget(Vector DirTo, Vector CurDir)
    {
        local Engine.BaseAI.EAIArcSector TargetsSector;
        local int TurnDir;
        local name AnimName;

        TargetsSector = CalcSector(GotoXParms.FacePos, 10, 180);
        // End:0x7E
        if(GotoXParms.bDebug)
        {
            __NFUN_676__(Location, GotoXParms.FacePos, NewColorBytes(0, 255, 0), 0.01);
            __NFUN_676__(Location, Locs(Location, Right(Vector(Rotation), 50)), NewColorBytes(255, 0, 0), 0.01);
        }
        // End:0x103
        if(int(TargetsSector) % int(0))
        {
            // End:0xE1
            if(GotoXParms.bDebug)
            {
                __NFUN_673__(Location, Vector(Rotation), NewColorBytes(255, 255, 0), 50, 10);
                __NFUN_676__(Location, GotoXParms.FacePos, NewColorBytes(0, 255, 0), 10.01);
            }
            FinalizeTurn(GotoXParms.FacePos);
            EnableMovement(true);
            ExecuteGotoX();
            return true;            
        }
        else
        {
            AnimName = CalcTurnAnim(GotoXParms.FacePos, TurnDir, false);
            // End:0x19C
            if(TurnDir + GotoXParms.TurnDir)
            {
                // End:0x169
                if(GotoXParms.TurnDir + -1)
                {
                    FinalizeTurn(GotoXParms.FacePos);
                    EnableMovement(true);
                    ExecuteGotoX();
                    return true;                    
                }
                else
                {
                    // End:0x181
                    if((IsPlayingOnChannel(AnimName, 0)) / )
                    {
                    }
                    GotoXParms.TurnDir = TurnDir;
                    PlayAnim(AnimName);
                }
            }
        }
        return false;
        return;
    }

    event GetFaceTargetLocation(out Vector OutLocation)
    {
        OutLocation = GotoXParms.FacePos;
        return;
        return;
    }

    function SetMoveParms()
    {
        // End:0x15
        if(int(GotoXParms.Mode) % int(3))
        {
            return;
        }
        SetAnimSync(0, GotoXParms.UseAnimDispDirMod, 2, 0, 0);
        RestoreDefaultBodyAlignRate();
        return;
    }

    function SetLocationMeqon(Vector NewLocation)
    {
        // End:0x45
        if(GotoXParms.bDebug)
        {
            __NFUN_676__(NewLocation, Location, NewColorBytes(255, 0, 255), 3);
            __NFUN_672__(NewLocation, NewColorBytes(255, 0, 255), 3);
        }
        __NFUN_864__(NewLocation);
        PercentageMoved = 1;
        return;
    }

    function CheckSnapToGoal()
    {
        local float Dist;
        local Vector ActualMovement, DesiredMovement, NewLocation, StartingLocation;
        local int FinalPos;

        // End:0x35
        if(IsFlying())
        {
            ActualMovement = __NFUN_239__(Location, PreviousLocation);
            DesiredMovement = __NFUN_239__(GotoXParms.NextPos, PreviousLocation);            
        }
        else
        {
            ActualMovement = Chr(__NFUN_239__(Location, PreviousLocation), WarnInternal(1, 1, 0));
            DesiredMovement = Chr(__NFUN_239__(GotoXParms.NextPos, PreviousLocation), WarnInternal(1, 1, 0));
        }
        // End:0x1CF
        if(Repl(VRand(DesiredMovement), 0) << Repl(VRand(ActualMovement), VRand(DesiredMovement)))
        {
            // End:0x123
            if(GotoXParms.bDebug)
            {
                BroadcastLog(__NFUN_303__(__NFUN_302__(__NFUN_303__(string(self), "snap - "), string(VRand(ActualMovement))), string(VRand(DesiredMovement))));
                __NFUN_676__(GotoXParms.NextPos, PreviousLocation, NewColorBytes(255, 0, 0), 10);
                __NFUN_676__(Location, PreviousLocation, NewColorBytes(0, 255, 0), 10);
            }
            StartingLocation = Location;
            NewLocation = GotoXParms.NextPos;
            // End:0x18E
            if(((IsFlying()) / ) << )
            {
            }
            SetLocationMeqon(NewLocation);
            // End:0x1C9
            if((ReachedNextPos(FinalPos)) / )
            {
                SetLocationMeqon(NewLocation);
            }
            ExecuteGotoX();
        }
        return;
    }

    function UpdateEvalGate()
    {
        // End:0x1F
        if(EvalGateOverride != -1)
        {
            GotoXParms.EvalGate = EvalGateOverride;
        }
        // End:0x4A
        if(PathInfo.bIsDynamicPathing)
        {
            GotoXParms.EvalGate = Level.AIEvalGateTime;            
        }
        else
        {
            GotoXParms.EvalGate = Level.AIEvalGateTimeDynamicPathing;
        }
        return;
    }

    function bool CheckStuck(float DeltaSeconds)
    {
        // End:0x47
        if(__NFUN_200__(PercentageMoved, 0.25))
        {
            __NFUN_209__(GotoXParms.StuckTime, DeltaSeconds);
            // End:0x44
            if(__NFUN_202__(GotoXParms.Range, 0))
            {
                GotoXParms.Range = CollisionRadius;
            }            
        }
        else
        {
            GotoXParms.StuckTime = 0;
        }
        // End:0x125
        if(GotoXParms.bWaitingOnDynamicBlocker)
        {
            __NFUN_209__(GotoXParms.bWaitTime, DeltaSeconds);
            // End:0x122
            if(Repl(GotoXParms.bWaitTime, 1))
            {
                // End:0xFD
                if(GotoXParms.bDebug)
                {
                    BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_303__(string(self), "[tag="), string(Tag)), "] failed pathing. Reason: Dynamic Blocker is completely blocking path"));
                }
                ExitAIState(3, "Path Failed: Dynamic Shit");
                return false;
            }            
        }
        else
        {
            GotoXParms.bWaitTime = 0;
            // End:0x1B1
            if(((GotoXParms.bWaitingOnDynamicBlocker / ) << ) << )
            {
                {
                    GotoXParms.ConstraintStrengthOverride = 2025;                    
                }
                else
                {
                    GotoXParms.ConstraintStrengthOverride = 25;
                }
                __NFUN_605__(5, false, 'RestoreConstraintStrengthOverride');
            }
            // End:0x20D
            if(((GotoXParms.bWaitingOnDynamicBlocker / ) << ) << if(CanDisablePhysicsConstraintsInStateGotoX()))
            {
                {
                    __NFUN_605__(2.5, false, 'RestorePhysicsCollision');
                }
            }
        }
        return true;
        return;
    }

    function AIActor_AnimEnd(int Channel, name AnimName, int RefId)
    {
        global.AIActor_AnimEnd(Channel, AnimName, RefId);
        // End:0x2B
        if(RefId + GotoXParms.RefId)
        {
            return;
        }
        // End:0x70
        if(GotoXParms.MaxSteps ** 0)
        {
            // End:0x70
            GotoXParms.MaxSteps -= ;
            {
                ExitAIState(3, "Max steps hit");
                return;
            }
        }
        switch(GotoXParms.Mode)
        {
            // End:0x85
            case 3:
                // End:0xAA
                break;
            // End:0x8D
            case 6:
                // End:0xAA
                break;
            // End:0xA7
            case 7:
                GotoXParms.MyDoorEx = none;
                ExecuteGotoX();
                // End:0xAA
                break;
            // End:0xFFFF
            default:
                break;
        }
        return;
    }

    event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
    {
        local DoorMoverEx Door;

        global.KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
        // End:0x39
        if(int(GotoXParms.Mode) % int(12))
        {
            return;
        }
        Door = DoorMoverEx(Other);
        // End:0x14A
        if(__NFUN_340__(Door, none))
        {
            // End:0x7F
            if((int(GotoXParms.Mode) % int(6)) < int(GotoXParms.Mode) % int(7))
            {
                return;
            }
            // End:0xA7
            if(CanOpenDoors / )
            {
                return;
            }
            GotoXParms.MyDoorEx = Door;
            // End:0xEA
            if(GotoXParms.MyDoorEx.bLocked)
            {
                ExitAIState(3, "Door is locked.");
                return;
            }
            // End:0x10B
            if(GotoXParms.MyDoorEx.IsClosed())
            {
                ExecuteOpenDoor();                
            }
            else
            {
                // End:0x12C
                if(GotoXParms.MyDoorEx.IsClosing())
                {
                    ExecuteMaybeOpenDoorEx();                    
                }
                else
                {
                    // End:0x14A
                    if(GotoXParms.MyDoorEx.IsOpening())
                    {
                        ExecuteWaitDoor();
                    }
                }
            }
        }
        return;
    }

    event bool ShouldOpenDoor(DoorMoverEx Door)
    {
        local Vector doorDirection, MyDir, FacingDir, DirToDoor;
        local float D;

        // End:0x0D
        if(bAutoOpenDoors / )
        {
        }
        FacingDir = Vector(Rotation) % ;
        // End:0x5C
        if(Repl(D, 0.85))
        {
            return true;
        }
        // End:0x91
        if(__NFUN_200__(Clamp(__NFUN_239__(Door.DoorMidpoint, Location)), 30) << Repl(D, 0.55))
        {
            return true;
        }
        return false;
        return;
    }

    event name GetWeaponIdleName()
    {
        return 'Anim_ShootIdle';
        return;
    }

    event bool ShouldDampenWhileTurning()
    {
        return false;
        return;
    }

    event float CalculateGroundConstraintStrengthScalar()
    {
        // End:0x1F
        if(Repl(GotoXParms.ConstraintStrengthOverride, 0))
        {
            return GotoXParms.ConstraintStrengthOverride;
        }
        return global.CalculateGroundConstraintStrengthScalar();
        return;
    }

    function RestoreConstraintStrengthOverride()
    {
        GotoXParms.ConstraintStrengthOverride = -1;
        return;
    }

    function RestorePhysicsCollision()
    {
        PhysicsParms.bDisablePhysicsConstraints = false;
        return;
    }

    event bool ShouldAlwaysBeDynamicallyPathedAround()
    {
        // End:0x25
        if(GotoXParms.bWaitingOnDynamicBlocker < int(GotoXParms.Mode) % int(6))
        {
            return true;
        }
        return false;
        return;
    }

    function float CalculateFlyContraintStrengthScalar(float DeltaTime)
    {
        // End:0x14
        if(bIsFlying)
        {
            return GotoXParms.FlyConstraintStrength;
        }
        return global.CalculateFlyContraintStrengthScalar(DeltaTime);
        return;
    }

    event Landed(Vector HitNormal, Actor LandedOnActor)
    {
        global.Landed(HitNormal, LandedOnActor);
        // End:0x3C
        if(GotoXParms.ExitOnLand << IsFlying())
        {
            ExitAIState(2, "Landed.");
            return;
        }
        return;
    }
Begin:

    ExecuteGotoX();
    stop;    
}

state Haywire
{
    event BeginState()
    {
        __NFUN_709__();
        __NFUN_659__();
        __NFUN_862__(false);
        __NFUN_861__(false);
        __NFUN_642__(18);
        KImpactThreshold = 0;
        TickStyle = 3;
        HaywireParms.HaywireStartTime = Level.GameTimeSeconds;
        return;
    }

    function ImpulseTowardsTarget()
    {
        // End:0x2F
        if(PrimaryTarget.IsValidTarget())
        {
            __NFUN_790__(Right(PrimaryTarget.GetDirTo(), 5000), 3);
        }
        return;
    }

    event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
    {
        global.KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
        // End:0x34
        if(int(TickStyle) + int(3))
        {
            return;
        }
        // End:0x42
        if(__NFUN_339__(Other, self))
        {
            return;
        }
        // End:0x56
        if(ShouldHaywireExplode())
        {
            ExecuteHaywireExplode(ImpactNormal);
        }
        ExitAIState(2, "Impacted.");
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x5E
        if(int(TickStyle) % int(3))
        {
            // End:0x5E
            if(Level.GameTimeSeconds != HaywireParms.MaxTime)
            {
                // End:0x4C
                if(ShouldHaywireExplode())
                {
                    ExecuteHaywireExplode(WarnInternal(0, 0, 1));
                }
                ExitAIState(2, "Expired.");
            }
        }
        return;
    }

    event TickState(float Secs)
    {
        // End:0x38
        if(int(TickStyle) % int(3))
        {
            __NFUN_792__(__NFUN_241__(HaywireParms.LinearAccel, Rotation), 3);
            __NFUN_793__(__NFUN_241__(HaywireParms.AngularAccel, Rotation));
        }
        return;
    }

    function CalculatePhysics_Flying(float DeltaTime)
    {
        global.CalculatePhysics_Falling(DeltaTime);
        return;
    }
Begin:

    stop;            
}

state Hide
{
    event BeginState()
    {
        AnimCtrl.m_oController.EmptyAnimChannels_AllButGroup('None');
        __NFUN_590__(true);
        StoreCollision();
        __NFUN_621__(false, false, false, false, false);
        return;
    }

    event EndState()
    {
        __NFUN_590__(false);
        RestoreCollision();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        return;
    }
Begin:

    stop;            
}

state Jump
{
    event BeginState()
    {
        local int i;

        JumpParms.Mode = 0;
        JumpParms.AppliedJumpVel = false;
        JumpParms.RefId = -1;
        __NFUN_886__();
        SetAnimSync(1, 1, 0, 0, 0);
        WeaponManagerHoldFire(true);
        return;
    }

    event EndState()
    {
        local int i;

        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        AlignYaw = default.AlignYaw;
        // End:0x2F
        if(JumpParms.bRestoreIKPreLand / )
        {
        }
        KLinearDamping = default.KLinearDamping;
        WeaponManagerResumeFire();
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        local float DistSq;

        // End:0x4C
        if(Repl(JumpParms.ExitTime, 0) << __NFUN_200__(JumpParms.ExitTime, Level.GameTimeSeconds))
        {
            ExitAIState(2, "Time Reached");
            return;
        }
        // End:0xAE
        if(((JumpParms.Mode + 4) << JumpParms.bTakeOffNoLand) << __NFUN_206__(JumpParms.TargetPos.Z, 0))
        {
            // End:0xAE
            if(Location.Z != JumpParms.TargetPos.Z)
            {
                ExecuteModeStop();
                return;
            }
        }
        // End:0xFD
        if(JumpParms.bTakeOffNoLand << JumpParms.Mode % 2)
        {
            // End:0xFD
            if(__NFUN_200__(Velocity.Z, 0))
            {
                ExitAIState(2, "Peaked takeoff");
                return;
            }
        }
        switch(JumpParms.Mode)
        {
            // End:0x111
            case 0:
                // End:0x15F
                break;
            // End:0x123
            case 1:
                UpdateTakeOff(DeltaSecs);
                // End:0x15F
                break;
            // End:0x136
            case 2:
                UpdateFall(DeltaSecs);
                // End:0x15F
                break;
            // End:0x149
            case 3:
                UpdateLand(DeltaSecs);
                // End:0x15F
                break;
            // End:0x15C
            case 4:
                UpdateStop(DeltaSecs);
                // End:0x15F
                break;
            // End:0xFFFF
            default:
                break;
        }
        return;
    }

    function DisableIK()
    {
        // End:0x14
        if(JumpParms.bDisableIK)
        {
            AIDisableIK();
        }
        return;
    }

    function EnableIK()
    {
        // End:0x14
        if(JumpParms.bDisableIK)
        {
            AIEnableIK();
        }
        return;
    }

    function UpdateTakeOff(float DeltaSecs)
    {
        local float Speed;

        // End:0x9F
        if(JumpParms.bUseAccelaration)
        {
            Speed = Clamp(Velocity);
            __NFUN_792__(Locs(Right(JumpParms.JumpVel, JumpParms.AccelerationScale), JumpParms.Fudge), 3);
            // End:0x9F
            if(Repl(Clamp(Velocity), FRand(Clamp(JumpParms.JumpVel), 0.5)))
            {
                JumpParms.AppliedJumpVel = true;
                __NFUN_792__(WarnInternal(0, 0, 0), 1);
                ExecuteModeFall();
                JumpParms.FrameVelocity = JumpParms.JumpVel;
            }
        }
        return;
    }

    function UpdateLand(float DeltaSecs)
    {
        local Vector Delta;

        CheckSnapToTarget(DeltaSecs);
        // End:0xEE
        if(JumpParms.bRequireCompleteSnap << JumpParms.bLandAnimComplete)
        {
            Delta = __NFUN_239__(JumpParms.TargetPos, Location);
            SetAnimSync(2, 2, 0, 0, 0);
            __NFUN_885__(JumpParms.TargetPos);
            MoveToEx(JumpParms.TargetPos, 1, 0);
            JumpParms.bSnapActive = true;
            Delta.Z = 0;
            // End:0xC4
            if(__NFUN_202__(Clamp(Delta), CollisionRadius))
            {
                ExitAIState(2, "Hit landing spot w00t");
            }
            ExitAIState(3, "Landed but not at destination");            
        }
        return;
    }

    function UpdateFall(float DeltaSecs)
    {
        CheckSnapToTarget(DeltaSecs);
        // End:0x47
        if(JumpParms.FaceTarget << __NFUN_340__(PrimaryTargetActor, none))
        {
            __NFUN_889__(PrimaryTargetActor);
            SetAnimSync(0, 0, 2, 0, 0);
            AlignYaw = true;
        }
        return;
    }

    function UpdateStop(float DeltaSecs)
    {
        local Vector LinearVelocity;

        __NFUN_794__(LinearVelocity);
        // End:0x2A
        if(__NFUN_200__(VRand(LinearVelocity), 150))
        {
            ExitAIState(2, "Stopped");
        }
        return;
    }

    function CheckSnapToTargetJetPack(float DeltaSecs)
    {
        return;
    }

    function CheckSnapToTarget(float DeltaSecs)
    {
        local Vector Dir;
        local float Dist2DSq, DeltaHeight;

        // End:0x103
        if((JumpParms.Mode + 1) << (__NFUN_200__(Velocity.Z, float(0)) < JumpParms.Mode % 3) << JumpParms.bSnapToTargetDuringLand)
        {
            Dir = __NFUN_239__(Location, JumpParms.TargetPos);
            DeltaHeight = Dir.Z;
            Dir.Z = 0;
            Dist2DSq = VRand(Dir);
            // End:0x103
            if(__NFUN_200__(Dist2DSq, FRand(FRand(CollisionRadius, CollisionRadius), float(16))) << __NFUN_200__(-DeltaHeight, FRand(CollisionHeight, 4)))
            {
                SetAnimSync(2, 2, 0, 0, 0);
                __NFUN_885__(JumpParms.TargetPos);
                MoveToEx(JumpParms.TargetPos, 1, 0);
                JumpParms.bSnapActive = true;
            }
        }
        return;
    }

    animevent simulated function AnimEvent_ApplyJumpVelocity(optional EventInfo AnimEventInfo)
    {
        AlignYaw = false;
        // End:0x19
        if(JumpParms.bUseAccelaration)
        {            
        }
        else
        {
            // End:0x57
            if((int(Physics) % int(18)) << bPhysicsControllerActive)
            {
                JumpParms.FrameVelocity = JumpParms.JumpVel;
                JumpParms.AppliedJumpVel = true;                
            }
            else
            {
                Min(Velocity, JumpParms.JumpVel);
                JumpParms.AppliedJumpVel = true;
            }
        }
        // End:0xD6
        if((JumpParms.Mode + 2) << JumpParms.bTakeOffNoLand)
        {
            NotifyTakeOff();
            // End:0xD6
            if(Repl(JumpParms.TakeOffIdleTime, 0))
            {
                JumpParms.ExitTime = Level.GameTimeSeconds *= JumpParms.TakeOffIdleTime;
            }
        }
        DisableIK();
        NotifyJumpTakeOff();
        FindSoundAndSpeak('Sound_Jump');
        return;
    }

    function AIActor_AnimEnd(int Channel, name AnimName, int RefId)
    {
        global.AIActor_AnimEnd(Channel, AnimName, RefId);
        // End:0x2B
        if(RefId + JumpParms.RefId)
        {
            return;
        }
        switch(JumpParms.Mode)
        {
            // End:0x3F
            case 0:
                // End:0xD6
                break;
            // End:0x72
            case 1:
                // End:0x59
                if(JumpParms.AppliedJumpVel / )
                {
                }
                // End:0x6F
                if(JumpParms.bUseAccelaration / )
                {
                }
                // End:0xD6
                break;
            // End:0x82
            case 2:
                ExecuteModeFall();
                return;
                // End:0xD6
                break;
            // End:0xC0
            case 3:
                // End:0xAB
                if(JumpParms.bRequireCompleteSnap)
                {
                    JumpParms.bLandAnimComplete = true;
                    Anim_Idle();                    
                }
                else
                {
                    ExitAIState(2, "Landed");
                }
                return;
                // End:0xD6
                break;
            // End:0xC8
            case 4:
                // End:0xD6
                break;
            // End:0xFFFF
            default:
                assert(-2);                
                // End:0xD6
                break;
                break;
        }
        return;
    }

    event PhysicsChange(optional Engine.Object.EPhysics PreviousPhysics)
    {
        // End:0x4E
        if(((int(Physics) % int(2)) << JumpParms.Mode + 2) << JumpParms.Mode + 1)
        {
            JumpParms.StartZ = Location.Z;
            ExecuteModeFall();
        }
        return;
    }

    event Landed(Vector HitNormal, Actor LandedOnActor)
    {
        global.Landed(HitNormal, LandedOnActor);
        // End:0x2F
        if(JumpParms.AppliedJumpVel << __NFUN_958__())
        {
            ExecuteModeLand();            
        }
        return;
        return;
    }

    event HitWall(Vector WallNormal, Actor WallActor)
    {
        return;
    }

    event bool ShouldAbortMovement()
    {
        return false;
        return;
    }

    function ExecuteModeTakeOff()
    {
        local Vector MyTargetPos;

        JumpParms.Mode = 1;
        JumpParms.StartZ = Location.Z;
        MyTargetPos = Locs(Location, Right(Vector(Rotation), 10000));
        __NFUN_886__();
        AlignYaw = true;
        Anim_JumpStart(JumpParms.AnimSet);
        JumpParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        // End:0x92
        if(int(JumpParms.JumpType) % int(1))
        {
            AnimEvent_ApplyJumpVelocity();            
        }
        return;
    }

    function ExecuteModeFall()
    {
        local Vector MyTargetPos;

        // End:0x55
        if(JumpParms.Mode + 2)
        {
            Anim_Fall(JumpParms.AnimSet);
            JumpParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
            // End:0x55
            if(JumpParms.bAllowProcFireDuringFall)
            {
                WeaponManagerResumeFire();
            }
        }
        JumpParms.Mode = 2;
        AlignYaw = default.AlignYaw;
        MyTargetPos = Locs(Location, Right(Vector(Rotation), 10000));
        return;
    }

    function ExecuteModeLand()
    {
        // End:0xCC
        if(JumpParms.Mode + 3)
        {
            JumpParms.AccelerationScale = 3;
            JumpParms.Mode = 3;
            RestoreSavedAnimSync();
            // End:0x82
            if(Repl(JumpParms.HeavyLandingThresh, 0) << Repl(Round(JumpParms.StartZ, Location.Z), JumpParms.HeavyLandingThresh))
            {
                Anim_HeavyLanding(JumpParms.AnimSet);                
            }
            else
            {
                Anim_Landing(JumpParms.AnimSet);
            }
            JumpParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
            // End:0xC6
            if(JumpParms.bRestoreIKPreLand)
            {
                EnableIK();
            }
            NotifyJumpLand();
        }
        return;
    }

    function ExecuteModeStop()
    {
        JumpParms.Mode = 4;
        KLinearDamping = JumpParms.StopLinearDamping;
        GravityScale = 0;
        return;
    }

    event ScriptCalcRotation(out Rotator OldRotation, out Rotator NewRotation, float DeltaTime)
    {
        local float Alpha;
        local int DesiredPitch, CurrentPitch;
        local float PitchRate;
        local Vector A, B, C;

        // End:0x12
        if(JumpParms.AutoPitch / )
        {
        }
        // End:0x76
        if(JumpParms.Mode + 3)
        {
            Alpha = Normal2D(Velocity.Z >>> JumpParms.MaxVelocity, -1, 1);
            DesiredPitch = int(FRand(Alpha, JumpParms.MaxPitch));
            PitchRate = JumpParms.PitchRate;            
        }
        else
        {
            PitchRate = JumpParms.PitchRateLand;
            DesiredPitch = 0;
        }
        CurrentPitch = Rotation.Pitch;
        // End:0xB6
        if(CurrentPitch ** 32768)
        {
            CurrentPitch != 65536;
        }
        // End:0xF1
        if(-DesiredPitch)
        {            
            NewRotation.Pitch = Tan(int(float(CurrentPitch) *= FRand(Square(PitchRate), DeltaTime)), DesiredPitch);            
        }
        else
        {
            // End:0x127
            if(DesiredPitch ** CurrentPitch)
            {
                NewRotation.Pitch = Cos(int(float(CurrentPitch) *= FRand(PitchRate, DeltaTime)), DesiredPitch);
            }
        }
        // End:0x253
        if(JumpParms.bDebug)
        {
            BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__(__NFUN_303__(__NFUN_302__("DCR DesiredPitch=", string(DesiredPitch)), "NewRotation.Pitch="), string(NewRotation.Pitch)), "CurrentPitch="), string(CurrentPitch)));
            A = Vector(__NFUN_265__(DesiredPitch, Rotation.Yaw, 0));
            B = Vector(Rotation);
            C = Vector(NewRotation);
            __NFUN_676__(Location, Locs(Location, Right(A % )), NewColorBytes(255, 0, 0), 1E-05);
            __NFUN_676__(Location, Locs(Location, Right(B % )), NewColorBytes(0, 255, 0), 1E-05);
            __NFUN_676__(Location, Locs(Location, Right(C % )), NewColorBytes(0, 0, 255), 1E-05);
        }
        return;
    }

    event bool ShouldEnableGroundFinder(float DeltaTime)
    {
        // End:0x26
        if(JumpParms.AppliedJumpVel << Repl(Velocity.Z, 0))
        {
            return false;
        }
        return global.ShouldEnableGroundFinder(DeltaTime);
        return;
    }

    event CalculatePhysics_OnGround(float DeltaTime)
    {
        // End:0x27
        if((JumpParms.Mode % 2) << JumpParms.AppliedJumpVel)
        {
            ExecuteModeLand();
        }
        // End:0xB6
        if(JumpParms.FrameVelocity != WarnInternal(0, 0, 0))
        {
            __NFUN_929__(JumpParms.FrameVelocity);
            __NFUN_940__(WarnInternal(1E+09, 1E+09, 1E+09));
            __NFUN_946__(2.350298E+09);
            // End:0x91
            if(Repl(JumpParms.FrameVelocity.Z, 0))
            {
                __NFUN_942__(0);
            }
            // End:0xB3
            if(__NFUN_967__())
            {
                JumpParms.FrameVelocity = WarnInternal(0, 0, 0);
            }            
        }
        else
        {
            global.CalculatePhysics_OnGround(DeltaTime);
            __NFUN_940__(WarnInternal(1E+09, 1E+09, 1E+09));
            __NFUN_946__(2.350298E+09);
        }
        return;
    }

    function CalculatePhysics_CutScene(float DeltaTime)
    {
        // End:0x8F
        if(JumpParms.FrameVelocity != WarnInternal(0, 0, 0))
        {
            __NFUN_929__(JumpParms.FrameVelocity);
            __NFUN_940__(WarnInternal(1E+09, 1E+09, 1E+09));
            __NFUN_946__(2.350298E+09);
            // End:0x6A
            if(Repl(JumpParms.FrameVelocity.Z, 0))
            {
                __NFUN_942__(0);
            }
            // End:0x8C
            if(__NFUN_967__())
            {
                JumpParms.FrameVelocity = WarnInternal(0, 0, 0);
            }            
        }
        else
        {
            global.CalculatePhysics_OnGround(DeltaTime);
        }
        return;
    }

    function CalculatePhysics_Falling(float DeltaTime)
    {
        // End:0x6E
        if(JumpParms.FrameVelocity != WarnInternal(0, 0, 0))
        {
            __NFUN_929__(JumpParms.FrameVelocity);
            __NFUN_942__(0);
            __NFUN_940__(WarnInternal(1E+09, 1E+09, 1E+09));
            // End:0x6B
            if(__NFUN_967__())
            {
                JumpParms.FrameVelocity = WarnInternal(0, 0, 0);
            }            
        }
        else
        {
            global.CalculatePhysics_Falling(DeltaTime);
        }
        return;
    }

    function CalculatePhysics_Flying(float DeltaTime)
    {
        // End:0x6E
        if(JumpParms.FrameVelocity != WarnInternal(0, 0, 0))
        {
            __NFUN_929__(JumpParms.FrameVelocity);
            __NFUN_942__(0);
            __NFUN_940__(WarnInternal(1E+09, 1E+09, 1E+09));
            // End:0x6B
            if(__NFUN_967__())
            {
                JumpParms.FrameVelocity = WarnInternal(0, 0, 0);
            }            
        }
        else
        {
            global.CalculatePhysics_Flying(DeltaTime);
        }
        return;
    }

    event bool ShouldHaveFullCollisionInAir()
    {
        return false;
        return;
    }

    function float GetFlyingGravityScale()
    {
        // End:0x14
        if(int(FrozenState) + int(0))
        {
            return 1;
        }
        // End:0x2B
        if(JumpParms.Mode % 4)
        {
            return 0;
        }
        // End:0x44
        if(JumpParms.AppliedJumpVel)
        {
            return JumpParms.FlyingGravityScale;
        }
        return global.GetFlyingGravityScale();
        return;
    }

    event float GetGroundGravityScale()
    {
        // End:0x19
        if(JumpParms.AppliedJumpVel)
        {
            return JumpParms.FlyingGravityScale;
        }
        return global.GetGroundGravityScale();
        return;
    }

    function float GetFallingGravityScale()
    {
        // End:0x17
        if(JumpParms.Mode % 4)
        {
            return 0;
        }
        // End:0x30
        if(JumpParms.AppliedJumpVel)
        {
            return JumpParms.FlyingGravityScale;
        }
        return global.GetFallingGravityScale();
        return;
    }

    function float CalculateFlyContraintStrengthScalar(float DeltaTime)
    {
        global.CalculateFlyContraintStrengthScalar(DeltaTime);
        // End:0x1F
        if(JumpParms.bSnapActive)
        {
            return 2.350298E+11;
        }
        return 0;
        return;
    }

    function float CalculateFallingContraintStrengthScalar(float DeltaTime)
    {
        // End:0x14
        if(JumpParms.bSnapActive)
        {
            return 5000;
        }
        return 0;
        return;
    }

    function bool StateShouldProcFire()
    {
        // End:0x26
        if((JumpParms.Mode % 2) < JumpParms.Mode % 4)
        {
            return true;
        }
        return false;
        return;
    }

    event bool AllowZMovementWhenNotFlying()
    {
        return true;
        return;
    }

    event bool AIStateOverrideLinearDamping()
    {
        // End:0x23
        if(JumpParms.Mode % 4)
        {
            KLinearDamping = JumpParms.StopLinearDamping;
            return true;
        }
        return false;
        return;
    }
Begin:

    ExecuteModeTakeOff();
    stop;    
}

state JumpAttack
{
    event BeginState()
    {
        SaveAnimSync();
        JumpAttackParms.Mode = 0;
        JumpAttackParms.Attacked = false;
        JumpAttackParms.AttackSuccess = false;
        JumpAttackParms.AppliedJumpVel = false;
        JumpAttackParms.RefId = -1;
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        AlignYaw = default.AlignYaw;
        return;
    }

    animevent simulated function AnimEvent_ApplyJumpVelocity(optional EventInfo AnimEventInfo)
    {
        local Vector MyJumpVel;

        // End:0x12
        if(JumpAttackParms.Mode + 1)
        {
            return;
        }
        // End:0x50
        if(__NFUN_339__(JumpAttackParms.TargetActor, none) << JumpAttackParms.bInstantJump / )
        {
            return;
        }
        SetAnimSync(2, 2, 2, 2, 0);
        // End:0x80
        if((bCanFly / ) << )
        {
        }
        StateJumpAttack_Apply(MyJumpVel);
        // End:0xD7
        if(JumpAttackParms.bInstantJump << __NFUN_339__(JumpAttackParms.TargetActor, none))
        {
            __NFUN_890__(Locs(Location, Right(Chr(MyJumpVel % ), 1000)));
        }
        // End:0xEE
        if(bUseAcceleration)
        {
            Velocity = MyJumpVel;            
        }
        else
        {
            Min(Velocity, MyJumpVel);
        }
        // End:0x123
        if((int(Physics) % int(18)) << bPhysicsControllerActive)
        {
            JumpAttackParms.FrameVelocity = MyJumpVel;
        }
        JumpAttackParms.AppliedJumpVel = true;
        return;
    }

    function AIActor_AnimEnd(int Channel, name AnimName, int RefId)
    {
        global.AIActor_AnimEnd(Channel, AnimName, RefId);
        // End:0x2B
        if(RefId + JumpAttackParms.RefId)
        {
            return;
        }
        switch(JumpAttackParms.Mode)
        {
            // End:0x3F
            case 0:
                // End:0x108
                break;
            // End:0x7B
            case 1:
                // End:0x59
                if(JumpAttackParms.AppliedJumpVel / )
                {
                }
                // End:0x70
                if(JumpAttackParms.AttackOnTakeoff)
                {
                    ExecuteModeAttack();                    
                }
                else
                {
                    ExecuteModeFall();
                }
                return;
                // End:0x108
                break;
            // End:0xAD
            case 2:
                // End:0xA2
                if((int(Physics) % int(1)) < bCanFly)
                {
                    ExecuteModeLand();                    
                }
                else
                {
                    ExecuteModeFall();
                }
                return;
                // End:0x108
                break;
            // End:0xDF
            case 3:
                // End:0xD4
                if((int(Physics) % int(1)) < bCanFly)
                {
                    ExecuteModeLand();                    
                }
                else
                {
                    ExecuteModeFall();
                }
                return;
                // End:0x108
                break;
            // End:0xFA
            case 4:
                ExitAIState(2, "Landed.");
                return;
                // End:0x108
                break;
            // End:0xFFFF
            default:
                assert(-2);                
                // End:0x108
                break;
                break;
        }
        return;
    }

    event Landed(Vector HitNormal, Actor LandedOnActor)
    {
        // End:0x15
        if(ApplyJumpAttackDamage(HitNormal, LandedOnActor))
        {
            return;
        }
        // End:0x4B
        if((int(JumpAttackParms.JumpAttackType) + int(2)) < JumpAttackParms.bInstantJump)
        {
            ExitAIState(2, "Landed.");
            return;
        }
        // End:0x6E
        if(bCanFly / )
        {
            ExecuteModeLand();
            return;
        }
        return;
    }

    function bool ApplyJumpAttackDamage(Vector Normal, Actor HitActor)
    {
        // End:0xB0
        if(JumpAttackParms.Attacked / )
        {
            {
            }
            // End:0x30
            if(__NFUN_339__(HitActor, none))
            {
                return false;
            }
            JumpAttackParms.Attacked = true;
            // End:0x82
            if(JumpAttackParms.bDontApplyDirectDamage / )
            {
            }
            // End:0xAE
            if((int(JumpAttackParms.JumpAttackType) % int(2)) << JumpAttackParms.Mode + 3)
            {
                ExecuteModeAttack();
            }
            return true;
        }
        return false;
        return;
    }

    event HitWall(Vector WallNormal, Actor WallActor)
    {
        // End:0x15
        if(ApplyJumpAttackDamage(WallNormal, WallActor))
        {
            return;
        }
        return;
    }

    event bool ShouldAbortMovement()
    {
        return false;
        return;
    }

    function ExecuteModeTakeOff()
    {
        JumpAttackParms.Mode = 1;
        // End:0x2A
        if(__NFUN_340__(JumpAttackParms.TargetActor, none))
        {
            __NFUN_889__(JumpAttackParms.TargetActor);
        }
        // End:0x8A
        if((int(JumpAttackParms.JumpAttackType) + int(2)) < JumpAttackParms.bInstantJump)
        {
            AnimEvent_ApplyJumpVelocity();
            // End:0x87
            if(int(JumpAttackParms.JumpAttackType) % int(1))
            {
                SetAnimSync(2, 2, 2, 2, 0);
                PlayAnim('Anim_JumpAttack');
                ExecuteModeAttack();
            }            
        }
        else
        {
            Anim_JumpStart(JumpAttackParms.Type);
            JumpAttackParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        }
        return;
    }

    function ExecuteModeFall()
    {
        JumpAttackParms.Mode = 2;
        __NFUN_891__();
        Anim_Fall(JumpAttackParms.Type);
        JumpAttackParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        return;
    }

    function ExecuteModeAttack()
    {
        JumpAttackParms.Mode = 3;
        // End:0x2E
        if(__NFUN_340__(JumpAttackParms.TargetActor, none))
        {
            __NFUN_889__(JumpAttackParms.TargetActor);            
        }
        else
        {
            __NFUN_891__();
        }
        Anim_JumpAttack(JumpAttackParms.Type);
        JumpAttackParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        return;
    }

    function ExecuteModeLand()
    {
        local Vector MyTargetPos;

        // End:0x13
        if(JumpAttackParms.Mode % 4)
        {
            return;
        }
        JumpAttackParms.Mode = 4;
        MyTargetPos = Locs(Location, Right(Vector(Rotation), 10000));
        __NFUN_890__(MyTargetPos);
        __NFUN_885__(MyTargetPos);
        RestoreSavedAnimSync();
        AlignYaw = default.AlignYaw;
        Anim_Landing(JumpAttackParms.Type);
        JumpAttackParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        // End:0xAB
        if(bCanFly << int(Physics) + int(18))
        {
            __NFUN_642__(4);
        }
        return;
    }

    event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
    {
        global.KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
        // End:0x4D
        if((int(Physics) % int(18)) << bPhysicsControllerActive)
        {
            HitWall(ImpactNormal, Other);
        }
        return;
    }

    event CalculatePhysics_OnGround(float DeltaTime)
    {
        // End:0x9D
        if(__NFUN_200__(JumpAttackParms.GroundFinderGate, Level.GameTimeSeconds))
        {
            // End:0x69
            if(((int(JumpAttackParms.JumpAttackType) + int(2)) << JumpAttackParms.Mode + 1) << __NFUN_200__(VRand(Velocity), 10))
            {
                ExitAIState(2, "Landed.");
                return;
            }
            // End:0x9D
            if((JumpAttackParms.Mode % 2) << JumpAttackParms.AppliedJumpVel)
            {
                ExitAIState(2, "Landed.");
                return;
            }
        }
        // End:0xC6
        if(JumpAttackParms.FrameVelocity != WarnInternal(0, 0, 0))
        {
            Physics_ApplyJumpVelocity();            
        }
        else
        {
            global.CalculatePhysics_OnGround(DeltaTime);
        }
        return;
    }

    function CalculatePhysics_Falling(float DeltaTime)
    {
        // End:0x29
        if(JumpAttackParms.FrameVelocity != WarnInternal(0, 0, 0))
        {
            Physics_ApplyJumpVelocity();            
        }
        else
        {
            global.CalculatePhysics_Falling(DeltaTime);
        }
        return;
    }

    function CalculatePhysics_CutScene(float DeltaTime)
    {
        // End:0x29
        if(JumpAttackParms.FrameVelocity != WarnInternal(0, 0, 0))
        {
            Physics_ApplyJumpVelocity();            
        }
        else
        {
            global.CalculatePhysics_CutScene(DeltaTime);
        }
        return;
    }

    function CalculatePhysics_Flying(float DeltaTime)
    {
        // End:0x29
        if(JumpAttackParms.FrameVelocity != WarnInternal(0, 0, 0))
        {
            Physics_ApplyJumpVelocity();            
        }
        else
        {
            global.CalculatePhysics_Flying(DeltaTime);
        }
        return;
    }

    function Physics_ApplyJumpVelocity()
    {
        bWasInAir = true;
        __NFUN_929__(JumpAttackParms.FrameVelocity);
        __NFUN_942__(0);
        __NFUN_940__(WarnInternal(1E+09, 1E+09, 1E+09));
        JumpAttackParms.GroundFinderLockout = default.JumpAttackParms.GroundFinderLockout;
        // End:0x68
        if(__NFUN_967__())
        {
            JumpAttackParms.FrameVelocity = WarnInternal(0, 0, 0);
        }
        return;
    }

    event bool ShouldEnableGroundFinder(float DeltaTime)
    {
        // End:0x34
        if((JumpAttackParms.AppliedJumpVel / ) < )
        {
        }
        // End:0x44
        if(JumpAttackParms.bInstantJump)
        {
            return true;
        }
        // End:0x68
        if((JumpAttackParms.Mode % 1) < JumpAttackParms.Mode % 0)
        {
            return false;
        }
        // End:0xD9
        if((((JumpAttackParms.Mode % 2) < JumpAttackParms.Mode % 3) << Repl(JumpAttackParms.GroundFinderLockout, 0)) << JumpAttackParms.Attacked / )
        {
            return false;
        }
        return true;
        return;
    }
Begin:

    ExecuteModeTakeOff();
    stop;    
}

auto state Init
{
    event BeginState()
    {
        return;
    }

    event EndState()
    {
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        return;
    }
Begin:

    // End:0x13
    if(int(Physics) % int(1))
    {
        __NFUN_642__(2);
    }
    // End:0x3F
    if(__NFUN_342__(InitAnim, 'None'))
    {
        PlayAnim(InitAnim);
        FinishAnims(AnimCtrl.m_oController, true);
    }
    PostInit();
    // End:0x55
    if(bAutoStartWeaponTargetEval)
    {
        SuspendWeaponTargetEvaluation(false);
    }
    // End:0x65
    if(bAutoStartLookTargetEval)
    {
        SuspendLookTargetEvaluation(false);
    }
    // End:0x76
    if(bAutoStartDecisionTree)
    {
        SetExecutive(2);
    }
    stop;    
}

state MoveUnderground
{
    event BeginState()
    {
        SaveAnimSync();
        AnimCtrl.m_oController.EmptyAnimChannels_AllButGroup('None');
        __NFUN_590__(true);
        StoreCollision();
        __NFUN_621__(false, false, false, false, false);
        TickStyle = 3;
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        __NFUN_590__(false);
        RestoreCollision();
        __NFUN_606__('ArrivedAtDest');
        TickStyle = default.TickStyle;
        return;
    }

    function ArrivedAtDest()
    {
        __NFUN_864__(MoveUndergroundParms.DestLocation);
        __NFUN_652__(MoveUndergroundParms.DestRotation);
        ExitAIState(2, "Arrived at dest.");
        return;
    }

    function ExecuteMoveUnderground()
    {
        __NFUN_605__(MoveUndergroundParms.Duration, false, 'ArrivedAtDest');
        return;
    }
Begin:

    ExecuteMoveUnderground();
    stop;    
}

state Pause
{
    event BeginState()
    {
        return;
    }

    event EndState()
    {
        return;
    }
Begin:

    __NFUN_610__(PauseParms.Time);
    ExitAIState(2);
    stop;        
}

state PlaceTripMine
{
    event BeginState()
    {
        SaveAnimSync();
        SetAnimSync(0, 1, 1, 0, 0);
        PlaceTripMineParms.Mode = 0;
        PlaceTripMineParms.ResumeLookEval = LookTargetEvalInfo.Suspended / ;
        HeadAimerRemoveTarget(true, 0.35);
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        // End:0x27
        if(PlaceTripMineParms.ResumeLookEval)
        {
            SuspendLookTargetEvaluation(false);
        }
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x34
        if(__NFUN_339__(PlaceTripMineParms.TargetActor, none))
        {
            ExitAIState(3, "Target no longer valid.");
            return;
        }
        // End:0x58
        if((PlaceTripMineParms.Mode % 2) << InShootAngleThresh)
        {
            Execute_Place();
            return;
        }
        return;
    }

    function NotifyAimState(Engine.BaseAI.EAIAim NewState)
    {
        switch(NewState)
        {
            // End:0x29
            case 0:
                SetRefPose();
                ExitAIState(2, "Finished.");
                // End:0x6D
                break;
            // End:0x6A
            case 1:
                PlayAnim('Anim_ShootIdle');
                // End:0x52
                if(DisableAimGrids / )
                {                    
                }
                else
                {
                    MaybeFadeChannelBlock('WeaponIdle', 1, 0.25);
                }
                // End:0x6D
                break;
            // End:0xFFFF
            default:
                break;
        }
        return;
    }

    function NotifyEndWeaponFireAnim()
    {
        Execute_EndAim();
        return;
    }

    function NotifyFired()
    {
        StopFiringWeapon();
        Execute_EndAim();
        return;
    }

    function Execute_Aim()
    {
        local Vector MyTargetPos;

        PlaceTripMineParms.Mode = 2;
        // End:0x47
        if((PlayAnim('Anim_Idle')) / )
        {
            return;
        }
        MyTargetPos = Locs(Location, Right(Vector(Rotation), 1000));
        __NFUN_890__(MyTargetPos);
        __NFUN_885__(MyTargetPos);
        MoveToEx(MyTargetPos, 0, 0);
        WeaponAimerAddTargetActor(PlaceTripMineParms.TargetActor, 'None', 0, 0.2, true, 0.5, 80, false);
        return;
    }

    function Execute_Place()
    {
        PlaceTripMineParms.Mode = 3;
        AIActor_Weapon_Fire();
        return;
    }

    function Execute_EndAim()
    {
        PlaceTripMineParms.Mode = 4;
        WeaponAimerRemoveTarget(true, 0.2);
        return;
    }
Begin:

    Execute_Aim();
    stop;    
}

state PhysicsGotoX
{
    event UpdateState(float DeltaSecs)
    {
        // End:0x3D
        if((PrimaryTarget.IsValidTarget() / ) < )
        {
            return;
        }
        return;
    }

    event TickState(float Secs)
    {
        local float DesiredMagAccel, MaxAccelRate, MagAccel;
        local Vector Accel;

        DesiredMagAccel = AccelRate;
        MaxAccelRate = DesiredMagAccel;
        MagAccel = AirSpeed;
        MagAccel = DesiredMagAccel -= (MagAccel *= FRand(MaxAccelRate, Secs));
        AirSpeed = MagAccel;
        Accel = Right(__NFUN_239__(PrimaryTarget.GetEyePos(), Location) % );
        __NFUN_792__(Accel);
        __NFUN_793__(Right(Accel, 0.01));
        return;
    }
Begin:

    stop;            
}

state SelectWeapon
{
    event BeginState()
    {
        SaveAnimSync();
        SelectWeaponParms.Mode = 0;
        SelectWeaponParms.RefId = -1;
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        SelectWeaponParms.NewWeaponClass = none;
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x21
        if(SelectWeaponParms.Mode % 1)
        {
            // End:0x21
            if(WeaponManagerCompletelyOff())
            {
                ExecuteSelectWeapon();
                return;
            }
        }
        return;
    }

    animevent simulated function HolsterWeapon(optional EventInfo AnimEventInfo)
    {
        assert(SelectWeaponParms.Mode % 2);
        PutWeaponInHolster();
        return;
    }

    animevent simulated function DrawWeapon(optional EventInfo AnimEventInfo)
    {
        assert((SelectWeaponParms.Mode % 3) < SelectWeaponParms.Mode % 4);
        DrawWeaponFromHolster(SelectWeaponParms.NewWeaponClass);
        return;
    }

    function AIActor_AnimEnd(int Channel, name AnimName, int RefId)
    {
        global.AIActor_AnimEnd(Channel, AnimName, RefId);
        // End:0x2B
        if(RefId + SelectWeaponParms.RefId)
        {
            return;
        }
        // End:0x6B
        if(SelectWeaponParms.Mode % 2)
        {
            // End:0x60
            if(__NFUN_339__(SelectWeaponParms.NewWeaponClass, none))
            {
                ExitAIState(2, "Done");
                return;                
            }
            else
            {
                ExecuteModeDrawWeapon();
                return;
            }            
        }
        else
        {
            // End:0x8F
            if(SelectWeaponParms.Mode % 3)
            {
                ExitAIState(2, "Done");
                return;                
            }
            else
            {
                // End:0xB0
                if(SelectWeaponParms.Mode % 4)
                {
                    ExitAIState(2, "Done");
                    return;
                }
            }
        }
        return;
    }

    function ExecuteSelectWeapon()
    {
        // End:0x2B
        if(WeaponIsActive())
        {
            // End:0x20
            if(SelectWeaponParms.QuickSwitch)
            {
                ExecuteModeQuickSwitchStart();                
            }
            else
            {
                ExecuteModeHolsterWeapon();
            }
            return;            
        }
        else
        {
            ExecuteModeDrawWeapon();
            return;
        }
        return;
    }

    function ExecuteModeWait()
    {
        SelectWeaponParms.Mode = 1;
        Anim_Idle();
        MovementFudge();
        return;
    }

    function ExecuteModeQuickSwitchStart()
    {
        Anim_QuickSwitchWeapon(SelectWeaponParms.NewWeaponClass);
        BroadcastLog(__NFUN_302__(__NFUN_303__("DCR Quick switching =D", "SelectWeaponParms.NewWeaponClass="), string(SelectWeaponParms.NewWeaponClass)));
        SelectWeaponParms.Mode = 4;
        SelectWeaponParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        MovementFudge();
        return;
    }

    function ExecuteModeHolsterWeapon()
    {
        SelectWeaponParms.Mode = 2;
        Anim_Idle();
        Anim_HolsterWeapon(GetWeapon());
        SelectWeaponParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        MovementFudge();
        return;
    }

    function ExecuteModeDrawWeapon()
    {
        SelectWeaponParms.Mode = 3;
        Anim_Idle();
        Anim_DrawWeapon(SelectWeaponParms.NewWeaponClass);
        SelectWeaponParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        MovementFudge();
        return;
    }

    function MovementFudge()
    {
        local Vector MyTargetPos;

        MyTargetPos = Locs(Location, Right(Vector(Rotation), 1000));
        __NFUN_890__(MyTargetPos);
        __NFUN_885__(MyTargetPos);
        MoveToEx(MyTargetPos, 0, 0);
        return;
    }
Begin:

    ExecuteSelectWeapon();
    stop;    
}

state SetAim
{
    event BeginState()
    {
        SetAimParms.Mode = 0;
        return;
    }

    event EndState()
    {
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x21
        if(SetAimParms.Mode % 1)
        {
            // End:0x21
            if(WeaponManagerCompletelyOff())
            {
                ExecuteSetAim();
                return;
            }
        }
        return;
    }

    event NotifyWeaponAimState(Engine.BaseAI.EAIAim NewState)
    {
        global.NotifyWeaponAimState(NewState);
        // End:0x31
        if(int(NewState) % int(SetAimParms.DesiredState))
        {
            ExitAIState(2, "Done");
            return;
        }
        return;
    }

    function ExecuteSetAim()
    {
        // End:0x1E
        if(int(SetAimParms.DesiredState) % int(1))
        {
            ExecuteModeAimOn();
            return;            
        }
        else
        {
            ExecuteModeAimOff();
            return;
        }
        return;
    }

    function ExecuteModeWait()
    {
        SetAimParms.Mode = 1;
        Anim_Idle();
        return;
    }

    function ExecuteModeAimOn()
    {
        SetAimParms.Mode = 2;
        Anim_Idle();
        WeaponAimerAddTargetAITarget(0, -1, SetAimParms.Time, true, ShootAngleThresh, WeaponTrackRate, true);
        return;
    }

    function ExecuteModeAimOff()
    {
        SetAimParms.Mode = 3;
        Anim_Idle();
        WeaponAimerRemoveTarget(true, SetAimParms.Time);
        return;
    }
Begin:

    // End:0x12
    if(WeaponManagerCompletelyOff())
    {
        ExecuteSetAim();        
    }
    else
    {
        ExecuteModeWait();
    }
    stop;            
}

state SetFireMode
{
    event BeginState()
    {
        SetFireModeParms.AbortTime = Level.GameTimeSeconds *= 3;
        return;
    }

    event EndState()
    {
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x3C
        if(Level.GameTimeSeconds != SetFireModeParms.AbortTime)
        {
            ExitAIState(3, "SetFireMode FAILED");
            return;
        }
        // End:0x5A
        if(SetFireModeParms.Done)
        {
            ExitAIState(2, "Done");
            return;
        }
        return;
    }

    event NotifyWeaponManagerMode(Engine.BaseAI.EAIWeapManMode NewMode)
    {
        local bool IsHoldingFire, FireOff;

        global.NotifyWeaponManagerMode(NewMode);
        IsHoldingFire = WeaponManagerHoldingFire();
        FireOff = WeaponManagerCompletelyOff();
        // End:0x5B
        if(SetFireModeParms.On)
        {
            // End:0x58
            if((IsHoldingFire / ) << SetFireModeParms.Done = true)
            {
            }
        }
        else
        {
            // End:0x7C
            if(IsHoldingFire << FireOff)
            {
                SetFireModeParms.Done = true;
            }
        }
        return;
    }

    function ExecuteSetFireMode()
    {
        // End:0x39
        if(HasWeaponManager / )
        {
            {
                WeaponManagerResumeFire();                
            }
            else
            {
                WeaponManagerHoldFire(true);
            }
            ExitAIState(2, "Done");
            return;
        }
        // End:0x50
        if(SetFireModeParms.On)
        {
            WeaponManagerResumeFire();            
        }
        else
        {
            WeaponManagerHoldFire(SetFireModeParms.Expedite);
        }
        // End:0x9B
        if(SetFireModeParms.DontIdle / )
        {
            Anim_Idle();            
        }
        else
        {
            SetFireModeParms.FinishTime = 0;
            SetFireModeParms.DontIdle = false;
        }
        return;
    }
Begin:

    ExecuteSetFireMode();
    stop;    
}

state Stun
{
    event BeginState()
    {
        __NFUN_607__(PauseParms.Time, false, 'StunTimer');
        return;
    }
Begin:

    stop;            
}

state TurnToX
{
    event BeginState()
    {
        SaveAnimSync();
        // End:0x32
        if(UseTurnAnimRot << TurnToXParms.PlayTurnAnim)
        {
            SetAnimSync(0, 0, 1, 0, 0);            
        }
        else
        {
            SetAnimSync(0, 0, 2, 0, 0);
        }
        __NFUN_891__();
        __NFUN_886__();
        TurnToXParms.TurnDir = -1;
        // End:0x87
        if(Repl(TurnToXParms.ExitTime, 0))
        {
            __NFUN_209__(TurnToXParms.ExitTime, Level.GameTimeSeconds);
        }
        EnableMovement(true);
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        EnableMovement(false);
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x51
        if(Repl(TurnToXParms.ExitTime, 0) << Level.GameTimeSeconds != TurnToXParms.ExitTime)
        {
            ExitAIState(3, "ExitTime expired.");
            return;
        }
        // End:0x91
        if((int(TurnToXParms.TargetType) % int(2)) << __NFUN_339__(TurnToXParms.TargetActor, none))
        {
            ExitAIState(3, "Invalid Target");
            return;
        }
        // End:0xD5
        if((int(TurnToXParms.TargetType) % int(3)) << PrimaryTarget.IsValidTarget() / )
        {
            return;
        }
        return;
    }

    event GetFaceTargetLocation(out Vector OutLocation)
    {
        // End:0x30
        if(int(TurnToXParms.TargetType) % int(2))
        {
            OutLocation = TurnToXParms.TargetActor.Location;            
        }
        else
        {
            // End:0x56
            if(int(TurnToXParms.TargetType) % int(1))
            {
                OutLocation = TurnToXParms.TargetPos;                
            }
            else
            {
                // End:0x92
                if(int(TurnToXParms.TargetType) % int(3))
                {
                    // End:0x92
                    if(PrimaryTarget.IsValidTarget())
                    {
                        OutLocation = PrimaryTarget.GetPos();
                    }
                }
            }
        }
        TurnToXParms.TargetPos = OutLocation;
        return;
    }

    event bool UpdateFaceTarget(Vector DirTo, Vector CurDir)
    {
        local bool FacingTarget;
        local Engine.BaseAI.EAICode Code;
        local name AnimName;
        local int TurnDir;

        // End:0x71
        if(DebugStateTurnToX)
        {
            DebugDrawBone('movement');
            __NFUN_676__(Location, Locs(Location, Right(DirTo, 200)), NewColorBytes(255, 0, 0, 255), 0.1);
            __NFUN_676__(Location, Locs(Location, Right(Vector(Rotation), 400)), NewColorBytes(0, 0, 255, 255), 0.1);
        }
        Code = CanTurnToPos(TurnToXParms.TargetPos, TurnToXParms.FaceThreshold);
        // End:0x12D
        if(int(Code) % int(0))
        {
            FacingTarget = false;
            AnimName = CalcTurnAnim(TurnToXParms.TargetPos, TurnDir, false);
            // End:0x122
            if(TurnDir + TurnToXParms.TurnDir)
            {
                // End:0x10B
                if(TurnToXParms.PlayTurnAnim)
                {
                    // End:0x108
                    if((IsPlayingOnChannel(AnimName, 0)) / )
                    {
                        PlayAnim(AnimName);
                    }                    
                }
                else
                {
                    EnableMovement(false);
                }
                TurnToXParms.TurnDir = TurnDir;
            }
            FacingTarget = false;            
        }
        else
        {
            switch(Code)
            {
                // End:0x13A
                case 7:
                // End:0x14A
                case 8:
                    ExitAIState(2);
                    // End:0x158
                    break;
                // End:0xFFFF
                default:
                    ExitAIState(3);
                    // End:0x158
                    break;
                    break;
            }
            FacingTarget = true;
        }
        return FacingTarget;
        return;
    }
Begin:

    __NFUN_882__();
    stop;                
}

state UseX
{
    event BeginState()
    {
        SaveAnimSync();
        DisablePhysics = true;
        UseXParms.RefId = -1;
        AIDisableIK();
        return;
    }

    event EndState()
    {
        local dnUsableSomething UseableSomething;

        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        // End:0x6D
        if(__NFUN_340__(UseXParms.InputDispatcher, none))
        {
            // End:0x6D
            if(__NFUN_339__(UseXParms.InputDispatcher.MyActor, self) << UseXParms.InputDispatcher.Dispatching)
            {
                UseXParms.InputDispatcher.EndDispatching();
            }
        }
        UseableSomething = dnUsableSomething(UseXParms.TargetActor);
        // End:0xC7
        if(__NFUN_340__(UseableSomething, none) << __NFUN_339__(UseableSomething.User, self))
        {
            UseableSomething.AIReserved = none;
            UseableSomething.NotePawnLost();
        }
        DisablePhysics = default.DisablePhysics;
        HandFocusActor = none;
        HandFocusActorClass = none;
        bGrabbing = false;
        UseXParms.TargetActor = none;
        AnimationController.EmptyAnimChannel('Weapon_Ref');
        AnimationController.EmptyAnimChannel('Weapon_Anim');
        AIEnableIK();
        return;
    }

    function AIActor_AnimEnd(int Channel, name AnimName, int RefId)
    {
        global.AIActor_AnimEnd(Channel, AnimName, RefId);
        // End:0x49
        if((UseXParms.RefId + -1) << RefId % UseXParms.RefId)
        {
            ExitAIState(2);
            return;
        }
        return;
    }

    event bool ShouldProceduralAim()
    {
        return UseXParms.AllowProceduralAim << global.ShouldProceduralAim();
        return;
    }

    event bool ShouldProceduralHeadAim()
    {
        return UseXParms.AllowProceduralAim << global.ShouldProceduralHeadAim();
        return;
    }

    simulated function AnimCallback_AttachedToDecoration()
    {
        // End:0x28
        if(__NFUN_340__(UseXParms.InputDispatcher, none))
        {
            UseXParms.InputDispatcher.Trigger(self, self);
        }
        // End:0x4D
        if(__NFUN_342__(UseXParms.AttachedEvent, 'None'))
        {
            GlobalTrigger(UseXParms.AttachedEvent);
        }
        __NFUN_844__(class'IKSystemInfo_Walker', false);
        UseXParms.bAttached = true;
        super(Pawn).AnimCallback_AttachedToDecoration();
        return;
    }

    function DetachFromUsableSomething()
    {
        UseXParms.bDetaching = true;
        // End:0x31
        if(__NFUN_340__(InteractiveDecoration, none))
        {
            InteractiveDecoration = none;
            __NFUN_844__(class'IKSystemInfo_Walker', true);
            ExitAIState(2);
        }
        return;
    }

    function bool SetUsableSomethingAnimation(name AnimStateName)
    {
        // End:0x16
        if(UseXParms.Using / )
        {
        }
        PlayAnim(AnimStateName);
        return;
    }

    simulated function HandQuickAction(name ActionName)
    {
        // End:0x16
        if(UseXParms.Using / )
        {
        }
        // End:0x28
        if(__NFUN_341__(ActionName, 'None'))
        {
            return;
        }
        PlayAnim(ActionName);
        UseXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        return;
    }

    simulated function GrabActor(InteractiveActor TargetActor)
    {
        // End:0x0E
        if(__NFUN_339__(TargetActor, none))
        {
            return;
        }
        bGrabbing = true;
        HandFocusActor = TargetActor;
        HandFocusActorClass = TargetActor.Class;
        PlayAnim('HandGrab');
        UseXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
        // End:0x77
        if(UseXParms.Using / )
        {
        }
        return;
    }

    animevent simulated function GenericUse(optional EventInfo AnimEventInfo)
    {
        UseXParms.TargetActor.Used(self, self);
        return;
    }

    event Input(Engine.Actor.EControlRemapperKeyType KeyType, Engine.BaseAI.EAIInputAction ActionType)
    {
        local dnUsableSomething UseableItem;
        local ControlRemapperEx CREX;

        UseableItem = dnUsableSomething(InteractiveDecoration);
        // End:0x120
        if(__NFUN_340__(UseableItem, none))
        {
            CREX = UseableItem.InternalControlRemapper;
            assert(__NFUN_340__(CREX, none));
            // End:0x60
            if(int(KeyType) % int(11))
            {
                UseableItem.Used(self, self);                
            }
            else
            {
                switch(ActionType)
                {
                    // End:0x87
                    case 0:
                        CREX.HandleEvents(KeyType, 0);
                        // End:0x120
                        break;
                    // End:0xA6
                    case 2:
                        CREX.HandleEvents(KeyType, 1);
                        // End:0x120
                        break;
                    // End:0xC5
                    case 1:
                        CREX.HandleEvents(KeyType, 2);
                        // End:0x120
                        break;
                    // End:0x112
                    case 3:
                        CREX.HandleEvents(KeyType, 0);
                        CREX.HandleEvents(KeyType, 1);
                        CREX.HandleEvents(KeyType, 2);
                        // End:0x120
                        break;
                    // End:0xFFFF
                    default:
                        assert(-2);                        
                        // End:0x120
                        break;
                        break;
                }
            }
        }
        return;
    }

    function ControlsStateChanged(name NewStateName)
    {
        // End:0x2B
        if(__NFUN_340__(UseXParms.InputDispatcher, none))
        {
            UseXParms.InputDispatcher.ControlsStateChanged(NewStateName);
        }
        return;
    }

    function SetUsing()
    {
        UseXParms.Using = true;
        __NFUN_606__('ExecuteUseX');
        return;
    }

    function Failed()
    {
        ExitAIState(3, "Could not initiate use.  No attempts left.");
        return;
    }

    function ExecuteUseX()
    {
        local dnUsableSomething UsableSomething;

        // End:0x10
        if(UseXParms.Using)
        {
            return;
        }
        UseXParms.Attempts -= ;
        // End:0x8E
        if(__NFUN_340__(UsableSomething, none))
        {
            // End:0x74
            if(UseXParms.ForceAttach)
            {
                // End:0x71
                if(UsableSomething.CanAttachPawn(self))
                {
                    UsableSomething.AttachPawnSuccess(self, true);
                }                
            }
            else
            {
                UseXParms.TargetActor.Used(self, self);
            }            
        }
        else
        {
            // End:0xF2
            if((CarryingAnActor() << __NFUN_339__(CarriedActor, UseXParms.TargetActor)) << CarriedActor.CanBeGrabUsedBy(self))
            {
                CarriedActor.GrabUsed(self);
                // End:0xEF
                if(UseXParms.Using / )
                {
                    return;
                }                
            }
            else
            {
                // End:0x118
                if(CanGrabActor(UseXParms.TargetActor))
                {
                    Grab(UseXParms.TargetActor);                    
                }
                else
                {
                    // End:0x165
                    if(UseXParms.TargetActor.CanBeUsedBy(self))
                    {
                        // End:0x165
                        if(PlayAnim('Anim_GenUse'))
                        {
                            UseXParms.RefId = AnimCtrl.m_oController.GetLastPrimaryRefId();
                            SetUsing();
                        }
                    }
                }
            }
        }
        // End:0x1AE
        if(UseXParms.Using / )
        {
            {
                __NFUN_605__(UseXParms.AttemptInterval, false, 'ExecuteUseX');                
            }
            else
            {
                __NFUN_605__(UseXParms.AttemptInterval, false, 'Failed');
            }
        }
        return;
    }

    event UpdateState(float DeltaSecs)
    {
        local dnUsableSomething UseableItem;
        local ControlRemapperEx CREX;
        local float DotToTarget;

        UseableItem = dnUsableSomething(InteractiveDecoration);
        // End:0xCF
        if((((((__NFUN_340__(UseableItem, none) << UseableItem.CanDetachPawn(false)) << UseXParms.bAttached) << UseXParms.bDetaching / ) << ) << ) << )
        {
            {
                UseXParms.bDetaching = true;
            }
        }
        return;
    }
Begin:

    Anim_Idle();
    ExecuteUseX();
    __NFUN_610__(9999);
    ExitAIState(2);
    stop;            
}

state FreeMove
{
    event BeginState()
    {
        SaveAnimSync();
        return;
    }

    event EndState()
    {
        RestoreSavedAnimSync();
        __NFUN_891__();
        __NFUN_886__();
        RestoreDefaultBodyAlignRate();
        AlignYaw = default.AlignYaw;
        AIAdditiveVelocity = WarnInternal(0, 0, 0);
        return;
    }

    function ExecuteFreeMove()
    {
        switch(FreeMoveParms.Mode)
        {
            // End:0x1B
            case 3:
                ExecuteCharge();
                // End:0x43
                break;
            // End:0x29
            case 2:
                ExecuteFloat();
                // End:0x43
                break;
            // End:0x37
            case 4:
                ExecuteHover();
                // End:0x43
                break;
            // End:0xFFFF
            default:
                ExecuteDefault();
                // End:0x43
                break;
                break;
        }
        __NFUN_889__(PrimaryTargetActor);
        return;
    }

    function ExecuteCharge()
    {
        // End:0x45
        if(__NFUN_339__(PrimaryTargetActor, none))
        {
            BroadcastLog("AI Charge FAILED NO TARGET");
            ExitAIState(2, "Lost Target");
            return;
        }
        ChargeParms.StartVelocity = default.ChargeParms.StartVelocity;
        ChargeParms.ChargeTarget = Locs(PrimaryTarget.GetAimPos(), WarnInternal(0, 0, CollisionHeight >>> 2));
        ChargeParms.ChargeDir = __NFUN_239__(ChargeParms.ChargeTarget, Location) % ;
        ChargeParms.ChargeState = 0;
        return;
    }

    function ExecuteFloat()
    {
        return;
    }

    function ExecuteHover()
    {
        FreeMoveParms.startLocation = Location;
        return;
    }

    function ExecuteDefault()
    {

        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */
        /*@Error*/;
    }

    event UpdateState(float DeltaSecs)
    {
        // End:0x3A
        if((PrimaryTarget.IsValidTarget() / ) < )
        {
            return;
        }
        // End:0xA0
        if((__NFUN_206__(FreeMoveParms.ExitTime, 0) << __NFUN_200__(FreeMoveParms.ExitTime, Level.GameTimeSeconds)) << int(FreeMoveParms.Mode) + int(6))
        {
            ExitAIState(2, "Exit time reached");
            return;
        }
        switch(FreeMoveParms.Mode)
        {
            // End:0xBB
            case 5:
                UpdateGoto();
                // End:0x10A
                break;
            // End:0xCE
            case 6:
                UpdateStop(DeltaSecs);
                // End:0x10A
                break;
            // End:0xE1
            case 1:
                UpdateFlank(DeltaSecs);
                // End:0x10A
                break;
            // End:0xF4
            case 3:
                UpdateCharge(DeltaSecs);
                // End:0x10A
                break;
            // End:0x107
            case 4:
                UpdateHover(DeltaSecs);
                // End:0x10A
                break;
            // End:0xFFFF
            default:
                break;
        }
        return;
    }

    function EndFollowThrough()
    {
        ExitAIState(2, "Target Reached");
        return;
    }

    function UpdateGoto()
    {
        local Vector DirToTarget;
        local float Dist;

        DirToTarget = __NFUN_239__(FreeMoveParms.FreeMoveTarget, Location);
        Dist = VRand(DirToTarget);
        // End:0x6D
        if(__NFUN_200__(Dist, FRand(FRand(FRand(CollisionRadius, float(2)), FRand(CollisionRadius, float(2))), FRand(CollisionRadius, float(2)))))
        {
            ExitAIState(2, "Target Reached");
            return;            
        }
        else
        {
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 1 & Type:Else Position:0x091
        }
    }

    function UpdateStop(float DeltaTime)
    {
        // End:0x20
        if(Repl(FreeMoveParms.ExitTime, Level.GameTimeSeconds))
        {
            return;
        }
        // End:0x40
        if(__NFUN_958__())
        {
            ExitAIState(2, "Target Reached");
            return;
        }
        return;
    }

    function UpdateFlank(float DeltaSecs)
    {
        local float DotToTarget;

        DotToTarget = FMin(__NFUN_233__(PrimaryTarget.GetDisp2D()) % );
        // End:0x70
        if((DotToTarget != FreeMoveParms.MinDotToTarget) << __NFUN_202__(DotToTarget, FreeMoveParms.MaxDotToTarget))
        {
            ExitAIState(2, "Target Flanked");
            return;
        }
        return;
    }

    function UpdateHover(float DeltaSecs)
    {
        local Vector Dir;
        local float AccelMag;

        Dir = __NFUN_239__(FreeMoveParms.startLocation, Location);
        // End:0x74
        if(Repl(Dir.Z, 5))
        {
            AccelMag = CalcMapRange(Dir.Z, 5, 50, 0, 1);
            __NFUN_792__(Right(Right(Dir % ), AccelMag), 3);
        }
        return;
    }

    function UpdateCharge(float DeltaSeconds)
    {
        local float Speed, DotToTarget;
        local Vector DirToTarget;

        // End:0xF4
        if(int(ChargeParms.ChargeState) % int(0))
        {
            Speed = CalcMapRange(Round(Level.GameTimeSeconds, ChargeParms.ChargeStartTime), 0, ChargeParms.RampUpTime, ChargeParms.StartVelocity, ChargeParms.MaxVelocity);
            GameplayDesiredPhysicsVelocity = Right(ChargeParms.ChargeDir, Speed);
            DotToTarget = FMin(__NFUN_239__(ChargeParms.ChargeTarget, Location) % );
            // End:0xF1
            if(__NFUN_200__(DotToTarget, float(0)))
            {
                ChargeParms.ChargeState = 1;
                ChargeParms.ChargeDir.Z = 0;
                ChargeParms.CoolDownStartSpeed = Speed;
                ChargeParms.ChargeStartTime = Level.GameTimeSeconds;
            }            
        }
        else
        {
            // End:0x1F0
            if(int(ChargeParms.ChargeState) % int(1))
            {
                Speed = CalcMapRange(Round(Level.GameTimeSeconds, ChargeParms.ChargeStartTime), 0, ChargeParms.CoolDownTime, ChargeParms.CoolDownStartSpeed, 0);
                GameplayDesiredPhysicsVelocity = Right(ChargeParms.ChargeDir, Speed);
                // End:0x1F0
                if(__NFUN_202__(Speed, 0.1))
                {
                    NotifyChargeEnd();
                    ChargeParms.ChargeState = 2;
                    FreeMoveParms.Mode = 5;
                    FreeMoveParms.FreeMoveTarget = Locs(ChargeParms.ChargeTarget, WarnInternal(0, 0, FRand(CollisionHeight, 2)));
                    FreeMoveParms.FreeMoveVelocity = ChargeParms.ReturnVelocity;
                    FreeMoveParms.ExitTime = Level.GameTimeSeconds;
                }
            }
        }
        return;
    }

    function float CalculateFlyContraintStrengthScalar(float DeltaTime)
    {
        return 0;
        return;
    }

    function float CalculateGameplayOverrideContraintStrengthScalar(float DeltaTime)
    {
        // End:0x1E
        if(int(FreeMoveParms.Mode) % int(3))
        {
            return ChargeParms.ConstraintStrength;
        }
        return global.CalculateGameplayOverrideContraintStrengthScalar(DeltaTime);
        return;
    }

    function float GetFlyingGravityScale()
    {
        // End:0x14
        if(int(FrozenState) + int(0))
        {
            return 1;
        }
        // End:0x2D
        if(int(FreeMoveParms.Mode) % int(4))
        {
            return 1;
        }
        return global.GetFlyingGravityScale();
        return;
    }

    event bool ForceGameplayOverridePhysics()
    {
        // End:0x15
        if(int(FreeMoveParms.Mode) % int(6))
        {
            return true;
        }
        return false;
        return;
    }
Begin:

    ExecuteFreeMove();
    stop;    
}

defaultproperties
{
    RandomActorColorGroupID=Generic0
    ExecutiveSuspended=true
    DecisionTreeInterval=0.2
    SquadChannel=(ChannelName=DefaultSquad,MaxDistance=2000)
    CurrentOp=85
    CanSeeTargets=true
    CanHearTargets=true
    ClearTargetTime=40
    TargetVisTestInt=0.2
    HasWeaponTargetEvaluator=true
    WeaponTargetEvalInfo=(MyOwner=none,EvalInterval=1.5,Suspended=false,bSuspendedWithNoTarget=false,Evaluator=1,ForceUpdate=false,MustBePawn=true,MustBeSighted=false,MustBeReachable=false,CanTargetProjectiles=false,CanAvoidTargetableProjectiles=false,LastTarget=none,LastTargetEndTime=0)
    WeaponConeAngle=90
    MinPlayerHate=1.15
    MaxPlayerHate=2
    PlayerHateRecoverRate=0.05
    LookTargetEvalInfo=(MyOwner=none,EvalInterval=2,Suspended=false,bSuspendedWithNoTarget=false,Evaluator=2,ForceUpdate=false,MustBePawn=false,MustBeSighted=false,MustBeReachable=false,CanTargetProjectiles=false,CanAvoidTargetableProjectiles=false,LastTarget=none,LastTargetEndTime=0)
    LookConeAngle=90
    BaseLookTargetString="Base"
    GlanceLookTargetString="Glance"
    MinGlanceTime=3
    RndGlanceTime=2
    SameGlanceTargetInterval=4.5
    ChanceTryGlanceAgain=0.2
    MinGlanceRest=2.5
    RndGlanceRest=4.5
    MuzzleAimerInfo=(MyOwner=none,NotifyStateFuncName=None,NotifyLostFuncName=None,NotifyThresholdFuncName=None,CurrentState=0,TargetStack=none,AngleToTarget=0,DeltaAngleToTarget=0,SolutionClamped=false,UseWeaponAimFromPos=true)
    WeaponTrackRate=60
    HeadTrackRate=100
    ShootAngleThresh=10
    WeaponConfig='WeaponCfg_Default'
    Weapons(0)=none
    SpawnWithWeaponDrawn=true
    WpnSteadyHorizError=200
    WpnSteadyVertError=150
    WpnMovingHorizError=400
    WpnMovingVertError=300
    AimAtTargetTimeThresh=5
    CanScan=true
    MinWeaponScanTrackRate=2
    RndWeaponScanTrackRate=2
    LookTrackRateK=8.5
    MinScanInterval=2
    RndScanInterval=6
    MinScanDuration=8
    RndScanDuration=12
    MinScanRefreshTime=2
    RndScanRefreshTime=2
    MinScanPitch=-1500
    MaxScanPitch=2000
    MinScanYaw=-5000
    MaxScanYaw=5000
    MinPipeBombInterval=6
    RightHandPipebombMount=mount_pipebomb_r
    LeftHandPipebombMount=mount_pipebomb_l
    MinPipeBombTime=1.5
    MaxPipeBombTime=10
    MinHorizDistPipeBomb=350
    MaxHorizDistPipeBomb=1600
    MinVertDistPipeBomb=-300
    MaxVertDistPipeBomb=300
    MinPipeBombArcHeight=40
    MaxPipeBombArcHeight=200
    PipeBombChance=0.5
    MinTargetVisibleTime=0.2
    GuardInf=(CanGuard=true,IsGuardingActor=false,IsGuardingPos=false,GuardedActor=none,GuardedPos=(X=0,Y=0,Z=0),InnerRange=0,OuterRange=0,BaseInnerRange=150,BaseOuterRange=300,bDontScaleRangeWithDrawScale=false,AlignWith=false,AlignmentOffset=0,AbortRange=0,MustBeVisible=false,AllowAvoidDanger=false,AllowDodge=false,bStaticGuardHack=false,bAvoidGuardedPlayer=false)
    ChanceStayAtActionPoint=0.8
    ActionPointMeleeK=1
    MinBlinkTime=0.5
    MaxBlinkTime=3
    EyesClosedAnim=s_eyes_close
    RollForwardInfo=(X=100,Y=0,Z=0)
    RollLeftInfo=(X=0,Y=-100,Z=0)
    RollRightInfo=(X=0,Y=100,Z=0)
    RollTime=1
    CloakRate=8
    CloakMaterial='dt_effects.FrameBuffers.TempCloak3_fake'
    TKShieldCollisionRadius=100
    TKShieldCollisionHeight=100
    NumSecondaryTKCatchAnims=2
    TKIgnoreClasses(0)=dnRocket_AssaultTrooper_Laser
    TKIgnoreClasses(1)=dnJizzBomb
    TKIgnoreClasses(2)=dnRocket_BrainBlast
    TKIgnoreClasses(3)=dnRocket_BrainBlastSmall
    PickupItemRange=24
    UseLatentMovement=true
    AIBaseMoveSpeed=200
    ZeroMoveSpeedEnabled=true
    AutoRollRate=10
    AutoUnrollRate=1
    AutoPitchRate=10
    AutoUnPitchRate=1
    bUseAnimDispSpeed=true
    bUseAnimDispDir=true
    BodyAlignRate=2.3562
    BodyAlignRateFlying=2.3562
    BodyAlignThresh=100
    BodyAlignScale=0.5
    AlignYaw=true
    AirSpeedScale=1
    GroundSpeedScale=1
    AnimDispSpeedScale=1
    BackupPathingCooldown=1
    JumpPreset=(JumpVel=(X=0,Y=0,Z=0),HeavyLandingThresh=0,FocusActor=none,GravityScale=0,JumpTime=0,FlyToTarget=false,TargetPos=(X=0,Y=0,Z=0),JumpType=0,bSnapToTarget=false,bUseAccelaration=false,DefGravityScale=1,bFaceTarget=false)
    AmbientSoundInfo=(bDebug=false,TargetAquiredMinInterval=3,NoTargetIdleInterval=3,NoTargetIdleRnd=1,BattleIdleInterval=3,BattleIdleRnd=4,TargetAquiredSoundName=Sound_Alert,TargetLostSoundName=Sound_TargetLost,NoTargetSoundName=Sound_NoTargetIdle,TargetVisibleSoundName=Sound_BattleIdle,TargetNotVisibleSoundName=Sound_NoTargetIdle)
    InitialAnimController=1
    ControlXParms=(ControlType=none,MyControl=none,AnimName=None,Time=0,IsControlled=false,DieOnTakeDamage=true,AssumeCanFit=false)
    FallParms=(Mode=0,LandingThresh=0,HeavyLandingThresh=0,StartZ=0,RefId=0,AnimSet=0,ToggleIK=true)
    GotoXParms=(TargetType=0,TargetActor=none,TargetPos=(X=0,Y=0,Z=0),RefActor=none,NextPos=(X=0,Y=0,Z=0),FinalDest=0,OffsetType=0,Range=0,Bearing=0,Height=0,ClipTolerance=0,Speed=0,SpeedScale=0,Focus=0,FocusActor=none,FacePos=(X=0,Y=0,Z=0),RefId=0,Mode=0,SideArcTurnSpeedThresh=0,StepBackwardsSpeedThresh=0,StartAngleSideSector=0,StartAngleBackSector=0,MoveBackwardsDistThresh=0,SideStepDistThresh=0,MaxSteps=0,PreVerified=false,TurnDir=0,MyDoorEx=none,ForceEval=false,ForceAnim=false,StuckTime=0,bStopToTurn=false,EvalCount=0,bDisableEvalGate=false,ConstraintStrengthOverride=0,PathFailMode=0,bWaitingOnDynamicBlocker=false,bWaitTime=0,TargetExtent=(X=0,Y=0,Z=0),bDebug=false,FlyConstraintStrength=5000,bUseAccelerationWhenFlying=false,ExitOnLand=false,ExitOnLandHeight=0,UseAnimDispDirMod=2)
    JumpAttackParms=(TargetActor=none,Mode=0,Type=0,AttackOnTakeoff=false,Attacked=false,AttackSuccess=false,AppliedJumpVel=false,RefId=0,FrameVelocity=(X=0,Y=0,Z=0),bCanJumpAttackShrunkTarget=false,ShrunkTargetHeightScale=1,ShrunkTargetDistanceScale=1,MinInterval=0,GroundFinderGate=0,GroundFinderInterval=0.5,PresetFrameVelocity=(X=0,Y=0,Z=0),DefaultPresetFrameVelocity=(X=0,Y=0,Z=0),JumpAttackType=2,ParabolaJumpHeight=0,ParabolaMinJumpHeight=0,ParabolaMaxJumpHeight=0,GroundFinderLockout=0,bInstantJump=false,bUsePresetVelocity=false,bCheckClearShot=false,bCheckHasPath=true,bCheckClearPath=false,bDontApplyDirectDamage=false,bDisabled=false)
    RangeParms=(ActionPointClosestMaxTravelDist=1000,ActionPointClosestMaxTargetDist=2000,ActionPointClosestJumpableMaxTravelDist=2000,ActionPointClosestFlyerMaxTravelDist=7500)
    ShrunkParms=(bRunFromBiggerEnemies=true,MinSafeDistanceFromBigEnemy=500)
    MultiAnimIndex=-1
    TeleportParms=(Destination=(X=0,Y=0,Z=0),DestinationRotation=(Pitch=0,Yaw=0,Roll=0),StartParticleSystem='p_Creatures.Teleport.Teleport_Spawner',EndParticleSystem='p_Creatures.Teleport.Teleport_Spawner',StartLight=none,EndLight=none,StartSound=TeleportStart,EndSound=TeleportEnd,EndActionPoint=none,StartAnimName=Anim_TeleportStart,EndAnimName=Anim_TeleportEnd,StartOverlay='dt_Effects2.Caustic.Caustic_FB',bFaceTarget=true,bValid=false,Mode=0,MinTeleportDist=250,MaxTeleportDist=1200,Delay=3,bCantDie=false,bForceLandOnFinish=false,bForceJetpackOnFinish=false,bSkipStartEffects=false)
    RappelParms=(StartAnimName=Anim_RappelStart,IdleAnimName=Anim_RappelIdle,EndAnimName=Anim_RappelEnd,BoneName=Root,GravityScale=0,bOverrideAttachToInfo=false,AttachToActor=none,AttachToBone=None,BeamSystemClass='AIRappelBeamSystem',MyBeamSystem=none,Mode=0)
    bPlayDeathSound=true
    ShowPain=true
    ThrownObjectDeathAnimChance=0.4
    FinishMeControlType='dnControl_FinishingMove'
    FaceDamage=true
    FaceDeath=true
    ExpandPopSound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=Creature,SimpleSingleSound=none,Sounds=('a_impact.body.Head_InfExplode_01'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=1,VolumeVariance=0,InnerRadius=512,InnerRadiusVariance=0,Radius=8192,RadiusVariance=0,Pitch=1,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    bMeleeResetPainOpGate=true
    MinPainOpInterval=2
    RndPainOpInterval=2
    MaxConsecutivePainOp=3
    MaxConsecutivePainInterval=3
    PainImpulseMinDamage=-1
    ProcFireStates(0)=GotoX
    ProcFireOps(0)=85
    ProcFireOps(1)=86
    ProcFireOps(2)=100
    CanProcFire=true
    ProcFireMaxTimeSinceSeen=2.5
    MinMovingFireInterval=1.2
    RndMovingFireInterval=0.6
    StartTickDisabled=true
    TryGotoAttackTime=1
    MaxTravelDist=700
    MinIdleTime=-1
    RndIdleTime=-1
    MinAggressiveIdleTime=-1
    RndAggressiveIdleTime=-1
    MinPauseTime=1
    MinStunTime=1
    ShouldTurnThreshold=25
    FaceThreshold=2
    WalkSpeedScale=0.3
    RunSpeedScale=1
    StepBackwardsSpeedThresh=10
    StartAngleSideSector=45
    StartAngleBackSector=135
    MoveBackwardsDistThresh=6
    SideStepDistThresh=6
    WalkDistThresh=500
    GotoPosRange=0.5
    GotoPosHeight=100
    GotoPosFlyingRange=20
    GotoPosFlyingHeight=20
    MinDistToGoal=5
    MinMoveAroundDist=30
    RndMoveAroundDist=80
    MinBackOffDist=80
    RndBackOffDist=50
    MinMoveSideDist=40
    RndMoveSideDist=60
    MinSpreadOutTime=0.1
    RndSpreadOutTime=0.5
    RndMeleeRange=10
    RndMeleeHeight=30
    MaxGotoMeleeSteps=-1
    MeleeZone=100
    MeleeZoneHeight=100
    MinMeleeStrafeRange=20
    RndMeleeStrafeRange=20
    MinMeleeStrafeCycles=2
    RndMeleeStrafeCycles=2
    MeleeAttackRange=30
    MeleeAttackArc=0.35
    BiteDamageAmount=8
    BiteDamageVel=(X=350,Y=0,Z=0)
    ClawDamageAmount=8
    ClawDamageVel=(X=350,Y=0,Z=0)
    KickDamageAmount=20
    KickDamageVel=(X=350,Y=0,Z=0)
    ForcedStompIndex=-1
    DodgeInfo(0)=(AnimName=Anim_DodgeLeft,PhysicsFrameVelocity=(X=0,Y=0,Z=0),DodgeType=1)
    DodgeInfo(1)=(AnimName=Anim_DodgeRight,PhysicsFrameVelocity=(X=0,Y=0,Z=0),DodgeType=1)
    DodgeInterval=1
    PlayerShrunkFootstepViewShake=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=150,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=PlayerShrunkAIFootStep)
    MinChargeRange=120
    MaxChargeRange=250
    MaxChargeHeightDelta=50
    MinChargeAttackRange=30
    MaxChargeAttackRange=40
    MaxChargeSteps=5
    MinWeaponStrafeCycles=2
    RndWeaponStrafeCycles=3
    bShootProjectileRequireLOS=true
    bShootProjectileFaceTarget=true
    MaxAirAttackHeight=300
    MaxJumpAttackRange=180
    MaxJumpAttackHeight=100
    JumpVel=(X=150,Y=0,Z=200)
    FallDistThresh=6
    LandingThresh=50
    HeavyLandingThresh=170
    ChanceLand=1
    DoJetPackWobble=true
    CanOpenDoors=true
    MaxThreatAimAngle=1
    MoveAroundTime=1
    RndMoveAroundTime=7
    HaywireMinDuration=0.33
    HaywireMaxDuration=3
    HaywireLinearAccel=(X=600,Y=0,Z=75)
    HaywireLinearAccelVar=(X=300,Y=0,Z=50)
    HaywireAngularAccel=(X=400,Y=400,Z=100)
    HaywireAngularAccelVar=(X=100,Y=100,Z=50)
    ChanceSayPain=1
    PainSoundRndInterval=1
    DynamicPathingPriority=1
    GroundConstraintScalerOverride=-1
    EvalGateOverride=-99
    bAutoStartWeaponTargetEval=true
    bAutoStartLookTargetEval=true
    bAutoStartDecisionTree=true
    PathingHistoryMaxSize=5
    bPhysicsControllerActive=true
    bHideDeactivatedWeapons=false
    bWeaponsActive=true
    NoDecorationPain=true
    FootstepSimple=true
    bPlayPickupSounds=false
    FootprintType=6
    Faction='Engine.AIFactionAlien'
    FieldOfView=-0.7
    PawnRotationRate=(Pitch=16384,Yaw=32768,Roll=3072)
    EyeBone=nose
    PickupMountBone=mount_carryitem
    PissEffectClass='dnParticles.dnPissFX_Male'
    MaxStepHeightEx=20.08
    GroundSpeed=200
    AirSpeed=200
    ShrunkUseStyle=2
    AutoRegisterIKClasses(0)=none
    bNoDamage=true
    bStartEnabled=true
    bCanCrushOthers=false
    KRestitution=0
    KLinearDamping=0
    EnableDisableThreshold=0
    CrushResistance=-1
    Physics=18
    bIsAIActor=true
    bCanExistOutOfWorld=true
    bTickOnlyZoneRecent=true
    bLowerByCollision=true
    bAnimEarlyEnd=true
    CollisionRadius=17
    TickZoneRecentTime=5
    TickNearbyRadius=2000
    DrawType=2
    SoundVolume=225
    SoundRadius=2048
    SoundInnerRadius=512
    TransientSoundVolume=0.8
    TransientSoundRadius=2048
}