/*******************************************************************************
 * AIDebugHUD generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AIDebugHUD extends AIHUD
    collapsecategories;

var MaterialEx BGMaterial;

simulated function DrawAIHUD(Canvas C)
{
    local float xw, txw, yh, sx, sy;

    local int i, j;
    local class<Weapon> WeaponClass;
    local int LoadedAmmo, TotalAmmo;
    local Inventory Inven;
    local AITarget MyTarget;
    local Engine.BaseAI.EAIExecutive CurExecutive;
    local int NumScripts, ScriptIndex, MethodIndex, CurrentMethodIndex, NumMethods;

    local string TmpString;
    local Actor GuardedActor;
    local Vector GuardedPos;
    local float InnerRange, OuterRange;
    local string GuardString;
    local bool Syncing;
    local AIActor SyncActor;
    local int NumPathCalls, NumActionPointTags;

    // End:0x0E
    if(__NFUN_339__(C, none))
    {
        return;
    }
    sx = FRand(10, HUDScaleX);
    sy = FRand(32, HUDScaleY);
    C.__NFUN_1231__("AI Debug HUD", xw, yh);
    StartColumn(int(sx), int(Round(sy, yh)), int(yh));
    C.__NFUN_1250__(0, 0);
    C.__NFUN_1234__(BGMaterial, float(C.SizeX), float(C.SizeY), 0, 0, 1, 1,,,,, 0.5);
    TmpString = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("AI Debug HUD  (", string(Level.GameTimeSeconds)), ")"), "  ActiveAI: "), string(Level.DebugNumActiveAILastFrame)), "  ExecTicks: ["), string(Level.DebugNumAIExecTicksLastFrame)), "/"), string(Level.DebugNumAIExecTicksAllowedLastFrame)), "]"), "  TargEvals: ["), string(Level.DebugNumAITargetEvalsLastFrame)), "/"), string(Level.DebugNumAIExecTicksAllowedLastFrame)), "]"), "  LookEvals: ["), string(Level.DebugNumAILookEvalsLastFrame)), "/"), string(Level.DebugNumAIExecTicksAllowedLastFrame)), "]");
    // End:0x23A
    if(__NFUN_339__(m_aTarget, none) < m_aTarget.InDanger / )
    {        
    }
    else
    {
        C.DrawColor = RedColor;
        TmpString = __NFUN_302__(TmpString, "  --  DANGER  --  DANGER  --  DANGER --  DANGER --  DANGER --");
    }
    DrawString(C, TmpString);
    // End:0x2BA
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    C.DrawColor = WhiteColor;
    C.__NFUN_1250__(FRand(float(C.SizeX), 0.005), FRand(float(C.SizeY), 0.005));
    C.Style = 5;
    C.DrawColor.R = 0;
    C.DrawColor.G = 0;
    C.DrawColor.B = 0;
    C.__NFUN_1234__(class'WhiteTexture', FRand(float(C.SizeX), 0.99), FRand(float(C.SizeY), 0.655), 1, 1, 1, 1,,,,, 0.5);
    C.__NFUN_1232__("White / Alpha 0.5 / STY_Translucent2");
    C.DrawColor = WhiteColor;
    C.DrawColor = GrayColor;
    StartColumn(int(sx), int(sy), int(yh));
    DrawString(C, "Class:");
    DrawString(C, "Name:");
    DrawString(C, "Tag:");
    DrawString(C, "Event:");
    DrawString(C, "Health:");
    DrawString(C, "Base:");
    DrawString(C, "");
    DrawString(C, "Executive:");
    DrawString(C, "Op:");
    DrawString(C, "OpRef:");
    DrawString(C, "OpStatus:");
    DrawString(C, "OpMustFinish:");
    DrawString(C, "OpShouldFinish:");
    DrawString(C, "State:");
    // End:0x588
    if(m_aTarget.__NFUN_398__('GotoX'))
    {
        DrawString(C, "Avoiding:");
        DrawString(C, "Waiting:");
    }
    Syncing = m_aTarget.IsSyncing(SyncActor);
    // End:0x60A
    if(Syncing)
    {
        // End:0x5DC
        if(m_aTarget.AnimXParms.SyncActor)
        {
            DrawString(C, "SyncActor:");
        }
        DrawString(C, "SyncPos:");
        DrawString(C, "SyncFacePos:");
    }
    DrawString(C, "ScriptTag:");
    DrawString(C, "WeaponMode:");
    DrawString(C, "Constraint:");
    DrawString(C, "");
    DrawString(C, "bUseAnimDispSpeed:");
    DrawString(C, "bUseAnimDispDir:");
    DrawString(C, "bUseAnimRotation:");
    DrawString(C, "bAnimCutScene:");
    DrawString(C, "bUseAcceleration:");
    DrawString(C, "Latent Action: ");
    DrawString(C, "Physics: ");
    DrawString(C, "Velocity:");
    DrawString(C, "Speed:");
    DrawString(C, "Disp:");
    // End:0x791
    if(-int(FRand(m_aTarget.PercentageMoved, 100)))
    {        
        C.DrawColor = RedColor;
    }
    DrawString(C, "Moved:");
    C.DrawColor = GrayColor;
    NumPathCalls = 0;
    i = 0;
    J0x7C7:

    // End:0x812 [Loop If]
    if(-i << )
    {        
        // [Loop Continue]
        i += ;
    }
    // End:0x832
    if(NumPathCalls ** 1)
    {
        C.DrawColor = RedColor;
    }
    DrawString(C, "Unique Paths: ");
    DrawString(C, "Paths ID: ");
    C.DrawColor = GrayColor;
    DrawString(C, "");
    DrawString(C, "Location:");
    DrawString(C, "Rotation:");
    DrawString(C, "Destination:");
    DrawString(C, "DestinationActor:");
    DrawString(C, "BodyTarget:");
    DrawString(C, "BodyTargetActor:");
    // End:0x995
    if(m_aTarget.IsGuardingActor(GuardedActor, InnerRange, OuterRange))
    {
        DrawString(C, "Guarding:");
        GuardString = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(GuardedActor.Name), " ("), string(InnerRange)), ", "), string(OuterRange)), ")");        
    }
    else
    {
        // End:0xA06
        if(m_aTarget.IsGuardingPos(GuardedPos, InnerRange, OuterRange))
        {
            DrawString(C, "Guarding:");
            GuardString = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("(", string(GuardedPos)), ") ("), string(InnerRange)), ", "), string(OuterRange)), ")");
        }
    }
    DrawString(C, "");
    DrawString(C, "PrimaryTarget:");
    DrawString(C, "TimeSinceContact:");
    DrawString(C, "TimeVisible:");
    // End:0xAAD
    if(m_aTarget.HasWeaponAimer)
    {
        DrawString(C, "WeaponTargets:");
        DrawString(C, "WeaponAimer: ");
    }
    // End:0xAD9
    if(m_aTarget.HasHeadAimer)
    {
        DrawString(C, "HeadTargets:");
    }
    DrawString(C, "");
    DrawString(C, "Weapon:");
    DrawString(C, "WeaponClass:");
    DrawString(C, "Ammo:");
    // End:0xB4E
    if(__NFUN_340__(m_aTarget.TKObj, none))
    {
        DrawString(C, "TKObj:");
    }
    // End:0xB7A
    if(__NFUN_340__(m_aTarget.CarriedActor, none))
    {
        DrawString(C, "Carrying:");
    }
    // End:0xBA2
    if(__NFUN_340__(m_aTarget.Prop, none))
    {
        DrawString(C, "Prop:");
    }
    // End:0xBD1
    if(__NFUN_340__(m_aTarget.DesiredProp, none))
    {
        DrawString(C, "DesiredProp:");
    }
    DrawString(C, "");
    DrawString(C, "Inventory:");
    C.DrawColor = LightBlueColor;
    C.__NFUN_1231__("TimeSinceContact:  ", xw, yh);
    __NFUN_209__(sx, xw);
    StartColumn(int(sx), int(sy), int(yh));
    DrawString(C, string(m_aTarget.Class));
    DrawString(C, string(m_aTarget.Name));
    DrawString(C, string(m_aTarget.Tag));
    DrawString(C, string(m_aTarget.Event));
    DrawString(C, string(m_aTarget.Health));
    DrawString(C, string(m_aTarget.Base));
    DrawString(C, "");
    CurExecutive = m_aTarget.GetExecutive();
    // End:0xD5E
    if(m_aTarget.IsExecutiveSuspended())
    {
        DrawString(C, __NFUN_302__(string(__NFUN_365__(class'EAIExecutive', int(CurExecutive))), " SUSPENDED"));        
    }
    else
    {
        DrawString(C, string(__NFUN_365__(class'EAIExecutive', int(CurExecutive))));
    }
    DrawString(C, string(__NFUN_365__(class'EAIOp', int(m_aTarget.GetCurrentOp()))));
    DrawString(C, string(m_aTarget.GetCurrentOpRef()));
    DrawString(C, string(__NFUN_365__(class'EAIOpStatus', int(m_aTarget.GetCurrentOpStatus()))));
    DrawString(C, string(m_aTarget.GetCurrentOpMustFinish()));
    DrawString(C, string(m_aTarget.GetCurrentOpShouldFinish()));
    // End:0xE86
    if(m_aTarget.DieOnExitState)
    {
        C.DrawColor = RedColor;
        TmpString = __NFUN_302__(string(m_aTarget.__NFUN_399__()), " - DIED");
        DrawString(C, TmpString);
        C.DrawColor = LightBlueColor;        
    }
    else
    {
        DrawString(C, string(m_aTarget.__NFUN_399__()));
    }
    // End:0xEF6
    if(m_aTarget.__NFUN_398__('GotoX'))
    {
        DrawString(C, string(m_aTarget.PathInfo.bAvoiding));
        DrawString(C, string(m_aTarget.PathInfo.bWait));
    }
    // End:0xF68
    if(Syncing)
    {
        // End:0xF28
        if(m_aTarget.AnimXParms.SyncActor)
        {
            DrawString(C, string(SyncActor));
        }
        DrawString(C, string(m_aTarget.AnimXParms.TargetSyncPos));
        DrawString(C, string(m_aTarget.AnimXParms.TargetFacePos));
    }
    DrawString(C, string(m_aTarget.ScriptTag));
    // End:0x1031
    if(int(m_aTarget.WeaponManager.Mode) % int(8))
    {
        DrawString(C, __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(string(__NFUN_365__(class'EAIWeapManMode', int(m_aTarget.WeaponManager.Mode))), " ("), string(Round(m_aTarget.WeaponManager.RefreshScanGate, Level.GameTimeSeconds))), "/"), string(Round(m_aTarget.WeaponManager.ScanGate, Level.GameTimeSeconds))), ")"));        
    }
    else
    {
        DrawString(C, string(__NFUN_365__(class'EAIWeapManMode', int(m_aTarget.WeaponManager.Mode))));
    }
    DrawString(C, string(__NFUN_365__(class'EAIAttackConstraint', int(m_aTarget.AttackConstraint))));
    DrawString(C, "");
    DrawString(C, string(m_aTarget.bUseAnimDispSpeed));
    DrawString(C, string(m_aTarget.bUseAnimDispDir));
    DrawString(C, string(m_aTarget.bUseAnimRotation));
    DrawString(C, string(m_aTarget.bAnimCutScene));
    DrawString(C, string(m_aTarget.bUseAcceleration));
    DrawString(C, string(m_aTarget.GetLatentAction()));
    DrawString(C, string(__NFUN_365__(class'EPhysics', int(m_aTarget.Physics))));
    DrawString(C, string(m_aTarget.Velocity));
    DrawString(C, string(Clamp(m_aTarget.Velocity)));
    DrawString(C, string(__NFUN_239__(m_aTarget.Location, m_aTarget.OldLocation)));
    // End:0x11EE
    if(-int(FRand(m_aTarget.PercentageMoved, 100)))
    {        
        C.DrawColor = RedColor;
    }
    DrawString(C, __NFUN_302__(string(int(FRand(m_aTarget.PercentageMoved, 100))), "%"));
    C.DrawColor = LightBlueColor;
    // End:0x124C
    if(NumPathCalls ** 1)
    {
        C.DrawColor = RedColor;
    }
    TmpString = "####################";
    TmpString = TmpString - NumPathCalls;
    TmpString = __NFUN_302__(__NFUN_302__(string(NumPathCalls), " "), TmpString);
    DrawString(C, TmpString);
    DrawString(C, string(m_aTarget.GetRealNAVID()));
    C.DrawColor = LightBlueColor;
    DrawString(C, "");
    DrawString(C, string(m_aTarget.Location));
    DrawString(C, string(m_aTarget.Rotation));
    DrawString(C, string(m_aTarget.__NFUN_887__()));
    DrawActor(C, m_aTarget.__NFUN_888__());
    DrawString(C, string(m_aTarget.__NFUN_892__()));
    DrawActor(C, m_aTarget.__NFUN_893__());
    __NFUN_672__(m_aTarget.__NFUN_892__(), NewColorBytes(255, 0, 0), 1E-05);
    // End:0x13BF
    if(m_aTarget.IsGuarding())
    {
        DrawString(C, GuardString);
    }
    DrawString(C, "");
    MyTarget = m_aTarget.GetTarget(0);
    // End:0x148A
    if(MyTarget.IsValidTarget())
    {
        // End:0x1433
        if(MyTarget.IsAnActor())
        {
            DrawString(C, string(MyTarget.GetActor().Name));            
        }
        else
        {
            DrawString(C, string(MyTarget.GetPos()));
        }
        DrawString(C, string(MyTarget.GetTimeSinceContact()));
        DrawString(C, string(MyTarget.GetTimeVisible()));        
    }
    else
    {
        DrawString(C, "NONE");
        DrawString(C, "N/A");
        DrawString(C, "N/A");
    }
    // End:0x15EC
    if(m_aTarget.HasWeaponAimer)
    {
        TmpString = "";
        i = -- m_aTarget.WeaponAimerGetNumTargets();        
        J0x14EF:

        // End:0x1534 [Loop If]
        if(i / 0)
        {
            TmpString = __NFUN_302__(__NFUN_302__(__NFUN_302__(TmpString, "("), m_aTarget.WeaponAimerGetTargetString(i)), ") ");
            // [Loop Continue]
            i -= ;
        }
        DrawString(C, TmpString);
        TmpString = __NFUN_302__("", string(__NFUN_365__(class'EAIAim', int(m_aTarget.GetWeaponAimerState()))));
        TmpString = __NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__(TmpString, " "), string(m_aTarget.WeaponAimerInfo.AngleToTarget)), " - "), string(m_aTarget.WeaponAimerInfo.DeltaAngleToTarget));
        // End:0x15DC
        if(m_aTarget.WeaponAimerInfo.SolutionClamped)
        {
            TmpString = __NFUN_302__(TmpString, " C");
        }
        DrawString(C, TmpString);
    }
    // End:0x1675
    if(m_aTarget.HasHeadAimer)
    {
        TmpString = "";
        i = -- m_aTarget.HeadAimerGetNumTargets();        
        J0x1620:

        // End:0x1665 [Loop If]
        if(i / 0)
        {
            TmpString = __NFUN_302__(__NFUN_302__(__NFUN_302__(TmpString, "("), m_aTarget.HeadAimerGetTargetString(i)), ") ");
            // [Loop Continue]
            i -= ;
        }
        DrawString(C, TmpString);
    }
    DrawString(C, "");
    // End:0x16DA
    if(m_aTarget.GetCurrentWeapon(WeaponClass, LoadedAmmo, TotalAmmo) / )
    {
        DrawString(C, "N/A");
        DrawString(C, "N/A");        
    }
    else
    {
        DrawString(C, string(WeaponClass));
        DrawString(C, string(m_aTarget.Weapon));
        TmpString = __NFUN_302__(__NFUN_302__(string(LoadedAmmo), "/"), string(TotalAmmo));
        DrawString(C, TmpString);
    }
    // End:0x1762
    if(__NFUN_340__(m_aTarget.TKObj, none))
    {
        DrawString(C, string(m_aTarget.TKObj));
    }
    // End:0x1793
    if(__NFUN_340__(m_aTarget.CarriedActor, none))
    {
        DrawString(C, string(m_aTarget.CarriedActor));
    }
    // End:0x17C4
    if(__NFUN_340__(m_aTarget.Prop, none))
    {
        DrawString(C, string(m_aTarget.Prop));
    }
    // End:0x17F5
    if(__NFUN_340__(m_aTarget.DesiredProp, none))
    {
        DrawString(C, string(m_aTarget.DesiredProp));
    }
    DrawString(C, "");
    Inven = m_aTarget.InventoryListHead;
    J0x1817:

    // End:0x1853 [Loop If]
    if(__NFUN_340__(Inven, none))
    {
        DrawString(C, string(Inven));
        Inven = Inven.NextInventory;
        // [Loop Continue]
        i += ;
    }
    DrawString(C, "");
    DrawString(C, "");
    DrawString(C, "");
    DrawString(C, "");
    DrawString(C, "");
    DrawString(C, "");
    DrawString(C, m_aTarget.TreeDescentLog);
    // End:0x18F9
    if(__NFUN_340__(m_aTarget.AmbientSound, none))
    {
        DrawString(C, "");
        DrawString(C, string(m_aTarget.AmbientSound));
    }
    sx = 290;
    StartColumn(int(sx), int(sy), int(yh));
    C.DrawColor = WhiteColor;
    DrawString(C, __NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_303__(string(__NFUN_365__(class'EAIAnimController', int(m_aTarget.AnimCtrl.m_eController))), "-"), string(m_aTarget.AnimationController)), "|"), string(m_aTarget.AnimCtrl.m_oController)));
    DrawString(C, "--------------------");
    // End:0x1A06
    if(m_aTarget.IsDoingSyncedAnim())
    {
        C.DrawColor = RedColor;
        DrawString(C, "SYNCED:");
        C.DrawColor = GrayColor;        
    }
    else
    {
        C.DrawColor = GrayColor;
        DrawString(C, "Bottom:");
    }
    DrawString(C, "Action:");
    DrawString(C, "Weapon_Aim:");
    DrawString(C, "Weapon_Ref:");
    DrawString(C, "Weapon_Idle:");
    DrawString(C, "Weapon_Anim:");
    DrawString(C, "Eyes:");
    DrawString(C, "LipsNeutral:");
    DrawString(C, "LipSync:");
    // End:0x1CB9
    if(int(CurExecutive) % int(1))
    {
        DrawString(C, "");
        C.DrawColor = WhiteColor;
        DrawString(C, "Script");
        DrawString(C, "------");
        C.DrawColor = GrayColor;
        NumScripts = m_aTarget.ScriptPlayer.GetNumScripts();
        ScriptIndex = 0;
        J0x1B77:

        // End:0x1CB9 [Loop If]
        if(-ScriptIndex)
        {            
            // End:0x1C3A
            if(ScriptIndex % -- NumScripts)
            {                
                C.DrawColor = WhiteColor;
                DrawString(C, "> ");
                C.DrawColor = GrayColor;
                C.__NFUN_1231__("> ", xw, yh);
                m_iCurLine -= ;
                DrawString(C, m_aTarget.ScriptPlayer.GetScriptName(ScriptIndex));
                m_iStartX != int(xw);
                // [Explicit Continue]
                goto J0x1CAF;
            }
            DrawString(C, "  ");
            C.__NFUN_1231__("  ", xw, yh);
            m_iCurLine -= ;
            DrawString(C, m_aTarget.ScriptPlayer.GetScriptName(ScriptIndex));
            m_iStartX != int(xw);
            J0x1CAF:

            // [Loop Continue]
            ScriptIndex += ;
        }
    }
    C.__NFUN_1231__("Weapon_Anim:     ", xw, yh);
    __NFUN_209__(sx, xw);
    StartColumn(int(sx), int(sy), int(yh));
    C.DrawColor = LightBlueColor;
    DrawString(C, "");
    DrawString(C, "");
    DrawAnimInfo(C, m_aTarget, 0);
    DrawAnimInfo(C, m_aTarget, 1);
    DrawAnimInfo(C, m_aTarget, 2);
    DrawAnimInfo(C, m_aTarget, 3);
    DrawAnimInfo(C, m_aTarget, 4);
    DrawAnimInfo(C, m_aTarget, 5);
    DrawAnimInfo(C, m_aTarget, 6);
    DrawAnimInfo(C, m_aTarget, 7);
    DrawAnimInfo(C, m_aTarget, 8);
    // End:0x1FA4
    if(int(CurExecutive) % int(1))
    {
        NumMethods = m_aTarget.ScriptPlayer.GetNumMethods();
        CurrentMethodIndex = Tan(0, -- m_aTarget.ScriptPlayer.GetMethodIndex());        
        DrawString(C, "");
        DrawString(C, "");
        DrawString(C, "");
        DrawString(C, "");
        MethodIndex = 0;
        J0x1E65:

        // End:0x1FA4 [Loop If]
        if(-MethodIndex)
        {            
            // End:0x1F25
            if(MethodIndex % CurrentMethodIndex)
            {
                C.DrawColor = WhiteColor;
                DrawString(C, "> ");
                C.DrawColor = GrayColor;
                C.__NFUN_1231__("> ", xw, yh);
                m_iCurLine -= ;
                DrawString(C, m_aTarget.ScriptPlayer.GetMethodString(MethodIndex));
                m_iStartX != int(xw);
                // [Explicit Continue]
                goto J0x1F9A;
            }
            DrawString(C, "  ");
            C.__NFUN_1231__("  ", xw, yh);
            m_iCurLine -= ;
            DrawString(C, m_aTarget.ScriptPlayer.GetMethodString(MethodIndex));
            m_iStartX != int(xw);
            J0x1F9A:

            // [Loop Continue]
            MethodIndex += ;
        }
    }
    DrawString(C, __NFUN_302__("ActionPoint: ", string(m_aTarget.ActionPoint)));
    DrawString(C, __NFUN_302__("Popup: ", string(m_aTarget.PopUp)));
    NumActionPointTags = string(m_aTarget.ActionPointTags);
    // End:0x2199
    if(NumActionPointTags ** 0)
    {
        DrawString(C, "");
        DrawString(C, "");
        DrawString(C, "");
        i = 0;
        J0x2047:

        // End:0x2199 [Loop If]
        if(-i)
        {            
            // End:0x2123
            if((i % m_aTarget.ActionPointIndex) < i % m_aTarget.ActionPointDesiredIndex)
            {
                C.DrawColor = WhiteColor;
                DrawString(C, "> ");
                C.DrawColor = GrayColor;
                C.__NFUN_1231__("> ", xw, yh);
                m_iCurLine -= ;
                DrawString(C, string(m_aTarget.ActionPointTags[i]));
                m_iStartX != int(xw);
                // [Explicit Continue]
                goto J0x218F;
            }
            DrawString(C, "  ");
            C.__NFUN_1231__("  ", xw, yh);
            m_iCurLine -= ;
            DrawString(C, string(m_aTarget.ActionPointTags[i]));
            m_iStartX != int(xw);
            J0x218F:

            // [Loop Continue]
            i += ;
        }
    }
    C.DrawColor = GrayColor;
    DrawString(C, "");
    // End:0x2334
    if(__NFUN_340__(m_aTarget.PopUp, none))
    {
        DrawString(C, "------------------------");
        DrawString(C, __NFUN_302__("ActionPoint: ", string(m_aTarget.ActionPoint)));
        DrawString(C, __NFUN_302__("Popup: ", string(m_aTarget.PopUp)));
        DrawString(C, "------------------------");
        DrawString(C, __NFUN_302__("Popup DamageTaken: ", string(m_aTarget.PopUpState.DamageTaken)));
        DrawString(C, __NFUN_302__("Popup ShotsFired: ", string(m_aTarget.PopUpState.ShotsFired)));
        C.DrawColor = RedColor;
        DrawString(C, __NFUN_302__("Popup Mode: ", string(m_aTarget.CurrentOpMode)));
        C.DrawColor = GrayColor;
    }
    DrawString(C, "");
    DrawString(C, "------------------------");
    i = 0;
    J0x236D:

    // End:0x244A [Loop If]
    if(-i << )
    {                
        // End:0x2406
        if(Repl(m_aTarget.AIDebugMessageQueue[i].TimeExpire, float(0)) << __NFUN_200__(m_aTarget.AIDebugMessageQueue[i].TimeExpire, Level.GameTimeSeconds))
        {
            m_aTarget.AIDebugMessageQueue.Remove(i, 1);
            // [Explicit Continue]
            i -= ;
        }
        C.DrawColor = WhiteColor;
        DrawString(C, m_aTarget.AIDebugMessageQueue[i].msg);
        J0x2440:

        // [Loop Continue]
        i += ;
    }
    // End:0x27BD
    if(__NFUN_340__(m_aTarget.AnimCtrl.m_oController, none))
    {
        DrawString(C, "------------------------");
        DrawString(C, "");
        DrawString(C, __NFUN_302__(__NFUN_302__(__NFUN_302__("WeaponBone Pitch: ", string(m_aTarget.WeaponBoneAimConstraints.MinViewPitchOffset)), "/"), string(m_aTarget.WeaponBoneAimConstraints.MaxViewPitchOffset)));
        DrawString(C, __NFUN_302__(__NFUN_302__(__NFUN_302__("WeaponBone Yaw:   ", string(m_aTarget.WeaponBoneAimConstraints.MinViewYawOffset)), "/"), string(m_aTarget.WeaponBoneAimConstraints.MaxViewPitchOffset)));
        DrawString(C, __NFUN_302__(__NFUN_302__(__NFUN_302__("HeadAimer Pitch: ", string(m_aTarget.HeadBoneAimConstraints.MinViewPitchOffset)), "/"), string(m_aTarget.HeadBoneAimConstraints.MaxViewPitchOffset)));
        DrawString(C, __NFUN_302__(__NFUN_302__(__NFUN_302__("HeadAimer Yaw:   ", string(m_aTarget.HeadBoneAimConstraints.MinViewYawOffset)), "/"), string(m_aTarget.HeadBoneAimConstraints.MaxViewPitchOffset)));
        DrawString(C, "");
        DrawString(C, "------------------------");
        i = 0;
        J0x2622:

        // End:0x26D4 [Loop If]
        if(-i)
        {            
            DrawString(C, __NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__("Bone #", string(i)), ":"), string(m_aTarget.BoneAim[i].BoneName)), "("), string(m_aTarget.BoneAim[i].Pitch)), ","), string(m_aTarget.BoneAim[i].Yaw)), ")"));
            // [Loop Continue]
            i += ;
        }
        DrawString(C, "-----------BoneHeadAim-------------");
        i = 0;
        J0x270B:

        // End:0x27BD [Loop If]
        if(-i)
        {            
            DrawString(C, __NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(__NFUN_302__("Bone #", string(i)), ":"), string(m_aTarget.BoneHeadAim[i].BoneName)), "("), string(m_aTarget.BoneHeadAim[i].Pitch)), ","), string(m_aTarget.BoneHeadAim[i].Yaw)), ")"));
            // [Loop Continue]
            i += ;
        }
    }
    // End:0x281C
    if(m_aTarget.ProceduralMovingFire)
    {
        DrawString(C, "------------ProceduralMovingFire----");
        DrawString(C, m_aTarget.HUDProceduralFireInfo());
    }
    DrawString(C, "------------ShouldFire----");
    DrawString(C, m_aTarget.ShouldFireStr);
    DrawString(C, __NFUN_302__("CanProcFire: ", string(m_aTarget.CanProcFire)));
    DrawString(C, __NFUN_302__("CanPopupAim: ", string(m_aTarget.CanPopupAim)));
    // End:0x29AC
    if(__NFUN_340__(m_aTarget.Weapon, none))
    {
        DrawString(C, __NFUN_302__("ShotCount: ", string(m_aTarget.WeaponManager.ShotCount)));
        DrawString(C, __NFUN_302__("CanFireWeapon: ", string(m_aTarget.CanFireWeapon())));
        DrawString(C, __NFUN_302__("IsOutOfLoadedAmmo: ", string(m_aTarget.Weapon.IsOutOfLoadedAmmo())));
        DrawString(C, __NFUN_302__("bWeaponFireLockout: ", string(m_aTarget.Weapon.bWeaponFireLockout)));
    }
    // End:0x2A18
    if(int(m_aTarget.WeaponManager.Mode) % int(9))
    {
        DrawString(C, "-------------PreFire-------------------");
        DrawString(C, m_aTarget.HUDPreFireInfo());
    }
    DrawString(C, "------------Guard----");
    DrawString(C, __NFUN_302__("InnerRange: ", string(m_aTarget.GuardInf.InnerRange)));
    DrawString(C, __NFUN_302__("OuterRange: ", string(m_aTarget.GuardInf.OuterRange)));
    DrawString(C, "------------SJump----");
    DrawString(C, __NFUN_302__("JumpParms.Mode: ", string(m_aTarget.JumpParms.Mode)));
    return;
}

exec function ShowAP()
{
    local ActionPoint ap;

    // End:0x1F
    foreach __NFUN_747__(class'ActionPoint', ap)
    {
        ap.__NFUN_590__(false);        
    }    
    return;
}

defaultproperties
{
    BGMaterial='dt_hud.ingame_hud.arcbody'
}