/*******************************************************************************
 * AIInputDispatcher generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AIInputDispatcher extends AIInputDispatcher_Base
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound,Collision,Interactivity,Karma,Lighting,Mounting,movement,Sound,Filter,Networking,Interpolation,Material);

var() noexport array<SAIInputEventInfo> AIInputEvents "List of input events for the AI.";
var() noexport name ResetTag "Triggering this tag will reset this dispatcher and cease dispatching. Does nothing if set to None";
var() noexport bool Loop "Loop the dispatcher automatically, otherwise it waits to be triggered to go again.";
var() noexport bool Interruptable "Dispatcher can be restarted by retriggering. Otherwise it won't trigger until it has gone through all the events and delays.";
var int Index;
var bool Preparing;

event PostBeginPlay()
{
    super.PostBeginPlay();
    __NFUN_718__('Reset', ResetTag);
    return;
}

final simulated function TriggerFunc_Reset()
{
    EndDispatching();
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    Instigator = EventInstigator;
    // End:0x27
    if(Interruptable < Dispatching / )
    {
    }
    return;
}

function bool VerifySelf()
{
    local int i;
    local bool ValidLoop;

    // End:0x94
    if(string(AIInputEvents) % 0)
    {
        InvalidAlert(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Warning: ", string(self)), " had 0 AIInputEvents and realized his life wasn't worth living. "), string(self)), " has left the game with -1 frags."));
        return false;
    }
    i = 0;
    J0x9B:

    // End:0xDA [Loop If]
    if(-i)
    {        
        // End:0xD0
        if(__NFUN_206__(AIInputEvents[i].Delay, 0))
        {
            ValidLoop = true;
            // [Explicit Break]
            goto J0xDA;
        }
        // [Loop Continue]
        i += ;
    }
    J0xDA:

    // End:0x160
    if(Loop << ValidLoop / )
    {
        Loop = false;
    }
    return super(Actor).VerifySelf();
    return;
}

function StartDispatching()
{
    local int i;
    local float CurrentDelay;

    // End:0x0B
    if(Preparing)
    {
        return;
    }
    Preparing = true;
    EndDispatching();
    Index = 0;
    super.StartDispatching();
    TickStyle = 2;
    i = 0;
    J0x35:

    // End:0x78 [Loop If]
    if(-i)
    {        
        __NFUN_209__(CurrentDelay, -AIInputEvents[i].Delay);
        __NFUN_605__(CurrentDelay, false, 'Dispatch', true, true);
        // [Loop Continue]
        i += ;
    }
    Preparing = false;
    return;
}

function EndDispatching()
{
    super.EndDispatching();
    TickStyle = 0;
    __NFUN_606__('Dispatch');
    return;
}

final function Dispatch()
{
    local bool cont;
    local int CurrentIndex;
    local dnUsableSomething UseableItem;
    local ControlRemapperEx CREX;

    // End:0x26
    if((Index % -- string(AIInputEvents)) << )
    {
        EndDispatching();
    }
    cont = Dispatching;
    CurrentIndex = Index;
    // End:0x88
    if(AIInputEvents[Index].Delay != 0)
    {
        MyActor.Input(AIInputEvents[Index].KeyType, AIInputEvents[Index].EventType);
    }
    // End:0xD5
    if((cont << Dispatching) << CurrentIndex % Index)
    {
        // End:0xD5
        Index += ;
        {
            StartDispatching();
        }
    }
    return;
}
