/*******************************************************************************
 * AIInputDispatcher_AirHockey generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AIInputDispatcher_AirHockey extends AIInputDispatcher_Auto
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var dnControl_AirHockeyPlayer HockeyCtler;
var float ShotGate;
var Vector Accel;
var Vector Vel;
var() bool Debug;
var(AirHockeySkill) noexport float MaxShotTime "Maximum time we take a shot over.  (Smaller values produce faster shots.)";
var(AirHockeySkill) noexport float MaxAccel "Maximum allowable magnitude of the grid acceleration.";
var(AirHockeySkill) noexport float MaxAccelVar "Random variance subtracted from MaxAccel to give it a bit of variety.";
var(AirHockeySkill) noexport float MaxVel "Maximum allowable magnitude of the grid velocity.";
var(AirHockeySkill) noexport Vector PullbackVel "Initial pullback velocity (before serve).";
var(AirHockeySkill) noexport Vector PullbackVelVar "Random vartiance added to the initial pullback velocity.";
var(AirHockeySkill) noexport float CenteringDisp "Accelerate towards the centre position with this factor of the current displacement from centre.";
var(AirHockeySkill) noexport float CenteringVel "Decelerate the grid motion by this factor of the current velocity when returning to centre.";

event Tick(float Secs)
{
    super.Tick(Secs);
    // End:0x27
    if(__NFUN_339__(MyActor, none) < __NFUN_339__(HockeyCtler, none))
    {
        return;
    }
    // End:0x4A
    if(HockeyCtler.__NFUN_398__('Play'))
    {
        PlayAirHockey(Secs);        
    }
    else
    {
        Reset();
    }
    return;
}

function Reset()
{
    ShotGate = 0;
    Accel = WarnInternal(0, 0, 0);
    Vel = Sleep(PullbackVel, PullbackVelVar);
    return;
}

function StartDispatching()
{
    super.StartDispatching();
    HockeyCtler = dnControl_AirHockeyPlayer(MyActor.InteractiveDecoration);
    Reset();
    MyActor.HeadAimerRemoveTarget(true, 0.2);
    return;
}

function EndDispatching()
{
    super.EndDispatching();
    // End:0x19
    if(__NFUN_340__(HockeyCtler, none))
    {
        HockeyCtler = none;
    }
    MyActor.HeadAimerRemoveTarget(true, 0.2);
    return;
}

function ControlsStateChanged(name NewStateName)
{
    // End:0x61
    if(__NFUN_341__(NewStateName, 'Play'))
    {
        MyActor.HeadAimerAddTargetActor(HockeyCtler.Table.Puck, 'None', -1, 0.2, true, -1, MyActor.HeadTrackRate, false);        
    }
    else
    {
        MyActor.HeadAimerRemoveTarget(true, 0.2);
    }
    return;
}

function bool CalcShot()
{
    local float ShotTime, MaxAccelThisShot;

    // End:0xEA
    if(HockeyCtler.CalcShot(MaxShotTime, Accel, ShotTime, Debug))
    {
        ShotGate = Level.GameTimeSeconds *= ShotTime;
        Vel = WarnInternal(0, 0, 0);
        /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
            
        */

        // End:0xD4
        /*@Error*/;
        // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 5 & Type:If Position:0x0D4
        // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
        // 5 & Type:If Position:0x0D4
}

function PlayAirHockey(float Secs)
{
    local Vector AvgVel, EndVel;

    assert(__NFUN_340__(HockeyCtler, none));
    // End:0x99
    if(Repl(Level.GameTimeSeconds, ShotGate) << (CalcShot()) / )
    {
    }
    EndVel = Locs(Vel, Right(Accel, Secs));
    AvgVel = Caps(0.5, Locs(Vel, EndVel));
    HockeyCtler.MouseInputX = Normal2D(HockeyCtler.MouseInputX *= FRand(AvgVel.X, Secs), -1, 1);
    HockeyCtler.MouseInputY = Normal2D(HockeyCtler.MouseInputY *= FRand(AvgVel.Y, Secs), -1, 1);
    // End:0x182
    if(-HockeyCtler.MouseInputX != 1)
    {
        Accel.X = 0;
        EndVel.X = 0;
    }
    // End:0x1BD
    if(-HockeyCtler.MouseInputY != 1)
    {
        Accel.Y = 0;
        EndVel.Y = 0;
    }
    MyActor.AnimationController.SetAnimGridState(HockeyCtler.AimGridName, HockeyCtler.MouseInputX, HockeyCtler.MouseInputY);
    Vel = EndVel;
    // End:0x27E
    if(Repl(VRand(Vel), FRand(MaxVel, MaxVel)))
    {
        // End:0x26A
        if(Debug)
        {
            BroadcastLog(__NFUN_302__(__NFUN_302__(__NFUN_302__(__NFUN_302__("Exceeded MaxVel: (", string(Clamp(Vel))), "/"), string(MaxVel)), ")"));
        }
        Vel = Right(Vel % );
    }
    return;
}

defaultproperties
{
    MaxShotTime=0.1
    MaxAccel=90
    MaxAccelVar=50
    MaxVel=25
    PullbackVel=(X=0,Y=-20,Z=0)
    PullbackVelVar=(X=3,Y=-5,Z=0)
    CenteringDisp=20
    CenteringVel=1
}