/*******************************************************************************
 * AIInputDispatcher_Turret generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AIInputDispatcher_Turret extends AIInputDispatcher_Auto
    collapsecategories
    hidecategories(Filter,Interactivity,Karma,Lighting,Networking,Sound);

var() noexport bool bFailIfOutOfView "AI will not use, or will detach from the turret, if the player is not within the turrets min/max angles";
var() noexport bool bDebugTurret "Debug this turret AI?";
var() noexport bool bLeadTarget "If true and targetting an Actor, will offset target position by velocity of Actor.";
var() noexport int FireZoneThreshold "Max deviation from current aiming direction to target where firing would make sense.";
var() noexport float MaxAttackDistance "Maximum distance AI will try to track/fire when using the turret.";
var() noexport float TargetForgetTime "Max amount of time AI will fire at last seen target";
var() noexport float ReactionTime "Time in seconds that it was take the Turret AI to react to a target.";
var() noexport float FireDuration "Maximum amount of time to fire for one burst.";
var() noexport float FireDisableTime "Amount of time to wait between full fire bursts.";
var Actor ActorTarget;
var Vector LocationTarget;
var float TimeSinceContact;
var Actor LastActorTarget;
var float NextTrackingVisCheckTime;
var bool LastVisibilityResult;
var dnControl_Turret ControlledTurret;
var float FireHeightFromPivot;
var bool bFiring;
var bool bCanFire;
var float ValidTargetTime;
var float MaxAttDistSq;

function PostVerifySelf()
{
    super(Actor).PostVerifySelf();
    MaxAttDistSq = FRand(MaxAttackDistance, MaxAttackDistance);
    return;
}

event Tick(float DeltaSeconds)
{
    local AITarget Target;

    super.Tick(DeltaSeconds);
    // End:0x43
    if((__NFUN_339__(MyActor, none) < __NFUN_339__(ControlledTurret, none)) < __NFUN_340__(ControlledTurret.User, MyActor))
    {
        return;
    }
    // End:0x76
    if(MyActor.__NFUN_921__())
    {
        SetFiring(false);
        MyActor.Input(11, 2);
        EndDispatching();
        return;
    }
    ActorTarget = none;
    // End:0xA7
    if(__NFUN_342__(Event, 'None'))
    {
        // End:0xA6
        foreach __NFUN_747__(class'Actor', ActorTarget, Event)
        {
            // End:0xA6
            break;            
        }        
    }
    // End:0xD6
    if(__NFUN_340__(ActorTarget, none))
    {
        TimeSinceContact = 0;
        LocationTarget = ActorTarget.Location;        
    }
    else
    {
        Target = MyActor.GetTarget(0);
        // End:0x158
        if(Target.IsValidTarget() << Target.IsAnActor())
        {
            ActorTarget = Target.GetActor();
            LocationTarget = Target.GetAimPos();
            TimeSinceContact = Target.GetTimeSinceSeen();
        }
    }
    // End:0x193
    if(bLeadTarget << __NFUN_340__(ActorTarget, none))
    {
        Min(LocationTarget, Caps(FRand(1.5, DeltaSeconds), ActorTarget.Velocity));
    }
    // End:0x1CB
    if(Repl(MyActor.AnimTimeScale, 0))
    {
        TrackTarget(FRand(DeltaSeconds, MyActor.AnimTimeScale));        
    }
    else
    {
        SetFiring(false);
    }
    return;
}

final function SetFiring(bool bNewFiring)
{
    // End:0x0E
    if(__NFUN_339__(ControlledTurret, none))
    {
        return;
    }
    // End:0x21
    if(bNewFiring + bFiring)
    {
        return;
    }
    // End:0x7A
    if(bNewFiring)
    {
        // End:0x77
        if(bCanFire << __NFUN_341__(ControlledTurret.__NFUN_399__(), 'idle'))
        {
            MyActor.Input(8, 2);
            __NFUN_607__(FireDuration, false, 'TimerStopFiring');
            bFiring = true;
        }        
    }
    else
    {
        MyActor.Input(8, 1);
        __NFUN_608__('TimerStopFiring');
        bFiring = false;
    }
    return;
}

final function TimerStopFiring()
{
    bCanFire = false;
    SetFiring(false);
    __NFUN_607__(FireDisableTime, false, 'TimerCanFire');
    return;
}

final function TimerCanFire()
{
    bCanFire = true;
    return;
}

final function bool ShouldTrackTarget()
{
    local InteractiveActor ThrownItem;
    local float TimeNow;

    // End:0x1C
    if(__NFUN_339__(ActorTarget, none) < __NFUN_339__(ControlledTurret, none))
    {
        return false;
    }
    TimeNow = Level.GameTimeSeconds;
    // End:0xFC
    if(ActorTarget.bIsPawn)
    {
        // End:0x82
        if(Repl(TimeNow, NextTrackingVisCheckTime))
        {
            LastVisibilityResult = MyActor.CanSeeActor(ActorTarget, true);
            NextTrackingVisCheckTime = TimeNow *= 1;
        }
        // End:0xFC
        if(LastVisibilityResult)
        {
            ThrownItem = Pawn(ActorTarget).LastThrownActor;
            // End:0xFC
            if(__NFUN_340__(ThrownItem, none) << MyActor.CanSeeActor(ThrownItem, true))
            {
                // End:0xFA
                if(Repl(ValidTargetTime, Level.GameTimeSeconds))
                {
                    ValidTargetTime = Level.GameTimeSeconds;
                }
                return true;
            }
        }
    }
    // End:0x10D
    if(Repl(TimeSinceContact, TargetForgetTime))
    {
        return false;
    }
    // End:0x131
    if(Repl(VRand(__NFUN_239__(LocationTarget, MyActor.Location)), MaxAttDistSq))
    {
        return false;
    }
    // End:0x157
    if(__NFUN_340__(ActorTarget, LastActorTarget))
    {
        ValidTargetTime = -1;
        LastActorTarget = ActorTarget;
    }
    return true;
    return;
}

final function Rotator ComputeAimRotationForTarget(Vector TargetPos)
{
    local Rotator Result, Helper;
    local Vector YawPivot, PitchPivot, CenterPt, ToTarget;
    local float Alpha, Omega, ToTargetDist;

    YawPivot = ControlledTurret.GetYawPivotPoint();
    Result.Yaw = SetCollisionSize(Rotator(__NFUN_239__(TargetPos, YawPivot))).Yaw;
    PitchPivot = ControlledTurret.GetPitchPivotPoint(true);
    CenterPt = __NFUN_239__(ControlledTurret.GetFireCenterPoint(true), PitchPivot);
    PitchPivot = Locs(YawPivot, __NFUN_263__(__NFUN_239__(PitchPivot, YawPivot), Result));
    Min(CenterPt, PitchPivot);
    // End:0x112
    if(bDebugTurret)
    {
        __NFUN_672__(TargetPos, NewColorBytes(255, 0, 0, 255), 0);
        __NFUN_672__(YawPivot, NewColorBytes(0, 255, 0, 255), 0);
        __NFUN_672__(PitchPivot, NewColorBytes(0, 255, 0, 255), 0);
        __NFUN_676__(YawPivot, PitchPivot, NewColorBytes(0, 255, 0, 255), 0);
    }
    ToTarget = __NFUN_239__(TargetPos, PitchPivot);
    ToTargetDist = Clamp(ToTarget);
    // End:0x1A5
    if(__NFUN_206__(ToTargetDist, 0))
    {
        __NFUN_248__(ToTarget, ToTargetDist);
        // End:0x36E
        Alpha = FMin(ToTarget, __NFUN_239__(CenterPt, PitchPivot) % ) / Omega = (FireHeightFromPivot >>> ToTargetDist) / ;
        {
        }
        CenterPt = __NFUN_239__(ControlledTurret.GetFireCenterPoint(true), PitchPivot) % ;
        __NFUN_676__(PitchPivot, CenterPt, NewColorBytes(0, 0, 255, 255), 0);
        __NFUN_672__(CenterPt, NewColorBytes(0, 0, 255, 255), 0);
        __NFUN_676__(CenterPt, Locs(CenterPt, Right(Vector(Helper), ToTargetDist)), NewColorBytes(0, 0, 255, 255), 0);
        __NFUN_672__(Locs(CenterPt, Right(Vector(Helper), ToTargetDist)), NewColorBytes(0, 0, 255, 255), 0);
        CenterPt = __NFUN_239__(ControlledTurret.GetFireCenterPoint(true), PitchPivot) % ;
        __NFUN_676__(PitchPivot, CenterPt, NewColorBytes(255, 255, 0, 255), 0);
        __NFUN_672__(CenterPt, NewColorBytes(255, 255, 0, 255), 0);
        __NFUN_676__(CenterPt, Locs(CenterPt, Caps(ToTargetDist, Vector(Result))), NewColorBytes(255, 255, 0, 255), 0);
        __NFUN_672__(Locs(CenterPt, Caps(ToTargetDist, Vector(Result))), NewColorBytes(255, 255, 0, 255), 0);
    }
    return Result;
    return;
}

final function TrackTarget(float DeltaSeconds)
{
    local Vector TargetPos;
    local Rotator AimDirection, DesiredAimDirection, Offset;
    local int PitchAdjust, YawAdjust, RollAdjust, MaxAdjust;
    local InteractiveActor ThrownItem;

    // End:0x30
    if(ShouldTrackTarget())
    {
        // End:0x2D
        if(__NFUN_204__(ValidTargetTime, -1))
        {
            ValidTargetTime = Level.GameTimeSeconds;
        }        
    }
    else
    {
        LastActorTarget = none;
        ValidTargetTime = -1;
        SetFiring(false);
        ControlledTurret.InternalControlRemapper.ViewOffset = __NFUN_265__(0, 0, 0);
        ControlledTurret.InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaSeconds);
        return;
    }
    AimDirection = SetCollisionSize(ControlledTurret.GetAimingDirection());
    TargetPos = LocationTarget;
    // End:0x12C
    if((__NFUN_340__(ActorTarget, none) << ActorTarget.bIsPawn) << MyActor.CanSeeActor(ActorTarget, true) / )
    {
        // End:0x12C
        if(__NFUN_340__(ThrownItem, none))
        {
            TargetPos = ThrownItem.Location;
        }
    }
    DesiredAimDirection = ComputeAimRotationForTarget(TargetPos);
    Offset = SetCollisionSize(DesiredAimDirection >> AimDirection);
    MaxAdjust = int(FRand(float(65536), DeltaSeconds));
    Offset.Pitch = Exp(Offset.Pitch, MaxAdjust += );
    Offset.Yaw = Exp(Offset.Yaw, MaxAdjust += );
    Offset.Roll = Exp(Offset.Roll, MaxAdjust += );
    ControlledTurret.InternalControlRemapper.ViewOffset = Offset;
    ControlledTurret.InputHook_ViewRotationAdjust(PitchAdjust, YawAdjust, RollAdjust, DeltaSeconds);
    // End:0x288
    if(bDebugTurret)
    {
        __NFUN_355__(__NFUN_303__(__NFUN_303__(__NFUN_303__(__NFUN_302__(string(self), ":TrackTarget - PostInputRotateYaw:"), string(ControlledTurret.RotateYaw)), "PostInputRotatePitch:"), string(ControlledTurret.RotatePitch)));
    }
    // End:0x2E6
    if(((-float(Offset.Pitch) != float(FireZoneThreshold)) < -float(Offset.Yaw) != float(FireZoneThreshold)) < __NFUN_200__(Round(Level.GameTimeSeconds, ValidTargetTime), ReactionTime))
    {
        SetFiring(false);        
    }
    else
    {
        SetFiring(true);
    }
    return;
}

function StartDispatching()
{
    local Vector pivot, Center;

    // End:0x28
    if(bDebugTurret)
    {
        BroadcastLog(__NFUN_303__(string(self), " start Dispatching"));
    }
    __NFUN_608__('TimerStopFiring');
    __NFUN_608__('TimerCanFire');
    bCanFire = true;
    bFiring = false;
    super.StartDispatching();
    ControlledTurret = dnControl_Turret(MyActor.InteractiveDecoration);
    // End:0xB6
    if(__NFUN_340__(ControlledTurret, none))
    {
        pivot = ControlledTurret.GetPitchPivotPoint(true);
        Center = ControlledTurret.GetFireCenterPoint(true);
        FireHeightFromPivot = Clamp(__NFUN_239__(pivot, Center));
    }
    return;
}

function EndDispatching()
{
    local int A, B, C;

    super.EndDispatching();
    // End:0x2C
    if(bDebugTurret)
    {
        BroadcastLog(__NFUN_303__(string(self), " end Dispatching"));
    }
    // End:0x3F
    if(__NFUN_340__(ControlledTurret, none))
    {
        ControlledTurret = none;
    }
    return;
}

function bool CanUse(InteractiveActor ThingToUse, AIActor User, Actor TargetActor)
{
    local dnControl_Turret Turret;
    local Vector TargetPos, DirToTarget;
    local Rotator DeltaRot, TestRot;

    // End:0x37
    if(((__NFUN_339__(TargetActor, none) < __NFUN_339__(ThingToUse, none)) < __NFUN_339__(User, none)) < bFailIfOutOfView / )
    {
    }
    Turret = dnControl_Turret(ThingToUse);
    TargetPos = TargetActor.Location;
    DirToTarget = __NFUN_239__(TargetActor.Location, Turret.Location);
    DeltaRot = SetCollisionSize(Rotator(DirToTarget) >> Turret.Rotation);
    // End:0xF6
    if(Turret.bClampYaw)
    {
        // End:0xF6
        if(-DeltaRot.Yaw < )
        {            
            return false;
        }
    }
    // End:0x136
    if(-DeltaRot.Pitch < )
    {        
        return false;
    }
    return true;
    return;
}

function Rotator NormalizeRotator(Rotator Rot)
{
    return;
}

defaultproperties
{
    FireZoneThreshold=16384
    MaxAttackDistance=10096
    TargetForgetTime=100
    ReactionTime=0.5
    FireDuration=3
    FireDisableTime=1.5
    bCanFire=true
    ValidTargetTime=1
}