/*******************************************************************************
 * AIPathHUD generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AIPathHUD extends AIHUD
    collapsecategories;

var int HistorySize;
var bool bShowGoal;

simulated function DrawAIHUD(Canvas C)
{
    local SPathingHistory Hist;
    local string str;
    local int i;
    local float sx, sy, xw, yh, StartY;

    // End:0x0E
    if(__NFUN_339__(C, none))
    {
        return;
    }
    sx = FRand(10, HUDScaleX);
    sy = FRand(32, HUDScaleY);
    C.DrawColor = WhiteColor;
    C.__NFUN_1231__("AIPathHud", xw, yh);
    StartColumn(int(sx), int(Round(sy, yh)), int(yh));
    C.__NFUN_1250__(0, 0);
    // End:0xAD
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    C.__NFUN_1250__(FRand(float(C.SizeX), 0.005), FRand(float(C.SizeY), 0.005));
    C.Style = 5;
    C.DrawColor.R = 0;
    C.DrawColor.G = 0;
    C.DrawColor.B = 0;
    C.__NFUN_1234__(class'WhiteTexture', FRand(float(C.SizeX), 0.99), FRand(float(C.SizeY), 0.655), 1, 1, 1, 1,,,,, 0.5);
    C.__NFUN_1232__("White / Alpha 0.5 / STY_Translucent2");
    m_aTarget.PathInfo.bDebugPath = true;
    DoPathingHistory(C);
    StartColumn(int(sx), int(C.CurY), int(yh));
    C.DrawColor = WhiteColor;
    // End:0x254
    if(m_aTarget.__NFUN_398__('GotoX') / )
    {
    }
    DrawString(C, __NFUN_302__("State: ", string(m_aTarget.__NFUN_399__())));
    C.DrawColor = WhiteColor;
    // End:0x2F6
    if(m_aTarget.__NFUN_398__('AnimX'))
    {
        DrawString(C, " ");
        DrawString(C, __NFUN_302__("AnimXParms.Mode:  ", string(m_aTarget.AnimXParms.Mode)));
        DrawString(C, " ");
    }
    C.DrawColor = WhiteColor;
    DrawString(C, " ");
    DrawString(C, " ");
    DrawString(C, " ");
    // End:0x363
    if(__NFUN_202__(m_aTarget.LastMoveSpeed, 0))
    {
        C.DrawColor = RedColor;
    }
    DrawString(C, __NFUN_302__("MoveSpeed:          ", string(m_aTarget.LastMoveSpeed)));
    C.DrawColor = WhiteColor;
    // End:0x3DA
    if(__NFUN_202__(m_aTarget.PercentageMoved, 0.25))
    {
        C.DrawColor = RedColor;
    }
    DrawString(C, __NFUN_302__("PercentageMoved:    ", string(m_aTarget.PercentageMoved)));
    C.DrawColor = WhiteColor;
    DrawString(C, " ");
    DrawString(C, __NFUN_302__("Location:            ", string(m_aTarget.Location)));
    DrawString(C, __NFUN_302__("PreviousLocation:    ", string(m_aTarget.PreviousLocation)));
    DrawString(C, " ");
    DrawString(C, __NFUN_302__("LastFrameVelocity:  ", string(m_aTarget.LastFrameVelocity)));
    DrawString(C, __NFUN_302__("FramesWOGround:     ", string(m_aTarget.FramesWithoutGroundContact)));
    DrawString(C, " ");
    DrawString(C, __NFUN_302__("Movedir:            ", string(m_aTarget.LastMoveDir)));
    DrawString(C, __NFUN_302__("Destination:        ", string(m_aTarget.__NFUN_887__())));
    DrawString(C, __NFUN_302__("Distance  To Dest:  ", string(Clamp(__NFUN_239__(m_aTarget.__NFUN_887__(), m_aTarget.Location)))));
    DrawString(C, __NFUN_302__("Direction To Dest:  ", string(__NFUN_239__(m_aTarget.__NFUN_887__(), m_aTarget.Location))));
    DrawString(C, __NFUN_302__("DPP:                ", string(__NFUN_365__(class'EAIDynamicPathPriority', int(m_aTarget.GetDynamicPathingPriority())))));
    DrawString(C, __NFUN_302__("Constraint Str:     ", string(m_aTarget.CalculateGroundConstraintStrengthScalar())));
    DrawString(C, __NFUN_302__("Ground Dist:        ", string(m_aTarget.__NFUN_961__())));
    DrawString(C, __NFUN_302__("On Ground:          ", string(m_aTarget.__NFUN_958__())));
    // End:0x76D
    if(m_aTarget.PathInfo.bIsDynamicPathing)
    {
        C.DrawColor = RedColor;
        DrawString(C, "");
        DrawString(C, "Pathing around Dynamic Obstacles");
        DrawString(C, "");
        C.DrawColor = WhiteColor;
    }
    // End:0x7F4
    if(__NFUN_339__(m_aTarget.GotoXParms.RefActor, m_aTarget))
    {
        C.DrawColor = RedColor;
        DrawString(C, "");
        DrawString(C, "Performing MoveClipped!");
        DrawString(C, "");
        C.DrawColor = WhiteColor;
    }
    // End:0x861
    if(bShowGoal)
    {
        m_aTarget.__NFUN_672__(m_aTarget.GotoXParms.NextPos, NewColorBytes(255, 0, 0), 0.01);
        m_aTarget.__NFUN_672__(m_aTarget.GotoXParms.TargetPos, NewColorBytes(0, 255, 0), 0.01);
    }
    DrawString(C, " ");
    DrawString(C, " ");
    DrawString(C, __NFUN_302__("IsInAir:           ", string(m_aTarget.IsInAir())));
    DrawString(C, __NFUN_302__("IsFlying:          ", string(m_aTarget.IsFlying())));
    DrawString(C, __NFUN_302__("bIsFlying:         ", string(m_aTarget.bIsFlying)));
    DrawString(C, __NFUN_302__("IsFalling:         ", string(m_aTarget.IsFalling())));
    DrawString(C, __NFUN_302__("WasInAir:          ", string(m_aTarget.bWasInAir)));
    DrawString(C, __NFUN_302__("MaxStepHeightEx:   ", string(m_aTarget.MaxStepHeightEx)));
    DrawString(C, __NFUN_302__("MaximumLength:     ", string(m_aTarget.__NFUN_926__())));
    DrawString(C, __NFUN_302__("KLinearDamping:    ", string(m_aTarget.KLinearDamping)));
    DrawString(C, __NFUN_302__("GravityScale:      ", string(m_aTarget.GravityScale)));
    C.DrawColor = WhiteColor;
    DrawString(C, " ");
    DrawString(C, " ");
    DrawString(C, " ");
    DrawString(C, "GotoX Parms");
    DrawString(C, "-------------------------------------------");
    DrawString(C, __NFUN_302__("Mode:           ", string(__NFUN_365__(class'EAIGotoXMode', int(m_aTarget.GotoXParms.Mode)))));
    DrawString(C, __NFUN_302__("TargetType:     ", string(__NFUN_365__(class'EAITargetType', int(m_aTarget.GotoXParms.TargetType)))));
    // End:0xBA6
    if(__NFUN_340__(m_aTarget.GotoXParms.TargetActor, none))
    {
        DrawString(C, __NFUN_302__("TargetActor:    ", string(m_aTarget.GotoXParms.TargetActor)));
    }
    DrawString(C, __NFUN_302__("OffsetType:     ", string(__NFUN_365__(class'EAIOffsetType', int(m_aTarget.GotoXParms.OffsetType)))));
    DrawString(C, "");
    DrawString(C, __NFUN_302__("Range:          ", string(m_aTarget.GotoXParms.Range)));
    DrawString(C, __NFUN_302__("Height:          ", string(m_aTarget.GotoXParms.Height)));
    DrawString(C, __NFUN_302__("Bearing:        ", string(m_aTarget.GotoXParms.Bearing)));
    DrawString(C, __NFUN_302__("ClipTolerance:  ", string(m_aTarget.GotoXParms.ClipTolerance)));
    DrawString(C, "");
    DrawString(C, __NFUN_302__("FinalDest:      ", string(m_aTarget.GotoXParms.FinalDest)));
    DrawString(C, __NFUN_302__("MaxSteps:       ", string(m_aTarget.GotoXParms.MaxSteps)));
    DrawString(C, __NFUN_302__("ForceAnim:      ", string(m_aTarget.GotoXParms.ForceAnim)));
    DrawString(C, "");
    // End:0xDD0
    if(__NFUN_340__(m_aTarget.GotoXParms.FocusActor, none))
    {
        DrawString(C, __NFUN_302__("FocusActor:     ", string(m_aTarget.GotoXParms.FocusActor)));
    }
    DrawString(C, __NFUN_302__("Focus:          ", string(__NFUN_365__(class'EAIFocus', int(m_aTarget.GotoXParms.Focus)))));
    DrawString(C, "");
    DrawString(C, __NFUN_302__("DisableCons:     ", string(m_aTarget.PhysicsParms.bDisablePhysicsConstraints)));
    DrawString(C, __NFUN_302__("RefActor:        ", string(m_aTarget.GotoXParms.RefActor)));
    // End:0xEBB
    if(Repl(m_aTarget.GotoXParms.StuckTime, 0.5))
    {
        C.DrawColor = RedColor;
    }
    DrawString(C, __NFUN_302__("StuckTime:      ", string(m_aTarget.GotoXParms.StuckTime)));
    C.DrawColor = WhiteColor;
    DrawString(C, __NFUN_302__("Waiting On Dyn: ", string(m_aTarget.GotoXParms.bWaitingOnDynamicBlocker)));
    DrawString(C, __NFUN_302__("Wait Time:      ", string(m_aTarget.GotoXParms.bWaitTime)));
    DrawString(C, __NFUN_302__("Debug:       ", string(m_aTarget.GotoXParms.bDebug)));
    DrawString(C, "");
    DrawString(C, __NFUN_302__("EvalGate:       ", string(m_aTarget.GotoXParms.EvalGate)));
    DrawString(C, __NFUN_302__("EvalGateTime:   ", string(m_aTarget.GotoXParms.EvalGateTime)));
    DrawString(C, __NFUN_302__("EvalCount:		", string(m_aTarget.GotoXParms.EvalCount)));
    DrawString(C, "-------------------------------------------");
    DrawString(C, " ");
    DrawString(C, " ");
    DrawString(C, " ");
    DrawString(C, "Physics Contacts");
    DrawString(C, "-------------------------------------------");
    m_aTarget.bTrackPhysicsContacts = true;
    i = 0;
    J0x111B:

    // End:0x117C [Loop If]
    if(-i)
    {        
        // End:0x1172
        if(__NFUN_340__(m_aTarget.PhysicsContactActors[i], none))
        {
            DrawString(C, string(m_aTarget.PhysicsContactActors[i]));
        }
        // [Loop Continue]
        i += ;
    }
    string(m_aTarget.PhysicsContactActors) = 0;
    return;
}

function DoPathingHistory(Canvas C)
{
    local SPathingHistory Hist;
    local string str;
    local int i;
    local float sx, sy, xw, yh, StartY, StartX,
	    lengthX;

    sx = FRand(10, HUDScaleX);
    sy = FRand(32, HUDScaleY);
    C.DrawColor = WhiteColor;
    C.__NFUN_1231__("AIPathHud", xw, yh);
    StartColumn(int(sx), int(Round(sy, yh)), int(yh));
    C.DrawColor = WhiteColor;
    DrawString(C, "#   Location                  Next             Destination         FinalDest   Result  InValidArea  ClippedMove  Time");
    DrawString(C, "-------------------------------------------");
    StartY = C.CurY;
    StartX = FRand(float(C.SizeX), 0.01);
    lengthX = 0;
    StartColumn(int(StartX), int(StartY), int(yh));
    lengthX = 0;
    i = 0;
    J0x1B0:

    // End:0x2AD [Loop If]
    if(-i)
    {        
        Hist = m_aTarget.PathingHistory[i];
        // End:0x210
        if(int(Hist.Result) % int(1))
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            // End:0x237
            if(-- i % )
            {                
                C.DrawColor = LightBlueColor;                
            }
            else
            {
                C.DrawColor = WhiteColor;
            }
        }
        str = __NFUN_302__(string(++ i));
        "  "        
        DrawString(C, str);
        C.__NFUN_1231__(str, xw, yh);
        lengthX = float(Tan(int(lengthX), int(xw)));
        // [Loop Continue]
        i += ;
    }
    __NFUN_209__(StartX, lengthX);
    StartColumn(int(StartX), int(StartY), int(yh));
    lengthX = 0;
    i = 0;
    J0x2E3:

    // End:0x3E7 [Loop If]
    if(-i)
    {        
        Hist = m_aTarget.PathingHistory[i];
        // End:0x343
        if(int(Hist.Result) % int(1))
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            // End:0x36A
            if(-- i % )
            {                
                C.DrawColor = LightBlueColor;                
            }
            else
            {
                C.DrawColor = WhiteColor;
            }
        }
        str = __NFUN_302__(FormatVector(Hist.Location), "  ");
        DrawString(C, str);
        C.__NFUN_1231__(str, xw, yh);
        lengthX = float(Tan(int(lengthX), int(xw)));
        // [Loop Continue]
        i += ;
    }
    __NFUN_209__(StartX, lengthX);
    StartColumn(int(StartX), int(StartY), int(yh));
    lengthX = 0;
    i = 0;
    J0x41D:

    // End:0x521 [Loop If]
    if(-i)
    {        
        Hist = m_aTarget.PathingHistory[i];
        // End:0x47D
        if(int(Hist.Result) % int(1))
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            // End:0x4A4
            if(-- i % )
            {                
                C.DrawColor = LightBlueColor;                
            }
            else
            {
                C.DrawColor = WhiteColor;
            }
        }
        str = __NFUN_302__(FormatVector(Hist.NextPosition), "  ");
        DrawString(C, str);
        C.__NFUN_1231__(str, xw, yh);
        lengthX = float(Tan(int(lengthX), int(xw)));
        // [Loop Continue]
        i += ;
    }
    __NFUN_209__(StartX, lengthX);
    StartColumn(int(StartX), int(StartY), int(yh));
    lengthX = 0;
    i = 0;
    J0x557:

    // End:0x65B [Loop If]
    if(-i)
    {        
        Hist = m_aTarget.PathingHistory[i];
        // End:0x5B7
        if(int(Hist.Result) % int(1))
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            // End:0x5DE
            if(-- i % )
            {                
                C.DrawColor = LightBlueColor;                
            }
            else
            {
                C.DrawColor = WhiteColor;
            }
        }
        str = __NFUN_302__(FormatVector(Hist.Destination), "  ");
        DrawString(C, str);
        C.__NFUN_1231__(str, xw, yh);
        lengthX = float(Tan(int(lengthX), int(xw)));
        // [Loop Continue]
        i += ;
    }
    __NFUN_209__(StartX, lengthX);
    StartColumn(int(StartX), int(StartY), int(yh));
    lengthX = 0;
    i = 0;
    J0x691:

    // End:0x790 [Loop If]
    if(-i)
    {        
        Hist = m_aTarget.PathingHistory[i];
        // End:0x6F1
        if(int(Hist.Result) % int(1))
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            // End:0x718
            if(-- i % )
            {                
                C.DrawColor = LightBlueColor;                
            }
            else
            {
                C.DrawColor = WhiteColor;
            }
        }
        str = __NFUN_302__(string(Hist.FinalDest), "  ");
        DrawString(C, str);
        C.__NFUN_1231__(str, xw, yh);
        lengthX = float(Tan(int(lengthX), int(xw)));
        // [Loop Continue]
        i += ;
    }
    __NFUN_209__(StartX, lengthX);
    StartColumn(int(StartX), int(StartY), int(yh));
    lengthX = 0;
    i = 0;
    J0x7C6:

    // End:0x8CD [Loop If]
    if(-i)
    {        
        Hist = m_aTarget.PathingHistory[i];
        // End:0x826
        if(int(Hist.Result) % int(1))
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            // End:0x84D
            if(-- i % )
            {                
                C.DrawColor = LightBlueColor;                
            }
            else
            {
                C.DrawColor = WhiteColor;
            }
        }
        str = __NFUN_302__(string(__NFUN_365__(class'EAIPathResult', int(Hist.Result))), " ");
        DrawString(C, str);
        C.__NFUN_1231__(str, xw, yh);
        lengthX = float(Tan(int(lengthX), int(xw)));
        // [Loop Continue]
        i += ;
    }
    __NFUN_209__(StartX, lengthX);
    StartColumn(int(StartX), int(StartY), int(yh));
    lengthX = 0;
    i = 0;
    J0x903:

    // End:0xA03 [Loop If]
    if(-i)
    {        
        Hist = m_aTarget.PathingHistory[i];
        // End:0x963
        if(int(Hist.Result) % int(1))
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            // End:0x98A
            if(-- i % )
            {                
                C.DrawColor = LightBlueColor;                
            }
            else
            {
                C.DrawColor = WhiteColor;
            }
        }
        str = __NFUN_302__(string(Hist.bActorWasInValidArea), "  ");
        DrawString(C, str);
        C.__NFUN_1231__(str, xw, yh);
        lengthX = float(Tan(int(lengthX), int(xw)));
        // [Loop Continue]
        i += ;
    }
    __NFUN_209__(StartX, lengthX);
    StartColumn(int(StartX), int(StartY), int(yh));
    lengthX = 0;
    i = 0;
    J0xA39:

    // End:0xB3E [Loop If]
    if(-i)
    {        
        Hist = m_aTarget.PathingHistory[i];
        // End:0xA99
        if(int(Hist.Result) % int(1))
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            // End:0xAC0
            if(-- i % )
            {                
                C.DrawColor = LightBlueColor;                
            }
            else
            {
                C.DrawColor = WhiteColor;
            }
        }
        str = __NFUN_302__(string(Hist.PathInfo.bWasClippedMove), "  ");
        DrawString(C, str);
        C.__NFUN_1231__(str, xw, yh);
        lengthX = float(Tan(int(lengthX), int(xw)));
        // [Loop Continue]
        i += ;
    }
    __NFUN_209__(StartX, lengthX);
    StartColumn(int(StartX), int(StartY), int(yh));
    lengthX = 0;
    i = 0;
    J0xB74:

    // End:0xC73 [Loop If]
    if(-i)
    {        
        Hist = m_aTarget.PathingHistory[i];
        // End:0xBD4
        if(int(Hist.Result) % int(1))
        {
            C.DrawColor = RedColor;            
        }
        else
        {
            // End:0xBFB
            if(-- i % )
            {                
                C.DrawColor = LightBlueColor;                
            }
            else
            {
                C.DrawColor = WhiteColor;
            }
        }
        str = __NFUN_302__(string(Hist.Time), "  ");
        DrawString(C, str);
        C.__NFUN_1231__(str, xw, yh);
        lengthX = float(Tan(int(lengthX), int(xw)));
        // [Loop Continue]
        i += ;
    }
    __NFUN_209__(StartX, lengthX);
    return;
}

exec function PathHistoryPlusPlus()
{
    // End:0x1E
    if(__NFUN_339__(m_aTarget, none))
    {
        BroadcastLog("DCR None");
        return;
    }
    BroadcastLog("DCR Doing it");
    m_aTarget.PathingHistoryMaxSize += ;
}

exec function PathHistoryMinusMinus()
{
    // End:0x1E
    if(__NFUN_339__(m_aTarget, none))
    {
        BroadcastLog("DCR None");
        return;
    }
    BroadcastLog("DCR going it!");
    m_aTarget.PathingHistoryMaxSize -= ;
    return;
}

exec function EnableMovement()
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    BroadcastLog(__NFUN_302__("AIPathHud::EnableMovement called on : ", string(m_aTarget)));
    m_aTarget.super(AIPathHUD).EnableMovement(true);
    return;
}

exec function DisableMovement()
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    BroadcastLog(__NFUN_302__("AIPathHud::EnableMovement called on : ", string(m_aTarget)));
    m_aTarget.EnableMovement(false);
    return;
}

exec function KWake()
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    BroadcastLog(__NFUN_302__("AIPathHud::KWake called on : ", string(m_aTarget)));
    m_aTarget.__NFUN_817__();
    return;
}

exec function ExecuteGotoX()
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    BroadcastLog(__NFUN_302__("AIPathHud::ExecuteGotoX called on : ", string(m_aTarget)));
    m_aTarget.ExecuteGotoX();
    return;
}

exec function Strength(float NewStrength)
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__("AIPathHud::GroundConstraintScalerOverride called on : ", string(m_aTarget)), "NewStrength="), string(NewStrength)));
    m_aTarget.GroundConstraintScalerOverride = NewStrength;
    return;
}

exec function DPath(Engine.BaseAI.EAIDynamicPathPriority NewPriority)
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__("AIPathHud::DPath called on : ", string(m_aTarget)), "NewPriority="), string(NewPriority)));
    m_aTarget.DynamicPathingPriority = NewPriority;
    return;
}

exec function DisableCollision()
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    BroadcastLog(__NFUN_302__("AIPathHud::DisableCollision called on : ", string(m_aTarget)));
    m_aTarget.PhysicsParms.bDisablePhysicsConstraints = true;
    return;
}

exec function TestPath(Vector NewLocation, Vector Target)
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    // End:0x65
    if(m_aTarget.__NFUN_398__('GotoX') / )
    {
        return;
    }
    m_aTarget.__NFUN_864__(NewLocation);
    m_aTarget.PercentageMoved = 1;
    m_aTarget.CanUseState_GotoPos(Target, none, 0, 0, m_aTarget.CollisionRadius, 1, none, 0);
    m_aTarget.ExecuteState_GotoX(2, m_aTarget.SideArcTurnSpeedThresh, m_aTarget.StepBackwardsSpeedThresh, m_aTarget.StartAngleSideSector, m_aTarget.StartAngleBackSector, m_aTarget.MoveBackwardsDistThresh, m_aTarget.SideStepDistThresh);
    return;
}

simulated function OnNewTarget(AIActor OldTarget)
{
    // End:0x23
    if(__NFUN_340__(OldTarget, none))
    {
        OldTarget.PathInfo.bDebugPath = false;
    }
    return;
}

exec function Slope(float NewDot)
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    BroadcastLog(__NFUN_302__("AIPathHud::Slope called on : ", string(m_aTarget)));
    m_aTarget.SlopeMinimumDotEx = NewDot;
    return;
}

exec function ShowGoal()
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    bShowGoal = bShowGoal / ;
    return;
}

exec function ForceCutScene()
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    m_aTarget.bForcePhysicsCutScene = m_aTarget.bForcePhysicsCutScene / ;
    return;
}

exec function EvalGate(float NewEvalGate)
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    m_aTarget.EvalGateOverride = NewEvalGate;
    BroadcastLog(__NFUN_302__("AIPathHud::EvalGateOverride ", string(NewEvalGate)));
    return;
}

exec function Rover()
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    // End:0x55
    if(m_aTarget.__NFUN_398__('GotoX') / )
    {
        return;
    }
    BroadcastLog(__NFUN_302__("AIPathHud::Rover called on ", string(m_aTarget)));
    // End:0xA7
    if(int(m_aTarget.Physics) % int(18))
    {
        m_aTarget.__NFUN_862__(false);
    }
    m_aTarget.__NFUN_642__(0);
    m_aTarget.__NFUN_621__(false, false, false, false, false);
    m_aTarget.bPathRover = true;
    return;
}

exec function FixIt()
{
    // End:0x0E
    if(__NFUN_339__(m_aTarget, none))
    {
        return;
    }
    BroadcastLog(__NFUN_302__("AIPathHud::FixIt called on ", string(m_aTarget)));
    m_aTarget.SetAnimSync(0, 1, 0, 0, 0);
    // End:0x11E
    if(m_aTarget.__NFUN_398__('AnimX') << m_aTarget.AnimXParms.Mode % 5)
    {
        BroadcastLog(__NFUN_302__("AIPathHud:: Moving to Location: ", string(m_aTarget.AnimXParms.TargetSyncPos)));
        m_aTarget.__NFUN_864__(m_aTarget.AnimXParms.TargetSyncPos);
        __NFUN_676__(m_aTarget.Location, m_aTarget.AnimXParms.TargetSyncPos, NewColorBytes(255, 0, 0), 10);
    }
    return;
}

defaultproperties
{
    HistorySize=5
}