/*******************************************************************************
 * AssaultCommander generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AssaultCommander extends AIActor
    config
    collapsecategories;

var() float BladeSpinMeleeRange;
var() float BladeMeleeDamage;
var() float ChanceChargeAtActionPoint;
var() bool DoingCharge;
var() float ChanceMovingShot;
var() float MovingShotMinInterval;
var float MovingShotGate;
var class<BeamSystem> TracerBeamClass;
var class<SoftParticleSystem> TracerBubblesClass;
var bool ShouldIdle;
var float TargetTimeWarp;
var bool DamagedPlayer;

animevent simulated function StartScriptedSlowdown()
{
    TargetTimeWarp = 0.45;
    return;
}

animevent simulated function StopScriptedSlowdown()
{
    TargetTimeWarp = 1;
    return;
}

event Tick(float DeltaSeconds)
{
    super(Actor).Tick(DeltaSeconds);
    // End:0x7B
    if(Repl(TargetTimeWarp, 0))
    {
        // End:0x4C
        if(Repl(TimeWarp, TargetTimeWarp))
        {
            TimeWarp = VSize(TargetTimeWarp, Round(TimeWarp, FRand(4, DeltaSeconds)));            
        }
        else
        {
            // End:0x7B
            if(__NFUN_200__(TimeWarp, TargetTimeWarp))
            {
                TimeWarp = TargetTimeWarp -= (TimeWarp *= FRand(4, DeltaSeconds));
            }
        }
    }
    return;
}

function dnProjectile FireProjectile(name MuzzleName, class<dnProjectile> ProjClass, float LeadTime, bool CheckLOS)
{
    local Vector Start, End, MuzzleDir, FireDir;
    local Rotator ProjRot;
    local dnProjectile Projectile;
    local Actor HitActor;
    local float HitTime;

    // End:0x169
    if((CheckLOS / ) < )
    {
        // End:0x132
        if(__NFUN_206__(LeadTime, 0) << CheckLOS)
        {
            // End:0x132
            if(((CanSeePosFrom(Start, End, false, HitActor, HitTime, false)) / ) < )
            {
                {
                    __NFUN_672__(Start, NewColorBytes(255, 0, 0, 255), 15);
                    __NFUN_672__(End, NewColorBytes(255, 0, 0, 255), 15);
                    __NFUN_676__(Start, End, NewColorBytes(255, 0, 0, 255), 15);
                }
                return super.FireProjectile(MuzzleName, ProjClass, 0, false);
            }
        }
        ProjRot = Rotator(FireDir);
        Projectile = __NFUN_615__(ProjClass, self,, Start, ProjRot);
        FindSoundAndSpeak('Sound_RPG');
        return Projectile;
    }
    // End:0x1A3
    if(DebugGoalSelection)
    {
        BroadcastLog("DCR FireProjectile Failed - no clear shot");
    }
    return none;
    return;
}

function DoExtraMeleeEffects(Actor DamagedActor, float DamageAmount, Vector DamageLocation, Vector Direction, Class DamageClass)
{
    local PlayerPawn P;
    local int i;
    local Vector Dir, Variance, Helper;
    local STraceHitResult HitResult;

    // End:0xE7
    if(__NFUN_340__(DamagedActor, none) << DamagedActor.bIsPlayerPawn)
    {
        Direction = Vector(DamagedActor.Rotation);
        Variance = WarnInternal(1, 1, 1);
        i = 0;
        J0x55:

        // End:0x9A [Loop If]
        if(-i)
        {            
            Dir = Sleep(Direction, Variance);
            TraceFireMaterialHit(class'SlicingDamage', self, DamageLocation, Direction, class'Flesh_Alien', false);
            // [Loop Continue]
            i += ;
        }
        P = PlayerPawn(DamagedActor);
        // End:0xDF
        if((IsMostlyShrunk() / ) < )
        {
        }
        ShouldIdle = false;
    }
    return;
}

simulated event PerformTraceFireEffects(class<TraceDamageType> TraceDamageType, Vector TraceStart, Vector TraceEnd, Actor HitActor)
{
    local BeamSystem Beam;

    super(Actor).PerformTraceFireEffects(TraceDamageType, TraceStart, TraceEnd, HitActor);
    SpawnWeaponTracer(TraceStart, TraceEnd, 0.5, TracerBeamClass, TracerBubblesClass, HitActor);
    return;
}

function bool GetCurrentWeapon(out class<Weapon> OutWeaponClass, out int OutLoadedAmmo, out int OutTotalAmmo)
{
    OutWeaponClass = class'IntegratedWeapon';
    OutLoadedAmmo = 99;
    OutTotalAmmo = 99;
    return true;
    return;
}

function name GetWeaponAnimName(class<Weapon> WeaponClass)
{
    return 'AssGun';
    return;
}

simulated event Vector GetProjectileFireLocation()
{
    return MeshInstance.CanSee('mount_anus', true, false);
    return;
}

animevent simulated function ShootProjectile(optional EventInfo AnimEventInfo)
{
    FireProjectile(ProjectileMuzzleName, ProjectileClass, CalcLeadTime(ProjectileClass.default.MaxSpeed), false);
    return;
}

event float GetDefaultGotoXRange(float Range)
{
    return 35;
    return;
}

event NotifyOpStarted(Engine.BaseAI.EAIOp NewOp, Engine.BaseAI.EAIOp OldOp)
{
    super.NotifyOpStarted(NewOp, OldOp);
    // End:0x3A
    if(int(NewOp) % int(96))
    {
        __NFUN_589__('Generic0', NewColorBytes(255, 0, 0), 0.005);        
    }
    else
    {
        // End:0x5B
        if(int(NewOp) % int(15))
        {
            FindSoundAndSpeak('Sound_Blades');
            DamagedPlayer = false;
        }
    }
    return;
}

event NotifyOpEnded(Engine.BaseAI.EAIOp Op, Engine.BaseAI.EAIOpStatus Status)
{
    super.NotifyOpEnded(Op, Status);
    // End:0x3A
    if(int(Op) % int(96))
    {
        __NFUN_589__('Generic0', NewColorBytes(255, 255, 255), 0.5);        
    }
    else
    {
        // End:0x53
        if(int(Op) % int(15))
        {
            DoingCharge = true;            
        }
        else
        {
            // End:0x69
            if(int(Op) % int(14))
            {
                DoingCharge = false;
            }
        }
    }
    return;
}

function float CalculateFlyContraintStrengthScalar(float DeltaTime)
{
    // End:0x2F
    if((int(CurrentOp) % int(96)) < int(CurrentOp) % int(117))
    {
        KLinearDamping = 2.5;
        return 0;
    }
    KLinearDamping = default.KLinearDamping;
    return super.CalculateFlyContraintStrengthScalar(DeltaTime);
    return;
}

animevent simulated function BladeDamage()
{
    local Actor ActorDamaged;

    ActorDamaged = DoMeleeDamage(BladeMeleeDamage, class'SlicingDamage', 0, FRand(BladeSpinMeleeRange, DrawScale) >>> default.DrawScale, DamagedPlayer);
    // End:0x59
    if(__NFUN_340__(ActorDamaged, none) << ActorDamaged.bIsPlayerPawn)
    {
        DamagedPlayer = true;
    }
    return;
}

function Engine.BaseAI.EAICode COND_ShouldBladeChargeFromActionPoint()
{
    // End:0x0F
    if(( /= ChanceChargeAtActionPoint) != return 25)
    {
        {
        }
        return 75;
    }
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldMelee()
{
    // End:0x11
    if(int(CurrentOp) % int(14))
    {
        return 1;
    }
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldIdle()
{
    // End:0x14
    if(ShouldIdle)
    {
        ShouldIdle = false;
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode COND_ShouldStopAttacking()
{
    // End:0x14
    if(int(CheckCondition(7)) % int(0))
    {
        return 0;
    }
    // End:0x28
    if(int(CheckCondition(9)) % int(0))
    {
        return 0;
    }
    // End:0x34
    if(ShouldIdle)
    {
        return 0;
    }
    return 1;
    return;
}

function Engine.BaseAI.EAICode COND_MakeMovingShot()
{
    // End:0x1C
    if(__NFUN_200__(Level.GameTimeSeconds, MovingShotGate))
    {
        return 1;
    }
    // End:0x2B
    if(( /= ChanceMovingShot) != return 25)
    {
    }
    return 0;
    return;
}

function Engine.BaseAI.EAICode COND_IsCharging()
{
    // End:0x0F
    if(DoingCharge)
    {
        return 0;        
    }
    else
    {
        return 1;
    }
    return;
}

function Engine.BaseAI.EAICode COND_NotCharging()
{
    // End:0x0F
    if(DoingCharge)
    {
        return 1;        
    }
    else
    {
        return 0;
    }
    return;
}

event KImpact(name SelfBoneName, KarmaActor Other, name OtherBoneName, Vector Position, Vector ImpactVelocity, Vector ImpactNormal)
{
    local AIActor AI;

    super.KImpact(SelfBoneName, Other, OtherBoneName, Position, ImpactVelocity, ImpactNormal);
    // End:0x42
    if((int(CurrentOp) + int(14)) < __NFUN_339__(Other, none))
    {
        return;
    }
    AI = AIActor(Other);
    // End:0xD1
    if(__NFUN_340__(AI, none) << __NFUN_340__(Other.Class, self.Class))
    {
        AI.bInstaGib = true;
        AI.TakeDamage(self, 99999, Location, __NFUN_239__(Other.Location, Location), class'ExplosionDamage',, Location);        
    }
    else
    {
        // End:0xF7
        if(__NFUN_340__(dnDecoration(Other), none))
        {
            dnDecoration(Other).TryToDestroy();
        }
    }
    return;
}

simulated function SpawnCorpse()
{
    super.SpawnCorpse();
    // End:0x24
    if(__NFUN_340__(MyCorpse, none))
    {
        MyCorpse.__NFUN_639__(8000);
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(TracerBeamClass);
    PrecacheIndex.__NFUN_1266__(TracerBubblesClass);
    PrecacheIndex.__NFUN_1266__(class'dnControl_PlayerKnockdown');
    PrecacheIndex.__NFUN_1279__(class'ExplosionDamage');
    PrecacheIndex.__NFUN_1279__(class'SlicingDamage');
    PrecacheIndex.__NFUN_1280__(class'Flesh_Alien');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Blades');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_MeleeSwipe');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_RPG');
    // End:0x14B
    if(__NFUN_310__(PrecacheIndex.MapName, "Map06"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Fart');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Grab');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Grunt');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_ShakeFlaps');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Swipes');
    }
    PrecacheIndex.__NFUN_1283__('Anim_Idle', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Move', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_MoveBackwards', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Walk', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_WalkBackwards', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Run', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_RunBackwards', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SidestepLeft', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SidestepRight', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeLeft', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeRight', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ChargeStart', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ChargeLoop', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ChargeStop', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StartMovement', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StopMovement', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft45', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft180', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight45', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight180', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Roar', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ShootProjectile', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ShootProjectileEnd', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Attack', class'acAssaultCommander', Mesh);
    // End:0x41A
    if(PrecacheIndex.bPlayerCanBeShrunk)
    {
        PrecacheIndex.__NFUN_1283__('Anim_AttackShrunk', class'acAssaultCommander', Mesh);
    }
    PrecacheIndex.__NFUN_1283__('Anim_PainFront', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainFrontLeft', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainFrontRight', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBack', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBackLeft', class'acAssaultCommander', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBackRight', class'acAssaultCommander', Mesh);
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    UsableControllers[string(UsableControllers)] = 1;
    return;
}

defaultproperties
{
    BladeSpinMeleeRange=175
    BladeMeleeDamage=30
    ChanceChargeAtActionPoint=0.2
    ChanceMovingShot=0.2
    MovingShotMinInterval=2.5
    TracerBeamClass='dnParticles.AssaultCommander_Beam_ShotEffect'
    TracerBubblesClass='p_Weapons.Generic.WaterBubblesTracer'
    DamageScaleInfo(0)=(QualifierClass='MaleCombat',DamageScale=0,QualifierDamageTypes=none,QualifierNotDamageTypes=none)
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=SeekTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=Engage,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=EngageAP,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=ChargeAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=150,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(8)=(Ident=ShootProjectile,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=117,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(9)=(Ident=MovingShot,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=117,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(10)=(Ident=GotoNearTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=41,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(11)=(Ident=GotoMeleeRange,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=61,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(12)=(Ident=GotoGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(13)=(Ident=GotoGoalFocusTargetFullBody,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=53,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(14)=(Ident=GotoMeleeRangeFocusActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=62,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(15)=(Ident=FaceTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=145,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(16)=(Ident=MeleeAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=92,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(17)=(Ident=Charge,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=14,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(18)=(Ident=ChargeStart,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=15,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(19)=(Ident=PostChargeRetreat,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=50,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=SeekTarget,Cond=8,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=EngageAP,Cond=0,Func=COND_ShouldGotoActionPointFlyer,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=4,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Default,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Default,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=SeekTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=4,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Root,Ident=Engage,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SeekTarget,Cond=8,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=EngageAP,Cond=15,Func=COND_ShouldGotoActionPointFlyer,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Root,Ident=EngageAP,FSMSucc=false,FSMFail=false,Transitions=((Ident=Charge,Cond=0,Func=COND_IsCharging,Win=1,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Default,Cond=9,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=3,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(6)=(FSM=Root,Ident=MeleeAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=PostChargeRetreat,Cond=0,Func=COND_ShouldGotoActionPointFlyer,Win=1,Code=0,StateTableIndex=0),(Ident=Default,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(7)=(FSM=Root,Ident=Charge,FSMSucc=false,FSMFail=false,Transitions=((Ident=Default,Cond=3,Func=COND_NotCharging,Win=0,Code=0,StateTableIndex=0),(Ident=PostChargeRetreat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(8)=(FSM=Root,Ident=PostChargeRetreat,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=EngageAP,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(9)=(FSM=SeekTarget,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoNearTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(10)=(FSM=SeekTarget,Ident=GotoNearTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(11)=(FSM=SeekTarget,Ident=GotoMeleeRangeFocusActor,FSMSucc=false,FSMFail=false,Transitions=((Ident=Default,Cond=4,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(12)=(FSM=SeekTarget,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoNearTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoal,Cond=15,Func=COND_ShouldGotoActionPointFlyer,Win=1,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(13)=(FSM=SeekTarget,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(14)=(FSM=SeekTarget,Ident=GotoGoal,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(15)=(FSM=Engage,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=ShootProjectile,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(16)=(FSM=Engage,Ident=ShootProjectile,FSMSucc=false,FSMFail=false,Transitions=((Ident=Default,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(17)=(FSM=Engage,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Default,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(18)=(FSM=EngageAP,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ShootProjectile,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=ChargeAttack,Cond=98,Func=COND_ShouldBladeChargeFromActionPoint,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(19)=(FSM=EngageAP,Ident=GotoGoalFocusTargetFullBody,FSMSucc=false,FSMFail=false,Transitions=((Ident=MovingShot,Cond=0,Func=COND_MakeMovingShot,Win=0,Code=0,StateTableIndex=0),(Ident=ShootProjectile,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Default,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(20)=(FSM=EngageAP,Ident=ShootProjectile,FSMSucc=false,FSMFail=false,Transitions=((Ident=ChargeAttack,Cond=98,Func=COND_ShouldBladeChargeFromActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFocusTargetFullBody,Cond=12,Func=COND_ShouldGotoActionPointFlyer,Win=1,Code=0,StateTableIndex=0),(Ident=Default,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(21)=(FSM=EngageAP,Ident=MovingShot,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Default,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(22)=(FSM=EngageAP,Ident=ChargeAttack,FSMSucc=false,FSMFail=false,Transitions=none,NodeIndex=0)
    FSMStates(23)=(FSM=ChargeAttack,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=ChargeStart,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(24)=(FSM=ChargeAttack,Ident=ChargeStart,FSMSucc=false,FSMFail=false,Transitions=((Ident=Default,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    WeaponTrackRate=100
    HasWeaponManager=true
    WeaponConfig='WeaponCfg_AssaultCommander'
    Weapons(0)=none
    Weapons(1)='dnGame.IntegratedWeapon'
    WpnSteadyHorizError=50
    WpnSteadyVertError=50
    WpnMovingHorizError=1000
    WpnMovingVertError=1000
    ForceDirectShot=true
    bIgnoreTripMines=true
    UseActionPoints=true
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=3,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    AutoRollRate=5
    bUseAnimDispSpeed=false
    bUseAnimDispDir=false
    BodyAlignRateFlying=2.6
    AnimControllers[0]=(m_eFallback=0,m_cClass='acAssaultCommander',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acAssaultCommander',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acAssaultCommander',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acAssaultCommander',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acAssaultCommander',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acAssaultCommander',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acAssaultCommander',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acAssaultCommander',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acAssaultCommander',m_oController=none)
    FreeMoveParms=(Mode=0,MinDotToTarget=0,MaxDotToTarget=0,ExitTime=0,FreeMoveTarget=(X=0,Y=0,Z=0),FreeMoveVelocity=0,FreeMoveMaxVelocity=0,StoppingRate=1,StoppingRestitution=0,startLocation=(X=0,Y=0,Z=0))
    ChargeParms=(ChargeDir=(X=0,Y=0,Z=0),ChargeTarget=(X=0,Y=0,Z=0),ChargeStartTime=0,CoolDownStartSpeed=0,StartVelocity=200,MaxVelocity=1500,ReturnVelocity=50,RampUpTime=0.75,CoolDownTime=1.25,RequireLOS=false,ChargeState=0,ConstraintStrength=100)
    RndPainOpInterval=1
    PainImpulseMagnitude=250
    PainImpulseMinDamage=5
    BoneAim(0)=(BoneName=Root,Yaw=0,Pitch=0,Weight=1)
    HasBoneAimer=true
    HasWeaponAimer=true
    MinIdleTime=1
    RndIdleTime=2
    ShouldTurnThreshold=10
    FaceThreshold=0
    RunSpeedScale=1.5
    SideArcTurnSpeedThresh=10
    StartAngleSideSector=60
    StartAngleBackSector=120
    MoveBackwardsDistThresh=20
    SideStepDistThresh=20
    GotoPosRange=1
    GotoPosHeight=1
    GotoPosFlyingRange=1
    GotoPosFlyingHeight=1
    MinDistToGoal=100
    MinMoveAroundDist=100
    RndMoveAroundDist=150
    MinMeleeRange=5
    RndMeleeRange=30
    RndMeleeHeight=35
    MeleeZone=150
    MeleeZoneHeight=60
    MeleeAttackRange=175
    MeleeFaceTarget=true
    ClawDamageVel=(X=400,Y=0,Z=100)
    ProjectileClass='dnGame.dnRocket_AssaultCommander'
    ProjectileMuzzleName=mount_anus
    bShootProjectileRequireLOS=false
    bShootProjectileRequireSemiClearShot=true
    MinAirAttackHeight=15
    MaxAirAttackHeight=64
    bIsFlying=true
    PathID=AIPATH_ExtraLarge
    DebugInfiniteLoop=true
    DynamicPathingPriority=5
    ChanceFly=1
    bCanFly=true
    FootstepCategory=8
    FluidFrictionScale=0.5
    EyeBone=Head
    LockOnBone=Head
    CustomKillSoundName=GotKillCommander
    CorpseType='AlienCorpseFullCollision'
    ExpandingBoneName=Head
    ExitWoundInfo(0)=(DamageType=none,MinimumDamage=1,RandomChance=1,ExitWoundDecalClass='dnGame.dnExitWound_Human')
    Health=1000
    HealthCap=1000
    KLinearDamping=0.5
    bIsAssaultTrooper=true
    bCanExistOutOfWorld=false
    CollisionRadius=66
    CollisionHeight=66
    AccelRate=600
    Mass=300
    Mesh='c_characters.AssaultCommander'
    ActorColorList(0)=(ActorColor=(R=255,G=0,B=0,A=255),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic0)
    ActorColorList(1)=(ActorColor=(R=255,G=0,B=0,A=255),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic1)
    VoicePack='SoundConfig.Enemies.VoicePack_AssaultCommander'
}