/*******************************************************************************
 * AssaultTrooper_Captain generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class AssaultTrooper_Captain extends AIActor
    config
    collapsecategories
    dependson(dnAssaultTrooperJetpackEffect)
    dependson(FakeAIWeapon);

const UninitialisedContactTime = -99.0f;
const ChanceIdleSound = 0.25f;
const MaxVelWobble = 30.0f;
const MinWobbleInterval = 0.1f;
const RndWobbleInterval = 0.2f;
const HeightThresh = 150;
const MinContactTime = 0.6f;
const ChanceRoar = 0.1f;
const ChanceRollInsteadOfPain = 0.4f;
const MinRoarHealthPercentage = 0.8f;
const BackFireMinInterval = 0.4f;
const BackFireRndInterval = 0.1f;

var private bool DoWobble;
var private float StartContactTime;
var private Engine.BaseAI.EAIArcSector DodgeSector;
var private dnAssaultTrooperJetpackEffect JetPackEffect[2];
var private SMountPrefab JetPackEffectMount[2];
var private class<SoftParticleSystem> JetPackBackFireFXClass;
var private class<SoftParticleSystem> JetPackSmokeTrailFXClass;
var private int LastGotoOpRef;
var private int MinRoarHealth;
var private float ChanceCloak;
var private class<dnMuzzleFX_Spawners> MuzzleFlashClass;
var private dnMuzzleFX_Spawners MuzzleFlash;
var private class<Weapon_LightEx> MuzzleLightClass;
var private Weapon_LightEx MuzzleLight;
var private class<BeamSystem> TracerClass;
var private class<SoftParticleSystem> WaterTracerClass;
var name FiringSound;
var private int MinBulletDamage;
var private int RndBulletDamage;
var int ReloadCountDown;
var int FireCount;
var SoftParticleSystem JetPackExplode;
var SoftParticleSystem HaywireSmokeParticleSystem;
var() noexport float FlyGate "Min time after taking off that we spend in the air. Must editdefactor to change this property at runtime.";
var() noexport float JumpGate "Min time after taking off that we spend in the air. Must editdefactor to change this property at runtime.";
var() noexport float LandGate "Min time after taking off that we spend in the air. Must editdefactor to change this property at runtime.";
var() noexport float TeleportGate "Min time after teleporting before teleporting again. Must editdefactor to change this property at runtime.";
var() noexport float ChanceTeleport_ActionPoint "Chance to teleport while in the wild when we are at an action point";
var() noexport float ChanceTeleport_Reaction "Chance to teleport while in the wild when we are being shot at";
var() float ChanceRoamSound;
var() noexport float ChanceIdleInAir "After reaching AP, chance to idle for MinIdleTime + RndIdleTime (while in air only)";
var Projectile IncomingProjectile;
var float DamageSinceTeleport;
var() bool AllowQuickTeleports;
var private bool bHeadKnockedOff;
var class<FakeAIWeapon> WeaponClass;
var FakeAIWeapon MyWeapon;

function PreInit()
{
    // End:0x11
    if(__NFUN_202__(ChanceFly, 0))
    {
        return;
    }
    // End:0x45
    if((int(ForceStartJetpack) % int(1)) < (int(ForceStartJetpack) + int(2)) << InAir(150))
    {
        StartupJetpack();
    }
    return;
}

simulated function ModifyAllowQuickTeleports(Engine.Object.EBitModifier bAllowQuickTeleportsModifier)
{
    AllowQuickTeleports = __NFUN_346__(bAllowQuickTeleportsModifier, AllowQuickTeleports);
    return;
}

animevent function StartupJetpack()
{
    SetAnimController(8);
    NotifyTakeOff();
    return;
}

animevent function StopJetpack()
{
    SetAnimController(5);
    NotifyLand();
    return;
}

event ExpandingDeath(Pawn DeathInstigator)
{
    // End:0x16
    if((IsFlying()) / )
    {
    }
    return;
}

function GetPickupSpawnLocationRotation(Weapon DropWeapon, out Vector SpawnLocation, out Rotator SpawnRotation)
{
    SpawnLocation = MyWeapon.Location;
    SpawnRotation = MyWeapon.Rotation;
    return;
}

simulated function TripMineAttached(Actor TripMineActor, float AutoDetonateTime)
{
    local LaserMine TripMine;

    // End:0x31
    if(int(CurrentOp) % int(138))
    {
        TripMine = LaserMine(TripMineActor);
        TripMine.Disarm();        
    }
    else
    {
        // End:0x94
        if(IsFlying())
        {
            bForceHaywire = true;
            CanUseOp(80);
            HaywireParms.HitNormal = Vector(TripMineActor.Rotation);
            CurrentOpMustFinish = false;
            SuspendExecutive(true);
            SuspendWeaponTargetEvaluation(true);
            SuspendLookTargetEvaluation(true);
            ExecuteOp(80);
            bForceHaywire = false;
            return;
        }
    }
    super.TripMineAttached(TripMineActor, AutoDetonateTime);
    return;
}

function UpdateShrinkScale(float ShrinkSizeScale)
{
    super.UpdateShrinkScale(ShrinkSizeScale);
    // End:0x40
    if(__NFUN_340__(JetPackEffect[0], none))
    {
        JetPackEffect[0].__NFUN_591__(FRand(ShrinkSizeScale, JetPackEffect[0].default.DrawScale));
    }
    // End:0x75
    if(__NFUN_340__(JetPackEffect[1], none))
    {
        JetPackEffect[1].__NFUN_591__(FRand(ShrinkSizeScale, JetPackEffect[1].default.DrawScale));
    }
    return;
}

event PostBeginPlay()
{
    super.PostBeginPlay();
    SetupWeapon();
    SetupWeaponFX();
    __NFUN_605__(2, false, 'RndStuff');
    MinRoarHealth = int(FRand(Health, 0.8));
    HaywireSmokeParticleSystem = SoftParticleSystem(FindMountedActor('HaywireSmokeFX', class'SoftParticleSystem'));
    // End:0x6C
    if(__NFUN_340__(HaywireSmokeParticleSystem, none))
    {
        HaywireSmokeParticleSystem.Enabled = false;
    }
    TeleportParms.StartLight = __NFUN_615__(class'AssaultTrooper_Captain_TeleportLight', self,, Location);
    TeleportParms.EndLight = __NFUN_615__(class'AssaultTrooper_Captain_TeleportLight', self,, Location);
    return;
}

function SetRefPose()
{
    return;
}

event Destroyed()
{
    JetStop();
    // End:0x2C
    if(__NFUN_340__(JetPackEffect[0], none))
    {
        JetPackEffect[0].__NFUN_614__();
        JetPackEffect[0] = none;
    }
    // End:0x52
    if(__NFUN_340__(JetPackEffect[1], none))
    {
        JetPackEffect[1].__NFUN_614__();
        JetPackEffect[1] = none;
    }
    // End:0x6B
    if(__NFUN_340__(MuzzleFlash, none))
    {
        MuzzleFlash.__NFUN_614__();
    }
    // End:0x84
    if(__NFUN_340__(MuzzleLight, none))
    {
        MuzzleLight.__NFUN_614__();
    }
    // End:0x9D
    if(__NFUN_340__(MyWeapon, none))
    {
        MyWeapon.__NFUN_614__();
    }
    super.Destroyed();
    return;
}

function RndStuff()
{
    // End:0xA0
    if(DoJetPackWobble << int(AnimCtrl.m_eController) % int(8))
    {
        // End:0xA0
        if(__NFUN_398__('GotoX') / )
        {
        }
    }
    return;
}

event Engine.Object.EDialog GetEnemySpottedDialog()
{
    // End:0x0C
    if(IsFlying())
    {
        return 11;
    }
    return super(Pawn).GetEnemySpottedDialog();
    return;
}

function Anim_MoveTo_StrafeLeft(Engine.BaseAI.EAIMoveSpeed MoveSpeed)
{
    // End:0x1C
    if(int(MoveSpeed) % int(1))
    {
        PlayAnim('Anim_SidestepLeftSlow');        
    }
    else
    {
        PlayAnim('Anim_SidestepLeft');
    }
    // End:0x3B
    if(IsFlying())
    {
        FindSoundAndSpeak('Sound_JetPackBoost');
    }
    return;
}

function Anim_MoveTo_StrafeRight(Engine.BaseAI.EAIMoveSpeed MoveSpeed)
{
    // End:0x1C
    if(int(MoveSpeed) % int(1))
    {
        PlayAnim('Anim_SidestepRightSlow');        
    }
    else
    {
        PlayAnim('Anim_SidestepRight');
    }
    // End:0x3B
    if(IsFlying())
    {
        FindSoundAndSpeak('Sound_JetPackBoost');
    }
    return;
}

function Anim_MoveTo(Engine.BaseAI.EAIMoveSpeed MoveSpeed)
{
    super.Anim_MoveTo(MoveSpeed);
    // End:0x1F
    if(IsFlying())
    {
        FindSoundAndSpeak('Sound_JetPackBoost');
    }
    return;
}

function Anim_MoveTo_BackUp(Engine.BaseAI.EAIMoveSpeed MoveSpeed)
{
    super.Anim_MoveTo_BackUp(MoveSpeed);
    // End:0x1F
    if(IsFlying())
    {
        FindSoundAndSpeak('Sound_JetPackBoost');
    }
    return;
}

animevent simulated function WeaponFire(optional EventInfo AnimEventInfo)
{
    ShouldFire = true;
    return;
}

function bool GetCurrentWeapon(out class<Weapon> OutWeaponClass, out int OutLoadedAmmo, out int OutTotalAmmo)
{
    OutWeaponClass = class'IntegratedWeapon';
    OutLoadedAmmo = 99;
    OutTotalAmmo = 99;
    return true;
    return;
}

function name GetWeaponAnimName(class<Weapon> WeaponClass)
{
    return 'AssaultTrooperGun';
    return;
}

function Weapon GetWeapon()
{
    return none;
    return;
}

event name AIActor_Weapon_GetName()
{
    return 'AssaultTrooperGun';
    return;
}

function bool AIActor_Weapon_Fire()
{
    PlayAnim('Anim_Shoot');
    // End:0x23
    if(__NFUN_340__(PopUp, none))
    {
        PopUpState.ShotsFired += ;
    }
    return;
}

event bool AIActor_Weapon_Reload()
{
    return true;
    return;
}

function bool AIActor_Weapon_GiveAmmo()
{
    return true;
    return;
}

function AIActor_Weapon_Holster(RenderActor MyWeapon)
{
    return;
}

simulated event Vector GetProjectileFireLocation()
{
    local Vector SpawnPos;
    local Rotator SpawnRot;

    // End:0x2C
    if(__NFUN_340__(MyWeapon, none))
    {
        MyWeapon.GetMuzzlePos(SpawnPos, SpawnRot);
        return SpawnPos;
    }
    return super.GetProjectileFireLocation();
    return;
}

event FireWeapon()
{
    local GearboxEngineGlobals Globals;

    Globals = __NFUN_404__();
    // End:0x80
    if(__NFUN_340__(Globals, none) << Globals.AssaultCaptainCanFireRealShotNow(self))
    {
        // End:0x7D
        if(__NFUN_340__(FireProjectile('None', ProjectileClass, CalcLeadTime(ProjectileClass.default.MaxSpeed), false), none))
        {
            StartWeaponFX();
            NotifyFired();
            FindSoundAndSpeak(FiringSound);
            // [Explicit Continue]
            ReloadCountDown -= ;
        }
    }
    StartWeaponFX();
    NotifyFired();
    ReloadCountDown -= ;
}

simulated event float GetBaseDamage(Actor Victim, optional Pawn Instigator, optional class<DamageType> DamageType, optional Vector HitDirection, optional Vector HitLocation, optional name BoneName, optional Vector SourceTraceOrigin)
{
    return float(++ MinBulletDamage);    
    return;
}

simulated event PerformTraceFireEffects(class<TraceDamageType> TraceDamageType, Vector TraceStart, Vector TraceEnd, Actor HitActor)
{
    local BeamSystem Beam;

    super(Actor).PerformTraceFireEffects(TraceDamageType, TraceStart, TraceEnd, HitActor);
    SpawnWeaponTracer(TraceStart, TraceEnd, 0.5, TracerClass, WaterTracerClass, HitActor);
    return;
}

function NotifyEndWeaponFireAnim()
{
    StopWeaponFX();
    super.NotifyEndWeaponFireAnim();
    return;
}

function SetupWeapon()
{
    MyWeapon = __NFUN_615__(WeaponClass, self);
    // End:0x50
    if(__NFUN_340__(MyWeapon, none))
    {
        MyWeapon.MountType = 2;
        MyWeapon.MountMeshItem = 'mount_carryitem';
        MyWeapon.__NFUN_635__(self);
    }
    return;
}

function SetupWeaponFX()
{
    MuzzleLight = __NFUN_615__(MuzzleLightClass, MyWeapon);
    // End:0x97
    if(__NFUN_340__(MuzzleLight, none))
    {
        MuzzleLight.LightStyle = 0;
        MuzzleLight.MountType = 2;
        MuzzleLight.MountMeshItem = MyWeapon.MuzzleBones[0];
        MuzzleLight.MountOrigin = WarnInternal(1, 0, 0);
        MuzzleLight.__NFUN_635__(MyWeapon);
    }
    MuzzleFlash = __NFUN_615__(MuzzleFlashClass, MyWeapon);
    // End:0x11C
    if(__NFUN_340__(MuzzleFlash, none))
    {
        MuzzleFlash.MountType = 2;
        MuzzleFlash.MountMeshItem = MyWeapon.MuzzleBones[0];
        MuzzleFlash.MountOrigin = WarnInternal(1, 0, 0);
        MuzzleFlash.__NFUN_635__(MyWeapon);
    }
    return;
}

function StartWeaponFX()
{
    // End:0x2E
    if(__NFUN_340__(MuzzleLight, none))
    {
        MuzzleLight.__NFUN_591__(DrawScale);
        MuzzleLight.Flash();
    }
    // End:0x60
    if(__NFUN_340__(MuzzleFlash, none))
    {
        MuzzleFlash.SystemSizeScale = DrawScale;
        MuzzleFlash.ExecuteEffect(true);
    }
    return;
}

function StopWeaponFX()
{
    // End:0x1C
    if(__NFUN_340__(MuzzleFlash, none))
    {
        MuzzleFlash.StopEffect();
    }
    return;
}

animevent simulated function JetStart(optional EventInfo AnimEventInfo)
{
    // End:0x0E
    if(__NFUN_202__(Health, float(0)))
    {
        return;
    }
    // End:0x75
    if(__NFUN_339__(JetPackEffect[0], none))
    {
        JetPackEffect[0] = __NFUN_615__(class'dnAssaultTrooperJetpackEffect');
        // End:0x75
        if(__NFUN_340__(JetPackEffect[0], none))
        {
            JetPackEffect[0].__NFUN_590__(false);
            JetPackEffect[0].TickStyle = 2;
            JetPackEffect[0].__NFUN_633__(JetPackEffectMount[0], self);
        }
    }
    // End:0xDC
    if(__NFUN_339__(JetPackEffect[1], none))
    {
        JetPackEffect[1] = __NFUN_615__(class'dnAssaultTrooperJetpackEffect');
        // End:0xDC
        if(__NFUN_340__(JetPackEffect[1], none))
        {
            JetPackEffect[1].__NFUN_590__(false);
            JetPackEffect[1].TickStyle = 2;
            JetPackEffect[1].__NFUN_633__(JetPackEffectMount[1], self);
        }
    }
    FindSoundAndSpeak('Sound_JetpackOn');
    HaywireChance = 1;
    return;
}

animevent simulated function JetStop(optional EventInfo AnimEventInfo)
{
    // End:0x41
    if(__NFUN_340__(JetPackEffect[0], none))
    {
        JetPackEffect[0].__NFUN_590__(true);
        JetPackEffect[0].TickStyle = 0;
        JetPackEffect[0].__NFUN_631__();
    }
    // End:0x82
    if(__NFUN_340__(JetPackEffect[1], none))
    {
        JetPackEffect[1].__NFUN_590__(true);
        JetPackEffect[1].TickStyle = 0;
        JetPackEffect[1].__NFUN_631__();
    }
    __NFUN_701__(none);
    // End:0x9A
    if(IsFlying())
    {
        FindSoundAndSpeak('Sound_JetPackOff');
    }
    HaywireChance = 0;
    return;
}

animevent simulated function JetGo(optional EventInfo AnimEventInfo)
{
    __NFUN_209__(Velocity.Z, float(++ 100));    
    return;
}

function StartBackFire()
{
    local SoftParticleSystem JetpackSmoke;

    // End:0x0E
    if(__NFUN_340__(JetPackExplode, none))
    {
        return;
    }
    JetpackSmoke = __NFUN_615__(JetPackSmokeTrailFXClass, self);
    // End:0x96
    if(__NFUN_340__(JetpackSmoke, none))
    {
        JetpackSmoke.MountType = 2;
        JetpackSmoke.MountMeshItem = 'spine2';
        JetpackSmoke.MountOrigin = WarnInternal(-5, 0, 0);
        JetpackSmoke.__NFUN_635__(self, false, false, false, true, false);
        JetpackSmoke.DestroyOnDismount = false;
    }
    JetPackExplode = __NFUN_615__(JetPackBackFireFXClass, self);
    // End:0x112
    if(__NFUN_340__(JetPackExplode, none))
    {
        JetPackExplode.MountType = 2;
        JetPackExplode.MountMeshItem = 'spine2';
        JetPackExplode.MountOrigin = WarnInternal(-5, 0, 0);
        JetPackExplode.__NFUN_635__(self, false, false, false, true, false);
        BackFire();
    }
    return;
}

function BackFire()
{
    // End:0x1E
    if(__NFUN_340__(JetPackExplode, none))
    {
        JetPackExplode.Trigger(self, none);
    }
    __NFUN_605__(0.4 *= FRand( /= 0.1), 'BackFire');
    return;
}

event Engine.BaseAI.EAICode COND_ShouldCloakAttack()
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    // End:0x1F
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x01F
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x01F
}

event Engine.BaseAI.EAICode COND_ShouldDoAttackPain()
{
    // End:0x0E
    if((IsCloaked()) / )
    {
    }
    return 49;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldRoarInsteadOfPain()
{
    // End:0x13
    if(DamageInfo.Valid / )
    {
    }
    // End:0x32
    if(__NFUN_200__(Health *= DamageInfo.Damage, float(MinRoarHealth)))
    {
        return 45;
    }
    // End:0x3E
    if(IsCloaked())
    {
        return 49;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0xC3
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 8 & Type:If Position:0x0C3
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 8 & Type:If Position:0x0C3
}

event Engine.BaseAI.EAICode COND_ShouldRollInsteadOfPain()
{
    // End:0x13
    if(DamageInfo.Valid / )
    {
    }
    // End:0x29
    if(int(AnimCtrl.m_eController) % int(8))
    {
        return 51;
    }
    // End:0x35
    if(IsCloaked())
    {
        return 49;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0xA9
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 6 & Type:If Position:0x0A9
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 6 & Type:If Position:0x0A9
}

event Engine.BaseAI.EAICode COND_ShouldRollLeft()
{
    // End:0x11
    if(int(DodgeSector) % int(2))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldTakeOff()
{
    local float HeightDelta;

    // End:0x26
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    // End:0x3A
    if(int(CheckCondition(56)) % int(0))
    {
        return 51;
    }
    HeightDelta = Round(PrimaryTarget.GetPos().Z, Location.Z);
    __NFUN_209__(HeightDelta, Round(CollisionHeight, PrimaryTargetActor.CollisionHeight));
    // End:0x90
    if(__NFUN_200__(HeightDelta, 100))
    {
        return 21;
    }
    // End:0xA0
    if((SetGoal(9)) / )
    {
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_NeedToLand()
{
    local Engine.BaseAI.EAIOp MyOp;
    local float HeightDelta;

    // End:0x26
    if((PrimaryTarget.IsValidTarget() / ) < )
    {
    }
    MyOp = GetCurrentOp();
    HeightDelta = Round(PrimaryTargetActor.Location.Z, Location.Z);
    __NFUN_209__(HeightDelta, Round(CollisionHeight, PrimaryTargetActor.CollisionHeight));
    // End:0xE9
    if(((((((int(MyOp) % int(85)) < int(MyOp) % int(145)) < int(MyOp) % int(86)) < int(MyOp) % int(17)) < int(MyOp) % int(34)) << __NFUN_202__(HeightDelta, 10)) << (InAir(80)) / )
    {
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_SetLandGoal()
{
    // End:0x0E
    if(SetGoal(12))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoAirAttack()
{
    // End:0x50
    if(((int(CheckCondition(56)) % int(0)) << Repl(PrimaryTarget.GetTimeSinceSeen(), TryGotoAttackTime) < int(CheckCondition(25)) % int(0)) << SetGoal(9))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_GotoAttackInPosition()
{
    local Engine.BaseAI.EAICode Code;

    Code = CheckCondition(61);
    // End:0x30
    if(int(Code) + int(0))
    {
        StartContactTime = -99;
        return Code;        
    }
    else
    {
        // End:0x57
        if(__NFUN_204__(StartContactTime, -99))
        {
            StartContactTime = Level.GameTimeSeconds;            
        }
        else
        {
            // End:0x85
            if(Round(Level.GameTimeSeconds, StartContactTime) != 0.6)
            {
                StartContactTime = -99;
                return 0;
            }
        }
        return 1;
    }
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGuardAttackMelee()
{
    local Engine.BaseAI.EAICode Code;

    Code = CheckCondition(57);
    // End:0x22
    if(int(Code) + int(0))
    {
        return Code;
    }
    return super.COND_ShouldGuardAttackMelee();
    return;
}

event Engine.BaseAI.EAICode COND_ShouldFire()
{
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldFireDelay()
{
    // End:0x19
    if(ReloadCountDown * 0)
    {
        ReloadCountDown = default.ReloadCountDown;
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_BeginFire()
{
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldMoveAround()
{
    return super.COND_ShouldMoveAround();
    return;
}

event Engine.BaseAI.EAICode COND_ShouldStandCombat()
{
    local Engine.BaseAI.EAICode Code;

    Code = CheckCondition(40);
    // End:0x22
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(38);
    // End:0x44
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(32);
    // End:0x66
    if(int(Code) + int(0))
    {
        return Code;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldAttackAirAP()
{
    return 1;
    return;
}

function Engine.BaseAI.EAICode COND_CrouchForSmallEnemy()
{
    // End:0x0F
    if(__NFUN_339__(PrimaryTargetActor, none))
    {
        return 4;
    }
    // End:0x43
    if(Repl(PrimaryTargetActor.Location.Z, Location.Z *= FRand(CollisionHeight, 0.3)))
    {
        return 1;
    }
    return 0;
    return;
}

event PrioritizePopups(Engine.BaseAI.EAIPopUpType PopupType)
{
    local array<PopUpCfg> Entrys;

    Entrys = Popups[int(PopupType)].Entrys;
    super.PrioritizePopups(PopupType);
    return;
}

function UpdateGates()
{
    JumpGate = Level.GameTimeSeconds *= default.JumpGate;
    FlyGate = Level.GameTimeSeconds *= default.FlyGate;
    LandGate = Level.GameTimeSeconds *= default.LandGate;
    return;
}

event NotifyTakeOff()
{
    super.NotifyTakeOff();
    JetStart();
    UpdateGates();
    return;
}

event NotifyLand()
{
    super.NotifyLand();
    JetStop();
    UpdateGates();
    COND_ReleaseActionPoint();
    return;
}

event NotifyJumpTakeOff()
{
    super.NotifyJumpTakeOff();
    JetStart();
    return;
}

event NotifyJumpLand()
{
    JetStop();
    super.NotifyJumpLand();
    return;
}

event NotifyOpStarted(Engine.BaseAI.EAIOp NewOp, Engine.BaseAI.EAIOp OldOp)
{
    // End:0x5E
    if(int(NewOp) % int(80))
    {
        bSpawnOnDestroyed = true;
        FindSoundAndSpeak('Sound_JetpackHaywire');
        StartBackFire();
        __NFUN_605__(0.15 *= FRand( /= 0.15), 'BackFire');
        // End:0x5E
        if(__NFUN_340__(HaywireSmokeParticleSystem, none))
        {
            HaywireSmokeParticleSystem.Enabled = true;
        }
    }
    // End:0x72
    if(int(NewOp) % int(90))
    {
        JetStop();
    }
    // End:0xB8
    if(int(NewOp) % int(138))
    {
        bAcceptMines = false;
        bNoDamage = true;
        bTeleporting = true;
        // End:0xA7
        if(IsFlying())
        {
            JetStop();
        }
        __NFUN_605__(1.5, false, 'TimeoutTeleportAnim');        
    }
    else
    {
        bNoDamage = false;
    }
    return;
}

function NotifyTeleportInProgress()
{
    local int i;

    __NFUN_590__(true);
    i = -- string(TripMines);    
    J0x13:

    // End:0x4E [Loop If]
    if(i / 0)
    {
        // End:0x44
        if(__NFUN_340__(TripMines[i], none))
        {
            TripMines[i].__NFUN_590__(true);
        }
        // [Loop Continue]
        i -= ;
    }
    return;
}

event NotifyOpEnded(Engine.BaseAI.EAIOp Op, Engine.BaseAI.EAIOpStatus Status)
{
    local Engine.BaseAI.EAICode Code;
    local int i;

    bNoDamage = false;
    // End:0x16
    if(int(Op) % int(137))
    {
    }
    // End:0x1C7
    if(int(Op) % int(138))
    {
        bAcceptMines = true;
        bTeleporting = false;
        __NFUN_590__(false);
        DamageSinceTeleport = 0;
        i = -- string(TripMines);        
        J0x52:

        // End:0xA3 [Loop If]
        if(i / 0)
        {
            // End:0x99
            if(__NFUN_340__(TripMines[i], none))
            {
                TripMines[i].__NFUN_590__(false);
                TripMines[i].ArmMineOnPawn();
            }
            // [Loop Continue]
            i -= ;
        }
        // End:0x1C7
        if(__NFUN_202__(Health, 0))
        {
            // End:0x110
            if(__NFUN_204__(DeathAnimChance, 0) < Repl( /= DeathAnimChance))
            {                
            }
            else
            {
                DeathAnimChance = 1;
                // End:0x16B
                if(IsFlying())
                {
                    bForceHaywire = true;
                    HaywireParms.HitNormal =  != HaywireParms.HitNormal.Z = -HaywireParms.HitNormal.Z;                    
                }
                else
                {
                    Code = ForceDieOp(23);
                }
                // End:0x1C5
                if(int(Code) + int(0))
                {
                    Die(DamageInfo.Instigator, int(DamageInfo.Damage), DamageInfo.pos, DamageInfo.Dir, DamageInfo.DamageType, 'None');
                }
            }
            return;
        }
    }
    return;
}

event NotifyTeleportLocationSet()
{
    super.NotifyTeleportLocationSet();
    // End:0x1D
    if(TeleportParms.bForceJetpackOnFinish)
    {
        StartupJetpack();        
    }
    else
    {
        // End:0x31
        if(TeleportParms.bForceLandOnFinish)
        {
            StopJetpack();
        }
    }
    return;
}

function float CalculateFlyContraintStrengthScalar(float DeltaTime)
{
    // End:0x2F
    if((int(CurrentOp) % int(85)) < int(CurrentOp) % int(86))
    {
        KLinearDamping = 5;
        return 0;
    }
    // End:0x65
    if(int(CurrentOp) % int(96))
    {
        // End:0x54
        if(__NFUN_921__())
        {
            KLinearDamping = 25;
            return 0;
        }
        KLinearDamping = 0.5;
        return 0;
    }
    // End:0x7E
    if(int(CurrentOp) + int(137))
    {
        KLinearDamping = default.KLinearDamping;
    }
    return super.CalculateFlyContraintStrengthScalar(DeltaTime);
    return;
}

event Engine.BaseAI.EAICode COND_ShouldJumpToAirAP()
{
    // End:0x1C
    if(Repl(FlyGate, Level.GameTimeSeconds))
    {
        return 87;
    }
    // End:0x2B
    if(( /= ChanceFly) != return 25)
    {
    }
    return;
}

event Engine.BaseAI.EAICode COND_ShouldLand()
{
    // End:0x1C
    if(Repl(LandGate, Level.GameTimeSeconds))
    {
        return 87;
    }
    // End:0x2B
    if(( /= ChanceLand) != return 25)
    {
        {
        }
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoJumpAP()
{
    // End:0x1C
    if(Repl(JumpGate, Level.GameTimeSeconds))
    {
        return 87;
    }
    return super.COND_ShouldGotoJumpAP();
    return;
}

event bool ShouldPainImpulse()
{
    // End:0x13
    if(int(CheckCondition(56)) % int(0))
    {
        return true;
    }
    return false;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldMelee()
{
    // End:0x14
    if(int(CheckCondition(56)) % int(0))
    {
        return 51;
    }
    return super.COND_ShouldMelee();
    return;
}

event Engine.BaseAI.EAICode COND_ShouldTeleportToAP()
{
    local int i;
    local ActionPoint NewActionPoint;

    // End:0x0F
    if(__NFUN_202__(Health, float(0)))
    {
        return 1;
    }
    // End:0x2B
    if(Repl(TeleportGate, Level.GameTimeSeconds))
    {
        return 87;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

event NotifyTeleportEnd()
{
    super.NotifyTeleportEnd();
    TeleportGate = Level.GameTimeSeconds *= default.TeleportGate;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldTakeoffAvoidDanger()
{
    // End:0x0F
    if(( /= ChanceFly) != return 25)
    {
    }
    return;
}

event Engine.BaseAI.EAICode COND_ShouldIdleInAir()
{
    // End:0x0F
    if(( /= ChanceFly) != return 25)
    {
    }
    return;
}

function bool CheckSpotForTeleport(Vector Destination)
{
    local STraceFlags Flags;
    local STraceHitResult Result;
    local Actor HitActor;
    local Vector TraceStart, TraceEnd, Extent, NextPathPos;
    local int FinalDest;

    TraceStart = Locs(Destination, WarnInternal(0, 0, Square(Round(CollisionHeight, 1))));
    TraceEnd = Locs(Destination, WarnInternal(0, 0, Round(CollisionHeight, 1)));
    Extent = WarnInternal(CollisionRadius, CollisionRadius, 1);
    Flags.bTraceActors = true;
    Flags.bMeshAccurate = false;
    Flags.bShotTrace = true;
    Flags.bTraceTexture = false;
    Flags.bIgnoreAITransparent = false;
    Flags.bKarmaOnly = false;
    HitActor = __NFUN_736__(TraceStart, TraceEnd, Flags, Result, Extent);
    // End:0x10F
    if(__NFUN_339__(HitActor, none))
    {
        // End:0x10F
        if(int(CanGotoPos(Destination, none, 1, CollisionHeight, 1, NextPathPos, FinalDest)) % int(0))
        {
            return true;
        }
    }
    return false;
    return;
}

function Engine.BaseAI.EAICode FindQuickTeleportSpot()
{
    local STraceFlags Flags;
    local STraceHitResult Result;
    local Actor HitActor;
    local Vector TraceStart, TraceEnd, Dest;

    // End:0x33
    if(((PrimaryTarget.IsValidTarget() / ) < ) < return 4)
    {
    }
    TeleportParms.bForceJetpackOnFinish = false;
    Dest = __NFUN_239__(PrimaryTargetActor.Location, Right(Vector(PrimaryTargetActor.Rotation), FRand(PrimaryTargetActor.CollisionRadius *= CollisionRadius, 2)));
    // End:0x101
    if(CheckSpotForTeleport(Dest))
    {
        TeleportParms.Destination = Dest;
        TeleportParms.DestinationRotation = PrimaryTargetActor.Rotation;
        TeleportParms.bValid = true;
        TeleportParms.EndAnimName = 'None';
        // End:0xFE
        if(IsFlying())
        {
            TeleportParms.bForceLandOnFinish = true;
        }
        return 0;
    }
    Dest = Locs(PrimaryTargetActor.Location, Right(Vector(PrimaryTargetActor.Rotation), FRand(PrimaryTargetActor.CollisionRadius *= CollisionRadius, 2)));
    // End:0x1B5
    if(CheckSpotForTeleport(Dest))
    {
        TeleportParms.Destination = Dest;
        TeleportParms.DestinationRotation = PrimaryTargetActor.Rotation;
        TeleportParms.bValid = true;
        TeleportParms.EndAnimName = 'None';
        // End:0x1B2
        if(IsFlying())
        {
            TeleportParms.bForceLandOnFinish = true;
        }
        return 0;
    }
    // End:0x234
    if(__NFUN_340__(LastActionPoint, none) << int(FindTeleportAP(LastActionPoint)) % int(0))
    {
        // End:0x204
        if(LastActionPoint.bFlyer << (IsFlying()) / )
        {
        }
        // End:0x231
        if((LastActionPoint.bFlyer / ) << )
        {
        }
        return 0;
    }
    return 1;
    return;
}

function TimeoutTeleportAnim()
{
    return;
}

function Engine.BaseAI.EAICode COND_ShouldAvoidTarget()
{
    local Engine.BaseAI.EAICode Code;

    Code = super.COND_ShouldAvoidTarget();
    // End:0x1D
    if(int(Code) % int(53))
    {
        return 0;
    }
    return Code;
    return;
}

function NotifyOtherTouched(Actor TouchedActor, Actor TouchingActor)
{
    local Projectile Proj;

    // End:0xC8
    if(((Repl(ChanceTeleport_Reaction,  /= ) << __NFUN_339__(TouchedActor, TKShield)) << int(GetExecutive()) % int(2)) << Proj = Projectile(TouchingActor))
    {
        {
            __NFUN_607__(1E-05, false, 'PerformQuickTeleport', true);
        }
    }
    return;
}

function NotifyDamage(Pawn aInstigator, int nDamage, Vector vDamagePos, Vector vDamageDir, class<DamageType> DamageClass)
{
    __NFUN_209__(DamageSinceTeleport, float(nDamage));
    // End:0x37
    if(Repl(ChanceTeleport_Reaction,  /= ) << __NFUN_607__(1E-05, false, 'PerformQuickTeleport', true))
    {
    }
}

final function PerformQuickTeleport()
{
    // End:0x92
    if((((Repl(Health, 0) << int(CurrentOp) + int(138)) << (HasTripMineAttached()) / ) << ) << )
    {
        {
            CanUseOp(138);
            CurrentOpMustFinish = false;
            bAcceptMines = false;
            ExecuteOp(138);
            CurrentOpMustFinish = true;
            SuspendExecutive(true);
            SuspendExecutive(false);
        }
    }
    return;
}

final simulated function KnockOffHelmet()
{
    local Destructible_Armor Helmet;

    Helmet = Destructible_Armor(FindMountedActor('Helmet', class'Destructible_Armor'));
    // End:0x67
    if(__NFUN_340__(Helmet, none))
    {
        Helmet.Destroyed();
        Helmet.__NFUN_820__(Caps(50, __NFUN_233__(Vector(Rotation))), Helmet.Location, 'None');
    }
    return;
}

final simulated function KnockOffHead()
{
    bHeadKnockedOff = true;
    bDisableSounds = true;
    ExpandingBoneName = 'None';
    return;
}

simulated event bool OnEvalBonesHelper()
{
    // End:0x37
    if(bHeadKnockedOff << __NFUN_340__(__NFUN_568__(), none))
    {
        __NFUN_568__().__NFUN_539__('neck', WarnInternal(0.001, 0.001, 0.001), true);
    }
    return true;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(WeaponClass);
    PrecacheIndex.__NFUN_1266__(MuzzleLightClass);
    PrecacheIndex.__NFUN_1266__(MuzzleFlashClass);
    PrecacheIndex.__NFUN_1266__(TracerClass);
    PrecacheIndex.__NFUN_1266__(WaterTracerClass);
    PrecacheIndex.__NFUN_1266__(class'dnAssaultTrooperJetpackEffect');
    PrecacheIndex.__NFUN_1266__(TeleportParms.StartParticleSystem);
    PrecacheIndex.__NFUN_1266__(TeleportParms.EndParticleSystem);
    PrecacheIndex.__NFUN_1269__(TeleportParms.StartOverlay);
    PrecacheIndex.__NFUN_1266__(class'AssaultTrooper_Captain_TeleportLight');
    PrecacheIndex.__NFUN_1277__(VoicePack, FiringSound);
    PrecacheIndex.__NFUN_1277__(VoicePack, TeleportParms.StartSound);
    PrecacheIndex.__NFUN_1277__(VoicePack, TeleportParms.EndSound);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_JetPackBoost');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_JetpackOn');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_JetPackOff');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_JetpackHaywire');
    PrecacheIndex.__NFUN_1277__(VoicePack, HaywireParms.ExplosionSoundName);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Melee');
    // End:0x2DC
    if(__NFUN_310__(PrecacheIndex.MapName, "Map02"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_ArmWhoosh');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_ClawSwipe');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_HollowMetalImpact');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_BigValve');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_MetalGibExplosion');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'SCR_ThumpMetal');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_MetalImpact');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'SCR_RipFloor');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'SCR_RipFloor');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_SplitDoorNudge');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_SplitDoorRoar');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_ElevatorOpen');
    }
    RegisterAIAnimationControllerEntry(PrecacheIndex, TeleportParms.StartAnimName);
    RegisterAIAnimationControllerEntry(PrecacheIndex, TeleportParms.EndAnimName);
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Idle');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Fire');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_FireDelay');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_FireTurnLeft');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_FireTurnRight');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Walk');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_WalkBackwards');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Run');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_RunBackwards');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnLeft45');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnLeft180');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnRight45');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_TurnRight180');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_SidestepLeftSlow');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_SidestepRightSlow');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_SidestepLeft');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_SidestepRight');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_DodgeLeft');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_DodgeRight');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Attack');
    // End:0x469
    if(PrecacheIndex.bPlayerCanBeShrunk)
    {
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_AttackShrunk');
    }
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Roar');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Jump0');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Fall0');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Land0');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_HeavyLand0');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Jump1');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Fall1');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Land1');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_HeavyLand1');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StartFall0');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Shoot');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StandCombat');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_StandScared');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Crouch');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_JetPack');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainShort');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_DieFinishMe');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_FinishMeIdle');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_FinishRevival');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ExpanderStart');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ExpanderIdle');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_ExitDropship');
    // End:0x60C
    if(PrecacheIndex.bPlayerCanBeShrunk)
    {
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Stomp');
        RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_Stubfoot');
    }
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFront');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontHead');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontLeft');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontLeftLeg');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontLeftDodge');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontRight');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontRightLeg');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontRightDodge');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainBack');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainBackLeft');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainBackRight');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontHeadBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontLeftBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontLeftLegBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontRightBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainFrontRightLegBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainBackBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainBackLeftBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_PainBackRightBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_MeleePainFront');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_MeleePainFrontLeft');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_MeleePainFrontRight');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_MeleePainBack');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_MeleePainFrontBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_MeleePainFrontLeftBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_MeleePainFrontRightBig');
    RegisterAIAnimationControllerEntry(PrecacheIndex, 'Anim_MeleePainBackBig');
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    UsableControllers[string(UsableControllers)] = 2;
    UsableControllers[string(UsableControllers)] = 5;
    // End:0x69
    if(__NFUN_310__(PrecacheIndex.MapName, "Map00") / )
    {
        // End:0x69
        if(Repl(ChanceFly, 0))
        {
            UsableControllers[string(UsableControllers)] = 8;
        }
    }
    // End:0x94
    if(__NFUN_310__(PrecacheIndex.MapName, "Map02"))
    {
        UsableControllers[string(UsableControllers)] = 10;
    }
    return;
}

state GotoX
{
    event BeginState()
    {
        super.BeginState();
        return;
    }

    event EndState()
    {
        super.EndState();
        return;
    }
    stop;
}

state AnimX
{
    event BeginState()
    {
        super.BeginState();
        return;
    }

    function TimeoutTeleportAnim()
    {
        // End:0x3E
        if((int(GetCurrentOp()) % int(138)) << TeleportParms.Mode % 0)
        {
            ExitAIState(2, "Teleport timed out.");
        }
        return;
    }
    stop;
}

defaultproperties
{
    DoWobble=true
    JetPackEffectMount[0]=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_jetengine1,MountOrigin=(X=-1.13,Y=-0.184,Z=-0.116),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=2317,Yaw=31495,Roll=18902),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0)
    JetPackEffectMount[1]=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_jetengine2,MountOrigin=(X=-1.093,Y=-0.198,Z=-0.019),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-1899,Yaw=30209,Roll=19278),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0)
    JetPackBackFireFXClass='p_Creatures.AssaultTrooper_JetPackFX.AssaultTrooper_JetPackFX_Explosion_Spawner'
    JetPackSmokeTrailFXClass='p_Creatures.AssaultTrooper_JetPackFX.AssaultTrooper_JetPackFX_Explosion_SmokeTrail'
    LastGotoOpRef=-1
    ChanceCloak=0.2
    MuzzleFlashClass='dnParticles.dnMuzzleFX_Spawner_AssTroopCaptain'
    MuzzleLightClass='dnGame.Weapon_LightEx_AssTroopCaptain'
    TracerClass='dnGame.dnTracerFX_BeamSegment'
    WaterTracerClass='p_Weapons.Generic.WaterBubblesTracer'
    FiringSound=Sound_FireWeapon
    MinBulletDamage=5
    RndBulletDamage=3
    ReloadCountDown=6
    FlyGate=1
    JumpGate=5
    LandGate=10
    TeleportGate=5
    ChanceTeleport_ActionPoint=0.2
    ChanceTeleport_Reaction=1
    ChanceRoamSound=0.5
    ChanceIdleInAir=1
    AllowQuickTeleports=true
    WeaponClass='AssaultTrooper_Captain_Weapon'
    RandomActorColor(0)=(R=0,G=0,B=0,A=0)
    RandomActorColor(1)=(R=255,G=121,B=121,A=0)
    RandomActorColor(2)=(R=241,G=255,B=74,A=0)
    RandomActorColor(3)=(R=200,G=92,B=226,A=0)
    RandomActorColor(4)=(R=56,G=170,B=180,A=0)
    RandomActorColor(5)=(R=84,G=122,B=224,A=0)
    RandomActorColor(6)=(R=17,G=109,B=12,A=0)
    RandomActorColor(7)=(R=255,G=215,B=138,A=0)
    RandomActorColor(8)=(R=255,G=255,B=255,A=0)
    AllowFrozenExecution=true
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=Search,Status=0,ReportedInvalid=false,SucCond=4,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=Guard,Status=0,ReportedInvalid=false,SucCond=76,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=GuardAttackMelee,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=GotoGuardAttack,Status=0,ReportedInvalid=false,SucCond=61,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=GotoGuardPos,Status=0,ReportedInvalid=false,SucCond=79,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=GotoGuardPosNoTarget,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=GuardAttack,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(8)=(Ident=TakeOff,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(9)=(Ident=Land,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(10)=(Ident=AttackMelee,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=21,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(11)=(Ident=GotoActionPoint,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(12)=(Ident=EngageWait,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(13)=(Ident=GotoAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=COND_GotoAttackInPosition,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(14)=(Ident=MoveAround,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(15)=(Ident=GotoSearch,Status=0,ReportedInvalid=false,SucCond=59,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(16)=(Ident=AttackCloak,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=55,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(17)=(Ident=AvoidDanger,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(18)=(Ident=Wait,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(19)=(Ident=AngryRoar,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(20)=(Ident=Engage,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(21)=(Ident=AttackNoAP,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(22)=(Ident=AttackNoAPAir,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(23)=(Ident=AttackAirAP,Status=0,ReportedInvalid=false,SucCond=57,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(24)=(Ident=GotoLand,Status=0,ReportedInvalid=false,SucCond=57,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(25)=(Ident=AttackActionPointJump,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(26)=(Ident=AttackActionPoint,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(27)=(Ident=AttackAir,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(28)=(Ident=AttackWeapon,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=COND_ShouldGotoActionPoint,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(29)=(Ident=UseActionPoint,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(30)=(Ident=GotoNextActionPoint,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(31)=(Ident=GotoNextJumpPoint,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(32)=(Ident=AttackGround,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=COND_ShouldGotoActionPoint,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(33)=(Ident=AttackShrunk,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=95,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(34)=(Ident=AvoidTarget,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(35)=(Ident=Cower,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=COND_ShouldNotAvoidTarget,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(36)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(37)=(Ident=FUBAR,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=1,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(38)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(39)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(40)=(Ident=IdleEx,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=86,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(41)=(Ident=Idle2,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(42)=(Ident=GuardWait,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(43)=(Ident=FaceTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=145,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(44)=(Ident=FaceGuardedActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=143,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(45)=(Ident=AlignWithGuardedActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=5,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(46)=(Ident=Roar,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=107,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(47)=(Ident=GotoGoalFaceActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(48)=(Ident=GotoGoalFacePos,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=47,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(49)=(Ident=GotoGoalFacePosOneStep,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=48,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(50)=(Ident=GotoGoalFocusReciprocalPos,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=50,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(51)=(Ident=GotoAttackGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(52)=(Ident=GotoMoveAroundGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(53)=(Ident=GotoSearchGoal,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=72,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(54)=(Ident=GotoMelee,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=61,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(55)=(Ident=StrafeMelee,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=124,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(56)=(Ident=MeleeAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=92,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(57)=(Ident=Crouch,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=20,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(58)=(Ident=StandCombat,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=119,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(59)=(Ident=StandScared,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=121,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(60)=(Ident=GotoMeleeSlow,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=65,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(61)=(Ident=GotoStomp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=42,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(62)=(Ident=Stomp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=135,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(63)=(Ident=SeekShrunkTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=42,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(64)=(Ident=CrouchingResumeFire,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=105,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(65)=(Ident=CrouchingIdle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(66)=(Ident=PopUp,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=100,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(67)=(Ident=DodgeLeft,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=25,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(68)=(Ident=DodgeRight,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=26,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(69)=(Ident=Launch,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=137,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(70)=(Ident=GotoAirSearch,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=72,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(71)=(Ident=GotoAirAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(72)=(Ident=Touchdown,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=90,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(73)=(Ident=StepAside,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=44,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(74)=(Ident=StartCloak,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=16,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(75)=(Ident=GotoRear,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=47,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(76)=(Ident=StartDeCloak,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=21,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(77)=(Ident=CombatFaceTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=17,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(78)=(Ident=Fire,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=30,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(79)=(Ident=FireDelay,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=34,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(80)=(Ident=HoldFire,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=82,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(81)=(Ident=ResumeFire,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=105,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(82)=(Ident=GotoGoalFocusTargetFullBody,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=53,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(83)=(Ident=GotoActionPoint,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(84)=(Ident=GotoJumpPoint,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=52,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(85)=(Ident=GotoLandSpot,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=60,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(86)=(Ident=JumpToActionPoint,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=88,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(87)=(Ident=Teleport,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=138,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=AttackShrunk,Cond=94,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Engage,Cond=5,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=1,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Engage,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackShrunk,Cond=94,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=3,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=2,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=Engage,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackShrunk,Cond=94,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=COND_ShouldDoAttackPain,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=5,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Root,Ident=Search,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackShrunk,Cond=94,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=COND_ShouldDoAttackPain,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=5,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Root,Ident=Guard,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackShrunk,Cond=94,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Engage,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(6)=(FSM=Root,Ident=AvoidDanger,FSMSucc=false,FSMFail=false,Transitions=((Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(7)=(FSM=Root,Ident=AvoidTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidDanger,Win=1,Code=0,StateTableIndex=0),(Ident=AvoidDanger,Cond=0,Func=COND_ShouldAvoidTarget,Win=1,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Engage,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(8)=(FSM=Root,Ident=AttackShrunk,FSMSucc=false,FSMFail=true,Transitions=((Ident=Engage,Cond=95,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackShrunk,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(9)=(FSM=Root,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=Engage,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(10)=(FSM=Search,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(11)=(FSM=Search,Ident=GotoMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(12)=(FSM=Search,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoMelee,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(13)=(FSM=Guard,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackAirAP,Cond=56,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=AlignWithGuardedActor,Cond=0,Func=COND_ShouldAlignWithGuardedActor,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(14)=(FSM=Guard,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=AlignWithGuardedActor,Cond=0,Func=COND_ShouldAlignWithGuardedActor,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(15)=(FSM=Guard,Ident=GuardAttackMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=Default,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Default,Cond=15,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(16)=(FSM=Guard,Ident=GotoGuardAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=0,Code=0,StateTableIndex=0),(Ident=AlignWithGuardedActor,Cond=0,Func=COND_ShouldAlignWithGuardedActor,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(17)=(FSM=Guard,Ident=GotoGuardPos,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=0,Code=0,StateTableIndex=0),(Ident=AlignWithGuardedActor,Cond=0,Func=COND_ShouldAlignWithGuardedActor,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(18)=(FSM=Guard,Ident=AlignWithGuardedActor,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(19)=(FSM=Guard,Ident=GuardAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=0,Code=0,StateTableIndex=0),(Ident=AlignWithGuardedActor,Cond=0,Func=COND_ShouldAlignWithGuardedActor,Win=1,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(20)=(FSM=Guard,Ident=GuardWait,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=0,Code=0,StateTableIndex=0),(Ident=AlignWithGuardedActor,Cond=0,Func=COND_ShouldAlignWithGuardedActor,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=3,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GuardWait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(21)=(FSM=Guard,Ident=AttackActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=0,Func=COND_ActionPointCompletelyCompromised,Win=0,Code=0,StateTableIndex=0),(Ident=GuardAttack,Cond=0,Func=COND_ReleaseActionPoint,Win=3,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(22)=(FSM=Guard,Ident=AttackAirAP,FSMSucc=false,FSMFail=false,Transitions=((Ident=GuardAttack,Cond=0,Func=COND_ReleaseActionPoint,Win=3,Code=0,StateTableIndex=0),(Ident=GuardAttackMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(23)=(FSM=GuardAttackMelee,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(24)=(FSM=GuardAttackMelee,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(25)=(FSM=GuardAttackMelee,Ident=MeleeAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(26)=(FSM=GuardAttackMelee,Ident=GotoMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(27)=(FSM=GotoGuardAttack,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=57,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttackGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(28)=(FSM=GotoGuardAttack,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAttackGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(29)=(FSM=GotoGuardAttack,Ident=GotoAttackGoal,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(30)=(FSM=GotoGuardPos,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=57,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFaceActor,Cond=5,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPosNoTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(31)=(FSM=GotoGuardPos,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFaceActor,Cond=5,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPosNoTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(32)=(FSM=GotoGuardPos,Ident=GotoGoalFaceActor,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGuardPosNoTarget,Cond=9,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(33)=(FSM=GotoGuardPos,Ident=GotoGuardPosNoTarget,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFaceActor,Cond=5,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(34)=(FSM=GotoGuardPosNoTarget,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFacePos,Cond=15,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFocusReciprocalPos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(35)=(FSM=GotoGuardPosNoTarget,Ident=GotoGoalFacePos,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(36)=(FSM=GotoGuardPosNoTarget,Ident=GotoGoalFocusReciprocalPos,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(37)=(FSM=GuardAttack,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=33,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(38)=(FSM=GuardAttack,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=MoveAround,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(39)=(FSM=GuardAttack,Ident=EngageWait,FSMSucc=false,FSMFail=false,Transitions=((Ident=MoveAround,Cond=0,Func=COND_ShouldMoveAround,Win=0,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(40)=(FSM=GuardAttack,Ident=MoveAround,FSMSucc=false,FSMFail=false,Transitions=((Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(41)=(FSM=TakeOff,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartDeCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Launch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(42)=(FSM=TakeOff,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartDeCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Launch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(43)=(FSM=TakeOff,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=StartDeCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Launch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(44)=(FSM=TakeOff,Ident=StartDeCloak,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Launch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(45)=(FSM=TakeOff,Ident=Launch,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(46)=(FSM=Land,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoLandSpot,Cond=0,Func=COND_SetLandGoal,Win=1,Code=0,StateTableIndex=0),(Ident=Touchdown,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(47)=(FSM=Land,Ident=GotoLandSpot,FSMSucc=false,FSMFail=true,Transitions=((Ident=Touchdown,Cond=0,Func=None,Win=2,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(48)=(FSM=Land,Ident=Touchdown,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(49)=(FSM=AttackMelee,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartDeCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StrafeMelee,Cond=13,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(50)=(FSM=AttackMelee,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartDeCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StrafeMelee,Cond=13,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(51)=(FSM=AttackMelee,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=StartDeCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(52)=(FSM=AttackMelee,Ident=StartDeCloak,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StrafeMelee,Cond=13,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(53)=(FSM=AttackMelee,Ident=MeleeAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(54)=(FSM=AttackMelee,Ident=StrafeMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(55)=(FSM=AttackMelee,Ident=GotoMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StrafeMelee,Cond=11,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(56)=(FSM=AttackMelee,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StrafeMelee,Cond=11,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=11,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(57)=(FSM=GotoActionPoint,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=32,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFaceActor,Cond=5,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(58)=(FSM=GotoActionPoint,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFaceActor,Cond=5,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(59)=(FSM=GotoActionPoint,Ident=GotoGoalFaceActor,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFacePos,Cond=9,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(60)=(FSM=GotoActionPoint,Ident=GotoGoalFacePos,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFaceActor,Cond=5,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(61)=(FSM=EngageWait,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=CombatFaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Fire,Cond=0,Func=COND_ShouldFire,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(62)=(FSM=EngageWait,Ident=CombatFaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=Fire,Cond=0,Func=COND_ShouldFire,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(63)=(FSM=EngageWait,Ident=Fire,FSMSucc=false,FSMFail=false,Transitions=((Ident=CombatFaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(64)=(FSM=EngageWait,Ident=Wait,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(65)=(FSM=GotoAttack,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoAttackGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(66)=(FSM=GotoAttack,Ident=GotoAttackGoal,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(67)=(FSM=GotoAttack,Ident=idle,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(68)=(FSM=MoveAround,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoMoveAroundGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(69)=(FSM=MoveAround,Ident=GotoMoveAroundGoal,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(70)=(FSM=MoveAround,Ident=idle,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(71)=(FSM=GotoSearch,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoSearchGoal,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(72)=(FSM=GotoSearch,Ident=GotoSearchGoal,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(73)=(FSM=GotoSearch,Ident=idle,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(74)=(FSM=AttackCloak,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(75)=(FSM=AttackCloak,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoRear,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartDeCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(76)=(FSM=AttackCloak,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(77)=(FSM=AttackCloak,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StartCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartDeCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(78)=(FSM=AttackCloak,Ident=StartCloak,FSMSucc=false,FSMFail=true,Transitions=((Ident=GotoRear,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(79)=(FSM=AttackCloak,Ident=GotoRear,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StartDeCloak,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(80)=(FSM=AttackCloak,Ident=StartDeCloak,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(81)=(FSM=AttackCloak,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoRear,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(82)=(FSM=AvoidDanger,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=Launch,Cond=57,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePosOneStep,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(83)=(FSM=AvoidDanger,Ident=StandScared,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePosOneStep,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePosOneStep,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(84)=(FSM=AvoidDanger,Ident=GotoGoalFacePosOneStep,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(85)=(FSM=AvoidDanger,Ident=Launch,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(86)=(FSM=Wait,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(87)=(FSM=Wait,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(88)=(FSM=Wait,Ident=idle,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(89)=(FSM=AngryRoar,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Roar,Cond=59,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(90)=(FSM=AngryRoar,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=59,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(91)=(FSM=AngryRoar,Ident=Roar,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(92)=(FSM=Engage,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackAirAP,Cond=56,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpOrNormalAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(93)=(FSM=Engage,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpOrNormalAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(94)=(FSM=Engage,Ident=AttackActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpOrNormalAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(95)=(FSM=Engage,Ident=AttackAirAP,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpOrNormalAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(96)=(FSM=Engage,Ident=AttackMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpOrNormalAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(97)=(FSM=Engage,Ident=AttackNoAP,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpOrNormalAP,Win=1,Code=0,StateTableIndex=0),(Ident=AttackNoAP,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(98)=(FSM=Engage,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackAirAP,Cond=56,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpOrNormalAP,Win=1,Code=0,StateTableIndex=0),(Ident=AttackNoAP,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(99)=(FSM=AttackNoAP,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(100)=(FSM=AttackNoAP,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=MoveAround,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(101)=(FSM=AttackNoAP,Ident=MoveAround,FSMSucc=false,FSMFail=false,Transitions=((Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(102)=(FSM=AttackNoAP,Ident=Wait,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(103)=(FSM=AttackNoAPAir,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=MoveAround,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(104)=(FSM=AttackNoAPAir,Ident=MoveAround,FSMSucc=false,FSMFail=false,Transitions=((Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(105)=(FSM=AttackNoAPAir,Ident=Wait,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(106)=(FSM=AttackAirAP,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=IdleEx,Cond=56,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=TakeOff,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=IdleEx,Cond=0,Func=COND_ReleaseActionPoint,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(107)=(FSM=AttackAirAP,Ident=TakeOff,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=COND_ShouldGotoActionPointFlyer,Win=1,Code=0,StateTableIndex=0),(Ident=IdleEx,Cond=0,Func=COND_ReleaseActionPoint,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(108)=(FSM=AttackAirAP,Ident=GotoGoalFocusTargetFullBody,FSMSucc=false,FSMFail=false,Transitions=((Ident=Teleport,Cond=0,Func=COND_ShouldTeleportToAP,Win=1,Code=0,StateTableIndex=0),(Ident=IdleEx,Cond=0,Func=COND_ShouldIdleInAir,Win=1,Code=0,StateTableIndex=0),(Ident=GotoLand,Cond=0,Func=COND_ShouldLand,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=COND_ShouldFlyToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=COND_ShouldGotoActionPointFlyer,Win=1,Code=0,StateTableIndex=0),(Ident=IdleEx,Cond=0,Func=COND_ReleaseActionPoint,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(109)=(FSM=AttackAirAP,Ident=IdleEx,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoLand,Cond=0,Func=COND_ShouldLand,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=COND_ShouldFlyToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=COND_ShouldGotoActionPointFlyer,Win=1,Code=0,StateTableIndex=0),(Ident=AttackNoAPAir,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(110)=(FSM=AttackAirAP,Ident=AttackNoAPAir,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=COND_ShouldGotoActionPointFlyer,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=COND_ShouldFlyToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=COND_ShouldGotoActionPointFlyer,Win=1,Code=0,StateTableIndex=0),(Ident=AttackNoAPAir,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(111)=(FSM=AttackAirAP,Ident=GotoLand,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(112)=(FSM=AttackAirAP,Ident=Teleport,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(113)=(FSM=GotoLand,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoLandSpot,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Touchdown,Cond=59,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(114)=(FSM=GotoLand,Ident=GotoLandSpot,FSMSucc=false,FSMFail=false,Transitions=((Ident=Touchdown,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(115)=(FSM=GotoLand,Ident=Touchdown,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(116)=(FSM=AttackActionPointJump,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFocusTargetFullBody,Cond=0,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(117)=(FSM=AttackActionPointJump,Ident=GotoGoalFocusTargetFullBody,FSMSucc=false,FSMFail=false,Transitions=((Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(118)=(FSM=AttackActionPointJump,Ident=JumpToActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=Teleport,Cond=0,Func=COND_ShouldTeleportToAP,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(119)=(FSM=AttackActionPointJump,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(120)=(FSM=AttackActionPointJump,Ident=Teleport,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(121)=(FSM=AttackActionPoint,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextJumpPoint,Cond=0,Func=COND_HasJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextActionPoint,Cond=0,Func=COND_HasNormalAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(122)=(FSM=AttackActionPoint,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=Teleport,Cond=0,Func=COND_ShouldTeleportToAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextJumpPoint,Cond=0,Func=COND_HasJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextActionPoint,Cond=0,Func=COND_HasNormalAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(123)=(FSM=AttackActionPoint,Ident=GotoNextJumpPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=Teleport,Cond=0,Func=COND_ShouldTeleportToAP,Win=1,Code=0,StateTableIndex=0),(Ident=AttackAirAP,Cond=0,Func=COND_ShouldJumpToAirAP,Win=1,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(124)=(FSM=AttackActionPoint,Ident=JumpToActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoNextActionPoint,Cond=0,Func=COND_ShouldGotoActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(125)=(FSM=AttackActionPoint,Ident=GotoNextActionPoint,FSMSucc=false,FSMFail=true,Transitions=((Ident=GotoNextJumpPoint,Cond=15,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_ReleaseActionPoint,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(126)=(FSM=AttackActionPoint,Ident=UseActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=Teleport,Cond=0,Func=COND_ShouldTeleportToAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextJumpPoint,Cond=0,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextActionPoint,Cond=0,Func=COND_ShouldAdvanceAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextActionPoint,Cond=0,Func=COND_ShouldFlankAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextActionPoint,Cond=0,Func=COND_ShouldLateralAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoNextActionPoint,Cond=0,Func=COND_ShouldRetreatAP,Win=1,Code=0,StateTableIndex=0),(Ident=UseActionPoint,Cond=0,Func=COND_ShouldUseActionPoint,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(127)=(FSM=AttackActionPoint,Ident=AttackAirAP,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(128)=(FSM=AttackActionPoint,Ident=Wait,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(129)=(FSM=AttackActionPoint,Ident=Teleport,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(130)=(FSM=AttackAir,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=TakeOff,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(131)=(FSM=AttackAir,Ident=TakeOff,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(132)=(FSM=AttackAir,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=Touchdown,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(133)=(FSM=AttackAir,Ident=Touchdown,FSMSucc=true,FSMFail=true,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(134)=(FSM=AttackWeapon,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(135)=(FSM=AttackWeapon,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(136)=(FSM=AttackWeapon,Ident=GotoAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackCloak,Cond=0,Func=COND_ShouldCloakAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(137)=(FSM=AttackWeapon,Ident=MoveAround,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackCloak,Cond=0,Func=COND_ShouldCloakAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(138)=(FSM=AttackWeapon,Ident=AttackCloak,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(139)=(FSM=AttackWeapon,Ident=GotoSearch,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=1,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(140)=(FSM=AttackWeapon,Ident=EngageWait,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoAttack,Cond=0,Func=COND_ShouldGotoAttack,Win=0,Code=0,StateTableIndex=0),(Ident=GotoSearch,Cond=0,Func=COND_ShouldGotoSearch,Win=0,Code=0,StateTableIndex=0),(Ident=MoveAround,Cond=0,Func=COND_ShouldMoveAround,Win=0,Code=0,StateTableIndex=0),(Ident=EngageWait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(141)=(FSM=UseActionPoint,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=PopUp,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(142)=(FSM=UseActionPoint,Ident=PopUp,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(143)=(FSM=GotoNextActionPoint,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoActionPoint,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(144)=(FSM=GotoNextActionPoint,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoActionPoint,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(145)=(FSM=GotoNextActionPoint,Ident=GotoActionPoint,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(146)=(FSM=GotoNextJumpPoint,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoJumpPoint,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(147)=(FSM=GotoNextJumpPoint,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoJumpPoint,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(148)=(FSM=GotoNextJumpPoint,Ident=GotoJumpPoint,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(149)=(FSM=AttackGround,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=StandCombat,Cond=33,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=1,Code=0,StateTableIndex=0),(Ident=AttackWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(150)=(FSM=AttackGround,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=1,Code=0,StateTableIndex=0),(Ident=AttackWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(151)=(FSM=AttackGround,Ident=AttackMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackWeapon,Cond=0,Func=COND_ShouldEndMelee,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(152)=(FSM=AttackGround,Ident=AttackWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(153)=(FSM=AttackShrunk,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=SeekShrunkTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(154)=(FSM=AttackShrunk,Ident=StandCombat,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=SeekShrunkTarget,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(155)=(FSM=AttackShrunk,Ident=ResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=SeekShrunkTarget,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(156)=(FSM=AttackShrunk,Ident=GotoMeleeSlow,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=COND_ShouldAbortGotoStomp,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=96,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=SeekShrunkTarget,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=3,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(157)=(FSM=AttackShrunk,Ident=AttackShrunkTargetLost,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=96,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(158)=(FSM=AttackShrunk,Ident=Stomp,FSMSucc=false,FSMFail=false,Transitions=((Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=SeekShrunkTarget,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(159)=(FSM=AttackShrunk,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=96,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=SeekShrunkTarget,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(160)=(FSM=AttackShrunk,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=96,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Stomp,Cond=101,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandCombat,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMeleeSlow,Cond=0,Func=COND_ShouldGotoStomp,Win=1,Code=0,StateTableIndex=0),(Ident=SeekShrunkTarget,Cond=0,Func=COND_ShouldGotoStompLostTarget,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(161)=(FSM=AttackShrunk,Ident=SeekShrunkTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoMeleeSlow,Cond=3,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Crouch,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(162)=(FSM=AttackShrunk,Ident=Crouch,FSMSucc=false,FSMFail=false,Transitions=((Ident=CrouchingResumeFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(163)=(FSM=AttackShrunk,Ident=CrouchingResumeFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=CrouchingIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(164)=(FSM=AttackShrunk,Ident=CrouchingIdle,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=48,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=CrouchingIdle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(165)=(FSM=AvoidTarget,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandScared,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoAvoidGoal,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(166)=(FSM=AvoidTarget,Ident=HoldFire,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=COND_ShouldNotAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Touchdown,Cond=56,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandScared,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(167)=(FSM=AvoidTarget,Ident=Touchdown,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=COND_ShouldNotAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=HoldFire,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StandScared,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(168)=(FSM=AvoidTarget,Ident=StandScared,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=COND_ShouldNotAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoAvoidGoal,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(169)=(FSM=AvoidTarget,Ident=GotoGoalFacePos,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=COND_ShouldNotAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=COND_SafeFromBiggerEnemy,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoAvoidGoal,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(170)=(FSM=AvoidTarget,Ident=Cower,FSMSucc=false,FSMFail=false,Transitions=((Ident=StandCombat,Cond=0,Func=COND_ShouldNotAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_NotSafeFromBigEnemy,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(171)=(FSM=AvoidTarget,Ident=StandCombat,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(172)=(FSM=Cower,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(173)=(FSM=Cower,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(174)=(FSM=Cower,Ident=idle,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    HasLookTargetEvaluator=true
    LookTargetEvalInfo=(MyOwner=none,EvalInterval=2,Suspended=false,bSuspendedWithNoTarget=false,Evaluator=2,ForceUpdate=false,MustBePawn=true,MustBeSighted=false,MustBeReachable=false,CanTargetProjectiles=false,CanAvoidTargetableProjectiles=false,LastTarget=none,LastTargetEndTime=0)
    HeadTrackRate=160
    WeaponConfig='WeaponCfg_AssaultTrooperGrunt'
    Weapons(0)=none
    Weapons(1)='dnGame.IntegratedWeapon'
    ForceWeaponActive=true
    WpnSteadyHorizError=768
    WpnSteadyVertError=768
    WpnMovingHorizError=768
    WpnMovingVertError=768
    ForceDirectShot=true
    MinTargetVisibleTime=0
    Popups(0)=(Entrys=(PopUpCfg_Left'AssaultTrooper_Captain.AssPopUpCfg_Left',PopUpCfg_LeftBlindFire'AssaultTrooper_Captain.AssPopUpCfg_LeftBlindFire'),PrimaryChoices=1,IdealAngle=-30)
    Popups(1)=(Entrys=(PopUpCfg_Right'AssaultTrooper_Captain.AssPopUpCfg_Right',PopUpCfg_LeftBlindFire'AssaultTrooper_Captain.AssPopUpCfg_RightBlindFire'),PrimaryChoices=1,IdealAngle=30)
    Popups(2)=(Entrys=(PopUpCfg_CrouchUp'AssaultTrooper_Captain.AssPopUpCfg_CrouchUp',PopUpCfg_CrouchUpBlindFire'AssaultTrooper_Captain.AssPopUpCfg_CrouchUpBlindFire'),PrimaryChoices=1,IdealAngle=0)
    Popups(3)=(Entrys=(PopUpCfg_CrouchLeft'AssaultTrooper_Captain.AssPopUpCfg_CrouchLeft',PopUpCfg_CrouchLeftBlindFire'AssaultTrooper_Captain.AssPopUpCfg_CrouchLeftBlindFire'),PrimaryChoices=1,IdealAngle=-30)
    Popups(4)=(Entrys=(PopUpCfg_CrouchRight'AssaultTrooper_Captain.AssPopUpCfg_CrouchRight',PopUpCfg_CrouchRightBlindFire'AssaultTrooper_Captain.AssPopUpCfg_CrouchRightBlindFire'),PrimaryChoices=1,IdealAngle=30)
    Popups(5)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(6)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(7)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(8)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(9)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(10)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(11)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(12)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(13)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(14)=(Entrys=(PopUpCfg_StandFire'AssaultTrooper_Captain.AssPopUpCfg_StandFire'),PrimaryChoices=0,IdealAngle=0)
    Popups(15)=(Entrys=(PopUpCfg_CrouchFire'AssaultTrooper_Captain.AssPopUpCfg_CrouchFire'),PrimaryChoices=0,IdealAngle=0)
    Popups(16)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    Popups(17)=(Entrys=none,PrimaryChoices=0,IdealAngle=0)
    bNoWeaponChargePopUp=true
    UseActionPoints=true
    ChanceStayAtActionPoint=0.6
    RollLeftInfo=(X=0,Y=-152.85,Z=0)
    RollRightInfo=(X=0,Y=99.758,Z=0)
    TKShieldCollisionRadius=300
    PickupItemRange=4
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    AutoRollRate=5
    AutoUnrollRate=2
    BodyAlignRate=5.5
    BodyAlignRateFlying=5.5
    BodyAlignScale=0.8
    JumpPreset=(JumpVel=(X=0,Y=0,Z=0),HeavyLandingThresh=0,FocusActor=none,GravityScale=0,JumpTime=0,FlyToTarget=false,TargetPos=(X=0,Y=0,Z=0),JumpType=0,bSnapToTarget=false,bUseAccelaration=false,DefGravityScale=0.25,bFaceTarget=false)
    IdleInfo(0)=(MinIdleTime=1.5,RndIdleTime=0.5,bFaceTarget=true,AnimName=Anim_Idle)
    InitialAnimController=5
    AnimControllers[0]=(m_eFallback=0,m_cClass='acAssaultTrooper',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acAssaultTrooper_Crouch',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acAssaultTrooper',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acAssaultTrooper',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acAssaultTrooper_Combat',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acAssaultTrooper',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acAssaultTrooper',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acAssaultTrooper_JetPack',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acAssaultTrooper_Scared',m_oController=none)
    AnimControllers[9]=(m_eFallback=1,m_cClass='acAssaultTrooper_Blind',m_oController=none)
    GotoXParms=(TargetType=0,TargetActor=none,TargetPos=(X=0,Y=0,Z=0),RefActor=none,NextPos=(X=0,Y=0,Z=0),FinalDest=0,OffsetType=0,Range=0,Bearing=0,Height=0,ClipTolerance=0,Speed=0,SpeedScale=0,Focus=0,FocusActor=none,FacePos=(X=0,Y=0,Z=0),RefId=0,Mode=0,SideArcTurnSpeedThresh=0,StepBackwardsSpeedThresh=0,StartAngleSideSector=0,StartAngleBackSector=0,MoveBackwardsDistThresh=0,SideStepDistThresh=0,MaxSteps=0,PreVerified=false,TurnDir=0,MyDoorEx=none,ForceEval=false,ForceAnim=false,StuckTime=0,bStopToTurn=false,EvalCount=0,bDisableEvalGate=false,ConstraintStrengthOverride=0,PathFailMode=0,bWaitingOnDynamicBlocker=false,bWaitTime=0,TargetExtent=(X=0,Y=0,Z=0),bDebug=false,FlyConstraintStrength=0.5,bUseAccelerationWhenFlying=true,ExitOnLand=false,ExitOnLandHeight=50,UseAnimDispDirMod=2)
    FreeMoveParms=(Mode=0,MinDotToTarget=0,MaxDotToTarget=0,ExitTime=0,FreeMoveTarget=(X=0,Y=0,Z=0),FreeMoveVelocity=50,FreeMoveMaxVelocity=0,StoppingRate=50,StoppingRestitution=25,startLocation=(X=0,Y=0,Z=0))
    HaywireParms=(bAllowHaywire=true,MinTime=0,MaxTime=0,LinearAccel=(X=0,Y=0,Z=0),AngularAccel=(X=0,Y=0,Z=0),HaywireStartTime=0,MinTimeToExplode=0.4,ChanceExplosion=1,HurtRadiusDamage=40,DamageRadius=150,DamageRadiusFallOffStart=36,ExplosionClass='p_Weapons.Rpg_Explosion.RPG_Explosion_Spawner',ExplosionLight=none,ExplosionSoundName=Sound_JetpackHaywireExplosion,HitNormal=(X=0,Y=0,Z=0))
    JumpParms=(Mode=0,JumpVel=(X=0,Y=0,Z=0),HeavyLandingThresh=0,AppliedJumpVel=false,StartZ=0,RefId=0,AnimSet=0,FrameVelocity=(X=0,Y=0,Z=0),bDisableIK=true,bRestoreIKPreLand=true,ExitTime=0,JumpType=0,FaceTarget=false,FocusActor=none,AutoPitch=false,PitchRate=0,PitchRateLand=0,MaxPitch=0,MaxVelocity=0,bDebug=false,bTakeOffNoLand=false,TakeOffIdleTime=0,FlyingGravityScale=0,TargetPos=(X=0,Y=0,Z=0),bCheckTargetPos=false,bUseAccelaration=false,AccelerationScale=3,Fudge=(X=0,Y=0,Z=0),bSnapToTargetDuringLand=false,bRequireCompleteSnap=false,bSnapActive=false,bLandAnimComplete=false,StopLinearDamping=3.5,bAllowProcFireDuringFall=true)
    TakeOffParms=(TakeOffVel=(X=0,Y=0,Z=0),TakeOffIdleTime=0,TakeOffIdleTimeRnd=0,GravityScale=0.25,IdealTakeOffHeight=200,IdealTakeOffVel=(X=0,Y=0,Z=500),AllowFire=true,TakeOffTarget=(X=0,Y=0,Z=0))
    HoverParms=(MinHoverTime=2.5,RndHoverTime=1)
    PhysicsParms=(bDebug=false,AccelRateEx=400,SlowAccelRateEx=0.1,AirControlEx=1,SlowSpeedScale=5,VertAccelRateEx=6,bDisableGroundFinder=false,MaxSpeed=400,MaxSpeedDamping=1.5,MaxSpeedOtherDir=75,MaxSpeedOtherDirDamping=4.5,bDisablePhysicsConstraints=false)
    TeleportParms=(Destination=(X=0,Y=0,Z=0),DestinationRotation=(Pitch=0,Yaw=0,Roll=0),StartParticleSystem='p_Creatures.Teleport.Teleport_Spawner',EndParticleSystem='p_Creatures.Teleport.Teleport_Spawner',StartLight=none,EndLight=none,StartSound=TeleportStart,EndSound=TeleportEnd,EndActionPoint=none,StartAnimName=Anim_TeleportStart,EndAnimName=Anim_TeleportEnd,StartOverlay='dt_Effects2.Caustic.Caustic_FB',bFaceTarget=true,bValid=false,Mode=0,MinTeleportDist=250,MaxTeleportDist=1200,Delay=3,bCantDie=true,bForceLandOnFinish=false,bForceJetpackOnFinish=false,bSkipStartEffects=false)
    RappelParms=(StartAnimName=Anim_RappelStart,IdleAnimName=Anim_RappelIdle,EndAnimName=Anim_RappelEnd,BoneName=mount_carryitem,GravityScale=0,bOverrideAttachToInfo=false,AttachToActor=none,AttachToBone=None,BeamSystemClass='AIRappelBeamSystem',MyBeamSystem=none,Mode=0)
    DeathAnimChance=0.2
    FaceDamage=false
    FaceDeath=false
    MinPainOpInterval=0.2
    RndPainOpInterval=0
    MaxConsecutivePainOp=5
    PainImpulseMagnitude=250
    PainImpulseMinDamage=5
    BoneAim(0)=(BoneName=Spine,Yaw=0,Pitch=0,Weight=0.3)
    BoneAim(1)=(BoneName=Spine1,Yaw=0,Pitch=0,Weight=0.3)
    BoneAim(2)=(BoneName=spine2,Yaw=0,Pitch=0,Weight=0.4)
    HasBoneAimer=true
    DisableAimGrids=true
    ProceduralMovingFire=true
    ProcFireStates(0)=GotoX
    ProcFireStates(1)=Jump
    ProcFireOps(0)=85
    ProcFireOps(1)=86
    ProcFireOps(2)=100
    ProcFireOps(3)=102
    BoneHeadAim(0)=(BoneName=neck,Yaw=0,Pitch=0,Weight=1)
    HasBoneHeadAimer=true
    HasWeaponAimer=true
    HasHeadAimer=true
    MinIdleTime=0.3
    RndIdleTime=0.1
    ShouldTurnThreshold=28
    FaceThreshold=1
    GotoPosFlyingRange=40
    MinMoveAroundDist=50
    RndMoveAroundDist=100
    MinMeleeRange=25
    RndMeleeRange=5
    MinMeleeStrafeRange=30
    RndMeleeStrafeRange=0
    MinMeleeStrafeCycles=1
    RndMeleeStrafeCycles=1
    MeleeFaceTarget=true
    ClawDamageAmount=35
    StompInfo(0)=(StompRadius=30,AnimName=Anim_StompLeft,BoneName=leftfoot,StompDamageAmount=50,StompDamageRadius=40,StompDamageVel=200,StompDamageLift=350,bDebug=false,SafeHeight=20,bCanStompShrunk=false,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=AssTroopStompShake),ShakeRadius=600,ParticleEffectClass='p_Impacts.StompImpact.StompImpact_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=false,bLightRumbleOnDamage=false)
    StompInfo(1)=(StompRadius=30,AnimName=Anim_StompRight,BoneName=rightfoot,StompDamageAmount=50,StompDamageRadius=40,StompDamageVel=200,StompDamageLift=350,bDebug=false,SafeHeight=20,bCanStompShrunk=false,ShakeInfo=(bNoLerp=false,bToggleSign=true,Style=2,Function=1,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.6,ShakeFrequency=0.08,ShakeMagnitude=2500,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=AssTroopStompShake),ShakeRadius=600,ParticleEffectClass='p_Impacts.StompImpact.StompImpact_Spawner',AdditionalEffectBones=none,StompLocation=(X=0,Y=0,Z=0),bDontFaceTarget=false,bLightRumbleOnDamage=false)
    ToeStubInfo=(bDebug=false,bEnabled=true,AnimName=Anim_Stubfoot,bBerzerkAfterStub=false,bDropWeapon=false,MinImpactVelocity=75,MinToeStubInterval=7,ToeStubGate=0)
    bPlayerShrunkSpecialFootstep=true
    ProjectileClass='dnGame.dnRocket_AssaultTrooper_Laser_Captain'
    MinAirAttackHeight=100
    MaxAirAttackHeight=400
    CanJump=true
    HasStartFallAnim=true
    ChanceLand=0.5
    AvoidDangers=true
    RndMoveAroundTime=1
    HaywireMinDuration=0
    HaywireMaxDuration=5
    HaywireLinearAccel=(X=1500,Y=0,Z=100)
    HaywireLinearAccelVar=(X=300,Y=0,Z=100)
    HaywireAngularAccelVar=(X=50,Y=50,Z=50)
    PathID=AIPATH_Medium
    ActionPointJumpType=AssTroopJetpack
    bAutoOpenDoors=true
    DynamicPathingPriority=4
    ChanceFly=0.8
    PickupOverride='dnGame.ATCaptainLaserPickup'
    PickupKImpulseMagnitude=100
    ConfirmKillDialog=6
    FootstepCategory=7
    FootprintType=0
    PawnRotationRate=(Pitch=32768,Yaw=40000,Roll=0)
    FluidFrictionScale=0.5
    EyeBone=Head
    BodyBone=Spine
    LockOnBone=Spine
    CustomKillSoundName=GotKillCaptain
    CustomKillSoundChance=0.1
    PickupMountBone=mount_carryitem_l
    CorpseType='AlienCorpse'
    ExpandingBoneName=neck
    GroundSpeed=280
    AirSpeed=500
    FootBones(0)=(bRightSide=false,BoneName=LeftToeBase,BoneID=foot_left_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(1)=(bRightSide=true,BoneName=RightToeBase,BoneID=foot_right_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    ExitWoundInfo(0)=(DamageType=none,MinimumDamage=1,RandomChance=1,ExitWoundDecalClass='dnGame.dnExitWound_Human')
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='AssaultTrooper_Captain_Armor_Helmet',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Helmet,ForceEvent=None,MountMeshItem=mount_armor_3,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='AssaultTrooper_Captain_Armor_LeftForeArm',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftForeArm,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=1335,Yaw=17553,Roll=23902),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='AssaultTrooper_Captain_Armor_LeftShin',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=LeftLeg,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-1720,Yaw=-29790,Roll=32265),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='AssaultTrooper_Captain_Armor_LeftThigh',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_5,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='AssaultTrooper_Captain_Armor_LeftShoulderTop',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_9,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='AssaultTrooper_Captain_Armor_RightShin',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=RightLeg,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=1722,Yaw=31834,Roll=499),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(6)=(bSkipVerifySelf=false,SpawnClass='AssaultTrooper_Captain_Armor_RightThigh',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_4,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(7)=(bSkipVerifySelf=false,SpawnClass='AssaultTrooper_Captain_Armor_RightShoulderTop',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=true,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_armor_2,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    Health=75
    HealthCap=75
    bSpawnOnDestroyed=false
    SpawnOnDestroyedSimple(0)='p_Creatures.AssaultTrooper_JetPackFX.AssaultTrooper_JetPackFX_Explosion_Spawner2'
    bIsAssaultTrooper=true
    bHasEvalBonesHelper=true
    bCanExistOutOfWorld=false
    CollisionRadius=28
    CollisionHeight=44
    AccelRate=1200
    Mesh='c_characters.AssaultTrooper_Captain'
    ActorColorList(0)=(ActorColor=(R=150,G=0,B=0,A=0),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic0)
    ActorColorList(1)=(ActorColor=(R=150,G=0,B=0,A=0),ActorColor_LightEx=none,ActorColor_LightExScale=(X=0,Y=0,Z=0),id=Generic1)
    VoicePack='SoundConfig.Enemies.VoicePack_AssaultTrooper'
}