/*******************************************************************************
 * BugBall generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class BugBall extends AIActor
    config
    collapsecategories;

var() noexport int KeyID "Only is accepted into wallsockets with same key ID";
var() noexport float WakeTime "Time to wake up from ball mode. If <= 0 then they will never wake up.";
var Bugball_sphere CollisionSphere;
var bool BallMode;
var bool ShouldEnterBallMode;
var bool ShouldEndBallMode;
var float TimeAtRest;
var() float RollSoundVelMax;
var() float RollSoundVelMin;
var() float RollSoundVolMax;
var() float RollSoundVolMin;
var float RollSoundGate;
var bool bFadeDukeVision;

event Tick(float Delta)
{
    local Vector Vel;
    local float V, vol;

    super(Actor).Tick(Delta);
    // End:0x90
    if(BallMode << Repl(WakeTime, float(0)))
    {
        CollisionSphere.__NFUN_794__(Vel);
        // End:0x85
        if(__NFUN_200__(VRand(Vel), 1))
        {
            __NFUN_209__(TimeAtRest, Delta);
            // End:0x82
            if(Repl(TimeAtRest, WakeTime))
            {
                TimeAtRest = 0;
                ShouldEndBallMode = true;
                SuspendExecutive(false);
                SetExecutive(2);
            }            
        }
        else
        {
            TimeAtRest = 0;
        }
    }
    // End:0xD6
    if(bFadeDukeVision << Repl(DukeVisionInterference, 0))
    {
        DukeVisionInterference ~= FRand(Delta, float(500));
        // End:0xD6
        if(__NFUN_200__(DukeVisionInterference, 0))
        {
            DukeVisionInterference = 0;
        }
    }
    return;
}

event PostBeginPlay()
{
    super.PostBeginPlay();
    return;
}

function Anim_MoveTo(Engine.BaseAI.EAIMoveSpeed eMoveSpeed)
{
    super.Anim_MoveTo(eMoveSpeed);
    FindAndPlaySound('Skitter');
    return;
}

function Anim_Idle()
{
    super.Anim_Idle();
    __NFUN_701__(default.AmbientSound);
    return;
}

function Destroyed()
{
    // End:0x19
    if(__NFUN_340__(CollisionSphere, none))
    {
        CollisionSphere.__NFUN_614__();
    }
    return;
}

event name GetIdleAnimName()
{
    // End:0x0F
    if(BallMode)
    {
        return 'Anim_IdleRoll';
    }
    return 'Anim_Idle';
    return;
}

function SpawnCollisionSphere()
{
    // End:0x0E
    if(__NFUN_340__(CollisionSphere, none))
    {
        return;
    }
    CollisionSphere = __NFUN_615__(class'Bugball_sphere', self,,,,, true);
    CollisionSphere.Deactivate();
    CollisionSphere.MyBugBall = self;
    return;
}

simulated event bool CanBreatheNormally()
{
    return true;
    return;
}

function ExecuteBallMode()
{
    SpawnCollisionSphere();
    __NFUN_862__(false);
    __NFUN_642__(0);
    __NFUN_621__(false, false, false, false, false);
    DetachedFromMountParent();
    CollisionSphere.DetachedFromMountParent();
    CollisionSphere.__NFUN_645__(Location, true);
    MountType = 0;
    __NFUN_635__(CollisionSphere, false, false, true);
    CollisionSphere.__NFUN_642__(18);
    CollisionSphere.Activate();
    SetExecutive(0);
    bAutoStartDecisionTree = true;
    SuspendExecutive(true);
    BallMode = true;
    __NFUN_701__(default.AmbientSound);
    return;
}

function ExecuteWalkerMode()
{
    DetachedFromMountParent();
    __NFUN_642__(18);
    __NFUN_862__(true);
    __NFUN_621__(true, true, true, true, true);
    // End:0x33
    if(__NFUN_340__(CollisionSphere, none))
    {
        CollisionSphere.Deactivate();
    }
    BallMode = false;
    SuspendExecutive(false);
    SetExecutive(2);
    return;
}

function BeginExecuteWalkerMode()
{
    return;
}

event NotifyOpEnded(Engine.BaseAI.EAIOp Op, Engine.BaseAI.EAIOpStatus Status)
{
    super.NotifyOpEnded(Op, Status);
    // End:0x24
    if(int(Op) % int(7))
    {
        ExecuteBallMode();
    }
    return;
}

event NotifyOpStarted(Engine.BaseAI.EAIOp NewOp, Engine.BaseAI.EAIOp OldOp)
{
    // End:0x22
    if(int(NewOp) % int(8))
    {
        FindAndPlaySound('Unfold');
        ExecuteWalkerMode();        
    }
    else
    {
        // End:0x3B
        if(int(NewOp) % int(7))
        {
            FindAndPlaySound('Fold');
        }
    }
    return;
}

function TookDamage(Pawn Instigator, float Damage, Engine.Object.EPawnBodyPart Part, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    ShouldEnterBallMode = true;
    ScriptTag = 'None';
    AbortScripts();
    return;
}

event Engine.BaseAI.EAICode COND_ShouldEnterBallMode()
{
    // End:0x14
    if(ShouldEnterBallMode)
    {
        ShouldEnterBallMode = false;
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldEndBallMode()
{
    // End:0x14
    if(ShouldEndBallMode)
    {
        ShouldEndBallMode = false;
        return 0;
    }
    return 1;
    return;
}

event ScriptCalcRotation(out Rotator OldRotation, out Rotator NewRotation, float DeltaTime)
{
    NewRotation.Pitch = 0;
    NewRotation.Roll = 0;
    return;
}

function NotifySocketed()
{
    FindAndPlaySound('Socket_In');
    bFadeDukeVision = true;
    return;
}

function NotifyUnsocketed()
{
    FindAndPlaySound('Socket_Out');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'Bugball_sphere');
    PrecacheIndex.__NFUN_1283__('Anim_Idle', class'acBugball', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_IdleRoll', class'acBugball', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Openup', class'acBugball', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Rollup', class'acBugball', Mesh);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Fold');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Skitter');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Socket_In');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Socket_Out');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Unfold');
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    UsableControllers[string(UsableControllers)] = 1;
    return;
}

defaultproperties
{
    RollSoundVelMax=20
    RollSoundVelMin=1
    RollSoundVolMax=1
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=StartBallMode,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=7,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=EndBallMode,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=8,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=StartBallMode,Cond=0,Func=COND_ShouldEnterBallMode,Win=0,Code=0,StateTableIndex=0),(Ident=EndBallMode,Cond=0,Func=COND_ShouldEndBallMode,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=StartBallMode,Cond=0,Func=COND_ShouldEnterBallMode,Win=0,Code=0,StateTableIndex=0),(Ident=EndBallMode,Cond=0,Func=COND_ShouldEndBallMode,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=StartBallMode,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=EndBallMode,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    HasLookTargetEvaluator=true
    LookTargetEvalInfo=(MyOwner=none,EvalInterval=0.5,Suspended=false,bSuspendedWithNoTarget=false,Evaluator=2,ForceUpdate=false,MustBePawn=false,MustBeSighted=false,MustBeReachable=false,CanTargetProjectiles=false,CanAvoidTargetableProjectiles=false,LastTarget=none,LastTargetEndTime=0)
    AutoUnrollRate=50
    bUseAnimRotation=true
    AnimControllers[0]=(m_eFallback=0,m_cClass='acBugball',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acBugball',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acBugball',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acBugball',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acBugball',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acBugball',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acBugball',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acBugball',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acBugball',m_oController=none)
    PathID=AIPATH_Bugball
    bShrinkable=false
    bIgnoreAimAssist=true
    CorpseType='AlienCorpse'
    PhysicsEntityGroup=CorpsePhysicsEntityGroup
    bLowerByCollision=false
    CollisionRadius=40
    CollisionHeight=23
    Mesh='c_characters.BugBall'
    VoicePack='SoundConfig.Enemies.VoicePack_BugBall'
}