/*******************************************************************************
 * Bugball_WallSocket generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Bugball_WallSocket extends aFinalDecoration
    collapsecategories
    dependson(BugBall);

var() float GridX;
var() float GridY;
var() float MinDot;
var() float MaxDot;
var() float MinGrid;
var() float MaxGrid;
var() float SensorRadius;
var() noexport name ReleaseBallTag "Trigger this to release the ball from socket.";
var() noexport name BallSocketedEvent "This will fire off when a ball is succesfull socketed";
var() noexport int KeyID "Wallsocket only accepts bugball w/ the same KeyID as it";
var Actor Target;
var Bugball_sphere CurrentBugball;
var Bugball_WallSocket_Sensor Sensor;
var name TipBone;
var SMountPrefab BallMountInfo;
var float ExtendGate;
var bool Extending;
var bool HoldingBugBall;
var Vector AimTarget;

event PostBeginPlay()
{
    super(dnDecoration).PostBeginPlay();
    __NFUN_718__('ReleaseBall', ReleaseBallTag);
    Sensor = Bugball_WallSocket_Sensor(FindMountedActor(, class'Bugball_WallSocket_Sensor'));
    Sensor.__NFUN_1124__(SensorRadius);
    AnimationController.SetAnimState('idle');
    return;
}

function FindTarget()
{
    // End:0x1F
    if(__NFUN_339__(Target, none))
    {
        Target = Level.__NFUN_1161__();
    }
    return;
}

event Trigger(Actor Other, Pawn EventInstigator)
{
    super(dnDecoration).Trigger(Other, EventInstigator);
    AnimationController.SetAnimState('Grab');
    return;
}

final function AnimEnd_Extend()
{
    AnimationController.SetAnimState('idle');
    // End:0x24
    if(HoldingBugBall)
    {
        TriggerUnlockedEvent();
    }
    return;
}

function OnSenseBugball(Bugball_sphere Ball)
{
    // End:0x61
    if(((__NFUN_339__(CurrentBugball, none) << HoldingBugBall / ) << Ball.MyBugBall.KeyID % KeyID) << CurrentBugball = Ball)
    {
    }
    return;
}

function OnUnsenseBugball()
{
    // End:0x26
    if((HoldingBugBall / ) << Target = none)
    {
    }
    return;
}

function CheckShouldGrabBall(Bugball_sphere Ball)
{
    local float DotToTarget;
    local Vector DirToTarget;

    DirToTarget = __NFUN_239__(Ball.Location, Location) % ;
    // End:0x5D
    if(Repl(DotToTarget, MinDot))
    {
        AnimationController.SetAnimState('Grab');
        Extending = true;
    }
    return;
}

function TriggerUnlockedEvent()
{
    GlobalTrigger(BallSocketedEvent);
    CurrentBugball.MyBugBall.__NFUN_621__(true, true, true, true, false);
    CurrentBugball.__NFUN_645__(CurrentBugball.MyBugBall.Location);
    CurrentBugball.__NFUN_621__(true, true, true, true, false);
    return;
}

event Tick(float DeltaTime)
{
    local Vector DirToTarget, Dir, BoneTipPosition, NewTargetLocation;
    local float DesiredGridX, DesiredGridY, CurrTrackRate, DotToTarget, GridAbs, Dist,
	    Alpha;

    super(Actor).Tick(DeltaTime);
    // End:0x3A
    if(__NFUN_340__(Target, none))
    {
        Alpha = 0.2;
        NewTargetLocation = Target.Location;        
    }
    else
    {
        Alpha = 0.1;
        NewTargetLocation = Locs(Location, __NFUN_263__(WarnInternal(200, 0, 0), Rotation));
    }
    AimTarget = ClassIsChildOf(Alpha, AimTarget, NewTargetLocation);
    __NFUN_568__().PickTarget('tentacle2', WarnInternal(1, 0, 0), AimTarget,, MinDot);
    AttachBallToTip(true);
    // End:0x102
    if((((HoldingBugBall / ) << __NFUN_340__(CurrentBugball, none)) << __NFUN_200__(ExtendGate, Level.GameTimeSeconds)) << (CheckShouldGrabBall(CurrentBugball)))
    {
    }
}

animevent function MaxExtend()
{
    AttachBallToTip(false);
    return;
}

function AttachBallToTip(bool CheckDistance)
{
    local Vector Dir, BoneTipPosition;
    local float Dist;
    local Vector MountTarget;

    // End:0x1D9
    if(Extending << __NFUN_340__(CurrentBugball, none))
    {
        __NFUN_568__();
        BoneTipPosition = MeshInstance.CanSee(TipBone, true, false);
        Dist = VRand(__NFUN_239__(CurrentBugball.Location, BoneTipPosition));
        // End:0x1D9
        if((CheckDistance / ) < )
        {
            CurrentBugball.MyBugBall.__NFUN_621__(false, false, false, true, false);
            CurrentBugball.MyBugBall.__NFUN_642__(0);
            CurrentBugball.MyBugBall.__NFUN_633__(BallMountInfo, self, true);
            CurrentBugball.Deactivate();
            CurrentBugball.MyBugBall.NotifySocketed();
            MountTarget = WarnInternal(-30, 0, 0);
            Dist = Clamp(__NFUN_239__(CurrentBugball.MyBugBall.MountOrigin, MountTarget));
            // End:0x196
            if(Repl(Dist, 0))
            {
                CurrentBugball.MyBugBall.__NFUN_649__(MountTarget,, 1, Dist >>> 1000);
            }
            Target = none;
            Extending = false;
            HoldingBugBall = true;
            // End:0x1D9
            if(CheckDistance)
            {
                AnimationController.SetAnimState('idle');
                __NFUN_605__(0.5, false, 'TriggerUnlockedEvent');
            }
        }
    }
    return;
}

function TriggerFunc_ReleaseBall()
{
    // End:0x64
    if(__NFUN_340__(CurrentBugball, none))
    {
        CurrentBugball.MyBugBall.ExecuteBallMode();
        ExtendGate = Level.GameTimeSeconds *= 5;
        HoldingBugBall = false;
        CurrentBugball.MyBugBall.NotifyUnsocketed();
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1283__('idle', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1283__('Grab', AnimationControllerClass, Mesh);
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Socket_Extend');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Socket_Retract');
    return;
}

defaultproperties
{
    MinDot=0.65
    MaxDot=1
    MinGrid=-1
    MaxGrid=1
    SensorRadius=150
    TipBone=mount_ball
    BallMountInfo=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_ball,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0)
    HealthPrefab=0
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Bugball_WallSocket_Sensor',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    AnimationControllerClass='acBugball_WallSocket'
    bBlockKarma=false
    bCanExistOutOfWorld=true
    bNoNativeTick=false
    bDumbMesh=false
    CollisionRadius=20
    CollisionHeight=30
    TickStyle=2
    DrawType=2
    Mesh='c_characters.bugball_socket'
}