/*******************************************************************************
 * CycloidCorpse generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class CycloidCorpse extends AlienCorpseFullCollision;

var() Actor FieldGoalAlignmentActor;
var() float FadeToBlackDelay;
var() float FadeToBlackTime;
var() float FadeFromBlackTime;
var name HumiliationStartEvent;
var name HumiliationCompleteEvent;
var dnControl HumiliationControl;
var SMountedActorPrefab PissSplashPrefab;
var SoftParticleSystem PissSplash;

function bool CreateRagdollCorpse(InteractiveActor aOther)
{
    local cycloid C;
    local class<dnControl> HumiliationControlClass;

    super(CorpseBase).CreateRagdollCorpse(aOther);
    bUsable = true;
    bDoOverlayEffect = true;
    FadeOverlayEffect(1, 0);
    __NFUN_620__(default.CollisionRadius, default.CollisionHeight);
    bNoNativeTick = false;
    bDumbMesh = false;
    C = cycloid(aOther);
    // End:0xE9
    if(__NFUN_340__(C, none))
    {
        HumiliationControlClass = C.HumiliationClass;
        FieldGoalAlignmentActor = C.FieldGoalAlignmentActor;
        HumiliationStartEvent = C.HumiliationStartEvent;
        HumiliationCompleteEvent = C.HumiliationCompleteEvent;
        // End:0xE9
        if(Repl(C.HumiliationTimeout, 0))
        {
            __NFUN_607__(C.HumiliationTimeout, false, 'HumiliationTimeout');
        }
    }
    // End:0x179
    if(__NFUN_340__(HumiliationControlClass, none))
    {
        HumiliationControl = __NFUN_615__(HumiliationControlClass, self,, Location, Rotation,, true);
        // End:0x179
        if(__NFUN_340__(HumiliationControl, none))
        {
            HumiliationControl.MountOrigin = WarnInternal(0, 0, 0);
            HumiliationControl.MountAngles = __NFUN_265__(0, 0, 0);
            HumiliationControl.MountType = 0;
            HumiliationControl.__NFUN_635__(self, false, false, false, false, false);
        }
    }
    return;
}

simulated event PreGameInit()
{
    super(CorpseBase).PreGameInit();
    return;
}

function MakeRagdoll()
{
    return;
}

simulated event Tick(float DeltaTime)
{
    super(CorpseBase).Tick(DeltaTime);
    bNoNativeTick = false;
    return;
}

simulated event bool ShouldDrawHUDInfoUsePhrase(Pawn TestPawn)
{
    // End:0x22
    if(__NFUN_340__(HumiliationControl, none))
    {
        return HumiliationControl.ShouldDrawHUDInfoUsePhrase(TestPawn);
    }
    return super(InteractiveActor).ShouldDrawHUDInfoUsePhrase(TestPawn);
    return;
}

simulated event string GetUsePhrase()
{
    // End:0x1D
    if(__NFUN_340__(HumiliationControl, none))
    {
        return HumiliationControl.GetUsePhrase();
    }
    return super(InteractiveActor).GetUsePhrase();
    return;
}

simulated function bool CanBeUsedBy(Pawn TestPawn)
{
    // End:0x22
    if(__NFUN_340__(HumiliationControl, none))
    {
        return HumiliationControl.CanBeUsedBy(TestPawn);
    }
    return super(InteractiveActor).CanBeUsedBy(TestPawn);
    return;
}

final simulated function DisableUsability()
{
    bUsable = false;
    FadeOverlayEffect(0, 1);
    return;
}

final simulated function HumiliationTimeout()
{
    DisableUsability();
    HumiliationControl.__NFUN_614__();
    GlobalTrigger(HumiliationCompleteEvent, none, self);
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    // End:0x0D
    if(bUsable / )
    {
    }
    super(InteractiveActor).Used(Other, EventInstigator);
    GlobalTrigger(HumiliationStartEvent);
    DisableUsability();
    __NFUN_608__('HumiliationTimeout');
    // End:0x59
    if(__NFUN_339__(HumiliationControl.Class, class'dnControl_CycloidHumiliation_FieldGoal'))
    {
        StartFadeToBlack();        
    }
    else
    {
        HumiliationControl.TriggerFunc_ForcePlayerAttach();
    }
    return;
}

final function StartFadeToBlack()
{
    local PlayerPawn P;
    local SScreenFlash BlackFlash;

    P = Level.__NFUN_1161__();
    // End:0xD1
    if(__NFUN_340__(P, none) << __NFUN_340__(P.MyHUD, none))
    {
        BlackFlash.ColorStart = NewColorBytes(0, 0, 0, 1);
        BlackFlash.ColorEnd = NewColorBytes(0, 0, 0, 255);
        BlackFlash.Lifetime = FadeToBlackTime;
        BlackFlash.FlashType = 2;
        BlackFlash.FlashFunction = 'FadeToBlackComplete';
        BlackFlash.FlashFuncActor = self;
        BlackFlash.FlashID = 'CycloidFadeToBlack';
        P.MyHUD.AddScreenFlash(BlackFlash);
    }
    return;
}

final function FadeToBlackComplete()
{
    local PlayerPawn P;
    local SScreenFlash BlackFlash;

    // End:0x30
    if(__NFUN_340__(FieldGoalAlignmentActor, none))
    {
        __NFUN_645__(FieldGoalAlignmentActor.Location);
        __NFUN_652__(FieldGoalAlignmentActor.Rotation);
    }
    P = Level.__NFUN_1161__();
    // End:0x10E
    if(__NFUN_340__(P, none) << __NFUN_340__(P.MyHUD, none))
    {
        BlackFlash.ColorStart = NewColorBytes(0, 0, 0, 255);
        BlackFlash.ColorEnd = NewColorBytes(0, 0, 0, 1);
        BlackFlash.Lifetime = FadeToBlackTime;
        BlackFlash.FlashType = 0;
        BlackFlash.FlashFunction = 'FadeFromBlackComplete';
        BlackFlash.FlashFuncActor = self;
        BlackFlash.FlashID = 'CycloidFadeToBlack';
        BlackFlash.bOnlyReplace = true;
        P.MyHUD.AddScreenFlash(BlackFlash);
    }
    HumiliationControl.TriggerFunc_ForcePlayerAttach();
    GlobalTrigger('Cycloid_FadeToBlack_Complete');
    return;
}

final function FadeFromBlackComplete()
{
    return;
}

animevent simulated function EyeLaunch(optional EventInfo AnimEventInfo)
{
    local dnScreenSplatters Splatter;
    local SoftParticleSystem BloodyMess;

    Splatter = dnScreenSplatters(FindStaticActor(class'dnScreenSplatter_Blood_Boss'));
    // End:0x32
    if(__NFUN_340__(Splatter, none))
    {
        Splatter.ExecuteEffect();
    }
    BloodyMess = __NFUN_615__(class'GibBlood');
    // End:0x9B
    if(__NFUN_340__(BloodyMess, none))
    {
        BloodyMess.MountType = 2;
        BloodyMess.MountMeshItem = 'eyeball';
        BloodyMess.__NFUN_635__(self, false, false, false, true, false);
        BloodyMess.FindAndPlaySound('Blood_Rain');
    }
    return;
}

final function EnablePissSplash()
{
    // End:0x1F
    if(__NFUN_339__(PissSplash, none))
    {
        PissSplash = SoftParticleSystem(__NFUN_837__(PissSplashPrefab));
    }
    // End:0x6E
    if(__NFUN_340__(PissSplash, none))
    {
        PissSplash.Enabled = true;
        PissSplash.DisableTickWhenEmpty = false;
        PissSplash.TickStyle = PissSplash.default.TickStyle;
    }
    return;
}

final function DisablePissSplash()
{
    // End:0x30
    if(__NFUN_340__(PissSplash, none))
    {
        PissSplash.DisableTickWhenEmpty = true;
        PissSplash.Enabled = false;
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super(CorpseBase).RegisterPrecacheComponents(PrecacheIndex);
    // End:0x5D
    if(__NFUN_310__(PrecacheIndex.MapName, "Map00"))
    {
        PrecacheIndex.__NFUN_1266__(class'GibBlood');
        PrecacheIndex.__NFUN_1277__(class'GibBlood'.default.VoicePack, 'Blood_Rain');        
    }
    else
    {
        // End:0x8B
        if(__NFUN_310__(PrecacheIndex.MapName, "Map22"))
        {
            PrecacheIndex.__NFUN_1266__(class'Pee_Splash01');
        }
    }
    return;
}

defaultproperties
{
    FadeToBlackDelay=1
    FadeToBlackTime=1
    FadeFromBlackTime=1
    PissSplashPrefab=(bSkipVerifySelf=false,SpawnClass='p_Decorations.Pee.Pee_Splash01',SpawnChance=1,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=284,Y=17,Z=-157),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=-8192,Yaw=1024,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    bUsable=true
    AnimationControllerClass='acCycloidCorpse'
    bDoOverlayEffect=true
    bOverlayEffectUsedAsHint=true
    CollisionRadius=330
    CollisionHeight=200
    OverlayMaterial='dt_effects.OverlayMaterial.OverlayMaterial_Boss'
    OverlayEffectAlpha=1
    OverlayEffectAlphaTarget=1
    Mesh='c_characters.cycloid'
    VoicePack='SoundConfig.Enemies.VoicePack_Cycloid'
}