/*******************************************************************************
 * Cycloid_AttackBeam generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Cycloid_AttackBeam extends BeamSystem
    collapsecategories
    hidecategories(Filter,HeatVision,Interactivity,Karma,KarmaObject,KarmaOverride,Lighting,Networking,ParticleSystemBase,ParticleTextureInfo,SoftParticleSystem,Sound,SpawnOnDestroyed);

var float DamagePlayer;
var float DamageNonPlayer;
var SoftParticleSystem HitParticleSystem;
var class<SoftParticleSystem> HitParticleSystemClass;

simulated function PostVerifySelf()
{
    local Actor A;

    // End:0x14
    if(-string(BeamSegments))
    {        
        string(BeamSegments) = 1;
    }
    BeamSegments[0].Actor1 = self;
    super(RenderActor).PostVerifySelf();
    __NFUN_361__('Tick');
    return;
}

final function ActivateBeam()
{
    Enabled = true;
    TickStyle = default.TickStyle;
    return;
}

final function DeactivateBeam()
{
    Enabled = false;
    TickStyle = 0;
    return;
}

event Touch(Actor Other)
{
    local float dmg;

    super(Actor).Touch(Other);
    // End:0x2C
    if(Other.bIsPlayerPawn)
    {
        dmg = DamagePlayer;        
    }
    else
    {
        dmg = DamageNonPlayer;
    }
    Other.TakeDamage(none, dmg, Other.Location, WarnInternal(0, 0, 1), class'ExplosionDamage');
    return;
}

defaultproperties
{
    Enabled=false
    BeamStartWidth=10
    BeamEndWidth=10
    DynamicBeamPoints=100024
    BeamTexture='dt_Effects2.Beams.BlueBeam03_FBM'
    BeamTextureScaleX=0.25
    BeamTexturePanX=32
    BeamTextureRotate=90
    BeamSegments(0)=(Lifetime=999999,Actor1=none,Actor2=none,Location1=(X=0,Y=0,Z=0),Location2=(X=0,Y=0,Z=0),bNonActor1=false,bNonActor2=true,Actor1Bone=None,Actor2Bone=None)
    BeamType=0
    bBeamOnlyCheckDynamicShootable=true
    SpawnClassOnBeamCollision='Cycloid_AttackBeam_HitSpawner'
    bForceNonFinalBlendBlooms=true
    NonFinalBlendBloomTint=(R=255,G=255,B=255,A=0)
    Physics=9
    bTraceShootable=false
    bCanExistOutOfWorld=true
    bDumbMesh=false
    bTickOnlyRecent=false
    bTickOnlyZoneRecent=false
    CollisionRadius=0
    CollisionHeight=0
    TouchClasses(0)='dnGame.dnDecoration'
    TouchClasses(1)='Engine.BaseAI'
    TickStyle=3
    Style=6
    AlphaSortGroup=8
    VoicePack='SoundConfig.Interactive.VoicePack_Decorations'
}