/*******************************************************************************
 * Cycloid_AttackBeam_HitSpawner generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Cycloid_AttackBeam_HitSpawner extends Actor
    collapsecategories
    notplaceable;

var() class<dnFriendFX_Spawners> HitClass;
var() class<dnFriendFX_Spawners> ExplosionClass;
var() class<dnDecal> DecalClass;
var() float Delay;
var() float Damage;
var() float DamageRadius;

event PostBeginPlay()
{
    local dnFriendFX_Spawners HitSpawner;

    super.PostBeginPlay();
    ExecuteSpawnEffects();
    return;
}

event Tick(float Delta)
{
    Delay ~= Delta;
    // End:0x24
    if(__NFUN_202__(Delay, 0))
    {
        ExecuteEffects();
        __NFUN_614__();
    }
    return;
}

final function ExecuteSpawnEffects()
{
    local dnFriendFX_Spawners ExplosionSpawner;
    local Decal SpawnedDecal;
    local Rotator DecalRot;

    DecalRot = Rotator(__NFUN_233__(Vector(Rotation)));
    StaticAttachDecal(DecalClass, Location, DecalRot);
    ExplosionSpawner = FindFriendSpawner(HitClass);
    ExplosionSpawner.__NFUN_645__(Location);
    ExplosionSpawner.__NFUN_652__(Rotation);
    ExplosionSpawner.ExecuteEffect(true);
    HurtRadius(Damage, Location, DamageRadius, DamageRadius, class'ExplosionDamage');
    return;
}

final function ExecuteEffects()
{
    local dnFriendFX_Spawners ExplosionSpawner;
    local Decal SpawnedDecal;
    local Rotator DecalRot;

    DecalRot = Rotator(__NFUN_233__(Vector(Rotation)));
    StaticAttachDecal(DecalClass, Location, DecalRot);
    ExplosionSpawner = FindFriendSpawner(ExplosionClass);
    ExplosionSpawner.__NFUN_645__(Location);
    ExplosionSpawner.__NFUN_652__(Rotation);
    ExplosionSpawner.ExecuteEffect(true);
    HurtRadius(Damage, Location, DamageRadius, DamageRadius, class'ExplosionDamage');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(HitClass);
    PrecacheIndex.__NFUN_1266__(ExplosionClass);
    PrecacheIndex.__NFUN_1266__(DecalClass);
    return;
}

defaultproperties
{
    HitClass='p_Creatures.cycloid.Cycloid_BeamHit_Spawner'
    ExplosionClass='p_Creatures.cycloid.Cycloid_BeamExplosions_Spawner'
    DecalClass='dnParticles.dnDecal_BlastMarkBlack'
    Delay=0.65
    Damage=10
    DamageRadius=50
    bHidden=true
}