/*******************************************************************************
 * Cycloid_EyeBeam generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Cycloid_EyeBeam extends BeamSystem
    collapsecategories
    hidecategories(Filter,HeatVision,Interactivity,Karma,KarmaObject,KarmaOverride,Lighting,Networking,ParticleSystemBase,ParticleTextureInfo,SoftParticleSystem,Sound,SpawnOnDestroyed);

var cycloid MyCycloid;
var Vector LastHitLocation;

simulated function PostVerifySelf()
{
    local Actor A;

    // End:0x14
    if(-string(BeamSegments))
    {        
        string(BeamSegments) = 1;
    }
    BeamSegments[0].Actor1 = self;
    super(RenderActor).PostVerifySelf();
    __NFUN_361__('Tick');
    return;
}

final function ActivateBeam()
{
    TickStyle = 2;
    bNoNativeTick = false;
    Enabled = true;
    return;
}

final function DeactivateBeam()
{
    Enabled = false;
    TickStyle = 0;
    return;
}

event HandleHit(Vector HitLocation, Actor HitActor, float DeltaSeconds)
{
    super.HandleHit(HitLocation, HitActor, DeltaSeconds);
    LastHitLocation = HitLocation;
    // End:0x59
    if(__NFUN_340__(HitActor, none) << HitActor.bIsPlayerPawn)
    {
        MyCycloid.NotifyEyeHitPawn(HitActor);        
    }
    else
    {
        MyCycloid.NotifyEyeHit(HitLocation);
    }
    return;
}

defaultproperties
{
    Enabled=false
    BeamStartWidth=2
    BeamEndWidth=2
    DynamicBeamPoints=100024
    BeamTexture='dt_Effects2.Beams.BlueBeam03_FBM'
    BeamTextureScaleX=0.025
    BeamTexturePanX=64
    BeamTextureRotate=90
    BeamSegments(0)=(Lifetime=999999,Actor1=none,Actor2=none,Location1=(X=0,Y=0,Z=0),Location2=(X=0,Y=0,Z=0),bNonActor1=false,bNonActor2=true,Actor1Bone=None,Actor2Bone=None)
    BeamType=0
    bBeamOnlyCheckDynamicShootable=true
    bForceNonFinalBlendBlooms=true
    NonFinalBlendBloomTint=(R=255,G=255,B=255,A=0)
    Physics=9
    bTraceShootable=false
    bCanExistOutOfWorld=true
    bDumbMesh=false
    bTickOnlyRecent=false
    bTickOnlyZoneRecent=false
    CollisionRadius=2
    CollisionHeight=2
    TickStyle=3
    Style=6
    AlphaSortGroup=8
    VoicePack='SoundConfig.Interactive.VoicePack_Decorations'
}