/*******************************************************************************
 * EDF_Grunt generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class EDF_Grunt extends MaleCombat
    config
    collapsecategories;

var() noexport float ChanceGotoCover "Percentage chance of going to cover after taking pain 0.0 -> 1.0";
var() noexport float MaxGotoCoverTime "How long will we keep seeking cover after being damaged?";
var() noexport float MaxThreatTimeSinceSeen "Maximum time since we have seen the target, for the target to be considered enough of a threat to seek cover from.";
var() noexport float ChanceCrouch "Percentage chance of going to crouch posture 0.0 -> 1.0";
var() bool bPlayRustleSounds;
var() SSoundInfo MovementRustleSoundInfo;
var() SSoundInfo LandingRustleSoundInfo;
var float FidgetGate;
var float MinFidgetInterval;
var float RndFidgetInterval;

event PostSpawn()
{
    // End:0x25
    if(__NFUN_341__(Mesh.Name, 'edf_soldiere'))
    {
        CorpseType = class'DylanCorpse';
    }
    super(AIActor).PostSpawn();
    return;
}

animevent simulated function FootStep(optional EventInfo AnimEventInfo)
{
    super(Pawn).FootStep(AnimEventInfo);
    // End:0x22
    if(bPlayRustleSounds)
    {
        PlayFootstepSound(MovementRustleSoundInfo, __NFUN_907__());
    }
    return;
}

simulated function PerformLanding(optional float VerticalVelocity, optional bool bForceLand)
{
    super(Pawn).PerformLanding(VerticalVelocity, bForceLand);
    // End:0x28
    if(bPlayRustleSounds)
    {
        PlayFootstepSound(LandingRustleSoundInfo, __NFUN_907__());
    }
    return;
}

function SetCurrentWeapon(class<Weapon> NewWeaponClass, optional Weapon NewWeapon)
{
    super(AIActor).SetCurrentWeapon(NewWeaponClass, NewWeapon);
    return;
}

function name GetHolsterMount(RenderActor MyWeapon)
{
    // End:0x20
    if(__NFUN_357__(MyWeapon.Class, class'Pistol'))
    {
        return 'mount_holster_hip_right';
    }
    return 'None';
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    // End:0x37
    if(__NFUN_341__(Mesh.Name, 'edf_soldiere'))
    {
        PrecacheIndex.__NFUN_1266__(class'DylanCorpse');
    }
    PrecacheIndex.__NFUN_1276__(MovementRustleSoundInfo);
    PrecacheIndex.__NFUN_1276__(LandingRustleSoundInfo);
    // End:0x101
    if(__NFUN_310__(PrecacheIndex.MapName, "Map22"))
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, 'CPR_Breath');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'CPR_Inhale');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'CPR_Push');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_FootScrape');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_Hand');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'ST_Getup_StandShift');
    }
    return;
}

event EnumerateWeaponClasses(PrecacheIndex PrecacheIndex, out array< class<Weapon> > WeaponClasses)
{
    // End:0x31
    if(__NFUN_310__(PrecacheIndex.MapName, "Map00"))
    {
        WeaponClasses[string(WeaponClasses)] = class'MachineGun_EDF';        
    }
    else
    {
        // End:0x82
        if(__NFUN_310__(PrecacheIndex.MapName, "Map04B") < __NFUN_310__(PrecacheIndex.MapName, "Map04C"))
        {
            WeaponClasses[string(WeaponClasses)] = class'Shotgun_EDF';            
        }
        else
        {
            // End:0xC5
            if(__NFUN_310__(PrecacheIndex.MapName, "Map05"))
            {
                WeaponClasses[string(WeaponClasses)] = class'MachineGun_EDF';
                WeaponClasses[string(WeaponClasses)] = class'Shotgun_EDF';                
            }
            else
            {
                // End:0xF6
                if(__NFUN_310__(PrecacheIndex.MapName, "Map08"))
                {
                    WeaponClasses[string(WeaponClasses)] = class'MachineGun_EDF';                    
                }
                else
                {
                    // End:0x139
                    if(__NFUN_310__(PrecacheIndex.MapName, "Map15"))
                    {
                        WeaponClasses[string(WeaponClasses)] = class'MachineGun_EDF';
                        WeaponClasses[string(WeaponClasses)] = class'Pistol_EDF';                        
                    }
                    else
                    {
                        // End:0x17D
                        if(__NFUN_310__(PrecacheIndex.MapName, "Map16B"))
                        {
                            WeaponClasses[string(WeaponClasses)] = class'MachineGun_EDF';
                            WeaponClasses[string(WeaponClasses)] = class'Shotgun_EDF';                            
                        }
                        else
                        {
                            // End:0x1BD
                            if(__NFUN_310__(PrecacheIndex.MapName, "Map22"))
                            {
                                WeaponClasses[string(WeaponClasses)] = class'Pistol_EDF';
                                WeaponClasses[string(WeaponClasses)] = class'Shotgun_EDF';
                            }
                        }
                    }
                }
            }
        }
    }
    return;
}

defaultproperties
{
    ChanceGotoCover=0.5
    MaxGotoCoverTime=8
    MaxThreatTimeSinceSeen=2
    ChanceCrouch=0.5
    bPlayRustleSounds=true
    MovementRustleSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('dnsMaterials.Generic.Step_Rustle_01','dnsMaterials.Generic.Step_Rustle_02','dnsMaterials.Generic.Step_Rustle_03','dnsMaterials.Generic.Step_Rustle_04'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0.45,VolumeVariance=0,InnerRadius=128,InnerRadiusVariance=0,Radius=640,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    LandingRustleSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=('dnsMaterials.Generic.Land_Rustle_01','dnsMaterials.Generic.Land_Rustle_02'),SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0.65,VolumeVariance=0,InnerRadius=128,InnerRadiusVariance=0,Radius=640,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=true,bNoScale=true,bSpoken=false,bPlayThroughListener=false,bNoDoppler=true,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none)
    MinFidgetInterval=10
    RndFidgetInterval=12
    DamageScaleInfo(0)=(QualifierClass='dnGame.DukePlayer',DamageScale=0,QualifierDamageTypes=none,QualifierNotDamageTypes=none)
    SquadChannel=(ChannelName=DefaultEDFSquad,MaxDistance=2000)
    HasLookTargetEvaluator=true
    LookTargetEvalInfo=(MyOwner=none,EvalInterval=0.5,Suspended=false,bSuspendedWithNoTarget=false,Evaluator=2,ForceUpdate=false,MustBePawn=true,MustBeSighted=false,MustBeReachable=false,CanTargetProjectiles=false,CanAvoidTargetableProjectiles=false,LastTarget=none,LastTargetEndTime=0)
    HeadTrackRate=120
    HasWeaponManager=true
    WeaponConfig='WeaponCfg_EDFGrunt'
    Weapons(0)=none
    Weapons(1)='dnGame.MachineGun_EDF'
    PistolClass='dnGame.Pistol_EDF'
    NumPipeBombs=-1
    PipeBombClass='dnGame.dnPipeBombProjectile_Timed_AI'
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=6,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=6,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=5,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(4)=(m_aClass='Engine.AIFactionRat',m_eAttitude=4,m_fDamageThreshold=1)
    BodyAlignRate=6
    BodyAlignRateFlying=6
    BodyAlignScale=0.75
    FaceDamage=false
    FaceDeath=false
    TryGotoAttackTime=0.5
    MinIdleTime=0.3
    RndIdleTime=1
    MeleeZone=70
    MinMeleeStrafeRange=25
    RndMeleeStrafeRange=5
    MinMeleeStrafeCycles=1
    RndMeleeStrafeCycles=1
    CanJump=true
    HasStartFallAnim=true
    AvoidDangers=true
    PathID=AIPATH_Thin
    ChanceSayFireInTheHole=1
    ChanceSayTakeCover=0.9
    ChanceSayLowHealth=0.75
    ChanceSayConfirmKill=1
    ChanceSayReloading=0.5
    ChanceSayManDown=0.75
    ChanceSayFriendlyFire=1
    ChanceSayEnemySpotted=1
    DynamicPathingPriority=0
    bHolsterWeapons=true
    Team=0
    FootprintType=0
    Faction='Engine.AIFactionHuman'
    FieldOfView=-0.95
    EyeBone=Head
    BodyBone=Spine
    LockOnBone=Spine
    CorpseType='HumanCorpse'
    FootBones(0)=(bRightSide=false,BoneName=leftfoot,BoneID=foot_left_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(1)=(bRightSide=true,BoneName=rightfoot,BoneID=foot_right_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    ExitWoundInfo(0)=(DamageType=none,MinimumDamage=1,RandomChance=1,ExitWoundDecalClass='dnGame.dnExitWound_Human')
    Group=AIGROUP_Good
    CollisionRadius=18
    Mesh='c_characters.edf_soldierA'
}