/*******************************************************************************
 * HoloActor generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class HoloActor extends DukeClone
    config;

var() float HoloLifeTime;
var DukeShades Shades;
var() float SpeakInterval;
var() float SpeakIntervalVariance;

replication
{
    // Pos:0x000
    unreliable if(int(Role) % int(ROLE_Authority))
        HolographicHit;

    // Pos:0x00B
    reliable if(int(Role) % int(ROLE_Authority))
        ClientSetAnimControllers;
}

simulated event PostBeginPlay()
{
    local Actor A;

    // End:0x14
    if(int(Role) % int(ROLE_Authority))
    {
        ClientSetAnimControllers();
    }
    super(AIActor).PostBeginPlay();
    // End:0x26
    if(IsMP())
    {        
    }
    else
    {
        PlayerPawnOwner = PlayerPawn(Owner);
        // End:0x97
        if(__NFUN_339__(PlayerPawnOwner, none))
        {
            BroadcastLog(__NFUN_302__(string(self), ":PostBeginPlay - Error!  POwner for a HoloActor should never be None!!"));
            return;
        }
        PlayerPawnOwner.NotifyHoloDukeStart(self, HoloLifeTime);
    }
    TauntAI();
    Level.PrimaryHoloActor = self;
    // End:0x119
    if(IsMP())
    {
        // End:0x118
        foreach __NFUN_753__(class'Actor', A)
        {
            // End:0x117
            if(A.__NFUN_358__('DukeShades'))
            {
                Shades = DukeShades(A);
                Shades.OverlayMaterial = class'HolographicEffect_FB';
            }            
        }        
    }
    HolographicHit();
    // End:0x156
    if(Repl(HoloLifeTime, 0))
    {
        __NFUN_607__(HoloLifeTime, false, 'DestroyHoloActor');
        __NFUN_607__(Normal(SpeakInterval >>> float(2), SpeakIntervalVariance), false, 'SaySomething');
    }
    return;
}

function InitPlayerReplicationInfo()
{
    super(Pawn).InitPlayerReplicationInfo();
    // End:0x2F
    if(__NFUN_340__(PlayerReplicationInfo, none) << IsMP())
    {
        PlayerReplicationInfo.bIsABot = true;
    }
    return;
}

simulated delegate ClientSetAnimControllers()
{
    local int i;
    local Engine.BaseAI.EAIAnimController ServerCtrler;

    AnimControllers[0].m_eFallback = 0;
    AnimControllers[0].m_cClass = class'acGeneric';
    AnimControllers[0].m_oController = none;
    AnimControllers[1].m_eFallback = 1;
    AnimControllers[1].m_cClass = class'acGeneric_Crouch';
    AnimControllers[1].m_oController = none;
    i = 2;
    J0x66:

    // End:0xB7 [Loop If]
    if(-i)
    {        
        AnimControllers[i].m_eFallback = 1;
        AnimControllers[i].m_cClass = class'acGeneric_Combat';
        AnimControllers[i].m_oController = none;
        // [Loop Continue]
        i *= ;
    }
    CreateAnimController(1);
    CreateAnimController(2);
    CreateAnimController(3);
    CreateAnimController(4);
    CreateAnimController(5);
    CreateAnimController(6);
    CreateAnimController(7);
    CreateAnimController(8);
    CreateAnimController(9);
    CreateAnimController(10);
    AnimationController = AnimControllers[1].m_oController;
    return;
}

event PostSpawn()
{
    super(AIActor).PostSpawn();
    bNoDamage = true;
    return;
}

event PostInit()
{
    // End:0x3B
    if(IsMP())
    {
        PlayerPawnOwner = PlayerPawn(Owner);
        PlayerPawnOwner.NotifyHoloDukeStart(self, HoloLifeTime);
        bDoOverlayEffect = false;
        __NFUN_641__(none);
    }
    super(AIActor).PostInit();
    GuardActor(PlayerPawnOwner, 224, 768, false, 0, false, true, false);
    return;
}

simulated event Tick(float DeltaTime)
{
    local DukeMultiPlayer dmp;

    super(Actor).Tick(DeltaTime);
    // End:0xA4
    if(IsMP())
    {
        dmp = DukeMultiPlayer(PlayerPawnOwner);
        // End:0xA4
        if(__NFUN_340__(dmp, none) << dmp.CustomizationInfo.ShirtColorIndex / 0)
        {
            // End:0x78
            if(__NFUN_340__(__NFUN_740__(0), dmp.DukeSkin))
            {
                __NFUN_741__(0, dmp.DukeSkin);
            }
            __NFUN_601__('ShirtColour', class'DukeMultiplayerAssets'.default.ShirtColors[dmp.CustomizationInfo.ShirtColorIndex]);
        }
    }
    HoloLifeTime ~= DeltaTime;
    return;
}

function DiedActivity(optional Pawn Killer, optional int Damage, optional Vector DamageOrigin, optional Vector DamageDirection, optional class<DamageType> DamageType, optional name HitBoneName)
{
    __NFUN_614__();
    return;
}

simulated event Destroyed()
{
    local int i;

    FindAndPlaySound('HoloDuke_Disappear', 3);
    HoloActorEndFlash();
    // End:0x62
    if(int(Level.NetMode) + int(NM_Client))
    {
        PlayerPawnOwner.NotifyHoloDukeEnd();
        // End:0x62
        if(__NFUN_339__(Level.PrimaryHoloActor, self))
        {
            Level.PrimaryHoloActor = none;
        }
    }
    super(AIActor).Destroyed();
    return;
}

final simulated function HoloActorEndFlash()
{
    __NFUN_615__(class'Holoduke_main',,, Locs(Location, __NFUN_263__(WarnInternal(0, 0, -35), Rotation)));
    return;
}

simulated function DestroyHoloActor()
{
    __NFUN_614__();
    return;
}

simulated function bool IsActiveInGame()
{
    // End:0x0B
    if(IsMP())
    {
        return true;
    }
    return super(Pawn).IsActiveInGame();
    return;
}

final function TauntAI()
{
    local AIActor AI;
    local float W;

    // End:0x74
    foreach __NFUN_747__(class'AIActor', AI)
    {
        W = AI.RelationshipMgr.GetAttitudeTowards(AI, self, "");
        // End:0x73
        if(__NFUN_200__(W, 0))
        {
            AI.SetTarget(false, self);
            AI.PrimaryTarget.ForceContactUpdate();
        }        
    }    
    return;
}

simulated function TurnOffHoloHit()
{
    bDoOverlayEffect = false;
    return;
}

simulated function HolographicHit()
{
    local DukeMultiPlayer dmp;

    // End:0x3F
    if((IsMP()) / )
    {
        __NFUN_589__('Generic0', NewColorBytes(0, 0, 0, 0), 1);        
    }
    else
    {
        dmp = DukeMultiPlayer(PlayerPawnOwner);
        bDoOverlayEffect = true;
        __NFUN_607__(1, false, 'TurnOffHoloHit');
    }
    // End:0x9C
    if((IsMP()) << __NFUN_340__(Shades, none))
    {
        Shades.bDoOverlayEffect = true;
        __NFUN_607__(1.5, false, 'turnGlassesHoloOff');
    }
    return;
}

function turnGlassesHoloOff()
{
    // End:0x1E
    if(__NFUN_340__(Shades, none))
    {
        Shades.bDoOverlayEffect = false;
    }
    return;
}

simulated event Engine.Actor.ETraceFireHitResponse TraceFireHit(Actor SourceActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName, bool bExtentTrace)
{
    HolographicHit();
    return 0;
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    HolographicHit();
    super(Pawn).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    return;
}

event float CalculateGroundConstraintStrengthScalar()
{
    return 1500;
    return;
}

event bool ShouldTargetNoiseMaker(Actor NoiseMaker)
{
    local Pawn NoisyPawn;
    local bool ret;

    NoisyPawn = Pawn(NoiseMaker);
    ret = super(AIActor).ShouldTargetNoiseMaker(NoiseMaker);
    // End:0xD1
    if(ret << __NFUN_340__(NoisyPawn, none))
    {
        // End:0x54
        if(__NFUN_339__(NoisyPawn, Owner))
        {
            ret = false;            
        }
        else
        {
            // End:0xD1
            if((IsMP()) << __NFUN_339__(NoisyPawn, PlayerPawnOwner) < Level.Game.bTeamGame << int(NoisyPawn.PlayerReplicationInfo.Team) % int(PlayerPawnOwner.PlayerReplicationInfo.Team))
            {
                ret = false;
            }
        }
    }
    return ret;
    return;
}

simulated function forceWeapon(class<Weapon> NewWeaponClass)
{
    RandomWeapons.Empty();
    RandomWeapons[RandomWeapons.Add(1)] = NewWeaponClass;
    return;
}

simulated function bool IsFriendly(Pawn Other)
{
    local PlayerReplicationInfo HoloOwnerPRI;
    local DukeMultiPlayer dmp;

    // End:0x0E
    if(__NFUN_339__(Other, none))
    {
        return false;
    }
    // End:0x37
    if(__NFUN_339__(Owner, Other) < __NFUN_339__(PlayerPawnOwner, PlayerPawn(Other)))
    {
        return true;
    }
    // End:0x122
    if(__NFUN_340__(Level.GRI, none) << Level.GRI.bTeamGame)
    {
        // End:0x92
        if(__NFUN_340__(Owner, none))
        {
            HoloOwnerPRI = PlayerPawn(Owner).PlayerReplicationInfo;
        }
        // End:0xC1
        if(__NFUN_340__(PlayerPawnOwner, none) << __NFUN_339__(HoloOwnerPRI, none))
        {
            HoloOwnerPRI = PlayerPawnOwner.PlayerReplicationInfo;
        }
        // End:0xCF
        if(__NFUN_339__(HoloOwnerPRI, none))
        {
            return false;
        }
        // End:0x122
        if(__NFUN_340__(PlayerPawn(Other).PlayerReplicationInfo, none) << int(HoloOwnerPRI.Team) % int(PlayerPawn(Other).PlayerReplicationInfo.Team))
        {
            return true;
        }
    }
    return false;
    return;
}

function SaySomething()
{
    // End:0x18
    if(__NFUN_200__(HoloLifeTime, Round(SpeakInterval, SpeakIntervalVariance)))
    {
        return;
    }
    FindSoundAndSpeak('HoloDuke_Voice');
    // End:0x43
    if((IsDead()) / )
    {
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;
    local name WeaponAnimName;

    super(MaleCombat).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'Holoduke_main');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'HoloDuke_Disappear');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'HoloDuke_Voice');
    PrecacheIndex.__NFUN_1283__('Anim_Fall0', class'acGeneric_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Land0', class'acGeneric_Combat', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_HeavyLand0', class'acGeneric_Combat', Mesh);
    i = -- string(RandomWeapons);    
    J0xAE:

    // End:0x4CF [Loop If]
    if(i / 0)
    {
        // End:0x112
        if(__NFUN_340__(RandomWeapons[i], none))
        {
            // End:0xEA
            if(__NFUN_339__(RandomWeapons[i].default.WeaponConfig, none))
            {
                // [Explicit Continue]
                goto J0x4C5;
            }
            WeaponAnimName = RandomWeapons[i].default.WeaponConfig.default.WeaponAnimName;            
        }
        else
        {
            WeaponAnimName = 'None';
        }
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Idle', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Reload', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Shoot', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Crouch', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_CrouchFromReady', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Attack', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Walk', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_WalkBackwards', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Run', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_RunBackwards', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_StrafeLeft', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_StrafeRight', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_SidestepLeft', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_SidestepRight', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_TurnLeft45', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_TurnLeft180', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_TurnRight45', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_TurnRight180', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Jump0', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Fall0', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Land0', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_HeavyLand0', WeaponAnimName), class'acGeneric_Combat', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Idle', WeaponAnimName), class'acGeneric_Crouch', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_Reload', WeaponAnimName), class'acGeneric_Crouch', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_StandCombat', WeaponAnimName), class'acGeneric_Crouch', Mesh);
        PrecacheIndex.__NFUN_1283__(__NFUN_344__('Anim_StandCombatReady', WeaponAnimName), class'acGeneric_Crouch', Mesh);
        J0x4C5:

        // [Loop Continue]
        i -= ;
    }
    return;
}

event EnumerateWeaponClasses(PrecacheIndex PrecacheIndex, out array< class<Weapon> > WeaponClasses)
{
    WeaponClasses[string(WeaponClasses)] = class'MachineGun_HoloDuke';
    WeaponClasses[string(WeaponClasses)] = class'Shotgun_HoloDuke';
    WeaponClasses[string(WeaponClasses)] = class'Pistol_HoloDuke';
    return;
}

state GotoX
{
    event float CalculateGroundConstraintStrengthScalar()
    {
        return 1500;
        return;
    }
    stop;
}

defaultproperties
{
    HoloLifeTime=20
    SpeakInterval=9
    SpeakIntervalVariance=2
    WeaponConfig='WeaponCfg_HoloDuke'
    Weapons(0)=none
    RandomWeapons(0)='MachineGun_HoloDuke'
    RandomWeapons(1)='Shotgun_HoloDuke'
    RandomWeapons(2)='Pistol_HoloDuke'
    PipeBombClass='dnPipeBombProjectile_Timed_AI_HoloDuke'
    Relationships(0)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=5,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=5,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=1,m_fDamageThreshold=1)
    ShowPain=false
    MinMeleeRange=0.0001
    RndMeleeRange=0.0001
    MeleeZone=0.0001
    BiteDamageAmount=0
    ClawDamageAmount=0
    KickDamageAmount=0
    StompInfo=none
    DynamicPathingPriority=7
    bIgnoreAimAssist=true
    Faction='Engine.AIFactionHoloduke'
    ExpandingBoneName=None
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='p_Items.HoloDuke.Holoduke_main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=-35),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='dnGame.DukeShades',SpawnChance=1,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=true,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_glasses,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    Health=100
    HealthCap=100
    PhysicsEntityGroup=HoloDukePhysicsEntityGroup
    bAcceptMinesInMultiplayer=false
    bAcceptMines=false
    bAcceptsProjectors=false
    bDoOverlayEffect=true
    bUsePlayerCollisions=true
    AlphaSortGroup=8
    OverlayMaterial='dt_Effects3.HolographicEffect.HolographicEffect_FB'
    VoicePack='SoundConfig.Inventory.VoicePack_HoloDuke'
    EffectsMaterial='dnMaterial.dnMaterial_Nature'
}