/*******************************************************************************
 * Pregnator generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Pregnator extends AIActor
    config
    collapsecategories
    dependson(dnControl_PregnatorFaceHump);

const MinDodgeHealth = 10;
const ChanceInitialRoar = 0.7f;
const ChanceRoarInsteadOfPain = 0.3f;
const ChanceDodgeInsteadOfPain = 0.5f;
const ChanceRoarInsteadOfShoot = 0.2f;
const MinMoveInterval = 0.5f;
const RndMoveInterval = 0.5f;
const MinMeleeDuration = 3.0f;
const RndMeleeDuration = 2.0f;
const MinMeleeInterval = 4.0f;
const RndMeleeInterval = 0.0f;
const MinMeleeAttackTime = 0.4f;
const RndMeleeAttackTime = 0.0f;
const MinChargeInterval = 4.0f;
const RndChargeInterval = 3.0f;
const MinShootInterval = 2.5f;
const RndShootInterval = 1.5f;
const MinRoarInterval = 3.0f;
const RndRoarInterval = 2.0f;

var Engine.BaseAI.EAIArcSector DodgeSector;
var float MeleeGate;
var float MeleeAttackGate;
var float ChargeGate;
var float ShootGate;
var float MoveGate;
var() float ChanceRoar;
var() float RoarMinInterval;
var float RoarGate;
var() float JumpSpeed;

event NotifySetTargetActor()
{
    super.NotifySetTargetActor();
    return;
}

function Anim_Idle()
{
    FindSoundAndSpeak('Sound_Idle');
    PlayAnim('Anim_Idle');
    return;
}

function Anim_Landing(int Type)
{
    PlayAnim(__NFUN_343__(__NFUN_302__(string('Anim_Land'), string(Type))));
    FindSoundAndSpeak('Sound_Land');
    return;
}

function Anim_MoveTo(Engine.BaseAI.EAIMoveSpeed MoveSpeed)
{
    FindSoundAndSpeak('Sound_Idle');
    // End:0x38
    if((int(MoveSpeed) % int(2)) << int(GetCurrentOp()) % int(14))
    {
        PlayAnim('Anim_RunFast');        
    }
    else
    {
        super.Anim_MoveTo(MoveSpeed);
    }
    return;
}

animevent simulated function KnobDamage(optional EventInfo AnimEventInfo)
{
    ApplyDamage(class'BiteDamage', int(BiteDamageAmount), BiteDamageVel, 4);
    return;
}

animevent simulated function ClawDamage(optional EventInfo AnimEventInfo)
{
    ApplyDamage(class'TentacleDamage', int(ClawDamageAmount), ClawDamageVel, 4);
    return;
}

function dnProjectile FireProjectile(name MuzzleName, class<dnProjectile> ProjClass, float LeadTime, bool CheckLOS)
{
    local dnProjectile Projectile;
    local dnGrenade Grenade;
    local float GravityZ;

    Projectile = super.FireProjectile(MuzzleName, ProjClass, LeadTime, CheckLOS);
    // End:0x102
    if(__NFUN_340__(Projectile, none))
    {
        ShootGate = (Level.GameTimeSeconds *= 2.5) *= FRand( /= 1.5);
        GravityZ = Projectile.__NFUN_640__().Z;
        Grenade = dnGrenade(Projectile);
        // End:0xFF
        if(__NFUN_340__(Grenade, none) << __NFUN_206__(GravityZ, class'PhysicsVolume'.default.Gravity.Z))
        {
            Grenade.UpwardsBoost = Asc(Right(Grenade.default.UpwardsBoost, GravityZ), class'PhysicsVolume'.default.Gravity.Z);
            Grenade.InitializeMotion();
        }        
    }
    else
    {
        FindSoundAndSpeak('Sound_AttackSwallow');
    }
    return Projectile;
    return;
}

function SetChargeGate()
{
    ChargeGate = (Level.GameTimeSeconds *= 4) *= FRand( /= 3);
}

function SetRoarGate()
{
    RoarGate = Level.GameTimeSeconds *= RoarMinInterval;
    return;
}

event AnimEnd_MeleeAttack_Pregnator()
{
    MeleeAttackGate = (Level.GameTimeSeconds *= 0.4) *= FRand( /= 0);
}

event Engine.BaseAI.EAICode COND_CanMeleeAttack()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x1C
    if(__NFUN_200__(Level.GameTimeSeconds, MeleeAttackGate))
    {
        return 60;
    }
    Code = CheckCondition(22);
    // End:0x3E
    if(int(Code) + int(0))
    {
        return Code;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldMelee()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x11
    if(int(AttackConstraint) % int(1))
    {
        return 0;
    }
    // End:0x22
    if(int(AttackConstraint) % int(2))
    {
        return 72;
    }
    // End:0x3E
    if(__NFUN_200__(Level.GameTimeSeconds, MeleeGate))
    {
        return 60;
    }
    Code = CheckCondition(20);
    // End:0x60
    if(int(Code) + int(0))
    {
        return Code;
    }
    MeleeGate = (Level.GameTimeSeconds *= 3) *= FRand( /= 2);
    return;
}

event Engine.BaseAI.EAICode COND_ShouldEndMelee()
{
    // End:0x11
    if(int(AttackConstraint) % int(2))
    {
        return 0;
    }
    // End:0x22
    if(int(AttackConstraint) % int(1))
    {
        return 73;
    }
    // End:0x89
    if(((int(CheckCondition(21)) % int(0)) < Level.GameTimeSeconds != MeleeGate) < int(GetCurrentOp()) % int(85))
    {
        MeleeGate = (Level.GameTimeSeconds *= 4) *= FRand( /= 0);
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldJumpAttack()
{
    local Engine.BaseAI.EAICode Code;

    // End:0x1C
    if(__NFUN_200__(Level.GameTimeSeconds, ChargeGate))
    {
        return 60;
    }
    // End:0x2F
    if((CheckGlobalGate('PregnatorChargeGate')) / )
    {
    }
    // End:0x43
    if(int(CheckCondition(15)) + int(0))
    {
        return 25;
    }
    // End:0x4F
    if(IsInAir())
    {
        return 51;
    }
    // End:0x6B
    if(__NFUN_200__(Level.GameTimeSeconds, MeleeGate))
    {
        return 60;
    }
    Code = CheckCondition(90);
    // End:0x8D
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(91);
    // End:0xAF
    if(int(Code) + int(0))
    {
        return Code;
    }
    UpdateGlobalGate('PregnatorChargeGate');
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldGotoGuardAttack()
{
    local Engine.BaseAI.EAICode Code;

    Code = CheckCondition(79);
    // End:0x22
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(3);
    // End:0x44
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(60);
    // End:0x66
    if(int(Code) + int(0))
    {
        return Code;
    }
    Code = CheckCondition(25);
    // End:0x88
    if(int(Code) + int(0))
    {
        return Code;
    }
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldInitialRoar()
{
    // End:0x18
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x34
    if(__NFUN_200__(Level.GameTimeSeconds, RoarGate))
    {
        return 60;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0x57
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x057
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 2 & Type:If Position:0x057
}

event Engine.BaseAI.EAICode COND_ShouldRoarInsteadOfPain()
{
    // End:0x13
    if(DamageInfo.Valid / )
    {
    }
    // End:0x2F
    if(__NFUN_200__(Level.GameTimeSeconds, RoarGate))
    {
        return 60;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

event Engine.BaseAI.EAICode COND_ShouldRoar()
{
    // End:0x1C
    if(__NFUN_200__(Level.GameTimeSeconds, RoarGate))
    {
        return 60;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    /*@Error*/;
}

event Engine.BaseAI.EAICode COND_ShouldDodgeInsteadOfPain()
{
    // End:0x13
    if(DamageInfo.Valid / )
    {
    }
    // End:0x2B
    if(PrimaryTarget.IsValidTarget() / )
    {
    }
    // End:0x47
    if(__NFUN_200__(Health *= DamageInfo.Damage, float(10)))
    {
        return 45;
    }
    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */

    // End:0x9F
    /*@Error*/;
    // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 4 & Type:If Position:0x09F
    // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
    // 4 & Type:If Position:0x09F
}

event Engine.BaseAI.EAICode COND_ShouldDodgeLeft()
{
    // End:0x11
    if(int(DodgeSector) % int(2))
    {
        return 0;
    }
    return 1;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldTryShot()
{
    return 0;
    return;
}

event Engine.BaseAI.EAICode COND_ShouldMoveFromWait()
{
    // End:0x1C
    if(__NFUN_200__(Level.GameTimeSeconds, MoveGate))
    {
        return 60;
    }
    return COND_CanMove();
    return;
}

event Engine.BaseAI.EAICode COND_CanMove()
{
    // End:0x1F
    if(int(CheckCondition(24)) + int(0))
    {
        // End:0x1F
        if(SetGoal(8))
        {
            return 0;
        }
    }
    // End:0x2D
    if(SetGoal(22))
    {
        return 0;
    }
    // End:0x3B
    if(SetGoal(15))
    {
        return 0;
    }
    return 53;
    return;
}

event Engine.BaseAI.EAICode COND_BeginWaitState()
{
    MoveGate = (Level.GameTimeSeconds *= 0.5) *= FRand( /= 0.5);
    return;
}

event float GetDefaultGotoXRange(float Range)
{
    return 5;
    return;
}

function bool TryFaceHump(Actor WallActor, optional bool Force)
{
    local DukePlayer Duke;
    local Vector TargetPos, Offset2D;
    local dnControl_PregnatorFaceHump FaceHumpControl;
    local float DotVal, Dist;
    local int i;
    local array<Actor> BlockingActors;

    // End:0x12
    if((CheckGlobalGate('PregnatorFaceHumpGate')) / )
    {
    }
    Duke = DukePlayer(WallActor);
    // End:0x2C7
    if(((((((int(FrozenState) % int(0)) << __NFUN_921__() / ) << __NFUN_340__(Duke, none)) << Duke.IsDead() / ) << Duke.__NFUN_921__() / ) << ) << if(__NFUN_340__(LaserMine(MountedActorList[i].MountedActor), none)))
    {
        {
            {
            }
            // [Loop Continue]
            i -= ;
        }/* !MISMATCHING REMOVE, tried Loop got Type:If Position:0x0B6! */
        // End:0x134
        if(Force / )
        {
            Offset2D.Z = 0;
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            // End:0x2C7
            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 16 & Type:If Position:0x2C7
            // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 16 & Type:If Position:0x2C7
}

event Vector GetJumpAttackTargetPos(Actor TargetActor)
{
    local Pawn pawnTarget;
    local float LeadTime, Dist;
    local Vector TargetPos;

    // End:0x23
    if(TargetActor.bIsPawn)
    {
        pawnTarget = Pawn(TargetActor);
    }
    // End:0xA7
    if(__NFUN_340__(pawnTarget, none))
    {
        Dist = Clamp(__NFUN_239__(pawnTarget.Location, Location));
        LeadTime = Dist >>> JumpSpeed;
        TargetPos = pawnTarget.__NFUN_906__();
        // End:0x9E
        if(__NFUN_206__(LeadTime, 0))
        {
            Min(TargetPos, Right(pawnTarget.Velocity, LeadTime));
        }
        return TargetPos;        
    }
    else
    {
        return Locs(TargetActor.Location, WarnInternal(0, 0, FRand(TargetActor.CollisionHeight, 0.66)));
    }
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(Pawn).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1266__(class'dnControl_PregnatorFaceHump');
    PrecacheIndex.__NFUN_1279__(class'BiteDamage');
    PrecacheIndex.__NFUN_1279__(class'TentacleDamage');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_AttackClaw');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_AttackJumpGrunt');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_AttackPreSpit');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_AttackShrunk');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_AttackSpit');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_AttackSwallow');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_AttackWhip1');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_AttackWhip2');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Dodge');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_FaceAttach');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Hiss');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Idle');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Sound_Land');
    PrecacheIndex.__NFUN_1283__('Anim_Idle', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Walk', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_WalkBackwards', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Run', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_RunBackwards', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_RunFast', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft45', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnLeft180', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight45', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_TurnRight180', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SidestepLeft', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_SidestepRight', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeLeft', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_StrafeRight', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_DodgeLeft', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_DodgeRight', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_ShootProjectile', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Attack', class'acPregnator', Mesh);
    // End:0x393
    if(PrecacheIndex.bPlayerCanBeShrunk)
    {
        PrecacheIndex.__NFUN_1283__('Anim_AttackShrunk', class'acPregnator', Mesh);
    }
    PrecacheIndex.__NFUN_1283__('Anim_JumpAttack', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_JumpAttack0', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_JumpAttack1', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Jump1', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Fall1', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Land1', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Jump0', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Fall0', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Land0', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_HeavyLand0', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_Roar', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainShortFront', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainShortBack', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainShortLeft', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainShortRight', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBigFront', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBigBack', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBigLeft', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1283__('Anim_PainBigRight', class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1282__(class'acPregnator', Mesh);
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Rage_VOC');
    return;
}

simulated event bool CanBreatheNormally()
{
    return true;
    return;
}

event EnumerateUsableAnimationControllers(PrecacheIndex PrecacheIndex, out array<Engine.BaseAI.EAIAnimController> UsableControllers)
{
    UsableControllers[string(UsableControllers)] = 1;
    return;
}

state JumpAttack
{
    event Landed(Vector HitNormal, Actor LandedOnActor)
    {
        // End:0x21
        if((TryFaceHump(LandedOnActor, true)) / )
        {
        }
        return;
    }

    event HitWall(Vector WallNormal, Actor WallActor)
    {
        // End:0x20
        if((TryFaceHump(WallActor)) / )
        {
        }
        return;
    }
    stop;
}

defaultproperties
{
    ChanceRoar=1
    JumpSpeed=450
    Nodes(0)=(Ident=Root,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(1)=(Ident=InitialRoar,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(2)=(Ident=Dodge,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(3)=(Ident=Guard,Status=0,ReportedInvalid=false,SucCond=76,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(4)=(Ident=GotoGuardAttack,Status=0,ReportedInvalid=false,SucCond=61,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(5)=(Ident=GotoGuardPos,Status=0,ReportedInvalid=false,SucCond=79,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(6)=(Ident=Search,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=7,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(7)=(Ident=AvoidDanger,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(8)=(Ident=Wait,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(9)=(Ident=Melee,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(10)=(Ident=GotoWeapon,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(11)=(Ident=Projectile,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(12)=(Ident=FaceTargetJumpAttack,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(13)=(Ident=Attack,Status=0,ReportedInvalid=false,SucCond=7,SucFunc=None,FailCond=9,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(14)=(Ident=AttackJumpAttack,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(15)=(Ident=AttackWeapon,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(16)=(Ident=AttackMelee,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(17)=(Ident=AttackActionPoint,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(18)=(Ident=SearchActionPoint,Status=0,ReportedInvalid=false,SucCond=4,SucFunc=None,FailCond=4,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(19)=(Ident=AvoidTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=COND_ShouldNotAvoidTarget,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(20)=(Ident=Cower,Status=0,ReportedInvalid=false,SucCond=1,SucFunc=None,FailCond=1,FailFunc=None,Op=0,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(21)=(Ident=Default,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(22)=(Ident=FUBAR,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=1,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(23)=(Ident=Pain,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=96,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(24)=(Ident=idle,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=85,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(25)=(Ident=FaceTarget,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=145,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(26)=(Ident=FaceGuardedActor,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=143,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(27)=(Ident=GotoJumpAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=56,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(28)=(Ident=GotoGoalFacePosOneStep,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=48,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(29)=(Ident=GotoMelee,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=61,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(30)=(Ident=GotoGuardMeleeAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=62,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(31)=(Ident=GotoGoalFullBody,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=53,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(32)=(Ident=GotoSearchPos,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=71,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(33)=(Ident=GotoGoalFacePos,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=47,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(34)=(Ident=StepAside,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=46,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(35)=(Ident=StrafeMelee,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=125,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(36)=(Ident=MeleeAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=92,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(37)=(Ident=Roar,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=107,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(38)=(Ident=ShootProjectile,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=117,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(39)=(Ident=DodgeLeft,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=25,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(40)=(Ident=DodgeRight,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=26,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(41)=(Ident=FreeMoveSpreadOut,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=40,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(42)=(Ident=JumpAttack,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=89,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(43)=(Ident=JumpToActionPoint,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=88,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    Nodes(44)=(Ident=TurnToActionPoint,Status=0,ReportedInvalid=false,SucCond=0,SucFunc=None,FailCond=0,FailFunc=None,Op=144,OpRef=0,SharedTransitions=none,StateTable=none,CurStateIndex=0)
    FSMStates(0)=(FSM=Root,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=0,Func=COND_ShouldRoarInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Dodge,Cond=0,Func=COND_ShouldDodgeInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(1)=(FSM=Root,Ident=Roar,FSMSucc=false,FSMFail=false,Transitions=((Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(2)=(FSM=Root,Ident=Dodge,FSMSucc=false,FSMFail=false,Transitions=((Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(3)=(FSM=Root,Ident=Pain,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(4)=(FSM=Root,Ident=Search,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=0,Func=COND_ShouldRoarInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Dodge,Cond=0,Func=COND_ShouldDodgeInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=InitialRoar,Cond=0,Func=COND_ShouldInitialRoar,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(5)=(FSM=Root,Ident=Attack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=0,Func=COND_ShouldRoarInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Dodge,Cond=0,Func=COND_ShouldDodgeInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(6)=(FSM=Root,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=0,Func=COND_ShouldRoarInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Dodge,Cond=0,Func=COND_ShouldDodgeInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=InitialRoar,Cond=0,Func=COND_ShouldInitialRoar,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(7)=(FSM=Root,Ident=Guard,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=0,Func=COND_ShouldRoarInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Dodge,Cond=0,Func=COND_ShouldDodgeInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(8)=(FSM=Root,Ident=InitialRoar,FSMSucc=false,FSMFail=false,Transitions=((Ident=Dodge,Cond=0,Func=COND_ShouldDodgeInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(9)=(FSM=Root,Ident=AvoidDanger,FSMSucc=false,FSMFail=false,Transitions=((Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(10)=(FSM=Root,Ident=AvoidTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Search,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(11)=(FSM=Root,Ident=SearchActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=0,Func=COND_ShouldRoarInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Dodge,Cond=0,Func=COND_ShouldDodgeInsteadOfPain,Win=0,Code=0,StateTableIndex=0),(Ident=Pain,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AvoidTarget,Cond=0,Func=COND_ShouldAvoidTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Guard,Cond=75,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Attack,Cond=3,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=SearchActionPoint,Cond=7,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(12)=(FSM=InitialRoar,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(13)=(FSM=InitialRoar,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=Roar,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(14)=(FSM=InitialRoar,Ident=Roar,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(15)=(FSM=Dodge,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=DodgeLeft,Cond=0,Func=COND_ShouldDodgeLeft,Win=1,Code=0,StateTableIndex=0),(Ident=DodgeRight,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(16)=(FSM=Dodge,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=DodgeLeft,Cond=0,Func=COND_ShouldDodgeLeft,Win=1,Code=0,StateTableIndex=0),(Ident=DodgeRight,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(17)=(FSM=Dodge,Ident=DodgeLeft,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(18)=(FSM=Dodge,Ident=DodgeRight,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(19)=(FSM=Guard,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardMeleeAttack,Cond=85,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(20)=(FSM=Guard,Ident=GotoGuardAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardMeleeAttack,Cond=85,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(21)=(FSM=Guard,Ident=GotoGuardMeleeAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(22)=(FSM=Guard,Ident=GotoGuardPos,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardMeleeAttack,Cond=85,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(23)=(FSM=Guard,Ident=Melee,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardMeleeAttack,Cond=85,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=0,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(24)=(FSM=Guard,Ident=Projectile,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardMeleeAttack,Cond=85,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=1,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(25)=(FSM=Guard,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_ShouldGuardAttackMelee,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardMeleeAttack,Cond=85,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardPos,Cond=0,Func=COND_ShouldGotoGuardPos,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGuardAttack,Cond=0,Func=COND_ShouldGotoGuardAttack,Win=0,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(26)=(FSM=GotoGuardAttack,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(27)=(FSM=GotoGuardAttack,Ident=GotoGoalFacePos,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(28)=(FSM=GotoGuardPos,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(29)=(FSM=GotoGuardPos,Ident=GotoGoalFacePos,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(30)=(FSM=Search,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoSearchPos,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(31)=(FSM=Search,Ident=GotoSearchPos,FSMSucc=true,FSMFail=true,Transitions=((Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(32)=(FSM=Search,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(33)=(FSM=AvoidDanger,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFacePosOneStep,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(34)=(FSM=AvoidDanger,Ident=GotoGoalFacePosOneStep,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(35)=(FSM=AvoidDanger,Ident=Wait,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(36)=(FSM=Wait,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=5,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(37)=(FSM=Wait,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(38)=(FSM=Wait,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=5,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(39)=(FSM=Wait,Ident=StepAside,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=5,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=1,Code=0,StateTableIndex=0),(Ident=FaceGuardedActor,Cond=9,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(40)=(FSM=Wait,Ident=FaceGuardedActor,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=5,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=StepAside,Cond=0,Func=COND_ShouldStepAside,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(41)=(FSM=Melee,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(42)=(FSM=Melee,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=MeleeAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(43)=(FSM=Melee,Ident=MeleeAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(44)=(FSM=GotoWeapon,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFullBody,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(45)=(FSM=GotoWeapon,Ident=GotoGoalFullBody,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(46)=(FSM=Projectile,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=ShootProjectile,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(47)=(FSM=Projectile,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=ShootProjectile,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(48)=(FSM=Projectile,Ident=ShootProjectile,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(49)=(FSM=Projectile,Ident=Roar,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(50)=(FSM=FaceTargetJumpAttack,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Roar,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(51)=(FSM=FaceTargetJumpAttack,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=JumpAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(52)=(FSM=FaceTargetJumpAttack,Ident=JumpAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(53)=(FSM=FaceTargetJumpAttack,Ident=Roar,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(54)=(FSM=Attack,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=AttackJumpAttack,Cond=0,Func=COND_ShouldJumpAttack,Win=1,Code=0,StateTableIndex=0),(Ident=AttackWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(55)=(FSM=Attack,Ident=AttackMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=Dodge,Cond=97,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=AttackWeapon,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(56)=(FSM=Attack,Ident=AttackWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=Dodge,Cond=97,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpAP,Win=0,Code=0,StateTableIndex=0),(Ident=AttackJumpAttack,Cond=0,Func=COND_ShouldJumpAttack,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(57)=(FSM=Attack,Ident=AttackJumpAttack,FSMSucc=false,FSMFail=false,Transitions=((Ident=Dodge,Cond=97,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=1,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=AttackWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(58)=(FSM=Attack,Ident=AttackActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackActionPoint,Cond=0,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=AttackJumpAttack,Cond=0,Func=COND_ShouldJumpAttack,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(59)=(FSM=Attack,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackMelee,Cond=0,Func=COND_ShouldMelee,Win=0,Code=0,StateTableIndex=0),(Ident=AttackJumpAttack,Cond=0,Func=COND_ShouldJumpAttack,Win=0,Code=0,StateTableIndex=0),(Ident=AttackWeapon,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(60)=(FSM=Attack,Ident=Dodge,FSMSucc=false,FSMFail=false,Transitions=((Ident=AttackJumpAttack,Cond=0,Func=COND_ShouldJumpAttack,Win=1,Code=0,StateTableIndex=0),(Ident=AttackWeapon,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(61)=(FSM=AttackJumpAttack,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoJumpAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(62)=(FSM=AttackJumpAttack,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoJumpAttack,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(63)=(FSM=AttackJumpAttack,Ident=GotoJumpAttack,FSMSucc=false,FSMFail=true,Transitions=((Ident=GotoJumpAttack,Cond=0,Func=None,Win=3,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=2,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(64)=(FSM=AttackJumpAttack,Ident=idle,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoJumpAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=JumpAttack,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(65)=(FSM=AttackJumpAttack,Ident=JumpAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(66)=(FSM=AttackWeapon,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoWeapon,Cond=0,Func=COND_CanMove,Win=0,Code=0,StateTableIndex=0),(Ident=FaceTargetJumpAttack,Cond=26,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(67)=(FSM=AttackWeapon,Ident=Projectile,FSMSucc=true,FSMFail=false,Transitions=((Ident=FaceTargetJumpAttack,Cond=26,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoWeapon,Cond=0,Func=COND_CanMove,Win=1,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(68)=(FSM=AttackWeapon,Ident=GotoWeapon,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTargetJumpAttack,Cond=26,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=COND_BeginWaitState,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(69)=(FSM=AttackWeapon,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTargetJumpAttack,Cond=26,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=COND_ShouldTryShot,Win=0,Code=0,StateTableIndex=0),(Ident=GotoWeapon,Cond=0,Func=COND_ShouldMoveFromWait,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(70)=(FSM=AttackWeapon,Ident=FaceTargetJumpAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(71)=(FSM=AttackMelee,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_CanMeleeAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(72)=(FSM=AttackMelee,Ident=Melee,FSMSucc=true,FSMFail=false,Transitions=((Ident=StrafeMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(73)=(FSM=AttackMelee,Ident=StrafeMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_CanMeleeAttack,Win=1,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(74)=(FSM=AttackMelee,Ident=GotoMelee,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_CanMeleeAttack,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(75)=(FSM=AttackMelee,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=Melee,Cond=0,Func=COND_CanMeleeAttack,Win=0,Code=0,StateTableIndex=0),(Ident=GotoMelee,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(76)=(FSM=AttackActionPoint,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=GotoGoalFullBody,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(77)=(FSM=AttackActionPoint,Ident=GotoGoalFullBody,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTargetJumpAttack,Cond=26,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFullBody,Cond=0,Func=COND_ShouldWalkToNextAPClosestTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(78)=(FSM=AttackActionPoint,Ident=JumpToActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTargetJumpAttack,Cond=26,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFullBody,Cond=13,Func=COND_ShouldWalkToNextAPClosestTarget,Win=1,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFullBody,Cond=0,Func=COND_ShouldWalkToNextAPClosestTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(79)=(FSM=AttackActionPoint,Ident=Projectile,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTargetJumpAttack,Cond=26,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFullBody,Cond=13,Func=COND_ShouldWalkToNextAPClosestTarget,Win=1,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFullBody,Cond=0,Func=COND_ShouldWalkToNextAPClosestTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(80)=(FSM=AttackActionPoint,Ident=Roar,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTargetJumpAttack,Cond=26,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFullBody,Cond=13,Func=COND_ShouldWalkToNextAPClosestTarget,Win=1,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=1,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFullBody,Cond=0,Func=COND_ShouldWalkToNextAPClosestTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(81)=(FSM=AttackActionPoint,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=FaceTargetJumpAttack,Cond=26,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAP,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFullBody,Cond=0,Func=COND_ShouldWalkToNextAPClosestTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Projectile,Cond=0,Func=None,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(82)=(FSM=AttackActionPoint,Ident=FaceTargetJumpAttack,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    FSMStates(83)=(FSM=SearchActionPoint,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAPNoTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(84)=(FSM=SearchActionPoint,Ident=GotoGoalFacePos,FSMSucc=false,FSMFail=false,Transitions=((Ident=TurnToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAPNoTarget,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(85)=(FSM=SearchActionPoint,Ident=JumpToActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=TurnToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAPNoTarget,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoJumpAP,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(86)=(FSM=SearchActionPoint,Ident=TurnToActionPoint,FSMSucc=false,FSMFail=false,Transitions=((Ident=JumpToActionPoint,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAPNoTarget,Win=1,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(87)=(FSM=SearchActionPoint,Ident=Wait,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoJumpAP,Win=0,Code=0,StateTableIndex=0),(Ident=JumpToActionPoint,Cond=0,Func=COND_ShouldJumpToNextAPNoTarget,Win=0,Code=0,StateTableIndex=0),(Ident=Wait,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(88)=(FSM=AvoidTarget,Ident=Default,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoAvoidGoal,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(89)=(FSM=AvoidTarget,Ident=GotoGoalFacePos,FSMSucc=false,FSMFail=false,Transitions=((Ident=Cower,Cond=0,Func=COND_SafeFromBiggerEnemy,Win=1,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldGotoAvoidGoal,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(90)=(FSM=AvoidTarget,Ident=Cower,FSMSucc=false,FSMFail=false,Transitions=((Ident=GotoGoalFacePos,Cond=0,Func=COND_NotSafeFromBigEnemy,Win=0,Code=0,StateTableIndex=0),(Ident=GotoGoalFacePos,Cond=0,Func=COND_ShouldMoveAround,Win=1,Code=0,StateTableIndex=0),(Ident=Cower,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(91)=(FSM=Cower,Ident=Default,FSMSucc=true,FSMFail=true,Transitions=((Ident=FaceTarget,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0),(Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(92)=(FSM=Cower,Ident=FaceTarget,FSMSucc=false,FSMFail=false,Transitions=((Ident=idle,Cond=0,Func=None,Win=1,Code=0,StateTableIndex=0)),NodeIndex=0)
    FSMStates(93)=(FSM=Cower,Ident=idle,FSMSucc=true,FSMFail=true,Transitions=none,NodeIndex=0)
    WeaponConfig='WeaponCfg_Pregnator'
    ForceDirectShot=true
    UseActionPoints=true
    RollLeftInfo=(X=0,Y=-130,Z=0)
    RollRightInfo=(X=0,Y=130,Z=0)
    Relationships(0)=(m_aClass='Engine.AIFactionHoloduke',m_eAttitude=1,m_fDamageThreshold=1)
    Relationships(1)=(m_aClass='Engine.AIFactionDuke',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(2)=(m_aClass='Engine.AIFactionHuman',m_eAttitude=2,m_fDamageThreshold=1)
    Relationships(3)=(m_aClass='Engine.AIFactionAlien',m_eAttitude=5,m_fDamageThreshold=1)
    BodyAlignRate=7
    BodyAlignRateFlying=7
    BodyAlignScale=0.8
    bTryBackupPathingOnFailure=true
    AnimControllers[0]=(m_eFallback=0,m_cClass='acPregnator',m_oController=none)
    AnimControllers[1]=(m_eFallback=1,m_cClass='acPregnator',m_oController=none)
    AnimControllers[2]=(m_eFallback=1,m_cClass='acPregnator',m_oController=none)
    AnimControllers[3]=(m_eFallback=1,m_cClass='acPregnator',m_oController=none)
    AnimControllers[4]=(m_eFallback=1,m_cClass='acPregnator',m_oController=none)
    AnimControllers[5]=(m_eFallback=1,m_cClass='acPregnator',m_oController=none)
    AnimControllers[6]=(m_eFallback=1,m_cClass='acPregnator',m_oController=none)
    AnimControllers[7]=(m_eFallback=1,m_cClass='acPregnator',m_oController=none)
    AnimControllers[8]=(m_eFallback=1,m_cClass='acPregnator',m_oController=none)
    JumpParms=(Mode=0,JumpVel=(X=0,Y=0,Z=0),HeavyLandingThresh=0,AppliedJumpVel=false,StartZ=0,RefId=0,AnimSet=0,FrameVelocity=(X=0,Y=0,Z=0),bDisableIK=true,bRestoreIKPreLand=true,ExitTime=0,JumpType=0,FaceTarget=true,FocusActor=none,AutoPitch=true,PitchRate=80000,PitchRateLand=80000,MaxPitch=6228,MaxVelocity=800,bDebug=false,bTakeOffNoLand=false,TakeOffIdleTime=0,FlyingGravityScale=0,TargetPos=(X=0,Y=0,Z=0),bCheckTargetPos=false,bUseAccelaration=false,AccelerationScale=0,Fudge=(X=0,Y=0,Z=0),bSnapToTargetDuringLand=false,bRequireCompleteSnap=false,bSnapActive=false,bLandAnimComplete=false,StopLinearDamping=0,bAllowProcFireDuringFall=false)
    JumpAttackParms=(TargetActor=none,Mode=0,Type=0,AttackOnTakeoff=false,Attacked=false,AttackSuccess=false,AppliedJumpVel=false,RefId=0,FrameVelocity=(X=0,Y=0,Z=0),bCanJumpAttackShrunkTarget=false,ShrunkTargetHeightScale=1,ShrunkTargetDistanceScale=1,MinInterval=3,GroundFinderGate=0,GroundFinderInterval=0.5,PresetFrameVelocity=(X=0,Y=0,Z=0),DefaultPresetFrameVelocity=(X=100,Y=0,Z=50),JumpAttackType=1,ParabolaJumpHeight=35,ParabolaMinJumpHeight=5,ParabolaMaxJumpHeight=30,GroundFinderLockout=0.25,bInstantJump=false,bUsePresetVelocity=false,bCheckClearShot=false,bCheckHasPath=true,bCheckClearPath=false,bDontApplyDirectDamage=false,bDisabled=false)
    RangeParms=(ActionPointClosestMaxTravelDist=5000,ActionPointClosestMaxTargetDist=5000,ActionPointClosestJumpableMaxTravelDist=5000,ActionPointClosestFlyerMaxTravelDist=7500)
    FaceDamage=false
    FaceDeath=false
    ShouldTurnThreshold=10
    FaceThreshold=4
    SideArcTurnSpeedThresh=10
    MoveBackwardsDistThresh=20
    SideStepDistThresh=10
    MinMoveAroundDist=50
    RndMoveAroundDist=160
    MinSpreadOutTime=0.5
    RndSpreadOutTime=0.7
    RndMeleeRange=20
    MeleeZone=160
    MinMeleeStrafeRange=10
    RndMeleeStrafeRange=10
    MinMeleeStrafeCycles=1
    RndMeleeStrafeCycles=1
    MeleeFaceTarget=true
    BiteDamageAmount=15
    ClawDamageAmount=15
    MinChargeRange=50
    MaxChargeRange=650
    MinChargeAttackRange=100
    MaxChargeAttackRange=130
    MinWeaponStrafeCycles=3
    ProjectileClass='dnGame.dnJizzBomb'
    ProjectileMuzzleName=unit_tip
    bShootProjectileRequireLOS=false
    bShootProjectileRequireTargetNotInStrTap=true
    MinJumpAttackRange=20
    MaxJumpAttackRange=225
    MaxJumpAttackHeight=500
    bJumpAttackRequireTargetNotInStrTap=true
    JumpAttackOnTakeOff=true
    CanJump=true
    CanOpenDoors=false
    AvoidDangers=true
    PathID=AIPATH_Medium
    ActionPointJumpType=Pregnator
    PathSizeOverrideHeight=22
    PathSizeOverrideRadius=30
    bAllowSpecialKillSounds=false
    bShouldCauseStompKillSound=false
    bInstaGib=true
    FootstepCategory=2
    SlopeMinimumDotEx=-2
    EyeBone=Head
    BodyBone=neck_lower
    LockOnBone=neck_lower
    CustomKillSoundName=GotKillPregnator
    CorpseType='AlienCorpse'
    MaxStepHeightEx=8.08
    FootBones(0)=(bRightSide=true,BoneName=leg_front_right_D,BoneID=foot_right_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(1)=(bRightSide=true,BoneName=leg_mid_right_D,BoneID=foot_right_2,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(2)=(bRightSide=true,BoneName=leg_back_right_D,BoneID=foot_right_3,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(3)=(bRightSide=false,BoneName=leg_front_left_D,BoneID=foot_left_1,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(4)=(bRightSide=false,BoneName=leg_mid_left_D,BoneID=foot_left_2,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    FootBones(5)=(bRightSide=false,BoneName=leg_back_left_D,BoneID=foot_left_3,BoneRotOffset=(Pitch=0,Yaw=0,Roll=0))
    ExitWoundInfo(0)=(DamageType=none,MinimumDamage=1,RandomChance=1,ExitWoundDecalClass='dnGame.dnExitWound_Human')
    AutoRegisterIKClasses(0)='IKSystemInfo_Walker_Pregnator'
    Health=35
    HealthCap=35
    bCanExistOutOfWorld=false
    CollisionRadius=20
    CollisionHeight=14
    DisturbWaterRadius=16
    Mass=30
    Mesh='c_characters.Pregnator'
    VoicePack='SoundConfig.Enemies.VoicePack_Pregnator'
}