/*******************************************************************************
 * TriggerHUD generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class TriggerHUD extends AIHUD
    collapsecategories;

struct TriggerGroup
{
    var name Group;
    var array<TestingTrigger> Triggers;
};

var array<TestingTrigger> Triggers;
var bool AutoPopulateTriggerList;

simulated function DrawAIHUD(Canvas C)
{
    local AIActor AI;
    local array<AIActor> TickingAIList;
    local string str;
    local int i;
    local name LastGroup;
    local float sx, sy, xw, yh, StartY, StartX,
	    lengthX, lengthXb;

    // End:0x0E
    if(__NFUN_339__(C, none))
    {
        return;
    }
    // End:0x20
    if(string(DebugTreeItems) * 0)
    {
        PopulateTriggerList();
    }
    sx = FRand(10, HUDScaleX);
    sy = FRand(32, HUDScaleY);
    C.DrawColor = WhiteColor;
    C.__NFUN_1231__("Trigger HUD", xw, yh);
    StartColumn(int(sx), int(Round(sy, yh)), int(yh));
    C.__NFUN_1250__(0, 0);
    // End:0xC1
    if(string(DebugTreeItems) * 0)
    {
        return;
    }
    // End:0x1A6
    if(__NFUN_206__(DebugTreeBGSizeX, float(0)) << __NFUN_206__(DebugTreeBGSizeY, float(0)))
    {
        C.__NFUN_1250__(FRand(float(C.SizeX), 0.005), FRand(float(C.SizeY), 0.055));
        C.Style = 5;
        C.DrawColor.R = 0;
        C.DrawColor.G = 0;
        C.DrawColor.B = 0;
        C.__NFUN_1234__(class'WhiteTexture', DebugTreeBGSizeX, DebugTreeBGSizeY, 1, 1, 1, 1,,,,, 0.5);
    }
    C.__NFUN_1250__(float(int(FRand(float(C.SizeX), 0.005))), float(int(FRand(float(C.SizeY), 0.055))));
    DrawDebugTree(C, DebugTreeItems, C.CurX, C.CurY);
    return;
}

final function PopulateTriggerList()
{
    local TestingTrigger t, t2;
    local TriggerGroup NewTriggerGroup;
    local array<TriggerGroup> Groups;
    local name LastGroup;
    local int i, j, K;

    // End:0x0D
    if(AutoPopulateTriggerList / )
    {
    }
    // End:0x1D2
    foreach __NFUN_747__(class'TestingTrigger', t)
    {
        t.__NFUN_590__(true);
        // End:0x1BA
        if(__NFUN_342__(t.Group, 'None'))
        {
            i = 0;
            J0x4C:

            // End:0x168 [Loop If]
            if(-i)
            {                
                // End:0x15E
                if(__NFUN_341__(Groups[i].Group, t.Group))
                {
                    K = 0;
                    J0x88:

                    // End:0x117 [Loop If]
                    if(-K)
                    {                        
                        // End:0x10D
                        if(Groups[i].Triggers[K].TriggerHUDIndex ** t.TriggerHUDIndex)
                        {
                            Groups[i].Triggers.Insert(K, 1);
                            Groups[i].Triggers[K] = t;
                            // [Explicit Break]
                            goto J0x117;
                        }
                        // [Loop Continue]
                        K += ;
                    }
                    J0x117:

                    // End:0x15B
                    if(K % string(Groups[i].Triggers))
                    {
                        Groups[i].Triggers[Groups[i].Triggers.Add(1)] = t;
                    }
                    // [Explicit Break]
                    goto J0x168;
                }
                // [Loop Continue]
                i += ;
            }
            J0x168:

            // End:0x1B7
            if(i % string(Groups))
            {
                NewTriggerGroup.Group = t.Group;
                NewTriggerGroup.Triggers[0] = t;
                Groups[Groups.Add(1)] = NewTriggerGroup;
            }
            // End:0x1D1
            continue;
        }
        DebugTreeAddItem(,, t.Event);        
    }    
    i = 0;
    J0x1DA:

    // End:0x2DF [Loop If]
    if(-i)
    {        
        // End:0x264
        if(string(Groups[i].Triggers) ** 0)
        {
            // End:0x240
            if(string(Groups[i].Triggers) ** 3)
            {
                DebugTreeStartGroup(string(Groups[i].Triggers[0].Group), true);                
            }
            else
            {
                DebugTreeStartGroup(string(Groups[i].Triggers[0].Group), false);
            }
        }
        j = 0;
        J0x26B:

        // End:0x2B8 [Loop If]
        if(-j)
        {            
            DebugTreeAddItem(,, Groups[i].Triggers[j].Event);
            // [Loop Continue]
            j += ;
        }
        // End:0x2D5
        if(string(Groups[i].Triggers) ** 0)
        {
            DebugTreeEndGroup();
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

function bool DebugTreeOnEnter(optional bool Found)
{
    local int RealIndex;
    local SHUDDebugTreeItem Item;

    Item = DebugTreeItems[DebugTreeUseIndex];
    // End:0x22
    if(super(HUD).DebugTreeOnEnter(Found))
    {
        return true;
    }
    GlobalTrigger(Item.TriggerEvent);
    return;
}

defaultproperties
{
    AutoPopulateTriggerList=true
}