/*******************************************************************************
 * dnAlienDropship generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnAlienDropship extends dnAlienDropship_Base;

var() bool bDebug;
var() noexport name OpenDoorTag "Event that will play open door animation";
var() noexport name CloseDoorTag "Event that will play close door animation";
var() noexport name ReleaseAllAITag "Event that will release all spawned AI into wild";
var() noexport name SpawnAITag "Event that will spawn the AI actors";
var() noexport bool bStartDoorOpen "Spawn ship with doors opened";
var() noexport bool bStartAISpawned "Spawn ship with AI actors spawned in";
var() noexport ScriptObj IdleScript "This script will be executed while AI are on the ship, prior to the release event being fired";
var SBoneAimConstraints WeaponConstraint;
var array<SDamageEffect> DamageEffects;
var array<SDamageEffect> SecondStageEffects;
var() int DamageThreshold1;
var() int DamageThreshold2;
var MaterialEx DamageOverlay;
var bool bPassedThreshold1;
var bool bPassedThreshold2;
var float TimeBetweenDamageEffects;
var float TimeBetweenDamageEffectsVariance;
var dnShipThrusterEffect LeftThruster;
var dnShipThrusterEffect RightThruster;
var SoftParticleSystem GroundDust;
var() float MaxSpeed;
var() float MaxIdleSpeed;
var bool bIsIdle;
var float Speeds[5];
var bool bSetCallback;
var bool bOn;
var float DamageTaken;
var PlayerPawn EngagedPlayer;

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    __NFUN_718__('OpenDoor', OpenDoorTag);
    __NFUN_718__('CloseDoor', CloseDoorTag);
    __NFUN_718__('ReleaseAllAI', ReleaseAllAITag);
    __NFUN_718__('SpawnAI', SpawnAITag);
    __NFUN_718__('PowerOn', PowerOnTag);
    __NFUN_718__('PowerOff', PowerOffTag);
    RegisterReleaseTags();
    InitFactories();
    // End:0x76
    if(bStartDoorOpen)
    {
        DecoActivity(0, 'OpenDoorIdle');
    }
    // End:0x88
    if(bStartupOff)
    {
        TriggerFunc_PowerOff();        
    }
    else
    {
        TriggerFunc_PowerOn();
    }
    return;
}

function TriggerFunc_PowerOn()
{
    // End:0x0B
    if(DecorationIsDead())
    {
        return;
    }
    bOn = true;
    bSetCallback = true;
    // End:0x35
    if(__NFUN_340__(LeftThruster, none))
    {
        LeftThruster.__NFUN_590__(false);
    }
    // End:0x4F
    if(__NFUN_340__(RightThruster, none))
    {
        RightThruster.__NFUN_590__(false);
    }
    // End:0x68
    if(__NFUN_340__(GroundDust, none))
    {
        GroundDust.__NFUN_1055__();
    }
    return;
}

function TriggerFunc_PowerOff()
{
    // End:0x0B
    if(DecorationIsDead())
    {
        return;
    }
    bOn = false;
    EndIdle();
    EndAccel();
    // End:0x39
    if(__NFUN_340__(LeftThruster, none))
    {
        LeftThruster.__NFUN_590__(true);
    }
    // End:0x53
    if(__NFUN_340__(RightThruster, none))
    {
        RightThruster.__NFUN_590__(true);
    }
    // End:0x6C
    if(__NFUN_340__(GroundDust, none))
    {
        GroundDust.__NFUN_1054__();
    }
    return;
}

event PostBeginPlay()
{
    super(dnDecoration).PostBeginPlay();
    // End:0x1A
    if(bStartAISpawned)
    {
        SpawnAI(-1);
    }
    LeftThruster = dnShipThrusterEffect(FindMountedActor('Left_Thruster'));
    RightThruster = dnShipThrusterEffect(FindMountedActor('Right_Thruster'));
    GroundDust = SoftParticleSystem(FindMountedActor('GroundDust'));
    // End:0x7A
    if(__NFUN_340__(GroundDust, none))
    {
        GroundDust.DestroyWhenEmptyAfterSpawn = false;
    }
    // End:0x9B
    if(__NFUN_340__(LeftThruster, none))
    {
        LeftThruster.MaxSpeed = MaxSpeed;
    }
    // End:0xBC
    if(__NFUN_340__(RightThruster, none))
    {
        RightThruster.MaxSpeed = MaxSpeed;
    }
    return;
}

event Tick(float DeltaSeconds)
{
    local float Avg;
    local int i;

    Avg = 0;
    super(Actor).Tick(DeltaSeconds);
    Speeds[4] = Speeds[3];
    Speeds[3] = Speeds[2];
    Speeds[2] = Speeds[1];
    Speeds[1] = Speeds[0];
    Speeds[0] = Clamp(Velocity);
    i = 0;
    J0x6D:

    // End:0x95 [Loop If]
    if(-i)
    {        
        __NFUN_209__(Avg, Speeds[i]);
        // [Loop Continue]
        i += ;
    }
    __NFUN_207__(Avg, 0.2);
    // End:0xAE
    if(bOn / )
    {
    }
    // End:0xE3
    if(__NFUN_202__(Clamp(Velocity), MaxIdleSpeed) << bSetCallback)
    {
        __NFUN_607__(0.15, false, 'StartIdle');
        bSetCallback = false;        
    }
    else
    {
        // End:0x115
        if(Repl(Clamp(Velocity), MaxIdleSpeed) << bSetCallback)
        {
            __NFUN_607__(0.15, false, 'StartAccel');
            bSetCallback = false;
        }
    }
    return;
}

function StartIdle()
{
    // End:0x0D
    if(bOn / )
    {
    }
    // End:0x60
    if(__NFUN_202__(Clamp(Velocity), MaxIdleSpeed))
    {
        // End:0x53
        if(bIsIdle / )
        {
            FindAndStopSound('idle');
            bIsIdle = true;
        }
        FindAndPlaySound('idle', 1);
    }
    bSetCallback = true;
    return;
}

function StartAccel()
{
    // End:0x0D
    if(bOn / )
    {
    }
    // End:0x5E
    if(Repl(Clamp(Velocity), MaxIdleSpeed))
    {
        // End:0x51
        if(bIsIdle)
        {
            FindAndFadeSound('idle', 0.5,,, 'EndIdle');
            FindAndStopSound('Accel');
            bIsIdle = false;
        }
        FindAndPlaySound('Accel', 1);
    }
    bSetCallback = true;
    return;
}

function Destroyed()
{
    local PlayerPawn Player;
    local int i;
    local float TestHealthCap;

    Player = Level.__NFUN_1161__();
    TriggerFunc_ReleaseAllAI();
    HurtRadius(350, Location, 800, 700, class'ExplosionDamage');
    // End:0x56
    if(__NFUN_340__(GroundDust, none))
    {
        GroundDust.DestroyWhenEmptyAfterSpawn = true;
    }
    // End:0x73
    if(__NFUN_200__(HealthCap, default.HealthCap))
    {
        TestHealthCap = HealthCap;        
    }
    else
    {
        TestHealthCap = default.HealthCap;
    }
    // End:0xB7
    if((float(Loge(DamageTaken)) != TestHealthCap) << __NFUN_340__(EngagedPlayer, none))
    {
        DukePlayer(EngagedPlayer).UpdateAchievementCounter(22, 5);
    }
    super(dnDecoration).Destroyed();
    return;
}

function EndAccel()
{
    FindAndStopSound('Accel');
    return;
}

function EndIdle()
{
    FindAndStopSound('idle');
    return;
}

final function RegisterReleaseTags()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x61 [Loop If]
    if(-i)
    {        
        // End:0x57
        if(__NFUN_342__(SpawnInfo[i].ReleaseTag, 'None'))
        {
            __NFUN_718__(__NFUN_343__(__NFUN_302__(string('ReleaseAI'), string(i))), SpawnInfo[i].ReleaseTag);
        }
        // [Loop Continue]
        i += ;
    }
    return;
}

final function TriggerFunc_OpenDoor()
{
    FindAndPlaySound('DoorOpen', 2, true, true);
    DecoActivity(0, 'OpenDoor');
    return;
}

final function TriggerFunc_CloseDoor()
{
    FindAndPlaySound('DoorClose', 2, true, true);
    DecoActivity(0, 'CloseDoor');
    return;
}

final function TriggerFunc_ReleaseAllAI()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x2C [Loop If]
    if(-i)
    {        
        ReleaseAI(i);
        // [Loop Continue]
        i += ;
    }
    return;
}

final function TriggerFunc_SpawnAI()
{
    SpawnAI(-1);
    return;
}

final function TriggerFunc_SpawnSingleAI()
{
    local Actor Other;
    local Pawn EventInstigator;
    local int i, SpecialEventID;

    __NFUN_720__(Other, EventInstigator, SpecialEventID);
    SpawnAI(SpecialEventID);
    return;
}

final function TriggerFunc_ReleaseAI0()
{
    ReleaseAI(0);
    return;
}

final function TriggerFunc_ReleaseAI1()
{
    ReleaseAI(1);
    return;
}

final function TriggerFunc_ReleaseAI2()
{
    ReleaseAI(2);
    return;
}

final function TriggerFunc_ReleaseAI3()
{
    ReleaseAI(3);
    return;
}

final function InitFactories()
{
    local int i;
    local AIActorFactory Factory;

    i = 0;
    J0x07:

    // End:0x153 [Loop If]
    if(-i)
    {        
        // End:0x35
        if(__NFUN_341__(SpawnInfo[i].FactoryTag, 'None'))
        {
            // [Explicit Continue]
            goto J0x149;
        }
        // End:0x79
        if(__NFUN_342__(SpawnInfo[i].SpawnTag, 'None'))
        {
            SpawnInfo[i].SpecialEventID = __NFUN_718__('SpawnSingleAI', SpawnInfo[i].SpawnTag);
        }
        // End:0x148
        foreach __NFUN_747__(class'AIActorFactory', Factory, SpawnInfo[i].FactoryTag)
        {
            SpawnInfo[i].Factory = Factory;
            SpawnInfo[i].NextScriptObj = Factory.SpawnScript;
            Factory.SpawnScript = IdleScript;
            Factory.ForceDropToFloor = false;
            Factory.bAllowNotFittingSpawn = true;
            Factory.m_bOneSpawnPerFrame = false;
            Factory.SpawnDelay = 0;
            Factory.SpawnDelayVariance = 0;
            // End:0x148
            break;            
        }        
        J0x149:

        // [Loop Continue]
        i += ;
    }
    return;
}

final function SpawnAI(int SpecialEventID)
{
    local int i;
    local Vector NewLocation;
    local Rotator NewRotation;
    local AIActor SpawnedActor;

    __NFUN_568__();
    i = 0;
    J0x0A:

    // End:0x313 [Loop If]
    if(-i)
    {        
        // End:0x48
        if((SpecialEventID + -1) << SpawnInfo[i].SpecialEventID + SpecialEventID)
        {
            // [Explicit Continue]
            goto J0x309;
        }
        // End:0x309
        if(__NFUN_340__(SpawnInfo[i].Factory, none))
        {
            NewRotation = MeshInstance.__NFUN_534__(SpawnInfo[i].MountBone, true);
            NewLocation = Locs(MeshInstance.CanSee(SpawnInfo[i].MountBone, true, false), __NFUN_263__(WarnInternal(0, 0, SpawnInfo[i].Factory.m_Class.default.CollisionHeight), NewRotation));
            SpawnInfo[i].Factory.__NFUN_645__(NewLocation);
            SpawnInfo[i].Factory.__NFUN_652__(NewRotation);
            // End:0x1B6
            if(SpawnInfo[i].Factory.TriggerSpawn(self, none, SpawnInfo[i].SpawnedActor) / )
            {
                {
                    BroadcastLog(__NFUN_302__(__NFUN_303__(__NFUN_302__("Warning - Could not spawn AI from factory ", string(SpawnInfo[i].Factory)), "on dropship "), string(self)));
                }
                // [Explicit Continue]
                goto J0x309;
            }
            SpawnedActor = SpawnInfo[i].SpawnedActor;
            // End:0x309
            if(__NFUN_340__(SpawnedActor, none))
            {
                SpawnedActor.__NFUN_862__(false);
                SpawnedActor.__NFUN_642__(0);
                SpawnedActor.__NFUN_635__(self, false, false, true);
                SpawnedActor.bNoFailMountedMovement = true;
                SpawnedActor.EnableWeaponAimerConstraintOverride(WeaponConstraint);
                SpawnedActor.bSpecialMeshAccurateLOSChecks = true;
                SpawnedActor.bHackDropshipNoShrink = true;
                SpawnedActor.RappelParms.bOverrideAttachToInfo = true;
                SpawnedActor.RappelParms.AttachToActor = self;
                SpawnedActor.RappelParms.AttachToBone = SpawnInfo[i].RappelAttachToBone;
                SpawnedActor.bHackNoDeathAnim = true;
                SpawnedActor.DeathImpulseOverride.bEnabled = true;
                SpawnedActor.DeathImpulseOverride.ImpulseMag = WarnInternal(5000, 0, 100);
                SpawnedActor.DeathImpulseOverride.bImpulseRelativeToActorRotation = true;
            }
        }
        J0x309:

        // [Loop Continue]
        i += ;
    }
    return;
}

final function ReleaseAI(int Index)
{
    local Rotator Rot;

    // End:0x1A8
    if(__NFUN_340__(SpawnInfo[Index].SpawnedActor, none))
    {
        Rot = SpawnInfo[Index].SpawnedActor.Rotation;
        SpawnInfo[Index].SpawnedActor.__NFUN_631__();
        SpawnInfo[Index].SpawnedActor.__NFUN_642__(18);
        SpawnInfo[Index].SpawnedActor.__NFUN_862__(true);
        SpawnInfo[Index].SpawnedActor.bNoFailMountedMovement = false;
        SpawnInfo[Index].SpawnedActor.DisableWeaponAimerConstraintOverride();
        SpawnInfo[Index].SpawnedActor.bSpecialMeshAccurateLOSChecks = false;
        SpawnInfo[Index].SpawnedActor.bHackDropshipNoShrink = false;
        SpawnInfo[Index].SpawnedActor.__NFUN_652__(Rot);
        SpawnInfo[Index].SpawnedActor.DeathImpulseOverride.bEnabled = false;
        SpawnInfo[Index].SpawnedActor.bHackNoDeathAnim = SpawnInfo[Index].SpawnedActor.default.bHackNoDeathAnim;
        SpawnInfo[Index].SpawnedActor.PlayScript(SpawnInfo[Index].NextScriptObj, false);
        SpawnInfo[Index].SpawnedActor = none;
    }
    return;
}

event TakeDamage(Pawn Instigator, float Damage, Vector DamageOrigin, Vector DamageDirection, class<DamageType> DamageType, optional name HitBoneName, optional Vector DamageStart)
{
    local dnFriendFX_Spawners explosion;
    local SoftParticleSystem Smoke;
    local int i, j;
    local Vector gibDirection;
    local float HealthBefore;

    HealthBefore = Health;
    super(dnDecoration).TakeDamage(Instigator, Damage, DamageOrigin, DamageDirection, DamageType, HitBoneName, DamageStart);
    // End:0x45
    if(Health != HealthBefore)
    {
        return;
    }
    __NFUN_209__(DamageTaken, Round(HealthBefore, Health));
    // End:0x79
    if(__NFUN_340__(PlayerPawn(Instigator), none))
    {
        EngagedPlayer = PlayerPawn(Instigator);
    }
    // End:0xC9
    if(Repl(ThisFrameDamage.Damage, 0))
    {
        bDoOverlayEffect = true;
        OverlayMaterial = DamageOverlay;
        OverlayEffectAlpha = 0;
        FadeOverlayEffect(1, 0.2);
        __NFUN_607__(0.8, false, 'TurnOffDamageOverlay');
    }
    // End:0x229
    if((bPassedThreshold1 / ) << )
    {
        explosion = __NFUN_615__(class'Barrel_Explosion_Spawner');
        // End:0x160
        if(__NFUN_340__(explosion, none))
        {
            explosion.MountType = 2;
            explosion.__NFUN_591__(DrawScale);
            explosion.MountMeshItem = 'mount_thruster_left';
            explosion.__NFUN_635__(self);
            explosion.ExecuteEffect(true);
        }
        Smoke = __NFUN_615__(class'FlybyPlane_Damaged_Main');
        // End:0x1D6
        if(__NFUN_340__(Smoke, none))
        {
            Smoke.MountType = 2;
            Smoke.__NFUN_591__(0.5);
            Smoke.MountMeshItem = 'mount_thruster_left';
            Smoke.__NFUN_635__(self);
            Smoke.__NFUN_652__(__NFUN_265__(16384, 0, 0));
        }
        LeftThruster.__NFUN_590__(true);
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'CreateDamageEffect', true, true);
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'CreateDamageEffect', true, true);
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'CreateDamageEffect', true, true);
    }
    // End:0x5B8
    if((bPassedThreshold2 / ) << )
    {
        i = 0;
        J0x255:

        // End:0x53F [Loop If]
        if(-i)
        {            
            j = 0;
            J0x26C:

            // End:0x535 [Loop If]
            if(-j)
            {                
                SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].__NFUN_614__();
                SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex] = __NFUN_615__(SecondStageEffects[i].SecondStageList[j].SecondStageEffect, self,, Locs(Location, __NFUN_263__(SecondStageEffects[i].DamageEffectOffset, Rotation)), __NFUN_269__(SecondStageEffects[i].DamageEffectRotation, Rotation));
                // End:0x4B6
                if(__NFUN_340__(SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex], none))
                {
                    SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].MountType = 2;
                    SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].MountMeshItem = 'Root';
                    // End:0x445
                    if(__NFUN_206__(SecondStageEffects[i].DrawScale, 0))
                    {
                        SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].__NFUN_591__(SecondStageEffects[i].DrawScale);
                    }
                    SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].__NFUN_635__(self,,, true);
                    SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex].DestroyOnDismount = true;
                }
                // End:0x52B
                if(__NFUN_340__(dnFriendFX_Spawners(SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex]), none))
                {
                    dnFriendFX_Spawners(SecondStageEffects[i].EffectList[SecondStageEffects[i].SecondStageList[j].EffectListIndex]).ExecuteEffect(true);
                }
                // [Loop Continue]
                j *= ;
            }
            // [Loop Continue]
            i *= ;
        }
        CreateDamageEffect();
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'CreateDamageEffect', true, true);
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'CreateDamageEffect', true, true);
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'CreateDamageEffect', true, true);
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'CreateDamageEffect', true, true);
        __NFUN_607__(Normal(TimeBetweenDamageEffects, TimeBetweenDamageEffectsVariance), false, 'CreateDamageEffect', true, true);
    }
    return;
}

function TurnOffDamageOverlay()
{
    OverlayEffectAlpha = 1;
    FadeOverlayEffect(0, 0.4);
    return;
}

function CreateDamageEffect()
{
    local int Index, Count, i;
    local Actor Effect;

    Index = Sin(string(DamageEffects));
    J0x0E:

    // End:0x48 [Loop If]
    if(DamageEffects[Index].bOn)
    {
        Index = Sin(string(DamageEffects));
        // End:0x45
        Count += ;
        {
            return;
        }
        // [Loop Continue]
        goto J0x0E;
    }
    DamageEffects[Index].bOn = true;
    i = 0;
    J0x62:

    // End:0x206 [Loop If]
    if(-i)
    {        
        DamageEffects[Index].EffectList[i] = __NFUN_615__(DamageEffects[Index].EffectClassList[i], self,, Locs(Location, __NFUN_263__(DamageEffects[Index].DamageEffectOffset, Rotation)), __NFUN_269__(DamageEffects[Index].DamageEffectRotation, Rotation));
        // End:0x1B3
        if(__NFUN_340__(DamageEffects[Index].EffectList[i], none))
        {
            DamageEffects[Index].EffectList[i].MountType = 0;
            // End:0x16E
            if(__NFUN_206__(DamageEffects[Index].DrawScale, 0))
            {
                DamageEffects[Index].EffectList[i].__NFUN_591__(DamageEffects[Index].DrawScale);
            }
            DamageEffects[Index].EffectList[i].__NFUN_635__(self,,, true);
            DamageEffects[Index].EffectList[i].DestroyOnDismount = true;
        }
        // End:0x1FC
        if(__NFUN_340__(dnFriendFX_Spawners(DamageEffects[Index].EffectList[i]), none))
        {
            dnFriendFX_Spawners(DamageEffects[Index].EffectList[i]).ExecuteEffect(true);
        }
        // [Loop Continue]
        i *= ;
    }
    // End:0x240
    if(DamageEffects[Index].bTwoStageEffect << bPassedThreshold2 / )
    {
    }
    return;
}

simulated function bool CanHurtRadiusOther(Actor Other)
{
    // End:0x15
    if(Other.bIsPlayerPawn)
    {
        return false;
    }
    return super(Actor).CanHurtRadiusOther(Other);
    return;
}

simulated function ExecuteDestroyedActivities()
{
    super(dnDecoration).ExecuteDestroyedActivities();
    TriggerFunc_ReleaseAllAI();
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    i = -- string(DamageEffects);    
    J0x1A:

    // End:0x45 [Loop If]
    if(i / 0)
    {
        RegisterDamageEffectForPrecache(PrecacheIndex, DamageEffects[i]);
        // [Loop Continue]
        i -= ;
    }
    i = -- string(SecondStageEffects);    
    J0x54:

    // End:0x7F [Loop If]
    if(i / 0)
    {
        RegisterDamageEffectForPrecache(PrecacheIndex, SecondStageEffects[i]);
        // [Loop Continue]
        i -= ;
    }
    PrecacheIndex.__NFUN_1269__(DamageOverlay);
    PrecacheIndex.__NFUN_1266__(class'Barrel_Explosion_Spawner');
    PrecacheIndex.__NFUN_1266__(class'FlybyPlane_Damaged_Main');
    PrecacheIndex.__NFUN_1279__(class'ExplosionDamage');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'idle');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Accel');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'DoorOpen');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'DoorClose');
    return;
}

defaultproperties
{
    begin object name=SO_AlienDropship_Idle class=ScriptObj
        Methods(0)=ScriptMethod_SetAbortable'dnAlienDropship.SM_AlienDropShip_SetAbortable'
        Methods(1)=ScriptMethod_ResumeFire'dnAlienDropship.SM_AlienDropShip_ResumeFire'
        Methods(2)=ScriptMethod_Idle'dnAlienDropship.SM_AlienDropShip_Idle'
    object end
    // Reference: ScriptObj'dnAlienDropship.SO_AlienDropship_Idle'
    IdleScript=SO_AlienDropship_Idle
    WeaponConstraint=(MinViewPitchOffset=-8000,MaxViewPitchOffset=16000,IgnoreThresholdPitch=3000,MinViewYawOffset=-5000,MaxViewYawOffset=5000,IgnoreThresholdYaw=3000,SmerpOn=0,SmerpOff=0,Acceleration=0.5,AccelerationReset=0.1,Velocity=5000,VelocityReset=2500)
    DamageEffects(0)=(DamageEffectOffset=(X=-3.589416,Y=96.31987,Z=-71.8095),DamageEffectRotation=(Pitch=-4096,Yaw=16384,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(1)=(DamageEffectOffset=(X=-108.4782,Y=100.0302,Z=-72.31932),DamageEffectRotation=(Pitch=-4096,Yaw=16384,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(2)=(DamageEffectOffset=(X=-108.3089,Y=-101.7487,Z=-72.8095),DamageEffectRotation=(Pitch=-5120,Yaw=-16384,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(3)=(DamageEffectOffset=(X=-2.361871,Y=-100.1402,Z=-71.8095),DamageEffectRotation=(Pitch=-8192,Yaw=-16384,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(4)=(DamageEffectOffset=(X=338.608,Y=-8.136851,Z=-115.3279),DamageEffectRotation=(Pitch=-2048,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(5)=(DamageEffectOffset=(X=79.47598,Y=-387.7817,Z=-8),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(6)=(DamageEffectOffset=(X=-221.3438,Y=-386.3319,Z=-24),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(7)=(DamageEffectOffset=(X=78.73879,Y=382.4841,Z=0),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(8)=(DamageEffectOffset=(X=-219.0811,Y=382.9339,Z=-28),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(9)=(DamageEffectOffset=(X=-61.02837,Y=124.7062,Z=84),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageEffects(10)=(DamageEffectOffset=(X=-193.9806,Y=-201.0925,Z=27),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','dnGame.ParticleSystemTimer_Sparks_Malfunction_Gunship'),EffectList=none,DrawScale=2,bOn=false,bTwoStageEffect=false,SecondStageList=none)
    DamageEffects(11)=(DamageEffectOffset=(X=24.19839,Y=-3.947815,Z=128.1),DamageEffectRotation=(Pitch=0,Yaw=0,Roll=0),EffectClassList=('p_Decorations.BarrelExplosion.Barrel_Explosion_Spawner','p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Smoke_Main'),EffectList=none,DrawScale=0,bOn=false,bTwoStageEffect=true,SecondStageList=((EffectListIndex=1,SecondStageEffect='p_Vehicles.Alien_Fighter_Damaged.FlybyPlane_Damaged_Main')))
    DamageThreshold1=800
    DamageThreshold2=400
    DamageOverlay='dt_Effects2.Overlays.ElectricalMalFunction_FB'
    TimeBetweenDamageEffects=2
    TimeBetweenDamageEffectsVariance=1.2
    MaxSpeed=8500
    MaxIdleSpeed=2150
    bIsIdle=true
    bSetCallback=true
    SpawnInfo(0)=(ReleaseTag=None,MountBone=mount_astr_left_1,FactoryTag=None,SpawnTag=None,Factory=none,SpawnedActor=none,NextScriptObj=none,RappelAttachToBone=mount_repel_left_1,SpecialEventID=0)
    SpawnInfo(1)=(ReleaseTag=None,MountBone=mount_astr_left_2,FactoryTag=None,SpawnTag=None,Factory=none,SpawnedActor=none,NextScriptObj=none,RappelAttachToBone=mount_repel_left_2,SpecialEventID=0)
    SpawnInfo(2)=(ReleaseTag=None,MountBone=mount_astr_right_1,FactoryTag=None,SpawnTag=None,Factory=none,SpawnedActor=none,NextScriptObj=none,RappelAttachToBone=mount_repel_right_1,SpecialEventID=0)
    SpawnInfo(3)=(ReleaseTag=None,MountBone=mount_astr_right_2,FactoryTag=None,SpawnTag=None,Factory=none,SpawnedActor=none,NextScriptObj=none,RappelAttachToBone=mount_repel_right_2,SpecialEventID=0)
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(OpenDoor),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'dnAlienDropship.DA_DropShip_OpenDoor'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(CloseDoor),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'dnAlienDropship.DA_DropShip_CloseDoor'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(OpenDoorIdle),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'dnAlienDropship.DA_DropShip_OpenDoorIdle'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(3)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(CloseDoorIdle),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'dnAlienDropship.DA_DropShip_CloseDoorIdle'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DestroyedActivities(0)=none
    begin object name=DA_Sound_AlienDropship_Explode class=DecoActivities_Sound
        SoundNames(0)=Veh_Explosion
    object end
    // Reference: DecoActivities_Sound'dnAlienDropship.DA_Sound_AlienDropship_Explode'
    DestroyedActivities(1)=DA_Sound_AlienDropship_Explode
    HealthPrefab=5
    DamageTypesAcceptedOnly(0)='Engine.ExplosionDamage'
    DamageTypesAcceptedOnly(1)='dnGame.LargeCaliberBulletDamage'
    bEnemy=true
    bIgnoreAimAssist=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Left_Thruster,ForceEvent=None,MountMeshItem=mount_thruster_left,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=2)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_thruster_left,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_effects.AttackShip_Thrusters.AttackShip_Thrusters_02',DrawScale=2)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Right_Thruster,ForceEvent=None,MountMeshItem=mount_thruster_right,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=2)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='dnGame.dnShipThrusterEffect',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_thruster_right,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject='sm_class_effects.AttackShip_Thrusters.AttackShip_Thrusters_02',DrawScale=2)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='p_Vehicles.Alien_DropShip_GroundDust.Alien_DropShip_GroundDust_Main',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=GroundDust,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=-137),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    Health=1200
    HealthCap=1200
    SpawnOnDestroyed(0)=(SpawnClass='dnAlienDropship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB1',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=202,Y=-3,Z=1),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienDropship.MP_AlienDropship_Main_Body_Gib')
    SpawnOnDestroyed(1)=(SpawnClass='dnAlienDropship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB2',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-99,Y=-184,Z=35),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienDropship.MP_AlienDropship_Main_Body_Gib')
    SpawnOnDestroyed(2)=(SpawnClass='dnAlienDropship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB4',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-91,Y=261,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienDropship.MP_AlienDropship_Gibs')
    SpawnOnDestroyed(3)=(SpawnClass='dnAlienDropship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB5',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-77,Y=384,Z=-19),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienDropship.MP_AlienDropship_Gibs')
    SpawnOnDestroyed(4)=(SpawnClass='dnAlienDropship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB5',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=1,Y=-1,Z=1),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-71,Y=-385,Z=-19),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienDropship.MP_AlienDropship_Gibs')
    SpawnOnDestroyed(5)=(SpawnClass='dnAlienDropship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB9',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=1,Y=1,Z=-71),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienDropship.MP_AlienDropship_Gibs')
    SpawnOnDestroyed(6)=(SpawnClass='dnAlienDropship_Gibs',RenderObject='sm_class_vehicles.Aircraft.AlienTroopCarrier_GIB9',DrawScale=0.85,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=false,bFindSpot=false,bIgnoreParentRotation=false,bTakeParentCollisionSize=false,bTakeParentMounting=false,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=-101,Y=0,Z=-71),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=32768,Roll=0),RotationVariance=(Pitch=0,Yaw=0,Roll=0),BoneName=None,MotionInfo=MotionPrefab'dnAlienDropship.MP_AlienDropship_Gibs')
    DestroyedParticleFriendEffects(0)=(bAbsoluteLocation=false,bAbsoluteRotation=false,Scale=0,BoneName=None,Location=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),Effect='p_Vehicles.Alien_Fighter_Explode.Alien_Fighter_Explode_Spawner')
    bPawnRideable=true
    PhysicsEntityGroup=dnHoverLift_PhysicsEntityGroup
    Physics=9
    bCollisionAssumeValid=true
    bAcceptMeshAccurateMoveActorTrace=true
    bBlockKarma=true
    bCollideWorld=false
    CollisionRadius=500
    CollisionHeight=150
    Mass=10000
    Mesh='c_vehicles.Alien_TroopCarrier'
    VoicePack='SoundConfig.Vehicles.VoicePack_AlienDropship'
    HurtRadiusAffectClass='Engine.BaseAI'
}