/*******************************************************************************
 * Containers_Pots generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Containers_Pots extends Containers_Generic
    abstract
    collapsecategories;

var() noexport float DirtHeight "How high the dirt is from the center of the pot.";
var array<Plants_Generic_Potted> plants;

function PostVerifySelf()
{
    local float DrawScaleDifference, ScaledDirtHeight;
    local Vector DrawScale3DDifference, PlantDesiredLocation;
    local Plants_Generic_Potted NewPlant;

    super(dnDecoration).PostVerifySelf();
    __NFUN_594__(DrawScaleDifference, DrawScale3DDifference);
    __NFUN_207__(DrawScaleDifference, DrawScale3DDifference.Z);
    ScaledDirtHeight = FRand(DrawScaleDifference, DirtHeight);
    // End:0xD4
    foreach __NFUN_747__(class'Plants_Generic_Potted', NewPlant, 'Plant', true)
    {
        // End:0xD3
        if(__NFUN_339__(NewPlant.Owner, self))
        {
            plants[plants.Add(1)] = NewPlant;
            PlantDesiredLocation = NewPlant.Location;
            PlantDesiredLocation.Z = (Location.Z *= ScaledDirtHeight) *= FRand(DrawScaleDifference, NewPlant.default.CollisionHeight);
            NewPlant.PositionProperly(PlantDesiredLocation);
        }        
    }    
    return;
}

function Destroyed()
{
    local int i;

    super(dnDecoration).Destroyed();
    i = 0;
    J0x0D:

    // End:0x3D [Loop If]
    if(-i)
    {        
        plants[i].CriticalDamage();
        // [Loop Continue]
        i += ;
    }
    return;
}

defaultproperties
{
    bSurviveDeath=true
    DestroyedActivities(0)=none
    DestroyedActivities(1)='dnGame.DecoActivityDeclarations.DA_Sound_Destroyed_Generic'
    DestroyedActivities(2)='dnGame.DecoActivityDeclarations.DA_Physics_PHYS_Karma_Set'
    begin object name=DA_Interact_Containers_Pots_Brkn class=DecoActivities_Interaction
        bNewDynamicInteractionClassification=true
        NewDynamicInteractionClassification=1
    object end
    // Reference: DecoActivities_Interaction'Containers_Pots.DA_Interact_Containers_Pots_Brkn'
    DestroyedActivities(3)=DA_Interact_Containers_Pots_Brkn
    HealthPrefab=1
    DamageThreshold=5
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Plants_Generic_Potted_A',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Plant,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    SpawnOnDestroyedSimple(0)='dnParticles.dnDebris_Dirt1'
    SpawnOnDestroyedSimple(1)='dnParticles.dnDebris_Smoke_Dirt1'
    SpawnOnDestroyed(0)=(SpawnClass='Details_Generic_DirtPile_A',RenderObject=none,DrawScale=0,DrawScaleVariance=0,DrawScale3D=(X=0,Y=0,Z=0),SpawnChance=0,SpawnCopies=0,SpawnCopiesVariance=0,bIgnorePawnAirCushion=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bNoCollision=true,bFindSpot=false,bIgnoreParentRotation=true,bTakeParentCollisionSize=false,bTakeParentMounting=true,bTakeParentActorColors=false,bTakeParentSkins=false,Offset=(X=0,Y=0,Z=0),OffsetVariance=(X=0,Y=0,Z=0),Rotation=(Pitch=0,Yaw=0,Roll=0),RotationVariance=(Pitch=0,Yaw=65535,Roll=0),BoneName=None,MotionInfo=MotionPrefab'Containers_Pots.MotionPrefab_Containers_Pots')
    PhysicsMassType=1
    PhysicsEntityGroup=PlantPotsPhysicsEntityGroup
    Mass=20
    VoicePack='SoundConfig.Interactive.VoicePack_LadyKiller'
}