/*******************************************************************************
 * Details_Balls_PoolBall generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Details_Balls_PoolBall extends Details_Generic
    collapsecategories;

var() noexport dnGame.aFinalDecoration.EPoolBall PoolBall "The ball in the set that this is a part of.";
var bool bInUse;
var MaterialEx BallMaterials[16];

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    SetPoolBall(PoolBall);
    return;
}

final function SetPoolBall(dnGame.aFinalDecoration.EPoolBall NewBall)
{
    PoolBall = NewBall;
    switch(PoolBall)
    {
        // End:0x34
        case 0:
            SetBallSettings("Cue", int(PoolBall));
            bUsable = true;
            // End:0x243
            break;
        // End:0x55
        case 1:
            SetBallSettings("One", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x76
        case 2:
            SetBallSettings("Two", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x99
        case 3:
            SetBallSettings("Three", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0xBB
        case 4:
            SetBallSettings("Four", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0xDD
        case 5:
            SetBallSettings("Five", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0xFE
        case 6:
            SetBallSettings("Six", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x121
        case 7:
            SetBallSettings("Seven", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x144
        case 8:
            SetBallSettings("Eight", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x166
        case 9:
            SetBallSettings("Nine", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x187
        case 10:
            SetBallSettings("Ten", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x1AB
        case 11:
            SetBallSettings("Eleven", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x1CF
        case 12:
            SetBallSettings("Twelve", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x1F5
        case 13:
            SetBallSettings("Thirteen", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x21B
        case 14:
            SetBallSettings("Fourteen", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0x240
        case 15:
            SetBallSettings("Fifteen", int(PoolBall));
            bUsable = false;
            // End:0x243
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

final function SetBallSettings(string BallName, int MaterialIndex)
{
    __NFUN_741__(0, BallMaterials[MaterialIndex]);
    return;
}

final function InitBall()
{
    // End:0x1E
    if(__NFUN_340__(CarriedBy, none))
    {
        CarriedBy.DropCarriedActor(, true);
    }
    bInUse = true;
    DecoActivity(0, 'InitBall');
    return;
}

final function ShowBall(Actor Table, Vector Position, float YOffset, float xOffset)
{
    InitBall();
    MountType = 0;
    MountOrigin = WarnInternal(Position.X *= xOffset, Position.Y *= YOffset, Position.Z);
    MountAngles = __NFUN_265__(Sin(65536), Sin(65536), 0);
    __NFUN_635__(Table);
    __NFUN_631__();
    DecoActivity(0, 'ShowBall');
    __NFUN_818__();
    __NFUN_817__();
    TickStyle = 3;
    __NFUN_605__(1, false, 'NormalTicking');
    return;
}

final function NormalTicking()
{
    TickStyle = default.TickStyle;
    return;
}

final function HideBall()
{
    InitBall();
    DecoActivity(0, 'HideBall');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    i = 0;
    J0x12:

    // End:0x40 [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1269__(BallMaterials[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

defaultproperties
{
    BallMaterials[0]='smt_skins5.PoolBalls.PoolBall_cue'
    BallMaterials[1]='smt_skins5.PoolBalls.PoolBall_one'
    BallMaterials[2]='smt_skins5.PoolBalls.PoolBall_two'
    BallMaterials[3]='smt_skins5.PoolBalls.PoolBall_three'
    BallMaterials[4]='smt_skins5.PoolBalls.PoolBall_four'
    BallMaterials[5]='smt_skins5.PoolBalls.PoolBall_five'
    BallMaterials[6]='smt_skins5.PoolBalls.PoolBall_six'
    BallMaterials[7]='smt_skins5.PoolBalls.PoolBall_seven'
    BallMaterials[8]='smt_skins5.PoolBalls.PoolBall_eight'
    BallMaterials[9]='smt_skins5.PoolBalls.PoolBall_nine'
    BallMaterials[10]='smt_skins5.PoolBalls.PoolBall_ten'
    BallMaterials[11]='smt_skins5.PoolBalls.Poolball_eleven'
    BallMaterials[12]='smt_skins5.PoolBalls.PoolBall_twelve'
    BallMaterials[13]='smt_skins5.PoolBalls.PoolBall_thirteen'
    BallMaterials[14]='smt_skins5.PoolBalls.PoolBall_fourteen'
    BallMaterials[15]='smt_skins5.PoolBalls.PoolBall_fifteen'
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=none,ActivityID=(3,1),ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_KarmaImpulse'Details_Balls_PoolBall.DA_KImpulse_Details_Balls_PoolBall_Used',DecoActivities_HUDInfo'Details_Balls_PoolBall.DA_HUDInfo_Details_Balls_PoolBall_Used'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=1),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(InitBall),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Physics_PHYS_None_Set',DecoActivities_Collision'Details_Balls_PoolBall.DA_Collision_Details_Balls_PoolBall_Off'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(HideBall),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Display_Hide'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(3)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(ShowBall),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Display_Show',DecoActivities_Collision'Details_Balls_PoolBall.DA_Collision_Details_Balls_PoolBall_On','dnGame.DecoActivityDeclarations.DA_Physics_PHYS_Karma_Set'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    HealthPrefab=0
    bForceUsePhrase=true
    UsePhrase="<?int?dnDecorations.Details_Balls_PoolBall.UsePhrase?>"
    bTickOnlyWhenPhysicsAwake=true
    KRestitution=0.99
    KLinearDamping=0.15
    KAngularDamping=0.15
    EnableDisableThreshold=0.3
    PhysicsSoundOverrides(0)=(SoundType=0,OtherMaterialTypes=('dnMaterial.dnPhysicsMaterial_Wood_Solid'),OtherMassTypes=none,Sounds=none,SoundInfo=(InputRange=(Min=0,Max=0),OutputPitchRange=(Min=0,Max=0),OutputVolumeRange=(Min=0,Max=0)),bDisableSoundInWater=false)
    PhysicsSoundOverrides(1)=(SoundType=0,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=('a_impact.Billiards.Pool_BallsImpact01','a_impact.Billiards.Pool_BallsImpact02'),SoundInfo=(InputRange=(Min=30,Max=200),OutputPitchRange=(Min=1,Max=1),OutputVolumeRange=(Min=0.5,Max=1)),bDisableSoundInWater=true)
    Physics=18
    bBlockPlayers=false
    CollisionRadius=1.54
    CollisionHeight=1.54
    Mass=10
    TickStyle=2
    DrawScale=1.2
    StaticMesh='sm_class_decorations.PoolTable.PoolBall'
}