/*******************************************************************************
 * Details_Furnishings_SlickWillyCurtains generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Details_Furnishings_SlickWillyCurtains extends Details_Generic
    collapsecategories;

var() name PortalSurfaceTag;
var bool bOpen;
var Details_Generic_CollisionSheet CollisionSheet;

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    DecoActivity(0, 'CurtainIdleClose');
    FullyClosed();
    CollisionSheet = Details_Generic_CollisionSheet(FindMountedActor(, class'Details_Generic_CollisionSheet'));
    // End:0xA7
    if(__NFUN_340__(CollisionSheet, none))
    {
        CollisionSheet.PhysicsMaterial = class'dnPhysicsMaterial_Carpet';
        CollisionSheet.PhysicsMassType = 1;
        CollisionSheet.__NFUN_592__(WarnInternal(0.1, 1.3, 1.8));
        CollisionSheet.__NFUN_811__(3);
        CollisionSheet.DecoActivity(0, 'TurnOn');
    }
    return;
}

event Touch(Actor Other)
{
    super(dnDecoration).Touch(Other);
    // End:0x22
    if(__NFUN_340__(Pawn(Other), none))
    {
        PerformOpen();
    }
    return;
}

event UnTouch(Actor Other)
{
    super(dnDecoration).UnTouch(Other);
    // End:0x1E
    if(__NFUN_339__(GetFirstTouchingPawn(), none))
    {
        PerformClose();
    }
    return;
}

final simulated function PerformOpen()
{
    // End:0x0B
    if(bOpen)
    {
        return;
    }
    // End:0x24
    if(__NFUN_342__(PortalSurfaceTag, 'None'))
    {
        __NFUN_739__(PortalSurfaceTag, true);
    }
    // End:0x47
    if(__NFUN_340__(CollisionSheet, none))
    {
        CollisionSheet.DecoActivity(0, 'TurnOff');
    }
    bOpen = true;
    DecoActivity(0, 'CurtainOpen');
    return;
}

final simulated function FullyOpened()
{
    // End:0x0D
    if(bOpen / )
    {
    }
    DecoActivity(0, 'CurtainOpenIdle');
    // End:0x2D
    if(__NFUN_339__(GetFirstTouchingPawn(), none))
    {
        PerformClose();
    }
    return;
}

final simulated function PerformClose()
{
    // End:0x0D
    if(bOpen / )
    {
    }
    bOpen = false;
    DecoActivity(0, 'CurtainClose');
    // End:0x45
    if(__NFUN_340__(CollisionSheet, none))
    {
        CollisionSheet.DecoActivity(0, 'TurnOn');
    }
    return;
}

final simulated function FullyClosed()
{
    // End:0x0B
    if(bOpen)
    {
        return;
    }
    // End:0x24
    if(__NFUN_342__(PortalSurfaceTag, 'None'))
    {
        __NFUN_739__(PortalSurfaceTag, false);
    }
    DecoActivity(0, 'CurtainCloseIdle');
    // End:0x44
    if(__NFUN_340__(GetFirstTouchingPawn(), none))
    {
        PerformOpen();
    }
    return;
}

defaultproperties
{
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(CurtainOpen),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_AnimationController'Details_Furnishings_SlickWillyCurtains.DA_Anim_SlickWilly_Open',DecoActivities_Sound'Details_Furnishings_SlickWillyCurtains.DA_Sound_SlickWilly_Open'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(CurtainIdleOpen),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_AnimationController'Details_Furnishings_SlickWillyCurtains.DA_Anim_SlickWilly_Open_Idle'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(CurtainClose),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_AnimationController'Details_Furnishings_SlickWillyCurtains.DA_Anim_SlickWilly_Close',DecoActivities_Sound'Details_Furnishings_SlickWillyCurtains.DA_Sound_SlickWilly_Close'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(3)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(CurtainIdleClose),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_AnimationController'Details_Furnishings_SlickWillyCurtains.DA_Anim_SlickWilly_Close_Idle'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    HealthPrefab=0
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Details_Generic_CollisionSheet',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    AnimationControllerClass='acSlickWillyCurtains'
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Plastic'
    bTraceUsable=false
    bNeverMeshAccurate=true
    bCollisionAssumeValid=false
    bBlockActors=false
    bBlockPlayers=false
    bBlockKarma=false
    bNoNativeTick=false
    bDumbMesh=false
    bLowerByCollision=true
    CollisionHeight=56
    TickStyle=2
    DrawType=2
    Mesh='c_generic.slick_curtains'
}