/*******************************************************************************
 * Details_Generic_Frisbee generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Details_Generic_Frisbee extends Details_Generic
    collapsecategories;

var() noexport float InitialThrust "Initial force given to object when thrown.";
var() noexport float SpinVelocity "Initial angular velocity around the Z axis of the frisbee when thrown.";
var() noexport int RollVariance "Variance on the roll of the initial rotation of the frisbee when thrown.";

function float GetImpulseStrength_Throwing(Pawn Thrower, float BaseStrength, float HeldTime)
{
    return FRand(InitialThrust, ThrowForceScale);
    return;
}

simulated function Rotator AdjustDropDirection_Throwing(Pawn Thrower, Rotator DropDirection)
{
    local Rotator Variance;

    Variance.Roll = RollVariance;
    // End:0x45
    if(Thrower.bIsPlayerPawn)
    {
        __NFUN_652__(GetStateName(PlayerPawn(Thrower).CalcedViewRotation, Variance));        
    }
    else
    {
        __NFUN_652__(GetStateName(Thrower.ViewRotation, Variance));
    }
    return Rotation;
    return;
}

simulated function Vector AdjustAngularVelocity_Throwing(Pawn Thrower, Vector CurrentAngularVelocity)
{
    return WarnInternal(0, 0, SpinVelocity);
    return;
}

simulated function UnGrabbed(Pawn Grabber, bool Thrown)
{
    super(dnDecoration).UnGrabbed(Grabber, Thrown);
    // End:0x44
    if(Thrown << __NFUN_340__(DukePlayer(Grabber), none))
    {
        DukePlayer(Grabber).GivePermanentEgoCapAward(13);
    }
    return;
}

defaultproperties
{
    InitialThrust=600
    SpinVelocity=200
    RollVariance=548
    HealthPrefab=0
    bGrabbable=true
    UsePhrase="<?int?dnDecorations.Details_Generic_Frisbee.UsePhrase?>"
    GrabInfo=(bCanDuckWhileHeld=true,MountItemOverride=mount_handright,MountOrigin=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),GrabAnimName=None,CarrierAnimName=CarryFrisbee,CarrierMountPose=CarryPoseFrisbee,GrabSoundName=None,ThrowSoundName=None,GrabSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),ThrowSoundInfo=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none))
    ThrowForceScale=0.5
    bIgnorePawnDownwardForce=true
    bCanCrushOthers=false
    bTickOnlyWhenPhysicsAwake=true
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Plastic'
    PhysicsMassType=1
    KFriction=0.9
    KRestitution=0.1
    KAngularDamping=0.2
    EnableDisableThreshold=0.005
    begin object name=PA_Frisbee class=PhysicsAction_Frisbee
        LiftCoeffecient=0.9
    object end
    // Reference: PhysicsAction_Frisbee'Details_Generic_Frisbee.PA_Frisbee'
    PhysicsActions(0)=PA_Frisbee
    Physics=18
    CollisionRadius=7.5
    CollisionHeight=0.5
    Mass=5
    StaticMesh='sm_class_decorations.frisbee.low_frisbee'
}