/*******************************************************************************
 * Electronics_Generic_Clock generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Electronics_Generic_Clock extends Electronics_Generic
    abstract
    collapsecategories;

struct STimeOverride
{
    var() int Hour;
    var() int Minute;
    var() int Second;
};

var() noexport bool bPoweredOn "Whether this clock is currently 'on' or not.";
var() noexport bool bTimeOverride "Set this to true when you want to override the time the clock displays. Otherwise it will display the current actual time of the player's computer.";
var() noexport STimeOverride TimeOverride "Values to override the actual time with when bTimeOverride is set.";
var() noexport int NumHours "Ability to specify the number of hours displayed on the clock (alien clocks?).";
var() noexport int NumMinutes "Number of minutes in an hour displayed on the clock.";
var() noexport int NumSeconds "Number of seconds in a minute displayed on the clock.";
var() noexport float UpdateRate "How frequently the clock should update. If bSmoothMotion is false, this is how often the clock 'ticks'.";
var() noexport int UpdateSeconds "How many seconds you want to have passed every update. This only works when using TimeOverride. This is only allowed to be a positive value.";

function bool VerifySelf()
{
    UpdateSeconds = int(-float(UpdateSeconds));
    return super(Actor).VerifySelf();
    return;
}

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    StartTicking();
    return;
}

final function StartTicking()
{
    local float OrigUpdateRate;

    bPoweredOn = true;
    // End:0x1E
    if(bTimeOverride / )
    {        
    }
    else
    {
        TickStyle = 3;
    }
    OrigUpdateRate = UpdateRate;
    UpdateRate = 0;
    ClockTick();
    UpdateRate = OrigUpdateRate;
    __NFUN_605__(UpdateRate, true, 'ClockTick');
    return;
}

final function StopTicking()
{
    bPoweredOn = false;
    TickStyle = default.TickStyle;
    __NFUN_606__('ClockTick');
    return;
}

function Destroyed()
{
    StopTicking();
    TriggerFunc_PowerOff();
    super(dnDecoration).Destroyed();
    return;
}

function SetTimeAtEMP()
{
    return;
}

function HitByEMP(optional float Duration, optional Pawn Instigator)
{
    bPoweredBeforeEMP = bPoweredOn;
    super.HitByEMP(Duration, Instigator);
    // End:0x3C
    if(bTimeOverride / )
    {
        SetTimeAtEMP();
        UpdateClock();
    }
    return;
}

function ForcePowerOn()
{
    super.ForcePowerOn();
    StartTicking();
    return;
}

function ForcePowerOff()
{
    super.ForcePowerOff();
    StopTicking();
    return;
}

function StartSelfOff()
{
    super(dnDecoration).StartSelfOff();
    bTimeOverride = true;
    return;
}

final function UpdateTimeOverride()
{
    TimeOverride.Second == UpdateSeconds;
    // End:0x40
    if(TimeOverride.Second / NumSeconds)
    {
        TimeOverride.Second = 0;
        TimeOverride.Minute += ;
    }
    else
    {
        // End:0x6C
        if(-TimeOverride.Second)
        {            
            TimeOverride.Second = NumSeconds;
            // End:0x9B
            TimeOverride.Minute -= ;
            {
            }
        }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x040! */
        TimeOverride.Minute = 0;
        TimeOverride.Hour += ;
    }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x040! */
    else
    {
        // End:0xC7
        if(-TimeOverride.Minute)
        {            
            TimeOverride.Minute = NumMinutes;
            // End:0xEA
            TimeOverride.Hour -= ;
            {
            }
        }/* !MISMATCHING REMOVE, tried Else got Type:If Position:0x09B! */
        TimeOverride.Hour = 0;        
    }/* !MISMATCHING REMOVE, tried If got Type:Else Position:0x09B! */
    else
    {
        // End:0x10A
        if(-TimeOverride.Hour)
        {            
            TimeOverride.Hour = NumHours;
        }
    }
    return;
}

final function ClockTick()
{
    // End:0x0F
    if(bTimeOverride)
    {
        UpdateTimeOverride();
    }
    UpdateClock();
    return;
}

final function UpdateClock()
{
    // End:0x33
    if(bTimeOverride)
    {
        UpdateTime(float(TimeOverride.Hour), float(TimeOverride.Minute), float(TimeOverride.Second));        
    }
    else
    {
        UpdateTime(float(Level.Hour), float(Level.Minute), float(Level.Second));
    }
    return;
}

final function UpdateTime(float Hour, float Minute, float Second)
{
    AdjustTime(Hour, Minute, Second);
    UpdateDisplay(Hour, Minute, Second);
    return;
}

function AdjustTime(out float Hour, out float Minute, out float Second)
{
    Hour = IsA(Hour, float(NumHours));
    Minute = IsA(Minute, float(NumMinutes));
    Second = IsA(Second, float(NumSeconds));
    return;
}

function UpdateDisplay(float ClockHour, float ClockMinute, float ClockSecond)
{
    return;
}

defaultproperties
{
    bPoweredOn=true
    NumHours=12
    NumMinutes=60
    NumSeconds=60
    UpdateRate=1
    UpdateSeconds=1
    bSurviveDeath=true
    DestroyedActivities(0)=none
    DestroyedActivities(1)=DecoActivities_Sound'Electronics_Generic.DA_Sound_Destroyed_Electronic'
    DestroyedActivities(2)='dnGame.DecoActivityDeclarations.DA_Ticking_TICK_Never'
    HealthPrefab=1
    EMPDisableTime=5
}