/*******************************************************************************
 * Electronics_Generic_Computer_CPU generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Electronics_Generic_Computer_CPU extends Electronics_Generic_Computer
    abstract
    collapsecategories
    dependson(Electronics_Generic_Computer_Keyboard)
    dependson(Electronics_Generic_Computer_Mouse)
    dependson(Electronics_Generic_Computer_Monitor);

var() noexport float RatioBSODInput "How frequently the computer will BSOD while receiving user input.";
var() noexport float RatioBSODRandom "How frequently the computer will BSOD just randomly while sitting there.";
var() noexport float RatioBSODBootup "How frequently the computer will BSOD while booting up.";
var() noexport float RatioBSODShutdown "How frequently the computer will BSOD while powering down.";
var() noexport float RateBSODRandom "How often to check for a random BSOD while the computer is on.";
var() float RateBSODRandomVariance;
var() noexport float TimePowerUp "How long it takes for the computer to power up.";
var() noexport float TimePowerDown "How long it takes for the computer to power down.";
var() noexport float TimeBSODPowerHold "How long the player has to hold the power button down when the computer BSOD's before it will reboot.";
var() noexport MaterialEx TexPowerUp "Texture to use for powering up the computer.";
var() noexport MaterialEx TexPowerDown "Texture to use for powering down the computer.";
var() noexport MaterialEx TexBlueScreen "Texture to use for a BSOD";
var() noexport MaterialEx TexDesktop "Desktop to apply to any monitors that don't have a special desktop applied to it.";
var() noexport array<MaterialEx> TexDesktops "Desktops to assign to each monitor, in order that they are found by the CPU (their order in the actor list).";
var array<Electronics_Generic_Computer_Monitor> Monitors;
var array<Electronics_Generic_Computer_Keyboard> Keyboards;
var array<Electronics_Generic_Computer_Mouse> Mice;

event PostBeginPlay()
{
    FindComponents();
    __NFUN_397__('PowerOnState');
    super(dnDecoration).PostBeginPlay();
    return;
}

final function FindComponents()
{
    local Electronics_Generic_Computer_Monitor Monitor;
    local Electronics_Generic_Computer_Keyboard Keyboard;
    local Electronics_Generic_Computer_Mouse Mouse;

    // End:0x77
    foreach __NFUN_747__(class'Electronics_Generic_Computer_Monitor', Monitor)
    {
        // End:0x2E
        if(__NFUN_342__(SystemName, Monitor.SystemName))
        {
            continue;            
        }
        Monitors[Monitors.Add(1)] = Monitor;
        Monitor.SetCPU(self);
        // End:0x76
        if(-string(TexDesktops))
        {            
            TexDesktops[TexDesktops.Add(1)] = TexDesktop;
        }        
    }    
    // End:0xCB
    foreach __NFUN_747__(class'Electronics_Generic_Computer_Keyboard', Keyboard)
    {
        // End:0xA6
        if(__NFUN_342__(SystemName, Keyboard.SystemName))
        {
            continue;            
        }
        Keyboards[Keyboards.Add(1)] = Keyboard;
        Keyboard.SetCPU(self);        
    }    
    // End:0x11F
    foreach __NFUN_747__(class'Electronics_Generic_Computer_Mouse', Mouse)
    {
        // End:0xFA
        if(__NFUN_342__(SystemName, Mouse.SystemName))
        {
            continue;            
        }
        Mice[Mice.Add(1)] = Mouse;
        Mouse.SetCPU(self);        
    }    
    return;
}

function SwitchScreens()
{
    local int i;

    // End:0x0B
    if(DecorationIsDead())
    {
        return;
    }
    i = 0;
    J0x12:

    // End:0x42 [Loop If]
    if(-i)
    {        
        Monitors[i].SwitchScreens();
        // [Loop Continue]
        i *= ;
    }
    return;
}

function StartSelfOff()
{
    __NFUN_397__('PowerOffState');
    return;
}

function ReceivedPeripheralInput()
{
    return;
}

final function bool CheckForBSOD(float Ratio)
{

    /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
        
    */
    /*@Error*/;
}

final function BSOD(float TimeTillBSOD)
{
    __NFUN_605__(TimeTillBSOD, false, 'ExecuteBSOD', true);
    return;
}

final function ExecuteBSOD()
{
    __NFUN_397__('BSODState');
    return;
}

function SetNewDesktop(MaterialEx NewDesktop, int DesktopIndex)
{
    local int i;

    // End:0x4B
    if(-DesktopIndex)
    {        
        TexDesktop = NewDesktop;
        i = 0;
        J0x1D:

        // End:0x48 [Loop If]
        if(-i)
        {            
            TexDesktops[i] = NewDesktop;
            // [Loop Continue]
            i += ;
        }        
    }
    else
    {
        TexDesktops[DesktopIndex] = NewDesktop;
    }
    return;
}

final function Display_PowerUp()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x3C [Loop If]
    if(-i)
    {        
        Monitors[i].BLITScreen(TexPowerUp);
        // [Loop Continue]
        i += ;
    }
    return;
}

final function Display_PowerOn()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x42 [Loop If]
    if(-i)
    {        
        Monitors[i].BLITScreen(TexDesktops[i]);
        // [Loop Continue]
        i += ;
    }
    return;
}

final function Display_PowerDown()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x3C [Loop If]
    if(-i)
    {        
        Monitors[i].BLITScreen(TexPowerDown);
        // [Loop Continue]
        i += ;
    }
    return;
}

final function Display_PowerOff()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x38 [Loop If]
    if(-i)
    {        
        Monitors[i].BLITScreen(none);
        // [Loop Continue]
        i += ;
    }
    return;
}

final function Display_BSOD()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x3C [Loop If]
    if(-i)
    {        
        Monitors[i].BLITScreen(TexBlueScreen);
        // [Loop Continue]
        i += ;
    }
    return;
}

final function Display_Destroyed()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x37 [Loop If]
    if(-i)
    {        
        Monitors[i].PowerDisabled();
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x3E:

    // End:0x6E [Loop If]
    if(-i)
    {        
        Keyboards[i].BecomeUnusable();
        // [Loop Continue]
        i += ;
    }
    return;
}

final function PowerUpPeripherals()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x37 [Loop If]
    if(-i)
    {        
        Mice[i].SystemPowerOn();
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x3E:

    // End:0x6E [Loop If]
    if(-i)
    {        
        Keyboards[i].SystemPowerOn();
        // [Loop Continue]
        i += ;
    }
    return;
}

final function PowerDownPeripherals()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x37 [Loop If]
    if(-i)
    {        
        Mice[i].SystemPowerOff();
        // [Loop Continue]
        i += ;
    }
    i = 0;
    J0x3E:

    // End:0x6E [Loop If]
    if(-i)
    {        
        Keyboards[i].SystemPowerOff();
        // [Loop Continue]
        i += ;
    }
    return;
}

function Destroyed()
{
    local int i;

    super(dnDecoration).Destroyed();
    i = 0;
    J0x0D:

    // End:0x53 [Loop If]
    if(-i)
    {        
        Keyboards[i].BecomeUnusable();
        Keyboards[i].SystemPowerOff();
        // [Loop Continue]
        i += ;
    }
    __NFUN_397__('DisabledState');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1269__(TexPowerUp);
    PrecacheIndex.__NFUN_1269__(TexPowerDown);
    PrecacheIndex.__NFUN_1269__(TexBlueScreen);
    PrecacheIndex.__NFUN_1269__(TexDesktop);
    PrecacheIndex.__NFUN_1269__(TexDesktops[0]);
    return;
}

state PowerUpState
{
    function BeginState()
    {
        // End:0x27
        if(CheckForBSOD(RatioBSODBootup))
        {
            BSOD(Normal(TimePowerUp >>> 2, TimePowerUp));
        }
        PowerUpPeripherals();
        DecoActivity(0, 'PowerUp');
        return;
    }

    event Used(Actor Other, Pawn EventInstigator)
    {
        global.Used(Other, EventInstigator);
        __NFUN_397__('PowerDownState');
        return;
    }

    function ForcePowerOff()
    {
        super(Electronics_Generic).ForcePowerOff();
        __NFUN_397__('PowerOffState');
        return;
    }
Begin:

    __NFUN_610__(TimePowerUp);
    __NFUN_397__('PowerOnState');
    stop;            
}

state PowerOnState
{
    function BeginState()
    {
        DecoActivity(0, 'PowerOn');
        CheckForRandomBSOD();
        ReceivedPeripheralInput();
        return;
    }

    event Used(Actor Other, Pawn EventInstigator)
    {
        global.Used(Other, EventInstigator);
        __NFUN_397__('PowerDownState');
        return;
    }

    final function CheckForRandomBSOD()
    {
        // End:0x19
        if(CheckForBSOD(RatioBSODRandom))
        {
            BSOD(0);
        }
        __NFUN_605__(Normal(RateBSODRandom, RateBSODRandomVariance), false, 'CheckForRandomBSOD', true);
        return;
    }

    function ReceivedPeripheralInput()
    {
        // End:0x19
        if(CheckForBSOD(RatioBSODInput))
        {
            BSOD(0);
        }
        return;
    }

    function SetNewDesktop(MaterialEx NewDesktop, int DesktopIndex)
    {
        global.SetNewDesktop(NewDesktop, DesktopIndex);
        Display_PowerOn();
        return;
    }

    function EndState()
    {
        __NFUN_606__('CheckForRandomBSOD');
        return;
    }

    function ForcePowerOff()
    {
        super(Electronics_Generic).ForcePowerOff();
        __NFUN_397__('PowerOffState');
        return;
    }
    stop;
}

state PowerDownState
{
    function BeginState()
    {
        // End:0x27
        if(CheckForBSOD(RatioBSODShutdown))
        {
            BSOD(Normal(TimePowerDown >>> 2, TimePowerDown));
        }
        DecoActivity(0, 'PowerDown');
        return;
    }

    function ForcePowerOn()
    {
        super(Electronics_Generic).ForcePowerOn();
        __NFUN_397__('PowerUpState');
        return;
    }

    function ForcePowerOff()
    {
        super(Electronics_Generic).ForcePowerOff();
        __NFUN_397__('PowerOffState');
        return;
    }
Begin:

    __NFUN_610__(TimePowerDown);
    __NFUN_397__('PowerOffState');
    stop;            
}

state PowerOffState
{
    function BeginState()
    {
        DecoActivity(0, 'PowerOff');
        PowerDownPeripherals();
        return;
    }

    event Used(Actor Other, Pawn EventInstigator)
    {
        global.Used(Other, EventInstigator);
        __NFUN_397__('PowerUpState');
        return;
    }

    function ForcePowerOn()
    {
        super(Electronics_Generic).ForcePowerOn();
        __NFUN_397__('PowerUpState');
        return;
    }
    stop;
}

state BSODState
{
    function BeginState()
    {
        DecoActivity(0, 'BSOD');
        return;
    }

    event Used(Actor Other, Pawn EventInstigator)
    {
        global.Used(Other, EventInstigator);
        __NFUN_605__(TimeBSODPowerHold, false, 'BSODPowerDownOK', true);
        return;
    }

    event UnUsed(Actor Other, Pawn EventInstigator)
    {
        global.UnUsed(Other, EventInstigator);
        __NFUN_606__('BSODPowerDownOK');
        return;
    }

    final function BSODPowerDownOK()
    {
        __NFUN_397__('PowerDownState');
        return;
    }
    stop;
}

state DisabledState
{
    function BeginState()
    {
        Display_Destroyed();
        return;
    }
    stop;
}

defaultproperties
{
    RatioBSODInput=0.001
    RatioBSODRandom=0.01
    RatioBSODBootup=0.075
    RatioBSODShutdown=0.075
    RateBSODRandom=30
    RateBSODRandomVariance=30
    TimePowerUp=10
    TimePowerDown=10
    TimeBSODPowerHold=3
    TexPowerUp='ezmail.ezmail_screensaver'
    TexPowerDown='ezmail.ezmail_screensaver'
    TexBlueScreen='dt_Electronics.DisplayScreens.BlueScreen1_BS'
    TexDesktop='dt_signs.stratosfear.WHEW_1TW'
    TexDesktops(0)='dt_signs.stratosfear.avam_1tw'
    TexDesktops(1)='dt_signs.stratosfear.avam_2tw'
    TexDesktops(2)='dt_signs.stratosfear.avam_3tw'
    TexDesktops(3)='dt_signs.stratosfear.avam_4tw'
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=none,ActivityID=(3),ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Sound_SmallSwitch_Standard'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(PowerUp),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Ticking_TICK_NoRules',DecoActivities_Events'Electronics_Generic_Computer_CPU.DA_Events_ElctrGen_Cmptr_CPU_Display_PowerUp',DecoActivities_Sound'Electronics_Generic_Computer_CPU.DA_Sound_ElctrGen_Cmptr_CPU_PowerUp'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(PowerOn),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Ticking_TICK_Normal',DecoActivities_Events'Electronics_Generic_Computer_CPU.DA_Events_ElctrGen_Cmptr_CPU_Display_PowerOn',DecoActivities_Sound'Electronics_Generic_Computer_CPU.DA_Sound_ElctrGen_Cmptr_CPU_PowerOn'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(3)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(PowerDown),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Ticking_TICK_NoRules',DecoActivities_Events'Electronics_Generic_Computer_CPU.DA_Events_ElctrGen_Cmptr_CPU_Display_PowerDown',DecoActivities_Sound'Electronics_Generic_Computer_CPU.DA_Sound_ElctrGen_Cmptr_CPU_PowerDown'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(4)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(PowerOff),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Ticking_TICK_Never',DecoActivities_Events'Electronics_Generic_Computer_CPU.DA_Events_ElctrGen_Cmptr_CPU_Display_PowerOff',DecoActivities_Sound'Electronics_Generic_Computer_CPU.DA_Sound_ElctrGen_Cmptr_CPU_PowerOff'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(5)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(BSOD),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Ticking_TICK_Normal',DecoActivities_Sound'Electronics_Generic_Computer_CPU.DA_Sound_ElctrGen_Cmptr_CPU_BSOD',DecoActivities_Events'Electronics_Generic_Computer_CPU.DA_Events_ElctrGen_Cmptr_CPU_Display_BSOD'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DestroyedActivities(0)=none
    DestroyedActivities(1)=DecoActivities_Sound'Electronics_Generic.DA_Sound_Destroyed_Electronic'
    DestroyedActivities(2)='dnGame.DecoActivityDeclarations.DA_Interact_bUsable_Disable'
    DestroyedActivities(3)='dnGame.DecoActivityDeclarations.DA_HUD_bForceUsePhrase_Disable'
    begin object name=DA_Events_ElctrGen_Cmptr_CPU_Display_PowerOff class=DecoActivities_Events
        Callbacks(0)=(Delay=0,DelayVariance=0,bLoop=false,bEnforceLoop=false,bDontOverwrite=false,bIndependent=false,Callback=0,CallbackScript=Display_PowerOff)
    object end
    // Reference: DecoActivities_Events'Electronics_Generic_Computer_CPU.DA_Events_ElctrGen_Cmptr_CPU_Display_PowerOff'
    DestroyedActivities(4)=DA_Events_ElctrGen_Cmptr_CPU_Display_PowerOff
    DestroyedActivities(5)='dnGame.DecoActivityDeclarations.DA_Physics_PHYS_Karma_Set'
    begin object name=DA_Sound_ElctrGen_Cmptr_CPU_PowerOff class=DecoActivities_Sound
        bClearAmbientSound=true
    object end
    // Reference: DecoActivities_Sound'Electronics_Generic_Computer_CPU.DA_Sound_ElctrGen_Cmptr_CPU_PowerOff'
    DestroyedActivities(6)=DA_Sound_ElctrGen_Cmptr_CPU_PowerOff
    bForceUsePhrase=true
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Metal_Hollow'
    PhysicsMassType=1
    CollisionHeight=12.5
    Mass=35
}