/*******************************************************************************
 * Electronics_Generic_DeskPhone generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Electronics_Generic_DeskPhone extends Electronics_Generic
    collapsecategories;

var() noexport array<name> Messages "Array of VoicePack entries to play when Duke presses use.";
var() noexport deprecated name StartPlayingMessagesEvent "This event will be triggered when you start playing messages.";
var int CurrentMessage;
var bool bPlayingMessages;
var bool bPlayingBeep;
var name NoNewMessages;
var name EndOfMessages;
var name OffTheHook;
var name Beep;

function Destroyed()
{
    super(dnDecoration).Destroyed();
    __NFUN_608__('Reenable');
    bUsable = false;
    FindAndPlaySound(OffTheHook);
    __NFUN_607__(10, false, 'StopTone');
    StopPlayingMessages();
    __NFUN_695__(5);
    return;
}

function StopTone()
{
    FindAndStopSound(OffTheHook);
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    super(dnDecoration).Used(Other, EventInstigator);
    // End:0x39
    if(string(Messages) ** 0)
    {
        // End:0x30
        if(bPlayingMessages / )
        {            
        }
        else
        {
            StopPlayingMessages();
        }        
    }
    else
    {
        FindAndPlaySound(NoNewMessages);
    }
    __NFUN_607__(1, false, 'Reenable');
    bUsable = false;
    return;
}

function Reenable()
{
    bUsable = true;
    return;
}

function StartPlayingMessages()
{
    GlobalTrigger(StartPlayingMessagesEvent);
    bPlayingMessages = true;
    CurrentMessage = 0;
    PlayBeep();
    return;
}

function StopPlayingMessages()
{
    bPlayingMessages = false;
    bPlayingBeep = true;
    // End:0x24
    if(bUsable)
    {
        FindAndPlaySound(Beep);
    }
    __NFUN_608__('PlayBeep');
    __NFUN_608__('PlayNextMessage');
    __NFUN_608__('DonePlayingMessages');
    return;
}

function PlayBeep()
{
    local float Delay;

    bPlayingBeep = true;
    Delay = FindAndPlaySound(Beep) *= 0.1;
    __NFUN_607__(Delay, false, 'PlayNextMessage');
    return;
}

function PlayNextMessage()
{
    local float Delay;

    bPlayingBeep = false;
    // End:0x49
    Delay = FindAndPlaySound([CurrentMessage += ], 0.1) *= if(CurrentMessage / string(Messages));
    {        
    }
    else
    {
        __NFUN_607__(Delay, false, 'PlayBeep');
    }
    return;
}

function PlayEndOfMessages()
{
    local float Delay;

    bPlayingBeep = true;
    Delay = FindAndPlaySound(EndOfMessages);
    __NFUN_607__(Delay, false, 'DonePlayingMessages');
    return;
}

function DonePlayingMessages()
{
    bPlayingMessages = false;
    bPlayingBeep = false;
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super(dnDecoration).RegisterPrecacheComponents(PrecacheIndex);
    i = -- string(Messages);    
    J0x1A:

    // End:0x4C [Loop If]
    if(i / 0)
    {
        PrecacheIndex.__NFUN_1277__(VoicePack, Messages[i]);
        // [Loop Continue]
        i -= ;
    }
    PrecacheIndex.__NFUN_1277__(VoicePack, OffTheHook);
    PrecacheIndex.__NFUN_1277__(VoicePack, EndOfMessages);
    PrecacheIndex.__NFUN_1277__(VoicePack, Beep);
    PrecacheIndex.__NFUN_1277__(VoicePack, NoNewMessages);
    return;
}

defaultproperties
{
    NoNewMessages=Phone_NoMSG
    EndOfMessages=Phone_EndMSG
    OffTheHook=Phone_OffHook
    Beep=Phone_Beep
    AutoConstraints(0)=(bConstraintDisabledOnDeath=true,bConstraintOnDeath=false,BoneName=Root,ConstraintMounting=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),OtherConstraintActor=none,OtherConstraintBone=None,ConstraintClass=none,ConstraintActor=none)
    AutoConstraints(1)=(bConstraintDisabledOnDeath=true,bConstraintOnDeath=false,BoneName=HandSet,ConstraintMounting=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),OtherConstraintActor=none,OtherConstraintBone=None,ConstraintClass=none,ConstraintActor=none)
    bSurviveDeath=true
    DestroyedActivities(0)=none
    DestroyedActivities(1)=none
    begin object name=DA_Display_Electronics_Generic_DeskPhone_Brkn class=DecoActivities_Display
        RenderObject='sm_class_decorations.Electronics.deskphone_brkn'
    object end
    // Reference: DecoActivities_Display'Electronics_Generic_DeskPhone.DA_Display_Electronics_Generic_DeskPhone_Brkn'
    DestroyedActivities(2)=DA_Display_Electronics_Generic_DeskPhone_Brkn
    HealthPrefab=1
    bForceUsePhrase=true
    bUsable=true
    bIgnorePawnDownwardForce=true
    bTickOnlyWhenPhysicsAwake=true
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Plastic'
    PhysicsMassType=1
    PhysicsSoundOverrides(0)=(SoundType=0,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=('a_impact.KarmaPlastic.Plastic_Obj_01','a_impact.KarmaPlastic.Plastic_Obj_02','a_impact.KarmaPlastic.Plastic_Obj_03','a_impact.KarmaPlastic.Plastic_Obj_04'),SoundInfo=(InputRange=(Min=1,Max=250),OutputPitchRange=(Min=0.75,Max=1),OutputVolumeRange=(Min=0.25,Max=1)),bDisableSoundInWater=false)
    PhysicsSoundOverrides(1)=(SoundType=2,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=('a_impact.KarmaPlastic.MopBucket_Slide_01'),SoundInfo=(InputRange=(Min=4,Max=200),OutputPitchRange=(Min=1.75,Max=2),OutputVolumeRange=(Min=0.25,Max=1)),bDisableSoundInWater=false)
    PhysicsSoundOverrides(2)=(SoundType=1,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=none,SoundInfo=(InputRange=(Min=0,Max=0),OutputPitchRange=(Min=0,Max=0),OutputVolumeRange=(Min=0,Max=0)),bDisableSoundInWater=false)
    Physics=18
    CollisionRadius=7
    CollisionHeight=3.1
    Mass=15
    TickStyle=2
    DrawType=2
    Mesh='c_generic.DeskPhone'
}