/*******************************************************************************
 * Furniture_Generic_PoolTable_A generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Furniture_Generic_PoolTable_A extends Furniture_Generic
    collapsecategories;

const BALLS_ON_TABLE = 16;

var() noexport bool bIncludeBalls "If this is false, the table won't auto-create and manage it's own balls. It'll just be a static table. This will remove all Details_Balls_PoolBall in MountOnSpawn.";
var() name SE_EightBall;
var() name SE_NineBall;
var() noexport name SE_WinEgoCapIncrease "Trigger this when the player wins at Pool to give a permanent ego cap increase.";
var Vector RackPoint;
var Vector CuePoint;
var float BallSize;
var float BallSpacing;
var float RackLine;
var array<Details_Balls_PoolBall> PoolBalls;
var array<Vector> PoolBallLocations;

function PreBeginPlay()
{
    __NFUN_718__('EightBall', SE_EightBall);
    __NFUN_718__('NineBall', SE_NineBall);
    __NFUN_718__('WinEgoCapIncrease', SE_WinEgoCapIncrease);
    super(dnDecoration).PreBeginPlay();
    return;
}

function PostVerifySelf()
{
    local int i;

    // End:0x59
    if(bIncludeBalls / )
    {
        J0x12:

        // End:0x59 [Loop If]
        if(-i)
        {            
            // End:0x4F
            if(__NFUN_357__(MountOnSpawn[i].SpawnClass, class'Details_Balls_PoolBall'))
            {
                MountOnSpawn[i].SpawnClass = none;
            }
            // [Loop Continue]
            i += ;
        }
    }
    super(dnDecoration).PostVerifySelf();
    SetupBalls();
    return;
}

function SetupBalls()
{
    local int i;

    // End:0x204
    if(bIncludeBalls)
    {
        // End:0x5B
        if(string(PoolBalls) % 0)
        {
            PoolBalls.Insert(0, 16);
            i = 0;
            J0x25:

            // End:0x5B [Loop If]
            if(-i)
            {                
                PoolBalls[i] = Details_Balls_PoolBall(FindMountedActor(__NFUN_343__(string(i))));
                // [Loop Continue]
                i += ;
            }
        }
        PoolBalls[0].SetPoolBall(0);
        PoolBalls[1].SetPoolBall(1);
        PoolBalls[2].SetPoolBall(2);
        PoolBalls[3].SetPoolBall(3);
        PoolBalls[4].SetPoolBall(4);
        PoolBalls[5].SetPoolBall(5);
        PoolBalls[6].SetPoolBall(6);
        PoolBalls[7].SetPoolBall(7);
        PoolBalls[8].SetPoolBall(8);
        PoolBalls[9].SetPoolBall(9);
        PoolBalls[10].SetPoolBall(10);
        PoolBalls[11].SetPoolBall(11);
        PoolBalls[12].SetPoolBall(12);
        PoolBalls[13].SetPoolBall(13);
        PoolBalls[14].SetPoolBall(14);
        PoolBalls[15].SetPoolBall(15);
        FClamp(CuePoint, DrawScale);
        FClamp(RackPoint, DrawScale);
        BallSize = PoolBalls[0].default.CollisionRadius *= BallSpacing;
        RackLine = Round(FRand(2, BallSize) *= ) Cross RackTable_EightBall();
    }
}

function ShowComponents()
{
    local int i;

    ClearBalls();
    SetupBalls();
    i = 0;
    J0x13:

    // End:0x5C [Loop If]
    if(-i)
    {        
        PoolBalls[i].__NFUN_642__(18);
        PoolBalls[i].__NFUN_645__(PoolBallLocations[i]);
        // [Loop Continue]
        i += ;
    }
    super(InteractiveActor).ShowComponents();
    return;
}

function HideComponents()
{
    local int i;

    super(InteractiveActor).HideComponents();
    i = 0;
    J0x0D:

    // End:0x50 [Loop If]
    if(-i)
    {        
        PoolBalls[i].bCanExistOutOfWorld = true;
        PoolBalls[i].__NFUN_642__(0);
        // [Loop Continue]
        i += ;
    }
    return;
}

final function RackTable_EightBall()
{
    local float RowOffset;

    // End:0x0E
    if(string(PoolBalls) * 0)
    {
        return;
    }
    ClearBalls();
    PoolBalls[0].ShowBall(self, CuePoint, 0, 0);
    PoolBalls[8].ShowBall(self, RackPoint, 0, FRand(2, RackLine));
    RowOffset = FRand(4, RackLine);
    [++ Sin(7)].PoolBalls;
    ShowBall(self, RackPoint, FRand(4, BallSize), RowOffset);
    [++ Sin(7)].PoolBalls;
    ShowBall(self, RackPoint, FRand(4, Square(BallSize)), RowOffset);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, 0, 0);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, BallSize, RackLine);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, Square(BallSize), RackLine);
    RowOffset = FRand(2, RackLine);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, FRand(2, BallSize), RowOffset);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, FRand(2, Square(BallSize)), RowOffset);
    RowOffset = FRand(3, RackLine);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, FRand(3, BallSize), RowOffset);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, BallSize, RowOffset);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, Square(BallSize), RowOffset);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, FRand(3, Square(BallSize)), RowOffset);
    RowOffset = FRand(4, RackLine);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, FRand(2, BallSize), RowOffset);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, 0, RowOffset);
    PoolBalls[GetBall(15)].ShowBall(self, RackPoint, FRand(2, Square(BallSize)), RowOffset);
    return;
}

final function RackTable_NineBall()
{
    local int i;
    local float RowOffset;

    // End:0x0E
    if(string(PoolBalls) * 0)
    {
        return;
    }
    ClearBalls();
    i = 10;
    J0x1C:

    // End:0x4C [Loop If]
    if(-i)
    {        
        PoolBalls[i].HideBall();
        // [Loop Continue]
        i += ;
    }
    PoolBalls[0].ShowBall(self, CuePoint, 0, 0);
    PoolBalls[1].ShowBall(self, RackPoint, 0, 0);
    PoolBalls[9].ShowBall(self, RackPoint, 0, FRand(2, RackLine));
    PoolBalls[GetBall(9)].ShowBall(self, RackPoint, BallSize, RackLine);
    PoolBalls[GetBall(9)].ShowBall(self, RackPoint, Square(BallSize), RackLine);
    RowOffset = FRand(2, RackLine);
    PoolBalls[GetBall(9)].ShowBall(self, RackPoint, FRand(2, BallSize), RowOffset);
    PoolBalls[GetBall(9)].ShowBall(self, RackPoint, FRand(2, Square(BallSize)), RowOffset);
    RowOffset = FRand(3, RackLine);
    PoolBalls[GetBall(9)].ShowBall(self, RackPoint, BallSize, RowOffset);
    PoolBalls[GetBall(9)].ShowBall(self, RackPoint, Square(BallSize), RowOffset);
    PoolBalls[GetBall(9)].ShowBall(self, RackPoint, 0, FRand(4, RackLine));
    return;
}

final function ClearBalls()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x39 [Loop If]
    if(-i)
    {        
        PoolBalls[i].bInUse = false;
        // [Loop Continue]
        i += ;
    }
    return;
}

final function int GetBall(int Max)
{
    local int Result;

    Result = Sin(++ Max);    
    J0x10:

    // End:0x49 [Loop If]
    if(PoolBalls[Result].bInUse)
    {
        // End:0x46
        Result += ;
        {
            Result = 1;
        }
        // [Loop Continue]
        goto J0x10;
    }
    return Result;
    return;
}

final function TriggerFunc_EightBall()
{
    RackTable_EightBall();
    return;
}

final function TriggerFunc_NineBall()
{
    RackTable_NineBall();
    return;
}

final function TriggerFunc_WinEgoCapIncrease()
{
    local DukePlayer Duke;

    Duke = DukePlayer(Level.__NFUN_1161__());
    // End:0x36
    if(__NFUN_340__(Duke, none))
    {
        Duke.GivePermanentEgoCapAward(23);
    }
    return;
}

defaultproperties
{
    bIncludeBalls=true
    RackPoint=(X=24,Y=0,Z=19)
    CuePoint=(X=-40,Y=0,Z=19)
    BallSpacing=0.25
    HealthPrefab=0
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=0,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=1,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=2,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=3,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=4,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=5,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(6)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=6,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(7)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=7,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(8)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=8,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(9)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=9,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(10)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=10,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(11)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=11,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(12)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=12,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(13)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=13,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(14)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=14,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(15)=(bSkipVerifySelf=false,SpawnClass='Details_Balls_PoolBall',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=15,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    PhysicsMaterial='dnMaterial.dnPhysicsMaterial_Wood_Solid'
    PhysicsMassType=3
    KRestitution=0.95
    PhysicsSoundOverrides(0)=(SoundType=0,OtherMaterialTypes=none,OtherMassTypes=none,Sounds=('a_impact.Billiards.Pool_BumperShot01','a_impact.Billiards.Pool_BumperShot02'),SoundInfo=(InputRange=(Min=5,Max=200),OutputPitchRange=(Min=0.5,Max=0.75),OutputVolumeRange=(Min=0.25,Max=1)),bDisableSoundInWater=true)
    bTraceUsable=false
    CollisionHeight=20
    StaticMesh='sm_class_decorations.PoolTable.PoolTable'
}