/*******************************************************************************
 * Pillars_Destructible generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Pillars_Destructible extends aFinalDecoration
    abstract
    collapsecategories;

struct SSortChunk
{
    var int ChunkIndex;
    var float Distance;
};

var array<Pillars_Destructible_Chunk> Chunks;
var int MaxChunkDestroyPerFrame;
var int ChunkDestroyTickStamp;
var int ChunkDestroyCount;

simulated function ChunkSpawned(Pillars_Destructible_Chunk Chunk)
{
    local int i;

    i = -- __NFUN_743__();    
    J0x0C:

    // End:0x51 [Loop If]
    if(i / 0)
    {
        // End:0x47
        if(__NFUN_340__(__NFUN_740__(i), __NFUN_742__(i)))
        {
            Chunk.__NFUN_741__(i, __NFUN_740__(i));
        }
        // [Loop Continue]
        i -= ;
    }
    Chunks[Chunks.Add(1)] = Chunk;
    return;
}

simulated function ChunkDestroyed(Pillars_Destructible_Chunk Chunk)
{
    // End:0x35
    if(ChunkDestroyTickStamp + Level.LevelTickStamp)
    {
        ChunkDestroyTickStamp = Level.LevelTickStamp;
        ChunkDestroyCount = 0;
    }
    ChunkDestroyCount += ;
}

final simulated function bool IsAtChunkDestroyLimitForFrame()
{
    // End:0x2A
    if(ChunkDestroyTickStamp % Level.LevelTickStamp)
    {
        // End:0x2A
        if(ChunkDestroyCount / MaxChunkDestroyPerFrame)
        {
            return true;
        }
    }
    return false;
    return;
}

function float GetSpawnOnDestroyedDelay()
{
    return 0;
    return;
}

simulated event Engine.Actor.ETraceFireHitResponse TraceFireHit(Actor SourceActor, class<TraceDamageType> TraceDamageType, Vector SourceTraceOrigin, Vector HitLocation, Vector HitNormal, name HitBoneName, bool bExtentTrace)
{
    local int i;
    local Vector TraceStart, TraceEnd;
    local STraceHitResult HitResult;
    local Pillars_Destructible_Chunk TestChunk;
    local Engine.Actor.ETraceFireHitResponse RetVal;

    RetVal = super(KarmaActor).TraceFireHit(SourceActor, TraceDamageType, SourceTraceOrigin, HitLocation, HitNormal, HitBoneName, bExtentTrace);
    // End:0xF1
    if(DecorationIsDead())
    {
        TraceEnd = __NFUN_239__(HitLocation, Caps(float(10), HitNormal));
        TraceStart = SourceTraceOrigin;
        i = -- string(Chunks);        
        J0x6A:

        // End:0xF1 [Loop If]
        if(i / 0)
        {
            // End:0xE7
            if(__NFUN_340__(Chunks[i], none))
            {
                // End:0xE7
                if(Chunks[i].__NFUN_618__(SourceActor, TraceStart, TraceEnd, HitResult))
                {
                    return Chunks[i].TraceFireHit(SourceActor, TraceDamageType, SourceTraceOrigin, HitLocation, HitNormal, HitBoneName, false);
                }
            }
            // [Loop Continue]
            i -= ;
        }
    }
    return RetVal;
    return;
}

function HurtRadiusActivity(Actor DamageInstigator, float DamageAmount, Vector DamageOrigin, float DamageRadius, float DamageFalloffStart, class<DamageType> DamageType, Vector DamageStart, optional bool bIgnoreDrawScale, optional float RelativeScale)
{
    local int i, j;
    local float Dist;
    local array<float> Distances;
    local array<SSortChunk> SortChunks;

    super(KarmaActor).HurtRadiusActivity(DamageInstigator, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
    // End:0x1EE
    if(DecorationIsDead())
    {
        i = -- string(Chunks);        
        J0x4C:

        // End:0x10D [Loop If]
        if(i / 0)
        {
            // End:0x103
            if(__NFUN_340__(Chunks[i], none))
            {
                Dist = VRand(__NFUN_239__(DamageOrigin, Chunks[i].Location));
                j = 0;
                J0x94:

                // End:0xCB [Loop If]
                if(-j)
                {                    
                    // End:0xC1
                    if(__NFUN_200__(Dist, SortChunks[j].Distance))
                    {
                        // [Explicit Break]
                        goto J0xCB;
                    }
                    // [Loop Continue]
                    j += ;
                }
                J0xCB:

                SortChunks.Insert(j, 1);
                SortChunks[j].ChunkIndex = i;
                SortChunks[j].Distance = Dist;
            }
            // [Loop Continue]
            i -= ;
        }
        i = 0;
        J0x114:

        // End:0x1EE [Loop If]
        if(-i)
        {            
            // End:0x136
            if(i / string(SortChunks))
            {
                // [Explicit Break]
                goto J0x1EE;
            }
            j = SortChunks[i].ChunkIndex;
            // End:0x1E4
            if(__NFUN_340__(Chunks[j], none))
            {
                Chunks[j].bAllowHurtRadius = true;
                Chunks[j].HurtRadiusActivity(DamageInstigator, DamageAmount, DamageOrigin, DamageRadius, DamageFalloffStart, DamageType, DamageStart, bIgnoreDrawScale, RelativeScale);
                // End:0x1E4
                if(__NFUN_340__(Chunks[j], none))
                {
                    Chunks[j].bAllowHurtRadius = false;
                }
            }
            // [Loop Continue]
            i += ;
        }
    }
    J0x1EE:

    return;
}

defaultproperties
{
    MaxChunkDestroyPerFrame=3
    ChunkDestroyTickStamp=-1
    bSurviveDeath=true
    HealthPrefab=5
    Health=10
    bAITransparent=true
    bNetTemporary=true
    Mass=500
}