/*******************************************************************************
 * Settings_Bathroom_WaterCooler generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class Settings_Bathroom_WaterCooler extends Settings_Bathroom
    collapsecategories;

enum ECoolerState
{
    COOLER_None,
    COOLER_Left,
    COOLER_Right
};

var SoftParticleSystem RightParticleFX;
var SoftParticleSystem LeftParticleFX;
var array<Vector> FaucetPoints;
var() noexport int DeltaHealth "How much health to give to the drinker of this fountain.";
var Containers_WaterCooler_Jug WaterJug;
var Pawn Drinker;
var Settings_Bathroom_WaterCooler.ECoolerState CoolerState;
var bool bLeftKnobUsed;

function PostVerifySelf()
{
    super(dnDecoration).PostVerifySelf();
    GetWaterJug();
    GetParticleFX();
    return;
}

final function bool GetUserRight(Pawn User)
{
    EndViewingAngleMinDiff = 0;
    return (GetUserLookAtPoint(User, FaucetPoints)) % 0;
    return;
}

final function GetWaterJug()
{
    WaterJug = Containers_WaterCooler_Jug(FindMountedActor('WaterJug'));
    // End:0x2D
    if(__NFUN_340__(WaterJug, none))
    {
        AttachJugToSelf(WaterJug);
    }
    return;
}

final function GetParticleFX()
{
    LeftParticleFX = SoftParticleSystem(FindMountedActor('LeftFX'));
    RightParticleFX = SoftParticleSystem(FindMountedActor('RightFX'));
    // End:0x44
    if(__NFUN_340__(LeftParticleFX, none))
    {
        SetParticleState(LeftParticleFX, false);
    }
    // End:0x5C
    if(__NFUN_340__(RightParticleFX, none))
    {
        SetParticleState(RightParticleFX, false);
    }
    return;
}

function bool VerifySelf()
{
    DeltaHealth = Exp(DeltaHealth, 0, int(-float(DeltaHealth)));
    return super(Actor).VerifySelf();
    return;
}

simulated function bool CanGrabUseCombine(InteractiveActor Combinee)
{
    return (__NFUN_339__(WaterJug, none) << __NFUN_340__(Combinee, none)) << __NFUN_340__(Containers_WaterCooler_Jug(Combinee), none);
    return;
}

simulated function bool CanBeUsedBy(Pawn User)
{
    // End:0x40
    if((__NFUN_339__(WaterJug, none) << User.CarryingAnActor()) << __NFUN_339__(Containers_WaterCooler_Jug(User.CarriedActor), none))
    {
        return false;
    }
    return super(InteractiveActor).CanBeUsedBy(User);
    return;
}

event Used(Actor Other, Pawn EventInstigator)
{
    super(dnDecoration).Used(Other, EventInstigator);
    // End:0x20
    if(int(CoolerState) + int(0))
    {
        return;
    }
    // End:0x69
    if((__NFUN_340__(WaterJug, none) < __NFUN_339__(EventInstigator, none)) < EventInstigator.CarryingAnActor() / )
    {
        return;
    }
    return;
}

event UnUsed(Actor Other, Pawn EventInstigator)
{
    super(dnDecoration).UnUsed(Other, EventInstigator);
    // End:0x24
    if(int(CoolerState) + int(0))
    {
        TurnOff();
    }
    return;
}

function DetachJug()
{
    // End:0x7B
    if(__NFUN_340__(WaterJug, none))
    {
        WaterJug.__NFUN_631__();
        WaterJug.RestoreCollision();
        WaterJug.__NFUN_642__(18);
        WaterJug.__NFUN_817__();
        WaterJug.SetCooler(none);
        WaterJug.__NFUN_820__(WarnInternal(0, 0, 300));
        WaterJug = none;
    }
    return;
}

final function AttachJugToSelf(Containers_WaterCooler_Jug AttachJug)
{
    // End:0x0E
    if(__NFUN_339__(AttachJug, none))
    {
        return;
    }
    AttachJug.SetCooler(self);
    AttachJug.StoreCollision();
    AttachJug.__NFUN_621__(, false, false, true, false);
    AttachJug.__NFUN_642__(0);
    AttachJug.MountType = 2;
    AttachJug.MountMeshItem = 'jugmount';
    AttachJug.MountOrigin = WarnInternal(0, 0, 0);
    AttachJug.MountAngles = __NFUN_265__(0, 0, 0);
    AttachJug.__NFUN_635__(self);
    return;
}

final function TurnOn(Pawn NewDrinker, bool rightSide)
{
    Drinker = NewDrinker;
    // End:0x1F
    if(rightSide)
    {
        CoolerState = 2;        
    }
    else
    {
        CoolerState = 1;
    }
    switch(CoolerState)
    {
        // End:0x6A
        case 1:
            DecoActivity(0, 'UseLeftKnob');
            // End:0x67
            if(__NFUN_340__(WaterJug, none) << __NFUN_340__(LeftParticleFX, none))
            {
                SetParticleState(LeftParticleFX, true);
            }
            // End:0xA8
            break;
        // End:0xA5
        case 2:
            DecoActivity(0, 'UseRightKnob');
            // End:0xA2
            if(__NFUN_340__(WaterJug, none) << __NFUN_340__(RightParticleFX, none))
            {
                SetParticleState(RightParticleFX, true);
            }
            // End:0xA8
            break;
        // End:0xFFFF
        default:
            break;
    }
    return;
}

final function TurnOff()
{
    switch(CoolerState)
    {
        // End:0x35
        case 1:
            DecoActivity(0, 'UnUseLeftKnob');
            // End:0x32
            if(__NFUN_340__(LeftParticleFX, none))
            {
                SetParticleState(LeftParticleFX, false);
            }
            // End:0x65
            break;
        // End:0x62
        case 2:
            DecoActivity(0, 'UnUseRightKnob');
            // End:0x5F
            if(__NFUN_340__(RightParticleFX, none))
            {
                SetParticleState(RightParticleFX, false);
            }
            // End:0x65
            break;
        // End:0xFFFF
        default:
            break;
    }
    Drinker = none;
    CoolerState = 0;
    return;
}

final function SetParticleState(SoftParticleSystem ParticleSystem, bool bEnabled)
{
    // End:0x72
    if(__NFUN_340__(ParticleSystem, none))
    {
        ParticleSystem.Enabled = bEnabled;
        // End:0x60
        if(bEnabled)
        {
            ParticleSystem.DisableTickWhenEmpty = false;
            ParticleSystem.TickStyle = ParticleSystem.default.TickStyle;            
        }
        else
        {
            ParticleSystem.DisableTickWhenEmpty = true;
        }
    }
    return;
}

final function BubbleActivity()
{
    // End:0x26
    if(__NFUN_339__(WaterJug, none) < int(CoolerState) % int(0))
    {
        __NFUN_608__('BubbleActivity');
        return;
    }
    // End:0x47
    if(__NFUN_340__(Drinker, none))
    {
        Drinker.ModifyBladder(DeltaHealth);
    }
    DecoActivity(0, 'BubbleEffect');
    return;
}

function Destroyed()
{
    TurnOff();
    DetachJug();
    super(dnDecoration).Destroyed();
    return;
}

defaultproperties
{
    FaucetPoints(0)=(X=5.533,Y=2.3,Z=8.78)
    FaucetPoints(1)=(X=5.533,Y=-2.3,Z=8.78)
    DeltaHealth=5
    DecoActivities_Default(0)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(UseLeftKnob),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Sound_SmallSwitch_Standard',DecoActivities_Animation'Settings_Bathroom_WaterCooler.DA_Anim_Settings_Bathroom_WaterCooler_TurnOn_Left',DecoActivities_Events'Settings_Bathroom_WaterCooler.DA_Events_Settings_Bathroom_WaterCooler_BubbleTimer'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(1)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(UseRightKnob),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=('dnGame.DecoActivityDeclarations.DA_Sound_SmallSwitch_Standard',DecoActivities_Animation'Settings_Bathroom_WaterCooler.DA_Anim_Settings_Bathroom_WaterCooler_TurnOn_Right',DecoActivities_Events'Settings_Bathroom_WaterCooler.DA_Events_Settings_Bathroom_WaterCooler_BubbleTimer'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(2)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(UnUseLeftKnob),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'Settings_Bathroom_WaterCooler.DA_Anim_Settings_Bathroom_WaterCooler_TurnOff_Left',DecoActivities_Events'Settings_Bathroom_WaterCooler.DA_Events_Settings_Bathroom_WaterCooler_EndBubbleTimer',DecoActivities_Sound'Settings_Bathroom_WaterCooler.DA_Sound_Settings_Bathroom_WaterCooler_EndBubbles'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(3)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(UnUseRightKnob),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Animation'Settings_Bathroom_WaterCooler.DA_Anim_Settings_Bathroom_WaterCooler_TurnOff_Right',DecoActivities_Events'Settings_Bathroom_WaterCooler.DA_Events_Settings_Bathroom_WaterCooler_EndBubbleTimer',DecoActivities_Sound'Settings_Bathroom_WaterCooler.DA_Sound_Settings_Bathroom_WaterCooler_EndBubbles'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    DecoActivities_Default(4)=(ActivityData=(bInitialized=false,CurrentIndex=0,NextPerformTime=0,NextPerformTime_Failure=0),ActivityIDScript=(BubbleEffect),ActivityID=none,ActivityMethod=0,ActivityStates_Success=none,ActivityStates_Failure=none,ActivityDebugID="",Activities=((ActivityRules=none,ActivityElements=(DecoActivities_Sound'Settings_Bathroom_WaterCooler.DA_Sound_Settings_Bathroom_WaterCooler_Bubbles',DecoActivities_Sound'Settings_Bathroom_WaterCooler.DA_Sound_Settings_Bathroom_WaterCooler_Drink'),ActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0),FailureActivityElements=none,FailureActivitySetup=(bDisabled=false,bPerformedThisRound=false,PerformedCounter=0,LoopCount=0,PerformAgainDelay=0))),bDisabled=false)
    StartupActivities(0)='dnGame.DecoActivityDeclarations.DA_Sound_Ambient_VendingHum'
    bSurviveDeath=true
    DestroyedActivities(0)=none
    DestroyedActivities(1)='dnGame.DecoActivityDeclarations.DA_Sound_Destroyed_Generic'
    DestroyedActivities(2)='dnGame.DecoActivityDeclarations.DA_Sound_Ambient_Clear'
    DestroyedActivities(3)='dnGame.DecoActivityDeclarations.DA_Interact_bUsable_Disable'
    DestroyedActivities(4)='dnGame.DecoActivityDeclarations.DA_Physics_PHYS_Karma_Set'
    HealthPrefab=4
    bForceUsePhrase=true
    bUsable=true
    bUnUsable=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='Containers_WaterCooler_Jug',SpawnChance=1,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=WaterJug,ForceEvent=None,MountMeshItem=jugmount,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='p_Decorations.WaterCoolerFX.WaterCoolerFX_spawner',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightFX,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=5.533,Y=2.3,Z=8.78),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='p_Decorations.WaterCoolerFX.WaterCoolerFX_spawner',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftFX,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=5.533,Y=-2.3,Z=8.78),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    SpawnOnDestroyedSimple(0)='dnParticles.dnDebris_WaterSplash'
    bTickOnlyWhenPhysicsAwake=true
    DynamicInteractionClassification=0
    CollisionRadius=8
    CollisionHeight=27.25
    DrawType=2
    Mesh='c_generic.watercooler'
}