/*******************************************************************************
 * dnControl_Pinball generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_Pinball extends dnControl
    collapsecategories
    dependson(dnControlHelper_Pinball_ScoreBoard)
    dependson(dnControlHelper_Pinball_Plunger)
    dependson(dnControlHelper_Pinball_Flipper)
    dependson(dnControlHelper_Pinball_SlotSet)
    dependson(dnControlHelper_Pinball_Blocker)
    dependson(dnControlHelper_Pinball_HitBoxSet)
    dependson(dnControlHelper_Pinball_Target)
    dependson(dnControlHelper_Pinball_BallGate)
    dependson(dnControlHelper_Pinball_Spacer);

struct SScoreThreshholdInfo
{
    var() int ScoreThreshhold;
    var() name ThreshholdEvent;
};

var() noexport deprecated name LeftFlipperTag "Tag of all the flippers that should be considered left flippers for this table.";
var() noexport deprecated name RightFlipperTag "Tag of all the flippers that should be considered right flippers for this table.";
var() float PlungerPullSpeed;
var() noexport Vector TrackCenter "Center of the ball track area (relative to table position).";
var() noexport Vector TrackExtent "Extent of the ball track area.";
var KBoxSensor TrackSensor;
var() noexport Vector GutterCenter "Center of the ball gutter area (relative to table position).";
var() noexport Vector GutterExtent "Extent of the ball gutter area.";
var KBoxSensor GutterSensor;
var() Vector NudgeUpForce;
var() Vector NudgeLeftForce;
var() Vector NudgeRightForce;
var() bool bTurnOffTilt;
var() float BallLaunchVelocity;
var bool bAllowPlunger;
var bool bLeftButton;
var bool bRightButton;
var float PlungerGrid;
var dnControlHelper_Pinball_Plunger Plunger;
var array<dnControlHelper_Pinball_Flipper> LeftFlippers;
var array<dnControlHelper_Pinball_Flipper> RightFlippers;
var dnControlHelper_Pinball_Ball PrimaryBall;
var string AttractMusicName;
var string AttachedMusicName;
var int CurrentThreshhold;
var() array<SScoreThreshholdInfo> ScoreThreshholds;
var() name HighScoreEvent;
var bool bHasThrownHighScoreEvent;
var() name JackpotEvent;
var dnControlHelper_Pinball_SlotSet SlotSet;
var dnControlHelper_Pinball_HitBoxSet HitBoxSet1;
var dnControlHelper_Pinball_HitBoxSet HitBoxSet2;
var dnControlHelper_Pinball_Target Target1;
var dnControlHelper_Pinball_Target Target2;
var dnControlHelper_Pinball_Target Target3;
var dnControlHelper_Pinball_Light BonusLights[4];
var dnControlHelper_Pinball_Light LeftBlockerLight;
var dnControlHelper_Pinball_Light RightBlockerLight;
var dnControlHelper_Pinball_Light RightSpacerLight;
var dnControlHelper_Pinball_Light LeftSpacerLight;
var dnControlHelper_Pinball_Light RightSpacerArrowLight;
var dnControlHelper_Pinball_Light LeftSpacerArrowLight;
var dnControlHelper_Pinball_Light GutterLight;
var dnControlHelper_Pinball_Light GutterArrowLight;
var dnControlHelper_Pinball_Light RedKeyLight;
var dnControlHelper_Pinball_Light BlueKeyLight;
var dnControlHelper_Pinball_Light JackpotLight;
var int CurrentBonusLightIndex;
var dnControlHelper_Pinball_Blocker TrackBlocker;
var dnControlHelper_Pinball_Blocker LeftBlocker;
var dnControlHelper_Pinball_Blocker RightBlocker;
var dnControlHelper_Pinball_Spacer RightSpacer;
var dnControlHelper_Pinball_Spacer LeftSpacer;
var dnControlHelper_Pinball_ScoreBoard ScoreBoard;
var array<dnControlHelper_Pinball_BallGate> BallGate;
var StaticMesh LightArrowMesh;
var int NudgeCount;
var int NudgeMax;
var bool bTilted;
var bool bMultiBall;
var float TiltDecayRate;
var bool bBallInGutter;
var int Score;
var int ScoreMultiplier;
var() int highscore;
var int RedKeyPoints;
var int BlueKeyPoints;
var int JackpotPoints;
var int BallsLeft;
var bool bGameOver;
var bool bFirstTimePlay;
var() bool bDebugScore;
var Vector BallKeyframeLocation;
var MaterialEx BallsLeftMaterials[3];
var MaterialEx TiltMaterial;
var MaterialEx HighScoreMaterial;
var MaterialEx KickAssMaterial;
var MaterialEx CurrentMaterial;
var MaterialEx BlackMaterial;
var bool bFirstLose;
var dnGame.DukePlayer.EAchievement Achievement;

simulated event PostBeginPlay()
{
    super(dnUsableSomething).PostBeginPlay();
    InitItems();
    return;
}

function ReMountOnSpawnItems()
{
    local int i;

    i = -- string(default.MountOnSpawn);    
    J0x0F:

    // End:0x32 [Loop If]
    if(i / 0)
    {
        __NFUN_837__(default.MountOnSpawn[i]);
        // [Loop Continue]
        i -= ;
    }
    return;
}

function InitItems()
{
    local dnControlHelper_Pinball_Flipper Flipper;
    local int i;
    local dnControlHelper_Pinball_BallGate BallGates;

    // End:0x25
    if(__NFUN_341__(PhysicsEntityGroup, 'None'))
    {
        __NFUN_816__(__NFUN_343__(__NFUN_302__(string(Name), "_PET")));
    }
    Plunger = dnControlHelper_Pinball_Plunger(FindMountedActor(, class'dnControlHelper_Pinball_Plunger'));
    PrimaryBall = dnControlHelper_Pinball_Ball(FindOwnedActor(class'dnControlHelper_Pinball_Ball', 'PRIMARY_BALL'));
    // End:0xA3
    foreach __NFUN_747__(class'dnControlHelper_Pinball_Flipper', Flipper, LeftFlipperTag)
    {
        Flipper.InitFlipper(true);
        Flipper.__NFUN_816__(PhysicsEntityGroup);
        LeftFlippers[LeftFlippers.Add(1)] = Flipper;        
    }    
    // End:0xF0
    foreach __NFUN_747__(class'dnControlHelper_Pinball_Flipper', Flipper, RightFlipperTag)
    {
        Flipper.InitFlipper(false);
        Flipper.__NFUN_816__(PhysicsEntityGroup);
        RightFlippers[RightFlippers.Add(1)] = Flipper;        
    }    
    // End:0x115
    foreach __NFUN_747__(class'dnControlHelper_Pinball_BallGate', BallGates)
    {
        BallGate[BallGate.Add(1)] = BallGates;        
    }    
    TrackSensor = __NFUN_615__(class'KBoxSensor', self,, Locs(Location, __NFUN_263__(TrackCenter, Rotation)), Rotation);
    // End:0x1EA
    if(__NFUN_340__(TrackSensor, none))
    {
        TrackSensor.__NFUN_1125__(TrackExtent);
        TrackSensor.BeginSenseEvent = __NFUN_343__(__NFUN_302__(string(Name), "_TS_Enter"));
        TrackSensor.EndSenseEvent = __NFUN_343__(__NFUN_302__(string(Name), "_TS_Exit"));
        TrackSensor.__NFUN_1120__(class'dnControlHelper_Pinball_Ball');
        __NFUN_718__('BallEnteredTrack', TrackSensor.BeginSenseEvent);
        __NFUN_718__('BallLeftTrack', TrackSensor.EndSenseEvent);
    }
    GutterSensor = __NFUN_615__(class'KBoxSensor', self,, Locs(Location, __NFUN_263__(GutterCenter, Rotation)), Rotation);
    // End:0x2BE
    if(__NFUN_340__(GutterSensor, none))
    {
        GutterSensor.__NFUN_1125__(GutterExtent);
        GutterSensor.BeginSenseEvent = __NFUN_343__(__NFUN_302__(string(Name), "_GS_Enter"));
        GutterSensor.EndSenseEvent = __NFUN_343__(__NFUN_302__(string(Name), "_GS_Exit"));
        GutterSensor.__NFUN_1120__(class'dnControlHelper_Pinball_Ball');
        __NFUN_718__('BallEnteredGutter', GutterSensor.BeginSenseEvent);
        __NFUN_718__('BallLeftGutter', GutterSensor.EndSenseEvent);
    }
    SlotSet = dnControlHelper_Pinball_SlotSet(FindMountedActor(, class'dnControlHelper_Pinball_SlotSet'));
    SlotSet.SpawnSlots(WarnInternal(-21, 7, 8), WarnInternal(-21, 1, 8), WarnInternal(-21, -5, 8));
    HitBoxSet1 = dnControlHelper_Pinball_HitBoxSet(FindMountedActor('HitBoxSet1', class'dnControlHelper_Pinball_HitBoxSet'));
    HitBoxSet1.AddHitBox(WarnInternal(-3, 22, 8), WarnInternal(-3, 20, 6.1));
    HitBoxSet1.AddHitBox(WarnInternal(1, 22, 8), WarnInternal(1, 20, 6.1));
    HitBoxSet1.AddHitBox(WarnInternal(5, 22, 8), WarnInternal(5, 20, 6.1));
    HitBoxSet2 = dnControlHelper_Pinball_HitBoxSet(FindMountedActor('HitBoxSet2', class'dnControlHelper_Pinball_HitBoxSet'));
    HitBoxSet2.AddHitBox(WarnInternal(-1, -16, 8), WarnInternal(-1, -14, 6.1), true);
    HitBoxSet2.AddHitBox(WarnInternal(3, -16, 8), WarnInternal(3, -14, 6.1), true);
    HitBoxSet2.AddHitBox(WarnInternal(7, -16, 8), WarnInternal(7, -14, 6.1), true);
    HitBoxSet2.AddHitBox(WarnInternal(11, -16, 8), WarnInternal(11, -14, 6.1), true);
    Target1 = dnControlHelper_Pinball_Target(FindMountedActor('Target1', class'dnControlHelper_Pinball_Target'));
    Target1.AddLight(WarnInternal(-6.18, -13.02, 6.1), __NFUN_265__(0, 8516, 0), LightArrowMesh);
    Target2 = dnControlHelper_Pinball_Target(FindMountedActor('Target2', class'dnControlHelper_Pinball_Target'));
    Target2.AddLight(WarnInternal(-7.1, 18.18, 6.1), __NFUN_265__(0, -8564, 0), LightArrowMesh);
    Target3 = dnControlHelper_Pinball_Target(FindMountedActor('Target3', class'dnControlHelper_Pinball_Target'));
    Target3.AddLight(WarnInternal(-17.21, 18.95, 6.1), __NFUN_265__(0, -5664, 0), LightArrowMesh);
    BonusLights[0] = dnControlHelper_Pinball_Light(FindMountedActor('Bonus2x', class'dnControlHelper_Pinball_Light'));
    BonusLights[0].__NFUN_591__(1.25);
    BonusLights[0].__NFUN_741__(0, class'Pinball_Light_Circlex2_fb');
    BonusLights[0].ActivatedColor = NewColorBytes(184, 79, 48, 255);
    BonusLights[1] = dnControlHelper_Pinball_Light(FindMountedActor('Bonus4x', class'dnControlHelper_Pinball_Light'));
    BonusLights[1].__NFUN_591__(1.25);
    BonusLights[1].__NFUN_741__(0, class'Pinball_Light_Circlex4_fb');
    BonusLights[1].ActivatedColor = NewColorBytes(206, 134, 53, 255);
    BonusLights[2] = dnControlHelper_Pinball_Light(FindMountedActor('Bonus6x', class'dnControlHelper_Pinball_Light'));
    BonusLights[2].__NFUN_591__(1.25);
    BonusLights[2].__NFUN_741__(0, class'Pinball_Light_Circlex6_fb');
    BonusLights[2].ActivatedColor = NewColorBytes(239, 189, 21, 255);
    BonusLights[3] = dnControlHelper_Pinball_Light(FindMountedActor('BonusNuke', class'dnControlHelper_Pinball_Light'));
    BonusLights[3].ActivatedColor = NewColorBytes(254, 249, 188, 255);
    RedKeyLight = dnControlHelper_Pinball_Light(FindMountedActor('RedKeyLight', class'dnControlHelper_Pinball_Light'));
    RedKeyLight.ActivatedColor = NewColorBytes(236, 255, 4, 255);
    BlueKeyLight = dnControlHelper_Pinball_Light(FindMountedActor('BlueKeyLight', class'dnControlHelper_Pinball_Light'));
    BlueKeyLight.__NFUN_741__(0, class'Pinball_Light_BlueKey_fb');
    BlueKeyLight.ActivatedColor = NewColorBytes(236, 255, 4, 255);
    JackpotLight = dnControlHelper_Pinball_Light(FindMountedActor('JackpotLight', class'dnControlHelper_Pinball_Light'));
    JackpotLight.ActivatedColor = NewColorBytes(236, 255, 4, 255);
    LeftBlockerLight = dnControlHelper_Pinball_Light(FindMountedActor('LeftBlockerLight', class'dnControlHelper_Pinball_Light'));
    LeftBlockerLight.ActivatedColor = NewColorBytes(236, 255, 4, 255);
    RightBlockerLight = dnControlHelper_Pinball_Light(FindMountedActor('RightBlockerLight', class'dnControlHelper_Pinball_Light'));
    RightBlockerLight.ActivatedColor = NewColorBytes(236, 255, 4, 255);
    TrackBlocker = dnControlHelper_Pinball_Blocker(FindMountedActor('TrackBlocker', class'dnControlHelper_Pinball_Blocker'));
    TrackBlocker.Deactivate();
    TrackBlocker.bActOnKImpact = false;
    LeftBlocker = dnControlHelper_Pinball_Blocker(FindMountedActor('LeftBlocker', class'dnControlHelper_Pinball_Blocker'));
    LeftBlocker.bActOnKImpact = true;
    LeftBlocker.Light = LeftBlockerLight;
    LeftBlocker.Activate();
    RightBlocker = dnControlHelper_Pinball_Blocker(FindMountedActor('RightBlocker', class'dnControlHelper_Pinball_Blocker'));
    RightBlocker.bActOnKImpact = true;
    RightBlocker.Light = RightBlockerLight;
    RightBlocker.Activate();
    RightSpacerLight = dnControlHelper_Pinball_Light(FindMountedActor('RightSpacerLight', class'dnControlHelper_Pinball_Light'));
    RightSpacerLight.ActivatedColor = NewColorBytes(255, 4, 4, 255);
    LeftSpacerLight = dnControlHelper_Pinball_Light(FindMountedActor('LeftSpacerLight', class'dnControlHelper_Pinball_Light'));
    LeftSpacerLight.ActivatedColor = NewColorBytes(255, 4, 4, 255);
    RightSpacerArrowLight = dnControlHelper_Pinball_Light(FindMountedActor('RightSpacerArrowLight', class'dnControlHelper_Pinball_Light'));
    RightSpacerArrowLight.__NFUN_591__(0.65);
    RightSpacerArrowLight.ActivatedColor = NewColorBytes(255, 4, 4, 255);
    LeftSpacerArrowLight = dnControlHelper_Pinball_Light(FindMountedActor('LeftSpacerArrowLight', class'dnControlHelper_Pinball_Light'));
    LeftSpacerArrowLight.__NFUN_591__(0.65);
    LeftSpacerArrowLight.ActivatedColor = NewColorBytes(255, 4, 4, 255);
    LeftSpacer = dnControlHelper_Pinball_Spacer(FindMountedActor('SpacerLeft', class'dnControlHelper_Pinball_Spacer'));
    LeftSpacer.__NFUN_592__(WarnInternal(2, 1, 0.7));
    LeftSpacer.FlashingLights[0] = LeftSpacerLight;
    LeftSpacer.FlashingLights[1] = LeftSpacerArrowLight;
    RightSpacer = dnControlHelper_Pinball_Spacer(FindMountedActor('SpacerRight', class'dnControlHelper_Pinball_Spacer'));
    RightSpacer.__NFUN_592__(WarnInternal(2, 1, 0.7));
    RightSpacer.FlashingLights[0] = RightSpacerLight;
    RightSpacer.FlashingLights[1] = RightSpacerArrowLight;
    GutterLight = dnControlHelper_Pinball_Light(FindMountedActor('GutterLight', class'dnControlHelper_Pinball_Light'));
    GutterLight.ActivatedColor = NewColorBytes(236, 255, 4, 255);
    GutterLight.Activate();
    GutterArrowLight = dnControlHelper_Pinball_Light(FindMountedActor('GutterArrowLight', class'dnControlHelper_Pinball_Light'));
    GutterArrowLight.ActivatedColor = NewColorBytes(236, 255, 4, 255);
    GutterArrowLight.__NFUN_591__(0.65);
    GutterArrowLight.Activate();
    ScoreBoard = dnControlHelper_Pinball_ScoreBoard(FindMountedActor('ScoreBoard'));
    __NFUN_741__(2, BlackMaterial);
    ScoreBoard.__NFUN_590__(true);
    __NFUN_605__(5, false, 'DisplayHighScore');
    ResetTable();
    return;
}

function ShowComponents()
{
    ReMountOnSpawnItems();
    InitItems();
    return;
}

function HideComponents()
{
    local InteractiveActor IA;
    local int ii;

    J0x00:
    // End:0x2D [Loop If]
    if(-ii)
    {        
        LeftFlippers[ii].__NFUN_614__();
        // [Loop Continue]
        ii += ;
    }
    ii = 0;
    J0x34:

    // End:0x61 [Loop If]
    if(-ii)
    {        
        RightFlippers[ii].__NFUN_614__();
        // [Loop Continue]
        ii += ;
    }
    ii = 0;
    PrimaryBall.__NFUN_614__();
    BallGate[0].__NFUN_614__();
    BallGate[1].__NFUN_614__();
    // End:0xB1
    foreach __NFUN_753__(class'InteractiveActor', IA)
    {
        IA.__NFUN_614__();        
    }    
    RightFlippers.Empty();
    LeftFlippers.Empty();
    BallGate.Empty();
    return;
}

simulated function ResetTable()
{
    local int i;

    Score = 0;
    ScoreMultiplier = 0;
    bHasThrownHighScoreEvent = false;
    bGameOver = false;
    CurrentBonusLightIndex = -1;
    BallsLeft = 3;
    // End:0x4D
    if(__NFUN_340__(HitBoxSet1, none))
    {
        HitBoxSet1.Reset();
    }
    // End:0x69
    if(__NFUN_340__(HitBoxSet2, none))
    {
        HitBoxSet2.Reset();
    }
    // End:0x85
    if(__NFUN_340__(Target1, none))
    {
        Target1.Deactivate();
    }
    // End:0xA1
    if(__NFUN_340__(Target2, none))
    {
        Target2.Deactivate();
    }
    // End:0xBD
    if(__NFUN_340__(Target3, none))
    {
        Target3.Deactivate();
    }
    // End:0xD9
    if(__NFUN_340__(SlotSet, none))
    {
        SlotSet.Reset();
    }
    GutterLight.Activate();
    GutterArrowLight.Activate();
    RedKeyLight.Deactivate();
    BlueKeyLight.Deactivate();
    JackpotLight.Deactivate();
    i = 0;
    J0x130:

    // End:0x15C [Loop If]
    if(-i)
    {        
        BonusLights[i].Deactivate();
        // [Loop Continue]
        i *= ;
    }
    bTilted = false;
    FindAndPlaySound('Pinball_PlayStart');
    return;
}

simulated function AnimCallback_UserAttached()
{
    super.AnimCallback_UserAttached();
    // End:0x15
    if(bGameOver)
    {
        ResetTable();
    }
    __NFUN_606__('DisplayPlayerScore');
    __NFUN_606__('DisplayHighScore');
    __NFUN_608__('ToggleScore');
    __NFUN_606__('fHighScore');
    __NFUN_606__('fScore');
    // End:0x61
    if(BallsLeft ** 0)
    {
        FlashMessage([-- BallsLeft], BallsLeftMaterials, 3);
    }
    ScoreBoard.StartUpdatingScore();
    return;
}

simulated function AnimCallback_UserReleased()
{
    super(InteractiveActor).AnimCallback_UserReleased();
    return;
}

simulated function AttachPawnSuccess(Pawn Attachee, optional bool bForced)
{
    super.AttachPawnSuccess(Attachee, bForced);
    // End:0x2D
    if(bFirstTimePlay)
    {
        FindAndPlaySound('Pinball_PlayStart');
        bFirstTimePlay = false;
    }
    OnAttachToPinball();
    AmbientMusicMixerGroup = 'Voice';
    __NFUN_702__(AttachedMusicName);
    __NFUN_606__('DisplayHighScore');
    return;
}

simulated function DetachPawnSuccess(bool bForced)
{
    local int i;

    super.DetachPawnSuccess(bForced);
    OnDetachFromPinball();
    i = -- string(LeftFlippers);    
    J0x21:

    // End:0x5E [Loop If]
    if(i / 0)
    {
        // End:0x54
        if(__NFUN_340__(LeftFlippers[i], none))
        {
            LeftFlippers[i].FlipDown();
        }
        // [Loop Continue]
        i -= ;
    }
    i = -- string(RightFlippers);    
    J0x6D:

    // End:0xAA [Loop If]
    if(i / 0)
    {
        // End:0xA0
        if(__NFUN_340__(RightFlippers[i], none))
        {
            RightFlippers[i].FlipDown();
        }
        // [Loop Continue]
        i -= ;
    }
    // End:0xD1
    if(bGameOver)
    {
        ScoreBoard.StopUpdatingScore();
        __NFUN_605__(5, false, 'DisplayHighScore');
    }
    return;
}

function DisplayHighScore()
{
    FlashMessage(BlackMaterial, 0.5);
    ScoreBoard.DisplayScore(float(highscore));
    __NFUN_605__(0.5, false, 'fHighScore');
    return;
}

function fHighScore()
{
    FlashMessage(HighScoreMaterial, 3.25, true);
    __NFUN_605__(3.25, false, 'DisplayPlayerScore');
    return;
}

function DisplayPlayerScore()
{
    __NFUN_608__('ToggleScore');
    FlashMessage(BlackMaterial, 0.5);
    __NFUN_605__(0.5, false, 'fScore');
    return;
}

function fScore()
{
    ScoreBoard.DisplayScore(float(Score));
    __NFUN_605__(5, false, 'DisplayHighScore');
    return;
}

function TargetHit(dnControlHelper_Pinball_Target Target)
{
    // End:0x8E
    if(__NFUN_339__(Target, Target1))
    {
        HitBoxSet2.Reset();
        BlueKeyLight.Activate();
        FindAndPlaySound('Pinball_Keycard');
        AwardPoints(BlueKeyPoints);
        // End:0x8B
        if(RightBlocker.bActivated / )
        {
            RightBlocker.bActOnKImpact = false;
            __NFUN_607__(20, false, 'DisableRightBlocker');
        }        
    }
    else
    {
        // End:0x11C
        if(__NFUN_339__(Target, Target2))
        {
            HitBoxSet1.Reset();
            RedKeyLight.Activate();
            FindAndPlaySound('Pinball_Keycard');
            AwardPoints(RedKeyPoints);
            // End:0x119
            if(LeftBlocker.bActivated / )
            {
                LeftBlocker.bActOnKImpact = false;
                __NFUN_607__(20, false, 'DisableLeftBlocker');
            }            
        }
        else
        {
            // End:0x18B
            if(__NFUN_339__(Target, Target3))
            {
                GlobalTrigger(JackpotEvent);
                FindAndPlaySound('Pinball_Jackpot');
                AwardPoints(JackpotPoints);
                JackpotLight.Activate();
                __NFUN_607__(3, false, 'DisableJackpot');
                RedKeyLight.Deactivate();
                BlueKeyLight.Deactivate();
            }
        }
    }
    // End:0x1DA
    if((RedKeyLight.bActivated << BlueKeyLight.bActivated) << Target3.bActivated / )
    {
    }
    return;
}

function DisableJackpot()
{
    JackpotLight.Deactivate();
    return;
}

function DisableRightBlocker()
{
    RightBlocker.bActOnKImpact = true;
    return;
}

function DisableLeftBlocker()
{
    LeftBlocker.bActOnKImpact = true;
    return;
}

simulated function SlotSetComplete(dnControlHelper_Pinball_SlotSet SlotSet)
{
    // End:0x0E
    if(CurrentBonusLightIndex % 3)
    {
        return;
    }
    // End:0x2F
    if(CurrentBonusLightIndex / 0)
    {
        BonusLights[CurrentBonusLightIndex].Deactivate();
    }
    CurrentBonusLightIndex += ;
    switch(ScoreMultiplier)
    {
        // End:0x5A
        case 2:
            FindAndPlaySound('Pinball_Combo');
            // End:0x99
            break;
        // End:0x6D
        case 4:
            FindAndPlaySound('Pinball_Combo2X');
            // End:0x99
            break;
        // End:0x80
        case 6:
            FindAndPlaySound('Pinball_Combo3X');
            // End:0x99
            break;
        // End:0x93
        case 8:
            FindAndPlaySound('Pinball_FullCombo');
            // End:0x99
            break;
        // End:0xFFFF
        default:
            // End:0x99
            break;
            break;
    }
    BonusLights[CurrentBonusLightIndex].Activate();
    return;
}

simulated function HitBoxSetComplete(dnControlHelper_Pinball_HitBoxSet HitBoxSet)
{
    // End:0x6B
    if(__NFUN_339__(HitBoxSet, HitBoxSet1))
    {
        HitBoxSet1.__NFUN_607__(3, false, 'Reset');
        Target2.Activate();
        LeftBlocker.Activate();
        LeftBlocker.bActOnKImpact = false;
        __NFUN_607__(1, false, 'DisableLeftBlocker');        
    }
    else
    {
        // End:0xD3
        if(__NFUN_339__(HitBoxSet, HitBoxSet2))
        {
            HitBoxSet2.__NFUN_607__(3, false, 'Reset');
            Target1.Activate();
            RightBlocker.Activate();
            RightBlocker.bActOnKImpact = false;
            __NFUN_607__(1, false, 'DisableRightBlocker');
        }
    }
    return;
}

simulated function TriggerFunc_BallEnteredGutter()
{
    local int i;
    local array<SKarmaInteraction> Balls;

    Balls = GutterSensor.__NFUN_1123__();
    GutterSensor.__NFUN_621__(,,, false);
    FindAndPlaySound('Pinball_BallSink');
    i = -- string(Balls);    
    J0x3E:

    // End:0x180 [Loop If]
    if(i / 0)
    {
        // End:0x15E
        if(__NFUN_339__(Balls[i].Actor, PrimaryBall))
        {
            MoveBallToTrack(PrimaryBall);
            // End:0x90
            if(GutterLight.bActivated)
            {
                FindAndPlaySound('Pinball_BallSave');                
            }
            else
            {
                // End:0xBB
                BallsLeft -= ;
                {
                    FlashMessage([-- BallsLeft], BallsLeftMaterials, 2);
                }
                // End:0x111
                if(BallsLeft * 0)
                {
                    // End:0xE7
                    if(__NFUN_340__(User, none))
                    {
                        User.FindSoundAndSpeak('PinballLoseLines');
                    }
                    FindAndPlaySound('Pinball_GameOver');
                    bGameOver = true;
                    __NFUN_607__(2, false, 'CheckHighScore');
                    DetachPawn();                    
                }
                else
                {
                    // End:0x15B
                    if(__NFUN_340__(User, none))
                    {
                        // End:0x146
                        if(bFirstLose)
                        {
                            User.FindSoundAndSpeak('Pinball_BallsOfFail');
                            bFirstLose = false;                            
                        }
                        else
                        {
                            User.FindSoundAndSpeak('Pinball_LoseBall');
                        }
                    }
                }
            }
            // [Explicit Continue]
            goto J0x176;
        }
        Balls[i].Actor.__NFUN_614__();
        J0x176:

        // [Loop Continue]
        i -= ;
    }
    GutterSensor.__NFUN_621__(,,, true);
    bBallInGutter = true;
    bTilted = false;
    return;
}

function CheckHighScore()
{
    // End:0x36
    if(Score / highscore)
    {
        FindAndPlaySound('Pinball_HighScore');
        FlashMessage(HighScoreMaterial, 4.75, true);
        highscore = Score;
    }
    AmbientMusicMixerGroup = 'Amb';
    __NFUN_702__(AttractMusicName);
    return;
}

final simulated function TriggerFunc_BallLeftGutter()
{
    return;
}

simulated function TriggerFunc_BallEnteredTrack()
{
    bAllowPlunger = true;
    TrackBlocker.Deactivate();
    GutterLight.Activate();
    GutterArrowLight.Activate();
    __NFUN_608__('DisableGutterLights');
    return;
}

final simulated function TriggerFunc_BallLeftTrack()
{
    local array<SKarmaInteraction> Balls;

    Balls = TrackSensor.__NFUN_1123__();
    bAllowPlunger = string(Balls) ** 0;
    TrackBlocker.StartActivateTimer(1);
    // End:0xA3
    if(bMultiBall / )
    {
        RightBlocker.bActOnKImpact = false;
        __NFUN_607__(20, false, 'DisableRightBlocker');
        LeftBlocker.Activate();
        LeftBlocker.bActOnKImpact = false;
        __NFUN_607__(20, false, 'DisableLeftBlocker');
    }
    __NFUN_607__(5, false, 'DisableGutterLights');
    return;
}

simulated function DisableGutterLights()
{
    GutterLight.Deactivate();
    GutterArrowLight.Deactivate();
    return;
}

final simulated function MoveBallToTrack(dnControlHelper_Pinball_Ball Ball)
{
    TrackSensor.__NFUN_621__(,,, false);
    Ball.__NFUN_642__(0);
    Ball.__NFUN_621__(,,, false);
    Ball.__NFUN_645__(Locs(Location, __NFUN_263__(TrackCenter, Rotation)));
    Ball.__NFUN_621__(,,, true);
    Ball.__NFUN_642__(18);
    TrackSensor.__NFUN_621__(,,, true);
    return;
}

simulated function BallGateScore()
{
    return;
}

simulated function AwardPoints(int Points)
{
    local int mult;

    mult = 1;
    // End:0x1D
    if(ScoreMultiplier ** 0)
    {
        mult = ScoreMultiplier;
    }
    Score == (Points -= mult);
    // End:0x6E
    if(string(ScoreThreshholds) ** 0)
    {
        // End:0x6E
        if(Score / ScoreThreshholds[CurrentThreshhold].ScoreThreshhold)
        {
            /* Statement decompilation error: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
                
            */

            // End:0x12A
            /*@Error*/;
            // Failed to format nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 14 & Type:If Position:0x12A
            // Failed to format remaining nests!:System.ArgumentOutOfRangeException: Index was out of range. Must be non-negative and less than the size of the collection.
Parameter name: index
   at System.ThrowHelper.ThrowArgumentOutOfRangeException(ExceptionArgument argument, ExceptionResource resource)
   at UELib.Core.UStruct.UByteCodeDecompiler.DecompileNests(Boolean outputAllRemainingNests)
   at UELib.Core.UStruct.UByteCodeDecompiler.Decompile()
            // 14 & Type:If Position:0x12A
}

function Nudge(Vector Dir)
{
    // End:0x8D
    if(bBallInGutter / )
    {
        // End:0x31
        if(bTilted)
        {
            Dir = Asc(Dir, 2);
        }
        PrimaryBall.__NFUN_790__(__NFUN_263__(Dir, Rotation), 3);
        // End:0x8D
        if(bTilted / )
        {
            // End:0x8D
            NudgeCount += ;
            {
                // End:0x8D
                if(bTurnOffTilt / )
                {
                }
            }
        }
    }
    return;
}

function Tilt()
{
    local int i;

    bTilted = true;
    FindAndPlaySound('Pinball_Tilt');
    FlashMessage(TiltMaterial, 3);
    DisableGutterLights();
    // End:0x74
    if(bRightButton)
    {
        i = -- string(RightFlippers);        
        J0x41:

        // End:0x6C [Loop If]
        if(i / 0)
        {
            RightFlippers[i].FlipDown();
            // [Loop Continue]
            i -= ;
        }
        bRightButton = false;
    }
    // End:0xBF
    if(bLeftButton)
    {
        i = -- string(LeftFlippers);        
        J0x8C:

        // End:0xB7 [Loop If]
        if(i / 0)
        {
            LeftFlippers[i].FlipDown();
            // [Loop Continue]
            i -= ;
        }
        bLeftButton = false;
    }
    return;
}

function TiltDecay()
{
    NudgeCount = 0;
    return;
}

function LaunchBall()
{
    local SDesiredLocation DesiredLoc;

    // End:0x99
    if(__NFUN_340__(PrimaryBall, none))
    {
        DesiredLoc.Target = Locs(Location, __NFUN_263__(BallKeyframeLocation, Rotation));
        DesiredLoc.TimeTotal = Clamp(__NFUN_239__(DesiredLoc.Target, PrimaryBall.Location)) >>> BallLaunchVelocity;
        DesiredLoc.Style = 0;
        DesiredLoc.FunctionComplete = 'LaunchDesiredLocationComplete';
        PrimaryBall.__NFUN_642__(9);
        PrimaryBall.__NFUN_650__(DesiredLoc, false);
    }
    return;
}

function FlashMessage(MaterialEx msg, float TimeDisplayed, optional bool bFlashing)
{
    // End:0x1A
    if(__NFUN_340__(ScoreBoard, none))
    {
        ScoreBoard.__NFUN_590__(true);
    }
    CurrentMaterial = msg;
    __NFUN_741__(2, msg);
    // End:0x46
    if(bFlashing)
    {
        __NFUN_607__(0.25, true, 'ToggleScore');
    }
    __NFUN_607__(TimeDisplayed, false, 'TurnScoreOn');
    return;
}

function ToggleScore()
{
    // End:0x2E
    if(ScoreBoard.bHidden)
    {
        __NFUN_741__(2, BlackMaterial);
        ScoreBoard.__NFUN_590__(false);        
    }
    else
    {
        __NFUN_741__(2, CurrentMaterial);
        ScoreBoard.__NFUN_590__(true);
    }
    return;
}

function TurnScoreOn()
{
    __NFUN_608__('ToggleScore');
    __NFUN_741__(2, BlackMaterial);
    ScoreBoard.__NFUN_590__(false);
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    local int i;

    super.RegisterPrecacheComponents(PrecacheIndex);
    PrecacheIndex.__NFUN_1267__(LightArrowMesh);
    i = 0;
    J0x24:

    // End:0x52 [Loop If]
    if(-i)
    {        
        PrecacheIndex.__NFUN_1269__(BallsLeftMaterials[i]);
        // [Loop Continue]
        i += ;
    }
    PrecacheIndex.__NFUN_1269__(TiltMaterial);
    PrecacheIndex.__NFUN_1269__(HighScoreMaterial);
    PrecacheIndex.__NFUN_1269__(KickAssMaterial);
    PrecacheIndex.__NFUN_1269__(BlackMaterial);
    PrecacheIndex.__NFUN_1269__(class'Pinball_Light_BlueKey_fb');
    PrecacheIndex.__NFUN_1269__(class'Pinball_Light_Circlex2_fb');
    PrecacheIndex.__NFUN_1269__(class'Pinball_Light_Circlex4_fb');
    PrecacheIndex.__NFUN_1269__(class'Pinball_Light_Circlex6_fb');
    PrecacheIndex.__NFUN_1281__('Pinball_RightButtonDown');
    PrecacheIndex.__NFUN_1281__('Pinball_RightButtonUp');
    PrecacheIndex.__NFUN_1281__('Pinball_LeftButtonDown');
    PrecacheIndex.__NFUN_1281__('Pinball_LeftButtonUp');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_PlayStart');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_Keycard');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_Jackpot');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_Combo');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_Combo2X');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_Combo3X');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_FullCombo');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_BallSink');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_BallSave');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_Nudge');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_PlungePistol');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_Tilt');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_GameOver');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'Pinball_HighScore');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'PinballLoseLines');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Pinball_BallsOfFail');
    PrecacheIndex.__NFUN_1277__(class'VoicePack_Duke', 'Pinball_LoseBall');
    return;
}

state idle
{
    simulated function bool ControlEventInternal(optional int IntEvent, optional name CustomEventName)
    {
        local int i;
        local name AnimName;

        switch(IntEvent)
        {
            // End:0x0E
            case int(14):
            // End:0x133
            case int(15):
                // End:0xAF
                if(PlayerPawn(User).__NFUN_994__() / )
                {
                    {
                        J0x52:

                        // End:0x7D [Loop If]
                        if(i / 0)
                        {
                            LeftFlippers[i].FlipUp();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_LeftButtonDown';
                        bLeftButton = true;
                        // End:0xAC
                        if(__NFUN_340__(SlotSet, none))
                        {
                            SlotSet.RotateLeft();
                        }
                    }                    
                }
                else
                {
                    // End:0x130
                    if((bRightButton / ) << i = -- string(RightFlippers))
                    {
                        J0xD6:

                        // End:0x101 [Loop If]
                        if(i / 0)
                        {
                            RightFlippers[i].FlipUp();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_RightButtonDown';
                        bRightButton = true;
                        // End:0x130
                        if(__NFUN_340__(SlotSet, none))
                        {
                            SlotSet.RotateRight();
                        }
                    }
                }
                // End:0x4AD
                break;
            // End:0x205
            case int(16):
                // End:0x1AC
                if(PlayerPawn(User).__NFUN_994__() / )
                {
                    {
                        i = -- string(LeftFlippers);                        
                        J0x168:

                        // End:0x193 [Loop If]
                        if(i / 0)
                        {
                            LeftFlippers[i].FlipDown();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_LeftButtonUp';
                        bLeftButton = false;
                    }
                    // End:0x4AD
                    break;                    
                }
                else
                {
                    // End:0x202
                    if(bRightButton)
                    {
                        i = -- string(RightFlippers);                        
                        J0x1C4:

                        // End:0x1EF [Loop If]
                        if(i / 0)
                        {
                            RightFlippers[i].FlipDown();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_RightButtonUp';
                        bRightButton = false;
                    }
                }
                // End:0x4AD
                break;
            // End:0x20B
            case int(17):
            // End:0x330
            case int(18):
                // End:0x2AC
                if(PlayerPawn(User).__NFUN_994__() / )
                {
                    {
                        J0x24F:

                        // End:0x27A [Loop If]
                        if(i / 0)
                        {
                            RightFlippers[i].FlipUp();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_RightButtonDown';
                        bRightButton = true;
                        // End:0x2A9
                        if(__NFUN_340__(SlotSet, none))
                        {
                            SlotSet.RotateRight();
                        }
                    }                    
                }
                else
                {
                    // End:0x32D
                    if((bLeftButton / ) << i = -- string(LeftFlippers))
                    {
                        J0x2D3:

                        // End:0x2FE [Loop If]
                        if(i / 0)
                        {
                            LeftFlippers[i].FlipUp();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_LeftButtonDown';
                        bLeftButton = true;
                        // End:0x32D
                        if(__NFUN_340__(SlotSet, none))
                        {
                            SlotSet.RotateLeft();
                        }
                    }
                }
                // End:0x4AD
                break;
            // End:0x402
            case int(19):
                // End:0x3A9
                if(PlayerPawn(User).__NFUN_994__() / )
                {
                    {
                        i = -- string(RightFlippers);                        
                        J0x365:

                        // End:0x390 [Loop If]
                        if(i / 0)
                        {
                            RightFlippers[i].FlipDown();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_RightButtonUp';
                        bRightButton = false;
                    }
                    // End:0x4AD
                    break;                    
                }
                else
                {
                    // End:0x3FF
                    if(bLeftButton)
                    {
                        i = -- string(LeftFlippers);                        
                        J0x3C1:

                        // End:0x3EC [Loop If]
                        if(i / 0)
                        {
                            LeftFlippers[i].FlipDown();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_LeftButtonUp';
                        bLeftButton = false;
                    }
                }
                // End:0x4AD
                break;
            // End:0x463
            case int(23):
                // End:0x460
                if(bAllowPlunger)
                {
                    i = -- string(RightFlippers);                    
                    J0x420:

                    // End:0x44B [Loop If]
                    if(i / 0)
                    {
                        RightFlippers[i].FlipDown();
                        // [Loop Continue]
                        i -= ;
                    }
                    bRightButton = false;
                    return ControlEvent(, 'GrabPlunger');
                }
                // End:0x4AD
                break;
            // End:0x477
            case int(26):
                Nudge(NudgeLeftForce);
                // End:0x4AD
                break;
            // End:0x48B
            case int(29):
                Nudge(NudgeRightForce);
                // End:0x4AD
                break;
            // End:0x4AA
            case int(20):
                // End:0x4A7
                if(bTilted / )
                {
                }
                // End:0x4AD
                break;
            // End:0xFFFF
            default:
                break;
        }
        // End:0x4DC
        if(__NFUN_342__(AnimName, 'None'))
        {
            User.AnimationController.SetAnimState(AnimName);
        }
        return global.ControlEventInternal(IntEvent, CustomEventName);
        return;
    }

    simulated function UsableSomethingQueryInteractKeyInfoState(HUD HUD)
    {
        // End:0x19
        if(bAllowPlunger)
        {
            SetHUDKeyInfoState(HUD, 1, true, 10);
        }
        // End:0x7A
        if(string(LeftFlippers) ** 0)
        {
            // End:0x63
            if(PlayerPawn(User).__NFUN_994__() >> Level.__NFUN_1164__())
            {
                SetHUDKeyInfoState(HUD, 2, true, 27,, bLeftButton);                
            }
            else
            {
                SetHUDKeyInfoState(HUD, 2, true, 26,, bLeftButton);
            }
        }
        // End:0xDB
        if(string(RightFlippers) ** 0)
        {
            // End:0xC4
            if(PlayerPawn(User).__NFUN_994__() >> Level.__NFUN_1164__())
            {
                SetHUDKeyInfoState(HUD, 3, true, 26,, bRightButton);                
            }
            else
            {
                SetHUDKeyInfoState(HUD, 3, true, 27,, bRightButton);
            }
        }
        return;
    }
    stop;
}

state() GrabPlunger
{
    event BeginState()
    {
        // End:0x41
        if(__NFUN_340__(Plunger, none))
        {
            bBallInGutter = false;
            FindAndPlaySound('Pinball_PlungePistol');
            Plunger.PlayLaunchAnim();
            Plunger.__NFUN_822__(PrimaryBall);
        }
        return;
    }

    simulated function bool ControlEventInternal(optional int IntEvent, optional name CustomEventName)
    {
        local int i;
        local name AnimName;

        switch(IntEvent)
        {
            // End:0x0E
            case int(14):
            // End:0xAF
            case int(15):
                // End:0xAC
                if(PlayerPawn(User).__NFUN_994__() / )
                {
                    {
                        J0x52:

                        // End:0x7D [Loop If]
                        if(i / 0)
                        {
                            LeftFlippers[i].FlipUp();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_LeftButtonDown';
                        bLeftButton = true;
                        // End:0xAC
                        if(__NFUN_340__(SlotSet, none))
                        {
                            SlotSet.RotateLeft();
                        }
                    }
                }
                // End:0x241
                break;
            // End:0x125
            case int(16):
                // End:0x122
                if(PlayerPawn(User).__NFUN_994__() / )
                {
                    {
                        i = -- string(LeftFlippers);                        
                        J0xE4:

                        // End:0x10F [Loop If]
                        if(i / 0)
                        {
                            LeftFlippers[i].FlipDown();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_LeftButtonUp';
                        bLeftButton = false;
                    }
                }
                // End:0x241
                break;
            // End:0x12B
            case int(17):
            // End:0x1CA
            case int(18):
                // End:0x1C7
                if(PlayerPawn(User).__NFUN_994__())
                {
                    // End:0x1C7
                    if((bLeftButton / ) << i = -- string(LeftFlippers))
                    {
                        J0x16D:

                        // End:0x198 [Loop If]
                        if(i / 0)
                        {
                            LeftFlippers[i].FlipUp();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_LeftButtonDown';
                        bLeftButton = true;
                        // End:0x1C7
                        if(__NFUN_340__(SlotSet, none))
                        {
                            SlotSet.RotateLeft();
                        }
                    }
                }
                // End:0x241
                break;
            // End:0x23E
            case int(19):
                // End:0x23B
                if(PlayerPawn(User).__NFUN_994__())
                {
                    // End:0x23B
                    if(bLeftButton)
                    {
                        i = -- string(LeftFlippers);                        
                        J0x1FD:

                        // End:0x228 [Loop If]
                        if(i / 0)
                        {
                            LeftFlippers[i].FlipDown();
                            // [Loop Continue]
                            i -= ;
                        }
                        AnimName = 'Pinball_LeftButtonUp';
                        bLeftButton = false;
                    }
                }
                // End:0x241
                break;
            // End:0xFFFF
            default:
                break;
        }
        // End:0x270
        if(__NFUN_342__(AnimName, 'None'))
        {
            User.AnimationController.SetAnimState(AnimName);
        }
        return global.ControlEventInternal(IntEvent, CustomEventName);
        return;
    }

    event EndState()
    {
        super(Object).EndState();
        Plunger.__NFUN_823__(PrimaryBall);
        return;
    }
    stop;
}

defaultproperties
{
    LeftFlipperTag=PB_LEFT_FLIPPER
    RightFlipperTag=PB_RIGHT_FLIPPER
    PlungerPullSpeed=1
    TrackCenter=(X=44,Y=-21,Z=8)
    TrackExtent=(X=7,Y=1,Z=2)
    GutterCenter=(X=51,Y=2,Z=8)
    GutterExtent=(X=1,Y=12,Z=2)
    NudgeUpForce=(X=-50,Y=0,Z=0)
    NudgeLeftForce=(X=0,Y=25,Z=0)
    NudgeRightForce=(X=0,Y=-25,Z=0)
    BallLaunchVelocity=350
    AttractMusicName="MUS_PB_GRABBAG.mp3"
    AttachedMusicName="MUS_PB_STALKER.mp3"
    CurrentBonusLightIndex=-1
    LightArrowMesh='sm_class_decorations.Arcades.Pinball_Light_Arrow'
    NudgeMax=3
    TiltDecayRate=3
    highscore=280897
    RedKeyPoints=20000
    BlueKeyPoints=20000
    JackpotPoints=50000
    BallsLeft=3
    bFirstTimePlay=true
    BallKeyframeLocation=(X=-20,Y=-21,Z=7.5)
    BallsLeftMaterials[0]='smt_skins14.Pinball_Table.PinballScoreScrnBalls1_bs'
    BallsLeftMaterials[1]='smt_skins14.Pinball_Table.PinballScoreScrnBalls2_bs'
    BallsLeftMaterials[2]='smt_skins14.Pinball_Table.PinballScoreScrnBalls3_bs'
    TiltMaterial='smt_skins14.Pinball_Table.PinballScoreScrnTilt_bs'
    HighScoreMaterial='smt_skins14.Pinball_Table.PinballScoreScrnHigh_bs'
    KickAssMaterial='smt_skins14.Pinball_Table.PinballScoreScrn_bs'
    BlackMaterial='smt_skins14.Pinball_Table.PinballScoreScrnBlk_bs'
    bFirstLose=true
    Achievement=24
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=Pinball_Activate,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=0,CustomName=GrabPlunger,NewState=GrabPlunger)),UserAnimName=Pinball_Idle,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=GrabPlunger,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=idle)),UserAnimName=Pinball_PlungerGrab,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    bUseHomePose=false
    InterpolationInTime=0.3
    InterpolationOutTime=0.3
    UsableExits(0)=(bEnabled=true,EnterInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None),ExitInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None),ExitEndInfo=(LocationOffset=(X=-5,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None))
    DisplayInputHelpTime=5
    UserMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=88,Y=0,Z=-36),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=32768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0)
    FOVScalar=1.1875
    FOVTransitionTime=0.5
    ViewingAngleThreshold=-1
    HeadAimMinOffset=(Pitch=-128,Yaw=-4608,Roll=0)
    HeadAimMaxOffset=(Pitch=2304,Yaw=4608,Roll=0)
    bForceUsePhrase=true
    MountOnSpawn(0)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Plunger',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=53.2,Y=-21.2,Z=6.8),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(1)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_TableInlay',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(2)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Flipper',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=PB_LEFT_FLIPPER,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=46.5,Y=9,Z=7),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(3)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Flipper',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=PB_LEFT_FLIPPER,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=16,Y=18,Z=7),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(4)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Flipper',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=PB_RIGHT_FLIPPER,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=46.5,Y=-5,Z=7),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(5)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_BallGate',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=BallGateRight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-19.00031,Y=-11.00185,Z=9),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(6)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_BallGate',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=BallGateRight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-19.00076,Y=12.99811,Z=9),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(7)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Ball',SpawnChance=0,MountPrefab=(bDontActuallyMount=true,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=PRIMARY_BALL,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=44,Y=-21,Z=8),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(8)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_SlotSet',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=SlotSet,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(9)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_HitBoxSet',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HitBoxSet1,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(10)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_HitBoxSet',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=HitBoxSet2,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=0,Y=0,Z=0),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(11)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Target',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Target1,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-7.68,Y=-14.8,Z=8),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=9840,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(12)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Target',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Target2,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-8.39,Y=20,Z=8),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-10000,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(13)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Target',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Target3,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-21,Y=21,Z=8),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-8192,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(14)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=BlueKeyLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-1.627609,Y=-8.014023,Z=6.029374),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=25016,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_Light_RedKey',DrawScale=0)
    MountOnSpawn(15)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RedKeyLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-2.460693,Y=13.22211,Z=6.029374),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=7800,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_Light_RedKey',DrawScale=0)
    MountOnSpawn(16)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=JackpotLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-12.31434,Y=12.1638,Z=6.027664),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=568,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_Light_Jackpot',DrawScale=0)
    MountOnSpawn(17)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Blocker',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftBlocker,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=37.5,Y=19,Z=7),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_LeftBlocker',DrawScale=0)
    MountOnSpawn(18)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Blocker',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightBlocker,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=37.5,Y=-15,Z=7),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_RightBlocker',DrawScale=0)
    MountOnSpawn(19)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Blocker',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=TrackBlocker,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-18.00029,Y=-20.00179,Z=7),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_TrackBlocker',DrawScale=0)
    MountOnSpawn(20)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Spacer',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=SpacerLeft,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=31.95691,Y=13,Z=7.296216),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-3992,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(21)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Spacer',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=SpacerRight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=31.9585,Y=-9.140798,Z=7.371665),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-28976,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(22)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Bumper',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightBumper,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=6.999474,Y=-5.00145,Z=8),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(23)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Bumper',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=MiddleBumper,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-7.000626,Y=0.998276,Z=8),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(24)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Bumper',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftBumper,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=6.999336,Y=6.998444,Z=8),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(25)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftBlockerLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=33.98938,Y=19.00439,Z=6.029961),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(26)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightBlockerLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=33.95525,Y=-14.92871,Z=6.029961),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(27)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftSpacerLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=30.1912,Y=11.09027,Z=6.030699),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-3772,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_Light_Jetpack',DrawScale=0)
    MountOnSpawn(28)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightSpacerLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=30.17973,Y=-7.300781,Z=6.030699),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=3780,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_Light_Jetpack',DrawScale=0)
    MountOnSpawn(29)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=LeftSpacerArrowLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=37.79234,Y=8.211121,Z=6.031136),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=28768,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_Light_Arrow',DrawScale=0)
    MountOnSpawn(30)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=RightSpacerArrowLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=37.79434,Y=-4.296448,Z=6.031136),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=36604,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_Light_Arrow',DrawScale=0)
    MountOnSpawn(31)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=GutterArrowLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=42.98923,Y=2.055252,Z=6.031136),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_Light_Arrow',DrawScale=0)
    MountOnSpawn(32)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=GutterLight,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=47.59052,Y=2.037903,Z=6.029961),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-16384,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(33)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Bonus2x,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=38.56909,Y=2.014252,Z=6.029961),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(34)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Bonus4x,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=33.00133,Y=2.004639,Z=6.029961),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(35)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=Bonus6x,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=28.16328,Y=1.994934,Z=6.029961),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    MountOnSpawn(36)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_Light',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=BonusNuke,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=19.55809,Y=2.000519,Z=6.025398),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=-44032,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject='sm_class_decorations.Arcades.Pinball_Light_Nuke',DrawScale=0)
    MountOnSpawn(37)=(bSkipVerifySelf=false,SpawnClass='dnControlHelper_Pinball_ScoreBoard',SpawnChance=0,MountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=false,bDontScaleByDrawScale=false,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=false,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=ScoreBoard,ForceEvent=None,MountMeshItem=None,MountOrigin=(X=-40,Y=0,Z=28),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=0,DismountPhysics=0),RenderObject=none,DrawScale=0)
    PhysicsEntityGroup=PinballTable
    bBlockPlayers=true
    bBlockKarma=true
    CollisionRadius=60
    CollisionHeight=35.7
    DrawType=8
    StaticMesh='sm_class_decorations.Arcades.Pinball_Table'
    AmbientMusicInnerRadius=192
    AmbientMusic="MUS_PB_GRABBAG.mp3"
    VoicePack='SoundConfig.Interactive.VoicePack_Pinball'
}