/*******************************************************************************
 * dnControl_Turret_MG42 generated by Eliot.UELib using UE Explorer.exe.
 * Eliot.UELib ? 2009-2022 Eliot van Uytfanghe. All rights reserved.
 * http://eliotvu.com
 *
 * All rights belong to their respective owners.
 *******************************************************************************/
class dnControl_Turret_MG42 extends dnControl_Turret
    collapsecategories;

var(dnTurret) noexport float VertSpreadScalar "scale value for max spread when calculating shot error vertically";
var(dnTurret) noexport float HorizSpreadScalar "scale value for max spread when calculating shot error horizontally";
var(dnTurret) noexport int MaxSpread "integer value representing max spread";
var(dnTurret) noexport float ShotDistance "Maximum trace distance for TraceFire line checks.";
var(dnTurret) noexport int ShotDamage "amount of damage caused by a single shot";
var(dnTurret) noexport float PlayerShotDamageScale "amount to scale ShotDamage by when the turret is controlled by a player.";
var(dnTurret) noexport class<TraceDamageType> TraceDamageType "DamageType to use for our damage.";
var(dnTurret) noexport int MaxTracePenetrationCount "Maximum number of times our shots cna penetrate objects.";
var(dnControl_Turret) noexport deprecated name SE_TurnOnCrashingMode "Changes turret to special crashing mode where firing is not allowed.";
var(dnControl_Turret) noexport deprecated name SE_TurnOffCrashingMode "Changes turret back to regular functionality.";
var(dnControl_Turret) noexport deprecated name SE_Crashing_HitFromRight "Plays a special 'hit from right' reaction animation if in crashing mode.";
var(dnControl_Turret) noexport deprecated name SE_Crashing_HitFromLeft "Plays a special 'hit from left' reaction animation if in crashing mode.";
var int MuzzleIndex;
var name MuzzleNames[3];
var class<SoftParticleSystem> MuzzleFlashClass;
var SoftParticleSystem MuzzleFlashActors[3];
var StaticMesh AmmoCasingMesh;
var class<PhysicsMaterial> AmmoCasingMaterial;
var Vector ShellEjectionDir;
var float ShellEjectionForce;
var int LastUpdateYaw;
var bool bInCrashMode;
var transient int ShellCasingCounter;

simulated event PostVerifySelf()
{
    local int i;

    super.PostVerifySelf();
    i = 0;
    J0x0D:

    // End:0xAF [Loop If]
    if(-i)
    {        
        MuzzleFlashActors[i] = __NFUN_615__(MuzzleFlashClass, self);
        // End:0xA5
        if(__NFUN_340__(MuzzleFlashActors[i], none))
        {
            MuzzleFlashActors[i].MountType = 2;
            MuzzleFlashActors[i].MountMeshItem = MuzzleNames[i];
            MuzzleFlashActors[i].__NFUN_635__(self);
            MuzzleFlashActors[i].TickStyle = 0;
        }
        // [Loop Continue]
        i += ;
    }
    // End:0xCF
    if(-NormalizeRotAxis(MinPitch))
    {        
        MinPitch = -8192;
    }
    // End:0xEB
    if(NormalizeRotAxis(MaxPitch) ** 8192)
    {
        MaxPitch = 8192;
    }
    __NFUN_718__('StartCrashing', SE_TurnOnCrashingMode);
    __NFUN_718__('StopCrashing', SE_TurnOffCrashingMode);
    __NFUN_718__('HitFromRight', SE_Crashing_HitFromRight);
    __NFUN_718__('HitFromLeft', SE_Crashing_HitFromLeft);
    return;
}

event Destroyed()
{
    local PlayerPawn Player;

    // End:0x107
    if(__NFUN_340__(User, none))
    {
        Player = PlayerPawn(User);
        // End:0x107
        if(__NFUN_340__(Player, none))
        {
            User.bBlockCamera = User.default.bBlockCamera;
            User.RestoreCollision();
            PlayerUser.__NFUN_642__(18);
            User.TickBefore = none;
            Player.bUseRemappedEvents = false;
            Player.SetNewPostureState(2);
            Player.__NFUN_1013__();
            Player.MaybeFadeOutChannelBlock('FBBlock', 0.4);
            Player.ViewMapper = none;
            User.DetachFromUsableSomething();
            Player.bAttachedToUsableSomething = false;
            Player.WeaponUp();
        }
    }
    super(dnUsableSomething).Destroyed();
    return;
}

simulated event Actor GetIKActor(name LimbID)
{
    return self;
    return;
}

simulated event PostUserTick(float DeltaTime)
{
    local int AnimIndex, ChannelIndex;
    local float Frame;
    local name GroupName;

    super.PostUserTick(DeltaTime);
    // End:0x26C
    if((__NFUN_340__(User, none) << __NFUN_340__(User.AnimationController, none)) << __NFUN_340__(User.__NFUN_568__(), none))
    {
        // End:0x26C
        if(((((__NFUN_341__(__NFUN_399__(), 'AttachUserAnim') < __NFUN_341__(__NFUN_399__(), 'idle')) < __NFUN_341__(__NFUN_399__(), 'FireDown')) < __NFUN_341__(__NFUN_399__(), 'FiringStop')) < __NFUN_341__(__NFUN_399__(), 'Overheated')) < __NFUN_341__(__NFUN_399__(), 'Pain'))
        {
            AnimIndex = User.AnimationController.__NFUN_1307__('MG42_AimGrid');
            // End:0x26C
            if(AnimIndex + -1)
            {
                User.AnimationController.SetAnimGridState('MG42_AimGrid', 0, float(NormalizeRotAxis(RotatePitch)) >>> 8192);
                ChannelIndex = User.AnimationController.Animations[AnimIndex].AnimationChannel.ChannelLink;
                // End:0x1F7
                if(User.AnimationController.AnimChannels[ChannelIndex].bActAsGroup)
                {
                    GroupName = User.AnimationController.AnimChannels[ChannelIndex].ChannelName;
                    ChannelIndex = 0;
                    J0x193:

                    // End:0x1F7 [Loop If]
                    if(-ChannelIndex)
                    {                        
                        // End:0x1ED
                        if(__NFUN_341__(User.MeshInstance.__NFUN_554__(ChannelIndex, GroupName), User.AnimationController.Animations[AnimIndex].AnimSequence))
                        {
                            // [Explicit Break]
                            goto J0x1F7;
                        }
                        // [Loop Continue]
                        ChannelIndex += ;
                    }
                }
                J0x1F7:

                // End:0x26C
                if(-ChannelIndex)
                {                    
                    User.MeshInstance.GetURLMap(ChannelIndex, 0, GroupName);
                    Frame = float(-- RotateYaw - 65535) >>> ;                    
                    User.MeshInstance.__NFUN_550__(ChannelIndex, Frame, GroupName);
                }
            }
        }
    }
    return;
}

simulated function GetCurrentShellEjectionLocation(out Vector OutEjectionLocation, out Rotator OutEjectionRotation)
{
    local name ShellEjectionBoneName;

    // End:0x6F
    if(__NFUN_340__(__NFUN_568__(), none))
    {
        ShellEjectionBoneName = 'mount_eject';
        __NFUN_354__(__NFUN_342__(ShellEjectionBoneName, 'None'), "No shell ejection bone set");
        OutEjectionLocation = __NFUN_568__().CanSee(ShellEjectionBoneName, true);
        OutEjectionRotation = __NFUN_568__().__NFUN_534__(ShellEjectionBoneName, true);
    }
    return;
}

animevent simulated function Eject_Casing(optional EventInfo AnimEventInfo)
{
    local Vector EjectLoc, EjectVelocity;
    local Rotator EjectRot;
    local float DrawScaleChange;

    // End:0xCD
    if(int(Level.NetMode) + int(NM_DedicatedServer))
    {
        GetCurrentShellEjectionLocation(EjectLoc, EjectRot);
        DrawScaleChange = DrawScale >>> default.DrawScale;
        EjectVelocity = Sleep(ShellEjectionDir, WarnInternal(0, 1, 0)) % ;
        FClamp(EjectVelocity, FRand(Normal(ShellEjectionForce, 40), DrawScaleChange));
        __NFUN_619__(AmmoCasingMesh, AmmoCasingMaterial, EjectLoc, EjectRot, DrawScaleChange, EjectVelocity, Sleep(WarnInternal(0, 0, 0), WarnInternal(3.141593, 3.141593, 3.141593)));
    }
    return;
}

animevent simulated function FireEffects(optional EventInfo AnimEventInfo)
{
    super.FireEffects(AnimEventInfo);
    // End:0x25
    MuzzleIndex += ;
    {
        MuzzleIndex = 0;
    }
    // End:0xC5
    if(__NFUN_340__(MuzzleFlashActors[MuzzleIndex], none))
    {
        MuzzleFlashActors[MuzzleIndex].__NFUN_591__(1);
        MuzzleFlashActors[MuzzleIndex].SystemSizeScale = DrawScale >>> default.DrawScale;
        // End:0xA9
        if(MuzzleFlashActors[MuzzleIndex].bIsFriendSpawner)
        {
            dnFriendFX_Spawners(MuzzleFlashActors[MuzzleIndex]).ExecuteEffect(true);            
        }
        else
        {
            MuzzleFlashActors[MuzzleIndex].Trigger(self, Instigator);
        }
    }
    PerformFire();
    return;
}

simulated function PerformFire(optional EventInfo AnimEventInfo)
{
    local Rotator MuzzleRot;
    local Vector startLocation;

    // End:0x13A
    if((int(Role) % int(ROLE_Authority)) << __NFUN_340__(__NFUN_568__(), none))
    {
        FireShot();
        MuzzleRot = MeshInstance.__NFUN_534__(MuzzleNames[MuzzleIndex], true);
        // End:0x82
        if(__NFUN_340__(PlayerUser, none))
        {
            startLocation = PlayerUser.CalcedViewLocation;
            MuzzleRot.Pitch = PlayerUser.CalcedViewRotation.Pitch;            
        }
        else
        {
            startLocation = MeshInstance.CanSee(MuzzleNames[MuzzleIndex], true, false);
        }
        MuzzleRot.Yaw = Atan(MuzzleRot.Yaw, int(FRand(HorizSpreadScalar, float(MaxSpread))));
        MuzzleRot.Pitch = Atan(MuzzleRot.Pitch, int(FRand(VertSpreadScalar, float(MaxSpread))));
        __NFUN_616__(startLocation, Locs(startLocation, Right(Vector(MuzzleRot), ShotDistance)), TraceDamageType, MaxTracePenetrationCount);
        // End:0x128
        if(ShellCasingCounter % 0)
        {
            Eject_Casing(AnimEventInfo);
        }
        ShellCasingCounter = -- ++ ShellCasingCounter;
        3        
    }
    return;
}

simulated event PerformTraceFireEffects(class<TraceDamageType> TraceDamageType, Vector TraceStart, Vector TraceEnd, Actor HitActor)
{
    local BeamSystem Beam;

    TraceStart = MeshInstance.CanSee(MuzzleNames[MuzzleIndex], true, false);
    super(Actor).PerformTraceFireEffects(TraceDamageType, TraceStart, TraceEnd, HitActor);
    SpawnWeaponTracer(TraceStart, TraceEnd, 1, class'dnTracerFX_BeamSegment', class'WaterBubblesTracer', HitActor);
    return;
}

simulated event float GetBaseDamage(Actor Victim, optional Pawn Instigator, optional class<DamageType> DamageType, optional Vector HitDirection, optional Vector HitLocation, optional name BoneName, optional Vector SourceTraceOrigin)
{
    // End:0x1A
    if(__NFUN_340__(PlayerUser, none))
    {
        return FRand(float(ShotDamage), PlayerShotDamageScale);
    }
    return float(ShotDamage);
    return;
}

simulated function AttachComplete()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x5A [Loop If]
    if(-i)
    {        
        // End:0x50
        if(__NFUN_340__(MuzzleFlashActors[i], none))
        {
            MuzzleFlashActors[i].TickStyle = MuzzleFlashActors[i].default.TickStyle;
        }
        // [Loop Continue]
        i += ;
    }
    super(dnUsableSomething).AttachComplete();
    return;
}

simulated function DetachComplete()
{
    local int i;

    i = 0;
    J0x07:

    // End:0x47 [Loop If]
    if(-i)
    {        
        // End:0x3D
        if(__NFUN_340__(MuzzleFlashActors[i], none))
        {
            MuzzleFlashActors[i].TickStyle = 0;
        }
        // [Loop Continue]
        i += ;
    }
    super(dnControl).DetachComplete();
    return;
}

simulated function StartFiring()
{
    super.StartFiring();
    FindAndPlaySound('MG42_Fire', 1);
    return;
}

simulated function StopFiring()
{
    super.StopFiring();
    FindAndStopSound('MG42_Fire', 3);
    // End:0x34
    if(__NFUN_340__(User, none))
    {
        User.SetUsableSomethingAnimation('MG42_Idle');
    }
    return;
}

simulated function StartOverheatedState()
{
    super.StartOverheatedState();
    FindAndPlaySound('MachinegunTurret_Overheat', 1);
    return;
}

function bool AimingIsEnabled()
{
    return (bInCrashMode / ) << ;
}

final function TriggerFunc_StartCrashing()
{
    bInCrashMode = true;
    ControlEvent(, 'StartCrash');
    return;
}

final function TriggerFunc_StopCrashing()
{
    bInCrashMode = false;
    ControlEvent(, 'StopCrash');
    return;
}

final function TriggerFunc_HitFromRight()
{
    ControlEvent(, 'HitRight');
    return;
}

final function TriggerFunc_HitFromLeft()
{
    ControlEvent(, 'HitLeft');
    return;
}

event RegisterPrecacheComponents(PrecacheIndex PrecacheIndex)
{
    super.RegisterPrecacheComponents(PrecacheIndex);
    // End:0xA5
    if(__NFUN_339__(dnControl_Turret_MountedGrenadeLauncher(self), none))
    {
        PrecacheIndex.__NFUN_1266__(class'dnTracerFX_BeamSegment');
        PrecacheIndex.__NFUN_1266__(class'WaterBubblesTracer');
        PrecacheIndex.__NFUN_1279__(TraceDamageType);
        PrecacheIndex.__NFUN_1267__(AmmoCasingMesh);
        PrecacheIndex.__NFUN_1277__(VoicePack, 'MG42_BrassEject');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'MG42_Fire');
        PrecacheIndex.__NFUN_1277__(VoicePack, 'MG42_Idle');
    }
    PrecacheIndex.__NFUN_1266__(MuzzleFlashClass);
    PrecacheIndex.__NFUN_1281__('MG42_AimGrid');
    PrecacheIndex.__NFUN_1277__(VoicePack, 'MachinegunTurret_Overheat');
    return;
}

state() AttachUserAnim
{
    simulated event BeginState()
    {
        super(Object).BeginState();
        User.__NFUN_605__(InterpolationInTime, false, 'AnimCallback_AttachedToDecoration');
        return;
    }

    simulated event EndState()
    {
        local float StoredRotatePitch, StoredLastRotatePitch;

        StoredRotatePitch = float(RotatePitch);
        StoredLastRotatePitch = float(LastRotatePitch);
        super.EndState();
        RotatePitch = int(StoredRotatePitch);
        LastRotatePitch = int(StoredLastRotatePitch);
        return;
    }
    stop;
}

state() Crashing
{
    event BeginState()
    {
        super(Object).BeginState();
        RotatePitch = 0;
        LastRotatePitch = 0;
        return;
    }
    stop;
}

state HitBase
{
    simulated function AnimCallback_UserAnimEnd()
    {
        super(dnControl).AnimCallback_UserAnimEnd();
        // End:0x1E
        if(bInCrashMode)
        {
            ControlEvent(, 'Crashing');            
        }
        else
        {
            ControlEvent(, 'idle');
        }
        return;
    }
    stop;
}

state() HitRight extends HitBase
{    stop;
}

state() HitLeft extends HitBase
{    stop;
}

defaultproperties
{
    VertSpreadScalar=1
    HorizSpreadScalar=1
    MaxSpread=256
    ShotDistance=50000
    ShotDamage=5
    PlayerShotDamageScale=4.2
    TraceDamageType='dnGame.LargeCaliberBulletDamage'
    MuzzleIndex=-1
    MuzzleNames[0]=mount_muzzle_1
    MuzzleNames[1]=mount_muzzle_2
    MuzzleNames[2]=mount_muzzle_3
    MuzzleFlashClass='p_Weapons.MG42_MuzzleFlash.MG42_MuzzleFlash_Spawner'
    AmmoCasingMesh='sm_class_dukeitems.machinegun_shell_casing.MachineGunShell_Casing'
    AmmoCasingMaterial='dnMaterial.dnPhysicsMaterial_LargeBulletCasing'
    ShellEjectionDir=(X=0,Y=1,Z=-1)
    ShellEjectionForce=200
    MinPitch=-8192
    MaxPitch=8192
    MinYaw=-8192
    MaxYaw=8192
    bClampYaw=true
    bUseInstantAimRate=true
    PitchAimRate=32768
    YawAimRate=16384
    RotationSoundName=MGL_Rotate
    RotationSoundModSideways=(Min=0,Max=0)
    RotationSoundModUpDown=(Min=0,Max=0)
    AimingBoneName=pivot
    FireHeightBoneName=Root
    YawPivotBoneName=mount_yaw
    PitchPivotBoneName=mount_pitch
    Crosshair='dt_hud.crosshairs.crosshair_mg42_fb'
    FireViewShake=(bNoLerp=false,bToggleSign=true,Style=0,Function=4,FalloffActor=none,FalloffDistance=0,ShakeDuration=0.2,ShakeFrequency=0.1,ShakeMagnitude=300,ShakeFullMagnitude=0,ShakeFullMagnitudeTime=0,ShakeName=MG42_Fire_Shake)
    FireRumble=(RumbleName=MG42_Rumble,RumbleDuration=0.14,RumbleLeftMagnitude=0.22,RumbleRightMagnitude=0.55,FalloffActor=none,FalloffDistance=0)
    OverheatMaxTime=10
    HeatPerShot=1.5
    OverheatNoFireSound=MG42_NoFire
    OverheatWarnTimePCT=0.8
    OverheatSmokeClass='p_Weapons.MG42_MuzzleFlash.MG42_Overheat_Main'
    OverheatMountName=mount_muzzle_1
    States(0)=(StateName=Useable,OutEvents=none,Transitions=((ControlEvent=3,CustomName=None,NewState=AttachUserLERP)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=idle_01,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(1)=(StateName=AttachUserLERP,OutEvents=none,Transitions=((ControlEvent=5,CustomName=None,NewState=AttachUserAnim)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(2)=(StateName=AttachUserAnim,OutEvents=none,Transitions=((ControlEvent=7,CustomName=None,NewState=idle)),UserAnimName=MG42_Idle,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=idle_01,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(3)=(StateName=DetachUser,OutEvents=none,Transitions=((ControlEvent=8,CustomName=None,NewState=DetachUserLERP)),UserAnimName=MG42_Deactivate,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=idle_01,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(4)=(StateName=DetachUserLERP,OutEvents=none,Transitions=((ControlEvent=6,CustomName=None,NewState=Useable)),UserAnimName=None,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=None,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(5)=(StateName=idle,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=15,CustomName=None,NewState=FireDown),(ControlEvent=0,CustomName=Overheated,NewState=Overheated),(ControlEvent=0,CustomName=Pain,NewState=Pain),(ControlEvent=0,CustomName=StartCrash,NewState=Crashing)),UserAnimName=MG42_Idle,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=idle_01,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(6)=(StateName=FireDown,OutEvents=none,Transitions=((ControlEvent=16,CustomName=None,NewState=idle),(ControlEvent=0,CustomName=CantFire,NewState=idle),(ControlEvent=0,CustomName=Overheated,NewState=Overheated),(ControlEvent=0,CustomName=Pain,NewState=Pain),(ControlEvent=0,CustomName=StartCrash,NewState=Crashing)),UserAnimName=MG42_Fire,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=Fire,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(7)=(StateName=Overheated,OutEvents=none,Transitions=((ControlEvent=4,CustomName=None,NewState=DetachUser),(ControlEvent=0,CustomName=CooledDown,NewState=idle)),UserAnimName=MG42_Idle,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=idle_01,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(8)=(StateName=Pain,OutEvents=none,Transitions=((ControlEvent=9,CustomName=None,NewState=idle),(ControlEvent=0,CustomName=Pain,NewState=Pain)),UserAnimName=MG42_Pain,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=idle_01,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(9)=(StateName=Crashing,OutEvents=none,Transitions=((ControlEvent=0,CustomName=StopCrash,NewState=idle),(ControlEvent=0,CustomName=HitRight,NewState=HitRight),(ControlEvent=0,CustomName=HitLeft,NewState=HitLeft)),UserAnimName=MG42_CrashIdle,UserSoundName=None,MyAnim=(Flags=(bLoop=true,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_edf_map08c_wasp_crash_idle,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(10)=(StateName=HitRight,OutEvents=none,Transitions=((ControlEvent=0,CustomName=Crashing,NewState=Crashing),(ControlEvent=0,CustomName=idle,NewState=idle)),UserAnimName=MG42_CrashHitRight,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_edf_map08c_wasp_crash_hit_right_reactions,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    States(11)=(StateName=HitLeft,OutEvents=none,Transitions=((ControlEvent=0,CustomName=Crashing,NewState=Crashing),(ControlEvent=0,CustomName=idle,NewState=idle)),UserAnimName=MG42_CrashHitLeft,UserSoundName=None,MyAnim=(Flags=(bLoop=false,bNoLoopEnd=false,bFade=false,bNoRemove=false,bLoopMovement=false,bInterrupt=false,bEarlyEnd=false,bAdjustStart=false),Animation=a_edf_map08c_wasp_crash_hit_left_reactions,Channel=0,Rate=0,TweenTime=0),MySound=(bAllowRepeats=false,bPlayAsAmbient=false,MixerGroupOverride=None,SimpleSingleSound=none,Sounds=none,SlotPriority=0,VolumePrefab=0,Slots=none,Volume=0,VolumeVariance=0,InnerRadius=0,InnerRadiusVariance=0,Radius=0,RadiusVariance=0,Pitch=0,PitchVariance=0,Flags=(bNoOverride=false,bMenuSound=false,bNoFilter=false,bNoOcclude=false,bNoAIHear=false,bNoScale=false,bSpoken=false,bPlayThroughListener=false,bNoDoppler=false,bDialogSound=false,bNoReverb=false,bEnableVis=false,bSkipFlangePrevention=false,bSkipSoundRadiusTest=false,bIgnoreTimeDilation=false),SoundLocationOverride=(bMakeRelativeForLocalPlayer=false,bMakeAbsoluteForActor=false,OverrideType=0,Location3D=(X=0,Y=0,Z=0),Velocity3D=(X=0,Y=0,Z=0)),Offset=0,Delay=0,SlotIndex=0,ForcedIndex=0,SoundFadeInfo=(FadeInDuration=0,FadeOutStartTime=0,FadeOutDuration=0,FadeInEndCallback=None,FadeOutEndCallback=None),SoundEndCallback=None,PlayedSounds=none,Filters=none),MySoundName=None,SubAnims=none)
    PassedDamageScaleAI=1
    bUseHomePose=false
    InterpolationInTime=0.3
    InterpolationOutTime=0.3
    UsableExits(0)=(bEnabled=true,EnterInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None),ExitInfo=(LocationOffset=(X=0,Y=0,Z=0),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None),ExitEndInfo=(LocationOffset=(X=0,Y=0,Z=0.1),RotationOffset=(Pitch=0,Yaw=0,Roll=0),Animation=None,SoundName=None))
    UserMountPrefab=(bDontActuallyMount=false,bHideable=false,bIndependentRotation=false,bIndependentLocation=false,bMatchParentLocation=false,bMatchParentRotation=false,bSurviveDismount=true,bDontScaleByDrawScale=true,bScaleByDrawScaleNonDefault=false,bTransformDrawScale3DChange=false,bTakeParentTag=false,bTransferToCorpse=false,bDontSetOwner=true,MountParentTag=None,DrawScaleOverride=0,AppendToTag=None,ForceTag=None,ForceEvent=None,MountMeshItem=mount_yaw,MountOrigin=(X=-74.25861,Y=0,Z=-49.31716),MountOriginVariance=(X=0,Y=0,Z=0),MountAngles=(Pitch=0,Yaw=0,Roll=0),MountAnglesVariance=(Pitch=0,Yaw=0,Roll=0),MountType=2,DismountPhysics=0)
    bDisableCrosshairHUD=true
    ViewingAngleThreshold=-2
    bBlockPlayers=true
    bAcceptsProjectors=false
    bAcceptsDecalProjectors=false
    bLowerByCollision=false
    PlacementZOffset=57.233
    CollisionRadius=20
    CollisionHeight=8
    Mesh='c_dnWeapon.Machinegun_wStand'
    Skins(0)='mt_skins8.Machinegun_wStand.machinegunbelt_bs'
}